<?php



class TabelaNumerow extends SortColumns {



    public function __construct()
    {
    
        $this->columns = array(

            'numer' => array(
                'order' => 'asc',
                'label' => 'Numer',
                'slug' => 'numer',
                'sortable' => 'tak'
            ),
            'lart' => array(
                'order' => 'dsc',
                'label' => 'Liczba artykułów',
                'column' => NumerPeer::LICZBAARTYKULOW,
                'slug' => 'lart',
                'sortable' => 'tak'
            ),
            'lstr' => array(
                'order' => 'dsc',
                'label' => 'Liczba stron',
                'column' => NumerPeer::LICZBASTRON,
                'slug' => 'lstr',
                'sortable' => 'tak'
            ),
        );            
        
        $this->setIndex('numer');
    }
    
    public function getCriteria()
    {


        $c = new Criteria();

        switch ($this->columns[$this->index]['slug']) {

        case 'numer':
            if ($this->columns[$this->index]['order'] == 'asc') {
                $c->addAscendingOrderByColumn(RocznikPeer::ROK);
                $c->addAscendingOrderByColumn(NumerPeer::NUMER);

            } else {
                $c->addDescendingOrderByColumn(RocznikPeer::ROK);
                $c->addDescendingOrderByColumn(NumerPeer::NUMER);
            }

            $c->addJoin(NumerPeer::ROCZNIK_ID, RocznikPeer::ROCZNIK_ID);

            break;

        case 'lstr':
            if ($this->columns[$this->index]['order'] == 'asc') {
                $c->addAscendingOrderByColumn($this->columns[$this->index]['column']);
            } else {
                $c->addDescendingOrderByColumn($this->columns[$this->index]['column']);
            }
            break;
            
        case 'lart':
            if ($this->columns[$this->index]['order'] == 'asc') {
                $c->addAscendingOrderByColumn($this->columns[$this->index]['column']);
            } else {
                $c->addDescendingOrderByColumn($this->columns[$this->index]['column']);
            }
            break;

        }


        
        return $c;        
    }
    

}