SET NAMES utf8 COLLATE utf8_polish_ci;

DROP DATABASE IF EXISTS cpp;

CREATE DATABASE cpp DEFAULT CHARACTER SET utf8 COLLATE utf8_polish_ci;

GRANT
    ALL
ON
    cpp.*
TO
    cppadm@localhost
IDENTIFIED BY
    'cpppass';

FLUSH PRIVILEGES;

USE cpp;
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- rozdzial
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rozdzial`;


CREATE TABLE `rozdzial`
(
	`rozdzial_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`ksiazka_id` INTEGER  NOT NULL,
	`tytul` VARCHAR(255),
	`numer` INTEGER,
	PRIMARY KEY (`rozdzial_id`),
	INDEX `FI__02` (`ksiazka_id`),
	CONSTRAINT `Rel_02`
		FOREIGN KEY (`ksiazka_id`)
		REFERENCES `ksiazka` (`ksiazka_id`)
		ON DELETE RESTRICT
)Type=MyISAM;

#-----------------------------------------------------------------------------
#-- zadanie
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `zadanie`;


CREATE TABLE `zadanie`
(
	`zadanie_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rozdzial_id` INTEGER  NOT NULL,
	`numer` INTEGER,
	`tekst` TEXT,
	`rozwiazanie` TEXT,
	PRIMARY KEY (`zadanie_id`),
	INDEX `FI__01` (`rozdzial_id`),
	CONSTRAINT `Rel_01`
		FOREIGN KEY (`rozdzial_id`)
		REFERENCES `rozdzial` (`rozdzial_id`)
		ON DELETE RESTRICT
)Type=MyISAM;

#-----------------------------------------------------------------------------
#-- ksiazka
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `ksiazka`;


CREATE TABLE `ksiazka`
(
	`ksiazka_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255),
	`autor` VARCHAR(255),
	PRIMARY KEY (`ksiazka_id`)
)Type=MyISAM;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 2.11.1
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 16 Maj 2008, 07:51
-- Wersja serwera: 5.0.45
-- Wersja PHP: 5.2.4

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

--
-- Baza danych: `cpp`
--

--
-- Zrzut danych tabeli `ksiazka`
--

INSERT INTO `ksiazka` (`ksiazka_id`, `tytul`, `autor`) VALUES(1, 'Zbiór zadań z C++', 'Włodzimierz Gajda');

--
-- Zrzut danych tabeli `rozdzial`
--

INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(1, 1, 'Podstawy C++. Pierwsze programy w C++', 1);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(2, 1, 'Podstawy C++. Programy do zamiany jednostek', 2);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(3, 1, 'Podstawy C++. Programy wyznaczające pola figur i objętości brył', 3);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(4, 1, 'Podstawy C++. Działania arytmetyczne, wartości funkcji', 4);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(5, 1, 'Instrukcja if w C++', 5);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(6, 1, 'Daty', 6);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(7, 1, 'Pętla for w C++. Rysowanie wzorków', 7);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(8, 1, 'Pętla for w C++. Tablice wartości', 8);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(9, 1, 'Pętla while w C++. Pętla zaporowa', 9);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(10, 1, 'Pętla for w C++. Sumy ciągów liczb.', 10);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(11, 1, 'Pętle for i while w C++. Obliczenia', 11);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(12, 1, 'Pętle for i while w C++. Cyfry liczb', 12);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(13, 1, 'Pętle for i while w C++. Symulacja wykonania pętli', 13);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(14, 1, 'Tablice w C++. Wczytywanie i drukowanie. Dostęp do elementów tablicy', 14);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(15, 1, 'Tablice w C++. Wyszukiwanie w tablicy', 15);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(16, 1, 'Tablice w C++. Przetwarzanie elementów tablicy', 16);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(17, 1, 'Tablice w C++. Przetwarzanie elementów tablicy o zadanych wartościach', 17);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(18, 1, 'Tablice w C++. Przetwarzanie elementów tablicy o zadanych indeksach', 18);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(19, 1, 'Tablice w C++. Zadania różne', 19);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(20, 1, 'Funkcje w C++. Wyznaczanie wartości wyrażeń', 20);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(21, 1, 'Funkcje w C++. Funkcje operujące na tablicach', 21);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(22, 1, 'Funkcje w C++. Iteracja a rekurencja', 22);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(23, 1, 'Funkcje w C++. Operacje na wielomianach', 23);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(24, 1, 'Funkcje w C++. Operacje wejścia-wyjścia', 24);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(25, 1, 'Menu programu', 25);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(26, 1, 'Podstawowe operacje na plikach', 26);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(27, 1, 'Wskaźniki w C++. Wskaźnik do zmiennej zadanego typu', 27);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(28, 1, 'Wskaźniki w C++. Dynamiczna alokacja zmiennej zadanego typu', 28);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(29, 1, 'Wskaźniki w C++. Tablice wskaźników', 29);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(30, 1, 'Wskaźniki w C++. Funkcje zwracające wskaźniki', 30);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(31, 1, 'Wskaźniki w C++. Wymiana wartości zmiennych', 31);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(32, 1, 'Wskaźniki w C++. Funkcje porównujące zmienne przekazywane przez wskaźnik', 32);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(33, 1, 'Wskaźniki w C++. Sortowanie dwóch zmiennych', 33);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(34, 1, 'Wskaźniki w C++. Sortowanie tablicy wskaźników', 34);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(35, 1, 'Sortowanie tablicy struktur', 35);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(36, 1, 'Klasy i obiekty. Klasy bez metod o polach publicznych', 36);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(37, 1, 'Klasy i obiekty. Klasy Metody publiczne', 37);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(38, 1, 'Klasy i obiekty. Klasy z konstruktorem i destruktorem', 38);
INSERT INTO `rozdzial` (`rozdzial_id`, `ksiazka_id`, `tytul`, `numer`) VALUES(39, 1, 'Klasy i obiekty. Funkcje wzorcowe', 39);

--
-- Zrzut danych tabeli `zadanie`
--

INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(1, 1, 1, '<p>\r\nNapisz program <span class="program">WITAJ</span>,\r\ndrukujący na ekranie komunikat <em>Witaj</em>.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  cout << "Witaj";\r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(2, 1, 2, '<p>\r\nNapisz program <span class="program">INICJALY</span>,\r\ndrukujący na ekranie Twoje inicjały. \r\nProgram Leszka Iwańskiego powinien wydrukować na ekranie:\r\n</p>\r\n\r\n<pre>\r\nLL		II\r\nLL		II\r\nLL		II\r\nLL		II\r\nLL		II\r\nLLLLLL		II\r\n</pre>\r\n\r\n', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  cout << "WW       WW       GGGGGGGGG        \\n";\r\n  cout << "WW       WW      GG       GG       \\n";\r\n  cout << "WW       WW      GG       GG       \\n";  \r\n  cout << "WW       WW      GG       GG       \\n";\r\n  cout << "WW  WWW  WW      GG                \\n";  \r\n  cout << "WW WW WW WW      GG     GGGG       \\n";  \r\n  cout << "WWWW   WWWW      GG       GG       \\n";\r\n  cout << "WWW     WWW  ..  GG       GG  ..   \\n";  \r\n  cout << "WW       WW  ..   GGGGGGGGG   ..   \\n";  \r\n  cout <<endl<<endl<<endl<<endl;\r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(3, 1, 3, '<p>\r\nNapisz program <span class="program">GWIAZDA</span>,\r\ndrukujący na ekranie dużą pięcioramienną \r\ngwiazdkę narysowaną z gwiazdek <span class="variable">*</span>.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\ncout << "           *           \\n"\r\n     << "          ***          \\n"\r\n     << "         *****         \\n"\r\n     << "  *******************  \\n"\r\n     << "     **************    \\n"\r\n     << "       **********      \\n"\r\n     << "       ***    ***      \\n"\r\n     << "      **        **     \\n"\r\n     << endl << endl;          \r\n       \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(4, 1, 4, '<p>\r\nNapisz program <span class="program">BANNER</span>,\r\ndrukujący na ekranie napis:\r\n</p>\r\n\r\n\r\n<pre>\r\n#     #                                 \r\n#  #  #     #     #####    ##         # \r\n#  #  #     #       #     #  #        # \r\n#  #  #     #       #    #    #       # \r\n#  #  #     #       #    ######       # \r\n#  #  #     #       #    #    #  #    # \r\n ## ##      #       #    #    #   ####\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(5, 1, 5, '<p>\r\nNapisz program <span class="program">TABELA KURSÓW</span>,\r\ndrukujący na ekranie tabelę kursów EURO.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  cout <<"|-----------|"<<endl\r\n       <<"|EURO|DOLLAR|"<<endl\r\n       <<"|-----------|"<<endl\r\n       <<"|3,94|  3,93|"<<endl    \r\n       <<"|-----------|"<<endl; \r\n  \r\n  cout <<"\\n\\nDNIA: 2002-11-16"<<endl;   \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(6, 2, 1, '<p>\r\nNapisz program \r\n<span class="program">Zamiana cali na centymetry</span>. \r\nProgram powinien pobrać od użytkownika jedną liczbę rzeczywistą \r\noznaczającą długość wyrażoną w calach (np. 1) \r\npo czym wydrukować na ekranie podaną długość po \r\nzmianie jednostki długości na centymetry (np. 2,54). \r\nProgram powinien się ładnie przedstawić tzn. wydrukować \r\nna ekranie czytelne informacje kto i kiedy \r\nprogram napisał. Każda drukowana na ekranie oraz wczytywana z \r\nklawiatury liczba powinna być poprzedzona odpowiednim opisem (np. \r\n<em>PODAJ DŁUGOŚĆ WYRAŻONĄ W CENTYMETRACH DL=</em>).\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  float cale,centymetry;\r\n  \r\n  cout << "Program CALE2CENTYMETRY\\n"\r\n       << "(C)2002 student\\n\\n"\r\n       << "Program przelicza dlugosc wyrazona w calach"\r\n       << " na centymetry.\\n\\n";\r\n  \r\n  cout << "Liczba cali = ";\r\n  cin >> cale; \r\n  \r\n  centymetry = cale * 2.54;\r\n  \r\n  cout << "\\n\\n" << cale << " cali  =  "<<centymetry<< " cm\\n\\n";\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(7, 2, 2, '<p>\r\nNapisz program \r\n<span class="program">Zamiana złotówek na dolary</span>. \r\nProgram ma służyć do przeliczenia kwoty pieniędzy wyrażonej w \r\nzłotówkach na kwotę dolarów. Bieżący kurs dolara znajdziesz w Internecie.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  float zlote,dolary;\r\n  \r\n  cout << "Program KURS WALUT\\n"\r\n       << "(C)2002 student\\n\\n"\r\n       << "Program przelicza kwote"\r\n       << " zadana w dolarach na kwote zadana w zlotych.\\n\\n";\r\n  \r\n  cout << "Kwota w dolarach: ";\r\n  cin >> dolary; \r\n  \r\n  zlote=dolary*4.13;\r\n  \r\n  cout << "\\n\\n" << dolary << " $  =  "<<zlote << " zl\\n\\n";\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(8, 2, 3, '<p>\r\nNapisz program przeliczający temperaturę wyrażoną w stopniach \r\nCelsjusza na temperaturę wyrażoną w skali Fahrenheita.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(9, 2, 4, '<p>\r\nNapisz program przeliczający objętość wyrażoną w litrach na galony.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(10, 2, 5, '<p>\r\nNapisz program przeliczający masę wyrażona w kilogramach na funty.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(11, 3, 1, '<p>\r\nNapisz program <span class="program">Pole trójkąta</span>. \r\nProgram powinien pobrać z klawiatury dwie liczby będące \r\ndługością podstawy i wysokością trójkąta, a \r\nnastępnie wydrukować na ekranie liczbę wyrażającą \r\npole powierzchni danego trójkąta. \r\nProgram powinien być czytelny dla użytkownika \r\n(tzn. powinien przedstawić się oraz każdą \r\nliczbę wczytywaną z klawiatury lub drukowaną na \r\nekranie poprzedzić stosownym komunikatem).\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(12, 3, 2, '<p>\r\nNapisz program <span class="program">Pole kwadratu</span>.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  float a,p;\r\n\r\n  cout  << "\\nProgram POLE KWADRATU\\n"\r\n        << "(C)2002 student\\n\\n";\r\n  cout << "Program oblicza pole powierzchni kwadratu"  \r\n       << " o zadanym boku." << endl << endl;\r\n       \r\n  cout << "Podaj dlugosc boku kwadratu a=";     \r\n  \r\n  cin >> a;\r\n  //obliczenia\r\n  p=a*a;\r\n  \r\n  cout << "\\n\\n\\nPole kwadratu o boku a="\r\n       << a << " wynosi P=" << p << "\\n\\n";\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n  \r\n  \r\n  \r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(13, 3, 3, '<p>\r\nNapisz program <span class="program">Pole koła</span>.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(14, 3, 4, '<p>\r\nNapisz program <span class="program">Pole prostokąta</span>.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(15, 3, 5, '<p>\r\nNapisz program <span class="program">Pole rombu</span>.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(16, 3, 6, '<p>\r\nNapisz program wyznaczający pole powierzchni n-kąta foremnego.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(17, 3, 7, '<p>\r\nNapisz program wyznaczający objętość kuli.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(18, 3, 8, '<p>\r\nNapisz program wyznaczający objętość prostopadłościanu.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(19, 3, 9, '<p>\r\nNapisz program wyznaczający objętość stożka.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(20, 3, 10, '<p>\r\nNapisz program wyznaczający objętość walca.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(21, 4, 1, '<p>\r\nNapisz program <span class="program">SUMA</span>. \r\nProgram ma wczytać z klawiatury dwie liczby, \r\na następnie policzyć ich sumę. \r\nWynik drukujemy na ekranie. \r\nProgram powinien być czytelny tj. \r\npowinien wydrukować wizytówkę, \r\nzaś każdą wczytywaną liczbę i \r\ndrukowany wynik poprzedzić stosownym komunikatem.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  int a,b;\r\n  int c;\r\n\r\n  cout << "Program SUMA" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program oblicza sume dwoch liczb."<< endl << endl;\r\n       \r\n  cout << "a=";\r\n  cin >> a;\r\n  \r\n  cout << "b=";    \r\n  cin >> b;\r\n  \r\n  c=a+b;\r\n  \r\n  cout << endl << endl;\r\n  cout << a << "+" << b << "=" << c;\r\n  cout << "\\n\\n";\r\n  \r\n  \r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(22, 4, 2, '<p>\r\nNapisz program <span class="program">RÓŻNICA</span>. \r\nProgram ma wczytać z klawiatury dwie liczby, \r\na następnie policzyć ich różnicę. \r\nWynik drukujemy na ekranie. \r\nProgram powinien być czytelny tj. \r\npowinien wydrukować wizytówkę, \r\nzaś każdą wczytywaną liczbę i drukowany wynik \r\npoprzedzić stosownym komunikatem.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  int a,b;\r\n  int c;\r\n\r\n  cout << "Program ROZNICA" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program oblicza roznice dwoch liczb."<< endl << endl;\r\n       \r\n  cout << "a=";\r\n  cin >> a;\r\n  \r\n  cout << "b=";    \r\n  cin >> b;\r\n  \r\n  c=a-b;\r\n  \r\n  cout << endl << endl;\r\n  cout << a << "-" << b << "=" << c;\r\n  cout << "\\n\\n";\r\n  \r\n  \r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(23, 4, 3, '<p>\r\nNapisz program <span class="program">ILORAZ</span>. \r\nProgram ma wczytać z klawiatury dwie liczby, \r\na następnie policzyć ich iloraz. \r\nWynik drukujemy na ekranie. \r\nProgram powinien być czytelny tj. powinien wydrukować wizytówkę, \r\nzaś każdą wczytywaną liczbę i drukowany wynik poprzedzić stosownym komunikatem.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  float a,b;\r\n  float c;\r\n\r\n  cout << "Program ILORAZ" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program oblicza iloraz dwoch liczb."<< endl << endl;\r\n       \r\n  cout << "a=";\r\n  cin >> a;\r\n  \r\n  cout << "b=";    \r\n  cin >> b;\r\n  \r\n  c=a/b;\r\n  \r\n  cout << endl << endl;\r\n  cout << a << "/" << b << "=" << c;\r\n  cout << "\\n\\n";\r\n  \r\n  \r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(24, 4, 4, '<p>\r\nNapisz program <span class="program">ILOCZYN</span>. \r\nProgram ma wczytać z klawiatury dwie liczby, \r\na następnie policzyć ich iloczyn. \r\nWynik drukujemy na ekranie. \r\nProgram powinien być czytelny tj. powinien wydrukować \r\nwizytówkę, zaś każdą wczytywaną liczbę i \r\ndrukowany wynik poprzedzić stosownym komunikatem.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  int  a,b,c;\r\n\r\n  cout << "Program ILOCZYN" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program oblicza iloczyn dwoch liczb."<< endl << endl;\r\n       \r\n  cout << "a=";\r\n  cin >> a;\r\n  \r\n  cout << "b=";    \r\n  cin >> b;\r\n  \r\n  c=a*b;\r\n  \r\n  cout << endl << endl;\r\n  cout << a << "*" << b << "=" << c;\r\n  cout << "\\n\\n";\r\n  \r\n  \r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(25, 4, 5, '<p>\r\nNapisz program <span class="program">ILORAZ CAŁKOWITY</span>. \r\nProgram ma wczytać z klawiatury dwie liczby, \r\na następnie policzyć iloraz całkowity tych liczb.\r\n</p>', '#include <iostream>\r\n#include <stdlib.h>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  int a,b;\r\n  int c;\r\n\r\n  cout << "Program ILORAZ CAŁKOWITY" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program oblicza iloraz całkowity dwóch liczb."<< endl << endl;\r\n       \r\n  cout << "a=";\r\n  cin >> a;\r\n  \r\n  cout << "b=";    \r\n  cin >> b;\r\n  \r\n  c=a/b;\r\n  \r\n  cout << endl << endl;\r\n  cout << a << "/" << b << "=" << c;\r\n  cout << "\\n\\n";\r\n  \r\n  \r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(26, 4, 6, '<p>\r\nNapisz program <span class="program">RESZTA Z DZIELENIA</span>. \r\nProgram ma wczytać z klawiatury dwie liczby, \r\na następnie policzyć resztę z dzielenia pierwszej z liczb przez drugą.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  int a,b;\r\n  int c;\r\n\r\n  cout << "Program RESZTA Z DZIELENIA" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program oblicza resztę z dzielenia dwóch liczb."<< endl << endl;\r\n       \r\n  cout << "a=";\r\n  cin >> a;\r\n  \r\n  cout << "b=";    \r\n  cin >> b;\r\n  \r\n  c=a % b;\r\n  \r\n  cout << endl << endl;\r\n  cout << "Reszta z dzielenia "<< a << " przez " << b << " wynosi "\r\n       << c << ".\\n\\n";\r\n  \r\n  \r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(27, 4, 7, '<p>\r\nNapisz program wyznaczający wartość funkcji liniowej \r\n<em>y = 2x + 2</em> w zadanym punkcie.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  float x,wynik;\r\n  cout << "Program FUNKCJA y=2x+2" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program wyznacza wartość funkcji y=2x+2 w zadanym punkcie."<< endl << endl;\r\n       \r\n  cout << "x=";\r\n  cin >> x;\r\n  \r\n  wynik=2*x+2;\r\n  \r\n  \r\n  cout << endl << endl;\r\n  cout << "Wartosc funkcji y=2*x+2 w punkcie x="<< x << " wynosi y="\r\n        << wynik << ".\\n\\n";\r\n  \r\n  \r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(28, 4, 8, '<p>\r\nNapisz program wyznaczający wartość funkcji liniowej \r\n<em>y = ax + b</em> w zadanym punkcie. \r\nWartości współczynników <em>a</em>, \r\n<em>b</em> należy wczytać z klawiatury.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  float a,b,x,wynik;\r\n  cout << "Program FUNKCJA y=ax+b" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program wyznacza wartość funkcji y=ax+b w zadanym punkcie."<< endl << endl;\r\n\r\n  cout << "wspolczynnik a=";\r\n  cin >> a;\r\n  \r\n  cout << "wspolczynnik b=";\r\n  cin >> b;\r\n       \r\n  cout << "x=";\r\n  cin >> x;\r\n  \r\n  wynik=a*x+b;\r\n \r\n  cout << endl << endl;\r\n  cout << "Wartosc funkcji y=" << a << "*x+" << b<< " punkcie x="<< x << " wynosi y="\r\n        << wynik << ".\\n\\n";\r\n  \r\n  \r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(29, 4, 9, '<p>\r\nNapisz program wyznaczający wartość funkcji \r\nkwadratowej <em>y = 2x<sup>2</sup> + 2x – 3</em> w zadanym punkcie.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  float a,b,x,wynik;\r\n  cout << "Program FUNKCJA KWADRATOWA y=2x^2+2x-3" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program wyznacza wartość funkcji kwadratowej "\r\n       << "y=2x^2+2x-3... w zadanym punkcie."<< endl << endl;\r\n\r\n  cout << "x=";\r\n  cin >> x;\r\n  \r\n  wynik=2*x*x+2*x-3;\r\n \r\n  cout << endl << endl;\r\n  cout << "Wartosc funkcji y=2x^2+2x-3 w punkcie x="<< x << " wynosi y="\r\n        << wynik << ".\\n\\n";\r\n  \r\n  \r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(30, 4, 10, '<p>\r\nNapisz program wyznaczający wartość funkcji \r\nkwadratowej <em>y = ax<sup>2</sup> + bx + c</em> w zadanym punkcie. \r\nWartości współczynników \r\n<em>a</em>, \r\n<em>b</em>, \r\n<em>c</em> należy wczytać z klawiatury.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  float a,b,c,x,wynik;\r\n  cout << "Program FUNKCJA KWADRATOWA y=ax^2+bx+c" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program wyznacza wartość funkcji kwadratowej "\r\n       << "y=ax^2+bx+c w zadanym punkcie."<< endl << endl;\r\n\r\n  cout << "x=";\r\n  cin >> x;\r\n  \r\n  cout << "a=";\r\n  cin >> a;\r\n  \r\n  cout << "b=";\r\n  cin >> b;\r\n  \r\n  cout << "c=";\r\n  cin >> c;\r\n  \r\n  \r\n  \r\n  wynik=a*x*x+b*x+c;\r\n \r\n  cout << endl << endl;\r\n  cout << "Wartosc funkcji y="<<a<<"x^2+"<<b<<"x+"<<c<<\r\n          "w punkcie x="<< x << " wynosi y=" <<\r\n          wynik << ".\\n\\n";\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(31, 4, 11, '<p>\r\nNapisz program wyznaczający wartość funkcji \r\nwymiernej <em>y = (x + 2)/(x – 3)</em> w zadanym punkcie.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  float x,wynik;\r\n  cout << "Program FUNKCJA WYMIERNA y=(x+2)/(x-3)" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program wyznacza wartość funkcji wymiernej " \r\n       << "y=(x+2)/(x-3) w zadanym punkcie."<< endl << endl;\r\n\r\n  cout << "x=";\r\n  cin >> x;\r\n  \r\n  wynik=(x+2)/(x-3);\r\n \r\n  cout << endl << endl;\r\n  cout << "Wartosc funkcji y=(x+2)/(x-3) "<<\r\n          "w punkcie x="<< x << " wynosi y=" <<\r\n          wynik << ".\\n\\n";\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(32, 4, 12, '<p>\r\nNapisz program wyznaczający wartość funkcji wymiernej \r\n<em>y = (ax + b)/(cx + d)</em> w zadanym punkcie. \r\nWartości współczynników \r\n<em>a</em>, \r\n<em>b</em>, \r\n<em>c</em>, \r\n<em>d</em> należy wczytać z klawiatury.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n#include <iomanip>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  float a,b,c,d,x,wynik;\r\n  cout << "Program FUNKCJA WYMIERNA" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program wyznacza wartość funkcji wymiernej " \r\n       << "y=(ax+b)/(cx+d) w zadanym punkcie."<< endl << endl;\r\n\r\n  cout << "x=";\r\n  cin >> x;\r\n  \r\n  cout << "a=";\r\n  cin >> a;\r\n  \r\n  cout << "b=";\r\n  cin >> b;\r\n\r\n  cout << "c=";\r\n  cin >> c;\r\n  \r\n  cout << "d=";\r\n  cin >> d;\r\n  \r\n  \r\n  wynik=(a*x+b)/(c*x+d);\r\n \r\n  cout << endl << endl;\r\n  cout << "Wartosc funkcji y=(" << a << "x+" << b << ")/("\r\n       << c << "x+" << d << ") w punkcie x="<< x \r\n       << " wynosi y=" << wynik << ".\\n\\n";\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(33, 5, 1, '<p>\r\nNapisz programy wyznaczające pola figur \r\ngeometrycznych i objętości brył, \r\nktóre nie przyjmują od użytkownika ujemnych \r\nliczb wyrażających długości boków.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  float r,P;\r\n\r\n  cout << "Program oblicza pole kwadratu." << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program oblicza pole kwadratu."\r\n       << "\\nDlugosc promienia musi byc liczba dodatnia."<< endl << endl;\r\n       \r\n  cout << "r=";\r\n  cin >> r;\r\n  \r\n  if (r>0)\r\n    {\r\n      P=3.14*r*r;\r\n      cout << "\\nPole kola o promieniu r="<<r\r\n           << " wynosi P=" << P << ".\\n";\r\n    }\r\n  else\r\n    cout <<"\\nDlugosc promienia musi byc liczba dodatnia!\\n";\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(34, 5, 2, '<p>\r\nNapisz programy wyznaczanie ilorazu dwóch liczb, \r\nwartość funkcji wymiernej w punkcie,  \r\nktóre nie przyjmują od użytkownika niepoprawnych liczb.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  float a,b,wynik;\r\n\r\n  cout << "Program ILORAZ" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program oblicza iloraz dwoch liczb."\r\n       << "\\nDzielnik musi byc rozny od zera!"<< endl << endl;\r\n       \r\n  cout << "a=";\r\n  cin >> a;\r\n  \r\n  cout << "b=";\r\n  cin >> b;\r\n  \r\n  \r\n  if (b!=0)\r\n      cout << "\\n" << a << " / " << b << " = " << a/b << "\\n\\n";\r\n  else\r\n    cout <<"\\nDzielnik musi byc rozny od zera!\\n\\n";\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(35, 5, 3, '<p>\r\nNapisz program obliczający pierwiastek z zadanej liczby. \r\nProgram powinien sprawdzić, \r\nczy pierwiastkowana liczba jest dodatnia. \r\nW przypadku gdy zadana liczba jest ujemna program \r\npowinien wydrukować na ekranie komunikat: \r\n<em>PIERWIASTEK KWADRATOWY Z LICZBY UJEMNEJ NIE ISTNIEJE</em>.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  float x,wynik;\r\n\r\n  cout << "Program PIERWIASTEK" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program oblicza pierwiastek kwadratowy z zadanej liczby."\r\n       << "\\nPodana liczba musi byc dodatnia!"<< endl << endl;\r\n       \r\n  cout << "x=";\r\n  cin >> x;\r\n  \r\n  if (x>=0)\r\n      cout << "\\n pierwiastek kwadtowy z liczby " << x \r\n      << " wynosi " << sqrt(x) << ".\\n\\n";\r\n  else\r\n    cout <<"\\nLiczba nie może być ujemna!\\n\\n";\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(36, 5, 4, '<p>\r\nNapisz program \r\n<em>Czy liczba jest parzysta?</em> \r\npobierający od użytkownika jedną liczbę i \r\ndrukujący na ekranie jedną z \r\ninformacji <em>LICZBA JEST PARZYSTA</em> bądź \r\n<em>LICZBA JEST NIEPARZYSTA</em>.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int a;\r\n\r\n  cout << "Program PARZYSTOSC" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program sprawdza, czy zadana liczba jest parzysta."\r\n       << endl << endl;\r\n       \r\n  cout << "a=";\r\n  cin >> a;\r\n  \r\n  if ((a%2) ==0)\r\n      cout << "\\nLiczba jest parzysta!\\n";\r\n  else\r\n      cout << "\\nLiczba nie jest parzysta!\\n";  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(37, 5, 5, '<p>\r\nNapisz program <span class="program">Czy liczba a jest podzielna przez b?</span> \r\nProgram ma pobrać od użytkownika dwie liczby całkowite \r\n<em>a</em>, <em>b</em>. \r\nJako wynik pracy program ma wydrukować \r\ninformację mówiącą o tym, czy liczba <em>a</em> jest \r\npodzielna przez  liczbę <em>b</em> \r\n(jeden z tekstów <em>A JEST PODZIELNE PRZEZ B</em> lub \r\n<em>A NIE JEST PODZIELNE PRZEZ B</em>).\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int a,b;\r\n\r\n  cout << "Program PODZIELNOSC" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program sprawdza, czy zadana liczba a "\r\n       << "jest podzielna przez liczbe b."\r\n       << endl << endl;\r\n       \r\n  cout << "a=";\r\n  cin >> a;\r\n  \r\n  cout << "b=";\r\n  cin >> b;\r\n  \r\n  \r\n  if ((a%b) ==0)\r\n      cout << "\\nLiczba " << a\r\n           <<" jest podzielna przez liczbę "<< b <<"\\n";\r\n  else\r\n      cout << "\\nLiczba " << a\r\n           <<" nie jest podzielna przez liczbę "<< b <<"\\n";\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(38, 5, 6, '<p>\r\nNapisz program \r\n<span class="program">N-ta potęga</span>, \r\npobierający od użytkownika dwie liczby: <em>x</em> (rzeczywiste) oraz \r\n<em>n</em> (naturalne z zakresu od 2 do 7). \r\nProgram ma drukować na ekranie liczbę <em>x<sup>n</sup></em>. \r\n(program powinien nie powinien stosować funkcji \r\n<span class="variable">power()</span> \r\nnależy użyć zagnieżdżonej instrukcji <span class="variable">if</span>).\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int n;\r\n  float x;\r\n  \r\n\r\n  cout << "Program POTEGA" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program wyznacza 2,3 lub 4-tą potęgę zadanej liczby x."\r\n       << endl << endl;\r\n       \r\n  cout << "Podaj podstawę potęgi x=";\r\n  cin >> x;\r\n  \r\n  cout << "Podaj wykładnik potęgi n=";\r\n  cin >> n;\r\n  \r\n  if (n==2)\r\n      cout << x << "^2 = " << x*x << "\\n";\r\n  else\r\n    if (n==3)\r\n        cout << x << "^3 = " << x*x*x << "\\n";\r\n    else    \r\n      if (n==4)\r\n          cout << x << "^4 = " << x*x*x*x << "\\n";\r\n      else\r\n        cout << "Wykładnik musi być równy 2, 3 lub 4.\\n";   \r\n        \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(39, 5, 7, '<p>\r\nNapisz program, pobierający z klawiatury liczbę \r\ncałkowitą i mówiącą o tym czy jest ona z przedziału <em><a;b></em>.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  float x,a,b;\r\n  \r\n\r\n  cout << "Program PRZEDZIAŁ" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program sprawdza, czy zadana liczba "\r\n       << "należy do przedziału (a;b]." \r\n       << "\\n\\nPrzedział jest prawostronnie domknięty."       \r\n       << endl << endl;\r\n       \r\n  cout << "Podaj liczbę x=";\r\n  cin >> x;\r\n  \r\n  cout << "Podaj lewy koniec przedziału a=";\r\n  cin >> a;\r\n  \r\n  cout << "Podaj prawy koniec przedziału b=";\r\n  cin >> b;\r\n  \r\n  cout  << "\\n\\n\\n\\n";\r\n  \r\n  if ((x>a) && (x<=b))\r\n      cout << x << "  należy do przedziału (" \r\n           << a << ":" << b << "]\\n\\n";\r\n      \r\n  else\r\n      cout << x << "  nie należy do przedziału (" \r\n           << a << ":" << b << "]\\n\\n";\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(40, 5, 8, '<p>\r\nNapisz program <span class="program">MAX 2</span>, \r\npobierający od użytkownika dwie liczby i drukujący na ekranie większą z nich.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  float l1,l2;\r\n  \r\n\r\n  cout << "Program MAX 2" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program znajduje największą spośród dwóch liczb"\r\n       << endl << endl;\r\n       \r\n  cout << "Podaj piewrszą liczbę = ";\r\n  cin >> l1;\r\n  \r\n  cout << "Podaj drugą liczbę = ";\r\n  cin >> l2;\r\n  \r\n  cout  << "\\n\\n\\nNajwiększą liczbą jest liczba ";\r\n  \r\n  if (l1<l2)\r\n      cout << l2;\r\n  else\r\n      cout << l1;  \r\n      \r\n  cout  << "\\n\\n\\n";      \r\n      \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(41, 5, 9, '<p>\r\nNapisz programy <span class="program">MAX 3</span>, \r\n<span class="program">MAX 4</span>, \r\n<span class="program">MAX 5</span>.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  float a,b,c,wieksza,najwieksza;\r\n\r\n  cout << "Program MAX 3" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program znajduje największą spośród trzech liczb"\r\n       << endl << endl;\r\n       \r\n  cout << "Podaj piewrszą liczbę = ";\r\n  cin >> a;\r\n  \r\n  cout << "Podaj drugą liczbę = ";\r\n  cin >> b;\r\n  \r\n  cout << "Podaj trzecią liczbę = ";\r\n  cin >> c;\r\n  \r\n  if (a>b)\r\n    wieksza=a;\r\n  else\r\n    wieksza=b;\r\n    \r\n  if (c>wieksza)\r\n    najwieksza=c;\r\n  else\r\n    najwieksza=wieksza;\r\n    \r\n  cout << "\\n\\nNajwiększą liczbą jest liczba " \r\n       << najwieksza << "\\n\\n";  \r\n       \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(42, 5, 10, '<p>\r\nNapisz program wymieniający wartość dwóch zmiennych.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int a,b,rob;\r\n  \r\n  cout << "Program WYMIANA WARTOŚCI ZMIENNYCH" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program wymienia wartości zmiennych a i b."\r\n       << endl << endl;\r\n       \r\n  cout << "Podaj piewrszą liczbę = ";\r\n  cin >> a;\r\n  \r\n  cout << "Podaj drugą liczbę = ";\r\n  cin >> b;\r\n\r\n\r\n  //przed wymianą\r\n  cout << endl << "===================="  << endl \r\n       <<  "PRZED WYMIANĄ" << endl\r\n       <<  "a = "   << a << endl\r\n       <<  "b = "   << b\r\n       << endl << "===================="  << endl << endl; \r\n\r\n              \r\n  //teraz wymieniamy wartości\r\n    rob=a;\r\n    a=b;\r\n    b=rob;  \r\n  \r\n  //po wymianie \r\n  cout << endl << "===================="  << endl \r\n       <<  "PO WYMIANIE" << endl\r\n       <<  "a = "   << a << endl\r\n       <<  "b = "   << b\r\n       << endl << "===================="  << endl << endl; \r\n\r\n      \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(43, 5, 11, '<p>\r\nNapisz program \r\n<span class="program">SORT 2</span>, \r\npobierający od użytkownika dwie liczby i \r\ndrukujący na ekranie obie liczby w porządku rosnącym.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int a,b,rob;\r\n  \r\n  cout << "Program SORT2" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program sortuje rosnąco dwie liczby."\r\n       << endl << endl;\r\n       \r\n  cout << "Podaj piewrszą liczbę = ";\r\n  cin >> a;\r\n  \r\n  cout << "Podaj drugą liczbę = ";\r\n  cin >> b;\r\n\r\n\r\n  if (a>b)\r\n    {\r\n      rob=a;\r\n      a=b;\r\n      b=rob;  \r\n    }  \r\n  \r\n\r\n  cout << endl << "===================="  << endl \r\n       <<  "a = "   << a << endl\r\n       <<  "b = "   << b\r\n       << endl << "===================="  << endl << endl; \r\n\r\n      \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(44, 5, 12, '<p>\r\nNapisz programy <span class="program">SORT 3</span>, \r\n<span class="program">SORT 4</span>.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int a,b,c,rob;\r\n  \r\n  cout << "Program SORT3" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program sortuje malejąco trzy liczby."\r\n       << endl << endl;\r\n       \r\n  cout << "Podaj piewrszą liczbę = ";\r\n  cin >> a;\r\n  \r\n  cout << "Podaj drugą liczbę = ";\r\n  cin >> b;\r\n  \r\n  cout << "Podaj trzecią liczbę = ";\r\n  cin >> c;\r\n\r\n\r\n  //chcemy by a było większe od b\r\n  if (a<b)\r\n    {\r\n      rob=a;\r\n      a=b;\r\n      b=rob;  \r\n    }  \r\n  //teraz wiemy, że \r\n  //                a > b  \r\n  \r\n  if (c>a)\r\n    {\r\n      //wymiana cykliczna trzech zmiennych\r\n      rob=c;\r\n      c=b;\r\n      b=a;  \r\n      a=rob;\r\n    }  \r\n  else\r\n    if (c>b)\r\n      {\r\n        rob=b;\r\n        b=c;\r\n        c=rob;  \r\n      }  \r\n    \r\n      \r\n  cout << endl << "===================="  << endl \r\n       <<  "a = "   << a << endl\r\n       <<  "b = "   << b << endl       \r\n       <<  "c = "   << c\r\n       << endl << "===================="  << endl << endl; \r\n\r\n      \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(45, 5, 13, '<p>\r\nNapisać program rozwiązujący metodą wyznaczników \r\nukład dwóch równań z dwiema niewiadomymi. \r\nZwrócić uwagę na przypadki, \r\nkiedy układ jest sprzeczny lub nieoznaczony. \r\nDanymi pobieranymi od użytkownika jest sześć liczb \r\nreprezentujących równania <em>ax+by=c</em>, <em>dx+ey=f</em>.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  float a,b,c;\r\n  float d,e,f;\r\n  float W,Wx,Wy;\r\n  float x,y;\r\n  \r\n  cout << "Program UKŁAD RÓWNAŃ" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program rozwiązuje układ "\r\n       << "dwóch równań z dwiema niewaidomymi."\r\n       << endl << endl;\r\n       \r\n  cout << "\\nWczytywanie pierwszego równania  ax+by=c" << endl;\r\n  cout << "a = ";  \r\n  cin >> a;\r\n  cout << "b = ";  \r\n  cin >> b;\r\n  cout << "c = ";  \r\n  cin >> c;\r\n  \r\n  cout << "\\nWczytywanie drugiego równania  dx+ey=f" << endl;\r\n  cout << "d = ";  \r\n  cin >> d;\r\n  cout << "e = ";  \r\n  cin >> e;\r\n  cout << "f = ";  \r\n  cin >> f;\r\n  \r\n  //W  = |a b|\r\n  //     |d e|\r\n  \r\n  //Wx = |c b|\r\n  //     |f e|\r\n  \r\n  //Wy = |a c|\r\n  //     |d f|\r\n  \r\n  \r\n  W  = a*e-d*b;\r\n  Wx = c*e-b*f;\r\n  Wy = a*f-c*d;\r\n \r\n  if (W==0)\r\n    {\r\n      if ((Wx==0) && (Wy==0))      \r\n          cout << "\\nUkład jest nieoznaczony.\\n";        \r\n      else\r\n          cout << "\\nUkład jest sprzeczny.\\n";                \r\n    }\r\n  else\r\n    {\r\n      x=Wx/W;\r\n      y=Wy/W;      \r\n      \r\n      cout << "Rozwiązaniem układu są liczby:\\n"\r\n           << "  x = " << x \r\n           << "  y = " << y            \r\n           << endl << endl;\r\n    }  \r\n\r\n      \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(46, 5, 14, '<p>\r\nW poprzednim programie przed rozwiązaniem układu \r\nwydrukować na ekranie postać układu. \r\nDla przykładu, dla liczb <em>a=2</em>, \r\n<em>b=-1</em>, \r\n<em>c=-1</em>, \r\n<em>d=0</em>, \r\n<em>e=-5</em>, \r\n<em>f=1</em> powinniśmy wydrukować równania \r\n<em>2x-y=-1</em> oraz <em>-5y=1</em>\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n#include <conio.h>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  float a,b,c;\r\n  float d,e,f;\r\n  float W,Wx,Wy;\r\n  float x,y;\r\n  \r\n  cout << "Program RÓWNANIE" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program drukuje równanie ax+by=c w ładnej postaci."\r\n       << endl << endl;\r\n       \r\n  cout << "\\nWczytywanie równania  ax+by=c" << endl;\r\n  cout << "a = ";  \r\n  cin >> a;\r\n  cout << "b = ";  \r\n  cin >> b;\r\n  cout << "c = ";  \r\n  cin >> c;\r\n  \r\n  cout << "\\n\\n\\n";\r\n  if (a!=0) \r\n    if (a==1)\r\n      cout << "x ";\r\n    else  \r\n      cout << a << "x ";    \r\n  \r\n  if (b<0)\r\n    if (b==-1)\r\n        cout << "-y ";      \r\n    else  \r\n        cout << b << "y ";\r\n  else\r\n    if (b>0)\r\n        cout << "+" << b << "y " ;\r\n        \r\n  cout << " = " << c << "\\n\\n"; \r\n      \r\n      \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(47, 6, 1, '<p>\r\nNapisz program sprawdzający czy podana \r\nz klawiatury liczba stanowi poprawny numer miesiąca.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(48, 6, 2, '<p>\r\nNapisz program <span class="program">Rok przestępny</span>. \r\nProgram pobiera z klawiatury numer roku \r\ni drukuje na ekranie informacje <em>ROK JEST PRZESTĘPNY</em> lub \r\n<em>ROK NIE JEST PRZESTĘPNY</em>.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int rok;\r\n\r\n  cout << "Program ROK PRZESTĘPNY" << endl \r\n       << "(C)2002 student" << endl << endl \r\n       << "Program podaje czy rok jest przestępny"               \r\n       << endl << endl;\r\n       \r\n  cout << "rok = ";\r\n  cin >> rok;\r\n  \r\n  if ((rok % 4==0) && ((rok%100!=0)||(rok%400==0 )))\r\n      cout << "Rok przestępny\\n\\n";\r\n  else\r\n    cout <<"to nie jest rok przestępny\\n\\n";\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(49, 6, 3, '<p>\r\nNapisz program <span class="program">Ile zadany miesiąc ma dni?</span>. \r\nDanymi programu są dwie liczby: numer roku i numer miesiąca.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(50, 6, 4, '<p>\r\nNapisz program <span class="program">Czy data jest poprawna?</span> \r\nProgram pobiera z klawiatury trzy liczby \r\ncałkowite oznaczające numer dnia, miesiąca i roku. \r\nJako wynik działania programu na ekranie winien \r\nsię pojawić komunikat <em>DATA JEST POPRAWNA</em> \r\nlub\r\n<em>DATA JEST NIEPOPRAWNA</em>. \r\nPodana data jest poprawna wtedy i tylko \r\nwtedy gdy podany dzień a prawdę można znaleźć \r\nw kalendarzu! \r\nDaty 1.01.1999 23.07.1934 2.02.2004 są poprawne \r\nzaś daty 34.01.1999, -2,100.90, 31.021999, 29.02.1999 \r\n(rok 1999 nie jest przestępny!) są niepoprawne.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(51, 6, 5, '<p>\r\nNapisać program <span class="program">Ile dni minęło od początku roku?</span> \r\nodpowiadający na pytanie ile dni minęło pomiędzy zadaną \r\ndatą a dniem 1 styczna zadanego roku. \r\nProgram pobiera od użytkownika trzy liczby całkowite \r\nreprezentujących poprawną datę.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(52, 6, 6, '<p>\r\nNapisz program <span class="program">Ile dni minęło od dnia do dnia?</span> \r\nodpowiadający na pytanie ile dni minęło pomiędzy \r\ndwiema zadanymi datami. \r\nProgram pobiera od użytkownika sześć liczb \r\ncałkowitych reprezentujących dwie poprawne daty.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(53, 6, 7, '<p>\r\nNapisz program <span class="program">Jaki to dzień tygodnia?</span>, \r\npobierający z klawiatury trzy liczby całkowite \r\nokreślające datę i drukujący na ekranie informację \r\no tym jaki to był  (jest lub będzie) dzień tygodnia. \r\nNa przykład dla danych 26.20.1999 powinniśmy na \r\nekranie zobaczyć komunikat <em>WTOREK</em>.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(54, 7, 1, '<p>\r\nNapisz program drukujący na ekranie 19 gwiazdek:\r\n</p>\r\n\r\n\r\n<pre>\r\n*******************\r\n</pre>\r\n', '#include <iostream>\r\n#include <cstdlib>\r\n\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int i;\r\n  \r\n  for (i=0;i<19;i++) \r\n    cout << "*";\r\n    \r\n  cout << endl;\r\n      \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(55, 7, 2, '<p>\r\nNapisz program drukujący na ekranie wieżę z literek O:\r\n</p>\r\n\r\n\r\n<pre>\r\nO\r\nOO\r\nOOO\r\nOOOO\r\nOOOOO\r\n</pre>\r\n', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  int i,j;\r\n  \r\n \r\n  for (i=0;i<5;i++) \r\n    {\r\n      for (j=0;j<=i;j++)     \r\n        cout << "X";\r\n      cout << endl;  \r\n    }\r\n\r\n    \r\n  cout << endl;\r\n      \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(56, 7, 3, '<p>\r\nNapisz program,\r\ndrukujący na ekranie prostokąt z literek X. \r\nWysokość i szerokość prostokąta wczytujemy z klawiatury:\r\n</p>\r\n\r\n\r\n<pre>\r\nXXXXXXXXXX\r\nX        X\r\nX        X\r\nXXXXXXXXXX\r\n</pre>\r\n\r\n', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n\r\n  int i,j;\r\n  int szerokosc,wysokosc;\r\n  \r\n  cout << "SZEROKOSC=";\r\n  cin >> szerokosc;\r\n  \r\n  cout << "WYSOKOSC=";\r\n  cin >> wysokosc;\r\n  \r\n  cout << endl;  \r\n\r\n  for (i=0;i<szerokosc;i++) \r\n     cout << "X";  \r\n  cout << endl;\r\n  \r\n  for (j=0;j<wysokosc-2;j++) \r\n    {\r\n       cout << "X";  \r\n       for (i=0;i<szerokosc-2;i++) \r\n          cout << " ";  \r\n       \r\n       cout << "X";         \r\n       cout << endl;    \r\n    }\r\n\r\n  for (i=0;i<szerokosc;i++) \r\n     cout << "X";  \r\n  cout << endl;\r\n  \r\n    \r\n     \r\n  cout << endl;       \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(57, 7, 4, '<p>\r\nNapisz program, drukujący na ekranie literę A złożoną z literek A. \r\nWielkość litery A wczytujemy z klawiatury.\r\n</p>\r\n\r\n\r\n\r\n<pre>\r\n     A\r\n    A A\r\n   A   A\r\n  AAAAAAA\r\n A       A\r\nA         A\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(58, 7, 5, '<p>\r\nNapisz program, drukujący na ekranie literę L złożoną z literek L. \r\nWielkość litery L (jej szerokość, wysokość i grubość) \r\nwczytujemy z klawiatury.  \r\nPrzykładowa litera ma wymiary: grubość=4, wys=11, szer=8.\r\n</p>\r\n\r\n\r\n<pre>\r\nLLLL\r\nLLLL\r\nLLLL\r\nLLLL\r\nLLLL\r\nLLLL\r\nLLLL\r\nLLLLLLLL\r\nLLLLLLLL\r\nLLLLLLLL\r\nLLLLLLLL\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(59, 7, 6, '<p>\r\nNapisz program drukujący na ekranie prostokąt z literek X. \r\nWysokość i szerokość prostokąta wczytujemy z klawiatury. \r\nPoniższy prostokąt ma wymiary: szer=10, wys=4.\r\n</p>\r\n\r\n\r\n<pre>\r\nXXXXXXXXXX\r\nXXXXXXXXXX\r\nXXXXXXXXXX\r\nXXXXXXXXXX\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(60, 7, 7, '<p>\r\nNapisz program drukujący na ekranie trójkąt. \r\nWysokość trójkąta wczytujemy z klawiatury. \r\nPoniższy trójkąt ma wysokość wys=5.\r\n</p>\r\n\r\n\r\n<pre>\r\n    X \r\n   XXX \r\n  XXXXX\r\n XXXXXXX\r\nXXXXXXXXX\r\n</pre>\r\n\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(61, 7, 8, '<p>\r\nNapisz program drukujący na ekranie trójkąt. \r\nWysokość trójkąta wczytujemy z klawiatury. \r\nPoniższy trójkąt ma wysokość wys=5.\r\n</p>\r\n\r\n\r\n\r\n<pre>\r\n    X \r\n   X X \r\n  X   X\r\n X     X\r\nXXXXXXXXX\r\n</pre>\r\n\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(62, 7, 9, '<p>\r\nNapisz program drukujący na ekranie trójkąt. \r\nWysokość trójkąta wczytujemy z klawiatury. \r\nPoniższy trójkąt ma wysokość wys=5.\r\n</p>\r\n\r\n\r\n<pre>\r\nX \r\nXX \r\nXXX\r\nXXXX\r\nXXXXX\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(63, 7, 10, '<p>\r\nNapisz program drukujący na ekranie trójkąt. \r\nWysokość trójkąta wczytujemy z klawiatury. \r\nPoniższy trójkąt ma wysokość wys=5.\r\n</p>\r\n\r\n\r\n<pre>\r\nX \r\nXX \r\nX X\r\nX  X\r\nXXXXX\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(64, 7, 11, '<p>\r\nNapisz program drukujący na ekranie trójkąt. \r\nWysokość trójkąta wczytujemy z klawiatury. Poniższy trójkąt ma wysokość wys=5.\r\n</p>\r\n\r\n\r\n<pre>\r\n    X \r\n   XX \r\n  XXX\r\n XXXX\r\nXXXXX\r\n</pre>\r\n\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(65, 7, 12, '<p>\r\nNapisz program drukujący na ekranie trójkąt. \r\nWysokość trójkąta wczytujemy z klawiatury. \r\nPoniższy trójkąt ma wysokość wys=5.\r\n</p>\r\n\r\n\r\n<pre>\r\n    X \r\n   XX \r\n  X X\r\n X  X\r\nXXXXX\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(66, 7, 13, '<p>\r\nNapisz program drukujący na ekranie krzyż. \r\nWysokość krzyżyka wczytujemy z klawiatury. Poniższy krzyż ma wysokość wys=3.\r\n</p>\r\n\r\n\r\n<pre>\r\n    #\r\n    #\r\n    # \r\n #######\r\n    #\r\n    #\r\n    #\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(67, 7, 14, '<p>\r\nNapisz program drukujący na ekranie kwadrat. \r\nDługość boku kwadratu wczytujemy z klawiatury. \r\nPoniższy kwadrat ma bak długości 4.\r\n</p>\r\n\r\n\r\n<pre>\r\nKKKK\r\nKKKK\r\nKKKK\r\nKKKK\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(68, 7, 15, '<p>\r\nNapisz program drukujący na ekranie liczby. \r\nWysokość wczytujemy z klawiatury. Oto wydruk dla wysokości h =5: \r\n</p>\r\n\r\n\r\n<pre>\r\n1\r\n1 2\r\n1 2 3\r\n1 2 3 4\r\n1 2 3 4 5\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(69, 7, 16, '<p>\r\nNapisz program drukujący na ekranie liczby. \r\nWysokość wczytujemy z klawiatury. Oto wydruk dla wysokości h=5: \r\n</p>\r\n\r\n\r\n<pre>\r\n1\r\n2 4\r\n3 6 9\r\n4 8 12 14\r\n5 10 15 20 25\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(70, 7, 17, '<p>\r\nNapisz program drukujący na ekranie liczby. \r\nWysokość wczytujemy z klawiatury. Oto wydruk dla wysokości h=5: \r\n</p>\r\n\r\n\r\n<pre>\r\n0\r\n3 6\r\n6 9 12\r\n9 12 15 18\r\n12 15 18 21 24\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(71, 7, 18, '<p>\r\nNapisz program drukujący na ekranie liczby. \r\nWysokość wczytujemy z klawiatury. \r\nOto wydruk dla wysokości h=5: \r\n</p>\r\n\r\n\r\n<pre>\r\n2,\r\n4,5,\r\n8,9,10,\r\n16,17,18,19,\r\n32,33,34,35,36,\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(72, 8, 1, '<p>\r\nNapisz program drukujący na ekranie tabliczkę mnożenia do 5:\r\n</p>\r\n\r\n\r\n\r\n<pre>\r\n  | 1   2   3   4   5\r\n======================\r\n1 | 1   2   3   4   5\r\n2 | 2   4   6   8  10\r\n3 | 3   6   9  12  15\r\n4 | 4   8  12  14  20\r\n5 | 5  10  15  20  25\r\n</pre>\r\n', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int i,j;\r\n\r\n\r\n  cout << " |";\r\n  for (i=1;i<=5;i++) \r\n     cout << "  " << i;  \r\n     \r\n  cout << endl;   \r\n  \r\n  for (i=0;i<5*3+2;i++) \r\n     cout << "=";  \r\n     \r\n  cout << endl;        \r\n  \r\n  \r\n  \r\n  \r\n  \r\n  for (i=1;i<=5;i++) \r\n    {\r\n      cout << i <<"|";\r\n      for (j=1;j<=5;j++) \r\n        {\r\n          cout << " ";\r\n          if (i*j<10)\r\n            cout << " ";\r\n          cout << i*j;  \r\n        }\r\n      cout << endl;  \r\n    }\r\n    \r\n  cout << endl;\r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(73, 8, 2, '<p>\r\nNapisz program drukujący na ekranie potęgi liczby 2 (od potęgi 0 do potęgi 8).\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n#include <cmath>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int i,j;\r\n  \r\n  for (i=0;i<=8;i++)\r\n    cout << "2^" << i << "=" << pow(2,i) << endl;\r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(74, 8, 3, '<p>\r\nNapisz program, drukujący na ekranie wartości \r\nlogarytmu dziesiętnego dla liczb 1/10, 2/10,...,9/10.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n#include <cmath>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  float i;\r\n  \r\n  for (i=0.1;i<1;i+=0.1)\r\n    cout << "log10(" << i << ")=" << log10(i) << endl;\r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(75, 9, 1, '<p>\r\nNapisz program wczytujący z klawiatury liczbę całkowitą. \r\nProgram powinien przyjmować jedynie liczbę dodatnią. \r\nJeśli użytkownik poda liczbę ujemną, \r\nto powinien zostać poinformowany, \r\nże wymagana jest liczba dodatnia i poproszony o kolejną liczbę. \r\nPróbę wczytywania liczby powtarzamy dopóty, \r\ndopóki użytkownik nie poda liczby poprawnej (dodatniej). \r\nTaki sposób zapewnienia poprawności wczytywanych danych nazywać będziemy pętlą zaporową.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int l;\r\n  \r\n  \r\n  cout << "Program demonstruje użycie pętli zaporowej.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "Podaj liczbę dodatnią l=";\r\n  cin >> l;\r\n  \r\n  while (l<=0)\r\n    {\r\n      cout << "Podałeś liczbę ujemną!\\n\\nPodaj liczbę dodatnią l=";\r\n      cin >> l;\r\n    }\r\n    \r\n  cout << "\\n\\n";\r\n  cout << "====================\\n";\r\n  cout << "Liczba dodatnia wynosi:" << l << endl << endl;\r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(76, 9, 2, '<p>\r\nWykorzystując pętlę zaporową napisz program, \r\nwyznaczający pole dowolnej figury. \r\nProgram jako dane (długości boków figury) \r\npowinien przyjmować wyłącznie liczby dodatnie.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  float  podstawa,wysokosc,pole;\r\n  \r\n  \r\n  cout << "Program oblicza pole równoległoboku.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "Podaj długość podstawy równoległoboku a=";\r\n  cin  >> podstawa;\r\n  \r\n  cout << "Podaj długość wysokości równoległoboku h=";\r\n  cin  >> wysokosc;\r\n  \r\n  while ((podstawa<=0) || (wysokosc<=0))\r\n    {\r\n      cout << "Długości boków muszą być większe od zera!\\n\\n";\r\n      cout << "Podaj długość podstawy równoległoboku a=";\r\n      cin  >>  podstawa;\r\n  \r\n      cout << "Podaj długość wysokości równoległoboku h=";\r\n      cin  >> wysokosc;\r\n    }\r\n    \r\n  pole=wysokosc * podstawa;  \r\n    \r\n\r\n  cout << "\\n\\nPole równoloegłoboku o podstawie a=" << podstawa \r\n       << " i wysokości h=" << wysokosc << " wynosi P=" << pole << endl << endl;\r\n\r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(77, 9, 3, '<p>\r\nWykorzystując pętlę zaporową napisz program, \r\nwyznaczający objętość dowolnej bryły. \r\nProgram jako dane (długości boków bryły) \r\npowinien przyjmować wyłącznie liczby dodatnie.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  float  podstawa,wysokosc,objetosc;\r\n  \r\n  \r\n  cout << "Program oblicza objętość ostrosłupa o podstawie kwadratu.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "Podaj długość podstawy a=";\r\n  cin  >> podstawa;\r\n  \r\n  cout << "Podaj długość wysokości h=";\r\n  cin  >> wysokosc;\r\n  \r\n  while ((podstawa<=0) || (wysokosc<=0))\r\n    {\r\n      cout << "Długości odcinków muszą być większe od zera!\\n\\n";\r\n      cout << "Podaj długość podstawy a=";\r\n      cin  >> podstawa;\r\n  \r\n      cout << "Podaj długość wysokości h=";\r\n       cin  >> wysokosc;\r\n\r\n    }\r\n    \r\n  objetosc =wysokosc * podstawa * podstawa / 3;  \r\n    \r\n\r\n  cout << "\\n\\nObjętość ostrosłupa o podstawie a=" << podstawa \r\n       << " i wysokości h=" << wysokosc << " wynosi V=" << objetosc << endl << endl;\r\n\r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(78, 10, 1, '<p>\r\nNapisz program wyznaczający sumę \r\n<em>n</em> początkowych liczb parzystych.  \r\nLiczbę <em>n</em> należy pobrać od użytkownika.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  float  n,suma,i;\r\n  \r\n  \r\n  cout << "Program oblicza sumę początkowych liczb parzystych.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "Podaj liczbę liczb n=";\r\n  cin  >> n;\r\n  \r\n  suma=0;\r\n  for (i=0;i<n;i++)\r\n    suma+=2*i;\r\n  \r\n  cout << "\\n\\nSuma " << n << " początkowych liczb parzystych wynosi " << suma << endl << endl;\r\n\r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(79, 10, 2, '<p>\r\nNapisz program wyznaczający sumę \r\n<em>n</em> początkowych liczb nieparzystych. \r\nLiczbę <em>n</em> należy pobrać od użytkownika.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  float  n,suma,i,x;\r\n  \r\n  \r\n  cout << "Program oblicza sumę początkowych liczb nieparzystych.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "Podaj liczbę liczb n=";\r\n  cin  >> n;\r\n  \r\n  suma=0;\r\n  x=-1;\r\n    \r\n  for (i=0;i<n;i++)\r\n    {\r\n      x+=2;\r\n      suma+=x;\r\n    }  \r\n  \r\n  cout << "\\n\\nSuma " << n << " początkowych liczb nieparzystych wynosi " << suma << endl << endl;\r\n\r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(80, 10, 3, '<p>\r\nNapisz program wyznaczający sumę \r\n<em>n</em> początkowych liczb nieparzystych. \r\nLiczbę <em>n</em> należy pobrać od użytkownika.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(81, 10, 4, '<p>\r\nNapisz program wyznaczający sumę \r\n<em>n</em> początkowych liczb podzielnych przez 7. \r\nLiczbę <em>n</em> należy pobrać od użytkownika.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int n,suma,x,ile;\r\n  \r\n  \r\n  cout << "Program oblicza sumę początkowych liczb podzielnych przez 7.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "Podaj liczbę liczb n=";\r\n  cin  >> n;\r\n  \r\n  suma=0;\r\n  x=0;\r\n  ile=0;\r\n    \r\n  while  (ile<n)\r\n    {\r\n      if  ((x % 7) ==0)\r\n        {\r\n          ile++;\r\n          suma+=x;\r\n        }\r\n      x++; \r\n    }\r\n  \r\n  cout << "\\n\\nSuma " << n << " początkowych liczb podzielnych przez 7 wynosi " \r\n       << suma << endl << endl;\r\n\r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(82, 10, 5, '<p>\r\nNapisz program wyznaczający sumę \r\n<em>n</em> początkowych liczb kończących się cyfrą 1, 2 lub 7. \r\nLiczbę <em>n</em> należy pobrać od użytkownika.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int n,suma,x,ile;\r\n  \r\n  \r\n  cout << "Program oblicza sumę n początkowych liczb kończących się cyfrą 1, 2 lub 7.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "Podaj liczbę liczb n=";\r\n  cin  >> n;\r\n  \r\n  suma=0;\r\n  x=0;\r\n  ile=0;\r\n    \r\n  while  (ile<n)\r\n    {\r\n      if  ( ((x % 10) == 1) ||  ((x % 10) == 2) || ((x % 10) == 7))\r\n        {\r\n          ile++;\r\n          suma+=x;\r\n        }\r\n      x++; \r\n    }\r\n  \r\n  cout << "\\n\\nSuma " << n << \r\n          " początkowych liczb kończących się cyfrą 1, 2 lub 7 wynosi " <<\r\n          suma << endl << endl;\r\n\r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(83, 10, 6, '<p>\r\nNapisz program wyznaczający sumę \r\n<em>n</em> początkowych liczb kończących się liczbą 31, 62 lub 17. \r\nLiczbę <em>n</em> należy pobrać od użytkownika.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int n,suma,x,ile;\r\n  \r\n  \r\n  cout << "Program oblicza sumę n początkowych liczb kończących się liczbą 31, 62 lub 17.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "Podaj liczbę liczb n=";\r\n  cin  >> n;\r\n  \r\n  suma=0;\r\n  x=0;\r\n  ile=0;\r\n    \r\n  while  (ile<n)\r\n    {\r\n      if  ( ((x % 100) == 31) ||  ((x % 100) == 62) || ((x % 100) == 17))\r\n        {\r\n          ile++;\r\n          suma+=x;\r\n        }\r\n      x++; \r\n    }\r\n  \r\n  cout << "\\n\\nSuma " << n << \r\n          " początkowych liczb kończących się liczbą 31, 62 lub 17 wynosi " <<\r\n          suma << endl << endl;\r\n\r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(84, 10, 7, '<p>\r\nNapisz program wyznaczający sumę \r\n<em>n</em> początkowych liczb, \r\nktórych suma cyfr wynosi 100. \r\nLiczbę <em>n</em> należy pobrać od użytkownika.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(85, 10, 8, '<p>\r\nNapisz program wyznaczający sumę \r\n<em>n</em> początkowych liczb, \r\nktórych suma cyfr jest liczbą parzystą. \r\nLiczbę <em>n</em> należy pobrać od użytkownika.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(86, 10, 9, '<p>\r\nNapisz program wyznaczający sumę \r\n<em>n</em> początkowych liczb, \r\nktórych suma cyfr jest liczbą pierwszą. \r\nLiczbę <em>n</em> należy pobrać od użytkownika.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(87, 10, 10, '<p>\r\nNapisz program wyznaczający sumę \r\n<em>n</em> początkowych liczb pierwszych.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(88, 11, 1, '<p>\r\nNapisz program wyznaczający \r\nn-tą potęgę liczby \r\n<em>x</em>. Liczby \r\n<em>n</em> oraz \r\n<em>x</em> należy pobrać od użytkownika.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int n,i;\r\n  float x,wynik;\r\n  \r\n  \r\n  cout << "Program oblicza potęgę naturalną zadanej liczby.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "Podaj wykłądnik potęgi n=";\r\n  cin  >> n;\r\n  \r\n  cout << "Podaj podstawę potęgi x=";\r\n  cin  >> x;\r\n  \r\n  wynik=1;\r\n  for (i=0;i<n;i++)\r\n    wynik=wynik*x;\r\n    \r\n  cout << "\\n\\n" << x << "^" << n << " = " << wynik << endl << endl;\r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(89, 11, 2, '<p>\r\nNapisz program wyznaczający wartość \r\n<em>n!</em> (n silnia) zadanej liczby <em>n</em>. \r\nLiczbę <em>n</em> należy pobrać od użytkownika.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int n,i,silnia;\r\n  \r\n  cout << "Program oblicza n!.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "Podaj n=";\r\n  cin  >> n;\r\n  \r\n \r\n  silnia=1;\r\n  for (i=1;i<=n;i++)\r\n    silnia=silnia*i;\r\n    \r\n  cout << "\\n\\n" << n << "!" << " = " << silnia << endl << endl;\r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(90, 11, 3, '<p>\r\nNapisz program wyznaczający <em>NWD</em> \r\n(<em>Największy Wspólny Dzielnik</em>) \r\nliczb <em>a</em> i <em>b</em>.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int a,b,roba,robb;\r\n  \r\n  cout << "Program oblicza NWD(a,b).\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "a=";\r\n  cin  >> a;\r\n  \r\n  cout << "b=";\r\n  cin  >> b;\r\n  \r\n  roba=a;\r\n  robb=b;\r\n  \r\n  while (roba != robb)\r\n   {\r\n     if (roba > robb)\r\n       roba = roba-robb;\r\n     else\r\n       robb = robb-roba;  \r\n   }\r\n  \r\n  \r\n \r\n  cout << "\\n\\nNWD(" << a << "," << b << ") = " << \r\n     roba << endl << endl;\r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(91, 11, 4, '<p>\r\nNapisz program wyznaczający <em>NWW</em> \r\n(<em>Najmniejszą Wspólną Wielokrotną</em>) \r\nliczb <em>a</em> i <em>b</em>.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int a,b,roba,robb,nwd,nww;\r\n  \r\n  cout << "Program oblicza NWW(a,b).\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "a=";\r\n  cin  >> a;\r\n  \r\n  cout << "b=";\r\n  cin  >> b;\r\n  \r\n  roba=a;\r\n  robb=b;\r\n  \r\n  while (roba != robb)\r\n   {\r\n     if (roba > robb)\r\n       roba = roba-robb;\r\n     else\r\n       robb = robb-roba;  \r\n   }\r\n   \r\n  nwd=roba;\r\n  \r\n  nww = ( a / nwd ) *  b ;\r\n  \r\n  \r\n \r\n  cout << "\\n\\nNWW(" << a << "," << b << ") = " << \r\n     nww << endl << endl;\r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(92, 11, 5, '<p>\r\nNapisz program wyznaczający pierwiastek całkowity zadanej liczby.\r\n(Nie stosuj funkcji <span class="variable">sqrt()</span>. \r\nUżyj wyłącznie pętli i działań arytmetycznych). \r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int n,robn,ile,nieparzysta;\r\n  \r\n  cout << "Program oblicza pierwiastek całkowity z zadanej liczby.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "n=";\r\n  cin  >> n;\r\n  \r\n  robn=n;\r\n  nieparzysta=1;\r\n  ile=0;\r\n \r\n  while (robn>=0)\r\n    {\r\n      robn-=nieparzysta;\r\n      ile++;\r\n      nieparzysta+=2;\r\n    }\r\n    \r\n  ile--;\r\n    \r\n  cout << "\\n\\nPierwiastek całkowity z liczby n = " \r\n       << ile << ".\\n\\n";\r\n  \r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(93, 12, 1, '<p>\r\nNapisz program wyznaczający liczbę cyfr zadanej liczby.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int n,rob,liczbacyfr;\r\n  \r\n  \r\n  cout << "Program wyznacza liczbę cyfr zadanej liczby.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "Podaj liczb n=";\r\n  cin  >> n;\r\n  \r\n  liczbacyfr=0;\r\n  rob=n;\r\n  \r\n  if ( rob == 0 )\r\n    liczbacyfr=1;\r\n  else  \r\n    while (rob>0)\r\n      {\r\n        liczbacyfr++;\r\n        rob/=10;\r\n      }\r\n      \r\n  cout << "Liczba " << n << " ma " << liczbacyfr << " cyfr(y)." << endl << endl;\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(94, 12, 2, '<p>\r\nNapisz program wyznaczający sumę cyfr liczby.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(95, 12, 3, '<p>\r\nNapisz program sumujący cyfry zadanej liczby. \r\nProces sumowania powtarzamy aż do momentu otrzymania liczby jednocyfrowej.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int n,robn,suma,ostatniacyfra;\r\n  \r\n  \r\n  cout << "Program wyznacza sumę cyfr zadanej liczby.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "Podaj liczb n=";\r\n  cin  >> n;\r\n  \r\n  robn=n;\r\n  suma=0;\r\n  \r\n  while (robn>0)\r\n      {\r\n        ostatniacyfra = robn % 10;\r\n        robn = robn / 10;\r\n        \r\n        suma += ostatniacyfra;\r\n      }\r\n      \r\n  cout << "Suma cyfr liczby " << n << " = " \r\n        << suma << "." << endl << endl;\r\n  \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(96, 12, 4, '<p>\r\nNapisz program stwierdzający, czy zadana liczba jest palindromem.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int n,robn,ostatniacyfra,odwrotna;\r\n  \r\n  \r\n  cout << "Program sprawdza czy zadana liczba jest palindromem.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "Podaj liczb n=";\r\n  cin  >> n;\r\n  \r\n  robn     = n;\r\n  odwrotna = 0;\r\n  \r\n  while (robn)\r\n    {\r\n      ostatniacyfra=robn % 10;\r\n      robn /= 10;\r\n      \r\n      odwrotna = odwrotna * 10 + ostatniacyfra;\r\n    }\r\n\r\n  if (odwrotna==n)  \r\n    cout << "\\n\\nPALINDROM\\n\\n" \r\n         << n <<  " = " << odwrotna << endl << endl;\r\n  else\r\n    cout << "\\n\\n NIE-PALINDROM\\n\\n" \r\n         << n <<  " != " << odwrotna << endl << endl;\r\n           \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(97, 12, 5, '<p>\r\nJaki jest największy palindrom mieszczący się w typie <code>int</code>?\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(98, 12, 6, '<p>\r\nWydrukuj na ekranie wszystkie palindromy z zakresu od \r\n<em>a</em> do <em>b</em>. \r\nLiczby <em>a</em> i <em>b</em> wczytujemy z klawiatury.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int a,b,i,odwrotna,rob;\r\n  \r\n  \r\n  cout << "Program wyznacza palindromy z zadanego zakresu.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "a=";\r\n  cin  >> a;\r\n  \r\n  cout << "b=";\r\n  cin  >> b;\r\n  \r\n  cout << "\\n\\n"; \r\n  \r\n  for (i=a;i<=b;i++)\r\n    {\r\n      rob=i;\r\n      odwrotna=0;\r\n      while (rob)\r\n        {\r\n          odwrotna = odwrotna * 10 + rob % 10;\r\n          rob /= 10;\r\n        }\r\n \r\n      if (odwrotna==i)  \r\n          cout << i << "\\n";\r\n    }\r\n         \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(99, 12, 7, '<p>\r\nNapisz program, \r\nsprawdzający, czy wszystkie cyfry zadanej liczby są parzyste.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int n,robn,ostatniacyfra;\r\n  \r\n  \r\n  cout << "Program sprawdza, czy wszystkie cyfry zadanej liczby są parzyste.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "n=";\r\n  cin  >> n;\r\n  \r\n  robn = n;\r\n  ostatniacyfra = n % 10;\r\n  while ((ostatniacyfra % 2 == 0)  && (robn))\r\n    {\r\n      robn /= 10;\r\n      ostatniacyfra = robn % 10;\r\n    }\r\n    \r\n  if (robn) \r\n    cout << "Liczba " << n << " ma conajmniej jedną nieparzystą cyfrę!\\n\\n\\n";\r\n  else   \r\n    cout << "Wszystkie cyfry liczby " << n << " są parzyste!\\n\\n\\n";  \r\n         \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(100, 12, 8, '<p>\r\nNapisz program, drukujący liczbę w odwrotnej kolejności.\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int n,robn,ostatniacyfra;\r\n  \r\n  \r\n  cout << "Program drukuje zadaną liczbę w odwrotnej kolejności.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "n=";\r\n  cin  >> n;\r\n  \r\n  cout << "\\n\\nLiczba " << n << " w odwrotnej kolejności ";  \r\n  \r\n  if (n)\r\n    {\r\n      robn = n;\r\n      while (robn)\r\n        {\r\n          ostatniacyfra = robn % 10;\r\n          cout << ostatniacyfra;\r\n          robn = robn /10;      \r\n        }  \r\n    }\r\n  else\r\n    cout << "0";  \r\n  \r\n    \r\n  cout << "\\n\\n";      \r\n    \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(101, 12, 9, '<p>\r\nNapisz program stwierdzający, czy liczba kończy się swoim pierwiastkiem?\r\n</p>', '#include <iostream>\r\n#include <cstdlib>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char *argv[])\r\n{\r\n  int i,n,rob,nieparzysta,pierwiastek,liczbacyfr,potegadziesiatki;\r\n  \r\n  \r\n  cout << "Program sprawdza, czy liczba kończy się swoim pierwiastkiem.\\n";\r\n  cout << "(C)2003 student\\n\\n\\n";  \r\n  \r\n  cout << "n=";\r\n  cin  >> n;\r\n  \r\n  \r\n  pierwiastek=0;\r\n  nieparzysta=1;\r\n  rob = n;\r\n  \r\n  while (rob>=0)\r\n    {\r\n      rob -= nieparzysta;    \r\n      nieparzysta+=2;\r\n      pierwiastek++;\r\n    }\r\n  pierwiastek--;\r\n  \r\n  //cout << "Pierwiastek z liczby " <<  n << " wynosi " << pierwiastek << "\\n\\n";    \r\n  \r\n  //liczba cyfr pierwiastka\r\n  liczbacyfr = 0;\r\n  rob=pierwiastek;\r\n  while(rob)\r\n    {\r\n      liczbacyfr++;\r\n      rob/=10;\r\n    }\r\n  \r\n  //cout << "Liczba cyfr pierwiastka LC=" << liczbacyfr << "\\n\\n";      \r\n  \r\n  \r\n  \r\n  //potęga liczby 10\r\n  \r\n  \r\n  potegadziesiatki=1;\r\n  for(i=1;i<=liczbacyfr;i++)\r\n    potegadziesiatki*=10;  \r\n    \r\n  if (n % potegadziesiatki == pierwiastek)  \r\n    cout << "\\n\\nTAK\\n\\n" << n << " kończy się liczbą " << pierwiastek << "\\n\\n";\r\n  else  \r\n    cout << "\\n\\nNIE\\n\\n" << n << " NIE kończy się liczbą " << pierwiastek << "\\n\\n";  \r\n    \r\n   \r\n  system("PAUSE");	\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(102, 12, 10, '<p>\r\nNapisz program drukujący na ekranie \r\nwszystkie liczby z zakresu od \r\n<em>a</em> do <em>b</em> kończące się swoim pierwiastkiem.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(103, 12, 11, '<p>\r\nNapisz program drukujący na ekranie zadaną liczbę \r\nzastępując jej kolejne cyfry ich kwadratami (dla liczby 127 drukujemy 1449).\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(104, 12, 12, '<p>\r\nNapisz program drukujący na ekranie zadaną \r\nliczbę zastępując jej kolejne cyfry ich sześcianami.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(105, 12, 13, '<p>\r\nNapisz program drukujący na ekranie zadaną \r\nliczbę zastępując jej kolejne cyfry liczbami \r\npowstałymi przez dodanie do cyfr liczby 1 (1598  =  26109).\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(106, 12, 14, '<p>\r\nNapisz program drukujący na ekranie zadaną \r\nliczbę zastępując jej kolejne cyfry liczbami \r\npowstałymi przez dodanie do cyfr liczb  1, 2, 3, 4 itd. \r\nDo liczby najmniej znaczącej (liczba jedności) \r\ndodajemy 1, do liczby dziesiątek dodajemy 2 itd.  (1598  =  58119).\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(107, 12, 15, '<p>\r\nNapisz program drukujący na ekranie zadaną liczbę \r\nzastępując jej kolejne cyfry liczbami \r\npowstałymi przez następujące działanie:\r\n</p>\r\n\r\n<ul>\r\n<li>do każdej cyfry dodać jej kwadrat,</li>\r\n<li>wynik wydzielić modulo 10.</li>\r\n</ul>\r\n\r\n<p>\r\nnp. dla 1234 mamy 1234 + (1 4 9 16) = (2 6 12 20) = 2620\r\n</p>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(108, 13, 1, '<p>\r\nCo zostanie wydrukowane po wykonaniu pętli:\r\n</p>\r\n\r\n\r\n<pre>\r\na = 1;\r\nb = 3;\r\nwhile (a &lt; b) {\r\n    a = 3 * a – 1;\r\n    b = 2 * b + 1;\r\n}\r\n\r\ncout &lt;&lt; a &lt;&lt; endl &lt;&lt; b;\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(109, 13, 2, '<p>\r\nCo zostanie wydrukowane po wykonaniu pętli:\r\n</p>\r\n\r\n\r\n<pre>\r\na = 21;\r\nb = 3;\r\nwhile (a != b) {\r\n    a = a – 1;\r\n    b = b + 1;\r\n}\r\n\r\ncout &lt;&lt; a &lt;&lt; endl &lt;&lt; b;\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(110, 13, 3, '<p>\r\nCo zostanie wydrukowane po wykonaniu pętli:\r\n</p>\r\n\r\n\r\n<pre>\r\na = 1000;\r\nb = 1;\r\nwhile (a &gt; b) {\r\n    a /= 2;\r\n    b *= 2;\r\n}\r\n\r\ncout &lt;&lt; a &lt;&lt; endl &lt;&lt; b;\r\n</pre>\r\n', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(111, 14, 1, '<p>\r\nNapisz program wczytujący z klawiatury \r\n10 liczb całkowitych. \r\nWczytane liczby należy wydrukować na ekranie.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[10], i, n;\r\n\r\n    for (i = 0; i < 10; i++) {\r\n        cout << "Liczba nr: " << i << " =";\r\n        cin  >> tab[i];\r\n    }\r\n\r\n    for (i = 0; i < 10; i++) {\r\n        cout << "Liczba nr: " << i << " =" << tab[i] << endl;\r\n    }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(112, 14, 2, '<p>\r\nNapisz program wczytujący z klawiatury 10 liczb \r\ncałkowitych. Wczytane liczby należy wydrukować \r\nna ekranie w odwrotnej kolejności.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[10], i;\r\n\r\n    for (i = 0; i < 10; i++) {\r\n        cout << "Liczba nr: " << i << " =";\r\n        cin>> tab[i];\r\n    }\r\n\r\n    for (i = 9; i >= 0; i--) {\r\n        cout << "Liczba nr: " << i\r\n             << " =" << tab[i] << endl;\r\n    }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(113, 15, 1, '<p>\r\nNapisz program wczytujący z klawiatury \r\n<em>n</em> liczb całkowitych. \r\nProgram ma znaleźć największą spośród \r\npodanych liczb i wydrukować ją na ekranie.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[100], i, n, max;\r\n\r\n    cout << "Ile n = ";\r\n    cin  >> n ;\r\n    if (n >= 1 && n <=100) {\r\n        for (i = 0; i < n; i++) {\r\n              cout << "Liczba nr: " << i << " =";\r\n              cin  >> tab[i];\r\n          }\r\n          max = tab [ 0 ];\r\n          for (i = 1 ; i < n ; i++) {\r\n              if (max < tab[i])\r\n                  max = tab[i];\r\n          }\r\n          cout << "Max = " << max << endl;\r\n      } else {\r\n          cout <<"Zla liczba\\n";\r\n      }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(114, 15, 2, '<p>\r\nNapisz program wczytujący z \r\nklawiatury <em>n</em> liczb całkowitych. \r\nProgram ma znaleźć najmniejszą spośród podanych \r\nliczb i wydrukować ją na ekranie.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[100], i, n, min;\r\n    cout << "Ile n = ";\r\n    cin  >> n ;\r\n    if (n >= 1 && n <= 100) {\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =";\r\n            cin  >> tab[i];\r\n        }\r\n        min = tab [ 0 ];\r\n        for (i = 1; i < n; i++) {\r\n            if (min > tab[i])\r\n                min = tab[i];\r\n        }\r\n        cout << "Min = " << min << endl;\r\n    } else {\r\n        cout <<"Zla liczba\\n";\r\n    }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(115, 15, 3, '<p>\r\nNapisz program wczytujący z klawiatury \r\n<em>n</em> liczb całkowitych. \r\nProgram ma znaleźć największą spośród \r\npodanych liczb oraz wydrukować na \r\nekranie informację mówiącą o tym, \r\nile razy największa liczba wystąpiła w podanym ciągu liczb.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[100], i, n, max, ilemax;\r\n\r\n    cout << "Ile n = ";\r\n    cin  >> n ;\r\n\r\n    if (n >= 1 && n <= 100) {\r\n\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =";\r\n            cin  >> tab[i];\r\n        }\r\n\r\n        max    = tab [ 0 ];\r\n        ilemax = 1;\r\n\r\n        for (i = 1; i < n; i++) {\r\n\r\n            if (max < tab[i]) {\r\n\r\n                ilemax = 1;\r\n                max    = tab[i];\r\n\r\n            } else if (max == tab[i]) {\r\n\r\n                ilemax++;\r\n\r\n            }\r\n\r\n        }\r\n        cout << "Max = " << max << endl;\r\n        cout << "Wystapilo " << ilemax << " razy.\\n";\r\n    } else {\r\n        cout <<"Zla liczba\\n";\r\n    }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(116, 15, 4, '<p>\r\nNapisz program wczytujący z klawiatury \r\n<em>n</em> liczb całkowitych. \r\nProgram ma znaleźć najmniejszą spośród \r\npodanych liczb oraz wydrukować na \r\nekranie informację mówiącą o tym, \r\nile razy najmniejsza liczba wystąpiła w podanym ciągu liczb.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[100], i, n, min, ilemin;\r\n\r\n    cout << "Ile n = ";\r\n    cin  >> n ;\r\n\r\n    if (n >= 1 && n <= 100) {\r\n\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =";\r\n            cin  >> tab[i];\r\n        }\r\n\r\n        min    = tab [ 0 ];\r\n        ilemin = 1;\r\n\r\n        for (i = 1; i < n; i++) {\r\n\r\n            if (min > tab[i]) {\r\n\r\n                ilemin = 1;\r\n                min    = tab[i];\r\n\r\n            } else if (min == tab[i]) {\r\n\r\n                ilemin++;\r\n\r\n            }\r\n\r\n        }\r\n        cout << "Min = " << min << endl;\r\n        cout << "Wystapilo " << ilemin << " razy.\\n";        \r\n    } else {\r\n        cout <<"Zla liczba\\n";\r\n    }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(117, 15, 5, '<p>\r\nNapisz program wczytujący z klawiatury \r\n<em>n</em> liczb całkowitych. \r\nProgram ma znaleźć drugi co \r\ndo wielkości wyraz podanego ciągu \r\nliczb (czyli liczbę mniejszą od \r\nnajwiększej liczby występującej w ciągu, \r\nale większą od wszystkich pozostałych).\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[100], i, n, max, max2;\r\n\r\n    cout << "Ile n = ";\r\n    cin  >> n ;\r\n    if (n >= 1 && n <= 100) {\r\n\r\n        //wczytanie\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =";\r\n            cin  >> tab[i];\r\n        }\r\n\r\n        //szukamy max\r\n        max = tab [ 0 ];\r\n        for (i = 1; i < n; i++) {\r\n            if (max < tab[i])\r\n                max = tab[i];\r\n        }\r\n\r\n\r\n        max2 = tab [ 0 ];\r\n        for (i = 1; i < n; i++) {\r\n            if (max2 == max) {\r\n                max2 = tab[i];\r\n            } else {\r\n                if (tab[i] > max2 && tab[i] < max)\r\n                    max2 = tab[i];\r\n            }\r\n        }\r\n        cout << "Druga najwieksza liczba jest " << max2 << endl;\r\n    } else {\r\n        cout << "\\nZła liczba!\\n";\r\n    }\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(118, 15, 6, '<p>\r\nNapisz program wczytujący z \r\nklawiatury <em>n</em> liczb całkowitych. \r\nProgram ma znaleźć drugi co \r\ndo wielkości (ciut większy od najmniejszego) \r\nwyraz podanego ciągu liczb (czyli liczbę \r\nwiększą od najmniejszej ale mniejszą od każdej innej).\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[100], n, i, min, min2;\r\n\r\n    cout << "Podaj liczbe = ";\r\n    cin  >> n;\r\n\r\n    if (n > 0 && n <= 100) {\r\n\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Podaj liczbe" << i << "= ";\r\n            cin  >> tab[i];\r\n        }\r\n\r\n        min  = tab[0];\r\n        min2 = tab[0];\r\n\r\n        for (i = 1; i < n; i++) {\r\n            if (min == min2) {\r\n\r\n                if (min > tab[i])\r\n                    min = tab[i];\r\n                else\r\n                    min2 = tab[i];\r\n            } else {\r\n\r\n                if (tab[i] < min) {\r\n\r\n                    min2 = min;\r\n                    min  = tab[i];\r\n\r\n                } else if (tab[i] < min2) {\r\n\r\n                    min2 = tab[i];\r\n\r\n                }\r\n            }\r\n        }\r\n\r\n\r\n        cout << "\\n\\nMIN2 = " << min2 << "\\n\\n";\r\n\r\n    } else\r\n        cout << "Zla liczba"<<endl;\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(119, 15, 7, '<p>\r\nIle razy w podanym ciągu liczb \r\nwystąpił drugi co do wielkości największy element ciągu?\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[100], i, n, max, max2, ilemax2;\r\n\r\n    cout << "Ile n = ";\r\n    cin  >> n ;\r\n    if (n >= 1 && n <= 100) {\r\n\r\n        //wczytanie\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =";\r\n            cin  >> tab[i];\r\n        }\r\n\r\n        //szukamy max\r\n        max = tab [ 0 ];\r\n        for (i = 1; i < n; i++) {\r\n            if (max < tab[i])\r\n                max = tab[i];\r\n        }\r\n\r\n\r\n        ilemax2 = 1;\r\n        max2    = tab [ 0 ];\r\n\r\n        for (i = 1; i < n; i++) {\r\n            if (max2 == max) {\r\n\r\n                if (tab[i] == max)\r\n                    ilemax2++;\r\n                else\r\n                    ilemax2 = 1;\r\n                    \r\n                max2    = tab[i];\r\n\r\n            } else {\r\n                if (tab[i] > max2 && tab[i] < max) {\r\n\r\n                    ilemax2 = 1;\r\n                    max2    = tab[i];\r\n\r\n                } else if (max2 == tab[i]) {\r\n\r\n                    ilemax2++;\r\n\r\n                }\r\n            }\r\n        }\r\n        cout << "Druga najwieksza liczba jest " << max2 << endl;\r\n        cout << "Liczba wystapien: " << ilemax2 << endl;\r\n    } else {\r\n        cout << "\\nZła liczba!\\n";\r\n    }\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(120, 16, 1, '<p>\r\nNapisz program wczytujący ciąg liczb rzeczywistych. \r\nKażdą podana liczbę należy podnieść \r\ndo kwadratu, a następnie wydrukować na ekranie.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[30], i, n;\r\n\r\n    cout << "Ile n= ";\r\n    cin >> n;\r\n    if (n > 0 && n < 31) {\r\n\r\n        //wczytanie\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =";\r\n            cin >> tab[i];\r\n        }\r\n\r\n        //przetwarzanie\r\n        for (i = 0; i < n; i++) {\r\n            tab[i] = tab[i] * tab[i];\r\n        }\r\n\r\n        //wydruk\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =" << tab[i] << endl;\r\n        }\r\n    } else {\r\n        cout << "Zla liczba\\n";\r\n    }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(121, 16, 2, '<p>\r\nNapisz program wczytujący ciąg liczb rzeczywistych. \r\nKażdą podana liczbę należy podnieść do \r\ntrzeciej potęgi, a następnie wydrukować na ekranie.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[30], i, n;\r\n\r\n    cout << "Ile n= ";\r\n    cin >> n;\r\n    if (n > 0 && n < 31) {\r\n\r\n        //wczytanie\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =";\r\n            cin >> tab[i];\r\n        }\r\n\r\n        //przetwarzanie\r\n        for (i = 0; i < n; i++) {\r\n            tab[i] = tab[i] * tab[i] * tab[i];\r\n        }\r\n\r\n        //wydruk\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =" << tab[i] << endl;\r\n        }\r\n    } else {\r\n        cout << "Zla liczba\\n";\r\n    }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(122, 16, 3, '<p>\r\nNapisz program wczytujący ciąg liczb \r\nrzeczywistych. Do każdej podanej \r\nliczby należy dodać jeden. Tak \r\notrzymane liczby należy wydrukować na ekranie.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[30], i, n;\r\n\r\n    cout << "Ile n= ";\r\n    cin >> n;\r\n    if (n > 0 && n < 31) {\r\n\r\n        //wczytanie\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =";\r\n            cin >> tab[i];\r\n        }\r\n\r\n        //przetwarzanie\r\n        for (i = 0; i < n; i++) {\r\n            tab[i] = tab[i] + 1;\r\n        }\r\n\r\n        //wydruk\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =" << tab[i] << endl;\r\n        }\r\n    } else {\r\n        cout << "Zla liczba\\n";\r\n    }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(123, 17, 1, '<p>\r\nNapisz program wczytujący ciąg liczb całkowitych. \r\nWydrukuj na ekranie kolejno wszystkie parzyste spośród podanych liczb.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[30], i, n;\r\n\r\n    cout << "Ile n= ";\r\n    cin >> n;\r\n    if (n > 0 && n < 31) {\r\n\r\n        //wczytanie\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =";\r\n            cin >> tab[i];\r\n        }\r\n\r\n        cout << endl << endl;\r\n                \r\n        //przetwarzanie\r\n        for (i = 0; i < n; i++) {\r\n            if (tab[i] % 2 == 0) {\r\n                cout << tab[i] << ", ";\r\n            }\r\n        }\r\n        cout << endl << endl;\r\n\r\n    } else {\r\n        cout << "Zla liczba\\n";\r\n    }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(124, 17, 2, '<p>\r\nNapisz program wczytujący ciąg liczb całkowitych. \r\nWydrukuj na ekranie kolejno wszystkie nieparzyste spośród podanych liczb.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[30], i, n;\r\n\r\n    cout << "Ile n= ";\r\n    cin >> n;\r\n    if (n > 0 && n < 31) {\r\n\r\n        //wczytanie\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =";\r\n            cin >> tab[i];\r\n        }\r\n\r\n        cout << endl << endl;\r\n                \r\n        //przetwarzanie\r\n        for (i = 0; i < n; i++) {\r\n            if (tab[i] % 2 == 1) {\r\n                cout << tab[i] << ", ";\r\n            }\r\n        }\r\n        cout << endl << endl;\r\n\r\n    } else {\r\n        cout << "Zla liczba\\n";\r\n    }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(125, 17, 3, '<p>\r\nNapisz program wczytujący ciąg liczb całkowitych. \r\nWydrukuj na ekranie kolejno wszystkie liczby, które dzielą się przez 3.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[30], i, n;\r\n\r\n    cout << "Ile n= ";\r\n    cin >> n;\r\n    if (n > 0 && n < 31) {\r\n\r\n        //wczytanie\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =";\r\n            cin >> tab[i];\r\n        }\r\n\r\n        cout << endl << endl;\r\n                \r\n        //przetwarzanie\r\n        for (i = 0; i < n; i++) {\r\n            if (tab[i] % 3 == 0) {\r\n                cout << tab[i] << ", ";\r\n            }\r\n        }\r\n        cout << endl << endl;\r\n\r\n    } else {\r\n        cout << "Zla liczba\\n";\r\n    }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(126, 17, 4, '<p>\r\nNapisz program wczytujący ciąg liczb rzeczywistych. \r\nWydrukuj na ekranie kolejno wszystkie liczby, które należą do przedziału <em>[4;15)</em>.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[30], i, n;\r\n\r\n    cout << "Ile n= ";\r\n    cin >> n;\r\n    if (n > 0 && n < 31) {\r\n\r\n        //wczytanie\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =";\r\n            cin >> tab[i];\r\n        }\r\n\r\n        cout << endl << endl;\r\n                \r\n        //przetwarzanie\r\n        for (i = 0; i < n; i++) {\r\n            if (tab[i] >= 4 && tab[i] < 15) {\r\n                cout << tab[i] << ", ";\r\n            }\r\n        }\r\n        cout << endl << endl;\r\n\r\n    } else {\r\n        cout << "Zla liczba\\n";\r\n    }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(127, 17, 5, '<p>\r\nNapisz program wczytujący ciąg liczb całkowitych. \r\nWydrukuj na ekranie kolejno wszystkie liczby, które mają wszystkie cyfry parzyste.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(128, 17, 6, '<p>\r\nNapisz program wczytujący ciąg liczb całkowitych. \r\nWydrukuj na ekranie kolejno wszystkie liczby, których suma cyfr wynosi 1.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(129, 17, 7, '<p>\r\nNapisz program wczytujący ciąg liczb całkowitych. \r\nDo liczb parzystych należy dodać 100, \r\na następnie wydrukować wszystkie liczby na ekranie.\r\n</p>', '#include <iostream>\r\nusing namespace std;\r\n\r\nint main (int arqc, char * argv [])\r\n{\r\n    int tab[30], i, n;\r\n\r\n    cout << "Ile n= ";\r\n    cin >> n;\r\n    if (n > 0 && n < 31) {\r\n\r\n        //wczytanie\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << i << " =";\r\n            cin >> tab[i];\r\n        }\r\n\r\n        cout << endl << endl;\r\n\r\n        //przetwarzanie\r\n        for (i = 0; i < n; i++) {\r\n            if (tab[i] % 2 == 0) {\r\n                tab[i] += 100;\r\n            }\r\n        }\r\n        cout << endl << endl;\r\n\r\n        //wydruk\r\n        for (i = 0; i < n; i++) {\r\n            cout << "Liczba nr: " << tab[i] << endl;\r\n        }\r\n\r\n\r\n    } else {\r\n        cout << "Zla liczba\\n";\r\n    }\r\n\r\n    system ("Pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(130, 18, 1, '<p>\r\nNapisz program wczytujący ciąg liczb rzeczywistych. \r\nWydrukuj na ekranie te spośród liczb, których indeks jest liczbą parzystą.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(131, 19, 1, '<p>\r\nNapisz program generujący ciąg liczb pierwszych \r\nod 0 do n metodą sita Eratostanesa.\r\n</p>', '#include <iostream.h>\r\n#include <cstdlib.h>\r\n\r\nusing namespace std;\r\n\r\nint main(int argc, char* argv[]){\r\n  int tab[1000],n,i,j,dzielnik;\r\n\r\n\r\n  cout << "Podaj n=";\r\n  cin >> n;\r\n  if (n>0 && n<=1001)\r\n    {\r\n      for (i=2;i<=n;i++)\r\n        tab[i-2]=i;\r\n\r\n      for (i=0;i<=n-3;i++)\r\n        {\r\n          dzielnik = tab[i];\r\n          if (dzielnik > 0)\r\n            for (j=i+1;j<n-2;j++)\r\n                if (tab[j] % dzielnik == 0)\r\n                  tab[j] = 0;\r\n        }\r\n\r\n      for (i=0;i<n-2;i++)\r\n        if (tab[i] > 0)\r\n          cout << tab[i] << endl;\r\n    }\r\n  else\r\n    cout << "\\nZła liczba n (1-1001)\\n";\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(132, 19, 2, '<p>\r\nNapisz program generujący ciąg <em>n</em> początkowych liczb Fibonacciego.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(133, 19, 3, '<p>\r\nNapisz program sortujący wczytane \r\n<em>n</em> liczb metodą wyszukiwania kolejnych minimów.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(134, 20, 1, '<p>\r\nNapisz funkcję \r\n<span class="variable">suma()</span>\r\nwyznaczającą sumę dwóch zadanych liczb całkowitych. \r\nNapisz program wykorzystujący funkcję <span class="variable">suma()</span>.\r\n</p>', '#include <iostream.h>\r\n#include <cstdlib.h>\r\n\r\nusing namespace std;\r\n\r\nint sumaliczb(int a, int b);\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  int l1, l2, l3;\r\n\r\n  cout << "\\nProgram SUMA LICZB" << endl\r\n       << "(C)2003 by student" << endl << endl;\r\n\r\n  cout << "Podaj pierwszą liczbę =";\r\n  cin >> l1;\r\n\r\n  cout << "Podaj drugą liczbę =";\r\n  cin >> l2;\r\n\r\n  l3=sumaliczb(l1,l2);\r\n\r\n  cout << endl << "SUMA LICZB WYNOSI:" << endl;\r\n  cout << l1 << "+" << l2 << "=" << l3 << endl << endl;\r\n\r\n  system ("Pause");\r\n\r\n  return 0;\r\n}\r\n\r\nint sumaliczb(int a, int b)\r\n{\r\n  return a+b;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(135, 20, 2, '<p>\r\nNapisz funkcję <span class="variable">roznica()</span> \r\nwyznaczającą różnicę dwóch zadanych liczb całkowitych. \r\nDziałanie funkcji sprawdź pisząc odpowiedni program.\r\n</p>', '#include <iostream.h>\r\n#include <cstdlib.h>\r\n\r\nusing namespace std;\r\n\r\nint roznicaliczb(int a, int b);\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  int l1, l2, l3;\r\n\r\n  cout << "\\nProgram RÓŻNICA LICZB" << endl\r\n       << "(C)2003 by student" << endl << endl;\r\n\r\n  cout << "Podaj pierwszą liczbę =";\r\n  cin >> l1;\r\n\r\n  cout << "Podaj drugą liczbę =";\r\n  cin >> l2;\r\n\r\n  l3=roznicaliczb(l1,l2);\r\n\r\n  cout << endl << "RÓŻNICA LICZB WYNOSI:" << endl;\r\n  cout << l1 << "-" << l2 << "=" << l3 << endl << endl;\r\n\r\n  system ("Pause");\r\n\r\n  return 0;\r\n}\r\n\r\nint roznicaliczb(int a, int b)\r\n{\r\n  return a - b;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(136, 20, 3, '<p>\r\nNapisz funkcję <span class="variable">iloczyn()</span> \r\nwyznaczającą iloczyn dwóch zadanych liczb \r\ncałkowitych. Działanie funkcji sprawdź pisząc odpowiedni program.\r\n</p>', '#include <iostream.h>\r\n#include <cstdlib.h>\r\n\r\nusing namespace std;\r\n\r\nint iloczynliczb(int a, int b);\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  int l1, l2, l3;\r\n\r\n  cout << "\\nProgram ILOCZYN LICZB" << endl\r\n       << "(C)2003 by student" << endl << endl;\r\n\r\n  cout << "Podaj pierwszą liczbę =";\r\n  cin >> l1;\r\n\r\n  cout << "Podaj drugą liczbę =";\r\n  cin >> l2;\r\n\r\n  l3=iloczynliczb(l1,l2);\r\n\r\n  cout << endl << "ILOCZYN LICZB WYNOSI:" << endl;\r\n  cout << l1 << "*" << l2 << "=" << l3 << endl << endl;\r\n\r\n  system ("Pause");\r\n\r\n  return 0;\r\n}\r\n\r\nint iloczynliczb(int a, int b)\r\n{\r\n  return a * b;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(137, 20, 4, '<p>\r\nNapisz funkcję <span class="variable">iloraz()</span> wyznaczającą \r\niloraz dwóch zadanych liczb całkowitych. \r\nDziałanie funkcji sprawdź pisząc odpowiedni program.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(138, 20, 5, '<p>\r\nNapisz funkcję <span class="variable">liczby_pitagorejskie()</span>,\r\nktóra ma trzy parametry formalne \r\n<span class="variable">a</span>, \r\n<span class="variable">b</span>, \r\n<span class="variable">c</span>,\r\nbędące liczbami całkowitymi. \r\nWartością funkcji jest jeden, jeśli zadane liczby są \r\nliczbami pitagorejskimi oraz \r\nzero w przeciwnym wypadku. \r\nLiczby pitagorejskie spełniają warunek:  <span class="variable">a*a+b*b=c*c</span>.\r\n</p>', 'int LiczbyPitagorejskie(int a, int b, int c)\r\n{\r\n  if ( c > a && c > b) // c jest największe\r\n    if ( a * a + b * b == c * c)\r\n      return 1;\r\n    else\r\n      return 0;\r\n  else if ( b > a && b > c) // b jest największe\r\n    if ( a * a + c * c == b * b)\r\n      return 1;\r\n    else\r\n      return 0;\r\n  else if ( a > b && a > c) // a jest największe lub brak największej\r\n    if ( b * b + c * c == a * a)\r\n      return 1;\r\n    else\r\n      return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(139, 20, 6, '<p>\r\nNapisz program wykorzystujący funkcję \r\n<span class="variable">liczby_pitagorejskie()</span> \r\nz poprzedniego zadania.\r\nProgram ma drukować na ekranie \r\nwszystkie trójki liczb pitagorejskich z zakresu od 1 do 10.\r\n</p>', '#include <iostream.h>\r\n#include <cstdlib.h>\r\n\r\nusing namespace std;\r\n\r\nint LiczbyPitagorejskie(int a, int b, int c);\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  int i, j, k;\r\n\r\n  cout << "\\nProgram LICZBY PITAGOREJSKIE" << endl\r\n       << "(C)2003 by student" << endl << endl;\r\n\r\n  cout << "Podaj pierwszą liczbę =";\r\n  cin >> i;\r\n\r\n  cout << "Podaj drugą liczbę =";\r\n  cin >> j;\r\n\r\n  cout << "Podaj trzecią liczbę =";\r\n  cin >> k;\r\n\r\n  if (LiczbyPitagorejskie(i,j,k)==1)\r\n    cout << "\\nPodane liczby są liczbami pitagorejskimi\\n";\r\n  else\r\n    cout << "\\nPodane liczby nie są liczbami pitagorejskimi\\n";\r\n\r\n  system ("Pause");\r\n\r\n  return 0;\r\n}\r\n\r\nint LiczbyPitagorejskie(int a, int b, int c)\r\n{\r\n  if ( c > a && c > b) // c jest największe\r\n    if ( a * a + b * b == c * c)\r\n      return 1;\r\n    else\r\n      return 0;\r\n  else if ( b > a && b > c) // b jest największe\r\n    if ( a * a + c * c == b * b)\r\n      return 1;\r\n    else\r\n      return 0;\r\n  else if ( a > b && a > c) // a jest największe lub brak największej\r\n    if ( b * b + c * c == a * a)\r\n      return 1;\r\n    else\r\n      return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(140, 20, 7, '<p>\r\nNapisz funkcję, która wyznacza \r\npierwiastek całkowity z zadanej liczby. \r\nZastosuj algorytm odejmowania kolejnych liczb nieparzystych.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(141, 20, 8, '<p>\r\nNapisz funkcję, która wyznacza liczbę cyfr zadanej liczby całkowitej.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(142, 20, 9, '<p>\r\nNapisz funkcję, która stwierdza, czy \r\nzadana jako parametr liczba całkowita kończy \r\nsię swoim pierwiastkiem. \r\nLiczby kończące się swoim pierwiastkiem \r\nto 25, 625. Wartością funkcji \r\nma być jeden, jeśli liczba spełnia \r\nwarunek oraz zero w przeciwnym wypadku.\r\n</p>', 'int CzyLiczbaKonczySieSwoimPierwiastkiem(long liczba){\r\n  long rob = 0;\r\n  long dziesiatki = 10;\r\n\r\n  while (rob < liczba){\r\n    rob = liczba % dziesiatki;\r\n    rob = rob * rob;\r\n    dziesiatki *= 10;\r\n  }\r\n  if (rob == liczba)\r\n    return 1;\r\n  else\r\n    return 0;\r\n}\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(143, 20, 10, '<p>\r\nNapisz program, który wydrukuje na ekranie \r\nwszystkie liczby kończące się swoim kwadratem \r\nz zakresu 1-10000. \r\nProgram powinien wykorzystywać funkcję z poprzedniego zadania.\r\n</p>', '#include <iostream.h>\r\n#include <cstdlib.h>\r\n\r\nusing namespace std;\r\n\r\nint CzyLiczbaKonczySieSwoimPierwiastkiem(long liczba);\r\n\r\nint main(int argc, char * argv[]){\r\n  long i;\r\n\r\n  cout << endl << endl;\r\n\r\n  for (i=1;i<10000;i++)\r\n    if (CzyLiczbaKonczySieSwoimPierwiastkiem(i))\r\n      cout << i << endl;\r\n\r\n\r\n  cout << endl << endl;\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n\r\n\r\nint CzyLiczbaKonczySieSwoimPierwiastkiem(long liczba){\r\n  long rob = 0;\r\n  long dziesiatki = 10;\r\n\r\n  while (rob < liczba){\r\n    rob = liczba % dziesiatki;\r\n    rob = rob * rob;\r\n    dziesiatki *= 10;\r\n  }\r\n  if (rob == liczba)\r\n    return 1;\r\n  else\r\n    return 0;\r\n}\r\n\r\n\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(144, 20, 11, '<p>\r\nNapisz funkcję, \r\nktóra stwierdza, czy zadana jako \r\nparametr liczba całkowita jest kwadratem pewnej \r\nliczby całkowitej.  \r\nLiczby będące kwadratami liczb \r\ncałkowitych to 1, 4, 9, 16 itd. \r\nWartością funkcji ma być jeden, \r\njeśli liczba spełnia warunek oraz zero w przeciwnym wypadku.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(145, 20, 12, '<p>\r\nNapisz funkcję, \r\nktóra stwierdza, czy \r\nzadana jako parametr liczba \r\ncałkowita jest liczbą pierwszą. \r\nWartością funkcji ma być jeden, \r\njeśli liczba spełnia warunek oraz zero w przeciwnym wypadku.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(146, 20, 13, '<p>\r\nNapisz funkcję, \r\nktóra stwierdza, czy zadana \r\njako parametr liczba całkowita jest \r\nsześcianem pewnej liczby naturalnej. \r\nWartością funkcji ma być jeden, \r\njeśli liczba spełnia warunek oraz zero w przeciwnym wypadku.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(147, 20, 14, '<p>\r\nNapisz funkcję, która wyznacza maksimum \r\nz dwóch zadanych liczb całkowitych. \r\nWartością funkcji ma być większa spośród liczb.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(148, 21, 1, '<p>\r\nNapisz funkcję, która posiada trzy parametry formalne. \r\nPierwszym parametrem jest liczba <span class="variable">a</span>,  \r\ndrugim tablica liczb <span class="variable">tab</span> zaś trzecim &mdash; \r\nliczba <span class="variable">n</span>. \r\nFunkcja ma dla zadanej liczy <span class="variable">a</span> \r\nzwracać w tablicy  \r\n<span class="variable">tab</span> \r\njej kod binarny. \r\nLiczba <span class="variable">n</span> ma informować o tym,\r\nile elementów tablicy zostało wypełnionych.\r\n</p>', '#include <iostream.h>\r\n#include <stdlib.h>\r\n\r\n\r\nvoid cyfrybinarne(int a, int tab[], int &n);\r\n\r\nint main(int argc, char **argv)\r\n{\r\n  int liczba , cyfry[30] , n, i;\r\n\r\n  cout << "Podajliczbe=";\r\n  cin >> liczba;\r\n\r\n  cout << endl << endl;\r\n\r\n  cyfrybinarne(liczba,cyfry,n);\r\n\r\n  cout << endl << endl;\r\n\r\n  cout << endl << liczba << " = ";\r\n  for (i=n-1;i>=0;i--)\r\n    cout << cyfry[i];\r\n\r\n  cout << endl << endl;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\nvoid cyfrybinarne(int a, int tab[], int &n){\r\n  n = 0;\r\n  do {\r\n    tab[n] = a % 2;\r\n    a /= 2;\r\n    n++;\r\n  } while(a > 0);\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(149, 21, 2, '<p>\r\nNapisz funkcję, \r\nktóra znajduje w tablicy element minimalny. \r\nParametrami funkcji mają być tablica oraz liczba elementów tablicy. \r\nWartością funkcji ma być element maksymalny.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(150, 21, 3, '<p>\r\nNapisz funkcję, \r\nktóra znajduje w tablicy element maksymalny. \r\nParametrami funkcji mają być: \r\ntablica oraz liczba elementów tablicy. \r\nWartością funkcji ma być element maksymalny.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(151, 21, 4, '<p>\r\nNapisz funkcję, \r\nktóra sortuje zadaną tablicę liczb całkowitych rosnąco.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(152, 22, 1, '<p>\r\nNapisz funkcję, \r\nktóra wyznacza n-tą \r\n(<em>n</em> jest liczba naturalną) \r\npotęgę zadanej liczby rzeczywistej <em>x</em>. \r\nFunkcja ma wykorzystywać iterację.\r\n</p>', '#include <iostream.h>\r\n#include <stdlib.h>\r\n\r\n\r\nfloat potega_iteracyjna(int n, float x);\r\n\r\nint main(int argc, char **argv)\r\n{\r\n  int n;\r\n  float x;\r\n\r\n\r\n  cout << "\\nProgram zawiera implementacje funkcji POTEGA-ITERACYJNA\\n\\n";\r\n\r\n\r\n  cout << "wyladnik potegi n=";\r\n  cin >> n;\r\n\r\n  cout << "podstawa potegi x=";\r\n  cin >> x;\r\n\r\n  cout << "\\n\\nLiczba " << x << " po podniesieniu do potegi "\r\n       << n << " daje " << potega_iteracyjna(n,x)\r\n       << endl << endl;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n\r\nfloat potega_iteracyjna(int n, float x){\r\n  int i;\r\n  float wynik=1;\r\n\r\n  for(i=1;i<=n;i++)\r\n    wynik *= x;\r\n  return wynik;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(153, 22, 2, '<p>\r\nNapisz funkcję, \r\nktóra wyznacza n-tą \r\n(<em>n</em> jest liczba naturalną) \r\npotęgę zadanej liczby rzeczywistej <em>x</em>. \r\nFunkcja ma wykorzystywać rekurencję.\r\n</p>', '#include <iostream.h>\r\n#include <stdlib.h>\r\n\r\n\r\nfloat potega_rekurencyjna(int n, float x);\r\n\r\nint main(int argc, char **argv)\r\n{\r\n  int n;\r\n  float x;\r\n\r\n\r\n  cout << "\\nProgram zawiera implementacje funkcji POTEGA-REKURENCYJNA\\n\\n";\r\n\r\n\r\n  cout << "wyladnik potegi n=";\r\n  cin >> n;\r\n\r\n  cout << "podstawa potegi x=";\r\n  cin >> x;\r\n\r\n  cout << "\\n\\nLiczba " << x << " po podniesieniu do potegi "\r\n       << n << " daje " << potega_rekurencyjna(n,x)\r\n       << endl << endl;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n\r\nfloat potega_rekurencyjna(int n, float x){\r\n  float rob;\r\n\r\n  if (n == 0)\r\n    return 1;\r\n  else\r\n    {\r\n      rob = potega_rekurencyjna( n - 1 , x );\r\n      return rob * x;\r\n    }\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(154, 22, 3, '<p>\r\nNapisz funkcję, \r\nktóra posiada trzy parametry formalne. \r\nPierwszym parametrem jest liczba <span class="variable">a</span>,  \r\ndrugim tablica liczb <span class="variable">tab</span> zaś trzecim &mdash; liczba <span class="variable">n</span>. \r\nFunkcja ma dla zadanej liczy <span class="variable">a</span> zwracać \r\nw tablicy  <span class="variable">tab</span> \r\njej kod Graya. \r\nLiczba <span class="variable">n</span> \r\nma informować o tym, ile elementów tablicy zostało wypełnionych.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(155, 22, 4, '<p>\r\nNapisz funkcję, \r\nktóra wyznacza wartość <em>n!</em> \r\n(tj. <em>n</em> silnia), gdzie <em>n</em> jest liczba naturalną. \r\nFunkcja ma wykorzystywać iterację.\r\n</p>', '#include <iostream.h>\r\n#include <stdlib.h>\r\n\r\n\r\nint silnia_iteracyjna(int n);\r\n\r\nint main(int argc, char **argv)\r\n{\r\n  int n;\r\n\r\n  cout << "\\nProgram zawiera implementacje funkcji SILNIA-ITERACYJNA\\n\\n";\r\n\r\n\r\n  cout << "n=";\r\n  cin >> n;\r\n\r\n  cout << "\\n\\n" << n << "! = "\r\n       << silnia_iteracyjna(n)\r\n       << endl << endl;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n\r\nint silnia_iteracyjna(int n){\r\n  int i;\r\n  int wynik=1;\r\n\r\n  for(i=1;i<=n;i++)\r\n    wynik *= i;\r\n  return wynik;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(156, 23, 1, '<p>\r\nNapisz funkcję, \r\nktóra wyznacza wartość wielomianu \r\nw zadanym punkcie. \r\nParametrami funkcji mają być: <span class="variable">n</span> &mdash;  \r\nstopień wielomianu (liczba całkowita), \r\n<span class="variable">tab</span> &mdash; tablica współczynników \r\n(współczynniki są liczbami rzeczywistymi) \r\noraz <span class="variable">x</span> &mdash; zadany punkt \r\n(liczba rzeczywista). \r\nWartością funkcji ma być wyznaczona wartość wielomianu.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(157, 23, 2, '<p>\r\nNapisz funkcję, która wyznacza sumę dwóch wielomianów.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(158, 23, 3, '<p>\r\nNapisz funkcję, która wyznacza różnicę dwóch wielomianów.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(159, 23, 4, '<p>\r\nNapisz funkcję, która wyznacza iloczyn dwóch wielomianów.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(160, 23, 5, '<p>\r\nNapisz funkcję, która wyznacza pierwszą pochodną wielomianu.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(161, 23, 6, '<p>\r\nNapisz funkcję, która wyznacza drugą pochodną wielomianu.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(162, 23, 7, '<p>\r\nNapisz funkcję, która wyznacza n-tą pochodną wielomianu.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(163, 24, 1, '<p>\r\nNapisz funkcję <span class="variable">wizytowka()</span>, \r\nktóra wyprowadza na ekran informacje o programie.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(164, 24, 2, '<p>\r\nNapisz funkcję, która wczytuje wielomian  z klawiatury.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(165, 25, 1, '<p>\r\nNapisz program sprawdzający \r\ndziałanie instrukcji <span class="variable">switch</span>. \r\nProgram powinien wczytać z klawiatury \r\nliczbę całkowitą i w zależności \r\nod jej wartości wydrukować różne \r\nkomunikaty (np. jeśli podana liczba wynosi 0 to \r\nnależy wydrukować tekst <em>komunikat pierwszy</em>, \r\ndla liczby 1 drukujemy <em>komunikat drugi</em> \r\nzaś dla liczby 2 &mdash; <em>Komunikat trzeci</em>).\r\n</p>', '#include <iostream.h>\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  int i;\r\n\r\n  cin >> i;\r\n  switch(i){\r\n    case 0: cout<< "000";\r\n            break;\r\n    case 1: cout<< "111";\r\n            break;\r\n    case 2: cout<< "222";\r\n            break;\r\n    case 3: cout<< "333";\r\n            break;\r\n  }//switch\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(166, 25, 2, '<p>\r\nNapisz program obliczający pole kwadratu. \r\nProgram ma umożliwiać wielokrotne \r\nwykonanie obliczeń. \r\nPo każdorazowym wyznaczeniu pola \r\nkwadratu program powinien zadać pytanie <em>Czy chcesz powtórzyć?</em> \r\ni w zależności od udzielonej \r\nprzez użytkownika odpowiedzi zakończyć działanie \r\nlub powtórzyć obliczenia.\r\n</p>', '#include <iostream.h>\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  int odp;\r\n  float a;\r\n\r\n  do{\r\n      cout << endl << "Podaj bok kwadratu a=";\r\n      cin >> a;\r\n\r\n      cout << "Pole kwadratu wynosi P=" << a*a << endl;\r\n\r\n      cout << "Czy chcesz kontynuowa?" << endl;\r\n      cout << "0 - nie" << endl\r\n           << "1 - tak" << endl;\r\n      cin >> odp;\r\n\r\n  }while(odp==1);\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n ');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(167, 25, 3, '<p>\r\nNapisz program obliczający pola koła, \r\nkwadratu oraz trapezu. Program \r\nma zawierać menu drukowane funkcją <span class="variable">mojemenu()</span>. \r\nMenu programu umożliwia dokonanie wyboru: \r\nkoniec pracy programu, \r\nwyznaczanie pola kwadratu, \r\nwyznaczanie pola koła lub wyznaczanie pola trapezu. \r\nProgram kończy pracę jedynie powinien przypadku, \r\ngdy użytkownik wybierze w menu opcję koniec pracy. \r\nJeśli użytkownik wybierze opcję wyznaczania \r\npola dowolnej figury, wówczas po \r\nwczytaniu danych oraz dokonaniu \r\nobliczeń program powinien ponownie drukować menu.\r\n</p>', '#include <iostream.h>\r\n\r\nint mojemenu();\r\n\r\nvoid polekola();\r\nvoid polekwadratu();\r\nvoid poletrapezu();\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  int wybor;\r\n\r\n\r\n  wybor=mojemenu();\r\n  while (wybor != 0)\r\n    {\r\n      switch (wybor){\r\n        case 1: polekola();\r\n                break;\r\n        case 2: polekwadratu();\r\n                break;\r\n        case 3: poletrapezu();\r\n                break;\r\n      };//switch\r\n    wybor=mojemenu();\r\n    }\r\n  return 0;\r\n}\r\n\r\n\r\nint mojemenu(){\r\n  int odp;\r\n\r\n  cout << "\\n======[ MENU GLOWNE ]======\\n"\r\n       << "0 - wyjscje" << endl\r\n       << "1 - pole kola" << endl\r\n       << "2 - pole kwadratu" << endl\r\n       << "3 - pole trapezu" << endl;\r\n       cin >> odp;\r\n  return odp;\r\n}\r\n\r\n\r\nvoid polekola(){\r\n  float r;\r\n\r\n  cout << "\\n======[ POLE KOLA ]======\\n";\r\n  cout << "r=";\r\n  cin >> r;\r\n  cout << "P=" << 3.14 * r * r;\r\n  cout << endl;\r\n}\r\n\r\n\r\nvoid polekwadratu(){\r\n  float a;\r\n\r\n  cout << "\\n======[ POLE KWADRATU ]======\\n";\r\n  cout << "a=";\r\n  cin >> a;\r\n  cout << "P=" << a * a;\r\n  cout << endl;\r\n}\r\n\r\n\r\nvoid poletrapezu(){\r\n  float a,b,h;\r\n\r\n  cout << "\\n======[ POLE TRAPEZU ]======\\n";\r\n  cout << "a=";\r\n  cin >> a;\r\n  cout << "b=";\r\n  cin >> b;\r\n  cout << "h=";\r\n  cin >> h;\r\n  cout << "P=" << (a + b)*h/2;\r\n  cout << endl;\r\n}\r\n\r\n\r\n\r\n\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(168, 25, 4, '<p>\r\nNapisz program obliczający objętość kuli, \r\nsześcianu, prostopadłościanu i stożka. \r\nProgram ma działać na analogicznie jak program z poprzedniego zadania.\r\nMenu programu oferuje dostępne operacje (koniec pracy, \r\nwyznaczania objętości kuli, \r\nwyznaczanie objętości sześcianu itd.) \r\nProgram kończy pracę po wybraniu opcji koniec. \r\nZa każdym razem, gdy użytkownik wybierze opcję realizującą \r\nobliczenia po wykonaniu obliczeń program ma wydrukować menu.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(169, 25, 5, '<p>\r\nNapisz program przeliczający waluty. \r\nKwoty podane w dolarach amerykańskich, \r\neuro oraz funtach brytyjskich przeliczamy na \r\nkwoty wyrażone w złotówkach. \r\nProgram ma posiadać menu i działać \r\nna zasadach opisanych w poprzednich zadaniach.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(170, 25, 6, '<p>\r\nNapisz program kalkulator umożliwiający wykonywanie \r\nczterech działań arytmetycznych. \r\nProgram ma posiadać menu i działać \r\nna zasadach opisanych w poprzednich zadaniach.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(171, 25, 7, '<p>\r\nNapisz program z menu tak, \r\nby zmienna sterująca instrukcji switch była typu char.\r\n</p>', '#include <iostream.h>\r\n\r\nint main(int argc, char **argv)\r\n{\r\n   char a;\r\n\r\n   cout << " Nacisnij jeden z klawiszy T,N,R,?" << endl\r\n        << "Uwaga: duże litery są odróżniane od małych!" << endl;\r\n\r\n   cin >> a;\r\n\r\n   switch (a)\r\n     {\r\n       case ''T'': cout << "\\nTAK\\n"; break;\r\n       case ''N'': cout << "\\nNIE\\n"; break;\r\n       case ''R'': cout << "\\nRACZEJ NIE\\n"; break;\r\n       case ''?'': cout << "\\nNIE WIEM\\n"; break;\r\n     };\r\n\r\n    system("Pause");\r\n	return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(172, 25, 8, '<p>\r\nNapisz program zamieniający temperaturę \r\nwyrażoną w stopniach Celsjusza \r\nna temperaturę wyrażoną w stopniach \r\nFahrenheita zgodnie ze \r\nwzorem <em>TC = 5/9(TF-32)</em>. \r\nProgram ma działać podobnie do \r\npoprzedniego programu: po każdorazowym \r\nwykonaniu obliczeń użytkownik jest \r\npytany <em>Czy powtórzyć obliczenia (T/N)?</em> \r\nW przypadku udzielenia odpowiedzi <span class="variable">T</span> \r\n(litera <span class="variable">T</span> \r\nnaciśnięta na klawiaturze) obliczenia są kontynuowane. \r\nJeśli użytkownik naciśnie przycisk <span class="variable">N</span> \r\nprogram kończy pracę. \r\nProgram powinien reagować jedynie na klawisze <span class="variable">T</span> \r\noraz <span class="variable">N</span>. \r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(173, 26, 1, '<p>\r\nDany jest plik tekstowy \r\n<span class="filename">liczby.txt</span>,\r\nzawierający liczby całkowite i białe znaki \r\n(spacje, tabulatory i znaki złamania wiersza). \r\nPrzykładowa zawartość pliku może wyglądać następująco:\r\n</p>\r\n\r\n\r\n\r\n<pre>\r\n1 -2     3    -4\r\n5\r\n\r\n-6\r\n\r\n   7\r\n\r\n     -8   9   10\r\n\r\n\r\n</pre>\r\n\r\n\r\n\r\n\r\n\r\n\r\n<p>\r\nNapisz program, \r\nktóry wydrukuje na ekranie liczby \r\nodczytane z pliku oraz policzy ich sumę.\r\n</p>\r\n\r\n', '#include <fstream.h>\r\n#include <stdlib.h>\r\n#include <iostream.h>\r\n\r\n\r\n\r\nint main(int argc, char **argv)\r\n{\r\n  ifstream pin;\r\n  int rob;\r\n  int suma = 0;\r\n\r\n\r\n  cout << "\\nSUMA LICZB CAŁKOWITYCH Z PLIKU\\n";\r\n\r\n  pin.open("liczby.txt");\r\n\r\n  if (!pin){\r\n      cout << "\\nBLAD OTWARCIA!\\n";\r\n      system ("Pause");\r\n      return 1;\r\n    }\r\n\r\n  while (pin >> rob) {\r\n    cout << rob << endl;\r\n    suma += rob;\r\n  }\r\n\r\n  cout << "\\n\\n=========\\n"\r\n       << " SUMA = " << suma << "\\n\\n\\n";\r\n\r\n  pin.close();\r\n\r\n\r\n  system ("Pause");       \r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(174, 27, 1, '<p>\r\nNapisz program definiujący zmienną typu \r\n<span class="variable">int</span> \r\noraz wskaźnik do zmiennej typu <span class="variable">int</span>. \r\nProgram powinien wczytać z klawiatury \r\nwartość i podstawić ją do zmiennej \r\nstosując wskaźnik i operator adresu (nie stosuj operatora <span class="variable">new</span>).\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(175, 27, 2, '<p>\r\nNapisz program definiujący zmienną typu \r\n<span class="variable">TData</span> oraz wskaźnik do \r\nzmiennej typu <span class="variable">TData</span>. \r\nProgram powinien wczytać z klawiatury wartości \r\npól zmiennej. Zastosuj wskaźnik i operator \r\nadresu (nie stosuj operatora <span class="variable">new</span>).\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(176, 27, 3, '<p>\r\nNapisz program definiujący zmienną typu \r\n<span class="variable">TStudent</span> oraz \r\nwskaźnik do zmiennej typu <span class="variable">TStudent</span>. \r\nProgram powinien wczytać z klawiatury wartości \r\npól zmiennej. Zastosuj wskaźnik i \r\noperator adresu (nie stosuj operatora <span class="variable">new</span>).\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(177, 28, 1, '<p>\r\nNapisz program, \r\nktóry dynamicznie zaalokuje zmienną typu <span class="variable">int</span>. \r\nProgram powinien wczytać z klawiatury wartość \r\ni podstawić ją do zaalokowanej zmiennej. \r\nNastępnie program powinien wydrukować na \r\nekranie wartość zmiennej, po czym zwolnić pamięć i zakończyć działanie.\r\n</p>', '//ZADANIE 12.2.1\r\n\r\n#include <iostream.h>\r\nint main(int argc, char* argv[])\r\n{\r\n  int *wsk;\r\n\r\n  wsk = new int;\r\n\r\n  cout << "n=";\r\n  cin >> *wsk;\r\n  cout << "\\n\\n-----\\n\\n";\r\n  cout << "n=";\r\n  cout << *wsk;\r\n  cout << endl << endl;\r\n  delete wsk;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(178, 28, 2, '<p>\r\nNapisz program, \r\nktóry zawiera definicję struktury <span class="variable">TData</span>. \r\nW programie dynamicznie utwórz zmienną typu \r\n<span class="variable">TData</span>, \r\nnastępnie wczytaj z klawiatury wartości pól, \r\npo czym wczytane informacje wydrukuj na ekranie. \r\nPrzed zakończeniem programu \r\nusuń zmienną operatorem <span class="variable">delete</span>.\r\n</p>', '//ZADANIE 12.2.2\r\n\r\n#include <iostream.h>\r\n\r\nstruct TData{\r\n  int d,m,r;\r\n};\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  TData *wsk;\r\n\r\n  wsk = new TData;\r\n\r\n  cout << "\\ndzien=";\r\n  cin >> wsk -> d;\r\n  cout << "\\nmiesiac=";\r\n  cin >> wsk->m;\r\n  cout << "\\nrok=";\r\n  cin >> wsk->r;\r\n\r\n  cout << "\\n\\n======\\n\\n";\r\n  cout << wsk->d << "-" << wsk->m << "-" << wsk->r << endl;\r\n\r\n  delete wsk;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(179, 28, 3, '<p>\r\nNapisz program, który zawiera \r\ndefinicję struktury <span class="variable">TStudent</span>. \r\nW programie dynamicznie utwórz \r\nzmienną typu <span class="variable">TStudent</span>, \r\nnastępnie wczytaj z klawiatury wartości \r\npól, po czym wczytane informacje \r\nwydrukuj na ekranie. Przed \r\nzakończeniem programu usuń zmienną operatorem <span class="variable">delete</span>.\r\n</p>', '//ZADANIE 12.2.3\r\n\r\n#include <iostream.h>\r\n\r\nstruct TData{\r\n  int d,m,r;\r\n};\r\n\r\nstruct TStudent{\r\n  string imie,nazwisko;\r\n  TData ur;\r\n};\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  TStudent *wsk;\r\n\r\n  wsk = new TStudent;\r\n\r\n  cout << "\\n\\nimie=";\r\n  cin >> (*wsk).imie;\r\n  cout << "\\n\\nnazwisko=";\r\n  cin >> (*wsk).nazwisko;\r\n  cout << "\\ndata urodzenia";\r\n  cout << "\\n   dzien = ";\r\n  cin >> (*wsk).ur.d;\r\n  cout << "\\n   miesiac = ";\r\n  cin >> (*wsk).ur.m;\r\n  cout << "\\n   rok = ";\r\n  cin >> (*wsk).ur.r;\r\n\r\n  cout << "\\n\\n-----\\n\\n";\r\n  cout << (*wsk).imie;\r\n  cout << "\\n\\n-----\\n\\n";\r\n  cout << (*wsk).nazwisko;\r\n  cout << "\\n\\n-----\\n\\n";\r\n  cout << (*wsk).ur.d << "-" << (*wsk).ur.m << "-" << (*wsk).ur.r << endl;\r\n  cout << "\\n\\n-----\\n\\n";\r\n\r\n  delete wsk;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(180, 29, 1, '<p>\r\nNapisz definicję dziesięcioelementowej tablicy wskaźników \r\ndo liczb całkowitych. \r\nNapisz program, który wykorzystując zadeklarowaną \r\ntablicę wczytuje z klawiatury dziesięć liczb, \r\na następnie drukuje wczytane liczby na ekranie. \r\nPamiętaj o alokacji i zwolnieniu pamięci operatorami <span class="variable">new</span> \r\noraz \r\n<span class="variable">delete</span>.\r\n</p>', '//ZADANIE 12.3.1\r\n\r\n#include <iostream.h>\r\nint main(int argc, char* argv[])\r\n{\r\n  int *wsk[10];\r\n\r\n\r\n  //Alokacja\r\n  for(int i=0;i<10;i++)\r\n    wsk[i] = new int;\r\n\r\n  //Wczytanie\r\n  for(int i=0;i<10;i++){\r\n    cout << "liczba nr " << i << " = ";\r\n    cin >> *wsk[i];\r\n  }\r\n\r\n  cout << "\\n##############################\\n";\r\n\r\n  //Wydruk\r\n  for(int i=0;i<10;i++){\r\n    cout << "liczba nr " << i << " = " << *wsk[i] << endl;\r\n  }\r\n\r\n\r\n  //Zwolnienie pamieci\r\n  for(int i=0;i<10;i++)\r\n    delete wsk[i];\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(181, 29, 2, '<p>\r\nNapisz definicję dziesięcioelementowej \r\ntablicy wskaźników do struktur \r\n<span class="variable">TData</span>. \r\nNapisz program, który wykorzystując \r\nzadeklarowaną tablicę wczytuje z \r\nklawiatury dziesięć dat, a \r\nnastępnie drukuje wczytane daty \r\nna ekranie. Pamiętaj o \r\nalokacji i zwolnieniu pamięci \r\noperatorami <span class="variable">new</span> oraz \r\n<span class="variable">delete</span>.\r\n</p>', '//ZADANIE 12.3.2\r\n\r\n#include <iostream.h>\r\n\r\nstruct TData{\r\n  int d,m,r;\r\n};\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  TData *wsk[5];\r\n\r\n\r\n  //Alokacja\r\n  for(int i=0;i<5;i++)\r\n    wsk[i] = new TData;\r\n\r\n  //Wczytanie\r\n  for(int i=0;i<5;i++){\r\n    cout << "data nr " << i << endl;\r\n    cout << "dzien=";\r\n    cin >> wsk[i]->d;\r\n    cout << "miesiac=";\r\n    cin >> wsk[i]->m;\r\n    cout << "rok=";\r\n    cin >> wsk[i]->r;\r\n  }\r\n\r\n  cout << "\\n##############################\\n";\r\n\r\n  //Wydruk\r\n  for(int i=0;i<5;i++){\r\n    cout << "data nr " << i << " : "\r\n         << wsk[i]->d << "-"\r\n         << wsk[i]->m << "-"\r\n         << wsk[i]->r << endl;\r\n  }\r\n\r\n  //Zwolnienie pamieci\r\n  for(int i=0;i<5;i++)\r\n    delete wsk[i];\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(182, 29, 3, '<p>\r\nNapisz definicję dziesięcioelementowej tablicy \r\nwskaźników do struktur <span class="variable">TStudent</span>. \r\nNapisz program, który wykorzystując \r\nzadeklarowaną tablicę wczytuje z \r\nklawiatury informacje o dziesięciu studentach, \r\na następnie drukuje wczytane \r\ndane na ekranie. Pamiętaj \r\no alokacji i zwolnieniu pamięci operatorami <span class="variable">new</span> \r\noraz <span class="variable">delete</span>.\r\n</p>', '//ZADANIE 12.3.3\r\n\r\n#include <iostream.h>\r\n\r\nstruct TData{\r\n  int d,m,r;\r\n};\r\n\r\nstruct TStudent{\r\n  string imie,nazwisko;\r\n  TData ur;\r\n};\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  TStudent *wsk[5];\r\n\r\n\r\n  //Alokacja\r\n  for(int i=0;i<5;i++)\r\n    wsk[i] = new TStudent;\r\n\r\n  //Wczytanie\r\n  for(int i=0;i<5;i++){\r\n    cout << "student nr " << i << endl;\r\n    cout << "imie=";\r\n    cin >> wsk[i]->imie;\r\n    cout << "nazwisko=";\r\n    cin >> wsk[i]->nazwisko;\r\n    cout << "data urodzenia\\ndzien=";\r\n    cin >> wsk[i]->ur.d;\r\n    cout << "miesiac=";\r\n    cin >> wsk[i]->ur.m;\r\n    cout << "rok=";\r\n    cin >> wsk[i]->ur.r;\r\n  }\r\n\r\n  cout << "\\n##############################\\n";\r\n\r\n  //Wydruk\r\n  for(int i=0;i<5;i++){\r\n    cout << "***student nr " << i << " : "\r\n         << wsk[i]->imie << " "\r\n         << wsk[i]->nazwisko << " ur."\r\n         << wsk[i]->ur.d << "-"\r\n         << wsk[i]->ur.m << "-"\r\n         << wsk[i]->ur.r << endl;\r\n  }\r\n\r\n  //Zwolnienie pamieci\r\n  for(int i=0;i<5;i++)\r\n    delete wsk[i];\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(183, 30, 1, '<p>\r\nNapisz funkcję <span class="variable">UstalLiczbeCalkowita</span>, \r\nktóra zwraca jako wartość wskaźnik \r\ndo zmiennej typu <span class="variable">int</span>. \r\nZadaniem funkcji jest zaalokowanie zmiennej \r\noraz ustalenie jej wartości (wartość zmiennej wczytujemy z klawiatury). \r\n</p>\r\n\r\n\r\n<p>\r\nNapisz program spradzający działanie funkcji.\r\n</p>\r\n', '//ZADANIE 12.4.1.a\r\n\r\n#include <iostream.h>\r\n\r\nint *UstalInt(void){\r\n  int *tmp = new int;\r\n  cout << "  liczba = ";\r\n  cin >> *tmp;\r\n  return tmp;\r\n};\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  int *wsk;\r\n\r\n  wsk = UstalInt();\r\n\r\n  cout << "\\n\\n-----\\n\\n";\r\n  cout << "n=";\r\n  cout << *wsk;\r\n  cout << endl << endl;\r\n  delete wsk;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(184, 30, 2, '<p>\r\nNapisz funkcję \r\n<span class="variable">UstalDate()</span>, \r\nktóra zwraca jako wartość wskaźnik do \r\nzmiennej typu <span class="variable">TData</span>. \r\nZadaniem funkcji jest zaalokowanie \r\nzmiennej oraz ustalenie wartości jej \r\npól (wartości pól zmiennej wczytujemy z klawiatury). \r\n</p>\r\n\r\n\r\n<p>\r\nNapisz program sprawdzający działanie funkcji.\r\n</p>\r\n', '//ZADANIE 12.4.2.a\r\n\r\n#include <iostream.h>\r\n\r\nstruct TData{\r\n  int d,m,r;\r\n};\r\n\r\nTData *UstalTData(void){\r\n  TData *tmp = new TData;\r\n\r\n  cout << "Dzien: ";\r\n  cin >> tmp -> d;\r\n  cout << "Miesiac: ";\r\n  cin >> tmp -> m;\r\n  cout << "Rok: ";\r\n  cin >> tmp -> r;\r\n\r\n  return tmp;\r\n};\r\n\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  TData *wsk;\r\n\r\n  wsk = UstalTData();\r\n\r\n  cout << "\\n\\n======\\n\\n";\r\n  cout << wsk->d << "-" << wsk->m << "-" << wsk->r << endl;\r\n\r\n  delete wsk;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(185, 30, 3, '<p>\r\nNapisz funkcję <span class="variable">UstalDaneStudenta()</span>, \r\nktóra zwraca jako wartość wskaźnik do \r\nzmiennej typu <span class="variable">TStudent</span>. \r\nZadaniem funkcji jest zaalokowanie zmiennej \r\noraz ustalenie wartości jej \r\npól (wartości pól zmiennej wczytujemy z klawiatury).\r\n</p>\r\n\r\n\r\n<p>\r\nNapisz program testujący działanie funkcji.\r\n</p>\r\n', '//ZADANIE 12.4.3.a\r\n\r\n#include <iostream.h>\r\n\r\nstruct TData{\r\n  int d,m,r;\r\n};\r\n\r\nstruct TStudent{\r\n  string imie,nazwisko;\r\n  TData ur;\r\n};\r\n\r\nTStudent *UstalTStudent(void){\r\n  TStudent *tmp = new TStudent;\r\n  cout << "Imie: ";\r\n  cin >> tmp -> imie;\r\n  cout << "Nazwisko: ";\r\n  cin >> tmp -> nazwisko;\r\n  cout << "Data Urodzenia\\n  dzien: ";\r\n  cin >> tmp -> ur . d;\r\n  cout << "  miesiac: ";\r\n  cin >> tmp -> ur . m;\r\n  cout << "  rok: ";\r\n  cin >> tmp -> ur . r;\r\n\r\n  return tmp;\r\n};\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  TStudent *wsk;\r\n\r\n  wsk = UstalTStudent();\r\n\r\n  cout << "\\n\\n-----\\n\\n";\r\n  cout << (*wsk).imie;\r\n  cout << "\\n\\n-----\\n\\n";\r\n  cout << (*wsk).nazwisko;\r\n  cout << "\\n\\n-----\\n\\n";\r\n  cout << (*wsk).ur.d << "-" << (*wsk).ur.m << "-" << (*wsk).ur.r << endl;\r\n  cout << "\\n\\n-----\\n\\n";\r\n\r\n  delete wsk;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(186, 30, 4, '<p>\r\nNapisz funkcję <span class="variable">UstalDaneSamochodu()</span>, \r\nktóra zwraca jako wartość \r\nwskaźnik do zmiennej typu <span class="variable">TSamochod</span>. \r\nZadaniem funkcji jest zaalokowanie \r\nzmiennej oraz ustalenie wartości jej \r\npól (wartości pól zmiennej wczytujemy z klawiatury).\r\n</p>\r\n\r\n\r\n<p>\r\nNapisz program testujący działanie funkcji.\r\n</p>\r\n', '//ZADANIE 12.4.4.a\r\n\r\n#include <iostream.h>\r\n\r\nstruct TSamochod{\r\n  string marka;\r\n  string model;\r\n  int rocznik;\r\n};\r\n\r\nTSamochod *UstalTSamochod(void){\r\n  TSamochod *w;\r\n\r\n  w = new TSamochod;\r\n\r\n  cout << "\\nmarka=";\r\n  cin >> w -> marka;\r\n  cout << "model=";\r\n  cin >> w -> model;\r\n  cout << "rocznik=";\r\n  cin >> w -> rocznik;\r\n\r\n  return w;\r\n};\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  TSamochod *w;\r\n\r\n  w=UstalTSamochod();\r\n\r\n  cout << "\\n\\n-----\\n\\n";\r\n  cout << w -> marka;\r\n  cout << "\\n\\n-----\\n\\n";\r\n  cout << w -> model;\r\n  cout << "\\n\\n-----\\n\\n";\r\n  cout << w -> rocznik;\r\n  cout << "\\n\\n-----\\n\\n";\r\n\r\n  delete w;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(187, 30, 5, '<p>\r\nWykorzystując funkcję <span class="variable">UstalLiczbeCalkowita</span>, \r\nnapisz program, który\r\nzaalokuje, wczyta, wydrukuje i usunie z pamięci 10 liczb całkowitych.\r\n</p>', '//ZADANIE 12.4.1.b\r\n\r\n#include <iostream.h>\r\n\r\nint *UstalInt(void){\r\n  int *tmp = new int;\r\n  cout << "  liczba = ";\r\n  cin >> *tmp;\r\n  return tmp;\r\n};\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  int *wsk[10];\r\n\r\n\r\n  //Alokacja\r\n  for(int i=0;i<10;i++)\r\n    wsk[i] = new int;\r\n\r\n  //Wczytanie\r\n  for(int i=0;i<10;i++)\r\n    wsk[i] = UstalInt();\r\n\r\n  cout << "\\n##############################\\n";\r\n\r\n  //Wydruk\r\n  for(int i=0;i<10;i++){\r\n    cout << "liczba nr " << i << " = " << *wsk[i] << endl;\r\n  }\r\n\r\n  //Zwolnienie pamieci\r\n  for(int i=0;i<10;i++)\r\n    delete wsk[i];\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(188, 30, 6, '<p>\r\nWykorzystując funkcję <span class="variable">UstalDate()</span>, \r\nnapisz program, który\r\nzaalokuje, wczyta, wydrukuje i usunie z pamięci 10 \r\nzmiennych <span class="variable">TData</span>.\r\n</p>', '//ZADANIE 12.4.2.b\r\n\r\n#include <iostream.h>\r\n\r\nstruct TData{\r\n  int d,m,r;\r\n};\r\n\r\nTData *UstalTData(void){\r\n  TData *tmp = new TData;\r\n\r\n  cout << "Dzien: ";\r\n  cin >> tmp -> d;\r\n  cout << "Miesiac: ";\r\n  cin >> tmp -> m;\r\n  cout << "Rok: ";\r\n  cin >> tmp -> r;\r\n\r\n  return tmp;\r\n};\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  TData *wsk[5];\r\n\r\n\r\n  //Alokacja i wczytanie\r\n  for(int i=0;i<5;i++)\r\n    wsk[i] = UstalTData();\r\n\r\n  cout << "\\n##############################\\n";\r\n\r\n  //Wydruk\r\n  for(int i=0;i<5;i++){\r\n    cout << "data nr " << i << " : "\r\n         << wsk[i]->d << "-"\r\n         << wsk[i]->m << "-"\r\n         << wsk[i]->r << endl;\r\n  }\r\n\r\n  //Zwolnienie pamieci\r\n  for(int i=0;i<5;i++)\r\n    delete wsk[i];\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(189, 30, 7, '<p>\r\nWykorzystując funkcję <span class="variable">UstalDaneStudenta()</span>,\r\nnapisz program, który\r\nzaalokuje, wczyta, wydrukuje i usunie z pamięci 10 \r\nzmiennych <span class="variable">TStudent</span>.\r\n</p>', '//ZADANIE 12.4.3.b\r\n\r\n#include <iostream.h>\r\n\r\nstruct TData{\r\n  int d,m,r;\r\n};\r\n\r\nstruct TStudent{\r\n  string imie,nazwisko;\r\n  TData ur;\r\n};\r\n\r\nTStudent *UstalTStudent(void){\r\n  TStudent *tmp = new TStudent;\r\n  cout << "Imie: ";\r\n  cin >> tmp -> imie;\r\n  cout << "Nazwisko: ";\r\n  cin >> tmp -> nazwisko;\r\n  cout << "Data Urodzenia\\n  dzien: ";\r\n  cin >> tmp -> ur . d;\r\n  cout << "  miesiac: ";\r\n  cin >> tmp -> ur . m;\r\n  cout << "  rok: ";\r\n  cin >> tmp -> ur . r;\r\n\r\n  return tmp;\r\n};\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  TStudent *wsk[5];\r\n\r\n\r\n  //Alokacja i wczytanie\r\n  for(int i=0;i<5;i++)\r\n    wsk[i] = UstalTStudent();\r\n\r\n  cout << "\\n##############################\\n";\r\n\r\n  //Wydruk\r\n  for(int i=0;i<5;i++){\r\n    cout << "***student nr " << i << " : "\r\n         << wsk[i]->imie << " "\r\n         << wsk[i]->nazwisko << " ur."\r\n         << wsk[i]->ur.d << "-"\r\n         << wsk[i]->ur.m << "-"\r\n         << wsk[i]->ur.r << endl;\r\n  }\r\n\r\n  //Zwolnienie pamieci\r\n  for(int i=0;i<5;i++)\r\n    delete wsk[i];\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(190, 31, 1, '<p>\r\nNapisz funkcję \r\n<span class="variable">WymianaInt()</span>. \r\nParametrami funkcji mają być dwa \r\nwskaźniki do zmiennych typu <span class="variable">int</span>. \r\nZadaniem funkcji jest wymiana wartości zmiennych.\r\nProgram ma fizycznie przesunąć z \r\njednego miejsca pamięci w drugie wartości zmiennych!\r\n</p>\r\n\r\n<p>\r\nNapisz program, który stosując funkcję \r\n<span class="variable">WymianaInt()</span> \r\nwymienia wartościami dwie zmienne automatyczne \r\noraz dwie zmienne dynamiczne. \r\nWartości wszystkich zmiennych wczytaj \r\nz klawiatury. Po dokonaniu wymiany wydrukuj wartości \r\nzmiennych na ekranie.\r\n</p>\r\n', '#include <iostream.h>\r\n#include <stdlib.h>\r\n\r\nvoid WymianaInt(int *p1, int *p2){\r\n  int ptmp;\r\n\r\n  ptmp = *p1;\r\n  *p1 = *p2;\r\n  *p2 = ptmp;\r\n}\r\n\r\nint main(int argc, char* argv[]){\r\n  int z1 = 300, z2 = 666;\r\n  int *pa,*pb;\r\n\r\n  pa = new int(33);\r\n  pb = new int(45);\r\n\r\n  cout << "WARTOSCI PRZED ZMIANA:  a = " << *pa << "  b = " << *pb << endl << endl;\r\n\r\n  WymianaInt(pa,pb);\r\n\r\n  cout << "WARTOSCI PO ZMNINIE:  a = " << *pa << "  b = " << *pb << endl << endl;\r\n\r\n\r\n  cout << "\\n\\n================================\\n\\n";\r\n\r\n  cout << "WARTOSCI PRZED ZMIANA:  z1 = " << z1 << "  z2 = " << z2 << endl << endl;\r\n\r\n  WymianaInt( &z1 , &z2);\r\n\r\n  cout << "WARTOSCI PO ZMIANIE:  z1 = " << z1 << "  z2 = " << z2 << endl << endl;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(191, 31, 2, '<p>\r\nNapisz funkcję <span class="variable">WymianaWskInt()</span>. \r\nParametrami funkcji mają być dwa \r\nwskaźniki do wskaźników do zmiennych typu <span class="variable">int</span>. \r\nZadaniem funkcji jest wymiana \r\nwartości zmiennych.\r\nFunkcja ma wymienić wskaźniki do zmiennych, a nie wartości zmiennych.\r\nNapisz program, który stosując funkcję \r\n<span class="variable">WymianaWskInt()</span> \r\nwymienia wartościami dwie zmienne dynamiczne. \r\nWartości wszystkich zmiennych wczytaj z klawiatury. \r\nPo dokonaniu wymiany wydrukuj wartości zmiennych na ekranie. \r\nCzy funkcja <span class="variable">WymianaWskInt()</span> \r\nmoże zostać użyta do wymiany wartości zmiennych statycznych?\r\n</p>\r\n\r\n\r\n\r\n<p>\r\nFunkcja <span class="variable">WymianaInt()</span> \r\nz poprzedniego zadania jest identyczna z funkcją:\r\n</p>\r\n\r\n\r\n<pre>\r\nvoid zmien(int &amp;p1, int &amp;p2){\r\n  int ptmp;\r\n\r\n  ptmp = p1;\r\n  p1   = p2;\r\n  p2   = ptmp;\r\n}\r\n</pre>\r\n\r\n\r\n\r\n<p>\r\nFunkcje te różnią się jedynie nagłówkiem. \r\nW przypadku, gdy parametry \r\n<span class="variable">p1</span> oraz \r\n<span class="variable">p2</span> są \r\ndużymi strukturami wówczas kopiowanie całych struktur \r\nmoże być czasochłonne. \r\nWtedy funkcja te jest nieefektywna (niewydajna).\r\n</p>\r\n\r\n\r\n\r\n<p>\r\nFunkcja <span class="variable">WymianaWskInt()</span> \r\nwymienia jedynie wskaźniki do danych. \r\nZatem wymiana danych (bez względu na ich wielkość) \r\nzawsze będzie równie wydajna. \r\nNiestety funkcji nie można użyć do zmiennych automatycznych. \r\nCo więcej, ponieważ wskaźniki są \r\nfaktycznie zmiennymi typu <span class="variable">unsigned long</span>, \r\nzatem zamiast tej funkcji możemy stosować \r\npowyższą funkcję <span class="variable">zmien()</span> \r\n(stosując odpowiednio operator rzutowania). \r\nPonadto funkcja <span class="variable">zmien()</span> \r\nmoże być użyta do wymiany wskaźników do dowolnego typu.\r\nEwentualna pułapka polega na tym, że nie w \r\nkażdym kompilatorze C++ wskaźnik musi \r\nbyć zgodny z typem <span class="variable">unsigned long</span>.\r\n</p>\r\n\r\n', '#include <iostream.h>\r\n#include <stdlib.h>\r\n\r\nvoid WymianaWskInt(int **p1, int **p2){\r\n  int *ptmp;\r\n\r\n  ptmp = *p1;\r\n  *p1 = *p2;\r\n  *p2 = ptmp;\r\n}\r\n\r\nvoid zmien(int &p1, int &p2){\r\n  int ptmp;\r\n\r\n  ptmp = p1;\r\n  p1   = p2;\r\n  p2   = ptmp;\r\n}\r\n\r\nint main(int argc, char* argv[]){\r\n  int *pa,*pb;\r\n\r\n  pa = new int(33);\r\n  pb = new int(45);\r\n\r\n  cout << "ADRESY PRZED ZMIANA: pa = " << pa << "  pb = " << pb << endl << endl;\r\n  cout << "WARTOSCI PRZED ZMIANA:  a = " << *pa << "  b = " << *pb << endl << endl;\r\n\r\n  WymianaWskInt(&pa,&pb);\r\n\r\n  cout << "WARTOSCI PO ZMNINIE:  a = " << *pa << "  b = " << *pb << endl << endl;\r\n  cout << "ADRESY PO ZMIANIE: pa = " << pa << "  pb = " << pb << endl << endl;\r\n\r\n  zmien((int)pa , (int)pb);\r\n\r\n  cout << "WARTOSCI PO ZMNINIE:  a = " << *pa << "  b = " << *pb << endl << endl;\r\n  cout << "ADRESY PO ZMIANIE: pa = " << pa << "  pb = " << pb << endl << endl;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(192, 31, 3, '<p>\r\nNapisz funkcję \r\n<span class="variable">WymianaTData()</span>. \r\nParametrami funkcji mają być \r\ndwa wskaźniki do zmiennych typu <span class="variable">TData</span>. \r\nZadaniem funkcji jest wymiana wartości zmiennych.\r\nNapisz program, który stosując funkcję \r\n<span class="variable">WymianaTData()</span> \r\nwymienia wartościami dwie zmienne \r\nstatyczne oraz dwie zmienne \r\nautomatyczne. Wszystkie dane wczytaj \r\nz klawiatury. Po dokonaniu \r\nwymiany wydrukuj wartości zmiennych na ekranie.\r\n</p>', '#include <iostream.h>\r\n#include <stdlib.h>\r\n\r\nstruct TData{\r\n  int d,m,r;\r\n};\r\n\r\nvoid WymianaTData(TData *p1, TData *p2){\r\n  TData ptmp;\r\n\r\n  ptmp = *p1;\r\n  *p1 = *p2;\r\n  *p2 = ptmp;\r\n}\r\n\r\nvoid DrukujTData(TData d){\r\n  cout << d.d << "-" << d.m << "-" << d.r;\r\n};\r\n\r\n\r\nint main(int argc, char* argv[]){\r\n\r\n  TData day1 = {31,12,2003};\r\n  TData day2 = {1,11,1999};\r\n\r\n  cout << "WARTOSCI PRZED ZMIANA:  day1 = ";\r\n  DrukujTData(day1);\r\n  cout << "  day2 = ";\r\n  DrukujTData(day2);\r\n  cout << endl << endl;\r\n\r\n  WymianaTData(&day1,&day2);\r\n\r\n  cout << "WARTOSCI PO ZMIANIE:  day1 = ";\r\n  DrukujTData(day1);\r\n  cout << "  day2 = ";\r\n  DrukujTData(day2);\r\n  cout << endl << endl;\r\n\r\n  cout << "\\n\\n===================================\\n\\n";\r\n\r\n  TData *wd1 = new TData;\r\n  wd1 -> d =3;\r\n  wd1 -> m =4;\r\n  wd1 -> r =2005;\r\n\r\n  TData *wd2 = new TData;\r\n  wd2 -> d =1;\r\n  wd2 -> m =1;\r\n  wd2 -> r =2000;\r\n\r\n\r\n  cout << "WARTOSCI PRZED ZMIANA:  wd1 = ";\r\n  DrukujTData(*wd1);\r\n  cout << "  wd2 = ";\r\n  DrukujTData(*wd2);\r\n  cout << endl << endl;\r\n\r\n  WymianaTData(wd1,wd2);\r\n\r\n  cout << "WARTOSCI PO ZMIANIE:  wd1 = ";\r\n  DrukujTData(*wd1);\r\n  cout << "  wd2 = ";\r\n  DrukujTData(*wd2);\r\n  cout << endl << endl;\r\n\r\n\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(193, 31, 4, '<p>\r\nNapisz funkcję \r\n<span class="variable">WymianaWskTData()</span>. \r\nParametrami funkcji mają być \r\ndwa wskaźniki do wskażników do zmiennych \r\ntypu <span class="variable">TData</span>. \r\nZadaniem funkcji jest wymiana \r\nwartości zmiennych.\r\nNapisz program, który stosując funkcję \r\n<span class="variable">WymianaWskTData()</span> \r\nwymienia wartościami dwie zmienne \r\ndynamiczne. Wszystkie dane wczytaj z \r\nklawiatury. Po dokonaniu wymiany \r\nwydrukuj wartości zmiennych na ekranie.\r\nW programie użyj również funkcji <span class="variable">zmien()</span> oraz \r\noperatora rzutowania do wymiany zmiennych.\r\n</p>', '#include <iostream.h>\r\n#include <stdlib.h>\r\n\r\nstruct TData{\r\n  int d,m,r;\r\n};\r\n\r\nvoid WymianaTData(TData **p1, TData **p2){\r\n  TData *ptmp;\r\n\r\n  ptmp = *p1;\r\n  *p1 = *p2;\r\n  *p2 = ptmp;\r\n}\r\n\r\nvoid zmien(int &p1, int &p2){\r\n  int ptmp;\r\n\r\n  ptmp = p1;\r\n  p1   = p2;\r\n  p2   = ptmp;\r\n}\r\n\r\nvoid DrukujTData(TData d){\r\n  cout << d.d << "-" << d.m << "-" << d.r;\r\n};\r\n\r\n\r\nint main(int argc, char* argv[]){\r\n\r\n  TData *wd1 = new TData;\r\n  wd1 -> d =3;\r\n  wd1 -> m =4;\r\n  wd1 -> r =2005;\r\n\r\n  TData *wd2 = new TData;\r\n  wd2 -> d =1;\r\n  wd2 -> m =1;\r\n  wd2 -> r =2000;\r\n\r\n\r\n  cout << "WARTOSCI PRZED ZMIANA:  wd1 = ";\r\n  DrukujTData(*wd1);\r\n  cout << "  wd2 = ";\r\n  DrukujTData(*wd2);\r\n  cout << endl << endl;\r\n\r\n  WymianaTData(&wd1,&wd2);\r\n\r\n  cout << "WARTOSCI PO ZMIANIE:  wd1 = ";\r\n  DrukujTData(*wd1);\r\n  cout << "  wd2 = ";\r\n  DrukujTData(*wd2);\r\n  cout << endl << endl;\r\n\r\n\r\n  cout << "\\n\\n===================================\\n\\n";\r\n\r\n  cout << "WARTOSCI PRZED ZMIANA:  wd1 = ";\r\n  DrukujTData(*wd1);\r\n  cout << "  wd2 = ";\r\n  DrukujTData(*wd2);\r\n  cout << endl << endl;\r\n\r\n  zmien((int)wd1, (int) wd2 );\r\n\r\n  cout << "WARTOSCI PO ZMIANIE:  wd1 = ";\r\n  DrukujTData(*wd1);\r\n  cout << "  wd2 = ";\r\n  DrukujTData(*wd2);\r\n  cout << endl << endl;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(194, 31, 5, '<p>\r\nNapisz funkcję \r\n<span class="variable">WymianaTStudent()</span>. \r\nParametrami funkcji mają być dwa \r\nwskaźniki do zmiennych typu <span class="variable">TStudent</span>. \r\nZadaniem funkcji jest wymiana wartości \r\nzmiennych.\r\nNapisz program, który stosując \r\nfunkcję <span class="variable">WymianaTStudent()</span> \r\nwymienia wartościami dwie zmienne \r\nautomatyczne oraz dwie zmienne \r\ndynamiczne. Wszystkie dane \r\nwczytaj z klawiatury. Po dokonaniu \r\nwymiany wydrukuj wartości zmiennych na ekranie.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(195, 31, 6, '<p>\r\nNapisz funkcję \r\n<span class="variable">WymianaWskTStudent()</span>. \r\nParametrami funkcji mają \r\nbyć dwa wskaźniki do wskaźników do zmiennych \r\ntypu <span class="variable">TStudent</span>. \r\nZadaniem funkcji jest wymiana wartości zmiennych.\r\nNapisz program, który stosując \r\nfunkcję <span class="variable">WymianaWskTStudent()</span> \r\nwymienia wartościami dwie zmienne dynamiczne. \r\nWszystkie dane wczytaj z klawiatury. \r\nPo dokonaniu wymiany wydrukuj wartości \r\nzmiennych na ekranie.\r\nW programie użyj również funkcji <span class="variable">zmien()</span> \r\noraz operatora rzutowania do wymiany zmiennych.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(196, 31, 7, '<p>\r\nNapisz funkcję \r\n<span class="variable">WymianaTSamochod()</span>. \r\nParametrami funkcji mają być \r\ndwa wskaźniki do zmiennych typu <span class="variable">TSamochod</span>. \r\nZadaniem funkcji jest wymiana \r\nwartości zmiennych.\r\nNapisz program, który stosując \r\nfunkcję <span class="variable">WymianaTSamochod()</span> \r\nwymienia wartościami dwie zmienne \r\nautomatyczne oraz dwie zmienne dynamiczne. \r\nWszystkie dane wczytaj z klawiatury. \r\nPo dokonaniu wymiany wydrukuj wartości zmiennych na ekranie.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(197, 32, 1, '<p>\r\nNapisz funkcję <span class="variable">PorownajInt()</span> \r\nporównującą wartości dwóch liczb całkowitych. \r\nParametrami funkcji mają być dwa \r\nwskaźniki do zmiennych typu <span class="variable">int</span>, \r\nzaś jej wartością liczba całkowita. \r\nWynik funkcji ma być liczbą mniejszą \r\nod zera jeśli pierwsza z liczb jest \r\nmniejsza od drugiej, równy zero jeśli liczby \r\nsą sobie równe lub większa od zera w przypadku, \r\ngdy pierwsza liczba jest większa od drugiej.\r\nNapisz program, który wykorzystując funkcję \r\n<span class="variable">PorownajInt()</span> dokona \r\nporównania dwóch zmiennych automatycznych oraz \r\ndwóch zmiennych dynamicznych. Potrzebne informacje \r\nwczytaj z klawiatury, zaś wynik działania obydwu porównań wydrukuj na ekranie.\r\n</p>', '#include <iostream.h>\r\n#include <stdlib.h>\r\n\r\nint PorownajInt(int *a, int *b){\r\n  return *a - *b;\r\n}\r\n\r\nint main(int argc, char* argv[]){\r\n  int x = 37, y= 99;\r\n\r\n  if (PorownajInt(&x,&y) > 0)\r\n    cout << endl << x << " jest wieksze od " << y << endl;\r\n  else if (PorownajInt(&x,&y) == 0)\r\n    cout << endl << x << " jest rowne " << y << endl;\r\n  else\r\n    cout << endl << x << " jest mniejsze od " << y << endl;\r\n\r\n  int *w1 = new int (39);\r\n  int *w2 = new int (33);\r\n\r\n  if (PorownajInt(w1,w2) > 0)\r\n    cout << endl << *w1 << " jest wieksze od " << *w2 << endl;\r\n  else if (PorownajInt(w1,w2) == 0)\r\n    cout << endl << *w1 << " jest rowne " << *w2 << endl;\r\n  else\r\n    cout << endl << *w1 << " jest mniejsze od " << *w2 << endl;\r\n\r\n\r\n  cout << "\\n\\n===========================\\n\\n";\r\n  for (int i=0;i<5;i++){\r\n      x = random(1000);\r\n      y = random(1000);\r\n\r\n      if (PorownajInt(&x,&y) > 0)\r\n        cout << endl << x << " jest wieksze od " << y << endl;\r\n      else if (PorownajInt(&x,&y) == 0)\r\n        cout << endl << x << " jest rowne " << y << endl;\r\n      else\r\n        cout << endl << x << " jest mniejsze od " << y << endl;\r\n  }\r\n\r\n  cout << endl << endl;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(198, 32, 2, '<p>\r\nNapisz funkcję <span class="variable">PorownajTData()</span> \r\nporównującą wartości dwóch zmiennych typu \r\n<span class="variable">TData</span>. \r\nParametrami funkcji mają być \r\ndwa wskaźniki do zmiennych typu <span class="variable">TData</span>, \r\nzaś jej wartością liczba \r\ncałkowita. Wynik funkcji ma być liczbą mniejszą \r\nod zera jeśli pierwsza z dat jest wcześniejsza mniejsza \r\nod drugiej, równy zero jeśli daty są sobie \r\nrówne lub większa od zera w \r\nprzypadku, gdy pierwsza data jest \r\npóźniejsza od drugiej.\r\nNapisz program, który wykorzystując funkcję \r\n<span class="variable">PorownajTData()</span> \r\ndokona porównania dwóch zmiennych automatycznych \r\noraz dwóch zmiennych dynamicznych. \r\nPotrzebne informacje wczytaj z klawiatury, \r\nzaś wynik działania obydwu porównań wydrukuj na ekranie.\r\n</p>', 'TData {\r\n  int d,m,r;\r\n};\r\n\r\nint PorownajTData(TData *d1, TData *d2){\r\n  if (d1 -> r  ==  d2 -> r) {\r\n        if (d1 -> m  ==  d2 -> m) {\r\n            return d1 -> d - d2 -> d;\r\n        } else\r\n            return d1 -> m - d2 -> m;\r\n  } else\r\n      return d1 -> r - d2 -> r;\r\n}');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(199, 32, 3, '<p>\r\nNapisz funkcję \r\n<span class="variable">PorownajTStudent()</span> \r\nporównującą wartości dwóch zmiennych typu <span class="variable">TStudent</span>. \r\nParametrami funkcji mają być dwa \r\nwskaźniki do zmiennych typu <span class="variable">TStudent</span>, \r\nzaś jej wartością liczba całkowita. \r\nWynik funkcji ma nas informować o \r\nkolejności umieszczenia studentów na liście. \r\nPrzyjmujemy, że porządek nazwisk na liście jest \r\nleksykograficzny. W przypadku identycznych nazwisk bierzemy \r\npod uwagę imiona.\r\nWynik funkcji ma być liczbą mniejszą \r\nod zera, jeśli pierwszy ze studentów \r\npowinien się znaleźć na liście alfabetycznej przed \r\ndrugim, równy zero, jeśli imiona i nazwiska studentów \r\nsą sobie równe lub większa od zera w przypadku, gdy \r\npierwszy ze studentów powinien być umieszczony na liście \r\npo drugim studencie. \r\nNapisz program, który wykorzystując funkcję \r\n<span class="variable">PorownajTStudent()</span> \r\ndokona porównania dwóch zmiennych automatycznych oraz \r\ndwóch zmiennych dynamicznych. \r\nPotrzebne informacje wczytaj z klawiatury, \r\nzaś wynik działania obydwu porównań wydrukuj na ekranie.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(200, 32, 4, '<p>\r\nNapisz funkcję \r\n<span class="variable">PorownajTStudent2()</span>,\r\nporównującą wartości dwóch zmiennych typu <span class="variable">TStudent</span>. \r\nParametrami funkcji mają być dwa wskaźniki \r\ndo zmiennych typu <span class="variable">TStudent</span>, \r\nzaś jej wartością liczba całkowita. \r\nWynik funkcji ma nas informować o wieku studentów.\r\nWynik funkcji ma być liczbą mniejszą od \r\nzera, jeśli pierwszy ze studentów jest \r\nmłodszy od drugiego, równy zero, \r\njeśli studenci urodzili się tego samego \r\ndnia lub większa od zera w przypadku, \r\ngdy pierwszy ze studentów jest starszy od drugiego.\r\nNapisz program, który wykorzystując funkcję \r\n<span class="variable">PorownajTStudent2()</span> \r\ndokona porównania dwóch zmiennych automatycznych oraz dwóch \r\nzmiennych dynamicznych. \r\nPotrzebne informacje wczytaj z klawiatury, \r\nzaś wynik działania obydwu porównań wydrukuj na ekranie.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(201, 32, 5, '<p>\r\nNapisz funkcję \r\n<span class="variable">PorownajTSamochod()</span>,\r\nporównującą wartości dwóch zmiennych typu \r\n<span class="variable">TSamochod</span>. \r\nParametrami funkcji mają być dwa wskaźniki \r\ndo zmiennych typu <span class="variable">TSamochod</span>, \r\nzaś jej wartością liczba całkowita. \r\nWynik funkcji ma nas informować o \r\nporządku leksykograficznym marek samochodów.\r\nWynik funkcji ma być liczbą mniejszą \r\nod zera, jeśli marka pierwszego samochodu \r\njest leksykograficznie mniejsza od marki drugiego \r\nsamochodu. Jeśli marki są identyczne to funkcja \r\npowinna zwracać zero. Jeśli pierwsza marka jest \r\nleksykograficznie większa od drugiej, \r\nwówczas funkcja powinna zwracać wartość większą od zera.\r\nNapisz program, który wykorzystując \r\nfunkcję <span class="variable">PorownajTSamochod()</span> \r\ndokona porównania dwóch zmiennych automatycznych oraz \r\ndwóch zmiennych dynamicznych. \r\nPotrzebne informacje wczytaj z klawiatury, \r\nzaś wynik działania obydwu porównań wydrukuj na ekranie.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(202, 33, 1, '<p>\r\nNapisz funkcję \r\n<span class="variable">Sort2Int()</span> \r\nporządkującą rosnąco dwie \r\nzadane liczby typu <span class="variable">int</span>. \r\nParametrami funkcji mają być dwa wskaźniki \r\ndo zmiennych typu <span class="variable">int</span>. \r\nFunkcja ma za zadanie umieścić w pierwszym parametrze \r\nmniejszą z dwóch wartości, \r\nzaś w drugim &mdash; większą.\r\nNapisz program, który wykorzystując funkcję \r\n<span class="variable">Sort2Int()</span> \r\ndokona sortowania dwóch zmiennych automatycznych \r\noraz dwóch zmiennych dynamicznych. \r\nPotrzebne informacje wczytaj z klawiatury, \r\nzaś wynik działania (w obydwu przypadkach!) \r\nwydrukuj na ekranie.\r\nWykorzystaj funkcje <span class="variable">WymianaInt()</span>\r\noraz  <span class="variable">PorownajInt()</span>.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(203, 33, 2, '<p>\r\nNapisz funkcję \r\n<span class="variable">Sort2TData()</span> \r\nporządkującą rosnąco dwie zadane daty. \r\nParametrami funkcji mają być dwa \r\nwskaźniki do zmiennych typu <span class="variable">TData</span>. \r\nFunkcja ma za zadanie umieścić w \r\npierwszym parametrze mniejszą z dwóch wartości, \r\nzaś w drugim &mdash; większą.\r\nNapisz program, \r\nktóry wykorzystując funkcję \r\n<span class="variable">Sort2TData()</span> \r\ndokona sortowania dwóch zmiennych automatycznych \r\noraz dwóch zmiennych dynamicznych. \r\nPotrzebne informacje wczytaj z klawiatury, \r\nzaś wynik działania (w obydwu przypadkach) wydrukuj na ekranie.\r\nWykorzystaj funkcje <span class="variable">WymianaTData()</span> \r\noraz <span class="variable">PorownajTData()</span>.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(204, 33, 3, '<p>\r\nNapisz funkcję \r\n<span class="variable">Sort2TStudent()</span> \r\nporządkującą rosnąco (tj. alfabetycznie wg \r\nnazwisk oraz imion) dwie \r\nzmienne zawierające informacje o studentach. Parametrami \r\nfunkcji mają być dwa wskaźniki do zmiennych typu \r\n<span class="variable">TStudent</span>. \r\nFunkcja ma za zadanie umieścić w pierwszym \r\nparametrze mniejszą z dwóch wartości, \r\nzaś w drugim &mdash; większą.\r\nNapisz program, który wykorzystując \r\nfunkcję <span class="variable">Sort2TStudent()</span> \r\ndokona sortowania dwóch zmiennych automatycznych \r\noraz dwóch zmiennych dynamicznych. Potrzebne informacje wczytaj z klawiatury, zaś wynik działania (w obydwu przypadkach!) wydrukuj na ekranie.\r\nWykorzystaj funkcje <span class="variable">WymianaTStudent()</span>\r\noraz <span class="variable">PorownajTStudent()</span>.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(205, 33, 4, '<p>\r\nNapisz funkcję \r\n<span class="variable">Sort2TStudent2()</span> \r\nporządkującą rosnąco (pod względem wieku) \r\ndwie zmienne zawierające informacje o studentach. \r\nParametrami funkcji mają być dwa wskaźniki \r\ndo zmiennych typu <span class="variable">TStudent</span>. \r\nFunkcja ma za zadanie umieścić \r\nw pierwszym parametrze mniejszą z dwóch \r\nwartości, zaś w drugim &mdash; większą.\r\nNapisz program, \r\nktóry wykorzystując funkcję \r\n<span class="variable">Sort2TStudent2()</span> \r\ndokona sortowania dwóch zmiennych \r\nautomatycznych oraz dwóch zmiennych dynamicznych. \r\nPotrzebne informacje wczytaj z klawiatury, \r\nzaś wynik działania (w obydwu przypadkach) wydrukuj na ekranie.\r\nWykorzystaj funkcje <span class="variable">WymianaTStudent()</span>\r\noraz <span class="variable">PorownajTStudent2()</span>.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(206, 33, 5, '<p>\r\nNapisz funkcję \r\n<span class="variable">Sort2TSamochod()</span> \r\nporządkującą rosnąco (tj. alfabetycznie pod wg nmarki) \r\ndwie zmienne zawierające informacje o \r\nsamochodach. Parametrami funkcji mają być \r\ndwa wskaźniki do zmiennych typu <span class="variable">TSamochod</span>. \r\nFunkcja ma za zadanie umieścić w \r\npierwszym parametrze mniejszą z dwóch \r\nwartości, zaś w drugim &mdash; większą.\r\nNapisz program, który wykorzystując funkcję \r\n<span class="variable">Sort2TSamochod()</span> \r\ndokona sortowania dwóch zmiennych automatycznych \r\noraz dwóch zmiennych dynamicznych. Potrzebne \r\ninformacje wczytaj z klawiatury, zaś \r\nwynik działania (w obydwu przypadkach) wydrukuj na ekranie.\r\nWykorzystaj funkcje <span class="variable">WymianaTSamochod()</span>\r\n<span class="variable">PorownajTSamochod()</span>.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(207, 34, 1, '<p>\r\nNapisz funkcję \r\n<span class="variable">SortTabWsk()</span> porządkującą \r\nrosnąco tablicę wskaźników. \r\nParametrami funkcji mają być:\r\n</p>\r\n\r\n<ul>\r\n<li>tablica do posortowania,</li>\r\n<li>liczba elementów tablicy,</li>\r\n<li>wskaźnik do procedury porównującej dwa elementy tablicy.</li>\r\n</ul>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(208, 34, 2, '<p>\r\nNapisz program, który \r\nwykorzystując funkcję <span class="variable">SortTabWsk()</span> \r\nposortuje tablicę wskaźników \r\nliczb całkowitych. Potrzebne \r\ndane wczytaj z klawiatury, zaś wynik działania wydrukuj na ekranie.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(209, 34, 3, '<p>\r\nNapisz program, który wykorzystując funkcję \r\n<span class="variable">SortTabWsk()</span> posortuje \r\ntablicę wskaźników do zmiennych typu \r\n<span class="variable">TData</span>. \r\nPotrzebne dane wczytaj z klawiatury, \r\nzaś wynik działania wydrukuj na ekranie.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(210, 34, 4, '<p>\r\nNapisz program, który wykorzystując \r\nfunkcję <span class="variable">SortTabWsk()</span> \r\nposortuje tablicę wskaźników do zmiennych \r\ntypu <span class="variable">TStudent</span>. \r\nPotrzebne dane wczytaj z klawiatury, \r\nzaś wynik działania wydrukuj na ekranie.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(211, 35, 1, '<p>\r\nNapisz funkcję <span class="variable">SortTab()</span> \r\nporządkującą rosnąco tablicę elementów. \r\nParametrami funkcji mają być:\r\n</p>\r\n\r\n<ul>\r\n<li>tablica do posortowania,</li>\r\n<li>liczba elementów tablicy,</li>\r\n<li>rozmiar elementu tablicy,</li>\r\n<li>wskaźnik do procedury porównującej dwa elementy tablicy.</li>\r\n</ul>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(212, 35, 2, '<p>\r\nNapisz program, \r\nktóry wykorzystując funkcję \r\n<span class="variable">SortTab</span> posortuje tablicę \r\nliczb całkowitych. \r\nPotrzebne dane wczytaj z klawiatury, \r\nzaś wynik działania wydrukuj na ekranie.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(213, 35, 3, '<p>\r\nNapisz program, który wykorzystując funkcję \r\n<span class="variable">SortTab()</span> posortuje \r\ntablicę zmiennych typu <span class="variable">TData</span>. \r\nPotrzebne dane wczytaj z klawiatury, \r\nzaś wynik działania wydrukuj na ekranie.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(214, 35, 4, '<p>\r\nNapisz program, który wykorzystując \r\nfunkcję <span class="variable">SortTab()</span> \r\nposortuje tablicę zmiennych typu <span class="variable">TStudent</span>. \r\nPotrzebne dane wczytaj z klawiatury, \r\nzaś wynik działania wydrukuj na ekranie.\r\n</p>', '');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(215, 36, 1, '<p>\r\nPodaj definicję klasy <span class="variable">TData</span>. \r\nNiech wszystkie pola klasy będą polami publicznymi. \r\nKlasa nie powinna zawierać żadnych metod.\r\n</p>', '#include <iostream.h>\r\n\r\nclass TData{\r\npublic:\r\n  int d,m,r;\r\n};\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  TData kiedy;\r\n\r\n  cout << "Dzien: ";\r\n  cin >> kiedy.d;\r\n  cout << "Miesiac: ";\r\n  cin >> kiedy.m;\r\n  cout << "Rok: ";\r\n  cin >> kiedy.r;\r\n\r\n  cout << "\\n\\n=====================================\\n\\n";\r\n\r\n  cout << kiedy.r << "-"\r\n       << kiedy.m << "-"\r\n       << kiedy.d << endl << endl;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(216, 36, 2, '<p>\r\nNapisz program, który \r\ndefiniuje zmienną automatyczną klasy \r\n<span class="variable">TData</span>. \r\nUstal wartości pól wczytując je z klawiatury. \r\nNastępnie wydrukuj na ekranie wczytane wartości .\r\n</p>', '#include <iostream.h>\r\n\r\nclass TData{\r\npublic:\r\n  int d,m,r;\r\n};\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  TData *kiedy;\r\n\r\n  kiedy = new TData;\r\n\r\n  cout << "Dzien: ";\r\n  cin >> kiedy->d;\r\n  cout << "Miesiac: ";\r\n  cin >> kiedy->m;\r\n  cout << "Rok: ";\r\n  cin >> kiedy->r;\r\n\r\n  cout << "\\n\\n=====================================\\n\\n";\r\n\r\n  cout << kiedy->r << "-"\r\n       << kiedy->m << "-"\r\n       << kiedy->d << endl << endl;\r\n\r\n  delete kiedy;     \r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(217, 37, 1, '<p>\r\nZdefiniuj klasę <span class="variable">TData</span>. \r\nNiech wszystkie pola klasy będą prywatne, \r\ndo ustalania wartości pól z klawiatury \r\ni drukowania wartości pól na \r\nekranie zaimplementuj bezparametrowe metody \r\n<span class="variable">Wczytaj()</span>, \r\n<span class="variable">Drukuj()</span>.\r\n</p>', '#include <iostream.h>\r\n\r\nclass TData{\r\nprivate:\r\n  int d,m,r;\r\npublic:\r\n  void Wczytaj(void);\r\n  void Drukuj(void);\r\n};\r\n\r\nvoid TData::Wczytaj(void){\r\n  cout << "Dzien: ";\r\n  cin >> d;\r\n  cout << "Miesiac: ";\r\n  cin >> m;\r\n  cout << "Rok: ";\r\n  cin >> r;\r\n}\r\n\r\nvoid TData::Drukuj(void){\r\n  cout << r << "-" << m << "-" << d << endl;\r\n}\r\n\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  TData kiedy;\r\n\r\n\r\n  kiedy.Wczytaj();\r\n\r\n  kiedy.Drukuj();\r\n\r\n  // cout << kiedy.r;  BLAD !!!! pola prywatne są niewidoczne!\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(218, 37, 2, '<p>\r\nNapisz program, który definiuje zmienną \r\nautomatyczną klasy <span class="variable">TData</span>, \r\na następnie wywołaj metody <span class="variable">Wczytaj()</span> \r\noraz <span class="variable">Drukuj()</span>.\r\n</p>', '#include <iostream.h>\r\n\r\nclass TData{\r\nprivate:\r\n  int d,m,r;\r\npublic:\r\n  void Wczytaj(void);\r\n  void Drukuj(void);\r\n};\r\n\r\nvoid TData::Wczytaj(void){\r\n  cout << "Dzien: ";\r\n  cin >> d;\r\n  cout << "Miesiac: ";\r\n  cin >> m;\r\n  cout << "Rok: ";\r\n  cin >> r;\r\n}\r\n\r\nvoid TData::Drukuj(void){\r\n  cout << r << "-" << m << "-" << d << endl;\r\n}\r\n\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  TData *kiedy;\r\n\r\n  kiedy = new TData;\r\n\r\n  kiedy->Wczytaj();\r\n\r\n  kiedy->Drukuj();\r\n\r\n  delete kiedy;\r\n\r\n  system("Pause");\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(219, 38, 1, '<p>\r\nZdefiniuj klasę \r\n<span class="variable">TData</span>. \r\nKlasa powinna posiadać:\r\n</p>\r\n\r\n<ul>\r\n<li>konstruktor kopiujący,</li>\r\n<li>konstruktor domniemany,</li>\r\n<li>dwa dodatkowe konstruktory różniące się parametrami,</li>\r\n<li>destruktor.</li>\r\n</ul>', '#include <iostream.h>\r\n\r\nclass TData{\r\nprivate:\r\n  int d,m,r;\r\npublic:\r\n\r\n  //konstruktor domniemany\r\n  TData(void);                    //K1\r\n\r\n  //konstruktory różniące sie parametrami (przeciążone)\r\n  TData(int Ad, int Am, int Ar);  //K2\r\n  TData(int);                     //K3\r\n\r\n  //konstruktor kopiujący\r\n  TData(TData &);                 //K4\r\n\r\n  //destruktor\r\n  ~TData(void);\r\n\r\n  void Wczytaj(void);\r\n  void Drukuj(void);\r\n};\r\n\r\nvoid TData::Wczytaj(void){\r\n  cout << "Dzien: ";\r\n  cin >> d;\r\n  cout << "Miesiac: ";\r\n  cin >> m;\r\n  cout << "Rok: ";\r\n  cin >> r;\r\n}\r\n\r\nvoid TData::Drukuj(void){\r\n  cout << "  " << r << "-" << m << "-" << d << "  ";\r\n}\r\n\r\n//K1\r\n//Konstruktor domniemany\r\nTData::TData(void){\r\n  cout << " Konstruktor K1:   ";\r\n  d = 29;\r\n  m = 2;\r\n  r = 2004;\r\n};\r\n\r\n//K2\r\n//konstruktory różniące sie parametrami (przeciążone)\r\nTData::TData(int Ad, int Am, int Ar){\r\n  cout << " Konstruktor K2:   ";\r\n  d = Ad;\r\n  m = Am;\r\n  r = Ar;\r\n};\r\n\r\n//K3\r\n//konstruktory różniące sie parametrami (przeciążone)\r\nTData::TData(int roczek){\r\n  cout << " Konstruktor K3:   ";\r\n  d = 1;\r\n  m = 1;\r\n  r = roczek;\r\n};\r\n\r\n//K4\r\n//Konstruktor kopiujący\r\nTData::TData(TData &Ad){\r\n  cout << " Konstruktor K4:   ";\r\n  d = Ad.d;\r\n  m = Ad.m;\r\n  r = Ad.r;\r\n};\r\n\r\n\r\n//Destruktor\r\nTData::~TData(void){\r\n  cout << "  Destruktor ";\r\n}\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  //Przykład 1\r\n  cout << "\\nPrzyklad 1.\\n";\r\n  TData p1; // wywoła się K1\r\n\r\n  p1.Drukuj();\r\n\r\n  cout << endl <<endl;\r\n  system("Pause");\r\n\r\n\r\n\r\n  //Przykład 2\r\n  cout << endl <<endl;\r\n  cout << "\\nPrzyklad 2.\\n";\r\n\r\n  TData p2(1,9,1793); // wywoła się K2\r\n\r\n  p2.Drukuj();\r\n\r\n  cout << endl <<endl;\r\n  system("Pause");\r\n\r\n\r\n\r\n  //Przykład 3\r\n  cout << endl <<endl;\r\n  cout << "\\nPrzyklad 3.\\n";\r\n\r\n  TData p3(966); // wywoła się K3\r\n\r\n  p3.Drukuj();\r\n\r\n  cout << endl <<endl;\r\n  system("Pause");\r\n\r\n\r\n\r\n  //Przykład 4\r\n  cout << endl <<endl;\r\n  cout << "\\nPrzyklad 4.\\n";\r\n\r\n  TData p4a(966); // wywoła się K3\r\n  TData p4b(p4a);  // wywoła się K4\r\n\r\n  p4a.Drukuj();\r\n  p4b.Drukuj();\r\n\r\n  cout << endl <<endl;\r\n  system("Pause");\r\n\r\n\r\n  //Przykład 5\r\n  cout << endl <<endl;\r\n  cout << "\\nPrzyklad 5.\\n";\r\n\r\n  TData p5(966); // wywoła się K3\r\n\r\n  p5.Drukuj();\r\n\r\n  p5.~TData(); // Wywoła się destruktor\r\n\r\n  cout << endl <<endl;\r\n  system("Pause");\r\n\r\n  //Przykład 6\r\n  if (1){\r\n  cout << endl <<endl;\r\n  cout << "\\nPrzyklad 6.\\n";\r\n\r\n  TData p6(1914); // wywoła się K3\r\n\r\n  p6.Drukuj();\r\n\r\n\r\n\r\n  cout << endl <<endl;\r\n  system("Pause");\r\n  // tutaj Wywoła się destruktor\r\n  }\r\n\r\n\r\n  cout << "\\n##### KONIEC #####\\n";\r\n  system("Pause");\r\n\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(220, 38, 2, '<p>\r\nNapisz program, \r\nktóry definiuje zmienną automatyczną klasy \r\n<span class="variable">TData</span>. \r\nW programie wywołaj wszystkie \r\nmetody klasy <span class="variable">TData</span>.\r\n</p>', '#include <iostream.h>\r\n\r\nclass TData{\r\nprivate:\r\n  int d,m,r;\r\npublic:\r\n\r\n  //konstruktor domniemany\r\n  TData(void);                    //K1\r\n\r\n  //konstruktory różniące sie parametrami (przeciążone)\r\n  TData(int Ad, int Am, int Ar);  //K2\r\n  TData(int);                     //K3\r\n\r\n  //konstruktor kopiujący\r\n  TData(TData &);                 //K4\r\n\r\n  //destruktor\r\n  ~TData(void);\r\n\r\n  void Wczytaj(void);\r\n  void Drukuj(void);\r\n};\r\n\r\nvoid TData::Wczytaj(void){\r\n  cout << "Dzien: ";\r\n  cin >> d;\r\n  cout << "Miesiac: ";\r\n  cin >> m;\r\n  cout << "Rok: ";\r\n  cin >> r;\r\n}\r\n\r\nvoid TData::Drukuj(void){\r\n  cout << "  " << r << "-" << m << "-" << d << "  ";\r\n}\r\n\r\n//K1\r\n//Konstruktor domniemany\r\nTData::TData(void){\r\n  cout << " Konstruktor K1:   ";\r\n  d = 29;\r\n  m = 2;\r\n  r = 2004;\r\n};\r\n\r\n//K2\r\n//konstruktory różniące sie parametrami (przeciążone)\r\nTData::TData(int Ad, int Am, int Ar){\r\n  cout << " Konstruktor K2:   ";\r\n  d = Ad;\r\n  m = Am;\r\n  r = Ar;\r\n};\r\n\r\n//K3\r\n//konstruktory różniące sie parametrami (przeciążone)\r\nTData::TData(int roczek){\r\n  cout << " Konstruktor K3:   ";\r\n  d = 1;\r\n  m = 1;\r\n  r = roczek;\r\n};\r\n\r\n//K4\r\n//Konstruktor kopiujący\r\nTData::TData(TData &Ad){\r\n  cout << " Konstruktor K4:   ";\r\n  d = Ad.d;\r\n  m = Ad.m;\r\n  r = Ad.r;\r\n};\r\n\r\n\r\n//Destruktor\r\nTData::~TData(void){\r\n  cout << "  Destruktor ";\r\n}\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n  //Przykład 1\r\n  cout << "\\nPrzyklad 1.\\n";\r\n  TData *p1 = new TData; // wywoła się K1\r\n\r\n  p1 -> Drukuj();\r\n\r\n  delete p1;  //wywoła się destruktor\r\n\r\n  cout << endl <<endl;\r\n  system("Pause");\r\n\r\n\r\n\r\n  //Przykład 2\r\n  cout << endl <<endl;\r\n  cout << "\\nPrzyklad 2.\\n";\r\n\r\n  TData *p2 = new TData(1,9,1793); // wywoła się K2\r\n\r\n  p2 -> Drukuj();\r\n\r\n  delete p2;  //wywoła się destruktor\r\n\r\n  cout << endl <<endl;\r\n  system("Pause");\r\n\r\n\r\n\r\n  //Przykład 3\r\n  cout << endl <<endl;\r\n  cout << "\\nPrzyklad 3.\\n";\r\n\r\n  TData *p3=new TData(966); // wywoła się K3\r\n\r\n  p3 -> Drukuj();\r\n\r\n  delete p3;  //wywoła się destruktor  \r\n\r\n  cout << endl <<endl;\r\n  system("Pause");\r\n\r\n\r\n\r\n  //Przykład 4\r\n  cout << endl <<endl;\r\n  cout << "\\nPrzyklad 4.\\n";\r\n\r\n  TData *p4a = new TData(966); // wywoła się K3\r\n  TData *p4b = new TData(*p4a);  // wywoła się K4\r\n\r\n  p4a -> Drukuj();\r\n  p4b -> Drukuj();\r\n\r\n  cout << endl <<endl;\r\n  system("Pause");\r\n\r\n\r\n  //Przykład 5\r\n  cout << endl <<endl;\r\n  cout << "\\nPrzyklad 5.\\n";\r\n\r\n  TData *p5 = new TData (966); // wywoła się K3\r\n\r\n  p5 -> Drukuj();\r\n\r\n  p5 -> ~TData(); // Wywoła się destruktor\r\n\r\n  delete p5;  //wywoła się destruktor - po raz drugi\r\n\r\n  cout << endl <<endl;\r\n  system("Pause");\r\n\r\n  //Przykład 6\r\n  if (1){\r\n  cout << endl <<endl;\r\n  cout << "\\nPrzyklad 6.\\n";\r\n\r\n  TData *p6 = new TData(1914); // wywoła się K3\r\n\r\n  p6 -> Drukuj();\r\n\r\n\r\n\r\n  cout << endl <<endl;\r\n  system("Pause");\r\n\r\n  delete p6;  //wywoła się destruktor\r\n  }\r\n\r\n\r\n  cout << "\\n##### KONIEC #####\\n";\r\n  system("Pause");\r\n\r\n  return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(221, 39, 1, '<p>\r\nNapisz funkcję wzorcową <span class="variable">min()</span> \r\nwyznaczającą minimum dwóch argumentów. \r\nNiech funkcja pobiera jako argumenty dwa parametry \r\nbędące klasami typu <span class="variable">T</span>. \r\nZaimplementowaną funkcję wykorzystaj w \r\nprogramie do wyznaczenia minimum z \r\ndwóch liczb całkowitych oraz z dwóch napisów. \r\nPotrzebne dane pobierz z klawiatury.\r\n</p>', '#include <iostream.h>\r\n\r\ntemplate <class T>\r\nT min(T a, T b)\r\n{\r\n    if (a<b)\r\n        return a;\r\n    else\r\n        return b;\r\n}\r\n\r\n\r\nint main(int argc, char* argv[])\r\n{\r\nint a, b;\r\n\r\ncout << "Przyklad uzycia funkcji min dla typu int:\\n";\r\n\r\ncout << "a = ";\r\ncin  >> a;\r\ncout << "b = ";\r\ncin  >> b;\r\n\r\ncout << "MIN( " << a << '','' << b << " ) = "\r\n    << min (a,b) << endl;\r\n\r\nstring s1, s2;\r\n\r\ncout << "Przyklad uzycia funkcji min dla typu string:\\n";\r\n\r\ncout << "s1 = ";\r\ncin  >> s1;\r\ncout << "s2 = ";\r\ncin  >> s2;\r\n\r\ncout << "MIN( " << s1 << '','' << s2 << " ) = "\r\n     << min(s1, s2) << endl;\r\n\r\nsystem("pause");\r\nreturn 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(222, 39, 2, '<p>\r\nNapisz funkcje wzorcowe <span class="variable">swap()</span> \r\noraz <span class="variable">sort2()</span>. \r\nZadaniem funkcji <span class="variable">swap()</span> \r\njest wymiana wartości dwóch zmiennych, \r\nzaś funkcja <span class="variable">sort2()</span> \r\npowinna sortować dwóch porządku \r\nrosnącym dwie zmienne będące jej \r\nparametrami. Niech funkcje pobierają \r\njako argumenty parametry będące klasami \r\ntypu <span class="variable">T</span>. \r\nZaimplementowane funkcje wykorzystaj w programie \r\ndo sortowania zmiennych typu <span class="variable">int</span> oraz \r\n<span class="variable">string</span>. \r\nPotrzebne dane pobierz z klawiatury.\r\n</p>', '#include <iostream.h>\r\n\r\ntemplate <class T>\r\nvoid swap(T &a, T &b){\r\n  T tmp;\r\n  tmp = a;\r\n  a = b;\r\n  b = tmp;\r\n}\r\n\r\ntemplate <class T>\r\nvoid sort2(T &a, T &b){\r\n  if (a>b)\r\n    swap(a,b);\r\n}\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n    int a, b;\r\n\r\n    cout << "Przyklad uzycia funkcji sort2 dla typu int:\\n";\r\n\r\n    cout << "a = ";\r\n    cin >> a;\r\n    cout << "b = ";\r\n    cin >> b;\r\n\r\n    sort2(a,b);\r\n\r\n    cout << a << endl << b << endl;\r\n\r\n\r\n    string s1, s2;\r\n\r\n    cout << "Przyklad uzycia funkcji sort2 dla typu string:\\n";\r\n\r\n    cout << "s1 = ";\r\n    cin >> s1;\r\n    cout << "s2 = ";\r\n    cin >> s2;\r\n\r\n    sort2(s1,s2);\r\n\r\n    cout << s1 << endl << s2 << endl;\r\n\r\n    system("pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(223, 39, 3, '<p>\r\nNapisz funkcję wzorcową zwracającą najmniejszy element tablicy. \r\nZaimplementowaną  funkcję wykorzystaj w programie \r\ndo znalezienia najmniejsze liczby w \r\ntablicy liczb całkowitych oraz najmniejszego napisu \r\nw tablicy napisów. Potrzebne dane pobierz z klawiatury.\r\n</p>', '#include <iostream>\r\n#include <string>\r\n\r\nusing namespace std;\r\n\r\ntemplate <class T>\r\nT MaxTab(T a[], int ile){\r\n  T wynik = a[0];\r\n  for(int i=1;i<ile;i++){\r\n      if (a[i]>wynik){\r\n          wynik = a[i];\r\n      }\r\n  }\r\n  return wynik;\r\n}\r\n\r\nint main(int argc, char* argv[])\r\n{\r\n    int *tabint;\r\n    int  n;\r\n\r\n    cout << "Przyklad dynamicznej alokacji tablicy"\r\n         << " i definicji funkcji wzorcowej\\n";\r\n\r\n    cout << "liczba elementow = ";\r\n    cin >> n;\r\n\r\n    if (n>0) {\r\n        tabint = new int[n];\r\n\r\n        for (int i=0; i<n; i++){\r\n          cout << "element " << i << " = ";\r\n          cin >> tabint[i];\r\n        }\r\n        cout << "\\n===== MAX = "<< MaxTab(tabint,n) << " ====\\n";\r\n        delete []tabint;\r\n    } else {\r\n        cout << "\\n\\nZbyt mala liczba elementow!\\n\\n";\r\n    }\r\n\r\n    string *tabstr;\r\n    \r\n    cout << "Uzycie dla typu string\\n\\n";\r\n\r\n    cout << "liczba elementow = ";\r\n    cin >> n;\r\n\r\n    if (n>0) {\r\n        tabstr = new string[n];\r\n\r\n        for (int i=0; i<n; i++){\r\n          cout << "element " << i << " = ";\r\n          cin >> tabstr[i];\r\n        }\r\n        cout << "\\n===== MAX = "<< MaxTab(tabstr,n) << " ====\\n";\r\n        delete []tabstr;\r\n    } else {\r\n        cout << "\\n\\nZbyt mala liczba elementow!\\n\\n";\r\n    }\r\n\r\n\r\n\r\n\r\n    system("pause");\r\n    return 0;\r\n}\r\n\r\n');
INSERT INTO `zadanie` (`zadanie_id`, `rozdzial_id`, `numer`, `tekst`, `rozwiazanie`) VALUES(224, 39, 4, '<p>\r\nNapisz funkcję wzorcową sortującą tablicę \r\ndanych. Zaimplementowaną  funkcję wykorzystaj w \r\nprzykładowym programie. Potrzebne dane pobierz z klawiatury.\r\n</p>', '');
