SET NAMES utf8 COLLATE utf8_polish_ci;

DROP DATABASE IF EXISTS wiersze;

CREATE DATABASE wiersze DEFAULT CHARACTER SET utf8 COLLATE utf8_polish_ci;

GRANT
    ALL
ON
    wiersze.*
TO
    poeta@localhost
IDENTIFIED BY
    'rymrymrym';

FLUSH PRIVILEGES;

USE wiersze;
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- poeta
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `poeta`;


CREATE TABLE `poeta`
(
	`poeta_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`imie` VARCHAR(45),
	`nazwisko` VARCHAR(45),
	PRIMARY KEY (`poeta_id`)
)Type=MyISAM;

#-----------------------------------------------------------------------------
#-- wiersz
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `wiersz`;


CREATE TABLE `wiersz`
(
	`wiersz_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`poeta_id` INTEGER  NOT NULL,
	`tytul` VARCHAR(255),
	`tekst` TEXT,
	PRIMARY KEY (`wiersz_id`),
	INDEX `FI__01` (`poeta_id`),
	CONSTRAINT `Rel_01`
		FOREIGN KEY (`poeta_id`)
		REFERENCES `poeta` (`poeta_id`)
		ON DELETE RESTRICT
)Type=MyISAM;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 2.11.1
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 07 Maj 2008, 09:40
-- Wersja serwera: 5.0.45
-- Wersja PHP: 5.2.4

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

--
-- Baza danych: `wiersze`
--

--
-- Zrzut danych tabeli `poeta`
--

INSERT INTO `poeta` (`poeta_id`, `imie`, `nazwisko`) VALUES(1, 'Julian', 'Tuwim');
INSERT INTO `poeta` (`poeta_id`, `imie`, `nazwisko`) VALUES(2, 'Leopold', 'Staff');
INSERT INTO `poeta` (`poeta_id`, `imie`, `nazwisko`) VALUES(3, 'Kazimierz', 'Przerwa-Tetmajer');
INSERT INTO `poeta` (`poeta_id`, `imie`, `nazwisko`) VALUES(4, 'Adam', 'Asnyk');
INSERT INTO `poeta` (`poeta_id`, `imie`, `nazwisko`) VALUES(5, 'Maria', 'Konopnicka');
INSERT INTO `poeta` (`poeta_id`, `imie`, `nazwisko`) VALUES(6, 'Tadeusz', 'Różewicz');

--
-- Zrzut danych tabeli `wiersz`
--

INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(1, 1, 'Banalna historia', 'Zadzwoniła do niego rano,\r\nBardzo wcześnie, jeszcze przed ósmą.\r\nW mózgu miała noc nie przespaną\r\nI ból, co na chwilę nie usnął.\r\nW sercu miała ciężar rozpaczy.\r\nPowiedziała: "Halo, to ty?\r\nZaraz muszę się z tobą zobaczyć".\r\nI po twarzy, do słuchawki, łzy.\r\nOdpowiedział: "Co za awantura?\r\nNie mam czasu dziś przed obiadem,\r\nDobrze wiesz, że muszę iść do biura.\r\nUspokój się nie lubię przesady".\r\nPowiedziała: "Jeśli nawet nie możesz,\r\nTo koniecznie przyjdź, bo..." - "Bo co?"\r\nZapłakała: "Boże! Boże! Boże!"\r\nRzucił: "Dobrze. Tylko nie płacz. No!"\r\nSpotkali się w pustej cukierence.\r\nCukiernie rano są puste.\r\nI puste jest serce dziewczęce,\r\nGdy je rozpacz przepełnia, nic więcej.\r\nPrzyszedł z miną na smutno szlachetną\r\n(Każdy z nas to umie, gdy chce);\r\n"Kawa czy herbata?" - "Wszystko jedno..."\r\n"Może ciastko?" - Dziękuję. Nie".\r\n"Co się stało?" Uśmiechnęła się blado:\r\n"Co się stało? Nic..." - "Więc dlaczego płaczesz?"\r\n"Płaczę? Myślałam, że się uśmiecham...\r\nTo tak trudno odróżnić czasem.\r\nAch, i mówić tak trudno, gdy słowa\r\nSą te same, a czuje się różnie.\r\nAle ja ci zaraz powiem, wszystko powiem..."\r\n- "Tylko, proszę cię, prędko, bo się spóźnię".\r\nI zaczęła jak wniebowzięta,\r\nJak w natchnieniu, chorobliwie, gorączkowo,\r\nDygotały nieszczęśliwe rączęta,\r\nKołysała się rozpalona głowa.\r\nNawet kelner poczuł litość dla niej\r\nI pomyślał: "Coś tam złego jest,\r\nTrzeba podać drugi cukier tej pani,\r\nBo jej kawa zgorzknieje od łez".\r\nCo mówiła - ja nie wiem niestety.\r\nSądzę nawet, że to wszystko jedno.\r\nAle wy - wy, dziewczyny i kobiety,\r\nZnacie dobrze tę mowę obłędną!\r\nGdy skończyła - spojrzała na niego\r\nJak zbity pies... wzrokiem oniemiałym...\r\n- "Hm (powiedział), to nic nowego,\r\nJuż to wszystko sto razy słyszałem!"\r\nI tu nagle -błysk w oczach dziewczyny,\r\nJakby ktoś ją obudził - i powiada:\r\n"A myślałam, że to mówię, mój jedyny,\r\nPierwsza!! pierwsza od początku świata!!!"\r\n-------\r\nTeraz wszystko już wiemy. Naturalnie!\r\nBo cóż mogła innego uczynić,\r\nJak do domu iść i najbanalniej\r\nMałą kartkę zostawić w sypialni:\r\n"Proszę nikogo nie winić".');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(2, 1, 'Biologia', 'Baby latem biodrzeją.\r\nSoki w babach się grzeją,\r\nOwoc żywy dojrzewa,\r\nLep żywiczny wre w drzewach. \r\nPłeć się pławi płodziwa,\r\nBuchaj ciołę pokrywa,\r\nMleczem tłustym się klei\r\nW rozjuszonej nadziei. \r\nDyszy ziemia - kobyła,\r\nWymion dwoje w świat wzbiła,\r\nByk wiecznego żywota\r\nBiałym ślepiem żar miota. \r\nRoztopiły się pola,\r\nRozstąpiła się rola\r\nI w czarnoziem tętniący\r\nTrysnął białun gorący');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(3, 2, 'Brona', 'Słońce za wzgórze się chyli\r\nI senną ziemię ozłaca.\r\nO, wielka ciszo tej chwili,\r\nGdy duch się zmierzchem wzbogaca!\r\n\r\nNa nieboskłonie dnia pomnym\r\nCiemną sylwetą się czerni\r\nChłop na swym koniu ogromnym\r\nWlokącym bronę po ścierni.\r\n\r\nCo krok koń ciężkim łbem kiwa,\r\nZ trudem stąpając pod wzgórek.\r\nSpod kopyt jego się zrywa\r\nStado spłoszonych przepiórek.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(4, 2, 'Chleb', 'Wiecznie tak samo jeszcze jak za czasów Piasta,\r\nPo łokcie umączone ręce dzierżąc w dzieży,\r\nZakwasem zaczyniony chleb ugniata świeży\r\nPrzejęta swym odwiecznym obrządkiem niewiasta.\r\n\r\nGdy wedle doświadczenia niechybnych probieży,\r\nNazajutrz ugniot miary właściwej dorasta,\r\nPierzyną ciepłą kryje pulchne ciało ciasta,\r\nKędy cierpliwie pory wypieku doleży.\r\n\r\nI uklepawszy w płaskie półkule miąższ miękki\r\nW gorący piec je wsuwa na długiej kociubie,\r\nSkąd roztaczając zapach kuszący i miły\r\n\r\nWychodzą wnet pożywne, razowe bochenki,\r\nBrunatne i okrągłe - ku piekarki chlubie -\r\nJak widnokrąg zoranych pól, co chleb zrodziły.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(5, 3, 'Czarna róża', 'Serce me spało, a moja myśl\r\ntoneła gdzieś w lazurze,\r\nnagle ujrzałem przy sobie tuż\r\nskromniutką, czarną różę.\r\n\r\nWspaniałą krasą jej kwiat i liść\r\nbynajmniej się nie płoni,\r\na przecież dziwny jakiś czar\r\nprzykuwa wzrok mój do niej.\r\n\r\nCzarna różyczko! zerwę cię,\r\nna piersi przypnę sennej -\r\nserce się budzi - cóż to ma dłoń\r\nchwyta za kwiat kamienny!\r\n\r\nOdchodzę smutny - w tej chwili znów\r\nz kamienia kwiat wykwita;\r\nwracam - i znowu moja dłoń\r\nza zimny kamień chwyta.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(6, 4, 'Daremne żale', 'Daremne żale - próżny trud,\r\n Bezsilne złożeczenia!\r\nPrzeżytych kształtów żaden cud\r\n Nie wróci do istnienia.\r\n\r\nŚwiat wam nie odda, idąc wstcz,\r\n Znikomych mar szeregu -\r\nNie zdołaogień ani miecz\r\n Powstrzymać myśli w biegu.\r\n\r\nTrzeba żywymi naprzód iść,\r\n Po życie sięgać nowe...\r\nA nie w uwiędłych laurów liść,\r\n Z uporem stroić głowę.\r\n\r\nWy nie cofniecieżycia fal!\r\n Nic skargi nie pomogą -\r\nBezsilne gniewy, próżny żaL!\r\nŚwiat pójdzie swoją drogą.\r\n\r\nLwów 1880');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(7, 1, 'Do prostego człowieka', 'Gdy znów do murów klajstrem świeżym\r\nPrzylepiać zaczną obwieszczenia,\r\nGdy "do ludności", "do żołnierzy"\r\nNa alarm czarny druk uderzy\r\nI byle drab, i byle szczeniak\r\nW odwieczne kłamstwo ich uwierzy,\r\nŻe trzeba iść i z armat walić,\r\nMordować, grabić, truć i palić;\r\nGdy zaczną na tysięczną modłę\r\nOjczyznę szarpać deklinacją\r\nI łudzić kolorowym godłem,\r\nI judzić "historyczną racją",\r\nO piędzi, chwale i rubieży,\r\nO ojcach, dziadach i sztandarach,\r\nO bohaterach i ofiarach;\r\nGdy wyjdzie biskup, pastor, rabin\r\nPobłogosławić twój karabin,\r\nBo mu sam Pan Bóg szepnął z nieba,\r\nŻe za ojczyznę - bić się trzeba;\r\nKiedy rozścierwi się, rozchami\r\nWrzask liter pierwszych stron dzienników,\r\nA stado dzikich bab - kwiatami\r\nObrzucać zacznie "żołnierzyków". -\r\n- O, przyjacielu nieuczony,\r\nMój bliźni z tej czy innej ziemi!\r\nWiedz, że na trwogę biją w dzwony\r\nKróle z pannami brzuchatemi;\r\nWiedz, że to bujda, granda zwykła,\r\nGdy ci wołają: "Broń na ramię!",\r\nŻe im gdzieś nafta z ziemi sikła\r\nI obrodziła dolarami;\r\nŻe coś im w bankach nie sztymuje,\r\nŻe gdzieś zwęszyli kasy pełne\r\nLub upatrzyły tłuste szuje\r\nCło jakieś grubsze na bawełnę.\r\nRżnij karabinem w bruk ulicy!\r\nTwoja jest krew, a ich jest nafta!\r\nI od stolicy do stolicy\r\nZawołaj broniąc swej krwawicy:\r\n"Bujać - to my, panowie szlachta!"');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(8, 3, 'Dziś', 'Dawniej się trzeba było zużyć, przeżyć,\r\nby przestać kochać, podziwiać i wierzyć,\r\ndziś - pierwsze nasze myśli sa zwątpieniem,\r\nnudą, szyderstwem, wstrętem i przeczeniem.\r\nDzieci krytyki, wiedzy i rozwagi,\r\ncudzych doświadczeń mając pełną głową,\r\nchoćby nam dano skrzydła Ikarowe,\r\nnie mielibyśmu do lotu odwagi.\r\nMy nie tracimy nic, bośmy do razu \r\nnic nie przynieśli - i tylko nam bywa\r\ntak żle,że na złe takie brak wyrazu,\r\na serce pęka w nas i we krwi pływa.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(9, 5, 'Gdy runą trzy ściany...', '...Gdy runą trzy ściany chaty\r\nW niszczących burz churaganie,\r\nWybij okienko na słońce \r\nW jedynej, jaką masz, ścianie.\r\n\r\nGdy scheda twoja tak marną,\r\nŻe tylko grzędę masz ziemi,\r\nNie sadź jej w wierzby płaczące,\r\nLecz dębu zasadź w niej ziarno.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(10, 5, 'Gdzie jest ten grom...', 'Gdzie jest ten grom, co przyjdzie a na prochy zetrze\r\nJesienne drzewo ludów, trzęsące się w wietrze,\r\nI nowe latorózgi dobędzie z korzeni,\r\nI żywym majem starą ziemię uzieleni?');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(11, 2, 'Gęsiarka', 'Z czteroletnia powagą, w spódniczce po bose\r\nstopki i w kaftaniku na wyrost, to wąską\r\nDrepce miedzią, to znowu brodzi młaką grząską,\r\nZ rannym świtem, nim słońce traw osuszy rosę.\r\n\r\nKrasą krajką przplótłszy lnianowłosą kosę,\r\nZ kromka chleba w chusteczce za pasa przewiązką\r\nDłoń prawą uzbroiwszy wierzbiny gałązką,\r\nW lewej wlecze za sobą źdźbło złocistokłose.\r\n\r\nSznur gęsi, z których każda jak łódka się słania,\r\nSunie jak szereg białych znaków zapytania,\r\nCzy dziecko ich pilnuje, czy one je wiodą\r\n\r\nJak na śnieżnym łańcuchu, by ustrzec przed szkodą,\r\nI odwracają szyję u każdego skręta,\r\nCzy nie zgubiło z dłoni pastuszego sprzęta');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(12, 3, 'I jeden atom powietrza znów dwoje...', '...I jeden atom powietrza znów dwoje\r\nnaszych spokojnych ust sobą obdzielił,\r\ni jeden spływa na dwie nasze głowy,\r\nobok leżące, promień księżycowy,\r\ni dziś my razem, znów razem oboje,\r\no czym śnić wczoraj bym się nie ośmielił...\r\nPrzed własnym szczęściem tak zdumiony stoję,\r\njak by mi nagle przed stopą wystrzelił\r\nsłup ognia - i szedł w niebieskie sklepienia,\r\ni stał się niebu filarem z płomiania...');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(13, 6, 'Jak dobrze', 'Jak dobrze Mogę zbierać\r\nJagody w lesie\r\nMyślałem\r\nNie ma lasu i jagód.\r\n\r\nJak dobrze Mogę leżeć\r\nW cieniu drzewa\r\nMyślałem drzewa\r\nJuż nie dają cienia.\r\n\r\nJak dobrze Jestem z tobą\r\nTak mi serce bije\r\nMyślałem człowiek \r\nnie ma serca.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(14, 1, 'Kalinowe dwory', 'Kalinowe dwory\r\nJarzeń na jawory,\r\nJarzębiec surowy,\r\nCzerwoń do zawory! \r\nCzerwoń jagodzico\r\nŁadnie do dziewanny!\r\nBorem nie da rady,\r\nJaworowe panny! \r\nDziewierz borem łazi,\r\nŁyśnie na spiekory:\r\nHej, kraśnie zagorzewią\r\nKalinowe dwory!');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(15, 4, 'Klątwa', 'Kto był przyczyną rozstania naszego -\r\nNiechaj łzy moje upadną na niego!\r\nI niech tak samo serce mu przygniotą\r\nSamotntm żalem i próżną tęsknotą!\r\n\r\nKto był przyczyną naszego rozstania -\r\nniech nie doczeka słodkiego spotkania,\r\nLecz niechj ginie z dala od kochanej,\r\nNie pocieszony i nie odżałowany!\r\n\r\nKraków 1872');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(16, 4, 'Kluczy woda po kamieniach', 'Kluczy woda po kamieniach, \r\nA na głębi cicho płynie -\r\nNie sądż ludzi po zachceniach,\r\nAle prawdy szukaj w czynie.\r\n\r\nKto prawdziwie czuć niezdolny,\r\nTen się szumem słowa pieści -\r\nPotok głośny a swawolny\r\nMało wody w sobie mieści.\r\n\r\nLecz spokojnej cisza toni\r\nZwykle wielką głąb zwiastuje -\r\nNa wiatr uczuć swych nie trwoni,\r\nKto głęboko w duszy czuje!\r\n\r\nKraków 1872');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(17, 2, 'Kołodziej', 'O lat tysiąc świat cały wygląda mo młodziej,\r\nGdy widzę, jak przed progiem swej lepianki wiejskiej\r\nSprawuje rzemieślniczy swój trud kołodziejski,\r\nJakimś kruszwickim czarem owiany kołodziej.\r\n\r\nNa jego skromną pracę w nierozgłośnym siole\r\nSłońce blask rzuca dziwny, rzkełbyś, nadgoplański.\r\nGdy on sporządza koła, niby święty pański\r\nDla dusz błogosławionych wieczne aureole.\r\n\r\nJak gdyby plaster miodu albo chleba skibki\r\nKrajał pośród śnieżnej kwietnych płatków chmury.\r\nStruga dzwona i piastę z drzewa, kiedy wióry\r\nPrószą wokoło niego wśród złotej rozsypki.\r\n\r\nCiosajże, jak promienie słońca, proste szprychy,\r\nHej, ojcze kołodzieju, nieksiążęcy Piaście,\r\nBy ich było, jak godzin w kole dnia, dwanaście,\r\nA wśród dwunastu godzin ani jednej lichej!\r\n\r\nA spajajże je mocno, aby trwały cało,\r\nBy z jednych gniazda miały strażnicze bociany,\r\nA inne niech blask mają słońcem wyzłacany,\r\nJakby na nich po świecie szczęście jechać miało!\r\n\r\nA zapłać-że ci Pan Bóg, że się tak mozolą\r\nBary twe, że się dłoń twa nad kołami trudzi!\r\nA włóż w nie wraz z swym trudem życzenie dla ludzi\r\nBy na nich umknąć mogli przed wszelką niedolą!');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(18, 6, 'Koncert życzeń', 'Opowiadanie babuni o kraju chrześcijańskiego\r\n\r\nChodzę po domu na czworakach\r\nNa palcach chowam się po kątach\r\nUdaję starą salopkę\r\nMiotełkę do zamiatania\r\n\r\nNie rzucam się w oczy w ten sposób\r\nUśmiecham się do wszystkich\r\nNawet do klamki słucham kroków\r\n\r\nKiedyś wsadziłam palec do garnuszka\r\nZ miodem\r\nOdezwały się głosy trąb\r\nSąd ostateczny\r\nMdli mnie\r\nZ miłości\r\nPrzedmioty mają zęby i pazury\r\n\r\nTa szafa co stoi otwarta\r\nTo mamusia wasza i babcia\r\nTo krzesło\r\nKtóre przestawiają z kąta w kąt\r\nTo też babcia\r\n\r\nKochanej mamuni i babuni \r\nW dniu sto pierwszych urodzin\r\nDwustu lat życia życzą\r\nSyn synowa i wnuki');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(19, 2, 'Kowal', 'Całą bezkształtną masę kruszców drogocennych,\r\nKtóre zaległy piersi mej głąb nieodgadłą,\r\nJak wulkan z swych otchłani wyrzucam bezdennych\r\nI ciskam ją na twarde, stalowe kowadło.\r\n\r\nGrzmotem młota w nią walę w radosnej otusze,\r\nBo wykonać mi trzeba dzieło wielkie, pilne,\r\nBo z tych kruszców dla siebie serce wykuć muszę,\r\nSerce hartowne, mężne, serce dumne, silne.\r\n\r\nLecz gdy ulegniesz, serce pod młota żelazem;\r\nGdy pękniesz, przeciw ciosom stali nieodporne:\r\nW pył cię rozbiją pięści mej gromy potworne!\r\n\r\nBo lepiej giń, zmiażdżone cyklopowym razem,\r\nNiżbyś żyć miało własną słabością przeklęte,\r\nRysą chorej niemocy skażone, pęknięte.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(20, 6, 'Kto jest poetą', 'Poetą jest ten który pisze wiersze\r\nI ten który wierszy nie pisze\r\n\r\nPoetą jest ten który zrzuca więzy \r\nI ten który więzy sobie nakłada\r\n\r\nPoetą jest ten który wierzy\r\nI ten który uwierzyć nie może\r\n\r\nPoetą jest ten który kłamał\r\nI ten którego okłamano\r\n\r\nTen który upadł\r\nI ten który się podnosi\r\n\r\nPoetą jest ten który odchodzi\r\nI ten który odejść nie może');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(21, 6, 'Lament', 'Zwracam się do was kapłani\r\nNauczyciele sędziowie artyści\r\nSzewcy lekarze referenci\r\nI do ciebie mój ojcze\r\nWysłuchajcie mnie.\r\n\r\nNie jestem młody\r\nNiech was smukłość mego ciała \r\nNie zwodzi\r\nAni tkliwa biel szyi\r\nAni jasność otwartego czoła \r\nAni puch nad słodką wargą\r\nNi śmiech cherubiński\r\nNi krok elastyczny\r\n\r\nNie jestem młody \r\nNiech was moja niewinność\r\nNie wzrusza\r\nAni moja czystość\r\nAni moja słabość\r\nKruchość i prostota\r\n\r\nMam lat dwadzieścia \r\nJestem mordercą\r\nJestem narzędziem\r\nTak ślepym jak miecz\r\nW dłoni kata\r\nZamordowałem człowieka\r\nI czerwonymi palcami\r\nGładziłem białe piersi kobiet.\r\n\r\nOkaleczony nie widziałem\r\nAni nieba ani róży\r\nPtaka gniazda drzewa\r\nŚwiętego Franciszka\r\nAchillesa i Hektora\r\nPrzez sześć lat\r\nBuchał z nozdrza opar krwi\r\nNie wierzę w przemianę wody w wino\r\nNie wierzę w grzechów odpuszczenie\r\nNie wierzę w ciała zmartwychwstanie');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(22, 6, 'List do ludożerców', 'Kochani ludożercy\r\nNie patrzcie wilkiem\r\nNa człowieka\r\nKtóry pyta o wolne miejsce\r\nW przedziale kolejowym\r\nZrozumcie\r\nInni ludzie też mają\r\nDwie nogi i siedzenie\r\n\r\nKochani ludożercy\r\nPoczekajcie chwilę\r\nNie depczcie słabszych\r\nNie zgrzytajcie zębami\r\n\r\nZrozumcie\r\nLudzi jest dużo będzie jeszcze\r\nWięcej więc posuńcie się trochę\r\nUstąpcie\r\n\r\nKochani ludożercy \r\nNie wykupujcie wszystkich\r\nŚwiec sznurowadeł i makaronu\r\nNie mówcie odwróceni tyłem:\r\nJa mnie mój moje\r\nMój żołądek, mój włos\r\nMój odcisk moje spodnie\r\nMoja żona moje dzieci\r\nMoje zdanie\r\n\r\nKochani ludożercy\r\nNie zjadajmy się Dobrze\r\nBo nie zmartwychwstaniemy\r\nNaprawdę');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(23, 4, 'Między nami nic nie było', 'Między nami nic nie było!\r\nŻadnych zwieżeń, wyznań żadnych,\r\nNic nas z sobą nie łączyło\r\nPrócz wiosennych marzeń zdradnych;\r\n\r\nPrócz tych wspólnych, jasnych zdrojów,\r\nZ których serce zachwyt piło,\r\nPrócz pierwiosnków i powojów\r\nMiędzy nami nic niwe było!\r\n\r\nKaków 1872');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(24, 5, 'Na jeziorze', 'Woda - taka cicha\r\n    Jak sen...\r\nWiatr - lekuchno wzdycha\r\n    Jak sen...\r\nŁódka - tak ucieka\r\n    jak sen...\r\nMyśl - taka daleka\r\n    jak sen...');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(25, 5, 'Nasz świat', 'I miasto, i wioska\r\nTo jeden nasz świat!\r\nI wszędzie, dziecino,\r\nTwa siostra, twój brat\r\n\r\nI wszędzie, dziecino,\r\nWśród lasów, wśród pól,\r\nJak ty, czują radość,\r\nJak ty, czują ból.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(26, 4, 'Nawrócenie', 'Gdy miała szesnaście latek,\r\nByła ach!bardzo sceptyczną:\r\nNie chciała wierzyć, gdym mówił,\r\n Że jest prześliczną!\r\nWątpiła o swej urodzie,\r\nWuczuci wierzyć nie chciała:\r\nKiedym jej miłość wyznawał,\r\n Tylko się śmiała!\r\n\r\nLecz dzisiaj po latach wielu,\r\nWiara w jej serce wstapiła\r\nI nawrócenie zupełnie \r\n Żałuje, wprzód wątpiła...\r\nUfna w potęgę miłości,\r\nWspomnienia pragnie odświerzyć;\r\nWierzy że ją kocham,\r\n Lecz ja - przestałem już wierzyć...\r\n\r\nLwów 1869');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(27, 3, 'Nie wierze w nic...', 'Nie wierze w nic, nie pragnę niczego na świecie,\r\nwstręt mam do wszystkich czynów, drwię z wszystkich zapasów:\r\nposagi moich marzeń strącam z piedestałów\r\ni zdruzgotane rzucam w niepamięci śmiecie\r\n\r\nA wprzód je depcę z żalu tak dzikim szaleństwem,\r\njak rzeźbiarz, co chciał zakląć z marmuru Afrodytę,\r\nwidząc trud swój daremnym, marmury rozbite\r\ndepce, plącząc krzyk bólu z śmiechem i przekleństwem.\r\n\r\nI jedna mi już tylko wiara pozostała:\r\nże konieczność jest wszystkim, wola ludzka niczym ?\r\ni jedno mi już tylko zostało pragnienie\r\n\r\nNirwany, w której jasność pogrąża się cała\r\nw bezwładności, w omdleniu sennym, tajemniczym,\r\ni nie czując przechodzi z wolna w nieistnienie.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(28, 1, 'O mowie rosyjskiej', 'Tiewnaja piewunnica\r\nMiłoj ni raduny!\r\nZwoniestie, zagoriste\r\nSwietoładi struny! \r\nWjarkoti żurczałowo,\r\nWjunica płaczewna,\r\nGrustiwie pieczałowo\r\nTiewnaja słopiewna');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(29, 3, 'O wichrze, wichrze!...', 'O wichrze, wichrze! Wyrwij moją duszę\r\nz ciała i nieś ją w powietrzne głębiny!\r\nJak ptak tatrzański zwleczony w niziny\r\nja na nizinach szarpię się i duszę.\r\n\r\nKędy chcesz, nieś ją szalonym podmuchem,\r\nrdzuć gdzieś w pustkowiu dalekim,\r\nnie chcę pamiętać, że jestem człowiekiem,\r\na nie swobodnym, wolnym, skrzydlatym duchem!');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(30, 6, 'Oblicze ojczyzny', 'Ojczyzna to kraj dzieciństwa\r\nMiejsce urodzenia\r\nTo jest ta mała najbliższa\r\nOjczyzna\r\n\r\nMiasto miasteczko wieś\r\nUlica dom podwórko\r\n\r\nPierwsza miłość\r\nLas na horyzoncie\r\nGroby\r\n\r\nW dzieciństwie poznaje się\r\nKwiaty zioła zboża\r\nZwierzęta\r\nPola łąki\r\nSłowa owoce\r\n\r\nOjczyzna się śmieje\r\n\r\nNa początku ojczyzna\r\nJest blisko\r\nNa wyciągnięcie ręki\r\n\r\nDopiero później rośnie\r\nKrwawi\r\nBoli');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(31, 6, 'Ocalony', 'Mam dwadzieścia cztery lata\r\nOcalałem\r\nProwadzony na rzeź\r\n\r\nTo są nazwy puste i jednoznaczne\r\nCzłowiek i zwierzę\r\nMiłość i nienawiść\r\nWróg i przyjaciel\r\nCiemność i światło\r\n\r\nCzłowieka tak się zabija jak zwierzę\r\nWidziałem:\r\nFurgony porąbanych ludzi\r\nKtórzy nie zostaną zbawieni.\r\n\r\nPojęcia są tylko wyrazami:\r\nCnota i występek\r\nPrawda i kłamstwo\r\nPiękno i brzydota\r\nMęstwo i tchórzostwo.\r\n\r\nJednakowo waży cnota i występek\r\nWidziałem:\r\nCzłowieka który był jeden\r\nWystępny i cnotliwy.\r\n\r\nSzukam nauczyciela i mistrza\r\nNiech przywróci mi wzrok słuch i mowę\r\nNiech jeszcze raz nazwie rzeczy i pojęcia\r\nNiech oddzieli światło od ciemności.\r\n\r\nMam dwadzieścia cztery lata\r\nOcalałem \r\nProwadzony na rzeź.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(32, 6, 'Oczyszczenie', 'Nie wstydźcie się łez\r\nNie wstydźcie się łez młodości poeci.\r\n\r\nZachwycajcie się księżycem\r\nNocą księżycową\r\nCzystą miłością i pieniem słowika.\r\n\r\nNie bójcie się wniebowzięcia\r\nSięgajcie po gwiazdę\r\nPorównujcie oczy do gwiazd.\r\n\r\nWzruszajcie się pierwiosnkiem\r\nPomarańczowym motylem\r\nWschodem i zachodem słońca.\r\n\r\nSypcie groch łagodnym gołębiom\r\nObserwujcie z uśmiechem\r\nPsy kwiaty nosorożce i lokomotywy.\r\n\r\nRozmawiajcie o ideałach\r\nDeklamujcie odę do młodości\r\nUfajcie obcemu przechodniowi.\r\n\r\nNaiwni uwierzycie w piękno\r\nWzruszeni uwierzycie w człowieka.\r\n\r\nNie wstydźcie się łez\r\nNie wstydźcie się łez młodzi poeci.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(33, 2, 'On', 'Byłeś wciąż przy mnie niegdyś przed tysiącem lat\r\n(A może tak sie tylko memu sercu zdaje).\r\nByłem wtedy pasterzem białorunych stad,\r\nPo roli pług wodziłem, który ziemie kraje,\r\nSiałem w rozorę bruzdy oziminy, jarce,\r\nPielęgnowałem z troską płodny, ciężki sad,\r\nChowałem pszczoły w ulach i z ciszą w pogwarce,\r\nZmierzchem śpiewałem proste pieśni na fujarce.\r\n\r\nOdszedłeś precz ode mnie przed tysiącem lat\r\n(A może tak się tylko memu sercu zdaje).\r\nBom przykrzył sobie lnianą prostotę swych szat\r\nI jednostajne życia zgrzebnego zwyczaje.\r\nI zapragnąłem zgiełku, który ciszę płoszy,\r\nPrzygód i niespodzianek, którym młodzian rad,\r\nI chwały, i bogactwa, i bujnej rozkoszy,\r\nI władzy, co się dumnie nad słabszym panoszy.\r\n\r\nNie byłeś potem przy mnie długie tysiąc lat\r\n(A może tak się tylko memu sercu zdaje).\r\nBom zbiegał z nieukojem wielki, dziwny świat,\r\nZnajdowałem wciąż nowe drogi i rozstaje.\r\nByłem kupcem, co w sakwie grube zyski liczy,\r\nGraczem, co rzuca kości i złoto jak grad,\r\nŻołnierzem żądnym walki, sławy i zdobyczy\r\nI włastem, co z sąsiady sporami graniczy.\r\n\r\nWróciłeś znowu do nie po tysiącu lat\r\n( I to się sercu memu już nie tylko zdaje).\r\nBo nie znalazłem szczęścia, lecz cierpienie i jad\r\nI, wróciwszy z tęsknotą, rzucony próg maję.\r\nI znów spokojny jestem snując się po polu,\r\nBo czuję, żeś jest przy mnie, druh słodki i brat,\r\nI chłonę, pojednawco radości i bólu,\r\nDuszę twą z dźbła pszenicy i kwiecia kąkolu.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(34, 2, 'Podój', 'W oborze, podle krowy, która słomy snopiec\r\nDepcąc chlasta ogonem śród cierpliwej bójki\r\nZ muchami łechcącymi ją z bzyczeniem rójki\r\nW łzawe oczy i w nozdrza, chcąc do żywa dopiec:\r\n\r\nDziewczyna hożej krasy, a mocna jak chłopiec\r\nWprawnymi ruchy ręki uważnej i czujkiej\r\nPociąga napęczniałych, ciężkich wymion dójki,\r\nDzierżąc, na niskim zydlu, pośród kolan skopiec.\r\n\r\nI gdy ciecz mleczna strzyka i z sykiem się pieni,\r\nRozlewając woń ciepłą i zapach ziół świeży,\r\nI napełnia naczynie, wzbierając po wręby:\r\n\r\nMleczarka w jej gęstości i złocie odcieni\r\nWita skarb masielnicy jutrzejszy i szczerzy\r\nDo śniegu przyszłych serów śnieżne jak ser zęby.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(35, 6, 'Pomniki', 'Nasze pomniki\r\nSą dwuznaczne\r\nMają kształt dołu\r\n\r\nNasze pomniki \r\nMają kształt \r\nŁzy\r\n\r\nNasze pomniki\r\nBudował pod ziemią \r\nKret\r\n\r\nNasze pomniki\r\nMają kształt dymu\r\nIdą prosto do nieba');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(36, 5, 'Preludium', 'Nie kocham jeszcze, a już mi jest drogi,\r\nNie kocham jeszcze, a już drżę i płonę\r\nI duszę pełną o niego mam trwogi\r\nI myśli moje już tam, w jego progi\r\nLecą stęsknione...\r\nI ponad dachem jego się trzepocą\r\nMiesięczną nocą...\r\n\r\nNie kocham jeszcze, a ranki już moje\r\nO snach mych dziwnie wstają zadumane,\r\nJuż chodzą za mną jakieś niepokoje,\r\nJuż czegoś pragnę i czegoś się boję\r\nW noce niespane...\r\nI już na ustach noszę ślad płomienia\r\nJego imienia.\r\n\r\nNie kocham jeszcze, a już mi się zdaje,\r\nŻe nam gdzieś lecieć, rozpłynąć się trzeba,\r\nW jakieś czarowne dziedziny i kraje...\r\nJuż mi się marzą słowicze wyraje\r\nDo tego nieba,\r\nKtóre gdzieś czeka, aż nas ukołysze\r\nW błękitną ciszę.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(37, 6, 'Przepaść', 'Babcia w czarnych sukniach\r\nDrucianych okularach\r\nZ laseczką\r\nStawia stopę\r\nNad przepaścią krawężnika cofa\r\nRozgląda się bojaźliwie \r\nChoć nie widać śladu samochodu\r\n\r\nPodbiega do niej chłopczyk\r\nBierze za rękę\r\nI przeprowadza\r\nPrzez otchłań ulicy\r\nNa drugi brzeg\r\n\r\nRozstępują się\r\nStraszliwe ciemności\r\nNagromadzone nad światem\r\nPrzez złych ludzi\r\nKiedy w sercu\r\nMałego chłopca\r\nŚwieci iskierka \r\nMiłości');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(38, 4, 'Publiczność do poetów', 'Wieczanie śpiewacie na tę samą nutę!\r\nŚpiewacie rozpacz dziką i bezbrzeżną,\r\nSrca przedwczesną goryczą zatrute\r\nI melancholię mglistąa lubieżną,\r\nSenne miłoście szpilkami przekłute,\r\nRany zadają jedną rączką śniżną\r\nI omijacie skrzętni każdą radość-\r\nStrojąc się w duchów księżycową bladość.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(39, 4, 'Ranek w górach', 'Wyzłocone słońcem szczyty\r\nJuż różowo w górze płoną\r\nI pogodnie lśnią błękity\r\nNad pogiętych skał koroną.\r\n\r\nW dole lasy skryte w cieniu\r\nToną jeszcze w mgle perłowej,\r\nCo wporannym oświetleniu\r\nMknie się z wolna przez parowy.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(40, 5, 'Rota', 'Nie rzucim ziemi, skąd nasz ród,\r\nNie damy pogrześć mowy!\r\nPolski my naród, polski lud,\r\nKrólewski szczep piastowy,\r\nNie damy by nas zniemczył wróg...\r\n\r\n- Tak nam dopomóż Bóg! \r\n\r\nDo krwi ostatniej kropli z żył\r\nBronić będziemy Ducha,\r\nAż się rozpadnie w proch i w pył\r\nKrzyżacka zawierucha.\r\nTwierdzą nam będzie każdy próg...\r\n\r\n- Tak nam dopomóż Bóg! \r\n\r\nNie będzie Niemiec pluł nam w twarz,\r\nNi dzieci nam germanił.\r\nOrężny wstanie hufiec nas,\r\nDuch będzie nam hetmanił,\r\nPójdziem, gdy zabrzmi złoty róg...\r\n\r\n- Tak nam dopomóż Bóg!');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(41, 3, 'Są takie chwile...', 'Są takie chwile, gdy się nie śmie badać\r\nswej własnej duszy, bo się człowiek lękanie,\r\nże ani jednej nie znajdzie w niej struny,\r\nco, potrącona, jeszcze czysto dźwięknie.\r\n\r\nLecz trzeba tylko jednego spojrzenia\r\npełnymi wielkiej miłości oczyma,\r\nby w akord związać wszystkie struny duszy...\r\npotrzeba jednych oczu - - lecz ich nie ma!');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(42, 1, 'Słowisień', 'W białodrzewiu jaśnie dźni słoneczko,\r\nMiodzie złoci białopałem żyśnie,\r\nDrzewia pełni pszczelą i pasieczną,\r\nA przez liście kraśnie pęk słowiśnie. \r\nA gdy sierpiec na niebłoczu łyście,\r\nW cieniem ciemnie jeno niedośpiewy\r\nW białodrzewiu ćwirnie i srebliście\r\nSłowik słowi słowisienkie ciewy');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(43, 4, 'Sonet', 'Pierwsze uczucia, to kwiaty wiosenne,\r\nCo się swą własną upajają wonią,\r\nPrzed żywszym blaskiem jeszcze w cień się chronią\r\nI wierzą jeszcze w swe trwanie niezmienne.\r\n\r\nPo nich, ach! inne stybarwne, płomienie, \r\nZnów zakwitają i za słońcem gonią;\r\nWiedzdzą, że zwiędną - więc czasu nie trwonią\r\nI gaszą tylko pragnienia codzienne.\r\n\r\nA póżnij znowu wspomnień astry blade\r\nWschodzą samotne na schyłku jesieni\r\nI chcą trwać tylko, i walczą z ulewą,\r\n\r\nWidzą wokoło martwość i zagładę -\r\nA w końcu jeden cyprys się zieleni,\r\nPonure, smutne rezygnacji drzewo.\r\n\r\nLwów 1869');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(44, 2, 'Staw', 'Gdy jeszcze resztką mrozu szronią się poranki.\r\nRuń ledwo się wypierza, a na stawie kaczki\r\nWśród odbic chmur, jak pośród kry błędnej tułaczki,\r\nSlizgają się, by śniegiem ubielone sanki:\r\n\r\nU wybrzeża wysoko podkasane praczki,\r\nBarwne jak Wielkanocy - już rychłej - kraszanki\r\nKlaszczą wesoło w płótna raxnymi kijanki\r\nI płoszą żółtodzióbe, żarłoczne pływaczki.\r\n\r\nGdy kaczora po szybie wód puszczają śmiałki\r\nPłaskimi kamykami, wśród plusku i śmiechów,\r\nW dziewki rozgrzane w chłodzie pilnymi zabiegi;\r\n\r\nWśród bieli chust i piany zda się, że rusałki\r\nPiorą dla przyszłej zimy, a na letni przechów,\r\nOdwilżą zabrudzone zeszłoroczne śniegi.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(45, 1, 'Święty Franciszek', 'Ptakowie kwiatowie\r\nłanie weseli \r\nalleluja, lelija\r\newangieli. \r\nEwangieli angieli\r\nświatu wołali:\r\nniewiemo! chwalemo!\r\npłakali. \r\nNiebianie polanie\r\nsłodkiej światłości\r\nJezusie gołąbku\r\nmiłości');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(46, 4, 'Szczęśliwa młodość', 'Szczęśliwa młodość!... nawet smutki\r\nZaprawne ma rozkoszą.\r\nDzień szczęścia długi... żalu - krótki;\r\nŁzy ulgę jej przynoszą.\r\n\r\nSzczęśliwa młodość!... swe boleści\r\nW słowiczym odda śpiewie\r\nI oddchem własnych skarg się pieści,\r\nI o swym szczęściu nie wie!\r\n\r\nLwów 1880');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(47, 3, 'Ta trawa której nikt nie kosi...', 'Ta trawa, której nikt nie kosi,\r\nta woda, której nikt nie pije,\r\nnikomu nie sza żyje!\r\npachnące kwiaty - - \r\noch! tam jedynie dusza żyje!\r\n\r\nTo niebo, w które nikt nie patrzy,\r\nBóg, który wcale nie zna ludzi,\r\nten las nikomu nie szumiący,\r\nta zorza, która nic nie budzi...\r\n\r\nTe nie pachnące zadnym nozdrzom\r\ncudowne, purpurowe kwiaty;\r\nta woda, której nikt nie pije,\r\nten wiatr nad pustką mgieł skrzydlaty...\r\n\r\nBóg, który wcale nie zna ludzi,\r\ncud, w który żadna muśl nie wcieka,\r\nten las nikomu nie szumiący,\r\nduch, nie mający nic z człowieka...\r\n\r\nŚwiat bez istnienia i bez śmierci,\r\nten zdrój, co tylko skałom bije,\r\nta trawa, której nikt nie kosi - -\r\noch! tam jedynie dusza żyje!');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(48, 5, 'Tęcza', '-A kto ciebie, śliczna tęczo,\r\nSiedmiobarwny pasie,\r\nWymalował na tej chmurce,\r\nJakby na atłasie?\r\n-Słoneczko mnie malowało\r\nPo deszczu, po burzy:\r\nPożyczyło sobie farby\r\nOd tej polnej róży.\r\nPożyczyło farby\r\nOd kwiatków z ogroda;\r\nMalowało tęcze na znak,\r\nŻe będzie pogoda!');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(49, 5, 'Tęczowy duszek', 'Kiedy czytam w mym ogródku,\r\nKiedy szemrzą trawy, drzewa,\r\nWtedy słyszę - po cichutku\r\nCoś w gęstwinie wonnej śpiewa...\r\n\r\nCoś ci śpiewa, coś - ci gada,\r\nBrzęczy niby złota pszczoła,\r\nRóżne dziwy opowiada,\r\nA kto taki - nie wiem zgoła!\r\n\r\nCzasem myślę, że to róża,\r\nCo na krzaku się rozwija,\r\nI oczęta do mnie zmruża...\r\nCzasem myślę - że lilija...\r\n\r\nAlbo może żuczki złote,\r\nMoże muszki i motyle,\r\nBrzęczą w uszko, tak, na psotę,\r\nGdy zadumam się na chwilę.\r\n\r\nI raz tylko mi się zdało,\r\nŻe wskroś młodych listków sieci\r\nWidzę postać "duszka" białą,\r\nJak na skrzydłach ku mnie leci...\r\n\r\nJasność słońca, dźwięk piosenki,\r\nZapach kwiatów, listków szmery\r\nW tęczę tkały mu sukienki\r\nI skrzydełek jego cztery...\r\n\r\nJak motylek na krzewinie,\r\nTak nad głową moją siedział...\r\nMyślę, że te wszystkie owe\r\nDziwy - on mi opowiedział.\r\n\r\nO tej pięknej, wielkiej ziemi,\r\nO tych morzach, o tych górach,\r\nO tych orłach, co nad nimi\r\nDo gniazd swoich lecą w chmurach.\r\n\r\nO tej czystej serc pogodzie,\r\nKtórej żaden mrok nie zaćmi,\r\nO miłości i o zgodzie,\r\nI o pracy z ludźmi braćmi.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(50, 4, 'Tęsknota', 'Obłoki co z ziemi wstają\r\nI płyną w słońca blask złoty,\r\nAch one mi się być zdają \r\nSkrzydłami mojej tęsknoty.\r\n\r\nTe białe skrzydła powiewne\r\nCzęsto nad ziemią obwisną,\r\nŁzy po nich spływają rzewne,\r\nCzasem i tęczą zabłysną.\r\n\r\nPatrzą się w ciemne odmęty\r\nTwielkie ruchome słońca...\r\nI ja, miłością przejęty,\r\nPatrzę i tęsknię bez końca.\r\n\r\nKraków 1872');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(51, 3, 'Ty nie giń marnie...', 'Ty nie giń marnie, gdy w serce cię rani \r\n            zabójczy grot:\r\nTy nie uciekaj do cichej przystani, \r\n       gdy ryknie grzmit.\r\n\r\n\r\nNiech się uczucia pouczuciach kruszą! \r\n       W kraj myśli idż -\r\nZ umarłym sercem, ale z żywą duszą \r\n       wszak można żyć.\r\n\r\n\r\nNiech na bałwany piętrzą się bałwany! \r\n       Niech pęka łódż!\r\nNa jednej desce łodzi toń można pruć.\r\n\r\n\r\nDymny zwyci  e zca w walce z sercem swojem, wyższy nad gmin\r\nDzielnie z losami prowadzonym bojem, sięgaj poczyn.\r\n\r\n\r\nRaz powolny, ty się nie poddawaj - jak ranny lew,\r\nTym potężniejszy, tym zuchwalszy stawaj wszystkiemu wbrew!');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(52, 2, 'U poju', 'Gdy słońce pada w mgieł zachodnich sidła\r\nI w bezgranicznej słodyczy spokoju,\r\nPo gospodarskim, rzetelnym dnia znoju,\r\nZmierzch nad wsią senne swe roztacza skrzydła:\r\n\r\nSpragnione kupią się z wolna u poju\r\nPowracające z pola stada bydła,\r\nCierpliwe konie zwolnione z wędzidła\r\nI krowy ciężkie przed porą podoju.\r\n\r\nI gdy sie widzi ten obraz prostaczy,\r\nSerce skupione rozumie i baczy, \r\nŻe to coś więcej jeszcze wszystko znaczy:\r\n\r\nŻe jest w tym wzniosła mądrość prawdy bożej,\r\nCo, wklęta w złoto zachodzącej zorzy,\r\nNad znojem świętą aureolę tworzy.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(53, 5, 'W cichej dolinie', 'Góry rozwarły ramiona,\r\nBy obiąć cichą dolinę...\r\nNoc schodzi srebrna, zroszona,\r\nBy objąć cichą dolinę...\r\nW zadumie patrzy me oko\r\nW daleką, cichą dolinę...');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(54, 5, 'W pole, w pole...', 'W pole, w pole, po padole\r\nBuja sokół siwy...\r\nKiedyż tobie wzejdzie zorza,\r\nKraju nieszczęśliwy!\r\n\r\nZapłonęła, zagorzała,\r\nJutrzenka na niebie,\r\nWschodzi, wschodzi złote słonko,\r\nAle nie dla ciebie.\r\n\r\nWschodzi słonko, wschodzi złote,\r\nKalinowa zorza,\r\nA nad tobą nocka ciemna\r\nOd morza do morza.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(55, 3, 'W tę cichą, senną...', 'W tę cichą, senną, wonną noc majową\r\nczuję twe ręce ponad moją głową -\r\nsłonią mi świat...\r\nO! Gdyby więcej pod rękoma twemi\r\nnie pomnieć życia i siebie, i ziemi,\r\ni złud, i strat...');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(56, 1, 'Wanda', 'Woda Wanda wiślana\r\ngłaź głębica srebliwa\r\npo ciemnurzu pazurem\r\nwodzi jaskro księżawiec \r\nsino płynie dno śpiewa\r\nwoda wanda ruślana\r\nczesze włosy świetłodzie\r\ntopiel dziewny kniaziewny');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(57, 2, 'Wół', 'W bezstrunnej rozwidlonych twoich rogów lirze\r\nMilczy hymn niemy pracy. Roboczym nawykiem\r\nKroczysz z wolna, pod jarzma twardego dotykiem,\r\nZ ciszą ziemi i duszy chłopskiej w wiecznym mirze.\r\n\r\nDzień witasz hasłem znoju: przeciągłym porykiem,\r\nI gdy potężny kark twój i mocarne krzyże\r\nLśnią potem w blasku słońca jak posągu spiże,\r\nSam jesteś najwznioślejszym mozołu pomnikiem.\r\n\r\nW czcigodnej swej powagi ciężkim majestacie,\r\nJak starożytne bogów zwierzęcych postacie,\r\nMiłość i cześć człowieka wziąłeś po nich w spadku.\r\n\r\nChoć z pokorą, co patrzy z łagodnym ócz tobie,\r\nSynowi Człowieczemu-ś oddał je przy żłobie,\r\nJak jest na wigilijnym odbite opłatku.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(58, 1, 'Wspomnienie', 'Mimozami jesień się zaczyna,\r\nZłotawa, krucha i miła.\r\nTo ty, to ty jesteś ta dziewczyna,\r\nKtóra do mnie na ulicę wychodziła. \r\nOd twoich listów pachniało w sieni,\r\nGdym wracał zdyszany ze szkoły,\r\nA po ulicach w lekkiej jesieni\r\nFruwały za mną jasne anioły. \r\nMimozami zwiędłość przypomina\r\nNieśmiertelnik żółty - październik.\r\nTo ty, to ty moja jedyna,\r\nPrzychodziłaś wieczorem do cukierni. \r\nZ przemodlenia, z przeomdlenia senny,\r\nW parku płakałem szeptanymi słowy.\r\nMłodzik z chmurek prześwitywał jesienny,\r\nOd mimozy złotej - majowy. \r\nAch, czułymi, przemiłymi snami\r\nZasypiałem z nim gasnącym o poranku,\r\nW snach dawnymi bawiąc się wiosnami,\r\nJak tą złotą, jak tą wonną wiązanką...');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(59, 3, 'Wszystko umiera z smutkiem i żałobom...', 'Wszystko umiera z smautkiem i żałobom,\r\nchoć tylko zmianę kształtu jest skonanie,\r\nbo chociaż wszystko zmarłe zmartwychwstanie,\r\nnie zmartwychwstanie nic już nigdy sobą.\r\n\r\nCóż, że w tysiącu kształtów moje ciało,\r\nz tysiąca zmarłych kształtów w jedno zlane,\r\ndawne, jak ziemia dawna, będzie trwało\r\ndo końca ziemi?... Jak nie zmartwychwstanę.\r\n\r\nLamiąca myśl jest, że ludzie tak muszą\r\nginąć, jak ginie zwierzę i roślina;\r\nże to, co we mnie nazywa się duszą,\r\nto jest czująca i myśląca glina.');
INSERT INTO `wiersz` (`wiersz_id`, `poeta_id`, `tytul`, `tekst`) VALUES(60, 1, 'Zielone słowa', 'A gdzie pod lasem podlasina,\r\nTam gęsta wiklina-szeleścina. \r\nNa prawo bór, na lewo trawy,\r\nOj da i te szerokie, śpiewane morawy. \r\nIści woda, uści woda na murawie,\r\nSzumi-strumni dunajewo po niekławie. \r\nNa prawo bór czarnolas dąbrowiany.\r\nNa lewo ziel jasnoziel liści wodziany. \r\nA po szepcinie wiją, a na murawie dzwionie,\r\nA i tam tżną wesoło te morowiańskie konie');
