<?php

/**
 * Base class that represents a row from the 'mecz' table.
 *
 * 
 *
 * @package    football2002.om
 */
abstract class BaseMecz extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        MeczPeer
	 */
	protected static $peer;

	/**
	 * The value for the mecz_id field.
	 * @var        int
	 */
	protected $mecz_id;

	/**
	 * The value for the gospodarz field.
	 * @var        int
	 */
	protected $gospodarz;

	/**
	 * The value for the gosc field.
	 * @var        int
	 */
	protected $gosc;

	/**
	 * The value for the kolejka field.
	 * @var        int
	 */
	protected $kolejka;

	/**
	 * The value for the gol1 field.
	 * @var        int
	 */
	protected $gol1;

	/**
	 * The value for the gol2 field.
	 * @var        int
	 */
	protected $gol2;

	/**
	 * The value for the data field.
	 * @var        string
	 */
	protected $data;

	/**
	 * @var        Klub
	 */
	protected $aKlubRelatedByGospodarz;

	/**
	 * @var        Klub
	 */
	protected $aKlubRelatedByGosc;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Initializes internal state of BaseMecz object.
	 * @see        applyDefaults()
	 */
	public function __construct()
	{
		parent::__construct();
		$this->applyDefaultValues();
	}

	/**
	 * Applies default values to this object.
	 * This method should be called from the object's constructor (or
	 * equivalent initialization method).
	 * @see        __construct()
	 */
	public function applyDefaultValues()
	{
	}

	/**
	 * Get the [mecz_id] column value.
	 * 
	 * @return     int
	 */
	public function getMeczId()
	{
		return $this->mecz_id;
	}

	/**
	 * Get the [gospodarz] column value.
	 * 
	 * @return     int
	 */
	public function getGospodarz()
	{
		return $this->gospodarz;
	}

	/**
	 * Get the [gosc] column value.
	 * 
	 * @return     int
	 */
	public function getGosc()
	{
		return $this->gosc;
	}

	/**
	 * Get the [kolejka] column value.
	 * 
	 * @return     int
	 */
	public function getKolejka()
	{
		return $this->kolejka;
	}

	/**
	 * Get the [gol1] column value.
	 * 
	 * @return     int
	 */
	public function getGol1()
	{
		return $this->gol1;
	}

	/**
	 * Get the [gol2] column value.
	 * 
	 * @return     int
	 */
	public function getGol2()
	{
		return $this->gol2;
	}

	/**
	 * Get the [optionally formatted] temporal [data] column value.
	 * 
	 *
	 * @param      string $format The date/time format string (either date()-style or strftime()-style).
	 *							If format is NULL, then the raw DateTime object will be returned.
	 * @return     mixed Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
	 * @throws     PropelException - if unable to parse/validate the date/time value.
	 */
	public function getData($format = 'Y-m-d H:i:s')
	{
		if ($this->data === null) {
			return null;
		}


		if ($this->data === '0000-00-00 00:00:00') {
			// while technically this is not a default value of NULL,
			// this seems to be closest in meaning.
			return null;
		} else {
			try {
				$dt = new DateTime($this->data);
			} catch (Exception $x) {
				throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->data, true), $x);
			}
		}

		if ($format === null) {
			// Because propel.useDateTimeClass is TRUE, we return a DateTime object.
			return $dt;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $dt->format('U'));
		} else {
			return $dt->format($format);
		}
	}

	/**
	 * Set the value of [mecz_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Mecz The current object (for fluent API support)
	 */
	public function setMeczId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->mecz_id !== $v) {
			$this->mecz_id = $v;
			$this->modifiedColumns[] = MeczPeer::MECZ_ID;
		}

		return $this;
	} // setMeczId()

	/**
	 * Set the value of [gospodarz] column.
	 * 
	 * @param      int $v new value
	 * @return     Mecz The current object (for fluent API support)
	 */
	public function setGospodarz($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->gospodarz !== $v) {
			$this->gospodarz = $v;
			$this->modifiedColumns[] = MeczPeer::GOSPODARZ;
		}

		if ($this->aKlubRelatedByGospodarz !== null && $this->aKlubRelatedByGospodarz->getKlubId() !== $v) {
			$this->aKlubRelatedByGospodarz = null;
		}

		return $this;
	} // setGospodarz()

	/**
	 * Set the value of [gosc] column.
	 * 
	 * @param      int $v new value
	 * @return     Mecz The current object (for fluent API support)
	 */
	public function setGosc($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->gosc !== $v) {
			$this->gosc = $v;
			$this->modifiedColumns[] = MeczPeer::GOSC;
		}

		if ($this->aKlubRelatedByGosc !== null && $this->aKlubRelatedByGosc->getKlubId() !== $v) {
			$this->aKlubRelatedByGosc = null;
		}

		return $this;
	} // setGosc()

	/**
	 * Set the value of [kolejka] column.
	 * 
	 * @param      int $v new value
	 * @return     Mecz The current object (for fluent API support)
	 */
	public function setKolejka($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->kolejka !== $v) {
			$this->kolejka = $v;
			$this->modifiedColumns[] = MeczPeer::KOLEJKA;
		}

		return $this;
	} // setKolejka()

	/**
	 * Set the value of [gol1] column.
	 * 
	 * @param      int $v new value
	 * @return     Mecz The current object (for fluent API support)
	 */
	public function setGol1($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->gol1 !== $v) {
			$this->gol1 = $v;
			$this->modifiedColumns[] = MeczPeer::GOL1;
		}

		return $this;
	} // setGol1()

	/**
	 * Set the value of [gol2] column.
	 * 
	 * @param      int $v new value
	 * @return     Mecz The current object (for fluent API support)
	 */
	public function setGol2($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->gol2 !== $v) {
			$this->gol2 = $v;
			$this->modifiedColumns[] = MeczPeer::GOL2;
		}

		return $this;
	} // setGol2()

	/**
	 * Sets the value of [data] column to a normalized version of the date/time value specified.
	 * 
	 * @param      mixed $v string, integer (timestamp), or DateTime value.  Empty string will
	 *						be treated as NULL for temporal objects.
	 * @return     Mecz The current object (for fluent API support)
	 */
	public function setData($v)
	{
		// we treat '' as NULL for temporal objects because DateTime('') == DateTime('now')
		// -- which is unexpected, to say the least.
		if ($v === null || $v === '') {
			$dt = null;
		} elseif ($v instanceof DateTime) {
			$dt = $v;
		} else {
			// some string/numeric value passed; we normalize that so that we can
			// validate it.
			try {
				if (is_numeric($v)) { // if it's a unix timestamp
					$dt = new DateTime('@'.$v, new DateTimeZone('UTC'));
					// We have to explicitly specify and then change the time zone because of a
					// DateTime bug: http://bugs.php.net/bug.php?id=43003
					$dt->setTimeZone(new DateTimeZone(date_default_timezone_get()));
				} else {
					$dt = new DateTime($v);
				}
			} catch (Exception $x) {
				throw new PropelException('Error parsing date/time value: ' . var_export($v, true), $x);
			}
		}

		if ( $this->data !== null || $dt !== null ) {
			// (nested ifs are a little easier to read in this case)

			$currNorm = ($this->data !== null && $tmpDt = new DateTime($this->data)) ? $tmpDt->format('Y-m-d H:i:s') : null;
			$newNorm = ($dt !== null) ? $dt->format('Y-m-d H:i:s') : null;

			if ( ($currNorm !== $newNorm) // normalized values don't match 
					)
			{
				$this->data = ($dt ? $dt->format('Y-m-d H:i:s') : null);
				$this->modifiedColumns[] = MeczPeer::DATA;
			}
		} // if either are not null

		return $this;
	} // setData()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->mecz_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->gospodarz = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
			$this->gosc = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
			$this->kolejka = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
			$this->gol1 = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
			$this->gol2 = ($row[$startcol + 5] !== null) ? (int) $row[$startcol + 5] : null;
			$this->data = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 7; // 7 = MeczPeer::NUM_COLUMNS - MeczPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Mecz object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

		if ($this->aKlubRelatedByGospodarz !== null && $this->gospodarz !== $this->aKlubRelatedByGospodarz->getKlubId()) {
			$this->aKlubRelatedByGospodarz = null;
		}
		if ($this->aKlubRelatedByGosc !== null && $this->gosc !== $this->aKlubRelatedByGosc->getKlubId()) {
			$this->aKlubRelatedByGosc = null;
		}
	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(MeczPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = MeczPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->aKlubRelatedByGospodarz = null;
			$this->aKlubRelatedByGosc = null;
		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(MeczPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			MeczPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(MeczPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$affectedRows = $this->doSave($con);
			$con->commit();
			MeczPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aKlubRelatedByGospodarz !== null) {
				if ($this->aKlubRelatedByGospodarz->isModified() || $this->aKlubRelatedByGospodarz->isNew()) {
					$affectedRows += $this->aKlubRelatedByGospodarz->save($con);
				}
				$this->setKlubRelatedByGospodarz($this->aKlubRelatedByGospodarz);
			}

			if ($this->aKlubRelatedByGosc !== null) {
				if ($this->aKlubRelatedByGosc->isModified() || $this->aKlubRelatedByGosc->isNew()) {
					$affectedRows += $this->aKlubRelatedByGosc->save($con);
				}
				$this->setKlubRelatedByGosc($this->aKlubRelatedByGosc);
			}

			if ($this->isNew() ) {
				$this->modifiedColumns[] = MeczPeer::MECZ_ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = MeczPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setMeczId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += MeczPeer::doUpdate($this, $con);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aKlubRelatedByGospodarz !== null) {
				if (!$this->aKlubRelatedByGospodarz->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aKlubRelatedByGospodarz->getValidationFailures());
				}
			}

			if ($this->aKlubRelatedByGosc !== null) {
				if (!$this->aKlubRelatedByGosc->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aKlubRelatedByGosc->getValidationFailures());
				}
			}


			if (($retval = MeczPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = MeczPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getMeczId();
				break;
			case 1:
				return $this->getGospodarz();
				break;
			case 2:
				return $this->getGosc();
				break;
			case 3:
				return $this->getKolejka();
				break;
			case 4:
				return $this->getGol1();
				break;
			case 5:
				return $this->getGol2();
				break;
			case 6:
				return $this->getData();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = MeczPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getMeczId(),
			$keys[1] => $this->getGospodarz(),
			$keys[2] => $this->getGosc(),
			$keys[3] => $this->getKolejka(),
			$keys[4] => $this->getGol1(),
			$keys[5] => $this->getGol2(),
			$keys[6] => $this->getData(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = MeczPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setMeczId($value);
				break;
			case 1:
				$this->setGospodarz($value);
				break;
			case 2:
				$this->setGosc($value);
				break;
			case 3:
				$this->setKolejka($value);
				break;
			case 4:
				$this->setGol1($value);
				break;
			case 5:
				$this->setGol2($value);
				break;
			case 6:
				$this->setData($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = MeczPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setMeczId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setGospodarz($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setGosc($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setKolejka($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setGol1($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setGol2($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setData($arr[$keys[6]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(MeczPeer::DATABASE_NAME);

		if ($this->isColumnModified(MeczPeer::MECZ_ID)) $criteria->add(MeczPeer::MECZ_ID, $this->mecz_id);
		if ($this->isColumnModified(MeczPeer::GOSPODARZ)) $criteria->add(MeczPeer::GOSPODARZ, $this->gospodarz);
		if ($this->isColumnModified(MeczPeer::GOSC)) $criteria->add(MeczPeer::GOSC, $this->gosc);
		if ($this->isColumnModified(MeczPeer::KOLEJKA)) $criteria->add(MeczPeer::KOLEJKA, $this->kolejka);
		if ($this->isColumnModified(MeczPeer::GOL1)) $criteria->add(MeczPeer::GOL1, $this->gol1);
		if ($this->isColumnModified(MeczPeer::GOL2)) $criteria->add(MeczPeer::GOL2, $this->gol2);
		if ($this->isColumnModified(MeczPeer::DATA)) $criteria->add(MeczPeer::DATA, $this->data);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(MeczPeer::DATABASE_NAME);

		$criteria->add(MeczPeer::MECZ_ID, $this->mecz_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getMeczId();
	}

	/**
	 * Generic method to set the primary key (mecz_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setMeczId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Mecz (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setGospodarz($this->gospodarz);

		$copyObj->setGosc($this->gosc);

		$copyObj->setKolejka($this->kolejka);

		$copyObj->setGol1($this->gol1);

		$copyObj->setGol2($this->gol2);

		$copyObj->setData($this->data);


		$copyObj->setNew(true);

		$copyObj->setMeczId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Mecz Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     MeczPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new MeczPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a Klub object.
	 *
	 * @param      Klub $v
	 * @return     Mecz The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setKlubRelatedByGospodarz(Klub $v = null)
	{
		if ($v === null) {
			$this->setGospodarz(NULL);
		} else {
			$this->setGospodarz($v->getKlubId());
		}

		$this->aKlubRelatedByGospodarz = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Klub object, it will not be re-added.
		if ($v !== null) {
			$v->addMeczRelatedByGospodarz($this);
		}

		return $this;
	}


	/**
	 * Get the associated Klub object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Klub The associated Klub object.
	 * @throws     PropelException
	 */
	public function getKlubRelatedByGospodarz(PropelPDO $con = null)
	{
		if ($this->aKlubRelatedByGospodarz === null && ($this->gospodarz !== null)) {
			$this->aKlubRelatedByGospodarz = KlubPeer::retrieveByPK($this->gospodarz, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aKlubRelatedByGospodarz->addMeczsRelatedByGospodarz($this);
			 */
		}
		return $this->aKlubRelatedByGospodarz;
	}

	/**
	 * Declares an association between this object and a Klub object.
	 *
	 * @param      Klub $v
	 * @return     Mecz The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setKlubRelatedByGosc(Klub $v = null)
	{
		if ($v === null) {
			$this->setGosc(NULL);
		} else {
			$this->setGosc($v->getKlubId());
		}

		$this->aKlubRelatedByGosc = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Klub object, it will not be re-added.
		if ($v !== null) {
			$v->addMeczRelatedByGosc($this);
		}

		return $this;
	}


	/**
	 * Get the associated Klub object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Klub The associated Klub object.
	 * @throws     PropelException
	 */
	public function getKlubRelatedByGosc(PropelPDO $con = null)
	{
		if ($this->aKlubRelatedByGosc === null && ($this->gosc !== null)) {
			$this->aKlubRelatedByGosc = KlubPeer::retrieveByPK($this->gosc, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aKlubRelatedByGosc->addMeczsRelatedByGosc($this);
			 */
		}
		return $this->aKlubRelatedByGosc;
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
		} // if ($deep)

			$this->aKlubRelatedByGospodarz = null;
			$this->aKlubRelatedByGosc = null;
	}

} // BaseMecz
