<?php

require 'openclipart/om/BaseImg.php';


/**
 * Skeleton subclass for representing a row from the 'img' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    openclipart
 */
class Img extends BaseImg {

	/**
	 * Initializes internal state of Img object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
	public function setSlug($slug)
	{
        if (trim($slug) == '') {
            $slug = 'nieznany';
        }

        $next_slug = $slug;
        $c = new Criteria();
        $c->add(ImgPeer::SLUG, $next_slug);
        $ile = ImgPeer::doCount($c);

        $unikatowy = ($ile == 0);

        $min = 2;
        $max = 1000;

        while (!$unikatowy) {

	        $next_slug = $slug . $min;
            $min++;

	        if ($min > $max + 1) {
	             die("****** ERROR    Img::setSlug({$next_slug})");
	        };

            $c->clear();
            $c->add(ImgPeer::SLUG, $next_slug);
            $ile = ImgPeer::doCount($c);
            $unikatowy = ($ile == 0);
        }
        parent::setSlug($next_slug);
	}
	
	
    public function tworzMiniature($szerokosc = 80, $wysokosc = 80)
    {
        $png = $this->getPng();
        if ($png) {

            $img_str = stream_get_contents($png);
            $obj = imagecreatefromstring($img_str);

            //MINIATURA
            $mini = gd_thumbnail_obj($obj, $szerokosc, $wysokosc);

            ob_start();
            imagepng($mini, NULL);
            $mini_str = ob_get_clean();

            $this->setMinipng($mini_str);

            $this->save();
        }
    }


} // Img
