
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- projekt
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `projekt`;


CREATE TABLE `projekt`
(
	`projekt_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(5),
	`slug` VARCHAR(128),
	`liczbaczcionek` INTEGER,
	PRIMARY KEY (`projekt_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- czcionka
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `czcionka`;


CREATE TABLE `czcionka`
(
	`czcionka_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(128),
	`podglad` INTEGER,
	`liczbaprojektow` INTEGER,
	`slug` VARCHAR(128),
	`platforma_id` INTEGER,
	`rodzina_id` INTEGER,
	`img` INTEGER,
	`lowercase` INTEGER,
	`uppercase` INTEGER,
	PRIMARY KEY (`czcionka_id`),
	INDEX `FI_czcionka_platforma1` (`platforma_id`),
	CONSTRAINT `fk_czcionka_platforma1`
		FOREIGN KEY (`platforma_id`)
		REFERENCES `platforma` (`platforma_id`),
	INDEX `FI_czcionka_rodzina1` (`rodzina_id`),
	CONSTRAINT `fk_czcionka_rodzina1`
		FOREIGN KEY (`rodzina_id`)
		REFERENCES `rodzina` (`rodzina_id`),
	INDEX `FI_czcionka_img1` (`img`),
	CONSTRAINT `fk_czcionka_img1`
		FOREIGN KEY (`img`)
		REFERENCES `img` (`img_id`),
	INDEX `FI_czcionka_img3` (`lowercase`),
	CONSTRAINT `fk_czcionka_img3`
		FOREIGN KEY (`lowercase`)
		REFERENCES `img` (`img_id`),
	INDEX `FI_czcionka_img4` (`uppercase`),
	CONSTRAINT `fk_czcionka_img4`
		FOREIGN KEY (`uppercase`)
		REFERENCES `img` (`img_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- img
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `img`;


CREATE TABLE `img`
(
	`img_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`image` LONGBLOB,
	`slug` VARCHAR(128),
	PRIMARY KEY (`img_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- platforma
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `platforma`;


CREATE TABLE `platforma`
(
	`platforma_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(128),
	`slug` VARCHAR(128),
	`liczbaczcionek` INTEGER,
	`liczbaprojektow` INTEGER,
	PRIMARY KEY (`platforma_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- rodzina
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rodzina`;


CREATE TABLE `rodzina`
(
	`rodzina_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`nazwa` VARCHAR(128),
	`slug` VARCHAR(128),
	`liczbaczcionek` INTEGER,
	`liczbaprojektow` INTEGER,
	PRIMARY KEY (`rodzina_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- projekt_has_czcionka
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `projekt_has_czcionka`;


CREATE TABLE `projekt_has_czcionka`
(
	`projekt_id` INTEGER  NOT NULL,
	`czcionka_id` INTEGER  NOT NULL,
	PRIMARY KEY (`projekt_id`,`czcionka_id`),
	CONSTRAINT `fk_projekt_has_czcionka_projekt`
		FOREIGN KEY (`projekt_id`)
		REFERENCES `projekt` (`projekt_id`),
	INDEX `FI_projekt_has_czcionka_czcionka` (`czcionka_id`),
	CONSTRAINT `fk_projekt_has_czcionka_czcionka`
		FOREIGN KEY (`czcionka_id`)
		REFERENCES `czcionka` (`czcionka_id`)
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
