<?php

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'pomocnicze.inc.php';
require_once 'vh-array.inc.php';
require_once 'thumbnails.inc.php';
require_once 'watermarks.inc.php';

require_once 'propel/Propel.php';
require_once 'sklep/Dvd.php';
Propel::init('sklep-conf.php');

set_time_limit(0);
header('Content-Type: text/plain;charset=utf-8');

MenuPeer::doDeleteAll();
DvdPeer::doDeleteAll();
KategoriaPeer::doDeleteAll();
FotkaPeer::doDeleteAll();

/*
 * Opcje menu
 */
$plk = file_get_contents('dane-menu/00lista.log');
$d = string2HArray($plk);
foreach ($d['items'] as $tmp_opcja) {
    $slug = $tmp_opcja[0];
    $tytul = $tmp_opcja[1];    
    $tresc = file_get_contents('dane-menu/' . $tmp_opcja[2]);
    
    $dane_menu = array(
        'tytul' => $tytul,
        'slug'  => $slug,
        'tresc' => $tresc
    );
    
    MenuPeer::wstaw($dane_menu);

}

/*
 * Ustalenie konfiguracji
 */
$konfiguracja = parse_ini_file('konfiguracja-generatora.ini');
ustal_domyslne_opcje($konfiguracja);



/*
 * Przetwarzanie folderów kolekcji
 */
echo "przetwarzanie folderow kolekcji\n";
echo "===============================\n";
$foldery_plyt = glob('dane/*');
foreach ($foldery_plyt as $folder) {
    przetworz_folder($konfiguracja, $folder);
}



/*
 * Zliczanie rekordów
 * Skalowanie fotek
 */
DvdPeer::zliczRekordy();
FotkaPeer::tworzMiniatury($konfiguracja);
