<?php

require 'sklep/om/BaseFotkaPeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'fotka' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    sklep
 */
class FotkaPeer extends BaseFotkaPeer {

    public static function wstaw($dane)
    {
        $tmp = new Fotka();
        $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
        $tmp->save();
        return $tmp;
    }
    

    static public function tworzMiniatury($konfiguracja)
    {
        $dlugosc = 50;
        echo "\n\nskalowanie fotek\n";
        echo "====================\n";
        echo str_pad("\n", $dlugosc + 2, 'x', STR_PAD_LEFT);
        flush();
        ob_flush();
        
        $wszystkieFotki = FotkaPeer::doSelect(new Criteria());
        $ile = count($wszystkieFotki);
        $dzielnik = round($ile / $dlugosc);

        foreach ($wszystkieFotki as $i => $fotka) {

            if ($i % $dzielnik == 0) {
                echo 'X';
                flush();
                ob_flush();
            }


            $fotka_str = stream_get_contents($fotka->getMax());
            $obj = imagecreatefromstring($fotka_str);
        
        
            //MINIATURA        
            $mini = gd_thumbnail_obj(
                $obj, 
                $konfiguracja['mini-szerokosc'],
                $konfiguracja['mini-wysokosc']
            );
    
            ob_start();
            imagejpeg($mini, NULL, $konfiguracja['mini-jakosc']);        
            $mini_str = ob_get_clean(); 
    
            $fotka->setMini($mini_str);
    
            //PREVIEW
            $preview = gd_thumbnail_obj(
                $obj, 
                $konfiguracja['preview-szerokosc'],
                $konfiguracja['preview-wysokosc']
            );
    
            ob_start();
            imagejpeg($preview, NULL, $konfiguracja['preview-jakosc']);        
            $preview_str = ob_get_clean(); 
    
            $fotka->setPreview($preview_str);    
    
    
            //POPUP
            $popup = gd_thumbnail_obj(
                $obj, 
                $konfiguracja['popup-szerokosc'],
                $konfiguracja['popup-wysokosc']
            );
    
            ob_start();
            imagejpeg($popup, NULL, $konfiguracja['popup-jakosc']);        
            $popup_str = ob_get_clean(); 
    
            $fotka->setPopup($popup_str);        
    
            $fotka->save();
        
        }
    
    
    }

} // FotkaPeer
