<?php

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);


require_once 'Doctrine/lib/Doctrine.php';
spl_autoload_register(array('Doctrine', 'autoload'));
$conn = Doctrine_Manager::connection('mysql://admin:password@localhost/treny');
Doctrine::loadModels('./../lib');
$conn->setCollate('utf8_polish_ci');
$conn->setCharset('utf8');



require_once 'slugs.inc.php';

$plks = glob('treny/*.txt');
shuffle($plks);
foreach ($plks as $plk) {

    $path_parts = pathinfo($plk);
    $numer = ltrim($path_parts['filename'], '0');

    $p = file($plk);
    $tytul = trim($p[0]);
    $slug = string2slug($tytul);
    $p[0] = '';
    $tresc = trim(implode('', $p));
    
    $tren = new Tren();
    $tren['tytul'] = $tytul;
    $tren['tresc'] = $tresc;
    $tren['slug'] = $slug;
    $tren['numer'] = $numer;
    $tren->save();
}