<?php

class TabelaMeczow extends SortColumns {

    public function __construct()
    {
        $this->columns = array(
            'gospodarz' => array(
                'label'    => 'Gospodarz',
                'slug'     => 'gospodarz',
                'sortable' => 'tak',
                'order'    => 'asc',
                'column'   => KlubPeer::NAZWA,
            ),
            'gosc' => array(
                'label'    => 'Gość',
                'slug'     => 'gosc',
                'sortable' => 'tak',
                'order'    => 'asc',
                'column'   => KlubPeer::NAZWA,
            ),
            'g1' => array(
                'label'    => 'G',
                'slug'     => 'g1',
                'sortable' => 'tak',
                'order'    => 'dsc',
                'column'   => MeczPeer::GOL1,
            ),    
            'g2' => array(
                'label'    => 'G',
                'slug'     => 'g2',
                'sortable' => 'tak',
                'order'    => 'dsc',
                'column'   => MeczPeer::GOL2,
            ),                
            'kolejka' => array(
                'label'    => 'Kolejka',
                'slug'     => 'kolejka',
                'sortable' => 'tak',
                'order'    => 'asc',
                'column'   => MeczPeer::KOLEJKA,
            ),        
        );            
        $this->setIndex('kolejka');
    }
    
    public function getCriteria($liga)
    {
        $c = parent::getCriteria($liga);
        
        if ($this->index == 'gosc') {
            $c->addJoin(MeczPeer::GOSC, KlubPeer::KLUB_ID);
        } else {
            $c->addJoin(MeczPeer::GOSPODARZ, KlubPeer::KLUB_ID);
        }
        
        return $c;
    }    
    
}