set names utf8;
drop database if exists artykulymi;
create database artykulymi default character set utf8 collate utf8_polish_ci;
grant all on artykulymi.* to admin@localhost identified by 'password';
flush privileges;
use artykulymi;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- autor
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `autor`;


CREATE TABLE `autor`
(
	`autor_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`imie` VARCHAR(255)  NOT NULL,
	`nazwisko` VARCHAR(255)  NOT NULL,
	`liczbaartykulow` INTEGER,
	`liczbastron` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`autor_id`),
	UNIQUE KEY `autor_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- artykul
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `artykul`;


CREATE TABLE `artykul`
(
	`artykul_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255)  NOT NULL,
	`lid` TEXT,
	`start` INTEGER,
	`stop` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	`rubryka_id` INTEGER,
	`podrubryka_id` INTEGER,
	`numer_id` INTEGER,
	`liczbastron` INTEGER,
	PRIMARY KEY (`artykul_id`),
	UNIQUE KEY `artykul_U_1` (`slug`(128)),
	INDEX `FI_artykul_rubryka1` (`rubryka_id`),
	CONSTRAINT `fk_artykul_rubryka1`
		FOREIGN KEY (`rubryka_id`)
		REFERENCES `rubryka` (`rubryka_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE,
	INDEX `FI_artykul_podrubryka1` (`podrubryka_id`),
	CONSTRAINT `fk_artykul_podrubryka1`
		FOREIGN KEY (`podrubryka_id`)
		REFERENCES `podrubryka` (`podrubryka_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE,
	INDEX `FI_artykul_numer1` (`numer_id`),
	CONSTRAINT `fk_artykul_numer1`
		FOREIGN KEY (`numer_id`)
		REFERENCES `numer` (`numer_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- numer
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `numer`;


CREATE TABLE `numer`
(
	`numer_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`numer` INTEGER  NOT NULL,
	`liczbaartykulow` INTEGER,
	`liczbastron` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	`rocznik_id` INTEGER,
	PRIMARY KEY (`numer_id`),
	UNIQUE KEY `numer_U_1` (`slug`(128)),
	INDEX `FI_numer_rocznik1` (`rocznik_id`),
	CONSTRAINT `fk_numer_rocznik1`
		FOREIGN KEY (`rocznik_id`)
		REFERENCES `rocznik` (`rocznik_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- rocznik
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rocznik`;


CREATE TABLE `rocznik`
(
	`rocznik_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rok` INTEGER  NOT NULL,
	`liczbaartykulow` INTEGER,
	`liczbastron` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`rocznik_id`),
	UNIQUE KEY `rocznik_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- rubryka
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rubryka`;


CREATE TABLE `rubryka`
(
	`rubryka_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rubryka` VARCHAR(255)  NOT NULL,
	`liczbaartykulow` INTEGER,
	`liczbastron` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`rubryka_id`),
	UNIQUE KEY `rubryka_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- podrubryka
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `podrubryka`;


CREATE TABLE `podrubryka`
(
	`podrubryka_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`podrubryka` VARCHAR(255)  NOT NULL,
	`liczbaartykulow` INTEGER,
	`liczbastron` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`podrubryka_id`),
	UNIQUE KEY `podrubryka_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- artykul_has_autor
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `artykul_has_autor`;


CREATE TABLE `artykul_has_autor`
(
	`artykul_id` INTEGER  NOT NULL,
	`autor_id` INTEGER  NOT NULL,
	PRIMARY KEY (`artykul_id`,`autor_id`),
	CONSTRAINT `fk_artykul_has_autor_artykul1`
		FOREIGN KEY (`artykul_id`)
		REFERENCES `artykul` (`artykul_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE,
	INDEX `FI_artykul_has_autor_autor1` (`autor_id`),
	CONSTRAINT `fk_artykul_has_autor_autor1`
		FOREIGN KEY (`autor_id`)
		REFERENCES `autor` (`autor_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 3.1.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 14 Gru 2009, 10:33
-- Wersja serwera: 5.1.35
-- Wersja PHP: 5.2.9-2

SET FOREIGN_KEY_CHECKS=0;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Baza danych: `artykulymi`
--

--
-- Zrzut danych tabeli `artykul`
--

INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1, 'Telepraca', '', 10, 16, 'telepraca', 1, 1, 1, 7);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(2, 'Komunikacja jak na dłoni', '', 22, 23, 'komunikacja_jak_na_dloni', 2, 2, 1, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(3, 'Zostań dyktatorem (w Internecie)', '', 24, 27, 'zostan_dyktatorem_w_internecie', 2, 3, 1, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(4, 'Cyberjęzyk', '', 28, 31, 'cyberjezyk', 2, 3, 1, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(5, 'Połaczeni w sieci', '', 32, 33, 'polaczeni_w_sieci', 2, 3, 1, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(6, 'www.skazani-na-sukces.pl Część 3', '', 34, 35, 'www_skazani_na_sukces_pl_czesc_3', 2, 4, 1, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(7, 'Sega Dreamcast. Internet w konsoli', '', 36, 37, 'sega_dreamcast_internet_w_konsoli', 2, 5, 1, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(8, 'Wcale nie potrzeba miliona dolarów, żeby stworzyć portal', '', 38, 39, 'wcale_nie_potrzeba_miliona_dolarow_zeby_stworzyc_portal', 2, 6, 1, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(9, 'Organizacja wirtualna', '', 44, 46, 'organizacja_wirtualna', 3, 5, 1, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(10, 'Cztery cele firmowej strony WWW', '', 48, 49, 'cztery_cele_firmowej_strony_www', 3, 4, 1, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(11, 'Podłączamy firmę do Internetu. Część 2: jak współdzielić łącze', '', 50, 53, 'podlaczamy_firme_do_internetu_czesc_2_jak_wspoldzielic_lacze', 3, 4, 1, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(12, 'Nieruchomości w sieci', '', 54, 57, 'nieruchomosci_w_sieci', 3, 7, 1, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(13, 'Opera 5.01', '', 60, 61, 'opera_5_01', 4, 8, 1, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(14, 'Visual Studio.NET', '', 62, 63, 'visual_studio_net', 4, 8, 1, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(15, 'Manta DB 2.02', '', 64, 65, 'manta_db_2_02', 4, 8, 1, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(16, 'Internet offline. Przegląd programów do kopiowania witryn WWW', '', 66, 69, 'internet_offline_przeglad_programow_do_kopiowania_witryn_www', 4, 9, 1, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(17, 'Ciekawe efekty na stronach WWW. Łączenie właściwości formatów graficznych z DHTML', '', 76, 77, 'ciekawe_efekty_na_stronach_www_laczenie_wlasciwosci_formatow_graficznych_z_dhtml', 5, 10, 1, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(18, 'PHP. Po stronie serwera (cz. 1)', '', 78, 81, 'php_po_stronie_serwera_cz_1', 5, 11, 1, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(19, 'Nie pozwól czekać', '', 82, 83, 'nie_pozwol_czekac', 5, 12, 1, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(20, 'Pogaduszki w Javie (Część 3)', '', 84, 86, 'pogaduszki_w_javie_czesc_3', 5, 13, 1, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(21, 'Śpiewać każdy może', '', 10, 15, 'spiewac_kazdy_moze', 1, 14, 2, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(22, 'Internet bardzo blisko życia', '', 22, 24, 'internet_bardzo_blisko_zycia', 2, 3, 2, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(23, 'Użytkowniku, siedź cicho!', '', 25, 25, 'uzytkowniku_siedz_cicho', 2, 15, 2, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(24, 'Internet dał mi nowe wyzwania', '', 26, 27, 'internet_dal_mi_nowe_wyzwania', 2, 6, 2, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(25, 'www.skazani-na-sukces.pl Część 4', '', 28, 29, 'www_skazani_na_sukces_pl_czesc_4', 2, 4, 2, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(26, 'Nie poserfujesz w pracy', '', 30, 32, 'nie_poserfujesz_w_pracy', 2, 4, 2, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(27, 'Komputer Expo 2001', '', 41, 41, 'komputer_expo_2001', 2, 2, 2, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(28, 'Zapomnij o PIT-ach!  Tania księgowość w Internecie', '', 42, 43, 'zapomnij_o_pit_ach_tania_ksiegowosc_w_internecie', 3, 6, 2, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(29, 'Podłączamy firmę do Internetu. Część 3: Dlaczego trzeba kontrolować działalność użytkowników?', '', 44, 47, 'podlaczamy_firme_do_internetu_czesc_3_dlaczego_trzeba_kontrolowac_dzialalnosc_uzytkownikow', 3, 4, 2, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(30, 'Szukamy pracy w Internecie', '', 48, 51, 'szukamy_pracy_w_internecie', 3, 7, 2, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(31, 'Systemy wymiany banerów', '', 52, 55, 'systemy_wymiany_banerow', 3, 7, 2, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(32, 'Czym animować? Przegląd programów do edycji animowanych GIF-ów', '', 58, 61, 'czym_animowac_przeglad_programow_do_edycji_animowanych_gif_ow', 4, 9, 2, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(33, 'Serwery FTP dla każdego', '', 62, 64, 'serwery_ftp_dla_kazdego', 4, 8, 2, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(34, 'Serwery .NET Enterprise', '', 65, 65, 'serwery_net_enterprise', 4, 8, 2, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(35, 'Ciekawe efekty na stronach WWW. Warstwy i JavaScript', '', 70, 71, 'ciekawe_efekty_na_stronach_www_warstwy_i_javascript', 5, 10, 2, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(36, 'PHP. Po stronie serwera (cz. 2)', '', 72, 75, 'php_po_stronie_serwera_cz_2', 5, 11, 2, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(37, 'PHP dla wtajemniczonych. Udoskonalamy ankietę', '', 76, 79, 'php_dla_wtajemniczonych_udoskonalamy_ankiete', 5, 11, 2, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(38, 'Akceleratory internetowe. Przeglądarka na sterydach, czyli jak podrasować połączenie internetowe', '', 80, 83, 'akceleratory_internetowe_przegladarka_na_sterydach_czyli_jak_podrasowac_polaczenie_internetowe', 5, 12, 2, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(39, 'Pogaduszki w Javie (Część 4)', '', 84, 86, 'pogaduszki_w_javie_czesc_4', 5, 13, 2, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(40, 'Lepiej powoli niż wcale', '', 87, 87, 'lepiej_powoli_niz_wcale', 5, 4, 2, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(41, 'Internetowa przestrzeń rynkowa', '', 18, 22, 'internetowa_przestrzen_rynkowa', 3, 5, 3, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(42, '9 mitów internetowego copyright', '', 24, 25, '9_mitow_internetowego_copyright', 3, 16, 3, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(43, 'Historia pewnego wdrożenia. Autoryzacja płatności kartami kredytowymi w trybie online', '', 26, 28, 'historia_pewnego_wdrozenia_autoryzacja_platnosci_kartami_kredytowymi_w_trybie_online', 3, 17, 3, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(44, '...jeśli dzić wtorek, to jesteśmy w First Tuesday!', '', 30, 31, 'jesli_dzic_wtorek_to_jestesmy_w_first_tuesday', 3, 18, 3, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(45, 'Interia jak Internet?', '', 32, 33, 'interia_jak_internet', 3, 6, 3, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(46, 'Nowa twarz Gnutelli', '', 38, 41, 'nowa_twarz_gnutelli', 2, 5, 3, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(47, 'Królewska gra w Internecie', '', 42, 44, 'krolewska_gra_w_internecie', 2, 3, 3, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(48, 'edysk.pl', '', 45, 45, 'edysk_pl', 2, 3, 3, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(49, 'Zrób pożytek ze swojego komputera. Przetwarzanie rozproszone w Internecie', '', 46, 49, 'zrob_pozytek_ze_swojego_komputera_przetwarzanie_rozproszone_w_internecie', 2, 3, 3, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(50, 'www.skazani-na-sukces.pl Część 5, ostatnia', '', 50, 51, 'www_skazani_na_sukces_pl_czesc_5_ostatnia', 2, 4, 3, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(51, 'Linux Część 1', '', 52, 54, 'linux_czesc_1', 2, 4, 3, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(52, 'Taryfikatory połączeń internetowych', '', 58, 61, 'taryfikatory_polaczen_internetowych', 4, 9, 3, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(53, 'Miej swój styl! TopStyle Pro 2.0', '', 62, 64, 'miej_swoj_styl_topstyle_pro_2_0', 4, 8, 3, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(54, 'Tiger II MINI', '', 66, 66, 'tiger_ii_mini', 4, 8, 3, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(55, 'eSafe Protect Desktop 3.0', '', 67, 67, 'esafe_protect_desktop_3_0', 4, 8, 3, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(56, 'Compaq iPAQ H3630', '', 70, 70, 'compaq_ipaq_h3630', 6, 19, 3, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(57, 'Casio QV-2800UX', '', 71, 71, 'casio_qv_2800ux', 6, 19, 3, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(58, 'Hewlett-Packard e-pc', '', 72, 72, 'hewlett_packard_e_pc', 6, 19, 3, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(59, 'Ciekawe efekty na stronach WWW. Interaktywne strony WWW', '', 74, 75, 'ciekawe_efekty_na_stronach_www_interaktywne_strony_www', 5, 20, 3, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(60, 'Flash i efekty specjalne', '', 76, 79, 'flash_i_efekty_specjalne', 5, 21, 3, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(61, 'PHP Po stronie serwera (cz. 3)', '', 80, 83, 'php_po_stronie_serwera_cz_3', 5, 11, 3, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(62, 'Zegar na stronie WWW', '', 84, 87, 'zegar_na_stronie_www', 5, 13, 3, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(63, 'Jak sobie poradzić z bombą mailową', '', 88, 89, 'jak_sobie_poradzic_z_bomba_mailowa', 5, 12, 3, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(64, 'Quo vadis pakiecie...', '', 90, 93, 'quo_vadis_pakiecie', 5, 12, 3, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(65, 'Polskie sklepy online A.D. 2001', '', 14, 19, 'polskie_sklepy_online_a_d_2001', 3, 22, 4, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(66, 'Polskie e-banki', '', 20, 23, 'polskie_e_banki', 3, 17, 4, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(67, 'Nadszedł czas zawodowców!', '', 24, 25, 'nadszedl_czas_zawodowcow', 3, 6, 4, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(68, 'Eutelsat Broadband Media Conference', '', 32, 35, 'eutelsat_broadband_media_conference', 2, 18, 4, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(69, 'Nauka przez sieć', '', 36, 39, 'nauka_przez_siec', 2, 5, 4, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(70, 'Linux. Pierwsze kroki: instalacja. Część 2', '', 40, 42, 'linux_pierwsze_kroki_instalacja_czesc_2', 2, 4, 4, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(71, 'SDI w praktyce', '', 44, 45, 'sdi_w_praktyce', 2, 4, 4, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(72, 'Z igły widły, czyli jak Czesi złamali PGP', '', 46, 47, 'z_igly_widly_czyli_jak_czesi_zlamali_pgp', 2, 3, 4, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(73, 'Programy TV w sieci', '', 48, 50, 'programy_tv_w_sieci', 2, 3, 4, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(74, 'Internetowe poradniki medyczne', '', 52, 57, 'internetowe_poradniki_medyczne', 2, 3, 4, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(75, 'Pomocnicy mistrza Flasha', '', 60, 62, 'pomocnicy_mistrza_flasha', 4, 9, 4, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(76, '12 sposobów na udana witrynę', '', 63, 65, '12_sposobow_na_udana_witryne', 4, 9, 4, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(77, '„Ja tłumaczyć po polskiemu”, czyli Internet Translator', '', 66, 67, 'ja_tlumaczyc_po_polskiemu_czyli_internet_translator', 4, 8, 4, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(78, 'Galeria w Internecie', '', 68, 69, 'galeria_w_internecie', 4, 8, 4, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(79, 'Internet Explorer 6 Public Preview', '', 70, 70, 'internet_explorer_6_public_preview', 4, 8, 4, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(80, 'Office XP beta', '', 71, 71, 'office_xp_beta', 4, 8, 4, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(81, 'Ciekawe efekty na stronach WWW. Warstwy i DHTML', '', 78, 79, 'ciekawe_efekty_na_stronach_www_warstwy_i_dhtml', 5, 20, 4, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(82, 'PHP. Po stronie serwera (cz. 4)', '', 80, 84, 'php_po_stronie_serwera_cz_4', 5, 11, 4, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(83, 'Animacje w Javie', '', 85, 87, 'animacje_w_javie', 5, 13, 4, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(84, 'Flash i efekty specjalne', '', 88, 91, 'flash_i_efekty_specjalne2', 5, 21, 4, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(85, 'Arkana szybkiego pobierania plików: GetRight', '', 92, 93, 'arkana_szybkiego_pobierania_plikow_getright', 5, 12, 4, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(86, 'Skuteczny firewall', '', 94, 98, 'skuteczny_firewall', 5, 12, 4, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(87, 'Motosieć', '', 14, 18, 'motosiec', 3, 22, 5, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(88, 'Praca w firmach internetowych', '', 20, 23, 'praca_w_firmach_internetowych', 3, 22, 5, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(89, 'Internetowe supermarkety i pasaże handlowe', '', 24, 28, 'internetowe_supermarkety_i_pasaze_handlowe', 3, 17, 5, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(90, 'Internetowe inkubatory', '', 30, 31, 'internetowe_inkubatory', 3, 6, 5, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(91, 'Wielkie podglądanie', '', 38, 42, 'wielkie_podgladanie', 2, 23, 5, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(92, 'Linux. System okiełznany. Część 3', '', 43, 45, 'linux_system_okielznany_czesc_3', 2, 4, 5, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(93, 'Zasilanie internetu', '', 46, 51, 'zasilanie_internetu', 2, 24, 5, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(94, 'Nowoczesne technologie w edukacji', '', 52, 53, 'nowoczesne_technologie_w_edukacji', 2, 25, 5, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(95, 'Odyseja kosmiczna 2001 — spełnione marzenia?', '', 54, 57, 'odyseja_kosmiczna_2001_spelnione_marzenia', 2, 18, 5, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(96, 'A to Polska właśnie...', '', 58, 61, 'a_to_polska_wlasnie', 2, 26, 5, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(97, 'Programy FTP: do wyboru, do koloru', '', 64, 67, 'programy_ftp_do_wyboru_do_koloru', 4, 9, 5, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(98, 'Oprogramowanie do tworzenia sklepów online', '', 68, 72, 'oprogramowanie_do_tworzenia_sklepow_online', 4, 9, 5, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(99, 'Kylix Server Developer', '', 73, 73, 'kylix_server_developer', 4, 8, 5, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(100, 'NeoPlanet Nowe skóry dla Internet Explorera', '', 74, 75, 'neoplanet_nowe_skory_dla_internet_explorera', 4, 8, 5, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(101, 'Ciekawe efekty na stronach WWW. Jeszcze o warstwach', '', 80, 81, 'ciekawe_efekty_na_stronach_www_jeszcze_o_warstwach', 5, 20, 5, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(102, 'Flash i efekty specjalne. ActionScript', '', 82, 85, 'flash_i_efekty_specjalne_actionscript', 5, 21, 5, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(103, 'PHP Po stronie serwera (cz. 5)', '', 86, 89, 'php_po_stronie_serwera_cz_5', 5, 11, 5, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(104, 'Lista dyskusyjna na stronie WWW', '', 90, 94, 'lista_dyskusyjna_na_stronie_www', 5, 11, 5, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(105, 'Obrazki na stronę WWW', '', 95, 95, 'obrazki_na_strone_www', 5, 12, 5, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(106, 'Arkana szybkiego pobierania plików: Go!Zilla', '', 96, 97, 'arkana_szybkiego_pobierania_plikow_go_zilla', 5, 12, 5, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(107, 'Kontrahenci z sieci', '', 16, 20, 'kontrahenci_z_sieci', 3, 22, 6, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(108, 'Internetowe wspieranie procesów logistycznych', '', 21, 25, 'internetowe_wspieranie_procesow_logistycznych', 3, 26, 6, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(109, 'Wpływ Internetu na proces globalizacji gospodarczej', '', 26, 29, 'wplyw_internetu_na_proces_globalizacji_gospodarczej', 3, 5, 6, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(110, 'Internet z nieba. Test usługi „Chello satelitarne”', '', 36, 39, 'internet_z_nieba_test_uslugi_chello_satelitarne', 2, 17, 6, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(111, 'VPN: Wirtualne Sieci Prywatne', '', 40, 43, 'vpn_wirtualne_sieci_prywatne', 2, 24, 6, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(112, 'Linux. Stawiamy Apacza. Część 4', '', 44, 45, 'linux_stawiamy_apacza_czesc_4', 2, 4, 6, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(113, 'A to Polska właśnie... (cz. 2)', '', 46, 49, 'a_to_polska_wlasnie_cz_2', 2, 26, 6, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(114, 'Promocja młodych talentów informatycznych i internetowych', '', 50, 51, 'promocja_mlodych_talentow_informatycznych_i_internetowych', 2, 6, 6, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(115, 'Formuła 1 w Internecie', '', 52, 56, 'formula_1_w_internecie', 2, 3, 6, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(116, 'Intergłupki', '', 57, 57, 'interglupki', 2, 15, 6, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(117, 'Norton Internet Security 2001 Family Edition 3.0', '', 60, 61, 'norton_internet_security_2001_family_edition_3_0', 4, 8, 6, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(118, 'Cafe Administratorzy, czyli alternatywa dla kafejkowego zeszytu', '', 62, 65, 'cafe_administratorzy_czyli_alternatywa_dla_kafejkowego_zeszytu', 4, 9, 6, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(119, 'Uśmiechnij się! Jesteś w ukrytej kamerze!', '', 66, 69, 'usmiechnij_sie_jestes_w_ukrytej_kamerze', 4, 9, 6, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(120, 'Czym chata bogata, czyli programy do wymiany plików przez Internet', '', 70, 73, 'czym_chata_bogata_czyli_programy_do_wymiany_plikow_przez_internet', 4, 9, 6, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(121, 'Microsoft Natural Keybord Pro', '', 76, 77, 'microsoft_natural_keybord_pro', 6, 19, 6, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(122, 'Motorola Timeport P7389i', '', 78, 79, 'motorola_timeport_p7389i', 6, 19, 6, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(123, 'Odchudzanie HTML-a', '', 80, 81, 'odchudzanie_html_a', 7, 4, 6, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(124, 'Flash i efekty specjalne. ActionScript. Elementy interfejsu graficznego (część 1)', '', 82, 85, 'flash_i_efekty_specjalne_actionscript_elementy_interfejsu_graficznego_czesc_1', 7, 21, 6, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(125, 'PHP. Po stronie serwera (cz. 6)', '', 86, 89, 'php_po_stronie_serwera_cz_6', 7, 11, 6, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(126, 'Firewall. Filtrowanie pakietów', '', 90, 91, 'firewall_filtrowanie_pakietow', 7, 12, 6, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(127, 'Podłączanie sieci lokalnych do Internetu', '', 92, 94, 'podlaczanie_sieci_lokalnych_do_internetu', 7, 12, 6, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(128, 'CacheFlow. Wydajne buforowanie danych', '', 95, 97, 'cacheflow_wydajne_buforowanie_danych', 7, 12, 6, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(129, 'Szkolenia internetowe', '', 16, 21, 'szkolenia_internetowe', 3, 22, 7, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(130, 'Polskie e-banki. Uzupełnienie', '', 22, 25, 'polskie_e_banki_uzupelnienie', 3, 27, 7, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(131, 'Internet z Dialogiem', '', 26, 28, 'internet_z_dialogiem', 3, 17, 7, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(132, 'Mikropłatności. Nowe metody płatności w polskim Internecie', '', 29, 31, 'mikroplatnosci_nowe_metody_platnosci_w_polskim_internecie', 3, 28, 7, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(133, 'Polskie blogi, czyli internetowe pamiętnikarstwo', '', 38, 39, 'polskie_blogi_czyli_internetowe_pamietnikarstwo', 2, 3, 7, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(134, 'Szkoły w sieci', '', 40, 43, 'szkoly_w_sieci', 2, 3, 7, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(135, 'Darmowe wyszukiwarki internetowe', '', 44, 45, 'darmowe_wyszukiwarki_internetowe', 2, 4, 7, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(136, 'Linux. Serwery FTP. Część 6', '', 46, 47, 'linux_serwery_ftp_czesc_6', 2, 4, 7, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(137, 'edysk.pl: dobry plan to podstawa sukcesu', '', 48, 49, 'edysk_pl_dobry_plan_to_podstawa_sukcesu', 2, 6, 7, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(138, 'Bądź w Kontakcie, bądź OK! Komunikatory Wirtualnej Polski i Onetu', '', 52, 55, 'badz_w_kontakcie_badz_ok_komunikatory_wirtualnej_polski_i_onetu', 4, 8, 7, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(139, 'Delphi 6 Enterprise', '', 56, 57, 'delphi_6_enterprise', 4, 8, 7, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(140, 'JBuilder 5 Enterprise', '', 58, 59, 'jbuilder_5_enterprise', 4, 8, 7, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(141, 'Office XP Professional PL', '', 60, 62, 'office_xp_professional_pl', 4, 8, 7, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(142, 'Przechytrzyć intruza. Przegląd programów antywirusowych', '', 62, 65, 'przechytrzyc_intruza_przeglad_programow_antywirusowych', 4, 9, 7, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(143, 'Specjaliści od przycisków', '', 66, 69, 'specjalisci_od_przyciskow', 4, 9, 7, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(144, 'PHP-Nuke czyli „atomowy” system portalowy', '', 76, 80, 'php_nuke_czyli_atomowy_system_portalowy', 5, 12, 7, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(145, 'Zrób to sam: trójwymiarowy przycisk', '', 81, 81, 'zrob_to_sam_trojwymiarowy_przycisk', 5, 12, 7, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(146, 'PHP4: ukryta moc. Część 2', '', 82, 85, 'php4_ukryta_moc_czesc_2', 5, 12, 7, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(147, 'Arkana szybkiego pobierania plików: Net Vampire', '', 86, 87, 'arkana_szybkiego_pobierania_plikow_net_vampire', 5, 12, 7, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(148, 'PHP Po stronie serwera (cz. 8)', '', 88, 91, 'php_po_stronie_serwera_cz_8', 5, 11, 7, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(149, 'Flash i efekty specjalne. Proste animacje rozrywkowe', '', 92, 95, 'flash_i_efekty_specjalne_proste_animacje_rozrywkowe', 7, 21, 7, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(150, 'Application Service Providers w Polsce', '', 14, 21, 'application_service_providers_w_polsce', 3, 22, 8, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(151, 'Negocjacje przez Internet', '', 22, 25, 'negocjacje_przez_internet', 3, 5, 8, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(152, 'Przewodnik webmastera', '', 32, 39, 'przewodnik_webmastera', 2, 4, 8, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(153, 'Polacy nie gęsi... i swój interfejs mają', '', 40, 42, 'polacy_nie_gesi_i_swoj_interfejs_maja', 2, 4, 8, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(154, 'Miraż złotych gór, czyli cała prawda o reklamie internetowej', '', 43, 45, 'miraz_zlotych_gor_czyli_cala_prawda_o_reklamie_internetowej', 2, 5, 8, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(155, 'Szkoły w sieci. Część 2', '', 46, 49, 'szkoly_w_sieci_czesc_2', 2, 3, 8, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(156, 'PRV.PL był zawsze nastawiony na użytkowników...', '', 50, 51, 'prv_pl_byl_zawsze_nastawiony_na_uzytkownikow', 2, 6, 8, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(157, 'Internet Explorer 6.0', '', 54, 55, 'internet_explorer_6_0', 4, 8, 8, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(158, 'FrontPage 2002 PL', '', 56, 57, 'frontpage_2002_pl', 4, 8, 8, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(159, 'DHTML Menu Builder 3', '', 58, 61, 'dhtml_menu_builder_3', 4, 8, 8, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(160, 'Serwery WWW dla każdego', '', 62, 65, 'serwery_www_dla_kazdego', 4, 9, 8, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(161, 'Matrox Millenium G550', '', 70, 71, 'matrox_millenium_g550', 6, 19, 8, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(162, 'Trzeci wymiar Internetu. Adobe Atmosphere', '', 72, 75, 'trzeci_wymiar_internetu_adobe_atmosphere', 5, 12, 8, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(163, 'PHP4: ukryta moc. Część 3', '', 76, 80, 'php4_ukryta_moc_czesc_3', 5, 12, 8, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(164, 'Operacja „Intruz w systemie”. Poradnik administratora', '', 81, 83, 'operacja_intruz_w_systemie_poradnik_administratora', 5, 12, 8, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(165, 'Arkana szybkiego pobierania plików: REGET', '', 84, 85, 'arkana_szybkiego_pobierania_plikow_reget', 5, 12, 8, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(166, 'Flash i efekty specjalne. Gra zręcznościowa (1)', '', 86, 89, 'flash_i_efekty_specjalne_gra_zrecznosciowa_1', 7, 21, 8, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(167, 'PHP Po stronie serwera (cz. 9)', '', 90, 94, 'php_po_stronie_serwera_cz_9', 5, 11, 8, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(168, 'Formularze ActiveForm', '', 95, 95, 'formularze_activeform', 5, 4, 8, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(169, 'Łącza stałe: przegląd rynku', '', 16, 27, 'lacza_stale_przeglad_rynku', 3, 22, 9, 12);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(170, 'Zarabianie w Internecie', '', 28, 33, 'zarabianie_w_internecie', 3, 4, 9, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(171, '10 lat polskiego Internetu', '', 40, 45, '10_lat_polskiego_internetu', 2, 18, 9, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(172, 'MP3 Protest Song, czyli opowiastka o tym jak muzycy chcieli wyrolować internautów, ale internauci się nie dali', '', 46, 49, 'mp3_protest_song_czyli_opowiastka_o_tym_jak_muzycy_chcieli_wyrolowac_internautow_ale_internauci_sie_nie_dali', 2, 4, 9, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(173, 'Robaki internetowe', '', 50, 53, 'robaki_internetowe', 2, 4, 9, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(174, 'Fundacje w sieci', '', 54, 57, 'fundacje_w_sieci', 2, 3, 9, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(175, 'Warszawskie Technopolis', '', 58, 59, 'warszawskie_technopolis', 2, 6, 9, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(176, 'Przeglądarka dla juniora', '', 62, 65, 'przegladarka_dla_juniora', 4, 9, 9, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(177, 'Sound Blaster Audigy Platinum eX', '', 70, 71, 'sound_blaster_audigy_platinum_ex', 6, 19, 9, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(178, 'Trzeci wymiar Internetu. Pulse 3D', '', 72, 75, 'trzeci_wymiar_internetu_pulse_3d', 5, 12, 9, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(179, 'PHP4: ukryta moc. Część 4', '', 76, 81, 'php4_ukryta_moc_czesc_4', 5, 12, 9, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(180, 'Arkana szybkiego pobierania plików: NETANTS', '', 82, 83, 'arkana_szybkiego_pobierania_plikow_netants', 5, 12, 9, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(181, 'Flash i efekty specjalne. Gra zręcznościowa (2)', '', 84, 87, 'flash_i_efekty_specjalne_gra_zrecznosciowa_2', 7, 21, 9, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(182, 'PHP Po stronie serwera (cz. 10)', '', 88, 91, 'php_po_stronie_serwera_cz_10', 5, 11, 9, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(183, 'Tuning sieci LAN', '', 92, 95, 'tuning_sieci_lan', 5, 12, 9, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(184, 'Internet przez radio', '', 14, 21, 'internet_przez_radio', 3, 22, 10, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(185, 'Web positioning', '', 22, 25, 'web_positioning', 3, 17, 10, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(186, 'Płatny hosting. Coraz lepszy, coraz tańszy...', '', 26, 27, 'platny_hosting_coraz_lepszy_coraz_tanszy', 3, 17, 10, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(187, 'Internet w gniazdku z prądem', '', 36, 39, 'internet_w_gniazdku_z_pradem', 2, 5, 10, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(188, 'Z komputera na telefon', '', 40, 45, 'z_komputera_na_telefon', 2, 4, 10, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(189, 'ATM od kuchni', '', 46, 49, 'atm_od_kuchni', 2, 24, 10, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(190, 'Informacje pod ręką', '', 50, 53, 'informacje_pod_reka', 2, 3, 10, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(191, 'Po bezpiecznej stronie Internetu', '', 54, 56, 'po_bezpiecznej_stronie_internetu', 2, 6, 10, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(192, 'Windows XP Professional', '', 60, 61, 'windows_xp_professional', 4, 8, 10, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(193, 'Norton Internet Security 2002', '', 62, 63, 'norton_internet_security_2002', 4, 8, 10, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(194, 'Norton Ghost 2002', '', 64, 64, 'norton_ghost_2002', 4, 8, 10, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(195, 'J-Perk 6.02', '', 65, 65, 'j_perk_6_02', 4, 8, 10, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(196, 'AutoMail 2.0', '', 65, 65, 'automail_2_0', 4, 8, 10, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(197, 'CodeCharge', '', 66, 69, 'codecharge', 4, 8, 10, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(198, 'Cyfrowy wartownik', '', 70, 73, 'cyfrowy_wartownik', 4, 9, 10, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(199, 'Sony SDM-N80', '', 76, 76, 'sony_sdm_n80', 6, 19, 10, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(200, 'Trzeci wymiar Internetu. Macromedia Director 8.5 (cz. 1)', '', 78, 81, 'trzeci_wymiar_internetu_macromedia_director_8_5_cz_1', 5, 12, 10, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(201, 'PHP4: ukryta moc. Część 5', '', 82, 87, 'php4_ukryta_moc_czesc_5', 5, 12, 10, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(202, 'Arkana szybkiego pobierania plików: FLASHGET', '', 88, 89, 'arkana_szybkiego_pobierania_plikow_flashget', 5, 12, 10, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(203, 'Flash i efekty specjalne. Quiz online', '', 90, 93, 'flash_i_efekty_specjalne_quiz_online', 7, 21, 10, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(204, 'Tworzymy serwer WWW', '', 94, 95, 'tworzymy_serwer_www', 7, 29, 10, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(205, 'PHP GTK. Coś pożytecznego dla webmastera', '', 96, 97, 'php_gtk_cos_pozytecznego_dla_webmastera', 7, 29, 10, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(206, 'Rekrutacja online', '', 12, 16, 'rekrutacja_online', 3, 22, 11, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(207, 'E-podpis i co dalej', '', 18, 23, 'e_podpis_i_co_dalej', 3, 5, 11, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(208, 'Sieciowe biura ogłoszeń', '', 24, 27, 'sieciowe_biura_ogloszen', 3, 17, 11, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(209, 'Od domeny do strony WWW', '', 36, 41, 'od_domeny_do_strony_www', 2, 4, 11, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(210, 'Prześlij znajomemu', '', 42, 44, 'przeslij_znajomemu', 2, 4, 11, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(211, 'Oceń jakość informacji', '', 46, 48, 'ocen_jakosc_informacji', 2, 4, 11, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(212, 'Co to jest społeczeństwo informacyjne?', '', 49, 49, 'co_to_jest_spoleczenstwo_informacyjne', 2, 15, 11, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(213, 'Newslettery: wszystko na e-mil', '', 50, 53, 'newslettery_wszystko_na_e_mil', 2, 3, 11, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(214, 'Informacje pod ręką, część 2', '', 54, 57, 'informacje_pod_reka_czesc_2', 2, 3, 11, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(215, 'Sam sobie daj podwyżkę!', 'Z Arturem Więckowskim, dyrektorem ds. marketingu Inteligo Financial Services SA, rozmawia Ewa Miller-Stefańska.', 58, 59, 'sam_sobie_daj_podwyzke', 2, 6, 11, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(216, 'Quo vadis pakiecie?', '', 62, 63, 'quo_vadis_pakiecie2', 4, 9, 11, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(217, 'Zapory ogniowe', '', 64, 68, 'zapory_ogniowe', 4, 9, 11, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(218, 'Kylix 2 Enterprise', '', 69, 69, 'kylix_2_enterprise', 4, 8, 11, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(219, 'Zamiast Internet Explorera: NetCaptor', '', 70, 70, 'zamiast_internet_explorera_netcaptor', 4, 8, 11, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(220, 'Yupi', '', 71, 71, 'yupi', 4, 8, 11, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(221, 'Minolta Dimage 7', '', 74, 75, 'minolta_dimage_7', 6, 19, 11, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(222, 'Sony G420', '', 76, 76, 'sony_g420', 6, 19, 11, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(223, 'Logitech Cordless Desktop Optical', '', 77, 77, 'logitech_cordless_desktop_optical', 6, 19, 11, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(224, 'Trzeci wymiar Internetu. Macromedia Director 8.5 (cz. 2)', '', 78, 81, 'trzeci_wymiar_internetu_macromedia_director_8_5_cz_2', 5, 12, 11, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(225, 'Arkana szybkiego pobierania plików: Mass Downloader', '', 82, 83, 'arkana_szybkiego_pobierania_plikow_mass_downloader', 5, 12, 11, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(226, 'PHP4: ukryta moc, część 6', '', 84, 88, 'php4_ukryta_moc_czesc_6', 5, 12, 11, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(227, 'Photoshop.to.jest.to. Kurs dla webmasterów (cz. 1)', '', 85, 91, 'photoshop_to_jest_to_kurs_dla_webmasterow_cz_1', 5, 30, 11, 7);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(228, 'Flash i efekty specjalne. Flash, HTML i Projektor EXE', '', 92, 95, 'flash_i_efekty_specjalne_flash_html_i_projektor_exe', 5, 21, 11, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(229, 'SMIL. Język opisu multimediów w Internecie', '', 96, 97, 'smil_jezyk_opisu_multimediow_w_internecie', 5, 29, 11, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(230, 'Gdy hosting nie wystarcza. Serwery wirtualne', '', 12, 14, 'gdy_hosting_nie_wystarcza_serwery_wirtualne', 3, 22, 12, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(231, 'Kampanie reklamowe w Internecie', '', 15, 19, 'kampanie_reklamowe_w_internecie', 3, 31, 12, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(232, 'Planowanie, organizowanie i wdrażanie projektu internetowego', '', 20, 21, 'planowanie_organizowanie_i_wdrazanie_projektu_internetowego', 3, 4, 12, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(233, 'Contact Center: klient to nasz pan', '', 22, 23, 'contact_center_klient_to_nasz_pan', 3, 5, 12, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(234, 'Bezprzewodowy zawrót głowy', '', 30, 35, 'bezprzewodowy_zawrot_glowy', 2, 24, 12, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(235, 'Królestwo warezu', '', 36, 39, 'krolestwo_warezu', 2, 3, 12, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(236, 'Kobiety w sieci', '', 40, 43, 'kobiety_w_sieci', 2, 3, 12, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(237, 'Wyszukiwarka z Atomz', '', 44, 46, 'wyszukiwarka_z_atomz', 2, 4, 12, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(238, 'Forum dyskusyjne. Niezbędne na każdej szanującej się witrynie...', '', 47, 51, 'forum_dyskusyjne_niezbedne_na_kazdej_szanujacej_sie_witrynie', 2, 4, 12, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(239, 'Dogonić Internet...', 'Z Łukaszem Lewandowskim i Arturem Banachem, koordynatorami wyszukiwarki NetSprint.pl, rozmawia Damian Jarosz.', 52, 53, 'dogonic_internet', 2, 6, 12, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(240, 'Zajączek', '', 56, 59, 'zajaczek', 4, 8, 12, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(241, 'Precz z reklamami!', '', 60, 62, 'precz_z_reklamami', 4, 9, 12, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(242, 'Podaj hasło', '', 63, 65, 'podaj_haslo', 4, 9, 12, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(243, 'Asmax Neo', '', 68, 69, 'asmax_neo', 6, 19, 12, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(244, 'Mustek MDC 3000', '', 69, 69, 'mustek_mdc_3000', 6, 19, 12, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(245, 'Video Blaster WebCam 5', '', 70, 70, 'video_blaster_webcam_5', 6, 19, 12, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(246, 'LG Combo GCC-4120B', '', 71, 71, 'lg_combo_gcc_4120b', 6, 19, 12, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(247, 'Trzeci wymiar Internetu. Nemo Creation (cz. 1)', '', 72, 75, 'trzeci_wymiar_internetu_nemo_creation_cz_1', 5, 12, 12, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(248, 'Stanowisko testowe PHP, część 1. Apache, PHP i MySQL w okienkach', '', 76, 79, 'stanowisko_testowe_php_czesc_1_apache_php_i_mysql_w_okienkach', 5, 12, 12, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(249, 'Arkana szybkiego pobierania plików: Freshdownload', '', 80, 81, 'arkana_szybkiego_pobierania_plikow_freshdownload', 5, 12, 12, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(250, 'PHP4: ukryta moc, część 7', '', 82, 86, 'php4_ukryta_moc_czesc_7', 5, 12, 12, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(251, 'FrontPage 2002/XP Kurs budowy serwisu internetowego', '', 87, 89, 'frontpage_2002_xp_kurs_budowy_serwisu_internetowego', 5, 12, 12, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(252, 'Photoshop.to.jest.to. Kurs dla webmasterów (cz. 2)', '', 90, 93, 'photoshop_to_jest_to_kurs_dla_webmasterow_cz_2', 5, 30, 12, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(253, 'Flash i efekty specjalne. Dreamweaver — narzędzie profesjonalistów', '', 94, 97, 'flash_i_efekty_specjalne_dreamweaver_narzedzie_profesjonalistow', 5, 21, 12, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(254, 'Część 1: Dostęp do Internetu', '', 115, 126, 'czesc_1_dostep_do_internetu', 8, 32, 12, 12);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(255, 'Telefonia VoIP', '', 12, 15, 'telefonia_voip', 3, 22, 13, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(256, 'Planowanie, organizowanie i wdrażanie projektu internetowego (cz. 2)', '', 16, 18, 'planowanie_organizowanie_i_wdrazanie_projektu_internetowego_cz_2', 3, 4, 13, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(257, 'Bezpieczeństwo w handlu elektronicznym', '', 20, 25, 'bezpieczenstwo_w_handlu_elektronicznym', 3, 5, 13, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(258, 'Gdzie żyją m@łpy?', '', 32, 34, 'gdzie_zyja_m_lpy', 2, 4, 13, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(259, 'Konta shellowe', '', 36, 37, 'konta_shellowe', 2, 4, 13, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(260, 'Radiostacja w sieci, czyli jak uruchomić radio internetowe', '', 38, 41, 'radiostacja_w_sieci_czyli_jak_uruchomic_radio_internetowe', 2, 4, 13, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(261, 'Najważniejsza jest oryginalność', 'Z Dariuszem Wadowskim, redaktorem naczelnym magazynu internetowego @t (http://at.g.pl), rozmawia Maciej Kunowski.', 42, 43, 'najwazniejsza_jest_oryginalnosc', 2, 6, 13, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(262, 'Wrogowie Internetu', '', 44, 47, 'wrogowie_internetu', 2, 3, 13, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(263, 'Rankingi stron WWW', '', 48, 50, 'rankingi_stron_www', 2, 3, 13, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(264, 'Wirtualna Bridżet Dżonson', '', 51, 51, 'wirtualna_bridzet_dzonson', 2, 15, 13, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(265, 'Direct Connect', '', 54, 57, 'direct_connect', 4, 8, 13, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(266, 'JBuilder 6 Enterprise', '', 58, 60, 'jbuilder_6_enterprise', 4, 8, 13, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(267, 'Specjaliści od pogawędek', '', 62, 63, 'specjalisci_od_pogawedek', 4, 9, 13, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(268, 'Trzeci wymiar Internetu. Nemo Creation (cz. 2)', '', 68, 71, 'trzeci_wymiar_internetu_nemo_creation_cz_2', 5, 12, 13, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(269, 'PHP4: ukryta moc, część 8', '', 72, 74, 'php4_ukryta_moc_czesc_8', 5, 12, 13, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(270, 'FrontPage 2002/XP Kurs budowy serwisu internetowego', '', 75, 75, 'frontpage_2002_xp_kurs_budowy_serwisu_internetowego2', 5, 12, 13, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(271, 'Arkana szybkiego pobierania plików: Advanced Internet Tool', '', 76, 77, 'arkana_szybkiego_pobierania_plikow_advanced_internet_tool', 5, 12, 13, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(272, 'Stanowisko testowe PHP, część 2. Apache, PHP i MySQL w okienkach', '', 78, 81, 'stanowisko_testowe_php_czesc_2_apache_php_i_mysql_w_okienkach', 5, 12, 13, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(273, 'Photoshop.to.jest.to. Kurs dla webmasterów (cz. 3)', '', 82, 85, 'photoshop_to_jest_to_kurs_dla_webmasterow_cz_3', 5, 30, 13, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(274, 'Flash i efekty specjalne. Generator (cz. 1)', '', 86, 89, 'flash_i_efekty_specjalne_generator_cz_1', 5, 21, 13, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(275, 'Część 2: Usługi internetowe', '', 107, 126, 'czesc_2_uslugi_internetowe', 8, 32, 13, 20);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(276, 'Internet a łańcuch wartości dodanej', '', 12, 16, 'internet_a_lancuch_wartosci_dodanej', 3, 5, 14, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(277, '10 najczęściej popełnianych błędów przy projektowaniu i prowadzeniu stron WWW oraz sposoby ich unikania', '', 18, 20, '10_najczesciej_popelnianych_bledow_przy_projektowaniu_i_prowadzeniu_stron_www_oraz_sposoby_ich_unikania', 3, 4, 14, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(278, 'Z przewodnikiem na wirtualne zakupy', '', 21, 23, 'z_przewodnikiem_na_wirtualne_zakupy', 3, 28, 14, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(279, 'Zostań e-wydawcą! Porady praktyczne dla twórców e-zinów', '', 30, 35, 'zostan_e_wydawca_porady_praktyczne_dla_tworcow_e_zinow', 2, 4, 14, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(280, 'MIME. Wszystko warto wiedzieć...', '', 36, 37, 'mime_wszystko_warto_wiedziec', 2, 4, 14, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(281, 'Przydatni pośrednicy. Alternatywne metody ściągania plików', '', 38, 40, 'przydatni_posrednicy_alternatywne_metody_sciagania_plikow', 2, 4, 14, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(282, 'Moje osobiste dane', '', 41, 41, 'moje_osobiste_dane', 2, 15, 14, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(283, 'Pierwsza polska przychodznia internetowa', '', 42, 43, 'pierwsza_polska_przychodznia_internetowa', 2, 26, 14, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(284, 'Bezpłatne książki z Internetu', '', 44, 45, 'bezplatne_ksiazki_z_internetu', 2, 3, 14, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(285, 'Konkursy w Internecie', '', 46, 47, 'konkursy_w_internecie', 2, 3, 14, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(286, 'Bezpieczny e-banking', '', 48, 49, 'bezpieczny_e_banking', 2, 6, 14, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(287, 'Podyskutujmy w Usenecie', '', 52, 56, 'podyskutujmy_w_usenecie', 4, 9, 14, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(288, 'Opera 6.01', '', 57, 57, 'opera_6_01', 4, 8, 14, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(289, 'Browse 3D', '', 58, 58, 'browse_3d', 4, 8, 14, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(290, 'Xara Webstyle', '', 59, 61, 'xara_webstyle', 4, 8, 14, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(291, 'Creative PC-Cam 600', '', 64, 65, 'creative_pc_cam_600', 6, 19, 14, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(292, 'LG GCE-8240B', '', 67, 67, 'lg_gce_8240b', 6, 19, 14, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(293, 'Trzeci wymiar Internetu. 3D Web Maker (cz. 1)', '', 68, 71, 'trzeci_wymiar_internetu_3d_web_maker_cz_1', 5, 12, 14, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(294, 'Formularze w JavaScript', '', 72, 75, 'formularze_w_javascript', 5, 12, 14, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(295, 'PHP4: ukryta moc, część 9', '', 76, 79, 'php4_ukryta_moc_czesc_9', 5, 12, 14, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(296, 'Arkana szybkiego pobierania plików: Star Downloader', '', 80, 81, 'arkana_szybkiego_pobierania_plikow_star_downloader', 5, 12, 14, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(297, 'Photoshop.to.jest.to. Kurs dla webmasterów (cz. 4)', '', 82, 84, 'photoshop_to_jest_to_kurs_dla_webmasterow_cz_4', 5, 30, 14, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(298, 'Flash i efekty specjalne. Generator (cz. 2)', '', 86, 89, 'flash_i_efekty_specjalne_generator_cz_2', 5, 21, 14, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(299, 'Część 3: Własna domena', '', 107, 122, 'czesc_3_wlasna_domena', 8, 32, 14, 16);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(300, 'Bezpieczeństwo informacji w firmie', '', 14, 17, 'bezpieczenstwo_informacji_w_firmie', 3, 4, 15, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(301, 'Firmowe biuletyny elektroniczne. Element skutecznej promocji', '', 18, 21, 'firmowe_biuletyny_elektroniczne_element_skutecznej_promocji', 3, 31, 15, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(302, 'Serwis dobrze zarządzany, czyli o rozwiązaniach CMS', '', 22, 24, 'serwis_dobrze_zarzadzany_czyli_o_rozwiazaniach_cms', 3, 24, 15, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(303, 'Serwisy finansowe', '', 26, 27, 'serwisy_finansowe', 3, 22, 15, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(304, 'Proxy. Internetowy akcelerator', '', 32, 35, 'proxy_internetowy_akcelerator', 2, 4, 15, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(305, 'Gotowe szablony stron WWW', '', 36, 37, 'gotowe_szablony_stron_www', 2, 4, 15, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(306, 'Wydawanie książek w sieci', '', 38, 42, 'wydawanie_ksiazek_w_sieci', 2, 4, 15, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(307, 'Taka sobie sprawa', '', 43, 43, 'taka_sobie_sprawa', 2, 15, 15, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(308, 'Nauka przez Internet', '', 44, 45, 'nauka_przez_internet', 2, 3, 15, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(309, 'Szukanie igły w sieci', '', 46, 51, 'szukanie_igly_w_sieci', 2, 5, 15, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(310, 'Telezdrowie, czyli diagnostyka i rehabilitacja przez Internet', '', 52, 53, 'telezdrowie_czyli_diagnostyka_i_rehabilitacja_przez_internet', 2, 6, 15, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(311, 'Flash MX. Nowa wizja Internetu', '', 56, 57, 'flash_mx_nowa_wizja_internetu', 4, 8, 15, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(312, 'Taryfikatory połączeń internetowych', '', 58, 61, 'taryfikatory_polaczen_internetowych2', 4, 9, 15, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(313, 'Asmax BR-804', '', 64, 64, 'asmax_br_804', 6, 19, 15, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(314, 'Yamaha CRW-70', '', 65, 65, 'yamaha_crw_70', 6, 19, 15, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(315, 'Trzeci wymiar Internetu. 3D Web Maker (cz. 2)', '', 66, 69, 'trzeci_wymiar_internetu_3d_web_maker_cz_2', 5, 12, 15, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(316, 'PHP4: ukryta moc, część 10', '', 70, 73, 'php4_ukryta_moc_czesc_10', 5, 12, 15, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(317, 'Adobe GoLive w praktyce (część 1)', '', 74, 76, 'adobe_golive_w_praktyce_czesc_1', 5, 12, 15, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(318, 'Formularze w JavaScript (część 2)', '', 77, 79, 'formularze_w_javascript_czesc_2', 5, 12, 15, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(319, 'Arkana szybkiego pobierania plików: Download Mage', '', 80, 81, 'arkana_szybkiego_pobierania_plikow_download_mage', 5, 12, 15, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(320, 'Photoshop.to.jest.to. Kurs dla webmasterów (cz. 5)', '', 82, 85, 'photoshop_to_jest_to_kurs_dla_webmasterow_cz_5', 5, 30, 15, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(321, 'Flash i efekty specjalne. Generator (cz. 3)', '', 86, 89, 'flash_i_efekty_specjalne_generator_cz_3', 5, 21, 15, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(322, 'Część 4: Firmowa strona WWW', '', 107, 119, 'czesc_4_firmowa_strona_www', 8, 32, 15, 13);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(323, 'Karty płatnicze i wirtualne portmonetki', '', 30, 35, 'karty_platnicze_i_wirtualne_portmonetki', 1, 32, 16, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(324, 'MMS, czyli multimedia w komórce', '', 36, 38, 'mms_czyli_multimedia_w_komorce', 2, 5, 16, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(325, 'On-line do funduszu emerytalnego...', '', 39, 39, 'on_line_do_funduszu_emerytalnego', 2, 33, 16, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(326, 'Cena e-kultury', '', 40, 42, 'cena_e_kultury', 2, 3, 16, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(327, 'Internet w SMS-ach', '', 44, 47, 'internet_w_sms_ach', 2, 4, 16, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(328, 'Gdzie na urlop?', '', 48, 49, 'gdzie_na_urlop', 2, 4, 16, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(329, 'SPAM, robaczywe .COM-binacje oraz URL-owe szachrajstwa', '', 50, 52, 'spam_robaczywe_com_binacje_oraz_url_owe_szachrajstwa', 2, 4, 16, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(330, 'Seks w Internecie', '', 53, 53, 'seks_w_internecie', 2, 15, 16, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(331, 'Zagraniczne serwery darmowych kont WWW', '', 54, 55, 'zagraniczne_serwery_darmowych_kont_www', 3, 22, 16, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(332, 'Serwisy turystyczne', '', 56, 59, 'serwisy_turystyczne', 3, 22, 16, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(333, 'Rodzaje stron internetowych', '', 60, 63, 'rodzaje_stron_internetowych', 3, 31, 16, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(334, 'Ochrona konsumenta w Internecie', '', 64, 64, 'ochrona_konsumenta_w_internecie', 3, 4, 16, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(335, 'Akceleratory internetowe', '', 66, 71, 'akceleratory_internetowe', 4, 9, 16, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(336, 'Outlook Express na maksa', '', 72, 75, 'outlook_express_na_maksa', 4, 4, 16, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(337, 'Kontrolki ActiveX. Osadzanie kontrolek ActiveX w dokumentach WWW.', '', 76, 78, 'kontrolki_activex_osadzanie_kontrolek_activex_w_dokumentach_www', 5, 12, 16, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(338, 'Adobe GoLive: formularze', '', 79, 81, 'adobe_golive_formularze', 5, 12, 16, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(339, 'Photoshop.to.jest.to', '', 82, 85, 'photoshop_to_jest_to', 5, 30, 16, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(340, 'Część 5: Tworzenie stron WWW', '', 99, 118, 'czesc_5_tworzenie_stron_www', 8, 32, 16, 20);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(341, 'Jak się reklamować w Internecie?', '', 26, 29, 'jak_sie_reklamowac_w_internecie', 1, 32, 17, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(342, 'Brokerzy reklam', '', 30, 33, 'brokerzy_reklam', 1, 32, 17, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(343, 'Reklamuj się w wyszukiwarkach!', '', 34, 35, 'reklamuj_sie_w_wyszukiwarkach', 1, 32, 17, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(344, 'Medyczne serwisy WWW', '', 36, 40, 'medyczne_serwisy_www', 3, 22, 17, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(345, 'Rząd w Internecie, czyli e-Government po polsku', '', 41, 43, 'rzad_w_internecie_czyli_e_government_po_polsku', 3, 5, 17, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(346, 'Lojalność e-klienta', '', 44, 47, 'lojalnosc_e_klienta', 3, 31, 17, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(347, 'Panoramy na WWW', '', 48, 51, 'panoramy_na_www', 2, 4, 17, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(348, 'Etat z Internetu', '', 52, 53, 'etat_z_internetu', 2, 4, 17, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(349, 'Ja, webmaster...czyli jak zdobyć zlecenie na wykonanie strony WWW.', '', 54, 57, 'ja_webmaster_czyli_jak_zdobyc_zlecenie_na_wykonanie_strony_www', 2, 4, 17, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(350, 'Ukryty Internet', '', 58, 60, 'ukryty_internet', 2, 4, 17, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(351, 'Kły, zęby, pazury i paznokcie', '', 61, 61, 'kly_zeby_pazury_i_paznokcie', 2, 15, 17, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(352, 'Wolna Encyklopedia Sieciowa', '', 62, 63, 'wolna_encyklopedia_sieciowa', 2, 3, 17, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(353, 'Internetowe agencje Public Relations', '', 64, 65, 'internetowe_agencje_public_relations', 2, 6, 17, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(354, 'Łowcy spamu', '', 66, 69, 'lowcy_spamu', 4, 9, 17, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(355, 'IncrediMail XE', '', 70, 71, 'incredimail_xe', 4, 8, 17, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(356, 'Actual Drawing', '', 72, 72, 'actual_drawing', 4, 8, 17, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(357, 'Virtual Village 1.6', '', 73, 73, 'virtual_village_1_6', 4, 8, 17, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(358, 'ColdFusion', '', 74, 77, 'coldfusion', 5, 12, 17, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(359, 'Kontrolki ActiveX. Projektowanie kontrolek ActiveX wykorzystujących klasy MFC', '', 78, 81, 'kontrolki_activex_projektowanie_kontrolek_activex_wykorzystujacych_klasy_mfc', 5, 12, 17, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(360, 'Photoshop.to.jest.to', '', 82, 85, 'photoshop_to_jest_to2', 5, 30, 17, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(361, 'Część 6: Co każdy internauta wiedzieć powinien', '', 99, 110, 'czesc_6_co_kazdy_internauta_wiedziec_powinien', 8, 32, 17, 12);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(362, 'Kolokacja i serwery dedykowane', '', 28, 35, 'kolokacja_i_serwery_dedykowane', 1, 32, 18, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(363, 'Prasa online', '', 36, 41, 'prasa_online', 3, 22, 18, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(364, 'Polskie systemy wymiany banerów', '', 42, 43, 'polskie_systemy_wymiany_banerow', 3, 4, 18, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(365, '„Miasta w Internecie” 2002', '', 44, 47, 'miasta_w_internecie_2002', 3, 18, 18, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(366, 'Google, czyli królowa wyszukiwarek', '', 48, 53, 'google_czyli_krolowa_wyszukiwarek', 2, 4, 18, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(367, 'Internauto, nie daj się oszukać!', '', 54, 55, 'internauto_nie_daj_sie_oszukac', 2, 4, 18, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(368, 'Ciemna strona e-książęk', '', 56, 58, 'ciemna_strona_e_ksiazek', 2, 3, 18, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(369, 'Czy Internet hamuje rozwój czytelnictwa?', '', 59, 59, 'czy_internet_hamuje_rozwoj_czytelnictwa', 2, 3, 18, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(370, 'Policja w sieci', '', 60, 62, 'policja_w_sieci', 2, 3, 18, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(371, 'Mała szkoda i jeszcze mniejszy żal', '', 63, 63, 'mala_szkoda_i_jeszcze_mniejszy_zal', 2, 15, 18, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(372, 'Internet zamiast wywiadówki', '', 64, 65, 'internet_zamiast_wywiadowki', 2, 6, 18, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(373, 'Menadźery zakładek', '', 66, 69, 'menadzery_zakladek', 4, 9, 18, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(374, 'Sprytny Fryderyk', '', 70, 71, 'sprytny_fryderyk', 4, 8, 18, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(375, 'Email Effects', '', 72, 72, 'email_effects', 4, 8, 18, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(376, 'Net.Medic', '', 73, 73, 'net_medic', 4, 8, 18, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(377, 'Adobe GoLive: Publikacja stron na serwerze z WebDav', '', 74, 75, 'adobe_golive_publikacja_stron_na_serwerze_z_webdav', 5, 12, 18, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(378, 'Publikacja witryn internetowych WebDav w IIS', '', 76, 78, 'publikacja_witryn_internetowych_webdav_w_iis', 5, 12, 18, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(379, '3D Flash Animator', '', 79, 81, '3d_flash_animator', 5, 12, 18, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(380, 'Projektowanie kontrolek ActiveX za pomocą ATL', '', 82, 85, 'projektowanie_kontrolek_activex_za_pomoca_atl', 5, 12, 18, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(381, 'Część 7: Promocja internetowa', '', 99, 114, 'czesc_7_promocja_internetowa', 8, 32, 18, 16);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(382, 'Przyjazne strony WWW', '', 30, 35, 'przyjazne_strony_www', 1, 32, 19, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(383, 'Internetowe serwisy edukacyjne', '', 36, 39, 'internetowe_serwisy_edukacyjne', 3, 22, 19, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(384, 'Zbawienna personalizacja, czyli jak zdobyć lojalność e-klientów', '', 40, 43, 'zbawienna_personalizacja_czyli_jak_zdobyc_lojalnosc_e_klientow', 3, 4, 19, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(385, 'Upiększanie adresu. W poszukiwaniu darmowych aliasów', '', 44, 45, 'upiekszanie_adresu_w_poszukiwaniu_darmowych_aliasow', 3, 4, 19, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(386, 'Intranet szyty na miarę', '', 46, 48, 'intranet_szyty_na_miare', 3, 5, 19, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(387, 'Fundusz emerytalny on-line', '', 47, 47, 'fundusz_emerytalny_on_line', 9, 32, 19, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(388, 'Internet zamiast szkoły? Najnowsze zasoby edukacyjne', '', 50, 53, 'internet_zamiast_szkoly_najnowsze_zasoby_edukacyjne', 2, 25, 19, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(389, 'Cyberterroryzm', '', 54, 56, 'cyberterroryzm', 2, 3, 19, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(390, 'Talk-show z komputerem. Technologia Lingubot podbija Internet', '', 57, 59, 'talk_show_z_komputerem_technologia_lingubot_podbija_internet', 2, 3, 19, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(391, 'Prywatność w Internecie', '', 60, 62, 'prywatnosc_w_internecie', 2, 4, 19, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(392, 'Internetowe fotolaby', '', 64, 66, 'internetowe_fotolaby', 2, 4, 19, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(393, 'Woodstock od internetowej kuchni', '', 67, 67, 'woodstock_od_internetowej_kuchni', 2, 15, 19, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(394, 'Z ufnością w przyszłość', '', 68, 69, 'z_ufnoscia_w_przyszlosc', 2, 6, 19, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(395, 'Kompresory HTML', '', 70, 73, 'kompresory_html', 4, 9, 19, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(396, 'Projekt XXI', '', 74, 74, 'projekt_xxi', 4, 8, 19, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(397, 'Internet Download Manager', '', 75, 75, 'internet_download_manager', 4, 4, 19, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(398, 'ActiveX dla serwera ASP', '', 76, 79, 'activex_dla_serwera_asp', 5, 12, 19, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(399, 'Statyczne i dynamiczne obrazy dla stron WWW. Adobe Live Motion 2', '', 80, 82, 'statyczne_i_dynamiczne_obrazy_dla_stron_www_adobe_live_motion_2', 5, 30, 19, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(400, 'Część 8: Bezpieczeństwo w sieci', '', 99, 110, 'czesc_8_bezpieczenstwo_w_sieci', 8, 32, 19, 12);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(401, 'Peer-to-peer. Zmierzch technologii?', '', 28, 33, 'peer_to_peer_zmierzch_technologii', 1, 32, 20, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(402, 'Stacje radiowe w sieci', '', 34, 39, 'stacje_radiowe_w_sieci', 3, 22, 20, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(403, 'Nic za darmo. Korzystanie z portali będzie płatne.', '', 40, 41, 'nic_za_darmo_korzystanie_z_portali_bedzie_platne', 3, 5, 20, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(404, 'Internetowe przekazy pieniężne w Polsce', '', 42, 44, 'internetowe_przekazy_pieniezne_w_polsce', 3, 5, 20, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(405, 'Reklama w niełasce', '', 45, 45, 'reklama_w_nielasce', 3, 31, 20, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(406, 'Opodatkowanie handlu elektronicznego', '', 46, 49, 'opodatkowanie_handlu_elektronicznego', 3, 34, 20, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(407, 'Wirtualni ludzie', '', 50, 53, 'wirtualni_ludzie', 2, 3, 20, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(408, 'Syzyfowa praca. Uchronić przed zapomnieniem dziesięć miliardów stron WWW? Czemu nie!', '', 54, 56, 'syzyfowa_praca_uchronic_przed_zapomnieniem_dziesiec_miliardow_stron_www_czemu_nie', 2, 3, 20, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(409, 'Podpuchy w sieci', '', 57, 57, 'podpuchy_w_sieci', 2, 15, 20, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(410, 'Boty — ircowi strażnicy', '', 58, 61, 'boty_ircowi_straznicy', 2, 4, 20, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(411, 'Elektroniczna swatka', '', 62, 63, 'elektroniczna_swatka', 2, 6, 20, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(412, 'Edytory WML', '', 64, 67, 'edytory_wml', 4, 9, 20, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(413, 'Netscape 7', '', 68, 69, 'netscape_7', 4, 8, 20, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(414, 'Outlook Express Backup', '', 70, 71, 'outlook_express_backup', 4, 8, 20, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(415, 'Cogitum software', '', 71, 71, 'cogitum_software', 4, 8, 20, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(416, 'Przyłapać PHP', '', 72, 75, 'przylapac_php', 5, 11, 20, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(417, 'Newsy dla każdego', '', 76, 77, 'newsy_dla_kazdego', 5, 12, 20, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(418, 'ColdFusion MX. Weryfikacja danych: praca z Dreamweaverem MX', '', 78, 81, 'coldfusion_mx_weryfikacja_danych_praca_z_dreamweaverem_mx', 5, 12, 20, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(419, 'Fireworks MX', '', 82, 85, 'fireworks_mx', 5, 30, 20, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(420, 'Część 9: Sklep online', '', 99, 106, 'czesc_9_sklep_online', 8, 32, 20, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(421, 'Bezpieczne aukcje. Strzeż się oszustów!', '', 28, 35, 'bezpieczne_aukcje_strzez_sie_oszustow', 1, 32, 21, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(422, 'Inwestycyjny poradnik internauty', '', 36, 38, 'inwestycyjny_poradnik_internauty', 3, 35, 21, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(423, 'Mikropłatności SMS. Zarabiaj na swoim serwisie internetowym!', '', 39, 41, 'mikroplatnosci_sms_zarabiaj_na_swoim_serwisie_internetowym', 3, 34, 21, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(424, 'Czy NEToskop będzie polskim Googlem?', '', 42, 45, 'czy_netoskop_bedzie_polskim_googlem', 3, 5, 21, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(425, 'Neostrada Plus. Szerokopasmowy tor przeszkód?', '', 46, 51, 'neostrada_plus_szerokopasmowy_tor_przeszkod', 2, 17, 21, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(426, 'Open Source w Internecie', '', 52, 56, 'open_source_w_internecie', 2, 36, 21, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(427, 'Wredność nad wrednościami', '', 57, 57, 'wrednosc_nad_wrednosciami', 2, 15, 21, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(428, 'Tuning Outlook Expressa', '', 58, 60, 'tuning_outlook_expressa', 2, 4, 21, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(429, 'Upiększanie mIRC-a', '', 62, 63, 'upiekszanie_mirc_a', 2, 4, 21, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(430, 'Metawyszukiwarki', '', 64, 67, 'metawyszukiwarki', 4, 9, 21, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(431, 'Jak wyszpiegować szpiega, czyli jak się pozbyć spyware''u', '', 68, 69, 'jak_wyszpiegowac_szpiega_czyli_jak_sie_pozbyc_spyware_u', 4, 4, 21, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(432, 'Download Express', '', 70, 71, 'download_express', 4, 8, 21, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(433, 'JBuilder 7', '', 72, 73, 'jbuilder_7', 4, 8, 21, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(434, 'Programowanie sieciowe w Javie. Czym są gniazda?', '', 74, 77, 'programowanie_sieciowe_w_javie_czym_sa_gniazda', 5, 12, 21, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(435, 'Flash MX w praktyce. Cisza, światło, projekcja', '', 78, 80, 'flash_mx_w_praktyce_cisza_swiatlo_projekcja', 5, 12, 21, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(436, 'ImageReady. Przyjazne projektowanie grafiki', '', 81, 83, 'imageready_przyjazne_projektowanie_grafiki', 5, 30, 21, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(437, 'Część 10: CRM — zarządzanie relacjami z klientami', '', 99, 114, 'czesc_10_crm_zarzadzanie_relacjami_z_klientami', 8, 32, 21, 16);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(438, 'Internetowe biura pośrednictwa pracy. Jak zdobyć wymarzoną pracę nie wychodząc z domu?', '', 30, 35, 'internetowe_biura_posrednictwa_pracy_jak_zdobyc_wymarzona_prace_nie_wychodzac_z_domu', 1, 32, 22, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(439, 'Serwisy WWW dla programistów', '', 36, 39, 'serwisy_www_dla_programistow', 3, 22, 22, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(440, 'Serwisy randkowe', '', 40, 41, 'serwisy_randkowe', 3, 22, 22, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(441, 'Cyberslacking, czyli szlajanie się po sieci podczas pracy', '', 42, 44, 'cyberslacking_czyli_szlajanie_sie_po_sieci_podczas_pracy', 3, 5, 22, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(442, 'Internetowe agregatory finansowe', '', 46, 49, 'internetowe_agregatory_finansowe', 3, 5, 22, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(443, 'Infoserwisy SMS. Zarabianie w Internecie', '', 50, 51, 'infoserwisy_sms_zarabianie_w_internecie', 3, 34, 22, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(444, 'Software software''owi nierówny. Czytajcie licencje oprogramowania!', '', 52, 55, 'software_software_owi_nierowny_czytajcie_licencje_oprogramowania', 2, 3, 22, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(445, 'MMS, czyli multimedia w komórce', '', 56, 59, 'mms_czyli_multimedia_w_komorce2', 2, 17, 22, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(446, 'Internet bez kabla. Uwolnij wyobraźnię i swój komputer', '', 60, 62, 'internet_bez_kabla_uwolnij_wyobraznie_i_swoj_komputer', 2, 24, 22, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(447, 'Blady strach', '', 63, 63, 'blady_strach', 2, 15, 22, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(448, 'Każdy przecież woli rzeczy piękne', '', 64, 65, 'kazdy_przeciez_woli_rzeczy_piekne', 2, 6, 22, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(449, 'Asy kontrwywiadu, czyli programy antyszpiegowskie', '', 66, 69, 'asy_kontrwywiadu_czyli_programy_antyszpiegowskie', 4, 9, 22, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(450, 'LeetchGet 2002', '', 70, 71, 'leetchget_2002', 4, 4, 22, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(451, 'Programowanie sieciowe w Javie. Transmisja danych', '', 72, 75, 'programowanie_sieciowe_w_javie_transmisja_danych', 5, 12, 22, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(452, 'Galeria zdjęć w PHP', '', 76, 78, 'galeria_zdjec_w_php', 5, 12, 22, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(453, 'LiveMotion. Obrazy statyczne i dynamiczne', '', 79, 81, 'livemotion_obrazy_statyczne_i_dynamiczne', 5, 30, 22, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(454, 'webFAQ. Porady serwisu web.reporter.pl', '', 82, 83, 'webfaq_porady_serwisu_web_reporter_pl', 5, 4, 22, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(455, 'Część 11: E-banking i płatności w Internecie', '', 99, 114, 'czesc_11_e_banking_i_platnosci_w_internecie', 8, 32, 22, 16);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(456, 'Zakładamy sieć osiedlową', 'Kiepskie transfery, co chwila zrywane połączenie, no i ten straszny dzień każdego miesiąca, kiedy listonosz przynosi rachunek telefoniczny — tak jeszcze niedawno wyglądał dostęp do Internetu „po polsku”. A przecież Internet jest powszechny i coraz bardziej potrzebny w codziennym życiu. Stał się tak samo popularnym kanałem informacyjnym jak radio, TV czy prasa.', 32, 37, 'zakladamy_siec_osiedlowa', 1, 32, 23, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(457, 'Profesjonalny e-mail od zaraz!', 'Gdzie założyć konto pocztowe? W pierwszym odruchu każdy z nas zapewne zwróciłby uwagę na bogatą ofertę kont darmowych. Jednak ostatnio coraz więcej portali i operatorów zachęca do korzystania z płatnych skrzynek e-mail, które mają znacznie lepsze parametry. Może więc warto rozważyć te propozycje, zwłaszcza że ceny nie są zbyt wygórowane.', 38, 40, 'profesjonalny_e_mail_od_zaraz', 3, 22, 23, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(458, 'Fachowo i za darmo? Przegląd serwisów z darmowymi komponentami WWW', 'W dzisiejszych czasach słowa „darmo” czy „gratis” zatracają swoje pierwotne znaczenie. Na co dzień spotykamy się z licznymi "promocjami", które — gdy przyjdzie co do czego — okazują się oszustwem. W Internecie jest podobnie, choć ciągle są w nim serwisy oferujące coś naprawdę za darmo. Nietrudno zgadnąć, że na takie usługi jest bardzo duży popyt. Oprócz wszelakich kont największą popularnością cieszą się komponenty do wykorzystania na stronach WWW, takie jak liczniki, księgi gości, fora dyskusyjne.', 0, 0, 'fachowo_i_za_darmo_przeglad_serwisow_z_darmowymi_komponentami_www', 3, 22, 23, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(459, 'Znaczenie zaufania klientów w transakcjach online', 'Brak zaufania klientów do transakcji online to bez wątpienia jedna z głównych barier stojących na drodze rozwoju handlu w sieci. Rynek internetowy będzie należał w przyszłości do tych e-sprzedawców, którzy będą wiedzieć, w jaki sposób pozyskać zaufanie klientów i jak zapewnić ich o bezpieczeństwie transakcji.', 44, 47, 'znaczenie_zaufania_klientow_w_transakcjach_online', 3, 34, 23, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(460, 'Sprytny osiołek, czyli jak zmusić eDonkeya do działania', 'eDonkey to program z gatunku P2P (peer-to-peer) mający kilka unikalnych opcji, które czynią z niego bardzo wydajne i wygodne w użytkowaniu narzędzie. Nie zdobył jednak popularności na miarę KaZy czy iMesha, głównie z powodu wyjątkowo nieprzyjaznej konfiguracji. Mam nadzieję, że zawarte w tym artykule wskazówki przyczynią się do zwiększenia liczby użytkowników tego wartościowego programu.', 48, 51, 'sprytny_osiolek_czyli_jak_zmusic_edonkeya_do_dzialania', 2, 4, 23, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(461, '100 porad dla webmastera', 'Zmysł plastyczny i znajomość kodu HTML są ważne, ale nie mniej istotne jest przestrzeganie pewnych zasad, które uczynią naszą pracę łatwiejszą, a jej odbiorców bardziej zadowolonymi.', 52, 55, '100_porad_dla_webmastera', 2, 4, 23, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(462, 'Jak działa wyszukiwarka?', 'W sieci jest mnóstwo wyszukiwarek, a zasady ich działania są w ogólnych zarysach bardzo zbliżone. Nie oznacza to jednak, że możliwości, funkcjonalność i zasoby wyszukiwarek są takie same, każda stara się akcentować swoją przewagę nad innymi. Niektóre wyróżnia potężna baza, inne bardzo dobrze zindeksowany pewien region, temat lub kraj, wartościowe kryteria oceny stron, znajomość specyfiki języka itd. Zasadnicza idea działania pozostaje jednak bez zmian. Każdą wyszukiwarkę zawsze współtworzą: robot, baza i interfejs użytkownika. Czym są te trzy podstawowe elementy i jakie pełnią funkcje?', 56, 59, 'jak_dziala_wyszukiwarka', 2, 24, 23, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(463, 'Która godzina? O synchronizacji czasu w Internecie', 'Wśród usług internetowych są ogólnie znane — takie jak WWW czy e-mail — a są też mniej popularne, często takie, które używane są tylko przez niewielką grupę „wtajemniczonych”. Wśród tych ostatnich znajduje się między innymi pożyteczny drobiazg, jakim jest usługa synchronizacji czasu.', 60, 62, 'ktora_godzina_o_synchronizacji_czasu_w_internecie', 2, 17, 23, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(464, 'O sztuce pisania mejli', '', 63, 63, 'o_sztuce_pisania_mejli', 2, 15, 23, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(465, 'Obrazki z sieci. Programy do kopiowania plików graficznych', 'Nieprzebrana skarbnica zasobów internetowych sprawia, że codziennie tysiące użytkowników łączy się z siecią celem wykrojenia sobie z tego tortu interesujących danych. Jednym z bardziej poszukiwanych komponentów są pliki graficzne.', 64, 68, 'obrazki_z_sieci_programy_do_kopiowania_plikow_graficznych', 4, 9, 23, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(466, 'Avast32 Home Edition', 'Świadomi istniejących zagrożeń internauci coraz częściej zaopatrują się w oprogramowanie antywirusowe. Jednak w natłoku ofert różnych producentów niełatwo znaleźć produkt, który gwarantowałby duże bezpieczeństwo, a jednocześnie nie próbowałby uzależniać użytkownika od dostaw „świeżych”, niestety płatnych sygnatur. Mnie udało się trafić na taki program.', 69, 70, 'avast32_home_edition', 4, 8, 23, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(467, 'FreeEncrypt for Outlook', 'Zazwyczaj mało kto zaprząta sobie głowę szyfrowaniem poczty elektronicznej, gdyż większość korespondencji nie ma wartości dla potencjalnych podglądaczy. Zdarzają się jednak sytuacje, gdy trzeba tą drogą przekazać prywatne lub firmowe tajemnice, a wtedy posługiwanie się otwartym tekstem jest raczej lekkomyślne. Jak więc ustrzec się przed niekontrolowanym wyciekiem informacji?', 70, 70, 'freeencrypt_for_outlook', 4, 8, 23, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(468, 'multiIMG. Dużo ilustracji zamiast jednej', 'Znacznik   służy do umieszczania ilustracji na stronach WWW. tworzeniu stron zawierających dużo ilustracji wygodny byłby znacznik   wstawiający na stronę wszystkie pliki graficzne z wybranego katalogu. Wprawdzie język HTML nie umożliwia definiowania własnych znaczników, jednak stosując PHP możemy to ograniczenie łatwo ominąć.', 72, 77, 'multiimg_duzo_ilustracji_zamiast_jednej', 5, 11, 23, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(469, 'Internetowy fanklub, czyli automatyczne dodawanie nowych użytkowników do bazy danych', 'Coraz częściej przeglądając Internet można trafić na strony fanów różnych zespołów muzycznych, aktorów lub piosenkarzy. Twórcy takich serwisów zwykle ręcznie dodają każdego nowego internautę do bazy odwiedzających. Nie jest to uciążliwe, gdy serwis jest niewielki, jednak gdy odwiedza go wiele osób, można mieć z tym spore problemy. Zaprezentowany tutaj skrypt powinien znacznie przyspieszyć proces dodawania nowego użytkownika. Dzięki mechanizmowi uploadu plików wzbogacimy go także o możliwość dodania zdjęcia lub innego motywu graficznego.', 78, 81, 'internetowy_fanklub_czyli_automatyczne_dodawanie_nowych_uzytkownikow_do_bazy_danych', 5, 11, 23, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(470, 'webFAQ. Porady serwisu web.reporter.pl', '', 82, 83, 'webfaq_porady_serwisu_web_reporter_pl2', 5, 4, 23, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(471, 'Programowanie sieciowe w Javie. Serwer wielowątkowy', 'Miesiąc temu napisaliśmy klika wersji programu serwera, z którym komunikowaliśmy się przy użyciu programu telnet. Rozwiązaliśmy też problem z wyświetlaniem polskich znaków na konsoli w środowisku Windows. Dzisiaj napiszemy własny program klienta oraz prawdziwy serwer wielowątkowy.', 84, 86, 'programowanie_sieciowe_w_javie_serwer_wielowatkowy', 5, 12, 23, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(472, 'Poradnik finansowy cz. 2', 'Ubezpieczenia i inwestowanie stanowią integralną część sektora finansowego, ich upowszechnianie się staje się coraz bardziej wyraźne. Czy jednak Internet stanowi doskonałe narzędzie do dystrybucji produktów ubezpieczeniowych i inwestowania online? Niniejszy poradnik udzieli odpowiedzi na to pytanie poprzez wyjaśnienie aspektów związanych z rynkiem ubezpieczeń i inwestycjami.', 87, 102, 'poradnik_finansowy_cz_2', 8, 32, 23, 16);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(473, 'Jak zacząć przygodę z e-handlem? Narzędzia do prowadzenia sklepów internetowych', 'Nie od dziś wiadomo, że Internet to świetny kanał dystrybucji produktów. Miliony potencjalnych klientów, nawet setki milionów — jeśli mówimy o skali globalnej. A więc na co czekasz? Ruszaj na podbój sieci! Nie zwlekaj, bo każda sekunda zwłoki może oznaczać straconego klienta. Zaraz... Ale jak właściwie otworzyć sklep internetowy?', 24, 29, 'jak_zaczac_przygode_z_e_handlem_narzedzia_do_prowadzenia_sklepow_internetowych', 1, 32, 24, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(474, 'Płatny hosting', 'Jeżeli posiadamy stronę WWW na darmowym serwerze lub mamy wykupione konto komercyjne, warto przyjrzeć się rynkowi usług hostingowych. Może czas na zmianę dotychczasowego operatora?', 30, 34, 'platny_hosting', 3, 22, 24, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(475, 'Muzycy w sieci', 'Wielu muzyków otwarcie występuje przeciw nielegalnemu kopiowaniu ich utworów przez Internet. Jednak równocześnie dostrzegają pozytywne możliwości Internetu jako narzędzia do promocji własnej twórczości. A możliwości tych jest przynajmniej kilka.', 38, 41, 'muzycy_w_sieci', 3, 22, 24, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(476, 'Wiarygodność serwisu internetowego', 'Między serwisami internetowymi toczy się zaciekła walka o każdego potencjalnego klienta. Jak sprawić, aby to nasz serwis zdobył większe uznanie w oczach użytkowników, aby jego marka była bardziej znana niż marka konkurencji?', 42, 45, 'wiarygodnosc_serwisu_internetowego', 3, 4, 24, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(477, 'Spam w przedsiębiorstwie', 'Ze zjawiskiem spamu mają do czynienia wszyscy internauci. Większość ocenia je zdecydowanie negatywnie, potrafiąc podać wiele argumentów przemawiających za tym sądem. Rozważając problem niechcianej reklamy e-mailowej patrzymy na nią z punktu widzenia pojedynczych internautów, rzadko koncentrujemy się na tym, jaki jest jej koszt w przedsiębiorstwach. To właśnie firmy ponoszą największe straty z tytułu działalności spamerów.', 46, 49, 'spam_w_przedsiebiorstwie', 3, 5, 24, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(478, 'Podpis elektroniczny w praktyce', 'Dzięki wykorzystaniu zaawansowanych technik kryptografii możliwe stało się m.in. wprowadzenie cyfrowego podpisu elektronicznego. Odpowiednie narzędzia do obsługi tej technologii są już wbudowywane w powszechnie wykorzystywane systemy i programy, np. Windows, Office czy Outlook. Warto więc dowiedzieć się czym tak naprawdę jest podpis elektroniczny i jak z niego korzystać.', 50, 53, 'podpis_elektroniczny_w_praktyce', 2, 5, 24, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(479, 'XHTML — przyszłość sieci', 'Dynamiczny rozwój informatyki i upowszechnianie się Internetu spowodowały znaczący wzrost zainteresowania technologiami sieciowymi. Wraz z tym zjawiskiem rosły także wymagania odnośnie standardów i narzędzi służących do wygodnego tworzenia rozbudowanych serwisów internetowych. W wyniku ewolucji języka HTML, służącego do opisu strony, powstał standard XHTML, który w połączeniu np. z językiem PHP stanowi wygodne i rozbudowane narzędzie pozwalające tworzyć bardzo złożone witryny.', 54, 56, 'xhtml_przyszlosc_sieci', 2, 24, 24, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(480, 'Wielkie orkiestrowe granie', '', 57, 57, 'wielkie_orkiestrowe_granie', 2, 37, 24, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(481, 'Zapoluj na Flasha', 'Na stronach internetowych coraz częściej możemy podziwiać wspaniałe graficzne animacje zaprojektowane w popularnym formacie Flasha (SWF). Możemy je także zapisać na dysku własnego komputera, aby w przyszłości, chcąc do nich powrócić, nie szukać ich znowu w sieci.', 58, 61, 'zapoluj_na_flasha', 4, 9, 24, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(482, 'Webdraw — wektorowe rysowanie', 'SVG ma ponoć zastąpić GIF-y i Flasha w zastosowaniach sieciowych, nie dziwi więc fakt, że ostatnio pojawiło się sporo programów umożliwiających zapis do tego formatu. W artykule przyjrzymy się bliżej aplikacji Webdraw, stworzonej przez znaną, głównie jako producenta Paint Shop Pro, firmę Jasc.', 62, 65, 'webdraw_wektorowe_rysowanie', 4, 8, 24, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(483, 'eMule', 'eMule to alternatywny klient sieci eDonkey. Korzysta z tych samych serwerów, potrafi wymieniać dane pomiędzy klientem eDonkey2000, posiada ten sam system odnośników i sposób haszowania plików, jednak jego możliwości są nieporównywalnie większe.', 66, 69, 'emule', 4, 4, 24, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(484, 'Serwisy WWW konfigurowane plikami tekstowymi', 'Artykuł prezentuje metodę tworzenia stron WWW ułatwiającą wprowadzanie modyfikacji. Jeśli serwis podlega ciągłym zmianom, jest stale wzbogacany o nowe informacje, wówczas edycja plików HTML przestaje być wystarczająca. Stosując język PHP i podstawowe funkcje operujące na plikach możemy wielokrotnie przyspieszyć proces tworzenia, a co najważniejsze także późniejsze rozwijanie serwisu.', 70, 75, 'serwisy_www_konfigurowane_plikami_tekstowymi', 5, 11, 24, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(485, 'webFAQ. Porady serwisu web.reporter.pl', '', 76, 77, 'webfaq_porady_serwisu_web_reporter_pl3', 5, 4, 24, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(486, 'LiveMotion — efekty specjalne', 'Zadaniem LiveMotion jest maksymalne usprawnienie procesu tworzenia grafiki oraz jej późniejsza optymalizacja. Program ten, oprócz narzędzi służących do przygotowywania kompozycji graficznych, został wyposażony w zestawy elementów gotowych do natychmiastowego użytku, które są dostępne w paletach Library, Styles i Sounds.', 78, 81, 'livemotion_efekty_specjalne', 5, 30, 24, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(487, 'Programowanie sieciowe w Javie', 'Tym razem wyposażymy nasz serwer w możliwość zapisywania wykonywanych operacji w pliku dziennika.', 82, 84, 'programowanie_sieciowe_w_javie', 5, 13, 24, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(488, 'Dostęp do Internetu', 'Pierwszym krokiem na drodze do korzystania z Internetu jest uzyskanie do niego dostępu. Wielu początkującym użytkownikom dostęp do Internetu kojarzy się wyłącznie z modemem i ogólnopolskim numerem dostępowym TP SA bądź intensywnie ostatnio promowanym alternatywnym numerem OnetKonekt. W znacznej części Polski — zwłaszcza w mniejszych miejscowościach — są to istotnie wciąż jedyne możliwości dostępu do Internetu. Jest jednak wiele rejonów, gdzie możemy wybierać spośród szeregu innych wariantów, trzeba tylko o nich wiedzieć i umieć dokonać właściwego wyboru. Mamy nadzieję, że pomoże w tym m.in. niniejszy poradnik.', 85, 104, 'dostep_do_internetu', 8, 32, 24, 20);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(489, 'Jak się bronić przed spamem?', 'Termin „spam” oznacza w języku angielskim mielonkę w konserwie (Spiced Pork And haM). W żargonie internetowym jest to wiadomość wysyłana na wiele adresów e-mailowych, której otrzymać nie chcieliśmy i której nadawca zwykle nie jest nam znany. Nazwa została zaczerpnięta z jednego z odcinków Latającego Cyrku Monty Pythona.', 26, 31, 'jak_sie_bronic_przed_spamem', 1, 32, 25, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(490, 'Ale numer! Zestawienie telefonicznych numerów dostępowych do Internetu', 'Internet się rozwija, a liczba jego użytkowników wyposażonych w szybkie stałe łącza nieustannie rośnie — niewątpliwie taka właśnie tendencja utrzymuje się obecnie na całym świecie. Jednak w krajach takich jak np. Polska dyktatura modemu jeszcze przez długi czas będzie rzucać cień na rynek usług dostępowych. Na dodatek większość internautów przyzwyczaiła się do łączenia przez numer Telekomunikacji Polskiej, czyli nieśmiertelne 0202122, choć, jak się okazuje. wcale nie jest to konieczne.', 32, 35, 'ale_numer_zestawienie_telefonicznych_numerow_dostepowych_do_internetu', 3, 22, 25, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(491, 'Kursy online', 'Bardzo wysokie bezrobocie w Polsce powoduje, że nie jest łatwo znaleźć i utrzymać dobrą pracę. Może nam w tym pomóc zdobycie nowych kwalifikacji zawodowych. W tym celu możemy m.in. skorzystać z różnorodnych kursów oferowanych przez Internet.', 36, 39, 'kursy_online', 3, 22, 25, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(492, 'Sklep internetowy... i co dalej?', 'Sklep internetowy jest nowoczesnym kanałem dystrybucji produktów. Dzięki niemu można otworzyć się na nowe rynki poprzez udostępnienie informacji o swoich produktach milionom internautów. Kiedy już działa, powinien jak najszybciej zacząć przynosić zyski. W jaki sposób przyciągnąć do niego klientów? Przy odpowiednim wykorzystaniu dostępnych narzędzi technicznych i arketingowych można tanio, a przede wszystkim skutecznie zaistnieć w sieci. Trzeba jednak zwrócić uwagę na istotne szczegóły związane prowadzeniem takiego sklepu, np. jak zabezpieczyć się przed fałszywymi zamówieniami.', 40, 43, 'sklep_internetowy_i_co_dalej', 3, 34, 25, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(493, 'Jak tanio zareklamować się w Internecie', 'Prowadząc serwis lub sklep internetowy często stajemy przed dylematem, jak i gdzie się reklamować, aby zwiększyć ruch na własnych stronach WWW, ale jednocześnie nie opustoszyć zbytnio portfela. Okazuje się, że w sieci wcale nie trzeba posiadać zbyt wielu środków finansowych, by się skutecznie zareklamować. Artykuł przestawia różne możliwości reklamy internetowej, zarówno płatnej, jak i bezpłatnej.', 44, 49, 'jak_tanio_zareklamowac_sie_w_internecie', 3, 4, 25, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(494, 'Fałszerze witryn', 'Internet jest źródłem informacji, coraz częściej także miejscem biznesu, bankowości oraz handlu. Zanim zdecydujemy się na wirtualny bank czy serwis aukcyjny, starannie sprawdzamy informacje o potencjalnym wyborze, świadomi obecności w sieci oszustów. Po jakimś czasie przyzwyczajamy się do nowego, wirtualnego partnera w biznesie. Okazuje się jednak, że pomimo czujności możemy się stać ofiarą wirtualnego przestępcy, który podrabia strony internetowe.', 50, 53, 'falszerze_witryn', 2, 3, 25, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(495, 'Blogowy rynek nieruchomości', 'Blogi w dość krótkim czasie stały się bardzo popularne. Coraz trudniej znaleźć nieobciążony serwer z wolnymi loginami. Przyczyną tego stanu rzeczy jest najczęściej niedostatek informacji o istniejących serwisach i prowadzonych przez nie usługach, słowem: nieznajomość blogowego rynku nieruchomości. Nadszedł więc najwyższy czas, aby mu się dokładniej przyjrzeć.', 54, 56, 'blogowy_rynek_nieruchomosci', 2, 17, 25, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(496, 'Niech żyje kreacja', '', 57, 57, 'niech_zyje_kreacja', 2, 37, 25, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(497, 'Programy do mapowania plików graficznych', 'Jedną z metod tworzenia efektywnych i ładnie wyglądających odsyłaczy jest zastosowanie techniki aktywnych map, czyli takiego podziału pliku graficznego, dzięki któremu określone jego części prowadzą do różnych zasobów sieci. Istnieje wiele programów, które służą temu celowi. Kilka najciekawszych opisano w tym artykule.', 58, 62, 'programy_do_mapowania_plikow_graficznych', 4, 9, 25, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(498, 'SWiSH, czyli Flash na skróty', 'Po co się męczyć, Mr SWiSH cię wyręczy! Gdyby australijski producent zdecydował się na szeroko zakrojoną kampanię reklamową swojego programu w naszym kraju, to właśnie te hasło najtrafniej oddawałoby jego istotę.', 63, 63, 'swish_czyli_flash_na_skroty', 4, 8, 25, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(499, 'Pajączek NxG Professional 5.0.1', 'Niemal dwa lata od momentu udostępnienia ostatniej wersji Pajączka 2000 przyszło czekać użytkownikom na premierę kolejnej edycji najlepszego polskiego programu wspomagającego proces tworzenia i publikowania stron WWW. Nowa wersja, określana jako Pajączek NxG 5, niesie ze sobą szereg zmian zarówno w zakresie oferowanych narzędzi, jak i interfejsu, a ponadto wprowadza podział aplikacji na dwie edycje o różnym poziomie zaawansowania.', 64, 65, 'pajaczek_nxg_professional_5_0_1', 4, 8, 25, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(500, 'Obsługa błędów w PHP', 'Niedostatecznie przetestowany kod, częste zmiany wersji PHP, brak jednolitego sposobu obsługi błędów w wielu najpopularniejszych współdzielonych bibliotekach i przede wszystkim niczym nieograniczona pomysłowość użytkowników i hakerów — oto zagrożenia czyhające na biednego programistę internetowego. Z pomocą przychodzi mu tylko kilka funkcji w jego ulubionym języku, pomysłowość, konsekwencja i niniejszy artykuł.', 66, 69, 'obsluga_bledow_w_php', 5, 11, 25, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(501, 'Wyszukiwarka na stronie WWW', 'W artykule omówimy sposób wzbogacenia serwisu WWW o możliwość wyszukiwania informacji. Przykładowe serwisy będą zawierały nowelę, wiersze oraz teksty piosenek. Zadaniem naszej wyszukiwarki będzie znalezienie stron zawierających podany tekst, wytłuszczenie tekstu oraz posortowanie wyników wyszukiwania. Zadanego tekstu będziemy szukali w treści strony, zaś jakość znalezionych informacji posortujemy według liczby wystąpień.', 70, 72, 'wyszukiwarka_na_stronie_www', 5, 11, 25, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(502, 'Subskrypcja e-mail, czyli tworzenie listy mailingowej', 'Twórcy serwisów internetowych na pewno spotkali się z problemem poinformowania użytkownika o aktualizacji serwisu lub zmianie jego adresu. Możlwości jest kilka, jednak najlepszą i najbardziej efektywną jest z pewnością wysłanie wiadomości e-mail, która w szybkim czasie dotrze do odbiorcy. Zaprezentowany tu skrypt powinien ułatwić tworzenie przykładowych list mailingowych.', 74, 75, 'subskrypcja_e_mail_czyli_tworzenie_listy_mailingowej', 5, 11, 25, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(503, 'webFAQ. Porady serwisu web.reporter.pl', '', 76, 77, 'webfaq_porady_serwisu_web_reporter_pl4', 5, 4, 25, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(504, 'Animacje 3D we Flashu MX', 'Flash MX w porównaniu do swojego poprzednika posiada bardzo przydatną właściwość — w trakcie odtwarzania animacji SWF możemy rysować od podstaw symbole typu Movie Clip, których nie ma w bibliotece projektu w fazie projektowania animacji FLA. Dzięki temu możemy tworzyć animacje, które nie zawierają w swojej bibliotece ani jednego symbolu, a jedynie kod ActionScript.', 78, 82, 'animacje_3d_we_flashu_mx', 5, 21, 25, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(505, 'Usługi internetowe', 'Internet zapewnia możliwość przesyłania dowolnych danych między dowolnymi przyłączonymi do niego komputerami. Całkowita dowolność w tym zakresie spowodowałaby jednak niemożliwość jakiejkolwiek sensownej komunikacji — trzeba określić pewien wspólny „język”, konkretną formę przesyłanych danych i sposób ich interpretacji. Uniwersalność Internetu pozwala rzecz jasna na to, aby takich języków było więcej niż jeden. Inna forma przesyłanych danych stosowana jest np. w poczcie elektronicznej, inna przy odczytywaniu stron WWW, a jeszcze inna w rozmowach za pośrednictwem IRC. Każdy taki sposób wykorzystania sieci określamy mianem usługi internetowej. Oczywiście słowo „usługa” ma tu znaczenie techniczne, a nie handlowe — każda taka usługa związana jest z określonym typem oprogramowania oraz odpowiednim protokołem komunikacyjnym, ustalającym sposób porozumiewania się programów.', 83, 104, 'uslugi_internetowe', 8, 32, 25, 22);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(506, 'Programy partnerskie. Czy w Internecie można zarobić?', 'Prowadząc serwis WWW często zastanawiamy się, czy można na nim zarobić, a przynajmniej zwrócić sobie koszty dostępu do Internetu lub zakupu konta WWW. Okazuje się, że można... za pomocą programów partnerskich. Artykuł prezentuje metody na zarabianie w sieci dla webmasterów.', 26, 31, 'programy_partnerskie_czy_w_internecie_mozna_zarobic', 1, 32, 26, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(507, 'E-mail na cenzurowanym, czyli jak polskie firmy traktują klientów', 'Wydawałoby się, że każda firma powinna możliwie jak naczęściej używać poczty elektronicznej. W szczególności powinna odpowiadać na wszelkie e-maile z pytaniami od klientów, gdyż brak odpowiedzi jest równoznaczny z lekceważeniem. Czy polskie firmy stosują się do tej zasady? Prześledźmy to na podstawie prostego testu przeprowadzonego przez redakcję Magazynu INTERNET.', 32, 36, 'e_mail_na_cenzurowanym_czyli_jak_polskie_firmy_traktuja_klientow', 3, 38, 26, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(508, 'Serwisy eksportowe', 'Polskie firmy, które chcą zwiększyć swoją sprzedaż, próbują wejść na rynki zagraniczne. W tym celu mogą skorzystać z różnych sposobów szukania zagranicznych kooperantów. Jeden z nich, często niedoceniany, polega na wykorzystaniu możliwości Internetu.', 38, 41, 'serwisy_eksportowe', 3, 22, 26, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(509, 'Internetowi tłumacze', 'Proces globalizacji powoduje, że coraz częściej mamy do czynienia z językami obcymi. Tymczasem liczba osób, które znają biegle kilka języków, jest stosunkowo nieduża. Oczywiście, jeżeli nie znamy jakiegoś języka, możemy skorzystać ze słowników. Niestety, nie są one tanie. Innym problemem jest czas potrzebny na znalezienie szukanego wyrazu. Te problemy może rozwiązać Internet. W sieci znajduje się wiele elektronicznych słowników, które za darmo przetłumaczą wyrazy z jednego języka na drugi. Co więcej, niektóre z takich internetowych tłumaczy potrafią przetłumaczyć całe zdania, a nawet całe strony WWW.', 42, 43, 'internetowi_tlumacze', 3, 22, 26, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(510, 'Zarządzanie jakością informacji w serwisach internetowych', 'Bez względu na to czy prowadzimy wortal, stronę małej, rodzinnej firmy, czy odpowiadamy za public relations w dużym przedsiębiorstwie chcemy, aby nasz serwis zdobywał nowych użytkowników. Zwłaszcza takich, którzy nie tylko będą powracali na jego strony regularnie, ale jeszcze polecą go innym. Zazwyczaj problemem jest brak środków na reklamę i promocję. Co w takiej sytuacji może być naszym głównym atutem? Czym możemy odróżnić się od konkurencji?', 44, 47, 'zarzadzanie_jakoscia_informacji_w_serwisach_internetowych', 3, 4, 26, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(511, 'E- handel pod paragrafem', 'Ostatnie miesiące przynoszą wiele nowych uregulowań prawnych. Ustawa o podpisie elektronicznym, bazach danych, a teraz świadczenie usług drogą elektroniczną. Jak widać, nie tylko technika idzie do przodu, ale w ślad za nią podąża też prawo. Miejmy tylko nadzieję, że nowa ustawa przyniesie więcej korzyści niż kłopotów.', 48, 49, 'e_handel_pod_paragrafem', 3, 16, 26, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(512, 'Kult Gadu-Gadu', 'Każdy internauta nazwę Gadu-Gadu kojarzy prawdopodobnie tylko z jednym produktem — polskim komunikatorem internetowym autorstwa firmy sms-express.com. Dziś z tego komunikatora korzysta ponad 1,5 miliona osób.', 50, 53, 'kult_gadu_gadu', 2, 3, 26, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(513, 'Wyszukiwanie zaawansowane', 'Wyszukiwarki umożliwiają dotarcie do żądanych zasobów pod warunkiem, że użytkownik potrafi się nimi posługiwać. Zadanie pytania w sposób nieprecyzyjny może doprowadzić do frustracji podczas przeglądania zwróconej przez wyszukiwarkę listy odpowiedzi. Jedynie znajomość i umiejętność korzystania z zaawansowanych funkcji wyszukiwawczych umożliwia szybkie i skuteczne dotarcie do poszukiwanych stron.', 54, 57, 'wyszukiwanie_zaawansowane', 2, 4, 26, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(514, 'Narodowa digitalizacja', 'W październiku ubiegłego roku powołano przy Komitecie Badań Naukowych Departament Promocji Społeczeństwa Informatycznego. Jego pierwszym i najważniejszym zadaniem stało się zrealizowanie projektu stworzenia i uruchomienia Polskiej Biblioteki Narodowej. PBI planuje skatalogowanie i digitalizację wszystkich archiwalnych zasobów polskiej literatury oraz znaczących prac naukowych, podręczników szkolnych i akademickich. W dalszych planach uwzględnia się udostępnianie dzieł malarskich, graficznych, fotograficznych, filmów dokumentalnych i zapisów spektakli telewizyjnych.', 58, 59, 'narodowa_digitalizacja', 2, 6, 26, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(515, 'Inteligentne domy', 'O inteligentnych domach mówi się od kilku lat. Obecnie takich domów jest jeszcze niewiele, ale wszystko wskazuje na to, że w przyszłości ten stan ulegnie zmianie.', 60, 62, 'inteligentne_domy', 2, 24, 26, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(516, 'Śmietnik', '', 63, 63, 'smietnik', 2, 37, 26, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(517, 'Masz wiadomość! Przegląd powiadamiaczy pocztowych', 'O tym, że nasza skrzynka pocztowa na serwerze nie jest już pusta, dowiadujemy się najczęściej dopiero w trakcie ściągania zgromadzonych wiadomości na komputer. Proces aktualizacji poczty — czyli uruchomienie odpowiedniego programu, a następnie czekanie aż wszystko dobiegnie końca — trwa zazwyczaj dość długo i zajmuje niepotrzebnie uwagę internauty. Chcąc uniknąć takich przestojów w pracy warto zainteresować się pewnym charakterystycznym gatunkiem oprogramowania — sygnalizatorami pocztowymi.', 64, 68, 'masz_wiadomosc_przeglad_powiadamiaczy_pocztowych', 4, 9, 26, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(518, 'Rapid Browser', 'Przeglądarka internetowa to program, który często odgrywa dominującą rolę w komputerze. Dla części internautów zakres eksploatowanych przez nią informacji nie jest jednak dostatecznie szeroki i aby w pełni zaspokoić swe potrzeby (związane np. ze streamingiem rozgłośni internetowych czy czatowaniem), muszą szukać rozwiązań alternatywnych. Firma RapidMedia Networks postanowiła wyjść im naprzeciw i proponuje oryginalną przeglądarkę multimedialną.', 69, 69, 'rapid_browser', 4, 8, 26, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(519, 'PHP bez MySQL', 'PHP i MySQL to potężny duet pozwalający na tworzenie rozbudowanych, dynamicznych stron WWW i aplikacji internetowych. Przy płatnych kontach WWW baza danych to już niemalże standard, niestety, sytuacja wygląda inaczej jeśli o chodzi o konta darmowe — tam MySQLa zazwyczaj nie uświadczysz. Skomplikowane skrypty można jednak tworzyć nie odwołując się do bazy danych spod znaku delfina. Jak? Proszę czytać dalej.', 70, 73, 'php_bez_mysql', 5, 11, 26, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(520, 'Autoryzacja użytkownika, czyli różne metody logowania w PHP', 'Każdy ma swoje sekrety, których nie chciałby dzielić z całym światem. Niektórymi z nich można jednak podzielić się z określonymi osobami, tworząc w ten sposób grupy uprzywilejowanych, którzy mają dostęp do wybranych danych. W niniejszym artykule zaprezentowano dwa sposoby uwierzytelnienia użytkownika, jeden w oparciu o pliki, a drugi o MySQL.', 74, 77, 'autoryzacja_uzytkownika_czyli_rozne_metody_logowania_w_php', 5, 11, 26, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(521, 'Licznik odwiedzin', 'Licznik odwiedzin to jeden z najczęściej spotykanych skryptów stosowanych przez każdego webmastera. Dzięki kilku linijkom kodu jesteśmy w stanie oszacować liczbę odwiedzin oraz pochwalić się nią innym internautom. Początkujący mogą mieć jednak problem ze stworzeniem własnego skryptu, dlatego posługują się licznikami darmowymi. Wadą tego rozwiązania jest uzależnienie od serwera — w przypadku awarii system nie nalicza odwiedzin. W artykule przedstawiam kilka skryptów, które powinny załatwić sprawę.', 78, 79, 'licznik_odwiedzin', 5, 11, 26, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(522, 'webFAQ. Porady serwisu web.reporter.pl', '', 80, 81, 'webfaq_porady_serwisu_web_reporter_pl5', 5, 4, 26, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(523, 'Kartki internetowe', 'Wprawdzie tegoroczne Walentynki mamy już za sobą, jednak mimo to wysyłanie internetowych kartek wciąż cieszy się ogromną popularnością. Dowodem tego są listy, jakie otrzymaliśmy od Czytelników. W odpowiedzi przedstawiamy skrypty PHP wyjaśniające mechanizm wysyłania kartek.', 82, 84, 'kartki_internetowe', 5, 11, 26, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(524, 'Własna domena', 'Domena to, najkrócej mówiąc, niepowtarzalna „końcówka” adresu internetowego, jednoznacznie identyfikująca daną firmę, instytucję czy serwis internetowy — np. microsoft.com, sejm.gov.pl czy onet.pl. Do posiadania własnej domeny dąży większość firm korzystających z Internetu (w mniejszym stopniu dotyczy to użytkowników prywatnych), gdyż daje to możliwość umieszczenia firmowej witryny WWW pod atrakcyjnym adresem w rodzaju www.nazwa-firmy.pl, zaś adresy e-mail mogą mieć postać konto@nazwa-firmy.pl. W powszechnym mniemaniu pojęcie domeny jest zazwyczaj sprowadzane właśnie do opisanych powyżej możliwości. W rzeczywistości jednak domena ma wiele zadań, a możliwość korzystania ze wspomnianych powyżej adresów to tylko jeden z możliwych skutków posiadania własnej domeny. Czym zatem w istocie jest domena, do czego służy oraz gdzie i jak można ją zarejestrować? Na te pytania postaramy się odpowiedzieć w niniejszym Poradniku.', 85, 99, 'wlasna_domena', 8, 32, 26, 15);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(525, 'Tanie udostępnianie', 'O udostępnianiu i współdzieleniu łącza w sieciach lokalnych napisano wiele artykułów i w zasadzie trudno coś nowego w tym temacie wymyślić. Proponowane rozwiązania przeznaczone są jednak głównie dla średnich (kilkanaście) i dużych (kilkadziesiąt komputerów) sieci. O małych sieciach pisze się niewiele. Dlatego postanowiliśmy opisać takie metody udostępniania łącza, które cechują się niskim budżetem.', 32, 36, 'tanie_udostepnianie', 1, 32, 27, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(526, 'Telewizje w sieci', 'Z roku na rok Internet staje się coraz potężniejszym środkiem masowego przekazu. Wymusza to różnego rodzaju działania ze strony innych mediów. Na przykład dla telewizji sieć z jednej strony stanowi szansę na większą interakcję z widzami oraz dodatkowe źródło dochodów, z drugiej zaś może stanowić pewnego rodzaju zagrożenie. Postanowiliśmy przyjrzeć się, jak polskie stacje telewizyjne starają się wykorzystywać potencjał globalnej pajęczyny.', 38, 43, 'telewizje_w_sieci', 3, 22, 27, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(527, 'Marketing w sieci', 'Czynnikiem determinującym podjęcie dowolnej decyzji są informacje (dane) będące w posiadaniu osoby ją podejmującej. Artykuł skupia się w głównej mierze na tym, jak wspomóc pozyskiwanie informacji niezbędnych w podejmowaniu trafnych decyzji w odniesieniu do przedsięwzięć internetowych. W centrum uwagi znajdzie się Internet jako źródło poszukiwania informacji marketingowych dla każdego typu działalności, zwłaszcza tej prowadzonej w sieci.', 44, 47, 'marketing_w_sieci', 3, 4, 27, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(528, 'Inteligentni agenci', 'Coraz trudniej znaleźć w sieci potrzebne informacje. Dlatego z taką nadzieją patrzy się na inteligentnych agentów, którzy wyręczą nas w wielu mozolnych czynnościach: przeszukają Internet, odnajdą najtańszy sklep internetowy czy będą monitorować sieć komputerową.', 48, 50, 'inteligentni_agenci', 3, 5, 27, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(529, 'Nieograniczony dostęp, nieograniczone ryzyko...', 'Artykuł podejmuje problematykę związaną z nieograniczonym i nielimitowanym dostępem do Internetu z sieci korporacyjnej lub firmowej. Jakie zagrożenia i pułapki czyhają na szczęśliwych, acz nieświadomych pracowników? Co może przyprawić zapracowanych administratorów systemów o ból głowy i podkrążone z niewyspania oczy?', 51, 53, 'nieograniczony_dostep_nieograniczone_ryzyko', 3, 39, 27, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(530, 'Darmowe grafiki', 'Marzeniem każdego webmastera jest posiadanie strony WWW z ciekawą i oryginalną oprawą graficzną. Sieć daje tutaj duże możliwości, zarówno dla bardziej, jak i mniej wymagających użytkowników. Pierwsi odnajdą inspirację w przepastnych archiwach grafik i animacji, drugich usatysfakcjonują gotowe szablony. Aby pozyskać nowe materiały, nie trzeba wydawać nawet złotówki. Wystarczy tylko wiedzieć, czego się szuka.', 54, 57, 'darmowe_grafiki', 2, 4, 27, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(531, 'Internetowe testery', 'Dynamicznie rozwijające się technologie internetowe w coraz większym zakresie przyczyniają się do wykorzystania sieci do coraz to nowych celów. Już teraz przez Internet można zbadać słuch czy wzrok, rozwiązać test na inteligencję, przetestować swój komputer na odległość, np. na odporność przeciwko atakom z sieci. Obecna sieć jest pełna rozmaitych testerów i generatorów, a producenci dążą do tego, aby przeglądarka stała się głównym centrum dowodzenia. Przez nią korzystamy ze stron WWW, odbieramy pocztę e-mail, korzystamy z banku, rozmawiamy z innymi poprzez czaty (nawet głosowe!), konfigurujemy aplikacje, sprzęt... a także możemy dokonać wielu testów.', 58, 61, 'internetowe_testery', 2, 4, 27, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(532, 'Wirtualne pamiętniki', 'Blogi stały się już tak popularne, że stanowią nieodłączny element współczesnej kultury. Co skłania internautów do prowadzenia blogów? Do czego mogą służyć blogi? Czy można zarobić na prowadzeniu serwisów z blogami?', 62, 63, 'wirtualne_pamietniki', 2, 5, 27, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(533, 'Permanentna inwigilacja', '', 65, 65, 'permanentna_inwigilacja', 2, 37, 27, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(534, 'Bla, bla, bla online. Przegląd komunikatorów internetowych', 'Ostatni rok był wyjątkowo urodzajny pod względem liczby powstałych rodzimych komunikatorów. Podaż na tego rodzaju oprogramowanie znacznie przewyższa popyt, dlatego należy się chyba spodziewać, że wkrótce ostra rywalizacja wyeliminuje część tych aplikacji z rynku. Póki co zobaczmy, co nowego proponują nam twórcy komunikatorów i do wspierania której aplikacji warto się ewentualnie przyłączyć.', 66, 71, 'bla_bla_bla_online_przeglad_komunikatorow_internetowych', 4, 9, 27, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(535, 'Śledzenie liczby pobrań plików', 'Która z piosenek dostępnych na naszych stronach cieszy się największą popularnością? Który program użytkownicy pobierają najczęściej? Jak wiele razy został pobrany plik zawierający teksty kolęd? W artykule przedstawiamy metody zliczania różnych zdarzeń związanych z odwiedzaniem stron. Dzięki temu goście odwiedzający naszą witrynę dowiedzą się jakie informacje cieszą się największą popularnością.', 72, 75, 'sledzenie_liczby_pobran_plikow', 5, 11, 27, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(536, 'Złożone animacje w Directorze', 'Pracując z Directorem 8.5 lub z najnowszym Directorem MX mamy do dyspozycji ogromne możliwości tworzenia animacji 3D.', 76, 81, 'zlozone_animacje_w_directorze', 5, 21, 27, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(537, 'webFAQ. Porady serwisu web.reporter.pl', '', 82, 83, 'webfaq_porady_serwisu_web_reporter_pl6', 5, 4, 27, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(538, 'Tworzenie aplikacji dla telefonów GSM', 'Jesteśmy świadkami ogromnego postępu w dziedzinie telefonii komórkowej. Aparaty nie służą już tylko do prowadzenia rozmów czy wysyłania SMS-ów. Dzięki nowym technologiom mogą posłużyć jako aparat cyfrowy, odtwarzacz MP3 czy odbiornik FM, minikonsola do gier lub aplikacji. W połączeniu z Internetem telefon komórkowy może stać się mobilnym biurem, za pomocą którego będziemy mogli odebrać pocztę, wysłać faks, przygotować prosty dokument czy arkusz kalkulacyjny, a w wolnej chwili pograć w szachy lub online ze znajomymi.', 84, 86, 'tworzenie_aplikacji_dla_telefonow_gsm', 5, 29, 27, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(539, 'Jak zaistnieć w Internecie, czyli witryna firmowa', 'Serwis WWW jest obecnie najszybszym i najtańszym sposobem dotarcia do grona potencjalnych klientów. Ze względu na swoje możliwości nadaje się doskonale do przejrzystego i wizualnie atrakcyjnego zaprezentowania każdego przedsiębiorstwa, jego produktów i usług w sieci Internet. Nie będzie to tekst o technicznych aspektach tworzenia kodu HTML. Postaramy się natomiast przybliżyć Czytelnikom szereg konkretnych problemów i pytań, na które należy sobie odpowiedzieć zanim zaczniemy tworzyć własny serwis internetowy.', 87, 99, 'jak_zaistniec_w_internecie_czyli_witryna_firmowa', 8, 32, 27, 13);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(540, 'Multimedia w Internecie', 'Multimedialna rewolucja nie mogła ominąć Internetu. Przepustowość łączy jest wprawdzie wciąż o wiele za mała na to, by ruchomy obraz i dźwięk zastąpiły w Internecie klasyczny tekst i grafikę w roli głównego medium przekazu informacji, jednak dźwięku i wideo w sieci jest coraz więcej...', 24, 31, 'multimedia_w_internecie', 1, 32, 28, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(541, 'Internetowe planowanie wakacji Przegląd witryn biur podróży i serwisów turystycznych', 'Zbliżają się wakacje. Jeżeli jeszcze nie ustaliliśmy, gdzie wyjechać, to najwyższy czas to zrobić. Aby zaplanować wymarzone wakacje, nie musimy wcale wychodzić z domu. Wystarczy skorzystać z możliwości, jakie daje Internet. Z roku na rok rośnie liczba biur podróży, które zakładają swoje strony WWW. Cały czas rozwijają się też niezależne od biur podróży serwisy turystyczne.', 32, 35, 'internetowe_planowanie_wakacji_przeglad_witryn_biur_podrozy_i_serwisow_turystycznych', 3, 22, 28, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(542, 'Płatny Internet a rzeczywistość. Co o płatnościach w Internecie sądzą ludzie, którzy sami je wprowadzili?', 'Nikt już nie może mieć wątpliwości: idea bezgranicznie darmowego Internetu odchodzi powoli w przeszłość, wypierana przez coraz silniejszą pokusę sięgnięcia do kieszeni internautów. Na ten temat krąży dużo mitów, jeszcze więcej niedomówień. Sami zainteresowani przejawiają najczęściej postawy zupełnie skrajne: od snucia apokaliptycznych wizji moralnej zagłady sieci poczynając, a na przesadnym entuzjazmie kończąc. W tej sytuacji najlepszym wyjściem było zapytanie o zdanie osób, które o płatnościach mogły powiedzieć najwięcej, ponieważ same brały udział w ich wprowadzaniu.', 36, 40, 'platny_internet_a_rzeczywistosc_co_o_platnosciach_w_internecie_sadza_ludzie_ktorzy_sami_je_wprowadzili', 3, 5, 28, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(543, 'Świat inwestycji offshore', 'Inwestycje offshore, znane także jako HYIP, do niedawna stanowiły tajemnicę znaną nielicznym. Dzięki Internetowi świat niezwykłych możliwości otworzył się teraz przed każdym, kto ma do niego dostęp. To nie bajka, to rzeczywistość XXI wieku.', 42, 43, 'swiat_inwestycji_offshore', 3, 40, 28, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(544, 'Dobra strona = lepszy zysk', 'Mimo że mamy świetny produkt i od pewnego czasu stronę WWW, na której jest on reklamowany, nie udaje się jednak nic za jej pomocą sprzedać. Dlaczego? Gdzie tkwi błąd? Jak go naprawić? Wystarczy odrobina marketingu...', 44, 47, 'dobra_strona_lepszy_zysk', 3, 31, 28, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(545, 'Upload.com — Mekka dla programistów', 'Każdemu twórcy programów komputerowych zależy na tym, aby jego program cieszył się jak największą popularnością. Może mu w tym pomóc odpowiednia promocja. Jednak koszty takiej promocji, szczególnie jeżeli ma ona być prowadzona na całym świecie, mogą być bardzo wysokie. Co w takim razie mają zrobić małe firmy programistyczne czy osoby prywatne, aby wypromować swoje programy? Oczywiście mogą do tego celu wykorzystać Internet.', 48, 51, 'upload_com_mekka_dla_programistow', 2, 4, 28, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(546, 'Nie daj się złapać w sieć!', 'Na nieświadomego internautę czeka dziś wiele pułapek. Niektóre z nich są pozorne, inne pociągają za sobą realne zagrożenia. Co nam rzeczywiście grozi i jak poznać co dobre, a co złe?', 52, 55, 'nie_daj_sie_zlapac_w_siec', 2, 4, 28, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(547, 'Kodem i klawiaturą, czyli sztuka doby Internetu', 'Cyberkultura powoduje prawdziwie rewolucyjne zamieszanie', 56, 57, 'kodem_i_klawiatura_czyli_sztuka_doby_internetu', 2, 41, 28, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(548, 'Jabber', 'Jabber to otwarty protokół wymiany informacji w czasie rzeczywistym pomiędzy dwoma punktami Internetu, stosowany głównie w komunikatorach. Czy mamy więc do czynienia z kolejnym systemem instant messaging typu Gadu-Gadu lub ICQ? Jabber nie jest systemem komunikacyjnym, do jakich się zdążyliśmy przyzwyczaić. Jego możliwości i zalety są znacznie szersze.', 58, 59, 'jabber', 2, 5, 28, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(549, 'Nowy wizerunek w 5 minut. Przegląd serwisów z darmowymi szablonami stron WWW', 'W ubiegłym miesiącu na łamach MI zostały zaprezentowane serwisy z darmowymi grafikami, które stanowią atrakcyjny materiał dla każdego aktywnie działającego webmastera. Ten artykuł, będący kontynuacją wspomnianego tematu, ma za zadanie przypomnieć o niedocenianym w Polsce, a dosyć popularnym na Zachodzie rozwiązaniu, jakim są graficzne szablony stron WWW.', 60, 62, 'nowy_wizerunek_w_5_minut_przeglad_serwisow_z_darmowymi_szablonami_stron_www', 2, 36, 28, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(550, 'Spam spam spamem pogania', '', 63, 63, 'spam_spam_spamem_pogania', 2, 37, 28, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(551, 'Zdalnie i profesjonalnie', 'Od czasu, gdy graficzne interfejsy użytkownika na stałe zagościły na ekranach naszych monitorów, manipulowanie zasobami odległego komputera stało się równie łatwe jak klikanie ikonek na własnym pulpicie. Wystarczy zainstalować odpowiedni program na dwóch maszynach, by z jednej przejąć pełną kontrolę nad drugą, tzn. uruchamiać na niej aplikacje. Możliwość zdalnej pracy jest szczególnie ważna dla osób, które np. w domu nie dysponują szybkim łączem internetowym, natomiast mają je w pracy, w godzinach nocnych prawdopodobnie bezczynne. Czyste marnotrawstwo...', 64, 69, 'zdalnie_i_profesjonalnie', 10, 9, 28, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(552, 'Sonda, czyli sposób na internetowe głosowanie', 'W poprzednich artykułach zaprezentowałem kilka przydatnych skryptów, które w większości opierały się na plikach tekstowych. Nadszedł czas, by przejść do bardziej złożonego zagadnienia, jakim jest z pewnością utworzenie sondy, czyli skryptu umożliwiającego głosowanie i wyświetlanie wyników na stronie WWW.', 70, 71, 'sonda_czyli_sposob_na_internetowe_glosowanie', 5, 11, 28, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(553, 'webFAQ. Porady serwisu web.reporter.pl', '', 72, 73, 'webfaq_porady_serwisu_web_reporter_pl7', 5, 4, 28, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(554, 'AOL Server — z czym na Apacza?', 'Najbardziej popularną usługą w Internecie obok poczty elektronicznej jest WWW. Codziennie internauci przeglądają miliardy stron i czerpią z nich potrzebne informacje. Żeby to wszystko działało, potrzebne są wydajne i niezawodne serwery WWW...', 74, 76, 'aol_server_z_czym_na_apacza', 5, 42, 28, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(555, 'Warsztat Flasha. Zegar i morfing tekstu', 'Serfowanie po sieci bardzo często dostarcza niezapomnianych przeżyć, przy których łatwo stracić poczucie czasu... i co wtedy ratuje nas od całkowitego zatracenia? Zegar oczywiście! Proponuję wykonanie we Flashu cyfrowego zegara, który będzie dodatkową ozdobą witryny.', 78, 79, 'warsztat_flasha_zegar_i_morfing_tekstu', 5, 21, 28, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(556, 'Ikona strony WWW', 'Przeglądarka Internet Explorer począwszy od wersji 4.0 wyświetla w polu adresu ikonkę reprezentującą dany serwis. Ikona przedstawia zazwyczaj logo i ułatwia wybór strony z zakładki Ulubione. Artykuł wyjaśnia, w jaki sposób przygotować i dołączyć do strony WWW ikonkę przedstawiającą logo serwisu, a także opisuje, jak zbadać popularność naszej strony.', 80, 82, 'ikona_strony_www', 5, 43, 28, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(557, 'Tworzenie stron WWW', 'Usługa WWW jest obecnie podstawową metodą udostępniania informacji w Internecie. Nic zatem dziwnego, że większość użytkowników sieci, od pojedynczych osób poczynając, a na wielkich korporacjach kończąc, jest zainteresowanych tworzeniem stron WWW. Duże instytucje oczywiście często zlecają wykonanie swojego serwisu WWW zewnętrznym firmom specjalizującym się w takich usługach. Wielu użytkowników jednak — czy to ze względów finansowych (choćby w przypadku stron prywatnych), czy ze względu na specyficzne potrzeby (np. częste aktualizacje), decyduje się na wykonanie takiego serwisu własnymi siłami. Głównie dla nich przeznaczony jest niniejszy odcinek Poradnika, zawierający podstawowe informacje na temat tworzenia stron WWW.', 83, 100, 'tworzenie_stron_www', 8, 32, 28, 18);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(558, 'Fotografia cyfrowa wkracza do sieci', 'Internet mocno spowszedniał. Wielu znajomych ma już konto poczty elektronicznej, a coraz więcej osób umieszcza na swoich stronach WWW nie tylko teksty, ale i zdjęcia, które coraz częściej robione są aparatami cyfrowymi. Może więc nadszedł już czas, by kupić taki aparat?', 26, 34, 'fotografia_cyfrowa_wkracza_do_sieci', 11, 44, 29, 9);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(559, 'Kredyty przez Internet', 'Zwrotność, terminowość, oprocentowanie, zabezpieczenie — to podstawowe, wspólne cechy każdego kredytu bankowego niezależne od drogi, którą był uzyskany. Nie jest istotne, czy złożyliśmy osobistą wizytę w banku, wydaliśmy zlecenie teleoperatorowi czy po prostu wypełniliśmy wniosek kredytowy dostępny na stronie internetowej. Jedno jest pewne, musimy zwrócić pieniądze do banku oraz zapłacić za możliwość korzystania z nich. Ważne jednak jest to, jak wiele trudów musieliśmy włożyć w znalezienie najlepszej oferty, ile czasu musieliśmy poświęcić na oczekiwania w kolejkach i jak dużo to nas kosztowało. Oferta kredytowa bankowości elektronicznej to po lokatach i rachunkach inwestycyjnych kolejny krok ku zwiększeniu świadomości społeczeństwa w poruszaniu po trudnym i pełnym pułapek świecie finansów.', 36, 39, 'kredyty_przez_internet', 3, 45, 29, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(560, 'Analiza SWOT dla serwisów internetowych', 'Efektywne i skuteczne zarządzanie serwisem internetowym wymaga wykorzystywania profesjonalnych technik analitycznych. W zasadzie w odniesieniu do każdego serwisu internetowego powinno się przeprowadzić dokładną analizę czynników mających wpływ na jego pozycję rynkową. Analizy nie można ograniczyć tylko do zebrania, opracowania i interpretacji danych marketingowych, które pozwalają poznać potrzeby i opinie użytkowników Internetu. Przede wszystkim, aby dostosować funkcjonowanie serwisu internetowego do otaczającej go rzeczywistości, należy poznać środowisko zewnętrzne, w którym działa serwis oraz dokładnie opisać wszystkie wewnętrzne elementy wpływające na rozwój serwisu.', 40, 41, 'analiza_swot_dla_serwisow_internetowych', 3, 31, 29, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(561, 'Szkolenia online od kuchni', 'E-learning to nauczanie przy wykorzystaniu nośników elektronicznych, takich jak Internet, intranet, komputer, CD-ROM, czy też sieci telefonii komórkowej. Jak podkreślają eksperci, polski rynek e-szkoleń jest bardzo zapóźniony. Aby móc projektować i prowadzić tego typu szkolenia, należy posiąść wiedzę i doświadczenie m.in. w zakresie tworzenia treści elektronicznych kursów, roli użytkowników systemów e-learningu, czy też wdrażania takich systemów w firmach.', 42, 45, 'szkolenia_online_od_kuchni', 3, 46, 29, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(562, 'Eros śle e-maila. Wirtualne randki w praktyce', 'Nie trzeba być wybitnym znawcą Internetu, by za jego pośrednictwem szukać pracy, wyjazdu na wakacje lub chociażby samochodu w atrakcyjnej cenie. Dlaczego by więc nie spróbować odnaleźć w sieci swojej drugiej połówki — osoby na przelotną znajomość lub towarzysza na całe życie? Jak się okazuje, wirtualne randki to jeden z hitów ostatnich miesięcy wśród rodzimych internautów.', 46, 49, 'eros_sle_e_maila_wirtualne_randki_w_praktyce', 2, 3, 29, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(563, 'Kupuj i oszczędzaj w Internecie. Gdzie szukać najtańszych i najlepszych ofert sklepów internetowych?', 'Wchodząc do tradycyjnego sklepu chcemy przede wszystkim nabyć jak najlepszy produkt za najkorzystniejszą cenę. Podobnie postępujemy odwiedzając sklepy w Internecie, które kuszą promocjami lub zniżkami. Jak sprawdzić, która oferta jest najbardziej atrakcyjna? Odwiedzanie wszystkich sklepów pozostawmy fascynatom i osobom posiadającym nadmiar wolnego czasu. Sprytny internauta po pomoc uda się do jednego z serwisów pośredniczących w wirtualnej sprzedaży.', 50, 52, 'kupuj_i_oszczedzaj_w_internecie_gdzie_szukac_najtanszych_i_najlepszych_ofert_sklepow_internetowych', 2, 4, 29, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(564, 'Witajcie w Matriksie?', '', 53, 53, 'witajcie_w_matriksie', 2, 37, 29, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(565, 'Manipulatorzy umysłów, czyli inżynieria społeczna w praktyce', 'Jeszcze kilka lat temu, aby skutecznie włamać się do czyjegoś komputera czy sieci, należało znać na wylot dany system operacyjny, wszystkie jego silne i słabe punkty, dziury w oprogramowaniu itd. Hakerzy posługiwali się głównie własną (i nabytą) wiedzą techniczną, Systemy sieciowe były znacznie słabiej zabezpieczone i dlatego prędzej czy później dało się do nich w jakiś sposób dobrać.', 54, 56, 'manipulatorzy_umyslow_czyli_inzynieria_spoleczna_w_praktyce', 2, 4, 29, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(566, 'Z wirusami nie ma żartów', 'Wywiad z Andrzejem Pilarzem, prezesem Kaspersky Lab Polska.', 58, 59, 'z_wirusami_nie_ma_zartow', 2, 6, 29, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(567, 'Łatwe projektowanie efektów specjalnych. Przegląd programów do tworzenia elementów dynamicznych na strony WWW', 'Projektując stronę WWW często zastanawiamy się jak ją uatrakcyjnić. Czysty HTML nie zawsze jest w stanie sprostać naszym oczekiwaniom, sięgamy więc po bardziej wyrafinowane rozwiązania, bazujące na skryptach i dynamicznym generowaniu kodu, i... powstaje problem, bowiem okazuje się, że aby z nich skorzystać, trzeba dysponować sporą wiedzą z zakresu programowania. Jednak czy na pewno? A może wystarczy zainstalować odpowiednią aplikację?', 60, 65, 'latwe_projektowanie_efektow_specjalnych_przeglad_programow_do_tworzenia_elementow_dynamicznych_na_strony_www', 10, 9, 29, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(568, 'Jak formatować teksty? PHP i wyrażenia regularne', 'W Internecie dostępnych jest wiele bibliotek oferujących swoje zasoby online. Największą z nich jest biblioteka Projektu Gutenberg (http://www.promo.net/pg/). Wszystkie dostępne w niej dzieła są zapisane w plikach tekstowych. Zadanie z jakim się dzisiaj zmierzymy będzie polegało na zamianie plików tekstowych na dokumenty HTML.', 66, 71, 'jak_formatowac_teksty_php_i_wyrazenia_regularne', 5, 11, 29, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(569, 'Dynamiczne menu w CSS i JavaScript', 'W początkowym okresie rozwoju Internetu odsyłacze hipertekstowe miały charakterystyczne formatowanie: niebieski kolor oraz podkreślenie. Dzisiaj wiele witryn stosuje różne metody wizualnego uatrakcyjnienia hiperłączy. Umieszczenie kursora myszki nad elementami menu często powoduje zmianę koloru hiperłącza, grubości czcionki czy podkreślenie. JavaScript stwarza możliwości oprogramowania zdarzeń onMouseOut oraz onMouseOver dla dowolnych elementów języka HTML, dzięki czemu witryna może zmieniać swój wygląd pod wpływem ruchu myszki. W artykule przedstawię metody realizacji dynamicznego menu z wykorzystaniem CSS, JavaScript oraz PHP.', 72, 75, 'dynamiczne_menu_w_css_i_javascript', 5, 43, 29, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(570, 'Dział download', 'Przeglądając strony internetowe możemy zauważyć stale powtarzające się odnośniki typu „download” lub „pliki”. Pod tymi nazwami kryją się lepiej lub gorzej zorganizowane archiwa plików. Jeżeli nosimy się z zamiarem uruchomienia podobnego działu w naszym serwisie, postarajmy się, aby zaliczał się on właśnie do tych lepiej zorganizowanych. Powinien być przystępny dla odwiedzającego i zarazem łatwy w obsłudze dla administratora. Zaprezentowane tutaj skrypty pozwolą na łatwą i przyjemną aktualizację naszych zbiorów, aodwiedzającym na wygodny do nich dostęp.', 76, 77, 'dzial_download', 5, 47, 29, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(571, 'webFAQ. Porady serwisu web.reporter.pl', '', 78, 79, 'webfaq_porady_serwisu_web_reporter_pl8', 5, 4, 29, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(572, 'Ming, czyli jak ugryźć Flasha z PHP', 'Czy marzyliście kiedyś o wstawieniu na własne strony ciekawych efektów graficznych przypominających intra gier lub filmy? Nie da się tego zrobić za pomocą HTML-a, ani animowanych GIF-ów. Z pomocą przychodzi tutaj znana wszystkim technologia Flash. W licznych artykułach prezentowanych na łamach MI opisywano sposoby tworzenia animacji z poziomu popularnego środowiska firmy Macromedia. Niewiele osób jednak wie, że pliki SWF można generować za pomocą PHP.', 80, 82, 'ming_czyli_jak_ugryzc_flasha_z_php', 5, 21, 29, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(573, 'Niezbędnik internauty', 'Każdy początkujący użytkownik Internetu po jakimś czasie stwierdza, że aby rzeczywiście sprawnie korzystać z sieci, przydałoby się coś więcej, niż tylko najprostsze programy do korzystania z podstawowych usług internetowych (zob. Poradnik praktyczny w MI 3/2003) i elementarne wiadomości o tym, jak ich używać. W tym wydaniu PP chcemy zaprezentować nieco narzędzi — czy to w postaci specjalizowanych programów, czy też nieco bardziej zaawansowanych sposobów użycia standardowych usług — które przydadzą się każdemu użytkownikowi sieci, aby łatwiej i pełniej wykorzystać jej możliwości.', 83, 100, 'niezbednik_internauty', 8, 32, 29, 18);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(574, 'Mobilny Internet', 'Od pewnego czasu mamy już „Internet w komórkach” oraz „komórki internetowe”. Coraz popularniejsze staje się odbieranie poczty e-mail przez mobilny telefon, serfowanie nie tylko po WAP-ie, przesyłanie z Internetu gier czy obrazków wprost na telefon komórkowy. Zaczynamy się zastanawiać: co będzie dalej? Jak się rozwinie rynek tych usług? Czy warto inwestować w mobilny Internet?', 26, 35, 'mobilny_internet', 11, 48, 30, 10);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(575, 'Darmowe listy dyskusyjne', 'Internet służy przede wszystkim do komunikacji. Istnieje wiele narzędzi, które umożliwiają internautom porozumiewanie się między sobą. Jednym z nich są e-mailowe listy dyskusyjne (określane też jako listy mailingowe), które wciąż mają grono wiernych zwolenników.', 36, 39, 'darmowe_listy_dyskusyjne', 3, 17, 30, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(576, 'Baza wiedzy pilnie poszukiwana, czyli jak zachęcić internautów do odwiedzania firmowej strony WWW', 'Coraz więcej firm umieszcza w Internecie swoje wirtualne wizytówki, czyli strony WWW. Ale zaistnienie w sieci nawet z bardzo atrakcyjnym serwisem teraz już nie wystarczy. Mnogość witryn powoduje, że pozyskanie uwagi internautów staje się coraz trudniejsze. Wymagania odbiorców są bardzo wysokie, stąd aby zachęcić do cyklicznych odwiedzin firmowego serwisu WWW, należy zaoferować coś unikalnego, coś, co będzie dalej nazywane bazą wiedzy.', 40, 43, 'baza_wiedzy_pilnie_poszukiwana_czyli_jak_zachecic_internautow_do_odwiedzania_firmowej_strony_www', 3, 4, 30, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(577, 'Skuteczność reklamy internetowej', 'Internetowy przemysł reklamowy kryzys ma za sobą. Ucichły już związane z nim afery, fałszywe księgowania przychodów z reklam czy dramatyczne bankructwa internetowych gigantów reklamy. Obecną fazę rozwoju rynku reklamy internetowej można określić jako „czas stabilnego wzrostu”. Reklamodawcy chłodno kalkulują koszty i potencjalne zyski. Odbiorcy stali się bardziej wybredni, już nie tak łatwo przyciągnąć ich uwagę. W efekcie, w chwili obecnej istnieje wiele różnych form reklamy internetowej, z których każda ma swoje wady i zalety. Umiejętność oceny skuteczności reklamy, znajomość oczekiwań odbiorcy oraz plusów i minusów wybranej formy przekazu to podstawa sukcesu internetowej kampanii reklamowej.', 44, 47, 'skutecznosc_reklamy_internetowej', 3, 31, 30, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(578, 'WWW — sposób na życie. Dzieciństwo, młodość, dojrzałość, starość... — zawsze z Internetem', 'Internet stał się sposobem na życie, stając się nieodłącznym towarzyszem człowieka. Listy bez znaczków pocztowych, sklep bez sprzedawcy, pieniądze w banku, którego „nie ma”, wizyta u wirtualnego kardiologa, który tak naprawdę jest programem komputerowym. To, co było przed laty wizją, teraz staje się rzeczywistością. Postęp technologiczny niesie ze sobą rozwiązania dotychczasowych problemów, ale i rodzi coraz to nowsze pragnienia. Dlatego też należy postawić pytanie, czy i w jakim stopniu Internet stał się sposobem na zaspokajanie określonych potrzeb w życiu człowieka, a następnie spróbować na nie odpowiedzieć.', 48, 51, 'www_sposob_na_zycie_dziecinstwo_mlodosc_dojrzalosc_starosc_zawsze_z_internetem', 2, 26, 30, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(579, 'Bluetooth od kuchni', 'Czy technologia Bluetooth wprowadzi nową jakość w dziedzinie przesyłania danych? Czy już niedługo będziemy mogli, także w Polsce, łączyć się z Internetem siedząc na ławce w pobliżu cyberkafejek? Przyjrzyjmy się bliżej jak funkcjonuje Bluetooth i jakie korzyści oferuje użytkownikom.', 52, 55, 'bluetooth_od_kuchni', 2, 24, 30, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(580, 'Wirtualne czasopisma. Hobby, motywacja, komercja...', 'Dlaczego powstają? Jakie czynniki decydują o ich popularności? A może to tylko czysta komercja? Zbadałem tę sprawę od podstaw. Rozmawiałem z redaktorami naczelnymi pięciu znanych i cenionych polskich e-zinów (e-zin to skrót od angielskiego wyrażenia electronic magazine, czyli innymi słowy prasa wydawana w formie elektronicznej.) Ich wypowiedzi niekiedy mnie zaskakiwały.', 56, 58, 'wirtualne_czasopisma_hobby_motywacja_komercja', 2, 3, 30, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(581, 'Polując na czcionki. Przegląd serwisów z darmowymi czcionkami', 'Co wchodzi w skład niezbędnika webmastera i grafika komputerowego? Z pewnością baza dobrych zdjęć, kliparty, programy graficzne... Osoby, które choć raz próbowały zaprojektować logo dodałyby jeszcze: czcionki. I te pospolite, i te ozdobne. Skąd je wziąć? Oczywiście z Internetu, nie płacąc ani grosza.', 60, 62, 'polujac_na_czcionki_przeglad_serwisow_z_darmowymi_czcionkami', 2, 36, 30, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(582, 'To twoje? Chyba nie...', '', 63, 63, 'to_twoje_chyba_nie', 2, 37, 30, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(583, 'Dozbrajanie Internet Explorera', 'Internet Explorer jest najczęściej używanym programem internetowym. Użytkownicy powinni zapoznać się z możliwościami jego rozbudowy, bo nawet po niewielkich modyfikacjach interfejsu można uzyskać szereg bardzo istotnych funkcji, które ułatwiają i przyspieszają pracę.', 64, 69, 'dozbrajanie_internet_explorera', 10, 9, 30, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(584, 'PHP i galerie internetowe', 'Wiele serwisów internetowych skupiających fotoamatorów czy grafików komputerowych zawiera galerie. Prezentowane fotografie i rysunki są zwykle podzielone na kategorie (jedno- lub wielopoziomowe). Artykuł prezentuje trzy przykładowe galerie wykonane w języku PHP. W opisanych rozwiązaniach położono nacisk na łatwość dodawania do galerii nowych kategorii i zdjęć.', 70, 74, 'php_i_galerie_internetowe', 5, 11, 30, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(585, 'Sposób na sklep internetowy', 'Internetowe zakupy zaczynają obejmować coraz większą gamę produktów. Na początku były to książki i płyty CD, a teraz nie ma praktycznie rzeczy, której nie można by zapakować do wirtualnego koszyka. Uruchomienie sklepu internetowego wiąże się niestety z ogromnymi kosztami, które nie zawsze muszą się zwrócić. W artykule przedstawię łatwe w realizacji rozwiązanie alternatywne, które pozwoli uniknąć, przynajmniej w początkowej fazie rozkręcania interesu, dużego wydatku jakim jest zakup gotowego skryptu.', 75, 77, 'sposob_na_sklep_internetowy', 5, 11, 30, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(586, 'Warsztat Flasha. Efekt Matrix i kolorowe fantazje', 'Wszechobecny Matrix znów zatriumfował i opanował nasze życie. Zewsząd jesteśmy atakowani znaną już symboliką. W telewizji, radiu, na ulicy — Matrix jest wszędzie, pora więc na naszą stronę internetową. Proponujemy wykonanie efektu zwanego „Matrix”, który polega na animacji spadających cyferek. Zrobienie tego efektu jest dużo łatwiejsze, niż mogłoby się wydawać.', 78, 79, 'warsztat_flasha_efekt_matrix_i_kolorowe_fantazje', 5, 21, 30, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(587, 'webFAQ. Porady serwisu web.reporter.pl', '', 80, 81, 'webfaq_porady_serwisu_web_reporter_pl9', 5, 4, 30, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(588, 'Ming i dynamiczna animacja', 'W numerze lipcowym MI opisano podstawy instalacji i obsługi biblioteki Ming. W tym miesiącu przygodę z Mingiem rozpoczniemy od utworzenia kilku prostych animacji opartych na obiektach SWFMorph, a także SWFButton. Każda z nich przedstawia jedynie zarys całego zagadnienia, bardziej szczegółowe opisy i przykłady można odnaleźć na stronie domowej projektu.', 82, 84, 'ming_i_dynamiczna_animacja', 5, 49, 30, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(589, 'Promocja internetowa', 'Promocja internetowa jest strategicznym czynnikiem decydującym o sukcesie firmy na wirtualnym rynku. W większości jednak przypadków działania firm koncentrują się tylko na tworzeniu serwisu WWW. Kreatorzy projektów skupiają swoje wysiłki na kompozycji plastycznej, sprawnej nawigacji oraz obsłudze transakcji online, zapominając o kwestii merytorycznej i promocji serwisu. Samo posiadanie strony internetowej nie przynosi firmom już korzyści.', 85, 100, 'promocja_internetowa', 8, 32, 30, 16);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(590, 'Między pecetem a serwerem', 'Zazwyczaj strony WWW tworzymy na komputerach PC z systemem Windows. Musimy je jednak umieścić na serwerze, do którego zwykle nie mamy bezpośredniego dostępu. Serwer z reguły działa pod kontrolą różnych odmian systemu UNIX (obecnie najczęściej Linuksa), choć zdarzają się również serwery działające w systemie Windows NT czy 2000. W niniejszym tekście zajmiemy się jednak metodami komunikacji między naszym PC a najczęściej spotykanymi serwerami uniksowymi.', 24, 32, 'miedzy_pecetem_a_serwerem', 11, 50, 31, 9);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(591, 'Organizacje wirtualne', 'Internet wiele zmienił w różnych sferach naszego życia. Internetowy e-handel, e-biznes czy e-marketing zmieniły także gospodarkę. Nie jest to koniec nowości w biznesie, coraz częściej mówi się o organizacjach wirtualnych. Na czym polega owa wirtualność? Co niesie ze sobą ten model prowadzenia biznesu?', 34, 37, 'organizacje_wirtualne', 3, 40, 31, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(592, 'Psychoterapia na odległość. Internet cię nie wyleczy, ale terapeuta przez Internet być może tak...', 'Wiele osób boryka się z różnymi problemami natury psychicznej: depresjami, stanami lękowymi, fobiami, kłopotami w relacjach interpersonalnych. Aby rozwiązać swoje problemy, mogą zasięgnąć porady w gabinecie psychologa, a także skorzystać z pomocy za pośrednictwem Internetu.', 38, 40, 'psychoterapia_na_odleglosc_internet_cie_nie_wyleczy_ale_terapeuta_przez_internet_byc_moze_tak', 3, 17, 31, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(593, 'Ekologia informacji', 'Pisząc o Internecie wielu autorów skupia swoją uwagę na praktycznych aspektach wykorzystania możliwości, jakie niesie to medium. Wynika to głównie z tego, że sieć uznano za jeden z elementów globalnego rynku. Rzadko znajduje się natomiast opracowania omawiające społeczne konsekwencje coraz powszechniejszego dostępu do Internetu. Dlatego dostrzegając tę lukę opisujemy ekologię informacji, która zyskuje wielu zwolenników na całym świecie.', 41, 43, 'ekologia_informacji', 3, 5, 31, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(594, 'Płatniczy galimatias. Jak płacić w sieci? Który sposób jest najbezpieczniejszy, a który najwygodniejszy?', 'Efektem dynamicznego wzrostu e-handlu i nasilenia się konkurencji pomiędzy sklepami internetowymi jest powstawanie nowych i rozwój istniejących form płatności online. Po przyjemnościach wybierania towarów i zapełniania nimi wirtualnego koszyka, nadchodzi moment, gdy trzeba udać się do sklepowej e-kasy i właśnie tam wybrać formę płatności. Liczące się w sieci sklepy umożliwiają zapłatę na wiele różnych sposobów: za zaliczeniem pocztowym, przelewem z konta, kartą kredytową, wirtualną portmonetką. Czym różnią się te formy płatności, która z nich jest najszybsza, najbezpieczniejsza, a która najtańsza?', 44, 47, 'platniczy_galimatias_jak_placic_w_sieci_ktory_sposob_jest_najbezpieczniejszy_a_ktory_najwygodniejszy', 3, 4, 31, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(595, 'Użytkownik na celowniku. Internauto, drżyj i szukaj adwokata — nadchodzi RIAA!', 'Od chwili upadku Napstera systemy P2P przeszły znaczną ewolucję. Shawn Fanning na trwałe wpisał się do historii Internetu, jednak najnowsze programy peer-to-peer bardzo różnią się od pierwowzoru. Jedno pozostało niezmienne — P2P jest bez wątpienia największym źródłem piractwa w Internecie.', 48, 51, 'uzytkownik_na_celowniku_internauto_drzyj_i_szukaj_adwokata_nadchodzi_riaa', 2, 5, 31, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(596, 'Prawdziwe oblicze hakera', 'Informacje o hakerach pojawiają się w prasie i telewizji. Tematowi hakingu poświęcono wiele stron internetowych, poruszany jest w grupach dyskusyjnych, na kanałach IRC. Jednak przekazywane w tych mediach sensacyjne wieści w wielu przypadkach mijają się z prawdą. A więc jaki naprawdę jest współczesny haker?', 52, 55, 'prawdziwe_oblicze_hakera', 2, 3, 31, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(597, 'Nauka przez Internet', 'Internet może być wykorzystywany także w celach edukacyjnych. Polacy dopiero odkrywają taką możliwość zastosowania sieci. Wynika to częściowo z niezbyt dużej oferty usług nauczania przez sieć. Jednak liczba ofert stale rośnie. Postanowiliśmy przyjrzeć się, jakie możliwości uczenia się za pomocą Internetu mają polscy internauci.', 56, 60, 'nauka_przez_internet2', 2, 51, 31, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(598, 'Przystanek Woodstock', '', 61, 61, 'przystanek_woodstock', 2, 37, 31, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(599, 'Bibliograficzne bazy danych', 'Internetowe poszukiwania ważnych dla nas informacji nie przyniosły oczekiwanych skutków? To, co znaleźliśmy nie jest wystarczająco dokładne, wiarygodne? A może po prostu chcemy poszerzyć swoją wiedzę na dany temat i przeczytać książki bądź artykuły drukowane w tradycyjnych czasopismach? W jaki sposób w Internecie można efektywnie poszukiwać informacji o tradycyjnych publikacjach? Najprostszym i najskuteczniejszym rozwiązaniem jest skorzystanie z bibliograficznych baz danych online.', 62, 64, 'bibliograficzne_bazy_danych', 2, 36, 31, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(600, 'Zrób to sam. Przegląd aplikacji do automatyzacji zadań', 'Współpraca użytkownika z komputerem polega na wydawaniu komend dla różnych aplikacji. Jednak niekoniecznie zawsze i niekoniecznie każdą operację musimy osobiście nadzorować, bo wiele typowych i możliwych do przewidzenia posunięć można po prostu zaprogramować. Pieczę nad mniej skomplikowanymi zadaniami można powierzyć w całości pecetowi, zaganiając go do pracy także wtedy, gdy sami zmuszeni jesteśmy zająć się czymś innym.', 66, 69, 'zrob_to_sam_przeglad_aplikacji_do_automatyzacji_zadan', 10, 9, 31, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(601, 'Opiekun 1.0, czyli cyberniańka made in Poland', 'Wiek przeciętnego użytkownika sieci wciąż maleje i nie jest już dziś niczym niezwykłym widok dziesięcio-- czy nawet ośmiolatka samodzielnie buszującego po Internecie. Niestety, taka popularność sieci niesie za sobą wiele zagrożeń, m.in. dostępną bez żadnych ograniczeń ostrą pornografię, strony pełne przemocy czy zachwalające narkotyki. Sposobem na ustrzeżenie dzieci od oglądania tego typu witryn jest skorzystanie ze specjalnego oprogramowania filtrującego, którym może być np. polski program Opiekun.', 70, 71, 'opiekun_1_0_czyli_cybernianka_made_in_poland', 10, 38, 31, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(602, 'JBuilder 9 Enterprise', 'Nowa wersja pakietu firmy Borland, przeznaczonego dla programistów tworzących w języku Java, integruje wszystkie etapy cyklu życia aplikacji. Zawiera m.in. wsparcie dla usług sieciowych i mechanizmy do tworzenia aplikacji mobilnych.', 72, 73, 'jbuilder_9_enterprise', 10, 38, 31, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(603, 'webFAQ. Porady serwisu web.reporter.pl', '', 74, 75, 'webfaq_porady_serwisu_web_reporter_pl10', 5, 4, 31, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(604, 'Warsztat Flasha. Powiększanie i rozwadnianie, czyli efekt lupy i wody', 'Metoda "szkiełka i oka" jest znana od wieków. Nasze „szkiełko” pozwoli dostrzec to, czego nie widać gołym okiem...', 76, 77, 'warsztat_flasha_powiekszanie_i_rozwadnianie_czyli_efekt_lupy_i_wody', 5, 21, 31, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(605, 'Jak zarobić na stronie WWW? Płatny serwis w praktyce', 'Kiedy twórca strony zastanawia się nad sensem jej istnienia i ciągłej aktualizacji, przychodzi moment kryzysu. Dobrze, jeśli ma w pobliżu ludzi chętnych do bezpłatnej pomocy. Co jednak się stanie, gdy firma hostingowa odmówi mecenatu z powodu np. gigantycznych transferów? Koniecznością staje się wprowadzenie opłat, których uiszczenie będzie szybkie, proste i bezpieczne.', 78, 81, 'jak_zarobic_na_stronie_www_platny_serwis_w_praktyce', 5, 11, 31, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(606, 'Jak stworzyć słownik internetowy', 'Współczesne słowniki internetowe umożliwiają tłumaczenie pojedynczych słów, fraz, a nawet całych stron (np. http://www.voycabulary.com). Często mamy również możliwość wyboru specjalistycznego zestawu słownictwa czy usłyszenia wymowy. Artykuł omawia kulisy realizacji internetowego słownika języka angielskiego. Największym problemem będzie oczywiście brak bazy danych. Na szczęście możemy posłużyć się słownikiem Webstera, dostępnym w bibliotece Projektu Gutenberg.', 82, 86, 'jak_stworzyc_slownik_internetowy', 5, 11, 31, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(607, 'Bezpieczeństwo w sieci', 'Internet stał się elementem naszego życia tak jak telefonia, telewizja, radio czy prasa. Jest to medium, które wyróżnia się od pozostałych nieporównywalnie większymi możliwościami przekazu oraz interaktywnością i szybkością. Dzięki temu pojęcie „wirtualny świat” zaczyna nabierać coraz bardziej realnych i konkretnych kształtów.', 87, 100, 'bezpieczenstwo_w_sieci', 8, 32, 31, 14);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(608, 'Serwerownia do wynajęcia. Oszczędzamy na IT — kolokacja, serwery dedykowane i wirtualne', 'Dziś już w zasadzie nie słychać o sytuacjach uruchamiania własnego serwera tylko po to, aby opublikować na nim niewielką stronę internetową. Firmy o niewielkich wymaganiach mają duży wybór z szerokiej oferty podstawowych usług hostingowych. Są jednak przedsiębiorstwa, którym zwykły hosting nie wystarcza. Dla nich przewidziano trzy wyspecjalizowane usługi: kolokację, serwery wirtualne oraz serwery dedykowane.', 26, 34, 'serwerownia_do_wynajecia_oszczedzamy_na_it_kolokacja_serwery_dedykowane_i_wirtualne', 11, 52, 32, 9);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(609, '(Nie)bezpieczny e-bank', 'Bankowość internetowa to z jednej strony korzyści ekonomiczne, oszczędność czasu i wygoda, a z drugiej anonimowość stron transakcji, dokumentacja w postaci elektronicznej, brak sejfów i uzbrojonych strażników. Cechy te sprawiają, że dla wielu osób tematyka ta jest dość interesująca, czasami intrygująca, a staje się wręcz wyzwaniem dla przestępców. Każdego dnia instytucje finansowe na całym świecie poddawane są próbom włamania, oszustw czy też kradzieży.', 36, 39, 'nie_bezpieczny_e_bank', 3, 27, 32, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(610, 'Domeny z odzysku. Przegląd internetowych aukcji domen', 'Domena — to właśnie od niej tak naprawdę rozpoczyna się planowanie każdego nowego serwisu. Idealna domena to coś więcej niż tylko adres: to nazwa przedsięwzięcia, niekiedy rozpoznawalna równie dobrze jak największe marki. Ale jak znaleźć dobrą i wolną domenę?', 40, 41, 'domeny_z_odzysku_przeglad_internetowych_aukcji_domen', 3, 17, 32, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(611, 'E-branding, czyli kreowanie marki w Internecie', 'E-branding to złożony i długofalowy proces, który wymaga rzetelnego i świadomego zaangażowania wszystkich pracowników firmy. Jego główną determinantą jest niewątpliwie czynnik czasowy. Niektórzy twierdzą, że sukces uda się osiągnąć w odpowiednio długiej perspektywie czasu. Czy rzeczywiście tak jest? Aby proces kreowania marki w Internecie przyniósł firmom spodziewane korzyści, potrzebny jest kompleksowy plan działań uwzględniający zarówno wizerunek firmy, funkcjonalność produktu, jak i całą filozofię zarządzania.', 42, 45, 'e_branding_czyli_kreowanie_marki_w_internecie', 3, 31, 32, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(612, '„Głębokie linki” w ogniu. Kontrowersje prawne wokół stosowania odnośników w Internecie', 'Odsyłanie do informacji za pomocą odnośników towarzyszy sieci od jej początków. Bez odsyłaczy wyszukanie interesujących nas materiałów w gąszczu portali internetowych graniczyłoby z cudem. Czy można jednak wyobrazić sobie funkcjonowanie Internetu bez wyszukiwarek? Jaki wpływ na korzystanie z sieci miałoby wyeliminowanie możliwości stosowania odnośników? Internet bez odnośników nie jest jedynie futurystyczną wizją. Od niedawna wokół sieciowych odsyłaczy narosło wiele kontrowersji natury prawnej. Wszystko za sprawą tzw. „głębokich linków”, które pozwalają na dotarcie bezpośrednio do informacji znajdujących się na podstronach, omijając stronę główną.', 46, 49, 'glebokie_linki_w_ogniu_kontrowersje_prawne_wokol_stosowania_odnosnikow_w_internecie', 3, 16, 32, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(613, 'Szaleństwo peer-to-peer', 'Chociaż wytwórnie płytowe i filmowe walczą z tym zjawiskiem z zaciętością godną lepszej sprawy, wciąż coraz więcej użytkowników Internetu korzysta z systemów wymiany plików, określanych także nazwą peer-to-peer (w skrócie P2P). Za ich pośrednictwem tysiące internautów ściąga od siebie nawzajem pliki, które zawierają zazwyczaj pirackie kopie muzyki lub filmów (stąd też wspomniane ataki ze strony producentów muzycznych i filmowych), czasami także oprogramowania. Abstrahując od aspektu prawnego tego zjawiska, pod względem technicznym stanowi ono niewątpliwie nową jakość w Internecie, której warto się bliżej przyjrzeć.', 50, 57, 'szalenstwo_peer_to_peer', 2, 24, 32, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(614, 'Uwaga, fałszywy alarm!', 'Internet niesie ze sobą zarówno korzyści, jak i zagrożenia. Wśród zagrożeń znajdują się między innymi wirusy, które obecnie łatwiej i szybciej opanowują nasze komputery. To wiemy wszyscy, ale mało kto zdaje sobie sprawę, że w sieci istnieje specyficzny rodzaj szkodliwych mikrobów, które rozprzestrzeniają się nie dzięki lukom w zabezpieczeniach komputerów, lecz dzięki podatności naszych umysłów na manipulacje.', 58, 61, 'uwaga_falszywy_alarm', 2, 3, 32, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(615, 'Usability po polsku', 'Usability to ergonomia i funkcjonalność w jednym. Braku funkcjonalności nie zatuszuje ani pokaźne archiwum informacji, ani powalająca na kolana grafika. Aby stosować elementy ergonomii w tworzonym serwisie, wystarczy poznać czynniki wpływające na poziom usability.', 62, 64, 'usability_po_polsku', 2, 4, 32, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(616, 'Unikaj błędów. Przegląd walidatorów HTML', 'Opracowanie sprawnie działającej strony WWW, w której nie byłoby żadnych błędów wcale nie jest takie proste. W mętliku znaczników, skryptów, odnośników i innych elementów bardzo łatwo się pogubić, a wtedy jeden niewinny, źle postawiony znak może doprowadzić do mniej lub bardziej widocznych „pęknięć” w strukturze serwisu. Co zatem zrobić, aby uniknąć błędów?', 66, 70, 'unikaj_bledow_przeglad_walidatorow_html', 10, 9, 32, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(617, 'Pierwsze kroki z MySQL', 'Niemal wszędzie, gdzie mamy do czynienia z dużą ilością informacji zastosowanie znajdują bazy danych. Portale internetowe zawierające katalogi produktów, towarów czy ofert zazwyczaj udostępniają dane przechowywane w bazach danych. Dzięki temu dodawanie nowych informacji do serwisu polega w istocie na dodawaniu rekordów do bazy danych, zaś oprogramowanie serwisu (kod HTML oraz PHP) nie wymaga modyfikacji. W artykule omówimy krok po kroku w jaki sposób rozpocząć wykorzystywanie SQL-owych baz danych we własnych serwisach internetowych.', 72, 74, 'pierwsze_kroki_z_mysql', 5, 53, 32, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(618, 'ZLIB — archiwizowanie danych w PHP', 'Gromadzenie dużej ilości danych wiąże się ze sporymi rozmiarami plików wynikowych, które niepotrzebnie marnują przestrzeń dyskową. Spakowany odpowiednik kilkuset kilobajtowego pliku tekstowego może zajmować zaledwie kilkanaście kilobajtów. Ponieważ większość danych na stronach WWW zapisana jest w postaci tekstu, artykuł ten został poświęcony łatwym i szybkim metodom kompresji z poziomu biblioteki ZLIB. Zwieńczeniem całości będzie napisanie prostego i funkcjonalnego systemu archiwizującego.', 75, 77, 'zlib_archiwizowanie_danych_w_php', 5, 11, 32, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(619, 'webFAQ. Porady serwisu web.reporter.pl', '', 78, 79, 'webfaq_porady_serwisu_web_reporter_pl11', 5, 4, 32, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(620, 'Szablony Smarty', 'Serwis internetowy to setki, a nawet tysiące linii kodu. Jak zapanować nad tym galimatiasem? Pomoże w tym Smarty — narzędzie programistyczne, które pozwala oddzielić główną logikę witryny od układu graficznego i małym kosztem stworzyć nawet bardzo rozbudowany serwis. Jest to rozwiązanie wydajne i skuteczne.', 80, 83, 'szablony_smarty', 5, 54, 32, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(621, 'Dynamiczne tworzenie plików PDF z poziomu PHP', 'Przeglądając strony internetowe, serwery FTP i inne zakątki Internetu można się natknąć na wiele manuali, książek elektronicznych oraz instrukcji obsługi zapisanych w formacie PDF. Firmy używają formatu PDF do przesyłania kontraktów, umów, a także generowania faktur i zestawień transakcji za pomocą stron internetowych. W większości przypadków PDF-y są tworzone offline za pomocą oprogramowania Adobe Acrobat i dopiero potem umieszczane w sieci. Okazuje się jednak, że można je tworzyć dynamicznie, bezpośrednio na stronie WWW.', 84, 88, 'dynamiczne_tworzenie_plikow_pdf_z_poziomu_php', 5, 55, 32, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(622, 'Cyberslacking i spam zagrożeniem dla firm', 'Wydawać by się mogło, że narzędzie o tak silnym potencjale jak Internet może jedynie usprawniać działalność firmy, być źródłem wielu korzyści i spektakularnych sukcesów. Okazuje się jednak, że istnieje też ujemna strona Internetu, która wyniszcza firmy. Czynnikami, które destrukcyjnie wpływają na kondycję małych przedsiębiorstw i dużych korporacji są: cyberslacking, czyli nadużywanie sieci w godzinach pracy w celach prywatnych oraz powszechnie znany spaming, czyli rozsyłanie niechcianych wiadomości. Niniejszy poradnik pokaże jak niszczycielską moc mają te dwa zjawiska i jak można się przed nimi ustrzec.', 89, 100, 'cyberslacking_i_spam_zagrozeniem_dla_firm', 8, 32, 32, 12);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(623, 'M-2 w Internecie wynajmę. Przegląd usług hostingowych', 'Przed miesiącem opublikowaliśmy raport na temat hostingu dla wymagających firm. Pisaliśmy na temat serwerów wirtualnych, kolokacji, a także o serwerach dedykowanych. Zaletom każdej z tych usług trudno przeczyć, niestety wysoka cena jest w tym przypadku niewspółmierna do korzyści dla zdecydowanej większości polskich firm. Z myślą o nich przyglądamy się w tym numerze klasycznym usługom hostingowym.', 24, 33, 'm_2_w_internecie_wynajme_przeglad_uslug_hostingowych', 11, 56, 33, 10);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(624, 'Marketing wirusowy w praktyce', 'Dla wielu firm i właścicieli stron WWW koszty reklamy w Internecie ciągle są zbyt wysokie w stosunku do efektów jakie przynoszą. Prawda jest taka, że niewielu użytkowników klika banery, czyta e-maile reklamowe i zezwala na wyświetlanie okienek pop-up lub podobnych. Jak więc skutecznie, tanio i efektywnie promować swoje produkty i usługi w sieci? Specjaliści od marketingu już dawno zauważyli, że najskuteczniejszym medium reklamy są dotychczasowi klienci, którzy zachęcają znajomych do skorzystania z usług czu produktów tej, a nie innej firmy. Ta prawidłowość ma zastosowanie także w Internecie.', 34, 35, 'marketing_wirusowy_w_praktyce', 3, 31, 33, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(625, 'Obsługa klienta na żywo w Internecie', 'Czy warto zainwestować w czat-linię? Który system wybrać? Pomysł wykorzystywania systemów typu live support przy elektronicznej obsłudze klienta pojawił się na Zachodzie już pewien czas temu. W Polsce jest to wciąż nowe rozwiązanie, stosowane jak dotąd tylko przez nielicznych. Co takiego niezwykłego posiada to nieznacznie zmodyfikowane oprogramowanie, znane z portalowych czatów? Kiedy i dlaczego warto je wdrożyć? Gdzie można je kupić? Odpowiedzi zawarłem w poniższym artykule.', 36, 41, 'obsluga_klienta_na_zywo_w_internecie', 3, 5, 33, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(626, 'E-rekrutacja: szybciej i taniej', 'Stale ulepszane metody rekrutacji przez Internet stają się coraz skuteczniejsze i — dzięki temu — coraz bardziej opłacalne dla pracodawców.', 42, 45, 'e_rekrutacja_szybciej_i_taniej', 3, 57, 33, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(627, 'Poczta elektroniczna z komórki', 'Jedną z najbardziej popularnych usług dostępnych w Internecie jest poczta elektroniczna. Korzysta z niej zdecydowana większość użytkowników sieci. Do odbierania i wysyłania poczty wykorzystują oni najczęściej komputer. Jednak coraz większą popularność zyskuje możliwość korzystania z poczty za pomocą telefonu komórkowego.', 46, 49, 'poczta_elektroniczna_z_komorki', 2, 17, 33, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(628, 'Z szelestem papieru', '', 51, 51, 'z_szelestem_papieru', 2, 37, 33, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(629, 'Internetowe banki zdjęć', 'Przekaz graficzny w silnie skomercjalizowanym świecie towarzyszy nam praktycznie na każdym kroku. Jedno zdjęcie jest często w stanie zastąpić sto słów. Mówi wiele o temacie reklamy, jej nastroju i grupie docelowej. Zwraca uwagę, zachęcając do zapoznania się z właściwym przekazem reklamowym, nie pozwalając się nim znużyć. Udałem się na poszukiwanie źródeł tych graficznych miniarcydzieł. Bynajmniej nie trafiłem z pękatym portfelem do fotografa... trop prowadził do Internetu.', 52, 56, 'internetowe_banki_zdjec', 2, 36, 33, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(630, 'Internet w roli wolontariusza. Jakie korzyści daje sieć organizacjom pozarządowym?', 'Życie organizacji społecznych nie jest łatwe. Muszą na co dzień zmagać się z wieloma przeciwnościami. Jednak w tej ciężkiej pracy mają do dyspozycji narzędzie, które może im pomóc przezwyciężyć przynajmniej część trudności i zwiększyć efektywność działania. Narzędziem tym jest Internet.', 58, 61, 'internet_w_roli_wolontariusza_jakie_korzysci_daje_siec_organizacjom_pozarzadowym', 2, 26, 33, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(631, 'Mój komputer moją twierdzą. ZoneAlarm i Norton Personal Firewall w akcji', 'Na komputer podłączony do Internetu czyha wiele niebezpieczeństw: wirusy, robaki internetowe, konie trojańskie czy wreszcie prawdziwi hakerzy. By choć po części uchronić swojego peceta przed tymi zagrożeniami, warto zainstalować proste zabezpieczenie w postaci programowego firewalla.', 62, 67, 'moj_komputer_moja_twierdza_zonealarm_i_norton_personal_firewall_w_akcji', 2, 4, 33, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(632, 'Nie z nami te numery... Przegląd antydialerów', 'Zagrożenia, jakie czyhają na nas w Internecie, to nie tylko wirusy, trojany, spam czy hakerzy. Użytkownicy konwencjonalnych modemów (cyfrowych bądź analogowych) narażeni są dodatkowo na podstępne oszustwa ze strony tzw. dialerów, które potajemnie instalują się na komputerach i zamieniają domyślne połączenia dial-up.', 68, 73, 'nie_z_nami_te_numery_przeglad_antydialerow', 10, 9, 33, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(633, 'Proste serwisy WWW wykorzystujące bazy danych', 'W poprzednim numerze MI poznaliśmy podstawowe zagadnienia dotyczące skryptów pisanych w języku PHP z wykorzystaniem baz danych MySQL. Tym razem skupimy się na wybieraniu informacji z bazy danych. Przykładowe serwisy pokażą w jaki sposób wybrać z tabeli konkretny rekord i wyświetlić go na stronie WWW. Dowiemy się również w jaki sposób umieszczać w bazie dane binarne (np. pliki graficzne).', 74, 79, 'proste_serwisy_www_wykorzystujace_bazy_danych', 5, 53, 33, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(634, 'Generowanie grafiki w języku JavaScript', 'Już sam tytuł artykułu może być zaskakujący. Od kiedy JavaScript pozwala na generowanie grafiki? Nie, wcale nie nastąpił żaden przełom. JavaScript nadal takich możliwości nie posiada...', 80, 85, 'generowanie_grafiki_w_jezyku_javascript', 5, 43, 33, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(635, 'Bezpieczne uwierzytelnianie bez SSL', 'We wszystkich internetowych systemach wymagających autoryzacji użytkowników sprawą priorytetową jest bezpieczeństwo. Nie możemy pozwolić, aby dostęp do poufnych informacji uzyskał ktoś nieuprawniony. Najlepszym rozwiązaniem problemu jest oczywiście szyfrowanie połączeń HTTP, ale co zrobić, gdy nie dysponujemy serwerem o takich możliwościach?', 86, 87, 'bezpieczne_uwierzytelnianie_bez_ssl', 5, 58, 33, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(636, 'CVS, czyli sposób na zorganizowanie projektu internetowego', 'Wielu programistów z pewnością nie raz pracowało w grupie zajmującej się rozbudowanym projektem internetowym. Tysiące linijek kodu, setki plików, dziesiątki modułów... W jaki sposób uniknąć nieporozumień? Jak wydajnie i sprawiedliwie podzielić pracę? Najprostszym, ale i najdroższym rozwiązaniem jest zatrudnienie menedżera projektu. A co zrobić, jeśli budżet przedsięwzięcia jest bliski zeru? Odpowiedź jest prosta — trzeba posłużyć się programem CVS, który daje możliwość pełnej kontroli nad kolejnymi wersjami projektu.', 88, 89, 'cvs_czyli_sposob_na_zorganizowanie_projektu_internetowego', 5, 59, 33, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(637, 'webFAQ. Porady serwisu web.reporter.pl', '', 90, 91, 'webfaq_porady_serwisu_web_reporter_pl12', 5, 4, 33, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(638, 'Firmowy sklep online', 'Podpowiadamy, jak uruchomić sklep dowolnej wielkości w Internecie.', 92, 101, 'firmowy_sklep_online', 8, 32, 33, 10);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(639, 'e-Commerce: czekając na kolejną falę', 'Polski e-handel czeka na swój czas. Przedsięwzięcia związane z nową gospodarką stają się coraz bardziej przemyślane. Często stosowanym sposobem na zarabianie na handlu elektronicznym jest łączenie tej działalności z innymi usługami lub wręcz mocnym osadzeniu w tradycyjnym biznesie.', 30, 32, 'e_commerce_czekajac_na_kolejna_fale', 11, 34, 34, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(640, 'Zakupy w sieci', 'Warto pobuszować po internetowych sklepach przed świętami — okazji jest sporo, a siedząc wygodnie przed monitorem unikniemy niepotrzebnych stresów. Praca Świętego Mikołaja może być w końcu łatwiejsza...', 30, 41, 'zakupy_w_sieci', 11, 34, 34, 12);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(641, 'Wykręć sobie numer', 'Wydawało się już, że wobec ofensywy szerokopasmowego dostępu do Internetu dial-up to pieśń przeszłości. Niespodziewanie jednak modem stał się przepustką do świata darmowych serwisów i usług niedostępnych dla pozostałych internautów.', 42, 45, 'wykrec_sobie_numer', 12, 40, 34, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(642, 'Rejestracja domen z polskimi znakami diakrytycznymi', 'Jeszcze do niedawna nie było możliwe zarejestrowanie domeny zapisanej w języku innym niż angielski, z uwzględnieniem znaków diakrytycznych. Rozwiązaniem problemu stały się IDN-y, czyli domeny, które możemy zapisać za pomocą dowolnych znaków pochodzących z repertuaru znaków Unikodu.', 46, 47, 'rejestracja_domen_z_polskimi_znakami_diakrytycznymi', 12, 4, 34, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(643, 'Open Source kontra komercja', 'Polskie firmy nie muszą wcale ponosić kosztów związanych z zakupem oprogramowania. Takie pakiety jak Office czy Photoshop można spokojnie zastąpić darmowym oprogramowaniem, które ma prawie identyczną funkcjonalność.', 48, 50, 'open_source_kontra_komercja', 12, 4, 34, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(644, 'Nie doKazuj miły, nie doKazuj...', 'Oprogramowanie P2P, tak popularne wśród użytkowników, stanowi istną zmorę administratorów sieci. Głównym problemem oprócz dyskusyjnej legalności uzyskiwania w ten sposób plików jest zapychanie łącza. Jeśli nie stosuje się mechanizmów ograniczających transfer dla poszczególnych użytkowników, zazwyczaj dochodzi do zablokowania wąskiego gardła sieci, jakim jest bramka internetowa.', 52, 55, 'nie_dokazuj_mily_nie_dokazuj', 12, 4, 34, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(645, 'MP3 na każdym kroku', 'Według badań przeprowadzonych przez zagraniczne serwisy internetowe odtwarzacz MP3 jest najbardziej pożądanym przez użytkowników komputerów prezentem gwiazdkowym. Przygotowaliśmy przegląd najciekawszych modeli dostępnych na polskim rynku.', 56, 61, 'mp3_na_kazdym_kroku', 2, 60, 34, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(646, 'Plagiaty plaga Internetu', 'Serfując po sieci można dość łatwo natrafić na strony bardzo podobne do siebie. W niektórych przypadkach na pierwszy rzut oka wydaje się, że jest to jedna i ta sama witryna. Wątpliwości rozwiewa dokładniejsze przyjrzenie się obu serwisom. Okazuje się, że należą do różnych osób lub firm. Najprawdopodobniej mamy więc do czynienia z plagiatem.', 62, 65, 'plagiaty_plaga_internetu', 2, 16, 34, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(647, 'Wasz błąd, nasz zysk', 'Jak firmy zarabiają na nieistniejących stronach WWW i wygasłych domenach internetowych?', 66, 69, 'wasz_blad_nasz_zysk', 2, 3, 34, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(648, 'Załóż własną rozgłośnię radiową, czyli jak uruchomić radio internetowe', 'Środki masowego przekazu mają w sobie coś z magii. Prawie każdy chciałby przynajmniej raz znaleźć się w środku zainteresowania mediów. Ale co zrobić, jeśli nie możemy na to liczyć? Wtedy możemy sami rozpocząć działalność medialną. Potrzeba zaledwie kilku godzin, by założyć rozgłośnię radiową nadającą na cały świat przez Internet.', 70, 72, 'zaloz_wlasna_rozglosnie_radiowa_czyli_jak_uruchomic_radio_internetowe', 2, 4, 34, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(649, 'Kawiarniany Internet', 'Istnieją pewne zasady, o których należy pamiętać korzystając z cyberkafejek.', 74, 76, 'kawiarniany_internet', 2, 4, 34, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(650, 'Książka w... Internecie?', '', 77, 77, 'ksiazka_w_internecie', 2, 37, 34, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(651, 'Wirusom STOP!', 'Przegląd programów antywirusowych.', 78, 83, 'wirusom_stop', 10, 9, 34, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(652, 'Galeria w sieci — to takie łatwe!', 'Jak szybko i bezproblemowo wykonać galerię internetową? Jakimi programami się posłużyć? Miniporadnik dla początkujących.', 84, 86, 'galeria_w_sieci_to_takie_latwe', 5, 61, 34, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(653, 'GIMP: tworzenie grafiki na potrzeby WWW. Część 1.', 'Program GIMP jest bezpłatnym narzędziem oferującym bogate możliwości obróbki grafiki komputerowej. Z powodu różnic interfejsu programu w stosunku do aplikacji Windows, GIMP potrafi skutecznie odstraszyć początkujących użytkowników. W jaki sposób ujarzmić GIMPa? O tym traktuje niniejszy artykuł, który rozpoczyna cykl mający na celu przedstawienie możliwości programu oraz metod pracy ze szczególnym uwzględnieniem tworzenia grafiki na potrzeby serwisów WWW.', 87, 91, 'gimp_tworzenie_grafiki_na_potrzeby_www_czesc_1', 5, 62, 34, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(654, 'RSS — syndykacja treści', 'Internet jest miejscem, w którym z każdą chwilą trudniej o szybką i precyzyjną nformację. Ponadto informacje ulegają dezaktualizacj, czego nie jesteśmy w stanie efektywnie kontrolować. RSS wprowadza taką możliwość, pozwalając użytkownikowi swobodnie śledzić zmiany zachodzące na wybranej przez niego stronie internetowej.', 92, 95, 'rss_syndykacja_tresci', 5, 24, 34, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(655, 'Smarty i baza danych', 'Smarty jest jedną z najpopularniejszych klas szablonów do PHP. Bardzo dobrze spełnia swoje podstawowe zadanie, które polega na oddzieleniu warstwy logiki aplikacji od warstwy prezentacji. Ma duży potencjał: instrukcje warunkowe, pętle, modyfikatory, funkcje itd. W artykule przedstawię sposób, w jaki można zintegrować Smarty z bazą danych, co pozwoli na czytanie szablonów oraz czytanie i zapisywanie cache''u wygenerowanych stron do bazy.', 96, 101, 'smarty_i_baza_danych', 5, 54, 34, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(656, 'webFAQ. Porady serwisu web.reporter.pl', '', 102, 103, 'webfaq_porady_serwisu_web_reporter_pl13', 5, 4, 34, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(657, 'PHP i MySQL: dodawanie rekordów do bazy danych za pomocą formularzy HTML', 'W kolejnym odcinku poświęconym serwisom WWW wykorzystującym bazy danych MySQL przyjrzymy się formularzom. Formularze elektroniczne umożliwiają przekazywanie różnorodnych informacji od gości odwiedzających nasze strony do skryptu zapisanego na serwerze. Umożliwia to tworzenie serwisów, których zawartość jest aktualizowana odpowiednimi stronami WWW zawierającymi formularze.', 104, 108, 'php_i_mysql_dodawanie_rekordow_do_bazy_danych_za_pomoca_formularzy_html', 5, 63, 34, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(658, 'Dojrzewanie internetowego biznesu', 'W ciągu ostatnich dziesięciu lat Internet zmienił się z ciekawostki używanej przez naukowców i specjalistów komputerowych w ogólnoświatowe narzędzie komunikacyjne. Dziś trudno wyobrazić sobie świat bez globalnej sieci. Okazuje się, że na Internecie można zarabiać... i to całkiem sporo.', 30, 35, 'dojrzewanie_internetowego_biznesu', 11, 40, 35, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(659, 'Projekt EMMA. Polskie firmy w USA dzięki Unii Europejskiej?', 'Każda firma zajmująca się multimediami i szeroko pojętą branżą IT zamierza w przyszłości działać na rynkach zagranicznych — -najlepiej unijnym lub amerykańskim. Jeżeli sama Unia Europejska zamierza ułatwić tę ekspansję, to odpowiedź na tytułowe pytanie powinna być oczywista, zwłaszcza że Unia dostarcza odpowiednich narzędzi.', 36, 38, 'projekt_emma_polskie_firmy_w_usa_dzieki_unii_europejskiej', 12, 64, 35, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(660, '„Ograniczona” i płatna reklama w wyszukiwarkach internetowych', 'Internet to unikatowe medium. Marketing w tym medium znacznie różni się od tradycyjnych form promocji, a kojarzony przez wszystkich baner nie jest najlepszym przykładem różnic, zbytnio przypomina tradycyjną reklamę.', 40, 45, 'ograniczona_i_platna_reklama_w_wyszukiwarkach_internetowych', 12, 31, 35, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(661, 'Goście na czacie, eksperci na forum', 'Odpowiednio ukierunkowany czat lub forum dyskusyjne mogą nie tylko dostarczać wiedzy oraz rozrywki, ale i stanowić pełnoprawny element przemyślanej kampanii promocyjnej online.', 46, 47, 'goscie_na_czacie_eksperci_na_forum', 12, 65, 35, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(662, 'Kupowanie muzyki online', 'Możliwość legalnego kupowania muzyki w wersji elektronicznej przez Internet w końcu staje się faktem. Duże wytwórnie muzyczne w końcu zdecydowały się dać zielone światło na sprzedaż utworów przez sieć. Może więc wreszcie piractwo fonograficzne umrze śmiercią naturalną.', 48, 51, 'kupowanie_muzyki_online', 2, 4, 35, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(663, 'Zadbaj o swoją prywatność, czyli jak chronić się przed spamerami, reklamami, hakerami, wirusami i spyware’em', 'Internet to bardzo przydatne narzędzie, jednak niesie pewne zagrożenia. Jednym z nich jest ryzyko utraty prywatności. Na szczęście stosując bardzo proste zasady i korzystając z licznych wskazówek możemy to ryzyko ograniczyć do minimum.', 52, 57, 'zadbaj_o_swoja_prywatnosc_czyli_jak_chronic_sie_przed_spamerami_reklamami_hakerami_wirusami_i_spywareem', 2, 4, 35, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(664, 'Bezpieczeństwo stron internetowych', 'Jak skutecznie utrudnić zadanie intruzom i nie narazić się na straty?', 58, 61, 'bezpieczenstwo_stron_internetowych', 2, 66, 35, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(665, 'Niepełnosprawni online', 'W Polsce jest ponad 4 mln osób niepełnosprawnych. Spotykają się one z różnego rodzaju ograniczeniami w kontaktach z innymi ludźmi, mają problemy ze znalezieniem pracy lub możliwością nauki. Dzięki Internetowi coraz częściej przezwyciężają te ograniczenia i czują, że są pełnoprawnymi członkami społeczeństwa.', 62, 65, 'niepelnosprawni_online', 2, 67, 35, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(666, 'Paragrafem w cyberprzestępcę', 'Regulacje prawne nie nadążają za rozwojem informatycznym...', 66, 69, 'paragrafem_w_cyberprzestepce', 2, 16, 35, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(667, 'Komunikator po tuningu', 'Czy komunikator internetowy bez obsługi pluginów to już przeżytek?', 70, 71, 'komunikator_po_tuningu', 2, 5, 35, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(668, 'Domeny dla Kowalskiego', 'Wywiad z Maciejem Kozłowskim, dyrektorem NASK-u.', 72, 73, 'domeny_dla_kowalskiego', 2, 6, 35, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(669, 'Cyfrowe uniwersum, czyli przegląd edytorów PDF', 'Format PDF, stworzony w 1991 r. przez firmę Adobe, stał się światowym standardem publikowania informacji. Uniwersalny styl zapisu, gwarantujący wszystkim odbiorcom zawsze jednakową formę przekazu, zjednał sobie tak liczne grono zwolenników, że stał się drugim po HTML-u nośnikiem informacji w Internecie. Przyjrzyjmy się więc bliżej narzędziom do redagowania tego typu dokumentów.', 74, 79, 'cyfrowe_uniwersum_czyli_przeglad_edytorow_pdf', 10, 9, 35, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(670, 'Norton AntiVirus 2004 PL', 'Jednym z największych zagrożeń związanych z korzystaniem z Internetu jest zdecydowane zwiększenie podatności systemu na atak wirusów, które mogą być rozpowszechniane zarówno za pośrednictwem poczty elektronicznej, jak i stanowić niespodziewany dodatek do pobieranych plików. Aby uchronić się przed ich destrukcyjną działalnością, należy skorzystać z dobrego programu antywirusowego. Interesującą propozycją w tym zakresie jest nowa wersja popularnej aplikacji Norton AntiVirus.', 83, 83, 'norton_antivirus_2004_pl', 10, 38, 35, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(671, 'Wykresy w PHP. Biblioteka GD od podstaw', 'Wiele serwisów internetowych korzysta z możliwości generowania prostych grafik za pomocą języka PHP. Czynność ta jest niezwykle prosta, a w wielu przypadkach może być niezastąpiona.', 84, 87, 'wykresy_w_php_biblioteka_gd_od_podstaw', 5, 11, 35, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(672, 'Złożone zapytania SQL', 'Dzisiejsze spotkanie z językiem SQL poświęcimy rozbudowanym zapytaniom dotyczącym kilku tabel. Przykładowa baza danych, która zawiera szczegółowe informacje dotyczące pierwszej ligi piłkarskiej, stwarza doskonałe środowisko do nauki języka SQL.', 88, 93, 'zlozone_zapytania_sql', 5, 63, 35, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(673, 'GIMP: tworzenie grafiki na potrzeby WWW (część 2)', 'Drugie spotkanie z GIMPem poświęcimy selekcjom, linijkom i prowadnicom. Linijki i prowadnice pomagają w precyzyjnym umiejscowieniu elementów rysunku, natomiast selekcje umożliwiają wykonywanie operacji edytorskich na fragmentach rysunków.', 94, 99, 'gimp_tworzenie_grafiki_na_potrzeby_www_czesc_2', 5, 62, 35, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(674, 'webFAQ. Porady serwisu web.reporter.pl', '', 100, 101, 'webfaq_porady_serwisu_web_reporter_pl14', 5, 4, 35, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(675, 'HTA, czyli aplikacje HTML', 'Słowo „aplikacja” kojarzy się najczęściej z programem wykonywalnym, napisanym w którymś z popularnych języków programowania. W tym kontekście termin „aplikacja HTML” może brzmieć nieco dziwnie — -czy możliwe jest napisanie programu w języku HTML?', 102, 108, 'hta_czyli_aplikacje_html', 5, 29, 35, 7);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(676, 'Podłączyć całą Polskę. Dostęp szerokopasmowy: obiecujący rynek', 'Czy dostęp do sieci to jeszcze luksus czy już standard? Kiedy spełni się wizja „Internetu w każdym domu”? Czy na rynku usług dla użytkowników indywidualnych doczekamy się prawdziwej konkurencji? Kiedy wreszcie spadną ceny dostępu szerokopasmowego? Czy jest szansa na upowszechnienie Internetu w małych miastach i wsiach? Analitycy twierdzą, że rok 2004 ma przynieść znaczne zmiany, być może rewolucyjne...', 26, 30, 'podlaczyc_cala_polske_dostep_szerokopasmowy_obiecujacy_rynek', 11, 68, 36, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(677, 'Dial-up ciągle w modzie', 'Czy dzisiaj warto jeszcze korzystać z wolnych połączeń modemowych? Czy nie lepiej zapłacić miesięczny abonament i swobodnie serfować? Oczywiście tak, istnieją jednak argumenty, które przemawiają za zwykłą linią telefoniczną i modemem.', 30, 34, 'dial_up_ciagle_w_modzie', 11, 68, 36, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(678, 'Cyfrowe wykluczanie', 'Technologie, takie jak telefony komórkowe, cały czas zyskują nowych użytkowników, to stanowią oni mniejszość wśród mieszkańców naszej planety. Coraz bardziej zarysowuje się przepaść dzieląca tych, którzy mają dostęp do nowoczesnych technologii, i tych, którzy tego dostępu są pozbawieni. Ci drudzy znajdują się w obszarze cyfrowego wykluczenia.', 34, 35, 'cyfrowe_wykluczanie', 11, 68, 36, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(679, 'Keyword research, czyli badania słów kluczowych', 'W poprzednim numerze MI przybliżyliśmy dwie formy marketingu w wyszukiwarkach: jedna polegała na kupowaniu pozycji dla konkretnych słów kluczowych, druga na optymalizacji serwisu pod kątem wybranych słów i fraz. Dla obu form wspólna i równie znacząca jest faza zbadania języka zapytań i logiki używanej przez potencjalnych odbiorców.', 36, 39, 'keyword_research_czyli_badania_slow_kluczowych', 12, 31, 36, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(680, 'Bazy teleadresowe firm', 'Dla firm oferujących swoje produkty i usługi innym podmiotom gospodarczym ogromne znaczenie ma dostęp do informacji o potencjalnych kooperantach. Dane teleadresowe i nie tylko znajdują się w internetowych bazach danych.', 40, 41, 'bazy_teleadresowe_firm', 12, 17, 36, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(681, 'Tajniki pozycjonowania stron WWW', 'Spośród wszystkich dostępnych sposobów promocji internetowej najmniej znane jest pozycjonowanie. Narosło wokół niego wiele mitów, jedne z nich są całkowicie fałszywe, inne zawierają ziarno prawdy.', 42, 49, 'tajniki_pozycjonowania_stron_www', 12, 4, 36, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(682, 'Neostrada: wpadka za wpadką', 'Abonenci narzekają, UOKiK nakłada karę, a właściciele... przepraszają.', 50, 51, 'neostrada_wpadka_za_wpadka', 2, 17, 36, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(683, 'Telefonia P2P, czyli rozmowy telefoniczne za darmo', 'Wszyscy korzystamy z telefonów, wszyscy płacimy rachunki za rozmowy. Życie bez telefonu raczej trudno sobie wyobrazić, natomiast bez rachunków... jak najbardziej! Dzięki technologii peer-to-peer (P2P) możemy raz na zawsze uwolnić się od uciążliwych opłat.', 52, 53, 'telefonia_p2p_czyli_rozmowy_telefoniczne_za_darmo', 2, 24, 36, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(684, 'Telepraca', 'W artykule przedstawiamy, co kryje się pod pojęciem telepracy, na jakich stanowiskach taka forma zatrudnienia może być realizowana oraz opisujemy regulacje prawne i zasady organizacji stanowisk pracy.', 54, 57, 'telepraca2', 2, 26, 36, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(685, 'Internauta na wykresach. Jak przeprowadzane są w Polsce badania Internetu?', 'Liczba internautów w naszym kraju systematycznie rośnie — -obecnie wynosi ponad 7,1 mln. O przeciętnym Kowalskim i jego aktywności w Internecie wiemy już o wiele więcej, niż mogłoby się wydawać. Jest to zasługa szczegółowych badań Internetu śledzących ruch na stronach WWW, jak i poczynania samych użytkowników sieci.', 58, 59, 'internauta_na_wykresach_jak_przeprowadzane_sa_w_polsce_badania_internetu', 2, 69, 36, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(686, 'Małe, złośliwe okienka', 'Pop-upy, czyli niewielkie okienka, które otwierają się automatycznie w chwili odwiedzania serwisu, miały przyciągać uwagę internautów, ale szybko okazało się, że są ich zmorą...', 60, 63, 'male_zlosliwe_okienka', 2, 16, 36, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(687, 'Internet z dopalaczem, czyli jak przyspieszyć ściąganie danych', 'Co ma zrobić użytkownik łącza dial-up, który często z frustracją obserwuje, jak powoli otwierają mu się strony WWW lub ściągają pliki? Może skorzystać z różnych możliwości przyspieszenia Internetu.', 64, 65, 'internet_z_dopalaczem_czyli_jak_przyspieszyc_sciaganie_danych', 2, 4, 36, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(688, 'Jak zrobić złą stronę WWW?', 'W sieci można znaleźć mnóstwo poradników o tym, jak upiększyć swoją stronę i jak sprawić, by była tak dobra, jak to tylko możliwe. Nikt jednak nie pisze o tym, jak łatwo można popsuć nawet najlepszą witrynę. A sposobów na to jest naprawdę mnóstwo!', 66, 67, 'jak_zrobic_zla_strone_www', 2, 4, 36, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(689, 'Bezpieczeństwo PHP', 'Dlaczego problem bezpieczeństwa jest tak często pomijany? Może dlatego, że bezpieczeństwa nie widać. Podobnie jak nie widać zagrożeń. Czy bezpieczny program zarobi dla nas pieniądze? Nie. Może je jednak zatrzymać w naszej kieszeni, bo pieniądze można łatwo stracić, a wraz z nimi reputację, markę i dotychczasowych klientów.', 68, 71, 'bezpieczenstwo_php', 2, 4, 36, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(690, 'Earth Station 5. Nowe oblicze sieci peer-to-peer?', 'Earth Station 5 jest aplikacją typu peer-to-peer (P2P), która po raz pierwszy zaistniała w Internecie około półtora roku temu i bardzo szybko zdobyła ogromną popularność. Skoro tak, to może już najwyższy czas przesiąść się z eMule’a na ES5?', 72, 74, 'earth_station_5_nowe_oblicze_sieci_peer_to_peer', 2, 70, 36, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(691, 'Allegro dla wielkiej orkiestry', '', 75, 75, 'allegro_dla_wielkiej_orkiestry', 2, 37, 36, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(692, 'WWW offline, czyli czym kopiować witryny internetowe', 'Wciąż dużym zainteresowaniem cieszą się tzw. przeglądarki offline. Aplikacje te kopiują całe serwisy WWW z zachowaniem struktury katalogów i odnośników, tak by można je było później swobodnie przeglądać, bez presji czasu spowodowanej „tykaniem licznika”.', 76, 81, 'www_offline_czyli_czym_kopiowac_witryny_internetowe', 10, 9, 36, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(693, 'Obiektowy dostęp do baz danych', 'Tworzenie większych serwisów internetowych w języku PHP z wykorzystaniem baz danych wymaga odpowiedniej organizacji kodu. Wyodrębnienie modułu dostępu do bazy danych ułatwia zarządzanie zapytaniami wysyłanymi do bazy. Artykuł przedstawia przykładową aplikację, w której wykorzystano obiektową implementację warstwy dostępu do bazy danych.', 86, 91, 'obiektowy_dostep_do_baz_danych', 5, 63, 36, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(694, 'GIMP: tworzenie grafiki na potrzeby WWW (cz. 3)', 'W kolejnym spotkaniu z programem GIMP przyjrzymy się ścieżkom. Wykorzystanie ścieżek daje możliwość wygodnego modyfikowania kształtu rysowanych elementów.', 92, 96, 'gimp_tworzenie_grafiki_na_potrzeby_www_cz_3', 5, 62, 36, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(695, 'Co nowego w piątej wersji PHP', 'Mimo że najnowsza wersja PHP, oznaczona numerem 5, nie jest jeszcze dostępna, już dziś możemy poznać jej możliwości dzięki pojawiającym się coraz częściej wersjom beta. Wszystko wskazuje na to, że „piątka” odniesie wielki sukces.', 97, 99, 'co_nowego_w_piatej_wersji_php', 5, 11, 36, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(696, 'webFAQ. Porady serwisu web.reporter.pl', '', 100, 101, 'webfaq_porady_serwisu_web_reporter_pl15', 5, 4, 36, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(697, 'Bądź bezpieczny w Internecie!', 'Co nam grozi? Jak się bronić? Jakie programy skutecznie ochronią nasz komputer? Co to jest firewall i jak z niego korzystać?', 28, 33, 'badz_bezpieczny_w_internecie', 11, 39, 37, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(698, 'WLAN dla każdego, czyli jak postawić sieć WiFi', 'Jeszcze do niedawna o sieci bezprzewodowej w domu czy na osiedlu można było sobie tylko pomarzyć. Ze względu na wysokie koszty urządzeń radiowych na to rozwiązanie decydowały się tylko zamożne firmy lub instytucje. Dziś, gdy radiolinię można skompletować w cenie poniżej 1500 zł, a koszt pojedynczego punktu dostępowego to ok. 500 zł, sieci WiFi zaczynają trafiać „pod strzechy".', 34, 39, 'wlan_dla_kazdego_czyli_jak_postawic_siec_wifi', 12, 4, 37, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(699, 'Polski Internet w opałach. Monopol Telekomunikacji Polskiej rośnie w siłę', 'Milkną kolejne internetowe stacje radiowe lub są nadawane w coraz gorszej jakości, znika jedyna społeczna stacja TV. Drożeją konta e-mail, zmniejsza się ich pojemność. Na rynku pozostają dwie, trzy firmy dyktujące wszystkim warunki. Czy to fikcja, czarny scenariusz rozwoju wydarzeń w jakimś małym kraju na peryferiach świata? Nie, to realny scenariusz rozwoju sytuacji w polskim Internecie!', 40, 41, 'polski_internet_w_opalach_monopol_telekomunikacji_polskiej_rosnie_w_sile', 12, 71, 37, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(700, 'Reklama w wyszukiwarkach: pomiar kosztów i skuteczności', 'Polskie firmy są coraz bardziej świadome faktu, że umieszczenie strony w Internecie to dopiero początek obecności w sieci. Rośnie zainteresowanie promocją w wyszukiwarkach oraz płatną reklamą.', 42, 45, 'reklama_w_wyszukiwarkach_pomiar_kosztow_i_skutecznosci', 12, 31, 37, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(701, 'Elementarz Internetu. Część I: wszystkie drogi prowadzą do... sieci', 'Niezbędna wiedza praktyczna dla początkujących internautów.', 46, 51, 'elementarz_internetu_czesc_i_wszystkie_drogi_prowadza_do_sieci', 2, 72, 37, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(702, 'Barometr Internetu: co nas kręci w sieci?', 'Od tego numeru rozpoczynamy, wspólnie z wyszukiwarką Netsprint.pl, publikowanie swoistej listy przebojów wskazującej na popularność określonych tematów w globalnej sieci i zapraszamy do brania czynnego udziału we wskazywaniu miejsc, w które warto zajrzeć w poszukiwaniu informacji.', 52, 55, 'barometr_internetu_co_nas_kreci_w_sieci', 2, 73, 37, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(703, 'Webringi — dobry sposób na promocję', 'Niemal każdy amatorski serwis internetowy pragnie docierać do nowych użytkowników bez nakładów finansowych. Aby realizować to zadanie, powstały specjalnie powiązane ze sobą grupy stron — webringi.', 56, 57, 'webringi_dobry_sposob_na_promocje', 2, 26, 37, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(704, 'Informacja zbyt dobrze chroniona?', 'Rozwój Internetu postawił w kłopotliwej sytuacji producentów, wydawców i autorów. Upowszechnienie sieci pozwoliło na transmisję danych w niespotykanej dotąd skali. Pojawia się więc pytanie: w jaki sposób zabezpieczyć informacje udostępniane w Internecie przed dostępem nieuprawnionych osób?', 58, 59, 'informacja_zbyt_dobrze_chroniona', 2, 5, 37, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(705, 'Google: pan i władca internetowego wyszukiwania. Krótka historia wielkiego sukcesu', 'Z małej, dwuosobowej firmy Google zmieniło się w ekspansywnego gracza, szukającego możliwości zysku w każdej niemal niszy rynkowej. W efekcie praktycznie zmonopolizowało rynek wyszukiwarek internetowych. Nie dziwi więc, że New York Times opublikował niedawno felieton, w którym tytuł jest jednocześnie retorycznym pytaniem: „Czy Google jest bogiem?”. Kilka lat temu byłoby ono nie na miejscu. Dzisiaj coraz częściej szuka się na nie odpowiedzi.', 60, 63, 'google_pan_i_wladca_internetowego_wyszukiwania_krotka_historia_wielkiego_sukcesu', 2, 3, 37, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(706, 'Zdalne sterowanie przez Internet', 'Przez Internet można zdalnie sterować nie tylko odległymi komputerami, ale też i systemami oświetlenia, ogrzewania, wentylacji, klimatyzacji czy maszynami produkcyjnymi.', 64, 67, 'zdalne_sterowanie_przez_internet', 2, 4, 37, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(707, 'Odgłosy sieci. Przegląd serwisów z dźwiękami na strony WWW', 'Jeszcze kilka lat temu na wielu amatorskich stronach WWW można było usłyszeć przygrywające w tle melodie w formacie MIDI. Dziś ich miejsce zajęły udźwiękowione animacje wykonane w technologii Flash oraz pliki MP3 i WAV. Dźwięk w sieci powraca do łask za sprawą coraz szybszych łączy, a wraz z nim liczne serwisy udostępniające darmowe pliki audio.', 68, 71, 'odglosy_sieci_przeglad_serwisow_z_dzwiekami_na_strony_www', 2, 17, 37, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(708, 'Usenetowa konkurencja. Przegląd programów do obsługi binarnych grup dyskusyjnych', 'Być może niewielu internautów pamięta jeszcze, że zanim powstały systemy wymiany plików P2P, rolę pośrednika w dystrybucji binariów sprawował Usenet. To właśnie za jego pośrednictwem internauci dzielili się swoimi zasobami, udostępniając i ściągając z sieci materiały w postaci programów, zdjęć, plików MP3 itp.', 72, 77, 'usenetowa_konkurencja_przeglad_programow_do_obslugi_binarnych_grup_dyskusyjnych', 10, 9, 37, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(709, 'Curl — nieodkryte możliwości', 'Czasy statycznych stron internetowych powoli dobiegają końca. Globalną sieć czeka mała rewolucja. Curl jest jedną z technologii, która ma w tym pomóc.', 82, 86, 'curl_nieodkryte_mozliwosci', 5, 24, 37, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(710, 'Profesjonalne wykresy na stronach WWW: biblioteka ChartDirector', 'Dobrze przygotowany wykres przekazuje więcej informacji niż wiele zdań tekstu. Kursy walut, statystyki odwiedzin serwisów, ceny produktów — -to tylko niektóre rodzaje wykresów, z jakimi spotykamy się niemal codziennie. Artykuł przedstawia obiektową bibliotekę ChartDirector. Wykorzystując zdefiniowane w niej klasy możemy łatwo wzbogacić serwis WWW o atrakcyjne wykresy.', 87, 91, 'profesjonalne_wykresy_na_stronach_www_biblioteka_chartdirector', 5, 11, 37, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(711, 'GIMP: tworzenie grafiki na potrzeby WWW (część 4)', '', 92, 97, 'gimp_tworzenie_grafiki_na_potrzeby_www_czesc_4', 5, 62, 37, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(712, 'webFAQ. Porady serwisu web.reporter.pl', '', 98, 99, 'webfaq_porady_serwisu_web_reporter_pl16', 5, 4, 37, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(713, 'Wakacje', 'Internet to nieocenione narzędzie do planowania i zakupu wypoczynku. Można przebierać i marudzić bez konieczności odwiedzania biura turystycznego, a przed pojęciem ostatecznej decyzji skorzystać z porad innych internautów. Najważniejsze są jednak oszczędności — -dzięki Internetowi w naszej kieszeni może pozostać równowartość nawet kilkudziesięciu procent ceny.', 22, 37, 'wakacje', 11, 74, 38, 16);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(714, 'Zakupy online: problemy z dostawą', 'W ciągu ostatnich kilku lat wzrosła konkurencja na polskim rynku handlu online. Rozwinęły się systemy płatności, poprawiła się jakość stron sklepowych. Wciąż jednak trudno zauważyć zmiany na lepsze w dostarczaniu zamówionych towarów do klientów.', 38, 41, 'zakupy_online_problemy_z_dostawa', 12, 34, 38, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(715, 'Bezpieczny WLAN', 'Bezprzewodowe sieci lokalne są bardzo wygodne w użyciu, ale podatne na próby włamania. Jak je zabezpieczyć?', 42, 43, 'bezpieczny_wlan', 12, 4, 38, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(716, 'Ewolucja modeli reklamy w wyszukiwarkach', 'Rynek reklamy w wyszukiwarkach uważany jest za najbardziej rozwojowy. Prognozy wskazują, że najszybszy przyrost wydatków na promocję będzie widoczny dla reklamy w wyszukiwarkach. Do gry włączyli się najwięksi gracze rynku IT.', 44, 46, 'ewolucja_modeli_reklamy_w_wyszukiwarkach', 12, 31, 38, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(717, 'Unia — nie bez szans', 'Integracja z Unią Europejską stwarza młodym ludziom nowe możliwości i tylko od nas zależy, czy zdołamy je wykorzystać. Nasze wstąpienie do UE wiąże się jednak z pewnymi ograniczeniami w dostępie do zachodnich rynków pracy. Zanim więc wyjedziecie w poszukiwaniu zatrudnienia, warto zapoznać się z informacjami na temat sytuacji w poszczególnych krajach.', 47, 49, 'unia_nie_bez_szans', 12, 57, 38, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(718, 'Elementarz Internetu. Część II: pierwsze kroki w wirtualnym świecie', 'W poprzednim, pierwszym odcinku Elementarza, poznaliśmy sposoby dostępu do Internetu, aktualne oferty providerów, ceny itd. Mamy nadzieję, że większości Czytelników po tamtej lekturze udało się wreszcie „wejść” do sieci. Pora więc zacząć z niej korzystać.', 50, 57, 'elementarz_internetu_czesc_ii_pierwsze_kroki_w_wirtualnym_swiecie', 2, 72, 38, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(719, 'Barometr Internetu: co nas kręci w sieci?', '', 58, 61, 'barometr_internetu_co_nas_kreci_w_sieci2', 2, 73, 38, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(720, 'Magia gier online', 'Miliony graczy prowadzących równocześnie przeciw sobie wirtualne armie ku nowym zwycięstwom i podbojom to rzeczywistość współczesnego świata gier online (zwanych również grami MMO, od angielskiego Massively Multiplayer Online). Ten dział gier przeżywa obecnie olbrzymi rozwój, stanowiący preludium do rewolucyjnych zmian, jakie nastąpią w najbliższym czasie w całej branży gier komputerowych.', 62, 63, 'magia_gier_online', 2, 75, 38, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(721, 'Cała prawda o dialerach, czyli kulisy „adult biznesu”', 'Media co pewien czas informują o użytkownikach Internetu spragnionych mocnych wrażeń, którzy bezwiednie łączą się z numerem 0-700, zwiększając w ten sposób swój rachunek telefoniczny o kilka zer. Ale istnieje też druga strefa osób wtajemniczonych, którzy przez ponad cztery lata działania dialerów zbijali majątek na niewiedzy tychże użytkowników.', 64, 68, 'cala_prawda_o_dialerach_czyli_kulisy_adult_biznesu', 2, 4, 38, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(722, 'O twórczości radosna!', '', 69, 69, 'o_tworczosci_radosna', 2, 37, 38, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(723, 'Minivademecum słuchacza radia internetowego', 'Można przypuszczać, że gdy w 1899 roku Guglielmo Marconi nawiązał łączność radiową przez kanał La Manche, zdawał już sobie sprawę z genialności swojego wynalazku. Od tego czasu radio zrewolucjonizowało życie na naszej planecie. Jednak Marconiemu z całą pewnością nie przyszło do głowy, że sto lat później Ziemia stanie się globalną wioską a rozgłośnie radiowe będą nadawać przez... Internet.', 70, 73, 'minivademecum_sluchacza_radia_internetowego', 2, 4, 38, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(724, 'Twój własny reality show, czyli jak umieścić w sieci transmisję z kamery', 'Kiedyś przełomem był telegram, potem telefon. Teraz mamy miniaturowe kamery internetowe, które umożliwiają kontakt głosowy i wzrokowy ze znajomymi znajdującymi się w dowolnym miejscu na świecie. Webkamerę możemy też wykorzystać w charakterze „trzeciego oka” i obserwować, co się dzieje w miejscu, w którym została zainstalowana. Potrzebny jest do tego jedynie dostęp do Internetu.', 74, 76, 'twoj_wlasny_reality_show_czyli_jak_umiescic_w_sieci_transmisje_z_kamery', 2, 4, 38, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(725, 'Zero zaufania. Czyli jak rozpoznać i bronić się przed oszustwami w Internecie', 'W zakamarkach Internetu czai się wiele niebezpieczeństw. Jednym z najpoważniejszych jest aktywność oszustów, którzy bardzo szybko przyswoili sobie mechanizmy funkcjonowania sieci.', 77, 79, 'zero_zaufania_czyli_jak_rozpoznac_i_bronic_sie_przed_oszustwami_w_internecie', 2, 39, 38, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(726, 'Strona dla amatora. Przegląd graficznych edytorów HTML', 'Wędrując po serwisach internetowych zapewne nieraz podziwialiśmy mistrzowski kunszt i twórcze umiejętności webmasterów. Tymczasem, aby opracować zgrabnie wyglądającą stronkę, wcale nie trzeba uczyć się od podstaw webmasterskiego rzemiosła. Czasem wystarczy do tego jedynie odpowiednia aplikacja.', 80, 85, 'strona_dla_amatora_przeglad_graficznych_edytorow_html', 10, 9, 38, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(727, 'GIMP: tworzenie grafiki na potrzeby WWW (część 5)', '', 88, 93, 'gimp_tworzenie_grafiki_na_potrzeby_www_czesc_5', 5, 62, 38, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(728, 'Aktualizacja kursów walut z poziomu PHP', 'Gdy potrzebujemy aktualnych kursów walut, możemy zajrzeć na przykład na stronę NBP, ale może warto postarać się, by nasza strona sama aktualizowała kursy walut...', 94, 98, 'aktualizacja_kursow_walut_z_poziomu_php', 5, 11, 38, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(729, 'SQLite (cz. 1)', 'SQLite to całkowicie samodzielna, kompaktowa baza danych. Szybka, wydajna, prosta w instalacji i bezpłatna. Czy możemy się jeszcze spodziewać rewolucji w technologii baz danych?', 99, 101, 'sqlite_cz_1', 5, 24, 38, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(730, 'Tworzenie aplikacji internetowych z wykorzystaniem szablonów', 'Szablony, nazywane również wzorcami, weszły do kanonu technik stosowanych przez twórców aplikacji internetowych. Główną korzyścią wynikającą z użycia szablonów jest oddzielenie kodu aplikacji od szaty graficznej. Ułatwia to zarówno zarządzanie kilkuosobowymi projektami, jak i przygotowywanie witryn WWW posiadających kilka różnych wyglądów. W pierwszym artykule o szablonach przeanalizujemy mechanizm działania prostego systemu szablonów.', 102, 105, 'tworzenie_aplikacji_internetowych_z_wykorzystaniem_szablonow', 5, 29, 38, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(731, 'webFAQ. Porady serwisu web.reporter.pl', '', 106, 107, 'webfaq_porady_serwisu_web_reporter_pl17', 5, 4, 38, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(732, 'Koniec fotografii analogowej? Przegląd aparatów cyfrowych', 'Przebój ostatnich lat — aparat cyfrowy powoli staje się standardem w amatorskich i profesjonalnych zastosowaniach. Natychmiastowy dostęp do zrobionego zdjęcia oraz możliwość zredukowania kosztów związanych z zakupem filmów i wykonaniem odbitek powoduje, że amatorzy bez skrupułów zamieniają klasyczne aparaty fotograficzne na coraz tańsze cyfrowe kompakty.', 24, 28, 'koniec_fotografii_analogowej_przeglad_aparatow_cyfrowych', 11, 76, 39, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(733, 'Niezbędnik cyfrowego fotografa', '', 28, 33, 'niezbednik_cyfrowego_fotografa', 11, 76, 39, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(734, 'Wygrani i przegrani w sieci', 'Nie tak dawno temu, jeszcze za czasów internetowego boomu, co chwila powstawały w sieci nowe przedsięwzięcia mające stanowić żyłę złota. Szybko okazało się, jak wiele z tych pomysłów było nietrafionych. Podobne historie zdarzają się po dziś dzień, a my sami bywamy często świadkami biznesowych sukcesów i porażek w polskim Internecie.', 34, 38, 'wygrani_i_przegrani_w_sieci', 12, 40, 39, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(735, 'Zwolnienie z podatku VAT, czyli socjotechnika polityków', 'Euforia — tak można by opisać komentarze na wielu forach internetowych. Komentarze dotyczyły zwolnienia z podatku VAT usługi dostępu do Internetu dla użytkowników indywidualnych. Czy to słuszna reakcja?', 40, 41, 'zwolnienie_z_podatku_vat_czyli_socjotechnika_politykow', 12, 77, 39, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(736, 'Jak sprzedać oprogramowanie w sieci', 'Poradnik dla niezależnych programistów i małych firm software’owych', 42, 48, 'jak_sprzedac_oprogramowanie_w_sieci', 12, 4, 39, 7);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(737, 'PrasóWWWka', 'Co mówi prawo o treściach umieszczanych na stronach WWW?', 49, 51, 'prasowwwka', 12, 16, 39, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(738, 'Elementarz Internetu. Część III: więcej o poczcie i WWW', 'W zeszłym miesiącu podaliśmy podstawowe informacje na temat funkcjonowania Internetu oraz omówiliśmy dwie najważniejsze aplikacje internetowe — przeglądarkę i klienta pocztowego. Ich opis był jednak dość pobieżny. W tym wydaniu Elementarza uzupełnimy brakującą wiedzę.', 52, 55, 'elementarz_internetu_czesc_iii_wiecej_o_poczcie_i_www', 2, 72, 39, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(739, 'Barometr Internetu: życzenia oraz świętowanie', '', 56, 59, 'barometr_internetu_zyczenia_oraz_swietowanie', 2, 73, 39, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(740, 'Edukacja na odległość', 'O zaletach edukacji na odległość zostało już powiedziane niemal wszystko: jest tania i skuteczna, na dodatek uczestnictwo w zajęciach nie wymaga uciążliwego dojeżdżania do szkoły czy na uczelnie. W USA niemal 90% uczelni oferuje różne formy edukacji przez Internet. W Polsce, wbrew zapowiedziom ekspertów, rynek e-learningu nie przeżywa jeszcze rozkwitu. Przyczyną jest wciąż wysoki koszt dostępu do Internetu oraz skromna oferta polskich szkół.', 60, 63, 'edukacja_na_odleglosc', 2, 25, 39, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(741, 'Wirtualna przechowalnia. Przegląd darmowych e-dysków', 'Praca nad jednym dokumentem pochłania cały nasz czas, zaległości często zabieramy ze sobą z pracy lub uczelni prosto do domu. Dodatkowo niektóre fragmenty wymagają ciągłej konsultacji z resztą zespołu. Jak poradzić sobie z koniecznością udostępniania oraz przenoszenia plików z miejsca na miejsce? Okazuje się, że najlepszym rozwiązaniem są e-dyski.', 64, 67, 'wirtualna_przechowalnia_przeglad_darmowych_e_dyskow', 2, 17, 39, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(742, 'Płatna ochrona antyspamowa w darmowych kontach pocztowych', 'Czy warto płacić za ochronę, jeśli istnieją równie skuteczne narzędzia bezpłatne?', 68, 71, 'platna_ochrona_antyspamowa_w_darmowych_kontach_pocztowych', 2, 17, 39, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(743, 'Internet na wynos', 'Od czasu wprowadzenia standardu Wi-Fi laptopy kupowane są najczęściej z myślą o bezprzewodowym korzystaniu z Internetu.', 72, 74, 'internet_na_wynos', 2, 4, 39, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(744, 'Martwy Internet', 'Istnieją obszary Internetu, które są zawsze aktualne, prezentują najświeższe informacje, omawiają ostatnie wydarzenia itd. Czy jednak dotyczy to wszystkich witryn?', 75, 77, 'martwy_internet', 2, 3, 39, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(745, 'Gigabajtowe konta w Google?', 'Primaaprilisowy żart w wykonaniu właścicieli Google się udał. Do dziś nikt do końca nie wie, czy pomysł uruchomienia serwisu pocztowego Gmail jest prawdą.', 78, 79, 'gigabajtowe_konta_w_google', 2, 3, 39, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(746, 'Usłyszeć obraz', 'Fakt, że komputery stają się pomocne, a wręcz niezbędne dla osób niepełnosprawnych, nie ulega wątpliwości. Na Zachodzie są dla nich oknem na świat, w Polsce niestety wciąż nie. Niepełnosprawni czują się pod tym względem dyskryminowani.', 80, 83, 'uslyszec_obraz', 2, 78, 39, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(747, 'Kopiowanie z turbodoładowaniem. Przegląd menedżerów downloadu', 'Z uwagi na różne przeszkody (przeciążone serwery, zatłoczone łącza) kopiowanie plików z jednego komputera na drugi za pomocą przeglądarek internetowych nie zawsze kończy się sukcesem. Dlatego wskazane jest, aby do tego typu operacji wykorzystywać specjalnie przystosowane oprogramowanie.', 84, 89, 'kopiowanie_z_turbodoladowaniem_przeglad_menedzerow_downloadu', 10, 9, 39, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(748, 'GIMP: tworzenie grafiki na potrzeby WWW (część 6)', '', 92, 95, 'gimp_tworzenie_grafiki_na_potrzeby_www_czesc_6', 5, 62, 39, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(749, 'Tworzenie aplikacji internetowych z wykorzystaniem szablonów (część 2)', '', 96, 101, 'tworzenie_aplikacji_internetowych_z_wykorzystaniem_szablonow_czesc_2', 5, 29, 39, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(750, 'webFAQ. Porady serwisu web.reporter.pl', '', 102, 103, 'webfaq_porady_serwisu_web_reporter_pl18', 5, 4, 39, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(751, 'SQLite (cz. 2)', '', 104, 108, 'sqlite_cz_2', 5, 24, 39, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(752, 'Którego listonosza wybrać?. Przegląd darmowych i komercyjnych kont pocztowych', 'Mało kto wie, czym różnią się oferty różnych dostawców poczty. Przyjrzeliśmy się bliżej zarówno darmowym, jak komercyjnym kontom e-mail oraz działaniu szeregu dodatkowych opcji uruchamianych zwykle wraz ze skrzynką pocztową.', 30, 43, 'ktorego_listonosza_wybrac_przeglad_darmowych_i_komercyjnych_kont_pocztowych', 11, 79, 40, 14);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(753, 'Firmowo-prywatna poczta. Kontrolowanie poczty korporacyjnej', '', 44, 45, 'firmowo_prywatna_poczta_kontrolowanie_poczty_korporacyjnej', 11, 79, 40, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(754, 'Kurs tworzenia sklepu internetowego (cz. 1)', 'Mimo zachęcających perspektyw wiele osób rezygnuje z internetowego biznesu, zrażonych rzekomymi ogromnymi trudnościami z opracowaniem i wdrożeniem odpowiedniego serwisu WWW, płatności online itp. Tymczasem akurat ten etap e-biznesu wcale nie jest trudny, co zamierzamy udowodnić niniejszym cyklem artykułów.', 46, 49, 'kurs_tworzenia_sklepu_internetowego_cz_1', 12, 4, 40, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(755, 'Zrób interes w sieci. Pierwszy krok w e-biznes', '', 50, 52, 'zrob_interes_w_sieci_pierwszy_krok_w_e_biznes', 12, 4, 40, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(756, 'Do sądu z nimi!', '', 53, 53, 'do_sadu_z_nimi', 2, 37, 40, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(757, 'Wirtualna Polska — kulisy upadłości', 'Wirtualna Polska od początku kwietnia jest w stanie upadłości. Wszystkiemu winien trwający od wielu miesięcy konflikt akcjonariuszy Wirtualnej Polski, który w ostatnich miesiącach gwałtownie przybrał na sile.', 54, 58, 'wirtualna_polska_kulisy_upadlosci', 2, 80, 40, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(758, 'Flash Mob — happening nowej generacji', 'Flash Mob można przetłumaczyć jako „błyskawiczny tłum”. Polega to na tym, że w określonym miejscu i czasie spotyka się grupa ludzi, aby przeprowadzić krótką, przygotowaną wcześniej akcję, zazwyczaj absurdalną...', 59, 61, 'flash_mob_happening_nowej_generacji', 2, 75, 40, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(759, 'BIP: kosztowne żarty z obywatela', 'Urzędy wszystkich szczebli nagminnie łamią prawo i pozbawiają nas prawa do informacji o tym, co dzieje się za zamkniętymi drzwiami administracji. Najgorzej dzieje się w Internecie.', 62, 63, 'bip_kosztowne_zarty_z_obywatela', 2, 81, 40, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(760, 'Strona WWW za niewielkie pieniądze', 'Czy w dobie upowszechniania się Internetu tworzenie stron WWW ciągle musi być ekskluzywną usługąś Czy za dobrą witrynę trzeba dużo płacićś Ten artykuł udowodni, że wszystko można mieć za darmo lub za całkiem niewielkie pieniądze...', 64, 65, 'strona_www_za_niewielkie_pieniadze', 2, 36, 40, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(761, 'Wirtualni szpiedzy', 'Jak wynika z badań przeprowadzonych ostatnio przez amerykańskiego dostawcę internetowego Earthlink, na ok. 90% komputerów podłączonych do sieci można znaleść programy, których użytkownicy nie instalowali. Skąd się tam wzięły i czemu służąś', 66, 69, 'wirtualni_szpiedzy', 2, 39, 40, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(762, 'Ile zarabia internauta?', '', 70, 71, 'ile_zarabia_internauta', 2, 57, 40, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(763, 'Barometr Internetu: co nas kręci w sieci?', '', 72, 75, 'barometr_internetu_co_nas_kreci_w_sieci3', 2, 73, 40, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(764, 'Elementarz Internetu: FTP i Usenet', 'W poprzednim odcinku uzupełniliśmy wiadomości na temat poczty elektronicznej i przeglądarki WWW. Pora opisać kolejne podstawowe usługi internetowe — FTP i Usenet (grupy dyskusyjne).', 76, 81, 'elementarz_internetu_ftp_i_usenet', 2, 72, 40, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(765, 'Internet ocenzurowany', 'Przegląd programów do kontroli rodzicielskiej', 82, 87, 'internet_ocenzurowany', 10, 9, 40, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(766, 'PHP-GTK — inne spojrzenie na język PHP', 'Wiele osób z pewnością uważa, że PHP to język przystosowany wyłącznie do tworzenia aplikacji internetowych działających tylko po stronie serwera WWW. Rzadko mówi się o jego zastosowaniu przy programowaniu złożonych aplikacji klienckich. A tak naprawdę za wszystko odpowiedzialna jest biblioteka PHP-GTK, która umożliwia tworzenie aplikacji okienkowych za pomocą składni języka PHP.', 90, 93, 'php_gtk_inne_spojrzenie_na_jezyk_php', 5, 11, 40, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(767, 'Tworzenie aplikacji internetowych z wykorzystaniem szablonów (część 3)', '', 94, 97, 'tworzenie_aplikacji_internetowych_z_wykorzystaniem_szablonow_czesc_3', 5, 29, 40, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(768, 'webFAQ. Porady serwisu web.reporter.pl', '', 98, 99, 'webfaq_porady_serwisu_web_reporter_pl19', 5, 4, 40, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(769, 'Wielkie granie', 'Wraz z upowszechnianiem szerokopasmowego dostępu do Internetu wirtualne pojedynki staną się na dobre częścią kultury, a coraz bardziej realistyczne gry zaczną powoli zastępować tradycyjne rozrywki. Przyszłość z pewnością należy do wirtualnych tworów, a ich wpływ również na życie w świecie realnym staje się coraz większy. Różnice pomiędzy dwoma światami powoli zaczynają się zacierać...', 30, 31, 'wielkie_granie', 11, 82, 41, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(770, 'Tryb wieloosobowy w grach komputerowych', '', 32, 35, 'tryb_wieloosobowy_w_grach_komputerowych', 11, 82, 41, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(771, 'Portalowe gierki', '', 35, 36, 'portalowe_gierki', 11, 82, 41, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(772, 'Mobilna rozrywka. Multimedialne granie na komórkach', '', 36, 38, 'mobilna_rozrywka_multimedialne_granie_na_komorkach', 11, 82, 41, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(773, 'Gry MMORPG. Życie w wirtualnym świecie', '', 39, 41, 'gry_mmorpg_zycie_w_wirtualnym_swiecie', 11, 82, 41, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(774, 'Płatne serwisy o grach komputerowych', '', 42, 43, 'platne_serwisy_o_grach_komputerowych', 11, 82, 41, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(775, 'Polacy na podbój Europy. Zagraniczne ekspansje Allegro i NetSprinta', '', 44, 45, 'polacy_na_podboj_europy_zagraniczne_ekspansje_allegro_i_netsprinta', 12, 71, 41, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(776, 'Faks przez Internet', 'Aby w dzisiejszych czasach skutecznie konkurować z nowymi technologiami, komunikacja faksowa musiała zaoferować dodatkową funkcjonalność i niższe koszty transmisji.', 46, 50, 'faks_przez_internet', 12, 4, 41, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(777, 'Oddajcie mi e-maila!', '', 51, 51, 'oddajcie_mi_e_maila', 2, 37, 41, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(778, 'Kurs tworzenia sklepu internetowego. Część 2: początek wdrożenia', 'W tym i kolejnych rozdziałach kursu przedstawiamy przykłady konkretnych wdrożeń, które zostały zrealizowane w polskim Internecie.', 52, 55, 'kurs_tworzenia_sklepu_internetowego_czesc_2_poczatek_wdrozenia', 12, 4, 41, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(779, 'Odpowiedzialność w sieci', 'Czy dostawca usług internetowych ma obowiązek monitorować wszystkie informacje udostępniane przez internautów na jego serwerach? Kto odpowiada za wady oprogramowania komputerowego? Jaki jest stosunek prawa do plagi przejmowania zdalnej kontroli nad komputerami użytkowników?', 56, 59, 'odpowiedzialnosc_w_sieci', 12, 16, 41, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(780, 'Barometr Internetu: co nas kręci w sieci?', '', 60, 63, 'barometr_internetu_co_nas_kreci_w_sieci4', 2, 73, 41, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(781, 'Kupię, sprzedam, zamienię', 'Porady dla użytkowników aukcji internetowych', 64, 68, 'kupie_sprzedam_zamienie', 2, 4, 41, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(782, 'Konta shellowe. Krótki poradnik dla niewtajemniczonych', 'W środowiskach ircmaniaków usługa ta znana jest od zawsze, jednak większość internautów jej nie zna. A szkoda.', 69, 71, 'konta_shellowe_krotki_poradnik_dla_niewtajemniczonych', 2, 4, 41, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(783, 'Problemy z domeną', 'Jak korzystać z systemu DNS? Jakie kryją się w tym pułapki?', 72, 73, 'problemy_z_domena', 2, 4, 41, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(784, 'Książki dla cierpliwych. Losy Polskiej Biblioteki Internetowej', '', 74, 75, 'ksiazki_dla_cierpliwych_losy_polskiej_biblioteki_internetowej', 2, 36, 41, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(785, 'Personalizacja dziś i jutro. Czy ambitna wizja całkowitej personalizacji Internetu jest nadal aktualna?', 'Internet skrojony na miarę: informacje w portalach wyświetlane według indywidualnych preferencji, reklamy dobierane na podstawie najbardziej szczegółowych obserwacji pojedynczych internautów. Gdyby wierzyć przepowiedniom, tak właśnie Internet miał wyglądać już dziś. O tym, że nie wygląda, nie trzeba nikogo przekonywać...', 76, 77, 'personalizacja_dzis_i_jutro_czy_ambitna_wizja_calkowitej_personalizacji_internetu_jest_nadal_aktualna', 2, 5, 41, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(786, 'Elementarz Internetu. Część V: pogadajmy sobie trochę.', 'W tym odcinku Elementarza przedstawiamy usługi internetowe, które umożliwiają internautom komunikację w czasie rzeczywistym. Do tej grupy usług zalicza się IRC i wszelkiego rodzaju komunikatory. W przeciwieństwie do e-maila, w którym wiadomości oczekują nieraz bardzo długo na odpowiedź, wymienione usługi umożliwiają w pełni interaktywną, natychmiastową komunikację na żywo, przy czym w takich rozmowach może uczestniczyć dowolnie dużo ludzi.', 78, 82, 'elementarz_internetu_czesc_v_pogadajmy_sobie_troche', 2, 72, 41, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(787, 'Przyjemne z pożytecznym. Toolbary dla Internet Explorera', 'W Internecie można znaleźć wiele dodatków, które rozszerzają funkcjonalność Internet Explorera. Ostatnio dużą popularnością cieszą się programy ułatwiające pracę z konkretną witryną internetową, a zwłaszcza z wyszukiwarką lub portalem.', 83, 85, 'przyjemne_z_pozytecznym_toolbary_dla_internet_explorera', 2, 17, 41, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(788, 'Sprawne zarządzanie na odległość, czyli przegląd klientów FTP', 'Eksplorator Windows, choć jest niezłym menedżerem plików, nie daje dostępu do dysków odległych serwerów. Chcąc sprawnie zarządzać plikami czy katalogami na odległość, trzeba wyposażyć komputer w specjalny program — -klienta FTP.', 86, 91, 'sprawne_zarzadzanie_na_odleglosc_czyli_przeglad_klientow_ftp', 10, 9, 41, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(789, 'Uniwersalne komunitatory', '', 94, 96, 'uniwersalne_komunitatory', 10, 8, 41, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(790, 'Tworzenie aplikacji internetowych z wykorzystaniem szablonów (część 4)', '', 97, 101, 'tworzenie_aplikacji_internetowych_z_wykorzystaniem_szablonow_czesc_4', 5, 29, 41, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(791, 'HTML — -język znaczników. Vademecum dla początkujących', '', 102, 107, 'html_jezyk_znacznikow_vademecum_dla_poczatkujacych', 5, 83, 41, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(792, 'webFAQ. Porady serwisu web.reporter.pl', '', 108, 109, 'webfaq_porady_serwisu_web_reporter_pl20', 5, 4, 41, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(793, 'Poradnik webmastera. Jak tworzyć dobre serwisy', 'Dobry webmaster musi posiadać zdolności graficzne, znać się na kodowaniu stron oraz wykazywać znajomości analityczne przy tworzeniu projektu serwisu. Przedstawiamy zestaw porad, które pomogą wielu Czytelnikom rozpocząć przygodę z tworzeniem serwisów internetowych.', 28, 30, 'poradnik_webmastera_jak_tworzyc_dobre_serwisy', 11, 84, 42, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(794, 'Przegląd stron internetowych. Serwisy dla webmasterów i webdesignerów', '', 32, 37, 'przeglad_stron_internetowych_serwisy_dla_webmasterow_i_webdesignerow', 11, 84, 42, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(795, 'E-patenty: koniec wolnej konkurencji? Niedoskonałe prawo sprzyja monopolistom i spryciarzom', 'Propozycja opatentowania oprogramowania komputerowego wywołuje w środowisku informatyków wiele wątpliwości. W działania zmierzające do odrzucenia możliwości uzyskiwania patentów na programy włączyły się aktywnie rzesze internautów. Czy patenty związane z szeroko pojętą informatyką mogą stanowić zagrożenie dla dalszego funkcjonowania Internetu?', 38, 41, 'e_patenty_koniec_wolnej_konkurencji_niedoskonale_prawo_sprzyja_monopolistom_i_spryciarzom', 12, 16, 42, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(796, 'Kurs tworzenia sklepu internetowego. Część 3: szablony', 'W tym odcinku zajmiemy się omówieniem budowy najważniejszych szablonów, którymi są: szablon strony głównej, karta produktu, szablony wyszukiwarek, szablon zakładania konta i koszyk.', 42, 45, 'kurs_tworzenia_sklepu_internetowego_czesc_3_szablony', 12, 4, 42, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(797, 'Pay Per Click. Pierwszy boks reklamowy w Polsce', '', 46, 47, 'pay_per_click_pierwszy_boks_reklamowy_w_polsce', 12, 31, 42, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(798, 'Internauta na celowniku. Zachowania użytkowników wyszukiwarek internetowych', 'Przy coraz większym zainteresowaniu branży marketingowej wyszukiwarkami internetowymi zadziwiający jest fakt przeprowadzenia małej ilości badań nad zachowaniami użytkowników. Powoli się to zmienia. Światło dzienne ujrzały dwa raporty z interesującymi wnioskami z niezależnie przeprowadzonych badań.', 48, 50, 'internauta_na_celowniku_zachowania_uzytkownikow_wyszukiwarek_internetowych', 12, 31, 42, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(799, 'Elementarz Internetu. Część 6: telefonia internetowa i wideokonferencje', 'W poprzednim odcinku omówione zostały usługi internetowe umożliwiające komunikację w czasie rzeczywistym: IRC i komunikatory. Ale czy jedynym sposobem komunikacji jest dość niewygodne wpisywanie tekstu z klawiatury? Oczywiście, że nie...', 51, 55, 'elementarz_internetu_czesc_6_telefonia_internetowa_i_wideokonferencje', 2, 72, 42, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(800, 'Absolutnie najtańsze zakupy!. Jak zaoszczędzić 50% ceny a nawet więcej!', 'Po raz kolejny Internet pokazuje, jak bardzo może ułatwić nam życie i dać wymierne korzyści w postaci oszczędności przy dokonywaniu zakupów. I nie chodzi tu o jakieś marne pięcio- czy dziesięcioprocentowe upusty, lecz o naprawdę poważne oszczędności sięgające nawet 80% ceny produktu.', 56, 59, 'absolutnie_najtansze_zakupy_jak_zaoszczedzic_50_ceny_a_nawet_wiecej', 2, 4, 42, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(801, 'Barometr Internetu: co nas kręci w sieci?', '', 60, 63, 'barometr_internetu_co_nas_kreci_w_sieci5', 2, 73, 42, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(802, 'Domena twoją wizytówką', 'Kiedyś własna domena była luksusem, dziś dla prawie każdej firmy jest koniecznością. Coraz więcej osób prywatnych rejestruje własne domeny. Domena staje się dobrem powszechnym.', 64, 67, 'domena_twoja_wizytowka', 2, 4, 42, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(803, 'Firewall niestraszny. Zdalne sterowanie przez pocztę elektroniczną', 'W artykule zaprezentowano proste rozwiązanie zdalnego sterowania oparte na darmowym koncie pocztowym i bezpłatnym programie PopTray. Ilustrowany poradnik krok po kroku pokazuje, jak uruchomić swój pierwszy „system zdalnego sterowania”.', 68, 69, 'firewall_niestraszny_zdalne_sterowanie_przez_poczte_elektroniczna', 2, 4, 42, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(804, 'Kasyna w Internecie. Wirtualne szpony hazardu oplatają cały świat', 'Dzięki cyberkasynom można oddawać się ulubionej grze w zaciszu własnego mieszkania. Wystarczy włączyć komputer, wejść do Internetu i wybrać kasyno. A gdy już znudzi się aktualne miejsce gry, możemy je w każdej chwili zmienić.', 70, 72, 'kasyna_w_internecie_wirtualne_szpony_hazardu_oplataja_caly_swiat', 2, 3, 42, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(805, 'RSS: świeżutkie aktualności prosto na pulpit', 'Zazwyczaj, gdy chcemy zapoznać się z aktualnościami, przeglądamy co najmniej kilka stron WWW (jakiś portal, strony specjalistyczne), niekiedy więcej. Pochłania to sporo czasu i jest niewygodne. Problem rozwiązuje standard RSS, dzięki któremu możemy otrzymywać w jednym miejscu indywidualnie dobrane wiadomości z wielu źródeł, natychmiast po ich opublikowaniu w sieci.', 73, 75, 'rss_swiezutkie_aktualnosci_prosto_na_pulpit', 2, 24, 42, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(806, 'Zadbaj o swoją prywatność. Przegląd programów do maskowania połączeń', 'W czasie internetowych sesji przeglądarka pozostawia po sobie w sieci mnóstwo śladów, które mogą demaskować nie tylko techniczne zaplecze naszego komputera, ale i upodobania wyrażane poprzez tematykę odwiedzanych stron. Aby „uszczelnić” komputer i zapobiec przeciekom prywatnych informacji, warto rozważyć zakup programu, który zamaskuje naszą sieciową aktywność.', 76, 81, 'zadbaj_o_swoja_prywatnosc_przeglad_programow_do_maskowania_polaczen', 10, 9, 42, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(807, 'ADOdb kluczem do każdej bazy danych', '', 84, 89, 'adodb_kluczem_do_kazdej_bazy_danych', 5, 24, 42, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(808, 'HTML — aplikacja języka SGML', '', 90, 95, 'html_aplikacja_jezyka_sgml', 5, 83, 42, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(809, 'Statystyki odwiedziń witryny WWW', '', 96, 100, 'statystyki_odwiedzin_witryny_www', 5, 12, 42, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(810, 'Internetowe fotolaby', '', 30, 34, 'internetowe_fotolaby2', 11, 85, 43, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(811, 'Fotolab offline. Miniprzegląd drukarek drukujących bezpośrednio z aparatu cyfrowego lub kart pamięci', '', 35, 37, 'fotolab_offline_miniprzeglad_drukarek_drukujacych_bezposrednio_z_aparatu_cyfrowego_lub_kart_pamieci', 11, 85, 43, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(812, 'Darmowe statystyki dla serwisów WWW', '', 38, 40, 'darmowe_statystyki_dla_serwisow_www', 12, 17, 43, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(813, 'Kurs tworzenia sklepu internetowego. Część 4: dodatkowe elementy szablonów', '', 42, 45, 'kurs_tworzenia_sklepu_internetowego_czesc_4_dodatkowe_elementy_szablonow', 12, 4, 43, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(814, 'WLAN pod paragrafem. Kiedy trzeba zgłosić działaność telekomunikacyjną do URTiP?', '', 46, 48, 'wlan_pod_paragrafem_kiedy_trzeba_zglosic_dzialanosc_telekomunikacyjna_do_urtip', 12, 4, 43, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(815, 'Sklepy internetowe od zaplecza', '', 49, 51, 'sklepy_internetowe_od_zaplecza', 12, 34, 43, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(816, 'Jestem tu incognito! Podstawy zachowania anonimowości i prywatności w Internecie', '', 52, 56, 'jestem_tu_incognito_podstawy_zachowania_anonimowosci_i_prywatnosci_w_internecie', 2, 4, 43, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(817, 'Dlaczego warto używać proxy?', '', 57, 59, 'dlaczego_warto_uzywac_proxy', 2, 4, 43, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(818, 'Nie trać czasu! Jak efektywnie serfować po Internecie?', '', 60, 63, 'nie_trac_czasu_jak_efektywnie_serfowac_po_internecie', 2, 4, 43, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(819, 'Zarządzanie domeną', '', 64, 65, 'zarzadzanie_domena', 2, 4, 43, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(820, 'WP: Jest lepiej ale wciąż nerwowo', '', 66, 68, 'wp_jest_lepiej_ale_wciaz_nerwowo', 2, 80, 43, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(821, 'Pasje w Internecie', '', 70, 71, 'pasje_w_internecie', 2, 26, 43, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(822, 'AdSense — zarabiaj z Google', '', 72, 73, 'adsense_zarabiaj_z_google', 2, 40, 43, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(823, 'XML internetowa unifikacja', '', 74, 77, 'xml_internetowa_unifikacja', 2, 24, 43, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(824, 'Barometr Internetu: półrocze w sieci', '', 78, 81, 'barometr_internetu_polrocze_w_sieci', 2, 73, 43, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(825, 'Elementarz Internetu. Część 7: internetowe radio i telewizja', '', 82, 87, 'elementarz_internetu_czesc_7_internetowe_radio_i_telewizja', 2, 72, 43, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(826, 'Stylowo i komfortowo. Przegląd edytorów CSS', '', 88, 91, 'stylowo_i_komfortowo_przeglad_edytorow_css', 10, 9, 43, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(827, 'Autoryzacja HTTP', '', 94, 98, 'autoryzacja_http', 5, 39, 43, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(828, 'Sposób na wyszukiwarki internetowe, czyli biblioteka libcurl w praktyce', '', 99, 101, 'sposob_na_wyszukiwarki_internetowe_czyli_biblioteka_libcurl_w_praktyce', 5, 11, 43, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(829, 'Co nowego w PHP5?', '', 102, 107, 'co_nowego_w_php5', 5, 11, 43, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(830, 'webFAQ. Porady serwisu web.reporter.pl', '', 108, 109, 'webfaq_porady_serwisu_web_reporter_pl21', 5, 4, 43, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(831, 'Hosting, serwery dedykowane i kolokacja. Przegląd usług hostingowych 2004', 'Strona internetowa nie może istnieć bez serwera WWW. Najpopularniejszym sposobem serwowania serwisów są usługi hostingowe. Prezentujemy najważniejsze zmiany w branży hostingowej w ostatnim roku oraz najbardziej godnych uwagi dostawców.', 32, 39, 'hosting_serwery_dedykowane_i_kolokacja_przeglad_uslug_hostingowych_2004', 11, 86, 44, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(832, 'Kolokacja i serwery dedykowane', '', 40, 43, 'kolokacja_i_serwery_dedykowane2', 11, 86, 44, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(833, 'Jedno kliknięcie od „do widzenia”, czyli o funkcjonalności stron internetowych', 'W Internecie wystarczy jedno kliknięcie, aby znaleźć się w całkowicie innym miejscu. Serwis internetowy musi więc być maksymalnie funkcjonalny, w przeciwnym razie odwiedzający szybko powie mu „do widzenia”.', 44, 47, 'jedno_klikniecie_od_do_widzenia_czyli_o_funkcjonalnosci_stron_internetowych', 12, 4, 44, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(834, 'Pożegnanie z banerem', '', 48, 49, 'pozegnanie_z_banerem', 12, 31, 44, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(835, 'Pytania bez odpowiedzi, czyli jak polskie firmy nie wykorzystują e-maila', 'Często słyszy się opinie, że e-mail jest bardzo tanim i skutecznym narzędziem dialogu pomiędzy firmą a jej potencjalnymi klientami. Postanowiliśmy sprawdzić, jak firmy działające w Polsce prowadzą ów dialog.', 50, 53, 'pytania_bez_odpowiedzi_czyli_jak_polskie_firmy_nie_wykorzystuja_e_maila', 12, 71, 44, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(836, 'Kurs tworzenia sklepu internetowego. Część 5: Po wdrożeniu', '', 54, 55, 'kurs_tworzenia_sklepu_internetowego_czesc_5_po_wdrozeniu', 12, 4, 44, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(837, 'Twoje konto w zasięgu myszki. Bank WWW w domu', 'Banki internetowe cieszą się coraz większą popularnością. Klienci doceniają wygodę, szybkość obsługi, dostępność banku z każdego miejsca. Nie ruszając się sprzed komputera można m.in. dokonać przelewu, sprawdzić saldo rachunku, a nawet zainwestować gotówkę. Do tego usługi są najczęściej tańsze niż w tradycyjnym banku.', 56, 58, 'twoje_konto_w_zasiegu_myszki_bank_www_w_domu', 2, 17, 44, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(838, 'Internet, radio i prawa autorskie. Które z powyższych nie pasuje do reszty?', '', 59, 61, 'internet_radio_i_prawa_autorskie_ktore_z_powyzszych_nie_pasuje_do_reszty', 2, 3, 44, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(839, 'grono.net. Internetowa społeczność przyjaciół', 'Elita w Internecie? A jednak. Internet ma swój elitarny krąg — -grono.net (http://www.grono.net). I jak przystało na elitę, można tam wejść tylko na zaproszenie.', 62, 64, 'grono_net_internetowa_spolecznosc_przyjaciol', 2, 3, 44, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(840, 'Wirtualne organizery', 'Rośnie popyt na narzędzia, które pozwalają zapanować nad zamętem dnia codziennego. Jednym z popularnych rozwiązań tego typu są programy zarządzające informacją osobistą. Wśród nich coraz większym powodzeniem cieszą się aplikacje działające w Internecie.', 65, 67, 'wirtualne_organizery', 2, 26, 44, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(841, 'Barometr Internetu: koniec wakacji', '', 68, 71, 'barometr_internetu_koniec_wakacji', 2, 73, 44, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(842, 'Elementarz Internetu. Część 8: uroki P2P', '', 72, 78, 'elementarz_internetu_czesc_8_uroki_p2p', 2, 72, 44, 7);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(843, 'Agregatory wiadomości. Przegląd programów do obsługi kanałów CSS', '', 80, 85, 'agregatory_wiadomosci_przeglad_programow_do_obslugi_kanalow_css', 10, 9, 44, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(844, 'CSS w praktyce: struktura strony. Style zamiast tabeli', 'Arkusze stylów CSS są obecnie nieodzownym elementem prawie każdej strony WWW. Ułatwiają tworzenie kodu, pozwalają uzyskać oryginalne efekty, dają lepszą kontrolę nad całością projektu i przyspieszają ładowanie stron.', 88, 89, 'css_w_praktyce_struktura_strony_style_zamiast_tabeli', 5, 12, 44, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(845, 'Praktyczne rozwiązania na stronę WWW. Przyjazne adresy URL', 'Dobre odnośniki to takie, które podobają się zarówno użytkownikom, jak i wyszukiwarkom. Najlepsze są te, które łatwo zapisać, zapamiętać i przeczytać. W świecie, gdzie o popularności witryn decyduje pozycja w wynikach wyszukiwania, największe znaczenie mają jednak URL-e przyjazne automatom indeksującym.', 90, 95, 'praktyczne_rozwiazania_na_strone_www_przyjazne_adresy_url', 5, 12, 44, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(846, 'HTML — ćwiczenia z tekstem', 'Po teoretycznym opisie języka HTML (MI 7 i 8/04) pora na ćwiczenia praktyczne. Przedstawiona seria ćwiczeń pomaga w opanowaniu języka HTML w stopniu wystarczającym do tworzenia dokumentów składających się z tekstów.', 96, 101, 'html_cwiczenia_z_tekstem', 5, 83, 44, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(847, 'Co nowego w PHP5? (cz. 2)', 'Obsługa XML. W pierwszej części artykułu zagłębialiśmy się w nowe, obiektowe możliwości silnika PHP5. Ten odcinek wprowadzenia do PHP5 poświęcimy w części dokończeniu kwestii silnika Zend Engine 2, a w części nowym, interesującym możliwościom obsługi XML poprzez PHP5.', 102, 107, 'co_nowego_w_php5_cz_2', 5, 11, 44, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(848, 'Zakupy w sieci', '', 32, 34, 'zakupy_w_sieci2', 11, 34, 45, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(849, 'Tu klient jest królem', '', 35, 37, 'tu_klient_jest_krolem', 11, 34, 45, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(850, 'Alternatywa dla hipermarketu', '', 38, 41, 'alternatywa_dla_hipermarketu', 11, 34, 45, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(851, 'Wybór i ocena słów kluczowych a marketingu internetowym', '', 42, 44, 'wybor_i_ocena_slow_kluczowych_a_marketingu_internetowym', 12, 31, 45, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(852, 'Na rynku pozostanie kilku silnych graczy', 'Rozmowa z Krzysztofem Szyszką, prezesem firmy Ogicom.', 45, 45, 'na_rynku_pozostanie_kilku_silnych_graczy', 12, 6, 45, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(853, 'Internet najtańczym medium reklamowym?', 'Rozmowa z Jakubem Żelichowskim, dyrektorem artystycznym Studia Kreacji Internetowej 3card.net z Krakowa.', 46, 47, 'internet_najtanczym_medium_reklamowym', 12, 6, 45, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(854, 'Internet ma się dobrze', '', 48, 49, 'internet_ma_sie_dobrze', 12, 71, 45, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(855, 'Darmowe aliasy pocztowe', '', 50, 51, 'darmowe_aliasy_pocztowe', 2, 17, 45, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(856, 'Wirtualne testowanie. Jak sprawdzić w Internecie bezpieczeństwo komputera?', '', 52, 56, 'wirtualne_testowanie_jak_sprawdzic_w_internecie_bezpieczenstwo_komputera', 2, 17, 45, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(857, 'Kasa dla piszących, czyli co ma do zaoferowania serwis ZłoteMyśli.pl?', '', 60, 62, 'kasa_dla_piszacych_czyli_co_ma_do_zaoferowania_serwis_zlotemysli_pl', 2, 4, 45, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(858, 'Gotówka z Internetu. Programy partnerskie, w których naprawdę można zarobić', '', 64, 67, 'gotowka_z_internetu_programy_partnerskie_w_ktorych_naprawde_mozna_zarobic', 2, 4, 45, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(859, 'Gry online. Arena Albionu, rycerska epopeja', '', 68, 69, 'gry_online_arena_albionu_rycerska_epopeja', 2, 75, 45, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(860, 'Ars electronica 2004. Festiwal sztuki nowej generacji. Relacja własna z Linzu', '', 70, 73, 'ars_electronica_2004_festiwal_sztuki_nowej_generacji_relacja_wlasna_z_linzu', 2, 41, 45, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(861, 'Elementarz Internetu. Część 9: stronę WWW każdy może mieć', '', 74, 81, 'elementarz_internetu_czesc_9_strone_www_kazdy_moze_miec', 2, 72, 45, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(862, 'Barometr Internetu', '', 82, 85, 'barometr_internetu', 2, 73, 45, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(863, 'Pod osłoną zapory ogniowej. Przegląd programowych firewalli', '', 86, 91, 'pod_oslona_zapory_ogniowej_przeglad_programowych_firewalli', 10, 9, 45, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(864, 'Bezpieczniejszy Windows XP? Nowości w dodatku Service Pack 2', '', 92, 93, 'bezpieczniejszy_windows_xp_nowosci_w_dodatku_service_pack_2', 10, 38, 45, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(865, 'Upload plików z dopalaczem', '', 96, 99, 'upload_plikow_z_dopalaczem', 5, 12, 45, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(866, 'Co nowego w PHP5? (cz. 3) Bazy danych', '', 100, 105, 'co_nowego_w_php5_cz_3_bazy_danych', 5, 11, 45, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(867, 'HTML — hiperłącza', '', 106, 109, 'html_hiperlacza', 5, 83, 45, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(868, 'webFAQ. Porady serwisu web.reporter.pl', '', 110, 111, 'webfaq_porady_serwisu_web_reporter_pl22', 5, 4, 45, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(869, 'Rutowanie podstawą Internetu. Zasada działania rutera', '', 32, 38, 'rutowanie_podstawa_internetu_zasada_dzialania_rutera', 11, 87, 46, 7);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(870, 'Jak podzielić Neostradę w sieci lokalnej?', '', 38, 41, 'jak_podzielic_neostrade_w_sieci_lokalnej', 11, 87, 46, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(871, 'Koniec spaghetti, czyli oddzielenie struktury od prezentacji', '', 42, 44, 'koniec_spaghetti_czyli_oddzielenie_struktury_od_prezentacji', 12, 4, 46, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(872, 'Onet jak Google? Nowy model rozliczeń reklamy w wyszukiwarce Onetu', '', 46, 48, 'onet_jak_google_nowy_model_rozliczen_reklamy_w_wyszukiwarce_onetu', 12, 31, 46, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(873, 'HotSpot. Internet za rogiem', '', 50, 51, 'hotspot_internet_za_rogiem', 12, 71, 46, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(874, 'Złapani w sieć Pajączka', 'Wywiad z Rafałem Płatkiem, twórcą popularnego edytora stron WWW o nazwie Pajączek', 52, 53, 'zlapani_w_siec_pajaczka', 12, 6, 46, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(875, 'Konta dla fotografów', '', 54, 58, 'konta_dla_fotografow', 2, 17, 46, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(876, 'VLOGI. Nowy wymiar blogowania', '', 60, 61, 'vlogi_nowy_wymiar_blogowania', 2, 5, 46, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(877, 'Zakłady bukmacherskie w Internecie', '', 62, 65, 'zaklady_bukmacherskie_w_internecie', 2, 26, 46, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(878, 'Doktor Elektron w akcji. Jak za pomocą Internetu zadbać o swoje zdrowie?', '', 66, 69, 'doktor_elektron_w_akcji_jak_za_pomoca_internetu_zadbac_o_swoje_zdrowie', 2, 26, 46, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(879, 'Barometr Internetu', '', 70, 73, 'barometr_internetu2', 2, 73, 46, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(880, 'Gry online. Dylematy Mieszka I, czyli jak wyżywić kmieci w księstwie Polan', '', 76, 77, 'gry_online_dylematy_mieszka_i_czyli_jak_wyzywic_kmieci_w_ksiestwie_polan', 2, 75, 46, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(881, 'Bezpieczeństwo sieci bezprzewodowych', '', 78, 79, 'bezpieczenstwo_sieci_bezprzewodowych', 2, 39, 46, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(882, 'Backup na czas. Archiwizacja danych w programie Outlook Express.', '', 80, 83, 'backup_na_czas_archiwizacja_danych_w_programie_outlook_express', 2, 4, 46, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(883, 'Elementarz Internetu. Część 10: jak sobie radzić w sieci — wyszukiwanie', '', 84, 89, 'elementarz_internetu_czesc_10_jak_sobie_radzic_w_sieci_wyszukiwanie', 2, 72, 46, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(884, 'Bądź punktualny. Przegląd programów do synchronizacji czasu', '', 90, 93, 'badz_punktualny_przeglad_programow_do_synchronizacji_czasu', 10, 9, 46, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(885, 'Norton Internet Security 2005 PL', '', 94, 95, 'norton_internet_security_2005_pl', 10, 38, 46, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(886, 'PHP i bezpieczne logowanie', '', 98, 102, 'php_i_bezpieczne_logowanie', 5, 11, 46, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(887, 'Systemy CMS: PHP-Nuke', '', 103, 107, 'systemy_cms_php_nuke', 5, 88, 46, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(888, 'Tabele HTML', '', 108, 111, 'tabele_html', 5, 83, 46, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(889, 'webFAQ. Porady serwisu web.reporter.pl', '', 112, 114, 'webfaq_porady_serwisu_web_reporter_pl23', 5, 4, 46, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(890, 'Szerokie pasmo zmian. Podsumowanie roku 2004 w Internecie: fakty, wydarzenia, technologie', 'Jeżeli ktoś wciąż jeszcze uważa, że w takiej branży jak Internet nie może dziać się nic ciekawego, ten najwyraźniej nie śledził uważnie wydarzeń mijającego roku. Działo się wiele - nowe usługi, nowe programy, branżowe przepychanki, a przede wszystkim coraz więcej pomysłów na to, jak Internet powinien wyglądać. Czas to wszystko podsumować.', 32, 41, 'szerokie_pasmo_zmian_podsumowanie_roku_2004_w_internecie_fakty_wydarzenia_technologie', 11, 89, 47, 10);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(891, 'Czas zmian w bankowości internetowej', 'Miało być różowo, bank dostępny przez całą dobę, bez kolejek, bez wypełniania mnóstwa dokumentów, bez opłat. Jednak do wszystkiego należy podchodzić z dystansem...', 42, 45, 'czas_zmian_w_bankowosci_internetowej', 12, 71, 47, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(892, 'Web-biznesmen. Rozrywka na twojej stronie WWW', 'Właściciele witryn internetowych szukają sposobów, aby zarobić, a przynajmniej odzyskać zainwestowane pieniądze. Jednym z rozwiązań jest uruchomienie usługi SMS-ów o podwyższonej płatności.', 46, 47, 'web_biznesmen_rozrywka_na_twojej_stronie_www', 12, 71, 47, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(893, 'Krok przed konkurencją. Promocja i reklama w Internecie w zgodzie z przepisami', 'Stworzenie skutecznej internetowej kampanii reklamowej to duży wysiłek. Oryginalny pomysł to dopiero początek. Trzeba jeszcze przebić się przez setki konkurencyjnych przekazów i zaintrygować internautę na tyle, by nie zamknął okienka reklamowego.', 48, 50, 'krok_przed_konkurencja_promocja_i_reklama_w_internecie_w_zgodzie_z_przepisami', 12, 16, 47, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(894, 'Pożegnanie z telefonem?', 'Telefonia internetowa istnieje w różnych formach już od bardzo dawna, ale dopiero teraz, za sprawą usług w rodzaju SkypeOut, Nawijka czy Tlenofon zyskuje sobie niebywałą popularność.', 52, 56, 'pozegnanie_z_telefonem', 2, 17, 47, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(895, 'No i gdzie te gigabajty?', 'Porównanie darmowych kont e-mail w polskich portalach', 58, 59, 'no_i_gdzie_te_gigabajty', 2, 17, 47, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(896, 'iplay.pl Legalna Muzyka z sieci', '', 60, 61, 'iplay_pl_legalna_muzyka_z_sieci', 2, 17, 47, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(897, 'Jak skutecznie sprzedawać na aukcjach. Poradnik dla korzystających z Allegro', 'Artykuł zawiera praktyczne porady i wskazówki napisane w oparciu o doświadczenia ze sprzedaży autora.', 62, 65, 'jak_skutecznie_sprzedawac_na_aukcjach_poradnik_dla_korzystajacych_z_allegro', 2, 4, 47, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(898, '10 najczęstszych zagrożeń internetowych', 'Spróbujmy bez emocji i wzbudzania niepotrzebnej sensacji wypunktować najczęstsze zagrożenia internetowe, z życia wzięte ich przykłady oraz metody obrony.', 66, 71, '10_najczestszych_zagrozen_internetowych', 2, 4, 47, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(899, 'Języki obce przez Internet - za darmo!', 'Czy wiesz, że możesz uczyć się języków obcych nic za to nie płacąc? Wystarczy, że zamówisz odpowiednie serwisy na e-mail, które oferują wortale edukacyjne.', 72, 73, 'jezyki_obce_przez_internet_za_darmo', 2, 25, 47, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(900, 'Elementarz Internetu. Część 11: jak sobie radzić w sieci', 'Na wszystko znajdzie się ... program.', 74, 79, 'elementarz_internetu_czesc_11_jak_sobie_radzic_w_sieci', 2, 72, 47, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(901, 'Barometr Internetu', '', 80, 81, 'barometr_internetu3', 2, 73, 47, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(902, 'Podziel się plikami!. Przegląd programów P2P', 'Bezpośrednia wymiana plików przez Internet, mimo kontrowersji wokół tego tematu, cieszy się niesłabnącą popularnością. Od czasów Napstera rozwój sieci P2P nabrał takiego tempa, że obecnie trudno nadążyć za coraz to nowszymi technikami dystrybucji plików.', 82, 87, 'podziel_sie_plikami_przeglad_programow_p2p', 10, 9, 47, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(903, 'Zend API - gdy PHP to za mało', 'Mimo ogromu bibliotek, które oferuje PHP, może się okazać, że staniemy przed koniecznością stworzenia własnego rozszerzenia, na przykład w celu obsłużenia z poziomu PHP miernika, a następnie zaprezentowania wyników pomiarów na stronie internetowej. W celu utworzenia takiego rozszerzenia należy zapoznać się z Zend API.', 92, 95, 'zend_api_gdy_php_to_za_malo', 5, 11, 47, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(904, 'HTML: ilustrowanie witryn', 'Artykuł omawia podstawowe wiadomości dotyczące umieszczania ilustracji na stronach WWW.', 96, 101, 'html_ilustrowanie_witryn', 5, 83, 47, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(905, 'webFAQ. Porady serwisu web.reporter.pl', '', 102, 103, 'webfaq_porady_serwisu_web_reporter_pl24', 5, 4, 47, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(906, 'Systemy CMS: PostNuke', 'Zwiększone bezpieczeństwo, system skórek, poprawność generowanego kodu HTML oraz uproszczona procedura instalacyjna - to najbardziej rzucające się w oczy zalety PostNuka.', 104, 106, 'systemy_cms_postnuke', 5, 90, 47, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(907, 'Formy reklamy w sieci. Marketing internetowy, czyli jak się reklamować w sieci', 'Czym jest reklama internetowa dzisiaj? Jakie przybiera formy? Jak się reklamować w wyszukiwarkach? Jak mierzyć efektywność reklamy?', 32, 33, 'formy_reklamy_w_sieci_marketing_internetowy_czyli_jak_sie_reklamowac_w_sieci', 11, 91, 48, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(908, 'Reklama w wyszukiwarkach internetowych', '', 34, 35, 'reklama_w_wyszukiwarkach_internetowych', 11, 91, 48, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(909, 'Zareklamować się w Internecie', '', 37, 40, 'zareklamowac_sie_w_internecie', 11, 91, 48, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(910, 'Kradzieże domen wciąż w modzie', 'Biznes domenowy jest jedną z bardziej dochodowych i dynamicznie rozwijających się form zarobkowania związanych z funkcjonowaniem Internetu. Ale również jest to pole dla spekulacji atrakcyjnymi adresami stron WWW.', 44, 45, 'kradzieze_domen_wciaz_w_modzie', 12, 16, 48, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(911, 'Internetowe zakupy a ochrona konsumentów', 'Dzięki zakupom w Internecie można znacznie zaoszczędzić. E-sklepy przyciągają niskimi cenami i szerokim asortymentem, a porównanie cen zajmuje dosłownie chwilkę. Skłania to coraz więcej osób do wydawania pieniędzy w sieci.', 46, 47, 'internetowe_zakupy_a_ochrona_konsumentow', 12, 16, 48, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(912, 'Ataki typu DoS. Anatomia zagrożenia i metody obrony', 'Obok takich niebezpieczeństw jak wirusy czy włamania do systemów coraz powszechniejsze stają się ostatnio ataki blokujące dostęp do zasobów i usług sieciowych.', 48, 52, 'ataki_typu_dos_anatomia_zagrozenia_i_metody_obrony', 12, 39, 48, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(913, 'Wbrew regułom, czyli jak konstruować tekst na stronę internetową', '', 53, 53, 'wbrew_regulom_czyli_jak_konstruowac_tekst_na_strone_internetowa', 12, 4, 48, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(914, 'Wyszukiwarki', 'W minionym roku rynek reklamy internetowej w głównej mierze napędzany był przez rozwój reklamy w wyszukiwarkach. Pojawiły się duże pieniądze, wyścig między głównymi graczami nabrał na sile. Co konkretnie wydarzyło się w 2004 roku i jak rynek będzie się rozwijał w przyszłości?', 54, 55, 'wyszukiwarki', 12, 71, 48, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(915, 'Korzystaj i twórz. Wikipedia', '', 56, 59, 'korzystaj_i_tworz_wikipedia', 2, 36, 48, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(916, 'Ulubione zawsze pod ręką', 'Jeśli często zmieniamy miejsce, z którego łączymy się z Internetem, np. jesteśmy stałymi bywalcami cyberkafejek, wówczas najlepiej przechowywać ulubione w sieci.', 60, 62, 'ulubione_zawsze_pod_reka', 2, 17, 48, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(917, 'Wtyczka dobra na wszystko. Czyli jak ulepszyć Internet Explorera', 'Nie ma rzeczy idealnych. Stwierdzenie to odnosi się również do przeglądarek internetowych, a zwłaszcza Internet Explorera. Jednak mnogość dostępnych wtyczek sprawia, że można łatwo ulepszyć tę przeglądarkę i dostosować do własnych potrzeb.', 63, 65, 'wtyczka_dobra_na_wszystko_czyli_jak_ulepszyc_internet_explorera', 2, 4, 48, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(918, 'Nie taki eBay straszny', '', 66, 71, 'nie_taki_ebay_straszny', 2, 4, 48, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(919, 'Sekrety haseł', 'Hasła są najczęściej stosowanym zabezpieczeniem dostępu do systemów informatycznych. Swoją popularność zawdzięczają temu, że są proste, niedrogie oraz łatwe w użyciu i administracji. Hasło stanowi jednak dość słabą formę ochrony, gdyż jest uzależnione od najbardziej zawodnego ogniwa w systemie bezpieczeństwa - człowieka.', 72, 75, 'sekrety_hasel', 2, 4, 48, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(920, 'Barometr Internetu', '', 76, 77, 'barometr_internetu4', 2, 73, 48, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(921, 'Gwiezdny kupiec kontratakuje', '', 78, 79, 'gwiezdny_kupiec_kontratakuje', 2, 75, 48, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(922, 'Elementarz Internetu. Część 12: jak sobie radzić w sieci', 'Garść porad na koniec', 80, 85, 'elementarz_internetu_czesc_12_jak_sobie_radzic_w_sieci', 2, 72, 48, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(923, 'Cyfrowy listonosz', 'Poczta elektroniczna coraz silniej zaczyna wypierać papierową korespondencję. Domowe komputery zastępują długopis, rolę listonosza przejmuje stosowny protokół komunikacyjny, a zamiast kartki papieru mamy program pocztowy, który przyjmuje wprowadzone informacje i wysyła je w świat.', 86, 91, 'cyfrowy_listonosz', 10, 9, 48, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(924, 'Obrazki pod kluczem: jak utrudnić życie plagiatorom?', '', 94, 95, 'obrazki_pod_kluczem_jak_utrudnic_zycie_plagiatorom', 5, 12, 48, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(925, 'Zabezpiedczanie obrazów przy użyciu PHP. Praktyka dla zaawansowanych webmasterów', '', 96, 98, 'zabezpiedczanie_obrazow_przy_uzyciu_php_praktyka_dla_zaawansowanych_webmasterow', 5, 12, 48, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(926, 'XTE — skórki dla PostNuke''a', '', 99, 103, 'xte_skorki_dla_postnuke_a', 5, 90, 48, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(927, 'HTML: cytaty, wykazy, elementy DIV oraz SPAN', '', 104, 109, 'html_cytaty_wykazy_elementy_div_oraz_span', 5, 83, 48, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(928, 'Warstwy lepsze niż tabele', 'Jeśli Twoja strona pęka w szwach, a drobna zmiana powoduje totalny chaos, to nadszedł czas na zastosowanie warstw. Warstwy zapewnią Ci komfort pracy i pozwolą zaoszczędzić mnóstwo czasu.', 110, 111, 'warstwy_lepsze_niz_tabele', 5, 4, 48, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(929, 'webFAQ. Porady serwisu web.reporter.pl', '', 112, 113, 'webfaq_porady_serwisu_web_reporter_pl25', 5, 4, 48, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(930, 'Wszystkie drogi prowadzą do Sieci. Technologie dostępowe, oferty dostępu szerokopasmowego, dial-up', 'Dzięki coraz szybszemu rozwojowi usług i technologii internetowych mamy możliwość wyboru sposobu w jaki łączymy się z Internetem. Poszczególne technologie dostępu mają wady i zalety. Czego możemy się spodziewać wybierając jedną z nich?', 32, 38, 'wszystkie_drogi_prowadza_do_sieci_technologie_dostepowe_oferty_dostepu_szerokopasmowego_dial_up', 11, 92, 49, 7);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(931, 'Infostrada a sprawa polska', '', 39, 43, 'infostrada_a_sprawa_polska', 11, 92, 49, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(932, 'Numer dostępowy z wartością dodaną', '', 44, 45, 'numer_dostepowy_z_wartoscia_dodana', 11, 92, 49, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(933, 'Badania Megapanel PBI/Gemius . Poprawne dane i kontrowersyjna prezentacja?', '11 stycznia br. światło dzienne ujrzały długo oczekiwane badania oceniające popularność polskich mediów internetowych. Po publikacji zawrzało - wyłonił się spory konflikt między portalami a sieciami reklamowymi. Co było tego powodem? Jak oceniać jakość badań?', 48, 51, 'badania_megapanel_pbi_gemius_poprawne_dane_i_kontrowersyjna_prezentacja', 12, 31, 49, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(934, 'Reklama online: jest dobrze, będzie lepiej', 'Z Dominikiem Kaznowskim, wiceprezesem zarządu IAB Polska, rozmawia Tomasz Frontczak.', 52, 53, 'reklama_online_jest_dobrze_bedzie_lepiej', 12, 6, 49, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(935, 'Nadeszła alternatywa. Firefox 1.0 PL, Thunderbird 1.0 PL', '', 54, 58, 'nadeszla_alternatywa_firefox_1_0_pl_thunderbird_1_0_pl', 2, 93, 49, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(936, 'Czy czuje Pani czta, Czy czata Pani zna?', '', 60, 62, 'czy_czuje_pani_czta_czy_czata_pani_zna', 2, 4, 49, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(937, 'Włącz wizję, to pogadamy!', '', 64, 66, 'wlacz_wizje_to_pogadamy', 2, 4, 49, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(938, 'Dobra prezentacja to podstawa. Jak wystawiać przedmioty na aukcjach internetowych (na przykładzie Allegro.pl)', 'Przeglądając aukcje w Internecie można spostrzec, jak ogromne znaczenie dla sprzedaży ma odpowiednia prezentacja przedmiotu.', 67, 69, 'dobra_prezentacja_to_podstawa_jak_wystawiac_przedmioty_na_aukcjach_internetowych_na_przykladzie_allegro_pl', 2, 4, 49, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(939, 'Bo ja jestem, proszę pana, bardzo dobrze wychowana. Usenetowy savoir-vivre', 'Zanim wyryjesz w Usenecie „tu byłem”, zapoznaj się z obowiązującymi regułami i - co ważne - przestrzegaj ich.', 70, 72, 'bo_ja_jestem_prosze_pana_bardzo_dobrze_wychowana_usenetowy_savoir_vivre', 2, 4, 49, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(940, 'SGE Strateg. Sprawdź się w roli prezesa', '', 74, 75, 'sge_strateg_sprawdz_sie_w_roli_prezesa', 2, 75, 49, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(941, 'Papier w sieci', '', 76, 79, 'papier_w_sieci', 2, 36, 49, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(942, 'Znajdź sponsora swego!', 'W dobie intensywnego rozwoju Internetu nikt już nie wątpi, czy warto inwestować w reklamę internetową, ale na pewno pyta: jak zrobić to efektywnie?', 80, 83, 'znajdz_sponsora_swego', 2, 17, 49, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(943, 'Zjedz ciasteczko', '', 84, 85, 'zjedz_ciasteczko', 2, 39, 49, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(944, 'Praktyka dla początkujących. część 1: Outlook Express bez tajemnic', 'Ten nowy cykl jest kolejnym, po Elementarzu Internetu, poradnikiem dla początkujących internautów. Dzięki niemu Czytelnik bardzo dokładnie pozna możliwości poszczególnych programów, a przy okazji również nowe szczegóły i niuanse usług internetowych.', 86, 90, 'praktyka_dla_poczatkujacych_czesc_1_outlook_express_bez_tajemnic', 2, 32, 49, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(945, 'Barometr Internetu', '', 92, 94, 'barometr_internetu5', 2, 73, 49, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(946, 'PostNuke w praktyce', '', 95, 97, 'postnuke_w_praktyce', 2, 90, 49, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(947, 'CSS - kaskadowe arkusze stylów', 'Kaskadowe arkusze stylów dołączane do witryn WWW zawierają definicje formatów poszczególnych elementów HTML. Artykuł zawiera przegląd najważniejszych informacji dotyczących języka CSS.', 98, 103, 'css_kaskadowe_arkusze_stylow', 5, 83, 49, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(948, 'Ochrona usług przy użyciu obrazków zabezpieczających. Skuteczny sposób na roboty internetowe', 'Czasy, w których za pomocą jednego formularza można było zarejestrować stronę we wszystkich katalogach i wyszukiwarkach bezpowrotnie przeminęły. Wszystkiemu winne są niepozorne obrazki zabezpieczające, które zmuszają użytkownika do przepisania ukrytych w nich haseł.', 104, 107, 'ochrona_uslug_przy_uzyciu_obrazkow_zabezpieczajacych_skuteczny_sposob_na_roboty_internetowe', 5, 11, 49, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(949, 'Wtyczkowe szaleństwo', '', 108, 111, 'wtyczkowe_szalenstwo', 10, 9, 49, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(950, 'Zaoszczędzić w Internecie', 'Na usługach finansowych dokonywanych w sieci korzystają wszystkie strony: banki, biura maklerskie, sklepy wirtualne, ubezpieczyciele, a przede wszystkim osoby prywatne, które zdecydowały się na taki sposób prowadzenia swoich rachunków. W artykule pokażemy, na czym konkretnie mogą zaoszczędzić internauci, którzy korzystają z szeroko rozumianych usług e-finansowych.', 32, 35, 'zaoszczedzic_w_internecie', 11, 94, 50, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(951, 'Biura maklerskie online', '', 37, 38, 'biura_maklerskie_online', 11, 94, 50, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(952, 'Oszczędzanie przez porównywanie cen', '', 40, 40, 'oszczedzanie_przez_porownywanie_cen', 11, 94, 50, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(953, 'Czy to się opłaca?', '', 44, 45, 'czy_to_sie_oplaca', 12, 4, 50, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(954, 'Pozycjonowanie w praktyce', 'Pozycjonowanie to nowe zjawisko w polskim Internecie. Rozwija się jednak bardzo dynamicznie, o czym może świadczyć ilość firm oferujących takie usługi. Czym jest pozycjonowanie i czy każdy może skorzystać z tej usługi?', 46, 47, 'pozycjonowanie_w_praktyce', 12, 4, 50, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(955, 'Droga do e-sukcesu - zobacz jak to robią inni!', 'Rozmowa z Tomaszem Kapelakiem, twórcą i właścicielem popularnych księgarni internetowych.', 48, 49, 'droga_do_e_sukcesu_zobacz_jak_to_robia_inni', 12, 32, 50, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(956, 'E-podpis - bezpieczeństwo informacji', 'Istotnym elementem przemian gospodarczych jest informacja, która stała się bardzo cenna, a jej wartość zależy od jej autora. Dlatego tak ważne stało się ustalenie, skąd pochodzi przekazywana wiadomość, szczególnie, gdy kanałem łączącym nadawcę i odbiorcę wiadomości jest Internet. Inną kwestią jest utajnienie wiadomości. Rozwiązanie tych problemów stanowi podpis elektroniczny.', 50, 55, 'e_podpis_bezpieczenstwo_informacji', 12, 24, 50, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(957, 'Webmaster - zawód podwyższonego ryzyka?', 'Zajęcie webmastera przynosi wiele satysfakcji, ale może też okazać się źródłem nie lada tarapatów. Okazuje się na przykład, że webmaster może ponosić odpowiedzialność za działania innych. Dotyczy to w szczególności zbyt żarliwych dyskusji na forach internetowych.', 56, 57, 'webmaster_zawod_podwyzszonego_ryzyka', 12, 16, 50, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(958, 'Niech cię zobaczą!', 'Wystaw swoje zdjęcia w Internecie i przekonaj się, co o nich sądzą inni', 58, 61, 'niech_cie_zobacza', 2, 17, 50, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(959, 'Nawigacja to podstawa', 'Dobry webmaster musi umieć tworzyć prostą i elegancką nawigację, która będzie trzymać się zasad dostępności dla każdego. Wbrew pozorom nie jest to tak proste, jak mogłoby się wydawać.', 62, 64, 'nawigacja_to_podstawa', 2, 4, 50, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(960, 'Google potrafi (prawie) wszystko!', 'Tak naprawdę niewiele osób umie wykorzystać pełnię możliwości największej wyszukiwarki internetowej...', 66, 69, 'google_potrafi_prawie_wszystko', 2, 4, 50, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(961, 'Skróty i buźki - sieciowa nowomowa', '', 70, 71, 'skroty_i_buzki_sieciowa_nowomowa', 2, 95, 50, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(962, 'Spokojnie, to tylko błąd!', '', 72, 73, 'spokojnie_to_tylko_blad', 2, 3, 50, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(963, 'Virlandia, czyli jak gra staje się drugim domem', '', 74, 75, 'virlandia_czyli_jak_gra_staje_sie_drugim_domem', 2, 75, 50, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(964, 'Barometr Internetu', '', 76, 78, 'barometr_internetu6', 2, 73, 50, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(965, 'Nie daj się fiskusowi!. Komu przysługuje ulga internetowa i jak się rozliczyć', 'Z dniem 1 stycznia 2005 r. weszły w życie zmiany w przepisach podatkowych, wśród których znalazła się tzw. ulga internetowa. Ile maksymalnie będziemy mogli odliczyć od podatku? Kto będzie mógł skorzystać z tej ulgi? Na te i inne pytania odpowiem w tym artykule.', 79, 79, 'nie_daj_sie_fiskusowi_komu_przysluguje_ulga_internetowa_i_jak_sie_rozliczyc', 2, 77, 50, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(966, 'Praktyka dla początkujących. część 2: Outlook Express - więcej możliwości', 'W tym odcinku kontynuujemy opis najpopularniejszego klienta pocztowego. Poznamy jego kolejne, coraz bardziej zaawansowane opcje oraz wyjaśnimy jak rozwiązać kilka najczęściej spotykanych problemów.', 80, 85, 'praktyka_dla_poczatkujacych_czesc_2_outlook_express_wiecej_mozliwosci', 2, 72, 50, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(967, 'Zobacz więcej. Programy do tworzenia panoram i wirtualnych wycieczek', '', 86, 91, 'zobacz_wiecej_programy_do_tworzenia_panoram_i_wirtualnych_wycieczek', 10, 9, 50, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(968, 'PHP i pliki', '', 94, 99, 'php_i_pliki', 5, 11, 50, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(969, 'CSS w praktyce: lista nawigacyjna', '', 100, 101, 'css_w_praktyce_lista_nawigacyjna', 5, 96, 50, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(970, 'Jak działają formularze?', 'W artykule omówimy, co się dzieje, gdy internauta wypełnia formularz, jak są zakodowane i jaką drogę odbywają wprowadzone informacje, oraz metody dostępu do danych pochodzących z formularza w języku PHP.', 102, 106, 'jak_dzialaja_formularze', 5, 97, 50, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(971, 'Statystyki przez WAP. czyli jak połączyć PHP z językiem WML', 'Artykuł prezentuje przydatność protokołu WAP oraz połączenie języka WML z dynamicznym PHP.', 107, 111, 'statystyki_przez_wap_czyli_jak_polaczyc_php_z_jezykiem_wml', 5, 98, 50, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(972, 'webFAQ. Porady serwisu web.reporter.pl', '', 112, 113, 'webfaq_porady_serwisu_web_reporter_pl26', 5, 4, 50, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(973, 'Bezpieczeństwo przede wszystkim', '', 32, 34, 'bezpieczenstwo_przede_wszystkim', 11, 39, 51, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(974, 'Elementarz bezpieczeństwa', '', 36, 38, 'elementarz_bezpieczenstwa', 11, 39, 51, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(975, 'Narzędzia do obrony', '', 39, 41, 'narzedzia_do_obrony', 11, 39, 51, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(976, 'Jak obronić się samemu — za darmo!', '', 42, 43, 'jak_obronic_sie_samemu_za_darmo', 11, 39, 51, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(977, 'Patentowe zamieszanie', 'W świecie informatyki zawrzało - Unia Europejska wprowadza patenty na oprogramowanie. Czy czeka nas powtórka sytuacji z USA? Czy europejskie firmy będą mogły opatentować kliknięcie klawiszem myszki?', 44, 46, 'patentowe_zamieszanie', 12, 16, 51, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(978, 'Sposoby targetowania reklamy w internecie', 'Efektywność reklamy w dużej mierze zależy od tego czy przekaz reklamowy dotrze do właściwej grupy docelowej...', 48, 51, 'sposoby_targetowania_reklamy_w_internecie', 12, 31, 51, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(979, 'Wyszukiwarki - bardzo popularne i naiwnie postrzegane?', 'Najpopularniejszą usługą internetową jest poczta elektroniczna. Zadanie zapytania wyszukiwarce to druga pod względem popularności aktywność, z którą internauci szybko oswajają się i czują komfortowo. Jak popularne są wyszukiwarki w Polsce? Jak użytkownicy postrzegają zwrócone przez nie wyniki?', 52, 54, 'wyszukiwarki_bardzo_popularne_i_naiwnie_postrzegane', 12, 71, 51, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(980, '4 lata Gery.pl', 'Wywiad z Gerardem Grechem, właścicielem portalu Gery.pl.', 56, 57, '4_lata_gery_pl', 12, 6, 51, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(981, 'Firefox na sterydach', 'Firefox zdobywa serca coraz większej rzeszy użytkowników i staje się poważną konkurencją dla innych przeglądarek internetowych. Powodem rosnącej jest m.in. możliwość wyposażenia go w różne dodatki, których liczba już dawno przekroczyła setkę.', 58, 61, 'firefox_na_sterydach', 2, 93, 51, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(982, '101 drobiazgów dla twojej przeglądarki,. czyli Internet Explorer jakiego jeszcze nie znałeś', 'Internet Explorer to od lat dominujący składnik Windows. W ciągu ostatnich lat niewiele go jednak ulepszano i obecnie, na tle prężnej konkurencji, systemowa przeglądarka wygląda trochę nieciekawie. Na szczęście aby to zmienić, wystarczy mały facelifting.', 62, 65, '101_drobiazgow_dla_twojej_przegladarki_czyli_internet_explorer_jakiego_jeszcze_nie_znales', 2, 93, 51, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(983, 'Ciemna strona aukcji internetowych, czyli jak nie dać się oszukać', '', 66, 69, 'ciemna_strona_aukcji_internetowych_czyli_jak_nie_dac_sie_oszukac', 2, 4, 51, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(984, 'Zadbaj o swój podpis', '„Najlepsza sygnatura, to brak sygnatury” - ktoś w Usenecie zrobił sobie taką sygnaturę i chyba miał rację...', 70, 71, 'zadbaj_o_swoj_podpis', 2, 4, 51, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(985, 'Porozmawiaj z botem', 'Czatowanie wciąga, a wiadomo, że co za dużo, to niezdrowo. Co zatem zrobić, gdy człowiek czatuje z komputerem i zaczyna się od tego uzależniać? Wtedy czas na odwyk i wizytę u doktor Elizy - czatbota, naturalnie.', 72, 73, 'porozmawiaj_z_botem', 2, 3, 51, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(986, 'Barometr Internetu', '', 74, 77, 'barometr_internetu7', 2, 73, 51, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(987, 'Praktyka dla początkujących. część 3: co można wycisnąć z Internet Explorera', 'Wbrew pozorom IE, który na pierwszy rzut oka wydaje się nieskomplikowany, ma bardzo duże możliwości i całą masę opcji, które warto poznać.', 78, 83, 'praktyka_dla_poczatkujacych_czesc_3_co_mozna_wycisnac_z_internet_explorera', 2, 32, 51, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(988, 'Pogoda z komputera', 'Coraz większą popularność zdobywają programy wyświetlające na bieżąco informacje o warunkach meteorologicznych na ekranie monitora.', 84, 87, 'pogoda_z_komputera', 10, 9, 51, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(989, 'Najwyższy czas na XHTML', 'Niedawno ukazała się nowa, druga wersja języka XHTML, na CSS3 wszyscy do dziś czekamy z niecierpliwością. Może więc warto poznać te technologie i zacząć w nich programować?', 90, 93, 'najwyzszy_czas_na_xhtml', 5, 99, 51, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(990, 'Kontrolki formularzy', 'Artykuł szczegółowo omawia wszystkie elementy języka HTML dotyczące formularzy i wyjaśnia rolę oraz sposób wykorzystania poszczególnych atrybutów.', 94, 99, 'kontrolki_formularzy', 5, 97, 51, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(991, 'PHP i pliki, cz. 2', '', 100, 103, 'php_i_pliki_cz_2', 5, 11, 51, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(992, 'webFAQ. Porady serwisu web.reporter.pl', '', 104, 105, 'webfaq_porady_serwisu_web_reporter_pl27', 5, 4, 51, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(993, 'Internet w kieszeni', 'Niemal każdy użytkownik internetu chciałby cieszyć się szybkim dostępem do sieci w dowolnym miejscu i czasie, jednak za cenę, która nie doprowadzi do ruiny jego portfela. Na dodatek chciałby korzystać z lekkiego, funkcjonalnego i niewielkiego urządzenia, wyposażonego w duży kolorowy wyświetlacz i wygodną klawiaturę. Teraz jest to już możliwe!', 32, 35, 'internet_w_kieszeni', 11, 100, 52, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(994, 'Cały Internet w małej karcie SIM', '', 36, 40, 'caly_internet_w_malej_karcie_sim', 11, 100, 52, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(995, 'Planowanie kampanii promocyjnych w internecie', 'W przypadku niemal wszystkich działań marketingowych prowadzonych w sieci i poza nią dla osiągnięcia sukcesu niezbędne jest przygotowanie planu oraz późniejsza jego realizacja. Niezbędna jest zatem znajomość zasad planowania kampanii promocyjnych.', 42, 43, 'planowanie_kampanii_promocyjnych_w_internecie', 12, 31, 52, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(996, 'Gdzie ulokować pieniądze w sieci?. Wyniki rankingu polskich kont bankowych online', 'Portal finansowy Money.pl zorganizował pierwszy niezależny ranking kont bankowych, w którym internauci ocenili i wybrali najlepsze rachunki bankowe online w Polsce.', 44, 46, 'gdzie_ulokowac_pieniadze_w_sieci_wyniki_rankingu_polskich_kont_bankowych_online', 12, 35, 52, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(997, 'Barbarzyńcy pokonani?', 'Nowe mechanizmy redukcji piractwa na rynku gier komputerowych', 47, 47, 'barbarzyncy_pokonani', 12, 16, 52, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(998, 'Dziurawe programy pod lupą', 'Prawne aspekty ujawniania wad oprogramowania komputerowego', 48, 49, 'dziurawe_programy_pod_lupa', 12, 16, 52, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(999, 'Polski internet rośnie w siłę!', 'Raport IAB Polska: blisko 8 milionów internautów w Polsce na koniec 2004 r. Przełom w rozwoju polskiego rynku reklamy online.', 50, 51, 'polski_internet_rosnie_w_sile', 12, 32, 52, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1000, 'Dyplom z sieci', 'Już ponad 10 mln osób studiuje przez internet, głównie w Wielkiej Brytanii, Kanadzie, USA, Australii i Nowej Zelandii. Również Polacy zaczynają się przekonywać do tej formy edukacji.', 52, 55, 'dyplom_z_sieci', 2, 46, 52, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1001, 'Twój PC częścią superkomputera. Od modelowania leków do poszukiwania życia pozaziemskiego', 'Wielu posiadaczy komputerów nie zdaje sobie sprawy, że procesor w ich maszynie wykorzystuje tylko ułamek swych możliwości, podczas gdy resztę czasu spędza właściwie bezczynnie. Tymczasem wolne moce obliczeniowe mogą się przyczynić do rozwoju najważniejszych problemów współczesnej nauki.', 56, 59, 'twoj_pc_czescia_superkomputera_od_modelowania_lekow_do_poszukiwania_zycia_pozaziemskiego', 2, 26, 52, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1002, 'Tłumacz pilnie potrzebny!', 'Do redakcji przychodzi dużo e-maili z pytaniami dotyczącymi rozmaitych, tajemniczych skrótów, które spotyka się w internecie na każdym kroku. Chodzi zarówno o oznaczenia oprogramowania, jak i innych materiałów, np. plików z muzyką czy filmami. Ten artykuł ma za zadanie dokładnie objaśnić znaczenie poszczególnych skrótów.', 60, 63, 'tlumacz_pilnie_potrzebny', 2, 4, 52, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1003, 'Nie daj się zrobić w konia! Instalujesz program? To koniecznie przeczytaj licencję.', '', 64, 65, 'nie_daj_sie_zrobic_w_konia_instalujesz_program_to_koniecznie_przeczytaj_licencje', 2, 4, 52, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1004, 'Jak się zarabia na naiwności internautów?', '', 66, 67, 'jak_sie_zarabia_na_naiwnosci_internautow', 2, 3, 52, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1005, 'Porównywarki cen. Alternatywa dla oszczędnych', '', 68, 70, 'porownywarki_cen_alternatywa_dla_oszczednych', 2, 17, 52, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1006, 'Google Toolbar 3. Wypełni formularz i sprawdzi pisownię', 'Pasek Google to już nie tylko szybszy dostęp do okienka wyszukiwania. Nowa wersja Google Toolbar potrafi np. wypełnić formularz rejestracyjny czy sprawdzić pisownię e-maili pisanych w internetowym programie pocztowym.', 71, 73, 'google_toolbar_3_wypelni_formularz_i_sprawdzi_pisownie', 2, 93, 52, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1007, 'Twoje-Miasto.pl Wirtualne życie', '', 74, 75, 'twoje_miasto_pl_wirtualne_zycie', 2, 75, 52, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1008, 'Praktyka dla początkujących. część 4: Zaawansowane opcje Internet Explorera', '', 76, 81, 'praktyka_dla_poczatkujacych_czesc_4_zaawansowane_opcje_internet_explorera', 2, 32, 52, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1009, 'Barometr Internetu', '', 82, 84, 'barometr_internetu8', 2, 73, 52, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1010, 'Uprzejmie donoszę, że.... Przegląd programów do monitorowania zmian na stronach WWW', 'Informacje przekazywane na stronach WWW często odgrywają czołową rolę w procesie zdobywania wiadomości. Przeglądanie ulubionych witryn i śledzenie aktualności bywa jednak żmudne i monotonne. Dlatego warto skorzystać z aplikacji, które same podpowiedzą, co i gdzie zostało zmodyfikowane.', 86, 91, 'uprzejmie_donosze_ze_przeglad_programow_do_monitorowania_zmian_na_stronach_www', 10, 9, 52, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1011, 'Walidacja formularzy', '', 94, 99, 'walidacja_formularzy', 5, 11, 52, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1012, 'Zaawansowana obsługa formularzy w PHP. Wykorzystanie pakietu QuickForm', 'Podczas tworzenia nawet najprostszego formularza należy zaprojektować ogólny wygląd, wygenerować odpowiedni kod HTML oraz stworzyć skrypt obsługujący odpowiednie pola. Co jednak, gdy w jakiś sposób chcemy zweryfikować poprawność wprowadzonych danych?', 100, 101, 'zaawansowana_obsluga_formularzy_w_php_wykorzystanie_pakietu_quickform', 5, 11, 52, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1013, 'PHP i pliki, część 3', '', 102, 105, 'php_i_pliki_czesc_3', 5, 11, 52, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1014, 'Wszystko o tworzeniu i publikowaniu kanałów RSS', '', 106, 111, 'wszystko_o_tworzeniu_i_publikowaniu_kanalow_rss', 5, 101, 52, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1015, 'webFAQ. Porady serwisu web.reporter.pl', '', 112, 113, 'webfaq_porady_serwisu_web_reporter_pl28', 5, 4, 52, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1016, 'Podglądanie w sieci. Cyfrowe oko do komputera', '', 32, 39, 'podgladanie_w_sieci_cyfrowe_oko_do_komputera', 11, 102, 53, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1017, 'Cały świat w zasięgu webkamery', '', 40, 43, 'caly_swiat_w_zasiegu_webkamery', 11, 102, 53, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1018, 'BePeHahaha, czyli jak skradziono milion złotych!', 'W maju ujawniono serię rekordowych włamań na internetowe konta w banku BPH. Szacuje się, że straty mogą sięgać nawet 1 mln złotych. Wydarzenia te obnażyły słaby poziom zabezpieczeń w niektórych polskich e-bankach, a także niski stan wiedzy polskich użytkowników internetu na temat bezpieczeństwa transakcji internetowych. Co powinieneś wiedzieć, aby nie dać się oszukać?', 44, 47, 'bepehahaha_czyli_jak_skradziono_milion_zlotych', 12, 27, 53, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1019, '11 pytań o AdSense', '', 48, 50, '11_pytan_o_adsense', 12, 4, 53, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1020, 'Gdzie sięgają możliwości wyszukiwarek?', '', 51, 51, 'gdzie_siegaja_mozliwosci_wyszukiwarek', 12, 15, 53, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1021, 'Musepack (MPC) - jakość za rozsądną ilość miejsca', 'Jeżeli MP3 @ 192 kb/s jest dla Was najniższym akceptowalnym poziomem jakości, zapraszamy do zapoznania się z formatem MPC.', 52, 55, 'musepack_mpc_jakosc_za_rozsadna_ilosc_miejsca', 2, 24, 53, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1022, 'Przeglądarki internetowe: decydujące starcie', 'Prawie 15 lat temu światło dzienne ujrzała pierwsza przeglądarka - WorldWideWeb - napisana przez samego ?ojca założyciela? internetu, Tima Bernersa-Lee. Dziś na rynku przeglądarek zostały ostatecznie trzy liczące się produkty. Co wybrać?', 56, 59, 'przegladarki_internetowe_decydujace_starcie', 2, 93, 53, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1023, 'Jak prowadzić sprzedaż na aukcjach?', 'Poradnik dla użytkowników Allegro.pl', 60, 62, 'jak_prowadzic_sprzedaz_na_aukcjach', 2, 4, 53, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1024, 'Jak po-dzie-lić muzykę?. Narzędzia do cięcia MP3', 'Od pewnego czasu w sieciach P2P (eMule, BitTorrent) pojawiają się duże pliki muzyczne, przeważnie MP3, rzędu kilkudziesięciu czy nawet ponad 100 MB. Aby nadawały się do użytku, trzeba je czymś podzielić...', 63, 65, 'jak_po_dzie_lic_muzyke_narzedzia_do_ciecia_mp3', 2, 4, 53, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1025, 'Sieciowe łowy. Nie sil się na anonimowość, i tak cię namierzą...', 'Ogólnoświatowa pajęczyna liczy obecnie ponad 8 miliardów stron. Namierzenie kogoś w tym bezmiarze jest łatwiejsze niż myślisz.', 66, 70, 'sieciowe_lowy_nie_sil_sie_na_anonimowosc_i_tak_cie_namierza', 2, 4, 53, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1026, 'moBlog.pl', 'Mobilny upload, stacjonarne podglądanie', 71, 73, 'moblog_pl', 2, 26, 53, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1027, 'Gry Online', 'Duel Online: strategia pojedynków', 74, 75, 'gry_online', 2, 32, 53, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1028, 'Internet uzależnia!', 'Z Wojmirem Strzałkowskim, psychologiem Ośrodka Psychologiczno-Pedagogicznego RAZEM w Gdyni (www.razem.pl), rozmawia Patrycja Kierzkowska.', 76, 77, 'internet_uzaleznia', 2, 6, 53, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1029, 'Praktyka dla początkujących', 'część 5: zaawansowane opcje Internet Explorera (cd.)', 78, 82, 'praktyka_dla_poczatkujacych', 2, 72, 53, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1030, 'Barometr Internetu', '', 83, 85, 'barometr_internetu9', 2, 73, 53, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1031, 'Zarządzanie multimediami', 'Twarde dyski naszych komputerów są coraz częściej wykorzystywane do magazynowania filmów, nagrań muzycznych. Aby sprawnie administrować poszerzającą się z roku na rok kolekcją, niezbędna jest odpowiednia aplikacja.', 86, 91, 'zarzadzanie_multimediami', 10, 9, 53, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1032, 'Ataki XSS oraz CSRF na aplikacje internetowe', '', 95, 99, 'ataki_xss_oraz_csrf_na_aplikacje_internetowe', 5, 103, 53, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1033, 'Skrypty JavaScript ułatwiające przetwarzanie formularzy', '', 100, 103, 'skrypty_javascript_ulatwiajace_przetwarzanie_formularzy', 5, 43, 53, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1034, 'Smarty dla opornych', 'PHP uchodzi za język prosty do nauki, ułatwiający tworzenie dynamicznych stron internetowych. To prawda. Ale stworzone w nim strony nie zawsze zostają równie szybko wygenerowane, a ich kod nie zawsze jest wystarczająco czytelny.', 104, 107, 'smarty_dla_opornych', 5, 11, 53, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1035, 'phpBB dla każdego', 'Profesjonalne forum w 5 minut', 108, 111, 'phpbb_dla_kazdego', 5, 12, 53, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1036, 'webFAQ. Porady serwisu web.reporter.pl', '', 112, 113, 'webfaq_porady_serwisu_web_reporter_pl29', 5, 4, 53, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1037, 'Internet dla grzczy', '', 32, 33, 'internet_dla_grzczy', 11, 104, 54, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1038, 'Tryb multiplayer', '', 34, 37, 'tryb_multiplayer', 11, 104, 54, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1039, 'Gry online', '', 39, 39, 'gry_online2', 11, 104, 54, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1040, 'Gracze światowego formatu', 'Wywiad z członkami Teamu Pentagram, odnoszącymi sukces w turniejach gier komputerowych, i z przedstawicielem sponsorującej ich firmy Multimedia Vision, która jest dystrybutorem marki Pentagram na rynku polskim.', 40, 41, 'gracze_swiatowego_formatu', 11, 104, 54, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1041, 'Płatne serwisy o grach', '', 42, 43, 'platne_serwisy_o_grach', 11, 104, 54, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1042, 'Konsole w sieci', '', 43, 44, 'konsole_w_sieci', 11, 104, 54, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1043, 'Spamowanie wyszukiwarek: warto czy nie?', '', 46, 48, 'spamowanie_wyszukiwarek_warto_czy_nie', 12, 31, 54, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1044, 'Domenowy biznes. Przepisy dotyczące rejestracji i obrotu domenami internetowymi', '', 49, 51, 'domenowy_biznes_przepisy_dotyczace_rejestracji_i_obrotu_domenami_internetowymi', 12, 16, 54, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1045, 'Zakupy w 9sekund.pl?', 'Z Łukaszem Kuncewiczem, szefem pasażu zakupowego 9sekund.pl, rozmawia Patrycja Kierzkowska.', 52, 53, 'zakupy_w_9sekund_pl', 12, 6, 54, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1046, 'Bezpieczeństwo kont internetowych', '', 54, 55, 'bezpieczenstwo_kont_internetowych', 2, 39, 54, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1047, 'Bezpieczny hotspot', '', 56, 59, 'bezpieczny_hotspot', 2, 39, 54, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1048, 'Kop głębiej! Google to nie wszystko.', '', 60, 63, 'kop_glebiej_google_to_nie_wszystko', 2, 4, 54, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1049, 'Gadaj zdrów!', '', 64, 66, 'gadaj_zdrow', 2, 4, 54, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1050, 'Nagrywanie z internetu. Jak zapisywać do pliku strumienie audio i wideo.', '', 67, 69, 'nagrywanie_z_internetu_jak_zapisywac_do_pliku_strumienie_audio_i_wideo', 2, 93, 54, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1051, 'Jak to się robi Mousepackiem', '', 70, 73, 'jak_to_sie_robi_mousepackiem', 2, 24, 54, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1052, 'Legalna muzyka z sieci', '', 74, 77, 'legalna_muzyka_z_sieci', 2, 17, 54, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1053, 'Portal na życzenie', '', 78, 80, 'portal_na_zyczenie', 2, 17, 54, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1054, 'Barometr Internetu', '', 81, 83, 'barometr_internetu10', 2, 73, 54, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1055, 'Praktyka dla początkujących. część 6: FTP dla każdego', '', 84, 89, 'praktyka_dla_poczatkujacych_czesc_6_ftp_dla_kazdego', 2, 72, 54, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1056, 'Wszystko gra! Przegląd narzędzi do obróbki plików audio', '', 90, 93, 'wszystko_gra_przeglad_narzedzi_do_obrobki_plikow_audio', 10, 9, 54, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1057, 'Wyszukiwanie plików', '', 97, 101, 'wyszukiwanie_plikow', 5, 11, 54, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1058, 'Uploader z paskiem dostępu', '', 102, 107, 'uploader_z_paskiem_dostepu', 5, 11, 54, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1059, 'Element META — dodatkowe informacje na temat witryny', '', 108, 113, 'element_meta_dodatkowe_informacje_na_temat_witryny', 5, 83, 54, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1060, 'Znajdź pracę w sieci', '', 34, 41, 'znajdz_prace_w_sieci', 11, 105, 55, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1061, 'Nie przepłacaj za reklamę', '', 42, 45, 'nie_przeplacaj_za_reklame', 12, 4, 55, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1062, 'Firma za darmo', '', 46, 48, 'firma_za_darmo', 12, 106, 55, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1063, 'P2P w kolejnych opałach?', '', 49, 49, 'p2p_w_kolejnych_opalach', 12, 16, 55, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1064, 'Odrzutowe radio', '', 50, 53, 'odrzutowe_radio', 2, 93, 55, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1065, 'Jak płacić w e-sklepach i na aukcjach?', '', 57, 59, 'jak_placic_w_e_sklepach_i_na_aukcjach', 2, 4, 55, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1066, 'Internetowe targowisko', '', 60, 63, 'internetowe_targowisko', 2, 4, 55, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1067, 'Szkolenia informatyczne', '', 64, 67, 'szkolenia_informatyczne', 2, 25, 55, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1068, 'Pisz do mnie szyfrem', '', 68, 71, 'pisz_do_mnie_szyfrem', 2, 17, 55, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1069, 'Wielki Brat Google', '', 72, 75, 'wielki_brat_google', 2, 5, 55, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1070, 'Kultura w komunikatorach', '', 76, 77, 'kultura_w_komunikatorach', 2, 95, 55, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1071, 'Twoje dziecko też może być ofiarą', 'Z Jakubem Śpiewakiem, założycielem fundacji Kid Protect (http://www.kidprotect.pl), rozmawia Patrycja Kierzkowska.', 78, 79, 'twoje_dziecko_tez_moze_byc_ofiara', 2, 6, 55, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1072, 'Battlefield 2', '', 80, 80, 'battlefield_2', 2, 75, 55, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1073, 'Empire Earth II', '', 81, 81, 'empire_earth_ii', 2, 75, 55, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1074, 'Barometr Internetu', '', 82, 85, 'barometr_internetu11', 2, 73, 55, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1075, 'Praktyka dla początkujących. część 7: P2P bez tajemnic', '', 86, 88, 'praktyka_dla_poczatkujacych_czesc_7_p2p_bez_tajemnic', 2, 72, 55, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1076, 'Graficzny przybornik webmastera, czyli jak udekorować stronę WWW', '', 90, 95, 'graficzny_przybornik_webmastera_czyli_jak_udekorowac_strone_www', 10, 9, 55, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1077, 'Oswoić XUL-a', '', 99, 103, 'oswoic_xul_a', 13, 29, 55, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1078, 'Układ strony w oparciu o elementy div i CSS', '', 104, 109, 'uklad_strony_w_oparciu_o_elementy_div_i_css', 13, 83, 55, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1079, 'Struktura kodu witryn tworzonych w PHP', '', 110, 113, 'struktura_kodu_witryn_tworzonych_w_php', 13, 11, 55, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1080, 'Doom 3', '', 74, 74, 'doom_3', 2, 75, 56, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1081, 'Worms 4: Totalna Rozwałka', '', 75, 75, 'worms_4_totalna_rozwalka', 2, 75, 56, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1082, 'Barometr Internetu', '', 76, 79, 'barometr_internetu12', 2, 73, 56, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1083, 'Praktyka dla początkujących. część 8: P2P bez tajemnic, c.d.', '', 80, 83, 'praktyka_dla_poczatkujacych_czesc_8_p2p_bez_tajemnic_c_d', 2, 72, 56, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1084, 'Monitory transferów', '', 84, 87, 'monitory_transferow', 10, 9, 56, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1085, 'CRON dla webmastera: automatyzacja procesów', '', 91, 95, 'cron_dla_webmastera_automatyzacja_procesow', 13, 12, 56, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1086, 'Ukrywanie kodu HTML przed ciekawskimi', '', 96, 99, 'ukrywanie_kodu_html_przed_ciekawskimi', 13, 12, 56, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1087, 'Jak przyspieszyć skrypty PHP? Caching i optymalizacja wydajności', '', 100, 103, 'jak_przyspieszyc_skrypty_php_caching_i_optymalizacja_wydajnosci', 13, 12, 56, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1088, 'Raport: Hosting 2005', '', 34, 47, 'raport_hosting_2005', 11, 56, 56, 14);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1089, 'Regulamin — ważna rzecz', '', 48, 50, 'regulamin_wazna_rzecz', 12, 16, 56, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1090, 'Mity marketingu internetowego w wyszukiwarkach', '', 51, 53, 'mity_marketingu_internetowego_w_wyszukiwarkach', 12, 31, 56, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1091, 'Bądź czujny, szpieg nie śpi', '', 54, 57, 'badz_czujny_szpieg_nie_spi', 2, 4, 56, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1092, 'Bezpieczne ssanie', '', 58, 61, 'bezpieczne_ssanie', 2, 4, 56, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1093, 'Jak zarobić na programach partnerskich?', '', 62, 64, 'jak_zarobic_na_programach_partnerskich', 2, 4, 56, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1094, 'Ach, władcą być!', '', 65, 67, 'ach_wladca_byc', 2, 3, 56, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1095, 'flickr — światowa megagaleria', '', 68, 69, 'flickr_swiatowa_megagaleria', 2, 17, 56, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1096, 'Chcesz studiować? Kliknij tutaj... Internetowa rekrutacja na studia w praktyce', '', 70, 73, 'chcesz_studiowac_kliknij_tutaj_internetowa_rekrutacja_na_studia_w_praktyce', 2, 26, 56, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1097, 'Perspektywy rozwoju e-handlu w Polsce', '', 32, 35, 'perspektywy_rozwoju_e_handlu_w_polsce', 11, 40, 57, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1098, 'Jak małym kosztem otworzyć sklep internetowy?', '', 36, 39, 'jak_malym_kosztem_otworzyc_sklep_internetowy', 11, 40, 57, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1099, 'osCommerce — bezpłatny sklep internetowy', '', 40, 45, 'oscommerce_bezplatny_sklep_internetowy', 11, 40, 57, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1100, 'Reklama pożądaną treścią', '', 46, 48, 'reklama_pozadana_trescia', 12, 31, 57, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1101, 'zoominfo — wyszukiwarka dla kadrowych', '', 49, 51, 'zoominfo_wyszukiwarka_dla_kadrowych', 12, 17, 57, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1102, 'Serce z internetu', '', 52, 55, 'serce_z_internetu', 2, 107, 57, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1103, 'Skrzynka marzeń, czyli darmowe konta e-mail, ale nie w portalach', '', 56, 59, 'skrzynka_marzen_czyli_darmowe_konta_e_mail_ale_nie_w_portalach', 2, 17, 57, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1104, 'Grupy Google — zrób to sam. Poradnik dla początkujących', '', 60, 62, 'grupy_google_zrob_to_sam_poradnik_dla_poczatkujacych', 2, 17, 57, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1105, 'Jaka prezentacja, taka sprzedaż. Szablon aukcji w HTML-u', '', 63, 65, 'jaka_prezentacja_taka_sprzedaz_szablon_aukcji_w_html_u', 2, 4, 57, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1106, 'Kopiowanie inaczej. Udostępniaj pliki przez FTP!', '', 69, 71, 'kopiowanie_inaczej_udostepniaj_pliki_przez_ftp', 2, 93, 57, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1107, 'WiMAXymalna łączność', '', 72, 74, 'wimaxymalna_lacznosc', 2, 24, 57, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1108, 'Kupujemy e-booki', '', 75, 75, 'kupujemy_e_booki', 2, 15, 57, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1109, 'Barometr Internetu', '', 76, 78, 'barometr_internetu13', 2, 73, 57, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1110, 'Sprawdź bezpieczeństwo swojego komputera', '', 79, 81, 'sprawdz_bezpieczenstwo_swojego_komputera', 2, 39, 57, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1111, 'Ludzie, filmy i napisy', '', 82, 83, 'ludzie_filmy_i_napisy', 2, 6, 57, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1112, 'Dungeon Siege II', '', 84, 84, 'dungeon_siege_ii', 2, 75, 57, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1113, 'Painkiller Black Edition', '', 85, 85, 'painkiller_black_edition', 2, 75, 57, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1114, 'Praktyka dla początkujących. część 9: P2P bez tajemnic c.d.', '', 86, 89, 'praktyka_dla_poczatkujacych_czesc_9_p2p_bez_tajemnic_c_d', 2, 72, 57, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1115, 'Tanie gadanie. Przegląd komunikatorów VoIP', '', 90, 95, 'tanie_gadanie_przeglad_komunikatorow_voip', 10, 9, 57, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1116, 'WYSIWYG-owy edytor w JavaScript', '', 99, 101, 'wysiwyg_owy_edytor_w_javascript', 13, 43, 57, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1117, 'Programowanie obiektowe w PHP4 i PHP5, część 1', '', 102, 105, 'programowanie_obiektowe_w_php4_i_php5_czesc_1', 13, 11, 57, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1118, 'Ą, Ś, Ź, czyli polskie ogonki w internecie', '', 106, 109, 'a_s_z_czyli_polskie_ogonki_w_internecie', 13, 12, 57, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1119, 'Elementy div i style CSS w praktyce', '', 110, 113, 'elementy_div_i_style_css_w_praktyce', 13, 12, 57, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1120, 'Tanie telefonowanie', '', 30, 41, 'tanie_telefonowanie', 11, 108, 58, 12);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1121, 'VoIP to dopiero początek', '', 42, 42, 'voip_to_dopiero_poczatek', 11, 109, 58, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1122, 'Jedna stawka na cały świat — 6 gr/min', '', 43, 43, 'jedna_stawka_na_caly_swiat_6_gr_min', 11, 109, 58, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1123, 'I-TELEPIN — nowoczesna i przyjazna telefonia internetowa', '', 44, 44, 'i_telepin_nowoczesna_i_przyjazna_telefonia_internetowa', 11, 109, 58, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1124, 'TELE24 — rewolucja w telekomunikacji', '', 45, 45, 'tele24_rewolucja_w_telekomunikacji', 11, 109, 58, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1125, 'Gdzie kupować w sieci? Ranking polskich sklepów internetowych (branże: komputery, foto, księgarnie)', '', 46, 52, 'gdzie_kupowac_w_sieci_ranking_polskich_sklepow_internetowych_branze_komputery_foto_ksiegarnie', 12, 110, 58, 7);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1126, 'Almanach programów partnerskich', '', 54, 58, 'almanach_programow_partnerskich', 12, 40, 58, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1127, 'Do wyboru, do koloru: domeny internetowe', '', 59, 63, 'do_wyboru_do_koloru_domeny_internetowe', 12, 111, 58, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1128, 'E-booki: nowy biznes internetowy', '', 64, 67, 'e_booki_nowy_biznes_internetowy', 12, 40, 58, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1129, 'Wojna o gigabajty. Google Gmail — już 2,5 GB pojemności i wciąż rośnie!', '', 68, 71, 'wojna_o_gigabajty_google_gmail_juz_2_5_gb_pojemnosci_i_wciaz_rosnie', 2, 17, 58, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1130, 'Fotograficzny skarbiec. Kopalnia darmowych zdjęć nie tylko dla profesjonalistów', '', 72, 74, 'fotograficzny_skarbiec_kopalnia_darmowych_zdjec_nie_tylko_dla_profesjonalistow', 2, 17, 58, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1131, 'Podcasting. Nowe wcielenie radia internetowego', '', 76, 79, 'podcasting_nowe_wcielenie_radia_internetowego', 2, 24, 58, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1132, 'Esencjonalna esensja', 'Z Konradem Węgrowskim, redaktorem naczelnym magazynu internetowego Esensja, rozmawia Patrycja Kierzkowska.', 80, 81, 'esencjonalna_esensja', 2, 6, 58, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1133, 'Praktyka dla początkujących: jak się zabezpieczyć przed spamem? Spamihilator w akcji', '', 82, 85, 'praktyka_dla_poczatkujacych_jak_sie_zabezpieczyc_przed_spamem_spamihilator_w_akcji', 2, 72, 58, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1134, 'FEAR. Strach zagląda głęboko w oczy', '', 86, 86, 'fear_strach_zaglada_gleboko_w_oczy', 2, 75, 58, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1135, 'FIFA 06. Piłka jest okrągła a bramki są dwie', '', 87, 87, 'fifa_06_pilka_jest_okragla_a_bramki_sa_dwie', 2, 75, 58, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1136, 'Barometr Internetu', '', 88, 89, 'barometr_internetu14', 2, 73, 58, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1137, 'Na falach internetu. Przegląd nakładek na strumieniowe odtwarzacze audio-wideo', '', 90, 93, 'na_falach_internetu_przeglad_nakladek_na_strumieniowe_odtwarzacze_audio_wideo', 10, 9, 58, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1138, 'Pierwsze kroki w nauce PHP', '', 97, 101, 'pierwsze_kroki_w_nauce_php', 13, 11, 58, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1139, 'Katalog torrentów w PHP', '', 102, 104, 'katalog_torrentow_w_php', 13, 11, 58, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1140, 'Zrób sobie portal', '', 105, 107, 'zrob_sobie_portal', 13, 12, 58, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1141, 'Gdy skrypt się rozrasta. Ergonomia projektowania i rozbudowywania witryn', '', 108, 113, 'gdy_skrypt_sie_rozrasta_ergonomia_projektowania_i_rozbudowywania_witryn', 13, 12, 58, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1142, 'Gdzie kupować w sieci? Najlepsze polskie sklepy internetowe. Branża: RTV, AGD', '', 20, 23, 'gdzie_kupowac_w_sieci_najlepsze_polskie_sklepy_internetowe_branza_rtv_agd', 14, 112, 59, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1143, 'Kto szuka, nie błądzi...', '', 24, 31, 'kto_szuka_nie_bladzi', 11, 113, 59, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1144, 'Darmowe szkolenia internetowe', '', 32, 34, 'darmowe_szkolenia_internetowe', 15, 46, 59, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1145, 'Wielka kolonizacja? Wirtualne państwa podbijaja internet', '', 35, 37, 'wielka_kolonizacja_wirtualne_panstwa_podbijaja_internet', 16, 114, 59, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1146, 'Jak zbudowano www.tunetribe.com', '', 38, 39, 'jak_zbudowano_www_tunetribe_com', 17, 115, 59, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1147, 'Przepis na idealny newsletter', '', 40, 43, 'przepis_na_idealny_newsletter', 18, 116, 59, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1148, 'Monitoring serwerów internetowych', '', 44, 47, 'monitoring_serwerow_internetowych', 19, 32, 59, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1149, 'Kryminalizacja internetu. Rozmowa', '', 48, 51, 'kryminalizacja_internetu_rozmowa', 20, 117, 59, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1150, 'Barometr Internetu', '', 60, 61, 'barometr_internetu15', 2, 73, 59, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1151, 'Praktyka dla początkujących. Kanały RSS w Outlook Expressie', '', 66, 69, 'praktyka_dla_poczatkujacych_kanaly_rss_w_outlook_expressie', 21, 118, 59, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1152, 'Firefox. Eksplozja możliwości', '', 70, 71, 'firefox_eksplozja_mozliwosci', 21, 119, 59, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1153, 'Zakładkowy galimatias. Ulubione pod specjalnym nadzorem', '', 76, 79, 'zakladkowy_galimatias_ulubione_pod_specjalnym_nadzorem', 10, 9, 59, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1154, 'Flock na warsztacie', '', 80, 81, 'flock_na_warsztacie', 10, 120, 59, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1155, 'HTML i formatowanie tekstu', '', 83, 87, 'html_i_formatowanie_tekstu', 13, 83, 59, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1156, 'GIMP i webmastering. Fotograficzne laboratorium GIMP-a', '', 88, 92, 'gimp_i_webmastering_fotograficzne_laboratorium_gimp_a', 13, 121, 59, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1157, 'Wizualne projektowanie baz danych', '', 93, 95, 'wizualne_projektowanie_baz_danych', 13, 122, 59, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1158, 'Bierz przykład z najlepszych: Adobe.com', '', 96, 97, 'bierz_przyklad_z_najlepszych_adobe_com', 13, 123, 59, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1159, 'Efekt okrągłych narożników. Tworzymy nietypową ramkę w CSS', '', 98, 102, 'efekt_okraglych_naroznikow_tworzymy_nietypowa_ramke_w_css', 13, 96, 59, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1160, 'PHP: algorytm dla twojej wyszukiwarki', '', 103, 105, 'php_algorytm_dla_twojej_wyszukiwarki', 13, 11, 59, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1161, 'Bezpłatne edytory WYSIWYG', '', 106, 109, 'bezplatne_edytory_wysiwyg', 13, 124, 59, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1162, 'W drodze do perfekcji', '', 110, 111, 'w_drodze_do_perfekcji', 13, 125, 59, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1163, 'Gdzie kupować w sieci? Najlepsze polskie sklepy internetowe. Branża: Zdrowie i uroda', '', 18, 18, 'gdzie_kupowac_w_sieci_najlepsze_polskie_sklepy_internetowe_branza_zdrowie_i_uroda', 14, 112, 60, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1164, 'Wirtualne banki, realne oszczędności', '', 22, 31, 'wirtualne_banki_realne_oszczednosci', 11, 126, 60, 10);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1165, 'Niech gra muzyka', '', 34, 38, 'niech_gra_muzyka', 22, 127, 60, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1166, 'Writely. Edytor online', '', 40, 43, 'writely_edytor_online', 23, 128, 60, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1167, 'Domena na wagę złota. Jaką nazwę wybrać, jak się zabezpieczyć przed utratą, jak przejąć od kogoś domenę?', '', 44, 45, 'domena_na_wage_zlota_jaka_nazwe_wybrac_jak_sie_zabezpieczyc_przed_utrata_jak_przejac_od_kogos_domene', 18, 111, 60, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1168, 'Domeny — porady rejestratora. Rozmowa', '', 46, 47, 'domeny_porady_rejestratora_rozmowa', 18, 111, 60, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1169, 'Zagubieni w przestrzeni', '', 48, 51, 'zagubieni_w_przestrzeni', 23, 129, 60, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1170, 'Jak zbudowano Marvel.co.uk', '', 52, 53, 'jak_zbudowano_marvel_co_uk', 24, 130, 60, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1171, 'Dynamiczny DNS. Jak uruchomić serwer dysponując łączem o zmiennym IP?', '', 54, 57, 'dynamiczny_dns_jak_uruchomic_serwer_dysponujac_laczem_o_zmiennym_ip', 25, 131, 60, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1172, 'Barometr Internetu', '', 64, 65, 'barometr_internetu16', 2, 73, 60, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1173, 'Praktyka dla początkujących. Kanały RSS w Thunderbirdzie', '', 70, 72, 'praktyka_dla_poczatkujacych_kanaly_rss_w_thunderbirdzie', 21, 132, 60, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1174, 'Pierwsze śliwki robaczywki', '', 73, 73, 'pierwsze_sliwki_robaczywki', 26, 32, 60, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1175, 'Zakładki Firefoxa', '', 74, 75, 'zakladki_firefoxa', 21, 119, 60, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1176, 'W kleszczach kompresora. Przegląd narzędzi do kompresji i dekompresji plików.', '', 80, 83, 'w_kleszczach_kompresora_przeglad_narzedzi_do_kompresji_i_dekompresji_plikow', 10, 9, 60, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1177, 'Płatne i darmowe edytory PHP', '', 84, 87, 'platne_i_darmowe_edytory_php', 10, 9, 60, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1178, 'Galeria internetowa w 5 minut. IfranView w roli „galernika”', '', 88, 89, 'galeria_internetowa_w_5_minut_ifranview_w_roli_galernika', 10, 120, 60, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1179, 'Okiełznać style. Wprowadzenie do CSS', '', 91, 95, 'okielznac_style_wprowadzenie_do_css', 13, 96, 60, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1180, 'Bierz przykład z najlepszych: Prawo.vagla.pl', '', 96, 97, 'bierz_przyklad_z_najlepszych_prawo_vagla_pl', 13, 123, 60, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1181, 'Wypunktować tekst w HTML-u', '', 98, 101, 'wypunktowac_tekst_w_html_u', 13, 83, 60, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1182, 'Projektowanie baz danych w praktyce. Muzyka rockowa.', '', 102, 105, 'projektowanie_baz_danych_w_praktyce_muzyka_rockowa', 13, 122, 60, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1183, 'GIMP i webmastering. Kopiuj-wklej, czyli kompozycje wielowarstwowe', '', 106, 109, 'gimp_i_webmastering_kopiuj_wklej_czyli_kompozycje_wielowarstwowe', 13, 121, 60, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1184, 'Antykwariat online', '', 110, 111, 'antykwariat_online', 13, 125, 60, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1185, 'Gdzie kupować w sieci? Najlepsze polskie sklepy internetowe. Branża: sport i turystyka', '', 18, 18, 'gdzie_kupowac_w_sieci_najlepsze_polskie_sklepy_internetowe_branza_sport_i_turystyka', 14, 112, 61, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1186, 'Bezpieczny PC. Zabezpiecz komputer przed atakami z sieci', '', 22, 27, 'bezpieczny_pc_zabezpiecz_komputer_przed_atakami_z_sieci', 11, 133, 61, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1187, 'Skanerem go! Przegląd programów antywirusowych', '', 28, 30, 'skanerem_go_przeglad_programow_antywirusowych', 11, 133, 61, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1188, 'Telewizja internetowa', '', 32, 35, 'telewizja_internetowa', 15, 134, 61, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1189, 'Tanie latanie, szybkie rezerwowanie. Czyli jak kupować bilety lotnicze w internecie', '', 36, 39, 'tanie_latanie_szybkie_rezerwowanie_czyli_jak_kupowac_bilety_lotnicze_w_internecie', 15, 135, 61, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1190, 'XmailHardDrive. Dysk na Google', '', 40, 42, 'xmailharddrive_dysk_na_google', 22, 136, 61, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1191, 'Od zera do v-bohatera. Jak rozwinąć żagle w wirtualnym świecie?', '', 43, 45, 'od_zera_do_v_bohatera_jak_rozwinac_zagle_w_wirtualnym_swiecie', 16, 114, 61, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1192, 'Jak podzielić neostradę?', '', 46, 49, 'jak_podzielic_neostrade', 25, 4, 61, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1193, 'Bitwa o obraz. Część I: jak zmusić film do współpracy?', '', 50, 53, 'bitwa_o_obraz_czesc_i_jak_zmusic_film_do_wspolpracy', 27, 4, 61, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1194, 'Jak zbudowano uefa.com', '', 58, 59, 'jak_zbudowano_uefa_com', 24, 130, 61, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1195, 'FRITZ!Box Fon WLAN', '', 60, 61, 'fritz_box_fon_wlan', 28, 137, 61, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1196, 'Nietoperz i kanały RSS', '', 72, 73, 'nietoperz_i_kanaly_rss', 21, 101, 61, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1197, 'Ściśle tajne łamane przez poufne. Ekspresowy kurs szyfrowania poczty', '', 74, 76, 'scisle_tajne_lamane_przez_poufne_ekspresowy_kurs_szyfrowania_poczty', 21, 138, 61, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1198, 'Internet Explorer 7 Beta 2', '', 80, 81, 'internet_explorer_7_beta_2', 10, 139, 61, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1199, 'Gadaj zdrów. Przegląd najpopularniejszych komunikatorów', '', 84, 86, 'gadaj_zdrow_przeglad_najpopularniejszych_komunikatorow', 10, 9, 61, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1200, 'HTML: nagłówki, akapity i bloki', '', 89, 91, 'html_naglowki_akapity_i_bloki', 13, 83, 61, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1201, 'Bierz przykład z najlepszych: stock.xchng', '', 92, 93, 'bierz_przyklad_z_najlepszych_stock_xchng', 13, 123, 61, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1202, 'phpMyAdmin: edycja zawartości bazy danych', '', 94, 97, 'phpmyadmin_edycja_zawartosci_bazy_danych', 13, 122, 61, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1203, 'GIMP i webmastering. Projekt witryny', '', 98, 101, 'gimp_i_webmastering_projekt_witryny', 13, 121, 61, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1204, 'Okiełznać style. Formatowanie tekstu', '', 102, 105, 'okielznac_style_formatowanie_tekstu', 13, 96, 61, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1205, 'AJAX, czyli aplikacje dla WWW', '', 106, 107, 'ajax_czyli_aplikacje_dla_www', 13, 24, 61, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1206, 'Sieciowe aplikacje — pożyteczne dodatki', '', 108, 111, 'sieciowe_aplikacje_pozyteczne_dodatki', 13, 12, 61, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1207, 'Rythmology', '', 112, 113, 'rythmology', 13, 125, 61, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1208, 'Gdzie kupować w sieci? Najlepsze polskie sklepy internetowe. Branża: zegarki i biżuteria', '', 18, 18, 'gdzie_kupowac_w_sieci_najlepsze_polskie_sklepy_internetowe_branza_zegarki_i_bizuteria', 14, 112, 62, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1209, 'Wszystkie drogi prowadzą do sieci', '', 24, 32, 'wszystkie_drogi_prowadza_do_sieci', 11, 92, 62, 9);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1210, 'Digg kopalnia informacji', '', 34, 35, 'digg_kopalnia_informacji', 29, 140, 62, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1211, 'Nie daj się złowić! Co to jest phishing? Jak się przed nim bronić?', '', 36, 39, 'nie_daj_sie_zlowic_co_to_jest_phishing_jak_sie_przed_nim_bronic', 20, 4, 62, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1212, 'Pokaż, gdzie mieszkasz, czyli mapa użytkowników Jabbera', '', 40, 41, 'pokaz_gdzie_mieszkasz_czyli_mapa_uzytkownikow_jabbera', 30, 141, 62, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1213, 'Atak klonów', '', 42, 44, 'atak_klonow', 24, 5, 62, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1214, 'Jak zbudowano Selfridges.com', '', 46, 47, 'jak_zbudowano_selfridges_com', 24, 142, 62, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1215, 'Trendy w projektowaniu stron w 2006', '', 48, 51, 'trendy_w_projektowaniu_stron_w_2006', 24, 5, 62, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1216, 'Bitwa o obraz. Część II: skąd się biorą rzadkie przypadki i nie tylko!', '', 54, 57, 'bitwa_o_obraz_czesc_ii_skad_sie_biora_rzadkie_przypadki_i_nie_tylko', 27, 4, 62, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1217, 'Na zdrowie?', '', 58, 59, 'na_zdrowie', 31, 143, 62, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1218, 'Tworzymy plan projektu', '', 60, 63, 'tworzymy_plan_projektu', 12, 144, 62, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1219, 'Co dalej z mks_virem?', '', 64, 65, 'co_dalej_z_mks_virem', 32, 32, 62, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1220, 'Antywirus w praktyce', '', 72, 73, 'antywirus_w_praktyce', 21, 145, 62, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1221, 'Galernik. Najlepszy do galerii', '', 74, 75, 'galernik_najlepszy_do_galerii', 21, 146, 62, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1222, 'Coreeditor 1', '', 82, 83, 'coreeditor_1', 10, 139, 62, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1223, 'Opera 9 Technology Preview 2', '', 84, 85, 'opera_9_technology_preview_2', 10, 139, 62, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1224, 'Polowanie na duchy, czyli dekonspirujemy rootkita', '', 88, 89, 'polowanie_na_duchy_czyli_dekonspirujemy_rootkita', 10, 9, 62, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1225, 'HTML i tabele', '', 91, 93, 'html_i_tabele', 13, 83, 62, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1226, 'GIMP i webmastering. Nagłówki stron WWW', '', 94, 97, 'gimp_i_webmastering_naglowki_stron_www', 13, 121, 62, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1227, 'Bierz przykład z najlepszych: GAP.com', '', 98, 99, 'bierz_przyklad_z_najlepszych_gap_com', 13, 123, 62, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1228, 'Okiełznać style. Formatowanie obrazów, marginesy, tła i obramowania', '', 100, 103, 'okielznac_style_formatowanie_obrazow_marginesy_tla_i_obramowania', 13, 96, 62, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1229, 'Wypełnianie bezy rekordami na podstawie plików tekstowych', '', 104, 107, 'wypelnianie_bezy_rekordami_na_podstawie_plikow_tekstowych', 13, 122, 62, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1230, 'Inspektor DOM, czyli jak analizować strony WWW', '', 108, 109, 'inspektor_dom_czyli_jak_analizowac_strony_www', 13, 147, 62, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1231, 'Testy na prawo jazdy', '', 110, 111, 'testy_na_prawo_jazdy', 13, 125, 62, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1232, 'Gdzie kupować w sieci? Najlepsze polskie sklepy internetowe. Branża: hobby', '', 18, 18, 'gdzie_kupowac_w_sieci_najlepsze_polskie_sklepy_internetowe_branza_hobby', 14, 112, 63, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1233, 'Domenowe ABC. Wszystko co chciałbyć wiedzieć o domenach, ale nie masz kogo spytać.', '', 24, 27, 'domenowe_abc_wszystko_co_chcialbyc_wiedziec_o_domenach_ale_nie_masz_kogo_spytac', 11, 111, 63, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1234, 'Gdzie zarejestrować domenę internetową?', '', 28, 31, 'gdzie_zarejestrowac_domene_internetowa', 11, 111, 63, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1235, 'Rejestrujemy domenę', '', 32, 33, 'rejestrujemy_domene', 11, 111, 63, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1236, '25 bezpłatnych narzędzi do projektowania', '', 34, 39, '25_bezplatnych_narzedzi_do_projektowania', 29, 148, 63, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1237, 'Google Analitycs', '', 40, 41, 'google_analitycs', 29, 149, 63, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1238, 'Sukces CSS', '', 42, 45, 'sukces_css', 24, 5, 63, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1239, 'Jak zbudowano Boreme.com', '', 46, 47, 'jak_zbudowano_boreme_com', 24, 142, 63, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1240, 'W poszukiwaniu wartościowych blogów', '', 48, 49, 'w_poszukiwaniu_wartosciowych_blogow', 33, 150, 63, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1241, 'del.icio.us: 15 skamowitych przeróbek', '', 50, 53, 'del_icio_us_15_skamowitych_przerobek', 33, 151, 63, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1242, 'Bitwa o obraz. Część III: czyste niebo', '', 54, 59, 'bitwa_o_obraz_czesc_iii_czyste_niebo', 34, 152, 63, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1243, 'Google Polska: przede wszystkim zadowolenie użytkowników', '', 60, 61, 'google_polska_przede_wszystkim_zadowolenie_uzytkownikow', 32, 32, 63, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1244, 'Fałszywe programy antyszpiegowskie', '', 68, 70, 'falszywe_programy_antyszpiegowskie', 21, 39, 63, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1245, 'Firefox 2 Bon Echo Alpha 1', '', 78, 79, 'firefox_2_bon_echo_alpha_1', 10, 139, 63, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1246, 'E-mail pod kontrolą. Porównanie programów pocztowych', '', 82, 87, 'e_mail_pod_kontrola_porownanie_programow_pocztowych', 10, 9, 63, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1247, 'HTML: zaawansowane możliwości tabel', '', 89, 91, 'html_zaawansowane_mozliwosci_tabel', 13, 83, 63, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1248, 'Układ stałej szerokości', '', 92, 93, 'uklad_stalej_szerokosci', 13, 83, 63, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1249, 'GIMP i webmastering', '', 94, 97, 'gimp_i_webmastering', 13, 121, 63, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1250, 'Bierz przykład z najlepszych: IMDb.com', '', 98, 99, 'bierz_przyklad_z_najlepszych_imdb_com', 13, 123, 63, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1251, 'PEAR::DB — interfejs API dostępu do bazy danych', '', 100, 101, 'pear_db_interfejs_api_dostepu_do_bazy_danych', 13, 122, 63, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1252, 'Okiełznać style. Formatowanie tabel i formularzy', '', 102, 105, 'okielznac_style_formatowanie_tabel_i_formularzy', 13, 96, 63, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1253, 'Strona na zawołanie', '', 106, 109, 'strona_na_zawolanie', 13, 153, 63, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1254, 'Mapy na nowo', '', 110, 111, 'mapy_na_nowo', 13, 125, 63, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1255, 'Gdzie kupować w sieci? Najlepsze polskie sklepy internetowe. Branża: odzież i dodatki', '', 18, 18, 'gdzie_kupowac_w_sieci_najlepsze_polskie_sklepy_internetowe_branza_odziez_i_dodatki', 14, 112, 64, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1256, 'Aukcje internetowe od podstaw. Serwisy aukcyjne w Polsce', '', 24, 28, 'aukcje_internetowe_od_podstaw_serwisy_aukcyjne_w_polsce', 11, 154, 64, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1257, 'Płacić, nie płacić? E-aukcje i podatki', '', 29, 30, 'placic_nie_placic_e_aukcje_i_podatki', 11, 154, 64, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1258, 'Pierwsze kroki w Allegro.pl', '', 31, 34, 'pierwsze_kroki_w_allegro_pl', 11, 154, 64, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1259, 'Pierwsze kroki w eBay.pl', '', 35, 37, 'pierwsze_kroki_w_ebay_pl', 11, 154, 64, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1260, 'Zostań milionerem! Jak zarabiać na własnej stronie WWW?', '', 38, 43, 'zostan_milionerem_jak_zarabiac_na_wlasnej_stronie_www', 35, 4, 64, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1261, 'PCLab.pl — poważny rywal prasy drukowanej?', '', 44, 47, 'pclab_pl_powazny_rywal_prasy_drukowanej', 35, 155, 64, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1262, 'Wstęp tylko za zaproszeniem', '', 48, 51, 'wstep_tylko_za_zaproszeniem', 16, 156, 64, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1263, 'Szkoła filmowa', '', 52, 55, 'szkola_filmowa', 34, 157, 64, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1264, 'Jak zbudowano Harveynichols.com', '', 56, 57, 'jak_zbudowano_harveynichols_com', 24, 142, 64, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1265, 'NETVIBES Nowoczesna strona startowa', '', 58, 59, 'netvibes_nowoczesna_strona_startowa', 33, 158, 64, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1266, 'Tworzymy skróty', '', 60, 61, 'tworzymy_skroty', 29, 159, 64, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1267, 'ArcaBit zmaga się z wirusami i konkurencją', '', 62, 63, 'arcabit_zmaga_sie_z_wirusami_i_konkurencja', 32, 32, 64, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1268, 'Jak wyciąć z filmu ścieżkę dźwiękową?', '', 70, 71, 'jak_wyciac_z_filmu_sciezke_dzwiekowa', 21, 160, 64, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1269, 'Konwertowanie plików dźwiękowych', '', 72, 75, 'konwertowanie_plikow_dzwiekowych', 21, 161, 64, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1270, 'Wielki brat patrzy. Zdalne monitorowanie obiektów', '', 84, 87, 'wielki_brat_patrzy_zdalne_monitorowanie_obiektow', 10, 9, 64, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1271, 'Po pierwsze: bezpieczeństwo', '', 89, 89, 'po_pierwsze_bezpieczenstwo', 32, 32, 64, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1272, 'Bierz przykład z najlepszych: Technorati.com', '', 90, 91, 'bierz_przyklad_z_najlepszych_technorati_com', 13, 123, 64, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1273, 'HTML: obrazki i odnośniki', '', 92, 93, 'html_obrazki_i_odnosniki', 13, 83, 64, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1274, 'Efekt rollover w oparciu o elementy div i style CSS', '', 94, 97, 'efekt_rollover_w_oparciu_o_elementy_div_i_style_css', 13, 83, 64, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1275, 'GIMP i webmastering. Przygotowywanie obrazów do efektu rollover', '', 98, 101, 'gimp_i_webmastering_przygotowywanie_obrazow_do_efektu_rollover', 13, 121, 64, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1276, 'Okiełznać style. Nawigacja', '', 102, 105, 'okielznac_style_nawigacja', 13, 96, 64, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1277, 'Bazy danych, szablony i surowe tablice', '', 106, 109, 'bazy_danych_szablony_i_surowe_tablice', 13, 122, 64, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1278, 'Porządki w RoboMilk', '', 110, 111, 'porzadki_w_robomilk', 13, 125, 64, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1279, 'Gdzie kupować w sieci? Najlepsze polskie sklepy internetowe. Branża: motoryzacja i warsztat', '', 18, 18, 'gdzie_kupowac_w_sieci_najlepsze_polskie_sklepy_internetowe_branza_motoryzacja_i_warsztat', 14, 112, 65, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1280, 'Internetowe fotolaby. Przegląd ofert, porównanie cen, fotogadżety', '', 22, 33, 'internetowe_fotolaby_przeglad_ofert_porownanie_cen_fotogadzety', 11, 162, 65, 12);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1281, 'Liczą się strony, które robią wrażenie', '', 34, 39, 'licza_sie_strony_ktore_robia_wrazenie', 24, 163, 65, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1282, 'Jak zbudowano Havenholidays.com', '', 40, 41, 'jak_zbudowano_havenholidays_com', 24, 142, 65, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1283, 'Open source, pudełko czy własne skrypty? Poznaj różne systemy e-commerce i wybierz najlepszy dla siebie', '', 44, 49, 'open_source_pudelko_czy_wlasne_skrypty_poznaj_rozne_systemy_e_commerce_i_wybierz_najlepszy_dla_siebie', 36, 93, 65, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1284, 'Podziel się plikami. Przegląd serwisów oferujących bezpłatny hosting plików', '', 50, 52, 'podziel_sie_plikami_przeglad_serwisow_oferujacych_bezplatny_hosting_plikow', 25, 164, 65, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1285, 'Pozycjonowanie stron w wyszukiwarkach. Część 1', '', 53, 55, 'pozycjonowanie_stron_w_wyszukiwarkach_czesc_1', 37, 165, 65, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1286, 'Gadające głowy', '', 56, 61, 'gadajace_glowy', 38, 166, 65, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1287, 'Lepsze blogi. Wyjść poza standard', '', 62, 65, 'lepsze_blogi_wyjsc_poza_standard', 39, 4, 65, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1288, 'Phishing na celowniku policji', '', 66, 67, 'phishing_na_celowniku_policji', 40, 167, 65, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1289, 'Szybciej za tyle samo. Jak przyspieszyć łącze internetowe?', '', 74, 77, 'szybciej_za_tyle_samo_jak_przyspieszyc_lacze_internetowe', 21, 168, 65, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1290, 'Norton Save &amp; Restore', '', 84, 84, 'norton_save_amp_restore', 10, 139, 65, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1291, 'Skype 2.5 beta', '', 85, 85, 'skype_2_5_beta', 10, 139, 65, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1292, 'Programowanie w PHP: najważniejsza jest staranność', '', 89, 89, 'programowanie_w_php_najwazniejsza_jest_starannosc', 32, 32, 65, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1293, 'Przedruk, cytat, linking, czyli co wolno webmasterowi', '', 90, 91, 'przedruk_cytat_linking_czyli_co_wolno_webmasterowi', 13, 16, 65, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1294, 'Bierz przykład z najlepszych: Dziennik Internautów', '', 92, 93, 'bierz_przyklad_z_najlepszych_dziennik_internautow', 13, 123, 65, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1295, 'HTML: formularze', '', 94, 97, 'html_formularze', 13, 83, 65, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1296, 'HTML czy XHTML? Część 1', '', 98, 100, 'html_czy_xhtml_czesc_1', 13, 99, 65, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1297, 'GIMP i webmastering. Baner witryny 33 i 1/3', '', 102, 105, 'gimp_i_webmastering_baner_witryny_33_i_1_3', 13, 121, 65, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1298, 'Następny, poprzedni, czyli o przewijaniu zawartości witryny WWW', '', 106, 109, 'nastepny_poprzedni_czyli_o_przewijaniu_zawartosci_witryny_www', 13, 122, 65, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1299, 'Randka po irlandzku', '', 110, 111, 'randka_po_irlandzku', 13, 125, 65, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1300, 'Gdzie kupować w sieci? Najlepsze polskie sklepy internetowe. Branża: dom i wnętrze', '', 18, 18, 'gdzie_kupowac_w_sieci_najlepsze_polskie_sklepy_internetowe_branza_dom_i_wnetrze', 14, 112, 66, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1301, 'Muzyka online. Jak kupować, to tylko w internecie!', '', 22, 23, 'muzyka_online_jak_kupowac_to_tylko_w_internecie', 41, 169, 66, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1302, 'Gdzie kupować? Przegląd polskich e-sklepów z legalna muzyką', '', 24, 27, 'gdzie_kupowac_przeglad_polskich_e_sklepow_z_legalna_muzyka', 41, 169, 66, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1303, 'Jak kupować?', '', 28, 30, 'jak_kupowac', 41, 169, 66, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1304, 'Jabber od A do Z', '', 32, 35, 'jabber_od_a_do_z', 42, 93, 66, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1305, 'Jak zostać cesarzem. Poradnik dla tworzących wirtualne państwa', '', 36, 39, 'jak_zostac_cesarzem_poradnik_dla_tworzacych_wirtualne_panstwa', 43, 114, 66, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1306, 'Firefox może więcej. Przegląd najciekawszych rozszerzeń', '', 40, 43, 'firefox_moze_wiecej_przeglad_najciekawszych_rozszerzen', 25, 170, 66, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1307, 'Pobudzić ruch na stronie', '', 44, 47, 'pobudzic_ruch_na_stronie', 25, 171, 66, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1308, 'Budujemy serwis randkowy', '', 48, 52, 'budujemy_serwis_randkowy', 25, 172, 66, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1309, 'Ochronić serwis', '', 54, 56, 'ochronic_serwis', 25, 39, 66, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1310, 'Linkologia, czyli delicje po polsku', '', 58, 59, 'linkologia_czyli_delicje_po_polsku', 25, 173, 66, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1311, 'Listy zadań online', '', 60, 62, 'listy_zadan_online', 25, 173, 66, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1312, 'Pozycjonowanie stron w wyszukiwarkach. Część 2', '', 63, 65, 'pozycjonowanie_stron_w_wyszukiwarkach_czesc_2', 37, 165, 66, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1313, 'Kalendarz online', '', 66, 67, 'kalendarz_online', 15, 174, 66, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1314, 'Windows Vista Beta 2', '', 80, 81, 'windows_vista_beta_2', 10, 139, 66, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1315, 'W poszukiwaniu błędów. Przegląd aplikacji do generowania i sprawdzania sum kontrolnych', '', 84, 85, 'w_poszukiwaniu_bledow_przeglad_aplikacji_do_generowania_i_sprawdzania_sum_kontrolnych', 10, 9, 66, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1316, 'PHP profesjonalnie: programowanie obiektowe i narzędzia programisty', '', 87, 87, 'php_profesjonalnie_programowanie_obiektowe_i_narzedzia_programisty', 32, 32, 66, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1317, 'Bierz przykład z najlepszych: YouTube.com', '', 88, 89, 'bierz_przyklad_z_najlepszych_youtube_com', 13, 123, 66, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1318, 'Bunchball — gry na każdą stronę', '', 90, 91, 'bunchball_gry_na_kazda_strone', 13, 4, 66, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1319, 'HTML czy XHTML? Część 2', '', 92, 94, 'html_czy_xhtml_czesc_2', 13, 99, 66, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1320, 'HTML: ramki', '', 95, 97, 'html_ramki', 13, 83, 66, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1321, 'GIMP i webmastering. Obrysowanie menu przy użyciu ścieżek', '', 98, 101, 'gimp_i_webmastering_obrysowanie_menu_przy_uzyciu_sciezek', 13, 121, 66, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1322, 'Walidacja zmiennych w aplikacji publikującej zawartość bazy danych', '', 102, 105, 'walidacja_zmiennych_w_aplikacji_publikujacej_zawartosc_bazy_danych', 13, 122, 66, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1323, 'Okiełznać style. Kompatybilność', '', 106, 109, 'okielznac_style_kompatybilnosc', 13, 96, 66, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1324, 'Kryzys tożsamości', '', 110, 111, 'kryzys_tozsamosci', 13, 125, 66, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1325, 'Gdzie kupować w sieci? Najlepsze polskie sklepy internetowe. Branża: kwiaty i ogród', '', 18, 18, 'gdzie_kupowac_w_sieci_najlepsze_polskie_sklepy_internetowe_branza_kwiaty_i_ogrod', 14, 112, 67, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1326, 'Twoja firma w internecie. Wybór wykonawcy', '', 22, 27, 'twoja_firma_w_internecie_wybor_wykonawcy', 11, 175, 67, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1327, 'Zadbajmy o naszą witrynę', '', 29, 29, 'zadbajmy_o_nasza_witryne', 11, 175, 67, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1328, 'Serwis dostępny', '', 34, 39, 'serwis_dostepny', 16, 5, 67, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1329, 'Zhakowani', '', 40, 41, 'zhakowani', 16, 176, 67, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1330, 'Kreatory stron WWW', '', 42, 45, 'kreatory_stron_www', 25, 173, 67, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1331, 'Interaktywny kalendarz na witrynie', '', 46, 50, 'interaktywny_kalendarz_na_witrynie', 25, 173, 67, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1332, 'Freedo style. Prosty sposób na kopiowanie RSS-ów', '', 52, 53, 'freedo_style_prosty_sposob_na_kopiowanie_rss_ow', 25, 173, 67, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1333, 'Projektowanie WWW. 20 sztuczek profesjonalistów', '', 54, 57, 'projektowanie_www_20_sztuczek_profesjonalistow', 5, 177, 67, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1334, 'Przetwarzanie rozproszone. Jak z pożytkiem wykorzystać moc obliczeniową komputera', '', 58, 61, 'przetwarzanie_rozproszone_jak_z_pozytkiem_wykorzystac_moc_obliczeniowa_komputera', 15, 178, 67, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1335, '(Nie)bezpieczne pogawędki przez internet', '', 62, 63, 'nie_bezpieczne_pogawedki_przez_internet', 42, 39, 67, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1336, 'Jak zbudowano McDonaldsMenu.info', '', 64, 65, 'jak_zbudowano_mcdonaldsmenu_info', 35, 142, 67, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1337, 'Od e-zinu do e-biznesu?', '', 66, 69, 'od_e_zinu_do_e_biznesu', 43, 179, 67, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1338, 'Praktyka dla początkujących. Jak szybciej pobierać pliki?', '', 76, 79, 'praktyka_dla_poczatkujacych_jak_szybciej_pobierac_pliki', 21, 180, 67, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1339, 'Beniamin. Nowy obrońca przed niepożądanymi treściami w internecie', '', 86, 87, 'beniamin_nowy_obronca_przed_niepozadanymi_tresciami_w_internecie', 10, 139, 67, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1340, 'Sortowanie danych względem dowolnych kolumn', '', 91, 93, 'sortowanie_danych_wzgledem_dowolnych_kolumn', 13, 122, 67, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1341, 'Bierz przykład z najlepszych: TheTarPit', '', 94, 95, 'bierz_przyklad_z_najlepszych_thetarpit', 13, 123, 67, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1342, 'Okiełznać style. Obsługa mediów', '', 96, 99, 'okielznac_style_obsluga_mediow', 13, 96, 67, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1343, 'GIMP i webmastering. Wielopunktowe rollovery', '', 100, 103, 'gimp_i_webmastering_wielopunktowe_rollovery', 13, 121, 67, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1344, 'HTML czy XHTML? Część 3', '', 104, 105, 'html_czy_xhtml_czesc_3', 13, 99, 67, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1345, 'HTML: mapy odsyłaczy i osadzanie skryptów', '', 106, 108, 'html_mapy_odsylaczy_i_osadzanie_skryptow', 13, 83, 67, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1346, 'Szpiegowanie na sprzedaż', '', 110, 111, 'szpiegowanie_na_sprzedaz', 13, 125, 67, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1347, 'Najlepsze polskie sklepy internetowe. Branża: delikatesy', '', 18, 18, 'najlepsze_polskie_sklepy_internetowe_branza_delikatesy', 14, 112, 68, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1348, 'Telefonia VoIP', '', 22, 33, 'telefonia_voip2', 11, 108, 68, 12);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1349, 'Zostań gwiazdą internetu! Jak publikować w sieci własne nagrania video', '', 34, 37, 'zostan_gwiazda_internetu_jak_publikowac_w_sieci_wlasne_nagrania_video', 25, 173, 68, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1350, 'Wszystko da się wysłać. YouSendIt. Sposób na duże pliki.', '', 38, 39, 'wszystko_da_sie_wyslac_yousendit_sposob_na_duze_pliki', 25, 173, 68, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1351, 'GoldenLine.pl Wirtualna droga do realnej kariery', '', 40, 41, 'goldenline_pl_wirtualna_droga_do_realnej_kariery', 25, 173, 68, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1352, 'Aukcyjne snajpery', '', 42, 45, 'aukcyjne_snajpery', 25, 181, 68, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1353, 'Thunderbird i jego piórka. Przegląd najciekawszych rozszerzeń', '', 46, 48, 'thunderbird_i_jego_piorka_przeglad_najciekawszych_rozszerzen', 25, 182, 68, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1354, 'Prawdziwe Web 2.0', '', 49, 51, 'prawdziwe_web_2_0', 23, 5, 68, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1355, 'Jak zbudowano www.ask.com', '', 52, 53, 'jak_zbudowano_www_ask_com', 35, 142, 68, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1356, 'Galaktyczne podboje', '', 54, 56, 'galaktyczne_podboje', 43, 183, 68, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1357, 'Praktyka dla początkujących. Usprawniamy Neostradę. Łączenie bez aplikacji dostępowej TP', '', 66, 68, 'praktyka_dla_poczatkujacych_usprawniamy_neostrade_laczenie_bez_aplikacji_dostepowej_tp', 21, 184, 68, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1358, 'Patrz i słuchaj. Przegląd aplikacji do obsługi podcastów', '', 78, 81, 'patrz_i_sluchaj_przeglad_aplikacji_do_obslugi_podcastow', 10, 9, 68, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1359, 'Instalujemy lokalny serwer testowy', '', 83, 85, 'instalujemy_lokalny_serwer_testowy', 13, 12, 68, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1360, 'Yahoo! Photos', '', 86, 87, 'yahoo_photos', 13, 123, 68, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1361, 'HTML: umieszczamy stronę na serwerze', '', 88, 89, 'html_umieszczamy_strone_na_serwerze', 13, 83, 68, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1362, 'Okiełznać style: ogród zen', '', 90, 93, 'okielznac_style_ogrod_zen', 13, 96, 68, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1363, 'Najlepsze wtyczki do Firefoksa', '', 94, 97, 'najlepsze_wtyczki_do_firefoksa', 13, 185, 68, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1364, 'Dwupunktowe rollovery ze wskaźnikiem wybranej opcji', '', 98, 101, 'dwupunktowe_rollovery_ze_wskaznikiem_wybranej_opcji', 13, 186, 68, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1365, 'GIMP i webmastering. Efekt rollover ze wskaźnikiem wybranej opcji', '', 102, 105, 'gimp_i_webmastering_efekt_rollover_ze_wskaznikiem_wybranej_opcji', 13, 121, 68, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1366, 'Bazy danych: aktywne rekordy', '', 106, 109, 'bazy_danych_aktywne_rekordy', 13, 122, 68, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1367, 'www.upsu.com', '', 110, 111, 'www_upsu_com', 13, 125, 68, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1368, 'Najlepsze polskie sklepy internetowe', 'Hobby to na tyle obszerna kategoria sklepów, że zmieściły się tu zarówno strony dla miłośników modelarstwa, puszczania latawców i przyszłych reżyserów. Obecnie własny sklep internetowy może otworzyć każdy. Wystarczy tylko znaleźć dogodną niszę.', 18, 18, 'najlepsze_polskie_sklepy_internetowe', 14, 112, 69, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1369, 'Czas na drugie życie', 'Jeśli lubicie społeczności internetowe oparte na ciekawym pomyśle, ale w wirtualnych państwach brakuje Wam grafiki i widzialnej akcji, zaś gry MMORPG osadzone w realiach fantasy bądź s-f zaczynają nudzić...Nie mogliście trafić lepiej! Witajcie w swoim drugim życiu!', 22, 25, 'czas_na_drugie_zycie', 15, 187, 69, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1370, 'Lifehacking. Sposób na pozbycie się stresu', 'Praca, która nas wykańcza to wystarczająco duże obciążenie. Jeśli jednak stale płynący do nas strumień informacji sprawia, że toniemy w ich zalewie i jest to jeszcze jeden powód stresu, pomocy możemu szukać w lifehackingu.', 26, 28, 'lifehacking_sposob_na_pozbycie_sie_stresu', 15, 5, 69, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1371, 'Layout za friko. Serwisy z darmowymi szablonami stron WWW', 'Osoby, które chcą mieć swoją witrynę w sieci, ale nie chcą tracić czasu na projektowanie jej wyglądu, mają do dyspozycji tony gotowych, profesjonalnie wykonanych szablonów.', 30, 33, 'layout_za_friko_serwisy_z_darmowymi_szablonami_stron_www', 22, 188, 69, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1372, 'Noximage. Sieciowa alternatywa dla Photoshopa?', 'Usługi internetowe zaczynają coraz śmielej konkurować z oprogramowaniem komputerowym. Obok projektów takich jak Google Docs &amp; Spreadsheeds (http://docs. google.com) pojawia się coraz więcej sieciowych alternatyw dla zwykłych, instalowanych na pececie aplikacji. Dobrym przykładem jest Neximage (http://www.neximage.com), edytor graficzny online.', 34, 36, 'noximage_sieciowa_alternatywa_dla_photoshopa', 22, 189, 69, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1373, 'Nie tylko wyszukiwarka. Przegląd usług Google', 'Google Inc. to firma, która w ciągu ostatnich lat wyrosła na prawdziwą potęgę. Zaczęło się od wyszukiwarki Google.com, później przyszedł czas na kolejne serwisy tworzone od podstaw lub wykupywane od konkurencji. Ale coraz częściej słychać głosy przeciwników, którzy podnoszą takie kwestie jak naruszanie przez Google prywatności czy zagrożenie monopolizacji rynku. Czy mamy się czego obawiać?', 37, 41, 'nie_tylko_wyszukiwarka_przeglad_uslug_google', 22, 190, 69, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1374, 'Coppermine', 'Coppermine Gallery 1.4 to album zdjęć online o dużych możliwościach, dzięki któremu zamieścimy na stronie galerie fotograficzne.', 42, 44, 'coppermine', 25, 191, 69, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1375, 'Kolory sieciowych projektów', 'Goethe w swojej książce "Teoria kolorów" stwierdził, że gdy oko dostrzeże kolor, ulega natychmiastowemu pobudzeniu. Od XIX wieku sporo nauszyliśmy się o kolorach, jednak ta podstawowa zasada sprawdza się do dziś, gdy malujemy obraz czy projektujemy strony.', 46, 49, 'kolory_sieciowych_projektow', 25, 192, 69, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1376, 'Wielokrotny autoresponder dla każdego', 'Jak przekonuje nas autor systemu FreeBot.pl (http://www.freebot.pl), wielokrotny autoresponder jest najważniejszym narzędziem w e-biznesie. Aby się o tym przekonać, przyjrzymy się wspólnie możliwościom tego darmowego narzędzia i samej idei wielokrotnych autoresponderów.', 50, 51, 'wielokrotny_autoresponder_dla_kazdego', 25, 173, 69, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1377, 'Promocja i reklama sklepu internetowego', 'Promocja i reklama to droga do efektywnej sprzedaży, a najleprzym medium reklamowym dla e-sklepów jest oczywiście internet. W artykule omawiam różne rodzaje sieciowej reklamy, przedstawiam ich wady i zalety, a także możliwe zastosowania.', 52, 55, 'promocja_i_reklama_sklepu_internetowego', 35, 193, 69, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1378, 'Jak zbudowano Habbo.com', 'Fiński projektant i animator Sampo Karjalainen ujawnia, jak Habbo Hotels udało się zachęcić do rejestracji miliony użytkowników z całego świata.', 56, 57, 'jak_zbudowano_habbo_com', 35, 142, 69, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1379, 'Biznes na podcastingu?', 'Zapytaliśmy znanych sieciowych podcasterów, czy osiągnięte przez nich wyniki odpowiadają zamieszaniu jakie wywołuje podcasting i czego możemy spodziewać się w najbliższej przyszłości.', 58, 61, 'biznes_na_podcastingu', 23, 194, 69, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1380, 'Wspomnienia z epoki drewnianych światłowodów', 'Dziś trudno sobie wyobrazić, że mógł istnieć świat bez sieci. A przecież jeszcze kilkanaście lat temu, gdy rodziła się większość obecnych internautów, Polska była białą plamą na internetowej mapie świata.', 62, 69, 'wspomnienia_z_epoki_drewnianych_swiatlowodow', 23, 195, 69, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1381, '"Możemy rozbudować Delicious tak, by przechowywało, kategoryzowało i udostępniało wszystkie aspekty naszego cyfrowego życia"', 'Fenomenów, które sprawiają, że rzeczywiście zmieniamy sposób korzyskania z internetu jest niewiele, ale twórcy Delicious, Joshua Schachterowi udało się uczynić ze znaczników jeden z głównych trendów w 2003 roku.', 70, 71, 'mozemy_rozbudowac_delicious_tak_by_przechowywalo_kategoryzowalo_i_udostepnialo_wszystkie_aspekty_naszego_cyfrowego_zycia', 23, 195, 69, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1382, 'Internet Explorer 7 kontra Firefox 2', 'Po blisko pięciu latach oczekiwania ukazała się kolejna wersja Internet Ixplorera. Kilka dni po premierze tego produktu użytkownikom udostępniono również nowe wydanie Firefoksa. Warto zatem przyjrzeć się obydwu przeglądarkom i sprawdzić jakie nowości oferują.', 84, 85, 'internet_explorer_7_kontra_firefox_2', 10, 139, 69, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1383, 'WordToPDF. Przeformatuj swoje dokumentu', '', 86, 86, 'wordtopdf_przeformatuj_swoje_dokumentu', 10, 196, 69, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1384, 'PiXPO. Podziel się swoimi mediami', '', 86, 86, 'pixpo_podziel_sie_swoimi_mediami', 10, 196, 69, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1385, 'Image Spider. Łowca grafik', '', 87, 87, 'image_spider_lowca_grafik', 10, 196, 69, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1386, 'Strzeż swojej prywatności', 'Domowy lub firmowy komputer ma zwykle wielu użytkowników. Każdy wykorzystuje jego możliwości na swój sposób, ale nie każdy być może zdaje sobie sprawę z faktu, że to co na nim robi jest rejestrowane przez system i zainstalowane aplikacje.', 88, 91, 'strzez_swojej_prywatnosci', 10, 9, 69, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1387, 'Quirks mode, strict mode. Dwa tryby pracy przeglądarek internetowych', 'Współczesne przeglądarki internetowe oferują dwa tryby pracy: quirks mode (ang. tryb dziwactw) oraz strict mode (ang. tryb standardów). Myśląc o tworzeniu witryn zgodnych ze standardami należy uwzględniać tryb pracy przeglądarki.', 93, 95, 'quirks_mode_strict_mode_dwa_tryby_pracy_przegladarek_internetowych', 13, 12, 69, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1388, 'Webmastering w przykładach: www.willaewa.pl', 'Witryna dostępna pod adresem http://www.willaewa.pl pełni rolę wizytówki pensjonatu o nazwe Willa Ewa, który znajduje się w miejscowości Lądek Zdrój. Artykół opisuje szczegóły realizacji witryny.', 96, 99, 'webmastering_w_przykladach_www_willaewa_pl', 13, 12, 69, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1389, 'Backpack', 'Jeden termin goni drugi. Ciągły brak czasu, powiększająca się liczba rzeczy do zrobienia "na wczoraj". Jakże typowa sytuacja w obecnym świecie. Jednak w większości przypadków dobra organizacja pracy może pozwolić zaoszczędzić wiele godzin. Backpack to internetowa aplikacja zawierająca zestaw świetnych narzędzi, które na pewno ułatwią to zadanie.', 100, 101, 'backpack', 13, 123, 69, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1390, 'Podstawy PHP. Zmienne i podstawowe operatory matematyczne', 'Poprzednio omówiliśmy instalację oraz konfigurację serwera HTTP Apache, tak aby umożliwiał uruchamianie sktyptów PHP. Przedstawilismy także podstawowe informacje na temat zmiennych (w tym napisów). W tym miesiącu rozszerzymy wiedzę na temat innego typu - tablic oraz opiszemy operatory matematyczne oferowane przez PHP.', 102, 105, 'podstawy_php_zmienne_i_podstawowe_operatory_matematyczne', 13, 11, 69, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1391, 'Gimp. Tworzenie szablonów stron www', 'Szablon, który przygotołałem w tym odcinku ma układ dwukolumnowy. Kolumny o stałej szerokości wyśrodkowane na stronie rozciągają się na całą wysokość okna przeglądarki. Wydawałoby się, nic prostszego. Jak się okaże, problemem jest wyznaczanie wysokości elementów pływających.', 106, 111, 'gimp_tworzenie_szablonow_stron_www', 13, 197, 69, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1392, 'Najlepsze polskie sklepy internetowe. Branża: dla dziecka i mamy', 'Młodzi rodzice to doskonali klienci, potrafiący przeznaczyć na potrzeby nowego członka rodziny niemałą część domowego budżetu. Na dodatek są to często osoby obeznane z internetem i mające pewne doświadczenie w zakupach online. Nic więc dziwnego, że e-sklepy z artykułami dla matek i niemowląt wyrastają w ostatnim czasie niczym grzyby po deszczu.', 18, 18, 'najlepsze_polskie_sklepy_internetowe_branza_dla_dziecka_i_mamy', 14, 112, 70, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1393, 'Internet z komórki', 'Nowe usługi, większe pasmo, nowa jakość telefonii komórkowej - to wyznaczniki epoki technologicznej 3G (trzeciej generacji). Dzięki 3G możemy korzystać z multimedialnego internetu bez konieczności siedzenia za biurkiem .', 22, 27, 'internet_z_komorki', 22, 198, 70, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1394, 'Zainwestuj w profesjonoany wizerunek', 'Jeśli chcesz, aby twoja strona internetowa przyciągała wzrok i wzbudzała zachwyt, to zapomnij o serwisach z darmowymi szablonami, które opisaliśmy miesiąc temu. Projektu dla siebie musisz poszukać w serwisach płatnych', 28, 31, 'zainwestuj_w_profesjonoany_wizerunek', 22, 199, 70, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1395, 'Google Docs &amp; Spreadsheets', 'Google to nie tylko twórca najpopularniejszej wyszukiwarki internetowej. Firma sukcesywnie uruchamia kolejne usługi. Jedną z najnowszych jest Google Docs &amp; Spreadsheets. Aplikacja ta umożliwia otwieranie, edytowanie i tworzenie róznorakich dokumentów i arkuszy kalkulacyjnych.', 32, 35, 'google_docs_amp_spreadsheets', 22, 200, 70, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1396, 'Czar zielonych liter. Zwięzła historia dawnych czatów, BITNET''u, nieudanych logowań, zapomnianych e-maili i sieciowych guru', 'Początki sieci w Polsce na przełomie lat 80. i 90. kojarzą się z zielonkawą poświatą rzędu starych terminali znakowych umieszczonych w zwykle przyciemnionych uniwersyteckich pracowniach komputerowych. Nie marzyliśmy jeszcze o prywatnych pecetach, Windowsy były w powijakach, a systemem operacyjnym komputerów (pamiętne mainframe''y firmy IBM) był VM/CMS. Synonimem słowa "sieć" był BITNET/EARN, ale jedno się nie zmieniło - ludzie byli takimi samymi entuzjastami jak dziś, choć wtedy być może wymamgało to nieco więcej wiedzy i wysiłku.', 36, 39, 'czar_zielonych_liter_zwiezla_historia_dawnych_czatow_bitnet_u_nieudanych_logowan_zapomnianych_e_maili_i_sieciowych_guru', 23, 195, 70, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1397, 'Zostań inżynierem SEO', 'Poszukiwanie prawdy zaczyna się tutaj, jednak jeśli "prawda" była naszym jedynym słowem kluczowym, mamy neduże szanse na poprawienie pozycji naszego serwisu w rankingach wyszukiwarek. Ekspert SEO Jaanson Duke zdradza, jak dostać się na szczyty list rankingowych internetowych wyszukiwarek', 40, 44, 'zostan_inzynierem_seo', 25, 201, 70, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1398, 'osCommerce 2.2', 'Wzbogacamy naszą stronę o zaawansowane funkcje sklepu za pomocą osCommerce 2.2, aplikacji opartej na PHP.', 45, 47, 'oscommerce_2_2', 25, 202, 70, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1399, 'Odtwarzacz MP3 we flashu', 'Utworzenie własnego odtwarzacza MP3 we flashu, działającego na stronie WWW nie jest trudne.', 48, 51, 'odtwarzacz_mp3_we_flashu', 25, 21, 70, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1400, 'Animowane GIF-y w GIMP-ie', 'Animowane GIF-y pojawiają się na stronach WWW jako osobne animacje bądź jako efekty wzbogacające interfejs witryny. Wyjaśnimy podstawowe cechy formatu GIF i pokażemy w jaki sposób tworzyć animowane GIF-y w programie GIMP.', 52, 55, 'animowane_gif_y_w_gimp_ie', 25, 203, 70, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1401, 'Pando. Sposób na duże załączniki', 'Jeśli często wymieniamy się ze znajomymi plikami, warto zainteresować się programem Pando.', 56, 57, 'pando_sposob_na_duze_zalaczniki', 25, 204, 70, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1402, 'Jak zbudowano nowy serwis CVG', 'Gracze chcą, by ich nowe serwisy były użyteczne, solidne i żeby dobrze wyglądały. Bob Silver z NOWWASHYOURHANDS wyjaśnia, jak udało się zachować właściwe proporcje podczas przebydowywania serwisu CVG.', 58, 59, 'jak_zbudowano_nowy_serwis_cvg', 35, 142, 70, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1403, 'Okiem napastnika', 'Napastnikiem podejmującym atak na sieć komnputerową mogą kierować różne przesłanki: osobiste urazy, słabość zabezpieczeń sieci lub widoki na atrakcyjną zdobycz. Bezpieczeństwo komputerowe to problem złożony, który można rozpatrywać z wielu stron. Ochrona informacji (przechowywanej lub przetwarzanej w systemie) przed jej ujawnieniem jest pierwszoplanowa np. w administracji państwowej, natomiast ochrona informacji przed jej utratą ma prioritet w bankach.', 60, 65, 'okiem_napastnika', 20, 205, 70, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1404, 'Flickr.com - w stronę mobilności', 'Na fali echa oprymizmu sieciowj kultury wczesnych lat 90., w 2004 r. Na scenie pojawił się Flickr i stał się apikacją definiującą Web 2.0. O przyszłości Flickra mówi Caterina Fake, jego współzałożycielka.', 66, 67, 'flickr_com_w_strone_mobilnosci', 32, 32, 70, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1405, 'Miasteczko Multimedialne. Nowoczesne technologie w Nowym Sączu', 'Z Piotrem Palikowskim, dyrektorem Projektu Wyższej Szkoły Biznesu - National Louis University, koordynatorem przedsięwzięcia "Miasteczko Multimedialne" rozmawia Piotr Perka.', 68, 69, 'miasteczko_multimedialne_nowoczesne_technologie_w_nowym_saczu', 32, 32, 70, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1406, 'Norton Confidential', 'Coraz większa ilość transakcji realizowanych za pośrednictwem internetu przy stale rosnącej aktywności sieciowych przestępców skłania użytkowników do sięgania po rozwiązania, które mają zapewnić im bezpieczeństwo oraz chronić cenne dla nich dane. Jednym z produktów oferujących tego typu funkcjonalność jest aplikacja o nazwie Norton Confidential.', 82, 83, 'norton_confidential', 10, 139, 70, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1407, 'Spyware Terminator. Bezpiecznie i za darmo', '', 84, 84, 'spyware_terminator_bezpiecznie_i_za_darmo', 10, 196, 70, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1408, 'Flash Designer. Animacja po polsku', '', 84, 84, 'flash_designer_animacja_po_polsku', 10, 196, 70, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1409, 'Pivot. Stwórz własną animację', '', 85, 85, 'pivot_stworz_wlasna_animacje', 10, 196, 70, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1410, 'Rzutem na taśmę. Przegląd aplikacji do automatycznego wypełniania formularzy', 'Za pośrednictwem internetu można obecnie załatwić wiele spraw formalno - prawnych, jednak wiaże się to z udzielaniem informacji identyfikujących usługobiorcę. Żmudne wypełnianie internetowych formularzy można uprościć i przyśpieszyć wykorzystując odpowiedni program.', 86, 89, 'rzutem_na_tasme_przeglad_aplikacji_do_automatycznego_wypelniania_formularzy', 10, 9, 70, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1411, 'Gimp. Tworzenie szablonów stron WWW.', 'Prezentowany szablon wykorzystuje technikę sztucznych kolumn (ang. faux columns) opisaną przez Dana Cederholma. Stosując poziomą stopkę rozciągającą się na całą długość strony rozwiązałem problem zbyt małej ilości tekstu, dodatkowo w szablonie umieściłem ikony reagujące na wskaźnik myszy (ang. rollover), wykonane w całości w CSS.', 91, 95, 'gimp_tworzenie_szablonow_stron_www2', 13, 197, 70, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1412, 'Podstawy PHP', 'Programy komputerowe nie są prostymi zbiorami instrukcji wykonywanych jedna po drugiej. Musi istnieć sposób na warunkowe wykonanie niektórych instrukcji, a także często na wielokrotne wykonanie pewnych fragmentów programu. Aby zapewnić taką funkcjonalność, niemal każdy język programowania dostarcza programiście zbiór struktur sterujących.', 96, 99, 'podstawy_php', 13, 11, 70, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1413, 'Rozdzielczość ekranu, szerokość okna przeglądarki, szerokość układu strony WWW.', 'Jednym z ważniejszych założeń webmasteringu jest to, by strona WWW była poprawnie wyświetlana na wielu różnych urządzenniach, w wielu różnych środowiskach. Wynikają z tego liczne komplikacje. Część kłopotów dotyczy rozdzielczości ekranu urządzenia, na którym wyświetlana jest witryna WWW.', 100, 102, 'rozdzielczosc_ekranu_szerokosc_okna_przegladarki_szerokosc_ukladu_strony_www', 13, 12, 70, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1414, 'fotosik.pl', 'Coraz częściej zachodzi potrzeba podzielenia się z innymi jakimiś zdjęciami. W takich sytuacjach z pomocą może przyjść Fotosik (http://fotosik.pl), który słóży do bezpłatnego składowania dowolnych obrazków. Serwis wzorowany jest na znanym amerykańskim Image-Shack (http://imageshack.us), jednak wyróżnia go polski interfejs oraz nieco inna funkcjonalność.', 104, 105, 'fotosik_pl', 13, 123, 70, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1415, 'Przyciski rollover w CSS', 'W artykule opiszę uniwersalną metodę wykonywania przycisków reagujących na wskaźnik myszki. Rozwiązanie bazuje wyłącznie na CSS, a etykieta przycisku jest tekstem w XHTML-u. Tekst taki nie tylko podlega skalowaniu, ale także łatwo go wymienić.', 106, 109, 'przyciski_rollover_w_css', 13, 96, 70, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1416, 'www.shelfbikes.co.uk', 'W tym miesiącu zaprosiliśmy Jonatana Briggsa, dyrektora OTHER Media, oraz projektanta Andersa Orrberga, by ulepszyli serwis Shelf Bikes zajmujący się przeróbkami rowerów.', 110, 111, 'www_shelfbikes_co_uk', 13, 125, 70, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1417, 'Najlepsze polskie sklepy internetowe. Branża: wędkarstwo i łowiectwo.', 'W zeszłym miesiącu zaprezentowaliśmy sklepy z artykułami dla matki i dziecka. Aby zachowywać równowagę, najnowsze zestawienie poświęciliśmy typowo męskim hobby, jakimi są wędkarstwo i łowiectwo. Przy okazji tego podsumowania, po raz kolejny okazało się, że trudno o branżę, w której nie zadomowiłyby się już sklepy internetowe.', 18, 18, 'najlepsze_polskie_sklepy_internetowe_branza_wedkarstwo_i_lowiectwo', 14, 112, 71, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1418, 'RSS i świat jest twój!', 'Gdyby tak od razu przy porannej kawie dostać wszystkie informacje, których nam potrzeba, z dziedzin, które nas interesują i tylko z tych źródeł, które sobie sami wybierzemy. To już nie są marzenia, to RSS.', 22, 25, 'rss_i_swiat_jest_twoj', 23, 101, 71, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1419, 'Dołącz do mobilnej rewolucji.', 'W najbliższych latach mobilna sięć zrewolucjonizuje sposób, w jaki odbieramy informacje. Coraz większe zainteresowanie, doskonaalsze przeglądarki, szerokopasmowa szybkość przesyłania danych oraz lokalizowane usługi są dostępne już dziś. Czy jesteśmy na to gotowi?', 26, 32, 'dolacz_do_mobilnej_rewolucji', 23, 206, 71, 7);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1420, 'Kursorem po mapie.', 'Rośnie konkurencja dla papierowych map i atlasów. W internecie przybywa serwisów, które oferują interaktywne mapy oraz zdjęcia satelitarne wysokiej jakości.', 34, 37, 'kursorem_po_mapie', 22, 207, 71, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1421, 'AdSense w praktyce.', 'Program reklamowy AdSense został zapoczątkowany w marcu 2003 roku, a oddano go do użytku trzy miesiące później. AdSense pozwala niezależnym wydawcom korzystać z sieci keklamodawców Google na zasadzie samoobsługi-po zapisaniu się do programu i krótkiej wertyfikacji system umieszcza na stronie zgodne z kontekstem reklamy. Jak program rozwiną się w polskim internecie oraz na co trzeba zwrócić uwagę zarabiając dzięki AdSense?', 38, 40, 'adsense_w_praktyce', 22, 208, 71, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1422, 'Systemy CMS. Niezbędnik współczesnego webmastera.', 'Program reklamowy AdSense został zapoczątkowany w marcu 2003 roku, a oddano go do użytku trzy miesiące później. AdSense pozwala niezależnym wydawcom korzystać z sieci keklamodawców Google na zasadzie samoobsługi-po zapisaniu się do programu i krótkiej wertyfikacji system umieszcza na stronie zgodne z kontekstem reklamy. Jak program rozwiną się w polskim internecie oraz na co trzeba zwrócić uwagę zarabiając dzięki AdSense?', 42, 46, 'systemy_cms_niezbednik_wspolczesnego_webmastera', 25, 90, 71, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1423, 'Systemy CMS. Niezbędnik współczesnego webmastera.', 'Bardzo popularny jeszcze kilka lat temu język HTML przestał spełniać wymogi twórców witryn internetowych. Wypierają go zaawansowane systemy zarządzania treścią-CMS.', 42, 46, 'systemy_cms_niezbednik_wspolczesnego_webmastera2', 25, 90, 71, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1424, 'Podcasting', 'Nie chcemy już więcej płącić za drogie programy do obróbki dźwięku, za pomocą których przygotowujemy nasz skromny podcast? Odłóżmyy portfel na bok i przyjrzyjmy się, jak skorzystać z bezpłatnych narzędzi i usług.', 47, 49, 'podcasting', 25, 194, 71, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1425, 'PiXPO. Internetowy fotoalbum.', 'Komputer i przeglądarka graficzna coraz częściej zastępują tradycyjny album fotograficzny. Jeśli zależy nam na tym, aby szybko i bezpiecznie pokazaź komuś z drugiej strony łącza swoje cyfrowe fotki, skorzystajmy z programu PiXPO.', 50, 51, 'pixpo_internetowy_fotoalbum', 25, 209, 71, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1426, 'Widok z kamery na stronie WWW.', 'Kamerę internetową podłączoną do komputera można wykorzystać nie tylko do wideopogawędek. Przy zastosowaniu odpowiedniego programu przechwytywany obraz można przesłać na stronę internetową i udostępnić go odwiedzającym.', 52, 53, 'widok_z_kamery_na_stronie_www', 25, 210, 71, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1427, 'Jak zbudowano markyourterritory.co.uk', 'Wirale rozprzestrzeniają się z prędkością błyskawicy. Pracujący dla Mavericka Will Jeffery wyjaśni, jak nakręcić wirala Gangi Londynu dla PlayStation Portable.', 54, 55, 'jak_zbudowano_markyourterritory_co_uk', 35, 142, 71, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1428, 'Blogowanie przeciw machinie.', 'Pomimo obrony wolności wypowiedzi na użytek zagranicznych inwestorów, historia malezyjskiego rządu to w rzeczywistości kłopotliwe dossier cenzuty i zastraszania. Scott Carney ujawnia sposoby opresji online.', 57, 58, 'blogowanie_przeciw_machinie', 15, 211, 71, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1429, '"To nowy poziom internetu społecznościowego, nowe medium, nowa przestrzeń." Alan Levy', 'Blogosfera podbiła internet. Stosunkowo prosto jest wystartować ludzi, którzy mają coś do powiedzenia. Rozmawiamy z Alanem Levy, który stworzył BlogTalkRadio - serwis, który wychodzi poza ramy Web 2.o, zmieniając blogerów w nadawców.', 60, 62, 'to_nowy_poziom_internetu_spolecznosciowego_nowe_medium_nowa_przestrzen_alan_levy', 32, 32, 71, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1430, 'Nowe oblicze muzeum.', 'Z Wojciechem Florczykiem, kierownikiem projektu w firmie softhis przygotowującej nowy serwis muzeum narodowego w krakowie (http://www.muzeum.krakow.pl), rozmawia Piotr Perka.', 64, 65, 'nowe_oblicze_muzeum', 32, 32, 71, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1431, 'PC-cillin Internet Security 2007', 'Konkurencja na rynku oprogramowania przeznaczonego do zabezpieczenia komputera jest bardzo duża. O względy polskich użytkowników rywalizuje m.in.. Firma Trend Micro, oferująca pakiet PC-cillin Internet Security 2007.', 78, 79, 'pc_cillin_internet_security_2007', 10, 139, 71, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1432, 'Webaroo. Internet offline', '', 80, 80, 'webaroo_internet_offline', 10, 196, 71, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1433, 'GrabJPG. Zarzuć sieć.', '', 80, 80, 'grabjpg_zarzuc_siec', 10, 196, 71, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1434, 'GreenBrowser. Przeglądarka na zielono.', '', 81, 81, 'greenbrowser_przegladarka_na_zielono', 10, 196, 71, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1435, 'Muzyka z tekstem. Jak razem z muzyką odtwarzać teksty i jak je synchronizować.', 'Odtwarzając na komputerze muzykę nie musimy ograniczać się do podglądu jedynie tytułu i artysty. Stosując odpowiednie zabiegi można poszerzyć podgląd o teksty utworów, które w wielu przypadkach mogą nawet automatycznie przewijać się w zsynchronizowanym tempie dostosowanym do słów bierzącego utworu. Cała sztuka polega na zainstalowaniu odpowiedniego programu, który zintegruje się z odtwarzaczem i będzie automatycznie wyszukiwać, a następnie pobierać teksty z internetu.', 82, 83, 'muzyka_z_tekstem_jak_razem_z_muzyka_odtwarzac_teksty_i_jak_je_synchronizowac', 10, 9, 71, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1436, 'GIMP. Tworzenie szablonów stron WWW.', 'Szablon, który dzisiaj przedstawię, nauczy dwóch ciekawych rozwiązań. Sowiemy się, w jaki sposób w GIMP-ie wykonać fotomontaż techniką "łatek" oraz na czym polega problem z wysokością elementów pływających w CSS.', 85, 89, 'gimp_tworzenie_szablonow_stron_www3', 13, 197, 71, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1437, 'Wiadomości24.pl', 'Ostatnie kilkanaście miesięcy to wysyp różnorakich stron internetowych, które łączy to, że tworzone są przez samych odwiedzających, a nie konkretny zespół osób. Jedynym z przykładów takich społecznościowych serwisów jest Wiadomości24.pl. To gazeta internetowa, która składa się w głównej mierze z artykułów pisanych przez osoby z żyłką dziennikarską, które chcą spróbować swoich sił w pisaniu reportaży, felietonów czy też typowych notek informacyjnych.', 90, 91, 'wiadomosci24_pl', 13, 123, 71, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1438, 'Czcionki na stronach WWW.', 'Teksty na stronach WWW stwarzają liczne problemy. Już sam wybór kroju i wielkości czcionki nie jest łatwy. W artykule przedstawię przegląd zagadnień dotyczących czcionek na stronach WWW oraz najlepsze rozwiązania dotyczące wyboru czcionki i jej wielkości.', 92, 97, 'czcionki_na_stronach_www', 13, 212, 71, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1439, 'PEAR: zaawansowana obsługa formularzy w PHP.', 'Podczas tworzenia nawet najprostszego formularza należy zaprojektować ogólny wygląd, wygenerować odpowiedni kod HTML oraz stworzyć skrypt obsługujący odpowiednie pola. Co jednak, jeśli w jakiś sposób chcemy zweryfikować poprawność wprowadzonych danych? Sytuacja komplikuje się jeszcze bardziej, gdy oprócz tradycyjnych filtrów użyte zostaną złożone reguły. Artykuł ten poświęcony jest alternatywnej metodzie tworzenia formularzy w oparciu o pakiet QuickForm (http://pear.php.net).', 98, 101, 'pear_zaawansowana_obsluga_formularzy_w_php', 13, 11, 71, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1440, 'Semantyczny kod XHTML.', 'W odniesieniu do stron WWW coraz częściej mówi się o tzw. semantycznym kodzie XHTML. W artykule wyjaśnię na czym owa semantyczność polega.', 102, 105, 'semantyczny_kod_xhtml', 13, 99, 71, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1441, 'Podstawy PHP.', 'Do budowy bardzo prostych programów wystarczy już wiedza, którą zdobyliśmy z ostatnich części kursu. Jeśli jednak chcielibyśmy napisać coś nieco bardziej skomplikowanego, szybko okaże się, że wiemy za mało. Dziś nauczymy się czym są funkcje oraz jak z nich korzystać, poznamy też sposób na dzielenie większych programów na kilka plików.', 106, 109, 'podstawy_php2', 13, 11, 71, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1442, 'avalorefreefly.com', 'Serwis online Szkoły Avalore Freefly wymagał nowego spojrzenia, zaprosiliśmy więc Mike''a Londona, projektanta z agencji itineris, by pokazał nam swoją magię.', 110, 111, 'avalorefreefly_com', 13, 125, 71, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1443, 'Najlepsze polskie sklepy internetowe. Branża: kosmetyki i perfumy.', 'Kupowanie perfum w sklepie internetowym może się wydawać kiepskim pomysłem. Lecz tylko do czasu, gdy nie spojrzy się na ceny oferowane przez wirtualne perfumerie. Warto więc zaryzykować, aby przy okazji sporo zaoszczędzić.', 18, 18, 'najlepsze_polskie_sklepy_internetowe_branza_kosmetyki_i_perfumy', 14, 112, 72, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1444, 'Jak wdrożyć program partnerski?', 'Programy partnerskie cieszą się dużym zaiteresowaniem internautów, którzy marzą o dużych pieniądzach. Jak zbudować fortunę swoją i potencjalcych partnerów?', 22, 25, 'jak_wdrozyc_program_partnerski', 35, 4, 72, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1445, 'Raport z rynku domen: biznes się kręci.', 'Co działo się w biznesie domenowym w zeszłym roku? Co cię będzie działo w tym roku? Które domeny są najpopularniejsze? Ilu rejestratorów wypadnie z gry?', 26, 27, 'raport_z_rynku_domen_biznes_sie_kreci', 35, 111, 72, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1446, 'Jak zbudowano Pandora.com.', 'Cyfrowa muzyka stworzyła całą sieciową kulturę, ale przypomina dziką dżunglę. Tom Conrad wyjaśnia, jak zbudował narzędzie pomagające odkrywać świat słuchowych przyjemności.', 28, 29, 'jak_zbudowano_pandora_com', 35, 142, 72, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1447, '40 najlepszych technicznych podcastów', 'Nadal podróżujemy po świecie pez odtwarzacza MP3? Musimy być szaleni. Od praktyka do profana, profesjonalisty do niezdecydowanych - prezentujemy czterdziestkę skierowanych do pasjonatów podcastów, które są gwarancją rozrywki w czasie dojazdów.', 30, 34, '40_najlepszych_technicznych_podcastow', 15, 194, 72, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1448, 'Radio na życzenie.', 'Wyobraź sobie radio, w którym nadają tylko to, czego Ty chcesz. Piosenki podpasowane wyłącznie pod Twój gust. Marzenie? Nie, to już rzeczywistość.', 36, 41, 'radio_na_zyczenie', 22, 213, 72, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1449, 'Identity 2.0', 'Internet wymaga od nas pamiętania dużej liczby haseł, nazw użytkowników czy identyfikatorów. Pamiętanie wielu różnych tego rodzaju danych sprawia kłopot, zaczynamy więc używać takich zamych haseł w różnych serwisach albo, co gorsza, zapisywać je na kartkach lub w komputerze. Czy można temu zapobiec? Okazuje się, że tak. Wyjście z impasu kryją się pod dwiema nazwami: Identity 2.0 oraz OpenID.', 42, 45, 'identity_2_0', 23, 214, 72, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1450, 'Włączamy drugi bieg!', 'Sto pełnometrażowych filmów DVD ściąganych w ciągu minuty? A może "tylko" wideokonferencja z kilkoma osobami w czasie rzeczywistym z transmisją obrazu o jakości HD? Możliwość zdalnego sterowania radioteleskopem lub inną wyrafinowaną aparaturą naukową połączona z przesyłaniem kilku gigabitów informacji na sekundę? Fantazja? Niekoniecznie. Powoli trzeba przygotowywać się na mocne doznania - nadchodzi era naprawdę szybkiego internetu.', 46, 49, 'wlaczamy_drugi_bieg', 23, 5, 72, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1451, 'E-mailowe śmieci. Jak sobie radzić ze spamem.', 'Jeśli więcej czasu zajmuje usuwanie e-maili niż ich czytanie, to czas się zastanowić, co zrobić, aby przechytrzyć spamerów.', 50, 55, 'e_mailowe_smieci_jak_sobie_radzic_ze_spamem', 20, 215, 72, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1452, 'Telepraca - praca przyszłości.', 'Z Ewą Dobrosiewicz, konsultantem w Departamencie Projektów Europejskich firmy Doradztwo Gospodarcze DGA, rozmawia Piotr Perka.', 56, 57, 'telepraca_praca_przyszlosci', 32, 32, 72, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1453, '"Jesteśmy ludźmi i naprawdę mamy emocje. Wielu ludzi tego nie rozumie"', 'Opracowanie poważniejszej aktualizacji swojej przeglądarki zajęło Microsoftowi połowę dekady. Czemu trwało to tak długo i otrzymaliśmy tak mało, tak późno? Oliver Lindberg przepytuje Deana Hachamovitcha, menadżera zespołu zajmującego się Internet Explorelem.', 58, 60, 'jestesmy_ludzmi_i_naprawde_mamy_emocje_wielu_ludzi_tego_nie_rozumie', 32, 32, 72, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1454, 'Internetowe telefonowanie Skype.', 'Na hasło "dzwonić przez internet" w pierwszej kolejności przychodzi na myśl Skype. Zobaczmy więc, jak z niego korzystać.', 61, 63, 'internetowe_telefonowanie_skype', 25, 216, 72, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1455, 'Ulepszamy WordPressa.', 'WordPress to wspaniała aplikacja przeznaczona do tworzenia blogów. Nie wszyscy jednak wiedzą, że można znacznie rozszerzyć jej możliwości za pomocą wtyczek.', 64, 66, 'ulepszamy_wordpressa', 25, 217, 72, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1456, 'Flash: interaktywny nagłówek.', 'Paul Wyatt wykorzystał i połączył moc i wszechstronność flasha z After Effects w tworzeniu dynamicznego nagłówka strony dla fikcyjnego serwisu teatralnego.', 68, 70, 'flash_interaktywny_naglowek', 25, 21, 72, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1457, 'Iloggo. Ulubione zawsze pod ręką.', 'Jeśli chcesz mieć dostęp do swoich ulubionych z każdego miejsca na świecie, zapisz je bezpośrednio w sieci, w serwisie Iloggo.', 72, 73, 'iloggo_ulubione_zawsze_pod_reka', 25, 173, 72, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1458, 'IE7 Pro. Podrasuj swoją przeglądarkę.', '', 86, 86, 'ie7_pro_podrasuj_swoja_przegladarke', 10, 196, 72, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1459, 'Lphant. Konkurencja dla eMule''a?', '', 86, 86, 'lphant_konkurencja_dla_emule_a', 10, 196, 72, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1460, 'JavuJavu. Komunikator dla sieciowych graczy.', '', 87, 87, 'javujavu_komunikator_dla_sieciowych_graczy', 10, 196, 72, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1461, 'Przykręć zawór! Przegląd programów do ograniczania przepustowości łącza.', 'Windows nie ma funkcji limitowania przepustowości łącza wybiórczo dla poszczególnych aplikacji. W tym celu trzeba skorzystać ze specjalizowanego oprogramowania. Wybór nie jest duży.', 88, 89, 'przykrec_zawor_przeglad_programow_do_ograniczania_przepustowosci_lacza', 10, 9, 72, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1462, 'Semantyczny kod XHTML.', 'W kolejnym spotkaniu z semantyką języka XHTML skupię się na podaniu praktycznych rozwiązań kilku często spotykanych problemów oraz przedstawię złożenia XHTML - technikę łączenia elementów XHTML w celu nadania bardziej sczegółowego znaczenia większemy fragmentowi tekstu.', 91, 93, 'semantyczny_kod_xhtml2', 13, 99, 72, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1463, 'Wrocek.pl', 'Pomysł na ciekawy serwis przynosi z reguły samo życie. Piotr i Karol Papała, studenci Politechniki Wrocławskiej, postanowili stworzyć serwis internetowy, z którego każdy mieszkaniec miasta mógłby dowiedzieć się o ciekawych wydarzeniach i miejscach wartych odwiedzenia, dodatkowo umożliwiając wszystkim odwiedzającym aktywne rozwijanie witryny. Tak powstał Wrocek.pl - portal społeczności Wrocławia.', 94, 95, 'wrocek_pl', 13, 123, 72, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1464, 'GIMP. Tworzenie szablonów stron WWW.', 'W kolejnym szablonie przedstawię połączenie trzech technik: ujemnych marginesów, udawanych kolumn oraz wymiany obrazów FIR. Dzięki użyciu tych technik otrzymany kod XHTML jest w pełni semantyczny, zaś w przypadku szablonu tekstowego także częściowo elastyczny.', 96, 99, 'gimp_tworzenie_szablonow_stron_www4', 13, 197, 72, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1465, 'Propel Tutorial.', 'Mapowanie relacyjno - obiektywne jest techniką programowania, w której dostęp do SQL-owej bazy danych jest zapewniany przez zestaw klas odpowiadających tabelom, relacjom i rekordom. Wstawianie, usuwanie czy wyszukiwanie rekordów wykonywane jest za pomocą obiektów, poprzez wywołanie odpowiednich metod. Rozwiązanie takie, choć bardzo wygodne, wymaga przygotowania szeregu klas i wielu metod. Zadanie to można zautomatyzować stosując Propel - narzędzie do automatycznego generowania kodu PHP5 zapewniającego obiektowy interfejs dostępu do relacyjnej bazy danych.', 100, 105, 'propel_tutorial', 13, 218, 72, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1466, 'Podstawy PHP. Operacje na Plikach.', 'Większość skryptów PHP musi przechowywać szereg informacji: treści wyświetlane na stronach, szczegóły o użytkownikach, komentarze itd. Najczęściej w celu przechowywania tych informacji używa się baz danych, takich jak np. MySQL. Jednak na bazę danych przyjdzie jeszcze czas. Dziś zapoznamy się z operowaniem plikami.', 106, 109, 'podstawy_php_operacje_na_plikach', 13, 11, 72, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1467, 'victorhugosalsa.com', 'W tym miesiącu zaprosiliśmy Heiko Keppela, projektanta z niemieckiego studia Fork Unstable Media, aby Victor Hugo, piosenkarz i kompozytor, otrzymał serwis, na jaki zasługuje.', 110, 111, 'victorhugosalsa_com', 13, 125, 72, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1468, 'Najlepsze polskie sklepy internetowe. Branża: akcesoria dla zwierząt.', 'Nie od dziś wiadomo, że właściciele domowych zwierzaków są w stanie wydać na swoich pupili każde pieniądze. Pamiętali o tym na pewno właściciele internetowych sklepów zoologicznych, z których najlepsze funkcjonują w polskim internecie nawet kilka lat.', 18, 18, 'najlepsze_polskie_sklepy_internetowe_branza_akcesoria_dla_zwierzat', 14, 112, 73, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1469, 'Własna galeria w internecie. Szybko, łatwo i za darmo.', 'W czasach gdy zdjęcia można zrobić zwykłą komórką, a aparaty cyfrowe są coraz tańsze, prawie każdy ma na swoim komputerze setki czy nawet tysiące fotek. Z czasem przychodzi chęć uporządkowania takiej kolekcji, ładnego zaprezentowania jej rodzinie czy znajomym. W tym mogą pomóc serwisy WWW, które nie dość że przechowują zdjęcia za darmo, to jeszcze automatycznie tworzą z nich efektywne galerie.', 22, 27, 'wlasna_galeria_w_internecie_szybko_latwo_i_za_darmo', 22, 219, 73, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1470, 'Jak założyć i prowadzić bloga.', 'Odkąd pamiętam, miałem niechętny stosunek do blogów. Nie podobało mi się używanie przez wszystkich tych samych szablonów i rozwijanie stron w sposób jedynie "pamiętnikarski". A jednak - może z lenistwa twórców czy prostego sposobu tworzenia tego typu witryn - internetowe pamiętniki wyparły dość szybko strony domowe pod względem ich ilości... A z czasem nawet i jakości!', 28, 31, 'jak_zalozyc_i_prowadzic_bloga', 22, 220, 73, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1471, 'Jak zbudowano Halo Interia.', 'Netia zdradza szczegóły dotyczące programu resellerskiego FON24, czyli jak zrarobić na telefonii internetowej.', 32, 33, 'jak_zbudowano_halo_interia', 44, 142, 73, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1472, 'Jak zbudowano miniclip.com.', 'Miniclip to jeden z największych serwisów gier online, mogący pochwalić się 30 milionami użytkowników miesięcznie. Robert Small, jego założyciel, opowiada o tworzeniu serwisu, w którym 98% użytkowników dysponuje łączem szerokopasmowym.', 34, 35, 'jak_zbudowano_miniclip_com', 35, 142, 73, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1473, 'Tworzymy strony, które zarabiają.', 'W pierwszej części artykułu Paul Dawson radzi jak zaplanować budowę sklepu, jak go zaprojektować oraz jak wybrać dla niego odpowiednią platformę.', 36, 41, 'tworzymy_strony_ktore_zarabiaja', 35, 4, 73, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1474, 'EyeOS. System operacyjny online.', 'Jeśli do tej pory sądziliście, że system operacyjny można mieć wyłącznie na dysku twardym swojego komputera, bootowalnej płycie CD lub w pamięci pendrive''a, to byliście w błędzie. Zaglądając na strony projektu EyeOS (http://eyeos.info) można znaleźć system, który wprawdzie nie do końca przypomina Windows czy Linuksa, ale pozwala sttworzyć coś na wzór systemu operacyjnego dostępnego z każdego komputera podłączonego do internetu. Pozwala on na zarzącdzanieróżnymi zasobami i programami zgromadzonymi w wirtualnej strefie własnego konta.', 42, 43, 'eyeos_system_operacyjny_online', 15, 221, 73, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1475, 'Internetowy dzienniczek ucznia.', 'Coraz większą popularnością cieszą się dzienniki online. Nauczyniel wstawia tam oceny z tradycyjnego dziennika, a uczeń i rodzic, mając osobne konta, śledzą wszystko na bieżąco.', 44, 47, 'internetowy_dzienniczek_ucznia', 15, 25, 73, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1476, 'Napiszmy coś razem.', 'Czytelnictwo w Polsce spada z roku na rok. Osoby, które przeczytały choć jedną książkę w miesiącu stanowią dziś nieliczny procent. Również coraz mniej osób kupuje czasopisma. Ludzie potrzebują efektownych, ale nieskomplikowanych przeżyć i zamiast ksążek wybierają film, grę lub internet, który z jednej strony odciąga od książek, a z drugiej jest miejscem, gdzie każdy może napisać co chce i przeczytać co go interesuje. Przykładem może być serwis Opowiadam.pl.', 48, 51, 'napiszmy_cos_razem', 15, 222, 73, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1477, '50 najlepszych wtyczek do Firefoksa.', 'Firefox sam w sobie jest fantastyczny, jednak za pomocą właściwych dodatków uczynimy go jeszcze wspanialszym, lepszym, szybszym i bardziej elastycznym. Przedstawiamy listę 50 najciekawszych i najbardziej przydatnych rozszerzeń przeznaczonych dla Firefoksa.', 52, 56, '50_najlepszych_wtyczek_do_firefoksa', 25, 223, 73, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1478, 'Internetowe telefonowanie Tlenofon.', 'Miesiąc temu pokazałem jak dzwoniń przez internet za pomocą Skype''a. Teraz zobaczymy co potrafi jego polski odpowiednik - Tlenofon.', 57, 59, 'internetowe_telefonowanie_tlenofon', 25, 224, 73, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1479, 'Rozszerzamy phpBB.', 'Dodajmy dodatkowe funkcje, style i motywy do forum na naszej stronie dzięki zaawansowanej architekturze phpBB.', 60, 62, 'rozszerzamy_phpbb', 25, 225, 73, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1480, 'Backpack. Zorganizuj swój czas w sieci!', 'Wszyscy narzekamy na brak czasu. By lepiej zorganizować własne życie, jedni posiłkują się książkowymi kalendarzami, innym wystarcza kartka papieru z listą "rzeczy do zrobienia". Są i tacy, którzy organizację swojej pracy powierzają internetowi.', 64, 65, 'backpack_zorganizuj_swoj_czas_w_sieci', 25, 173, 73, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1481, '"Byłem okropnym programistą, prawdopodobnie nadal jestem. Nie potrafię nawet przeliterować HTML". Matt Mullenweg', 'Według Google Matt Mullenweg jest jednym z najważniejszych Mattów na świecie. Fani jego sławnego projektu, opensource''owego narzędzia do blogowania WordPress, zgodzą się z tą opinią. Oliver Lindberg odkrywa, kim naprawdę jest człowiek stojący za tym oprogramowaniem.', 66, 68, 'bylem_okropnym_programista_prawdopodobnie_nadal_jestem_nie_potrafie_nawet_przeliterowac_html_matt_mullenweg', 32, 32, 73, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1482, 'Pozostaliśmy wierni idei Firefoksa.', 'Mozilla jest silna dzięki sile swoich zwolenników. Wszystkie tłumaczenia tworzą zapaleńcy. W Polsce wszystko, co jest związane z pomocą innym użytkownikom także znajduje się w gestii entuzjastów. Prowadzenie forów internetowych promocja przegladarki to zasługa ludzi, którzy ronią to na ochotnika. Identycfikują się z ideałami Fundacji.', 70, 71, 'pozostalismy_wierni_idei_firefoksa', 32, 32, 73, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1483, 'Webcam First. Obserwator i strażnik.', '', 84, 84, 'webcam_first_obserwator_i_straznik', 10, 196, 73, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1484, 'Incomedia WebSite X5. Strona WWW w pięciu krokach.', '', 84, 84, 'incomedia_website_x5_strona_www_w_pieciu_krokach', 10, 196, 73, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1485, 'PimpFish. Ściągaj optymalnie.', '', 85, 85, 'pimpfish_sciagaj_optymalnie', 10, 196, 73, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1486, 'Nie rób błędów! Kontrolowanie pisowni w komunikatorze.', 'Tekstowe komunikatory internetowe mimo ekspansji dźwiękowych form komunikacji (VoIP) nadal cieszą się dużym powodzeniem. Pisemna forma dialogu wymaga poprawnego posługiwania się językiem i płynnego pisania na klawiaturze, a nie wszyscy radzą sobie z tym najlepiej. Błędów można uniknąć integrując z komunikatorem moduł słownikowy.', 86, 87, 'nie_rob_bledow_kontrolowanie_pisowni_w_komunikatorze', 10, 4, 73, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1487, 'Gimp. Tworzenie szablonów stron WWW.', 'Efekt rollover można wykonać w CSS w taki sposób, że wszystkie opcje w stanie aktywnym są zapisane w jednym pliku graficznym. Technika taka, nazywana z żargonie Sprites, wymusza wstępne pobieranie obrazów i minimalizuje krojenie pliku graficznego na małe kawałki. W omawianym szablonie rozwoiązanie to zostało wykorzystane do wykonania menu.', 89, 93, 'gimp_tworzenie_szablonow_stron_www5', 13, 197, 73, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1488, 'nasza-klasa.pl', 'Podztawą sudcesu każdego serwisu internetowego jest dobry pomysł. Wydawałony się, że już nic nowego nie da się wymyślić. Jednak niemal każdego dnia powstają projekty, które zapełniają jakąś lukę, wykorzystują zapotrzebowanie na określoną funkcjonalność, której dotychczas brakowało w internecie lub była niedostatecnie wyeksponowana. nasza-klasa.pl to, jak piszą autorzy "portal dla ludzi z klasą". A co się naprawdę pod tym kryje? Jest to serwis, gdzie można odnaleźć kolażanki i kolegów ze szkolnych lat.', 94, 95, 'nasza_klasa_pl', 13, 123, 73, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1489, 'Semantyczny kod XHTML', 'Kontynuując rozważania na temat semantyki, zajmiemy się kwestiami niedostatków semantycznych języka XHTML, czy raczej języków XHTML/CSS. Niestety, bardzo często różne kwestie praktyczne wymuszają tworzenie dokumentów zawierających rozwiązania niesemantyczne. W tej części, analizując kilka przykładów, powiążemy pojęcia semantyki i struktury oraz wyciągniemy wnioski na temat wpływu klas na semantykę dokumentu.', 96, 99, 'semantyczny_kod_xhtml3', 13, 99, 73, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1490, 'Propel. Operacje na plikach.', 'Seria artykułów poświęconych bazom danych, które były opublikowane na łamach MI w ubiegłym roku, pokazywała w jaki sposób korzystać z programu DBDesigner. Aplikacja Propel, którą przedstawiłem w ubiegłym miesiącu, generuje automatycznie klasy aktywnych rekordów. Teraz opiszę w jaki sposób Propelem generować kod PHP dla modelu bazy danych przygotowanego DBDesignerem.', 100, 105, 'propel_operacje_na_plikach', 13, 218, 73, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1491, 'Podstawy PHP.', 'Miesiąc temu poznaliśmy funkcje pozwalające na operowanie plikami z poziomu skryptów PHP. Dziś poznamy bardziej zaawansowane funkcje związane z obsługą plików.', 106, 109, 'podstawy_php3', 13, 11, 73, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1492, 'gp-training.net', 'Edukacyjny serwis gp-training.net zymaga szybkiej zmiany wizerunku. Zajmą się tym projektant Paul Lyons oraz Dave Ward, Menedżer projektu i architekt informacji z firmy Fortune Cookie.', 110, 111, 'gp_training_net', 13, 125, 73, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1493, 'Najlepsze polskie sklepy internetowe. Branża: sprzęt turystyczny i biwakowy.', 'Początek lata to czas wzmożonych zakupów sprzętu sportowego i turystycznego. Wiele osób już teraz zaopatruje się w namioty, plecaki, śpiwory czy buty, które przydadzą się podczas lipcowo-sierpniowych wojaży. Naprzeciw ich oczekiwaniom wychodzą sklepy internetowe.', 20, 20, 'najlepsze_polskie_sklepy_internetowe_branza_sprzet_turystyczny_i_biwakowy', 14, 112, 74, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1494, 'Wakacje 2007. Zaplanuj je w internecie.', 'Zbliżają się wakacje. Trzeba zacząć planować letnie wyjazdy, w czym wydatnie może pomóc internet. W sieci znajdziemy wiele serwisów z ofertami biur podróży, jak również informacje o miejscach na całym świecie, które warto odwiedzić.', 24, 28, 'wakacje_2007_zaplanuj_je_w_internecie', 15, 226, 74, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1495, 'Oj, będzie się działo... Profesjonaliści o najnowszych trendach w projektowaniu WWW.', 'Projektowanie i programowanie rozwijają się tak szybko, że często trudno nadążyć za najnowszymi trendami i technikami. Jason Walsh rozmawiał z 11 najlepszymi projektantami, którzy wyjawili mu, co przyniesie najbliższa przyszłość.', 30, 35, 'oj_bedzie_sie_dzialo_profesjonalisci_o_najnowszych_trendach_w_projektowaniu_www', 23, 5, 74, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1496, 'Darmowe skrzynki e-mailowe, czyli co zostało po wojnie gigabajtów.', 'Jakieś dwa lata temu trwała wojna na gigabajty. Dziś nikt już nie mówi o powiększaniu skrzynek, bo trwa inna wojna - na serwisy Web 2.0. Kto wygrał wojnę na gigabajty i co z tego mamy?', 36, 43, 'darmowe_skrzynki_e_mailowe_czyli_co_zostalo_po_wojnie_gigabajtow', 22, 227, 74, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1497, 'Na czym nie zarobisz w sieci.', 'Sieć coraz częściej postrzegana jest jako źródło łatwego zarobku. Na łamach MI nieraz podejmowano temat programów partnerskich, które istotnie są dobrym źródłem dochodów. Niestety, strony, które wyświetlają się po wpisaniu hasła "e-biznes" mówią nie tylko o zarabianiu w programach partnerskich, ale także... o klikaniu banerów i oglądaniu reklam za pieniądze.', 44, 47, 'na_czym_nie_zarobisz_w_sieci', 35, 4, 74, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1498, 'Jak zbudowano Clickdensity.com.', 'Tuziny sieciowych aplikacji każdego roku pomagają firmom w zwiększaniu wydajności, jednak celem zaledwie kilku z nich jest analiza odwiedzin. Dan Zambonini wyjaśnia, jak Clicdensity stało się ważnym narzędziem.', 48, 49, 'jak_zbudowano_clickdensity_com', 35, 142, 74, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1499, 'Tworzymy strony, które zarabiają.', 'O programowaniu naszego serwisu, pobieraniu, analizowaniu i aktualizowaniu statystyk, cross-sellingu i up-sellingu opowiada Poul Dawson.', 51, 54, 'tworzymy_strony_ktore_zarabiaja2', 35, 4, 74, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1500, '"BitTorrent miał być narzędziem przydatnym do wymiany plików bez zbytniej troski o prawne skutki tego działania". Bram Cohen', 'Jak przejść drogę od biednego programisty do CEO i założyciela BitTorrenta? Czy ruszy nowy, legalny sklep wideo? Bram Cohen oderwał się od programowania, zabaw z matematyką, żonglerki i origami, by porozmawiać z Oliverem Lindbergem.', 55, 57, 'bittorrent_mial_byc_narzedziem_przydatnym_do_wymiany_plikow_bez_zbytniej_troski_o_prawne_skutki_tego_dzialania_bram_cohen', 32, 32, 74, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1501, 'Budujemy internet.', 'W poradniku Karl Hodge zachwala zalety serwisów internetowych, dzieli się spostrzeżeniami eksperta i przedstawia najlepsze aplikacje umożliwiające utworzenie własnego, bezpiecznego, opensource''owego serwisu.', 58, 60, 'budujemy_internet', 25, 228, 74, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1502, 'Jak zbudować popularność witryn?', 'Pozycjonowanie witryn internetowych jest narzędziem promocji witryny w internecie. Optymalizacja witryny pod kątem wyszukiwarek to pozyskiwanie właściwych odnośników oraz budowanie wartościowej witryny. Pozycjonowanie polega na kombinacji działań zwiększających prawdopodobieństwo znalezienia się witryny wśród pierwszych wyników wyświetlanych przez wyszukiwarki internetowe. Wyniki mają dotyczyć najbardziej popularnych słów kluczowych związanych z tematyką pozycjonowanej witryny.', 62, 64, 'jak_zbudowac_popularnosc_witryn', 25, 229, 74, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1503, 'Internetowe telefonowanie. Gadu-Gadu NAGŁOS.', 'W ostatniej części przewodnika po najpopularniejszych w Polsce programach umożliwiających rozmowy głosowe za pośrednictwem internetu przedstawiam możliwości Gadu-Gadu NAGŁOS.', 65, 67, 'internetowe_telefonowanie_gadu_gadu_naglos', 25, 216, 74, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1504, 'Orbit Downloader. Z sieci na dysk.', '', 80, 80, 'orbit_downloader_z_sieci_na_dysk', 10, 196, 74, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1505, 'BackStreet Browser. Internet offline.', '', 80, 80, 'backstreet_browser_internet_offline', 10, 196, 74, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1506, 'iDesk. Interia.pl na pulpicie.', '', 81, 81, 'idesk_interia_pl_na_pulpicie', 10, 196, 74, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1507, 'Z sieci na dysk. Przegląd menedżerów downloadu.', 'Wbudowane w przeglądarki mechanizmy odpowiadające za kopiowanie plików są wciąż dość prymitywne. Dlatego wielu internautów zastępuje je menedżerami downloadu.', 82, 83, 'z_sieci_na_dysk_przeglad_menedzerow_downloadu', 10, 9, 74, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1508, 'EXIF oraz IPTC Metadane opisujące obrazy cyfrowe.', 'Standardy EXIF (ang. Exchangeable Image File Format) oraz IPTC (ang. International Press Telecommunications Council) umożliwiają zapis metadanych w obrazach cyfrowych. Plik graficzny (np.. JPEG) może zawierać - oprócz samej fotografii - informacje o autorze, słowa kluczowe, opis oraz parametry i ustawienia aparatu. Arytuł opisuje metody odczytu oraz modyfikacji danych EXIF i IPTC przy użyciu kilku programów użytkowych oraz skryptów w języku PHP.', 87, 89, 'exif_oraz_iptc_metadane_opisujace_obrazy_cyfrowe', 13, 11, 74, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1509, 'zumi.pl', 'W internecie jak grzyby po deszczu pojawiają się kolejne serwisy WWW, które wzbogacane są o interaktywne mapy i zdjęcia satelitarne. Wykorzystywane są one np. do wskazania lokalizacji siedziby danej firmy czy też miejsca, gdzie odbędzie się organizowana konferencja. Zdecydowana większość webmasterów korzysta w tym celu z usługi Google Maps. Inną drogą poszedł portal Onet.pl, który stworzył od podstaw własne rozwiązanie. Na początku kwietnia roku zaprezentował serwis Zumi (http://www.zumi.pl) - lokalizator internetowy umożliwiający poszukiwanie i lokalizowanie różnego rodzaju obiektów.', 90, 91, 'zumi_pl', 13, 123, 74, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1510, 'JavaScript. Dynamiczne elementy HTML.', 'JavaScript to język, który pomaga w łatwy sposób dodać do stron WWW nowe funkcje. Przy użyciu innych metod (HTML, CSS) część z nich byłaby zbyt trudna do zrealizowania bądź w ogóle niemożliwa.', 92, 95, 'javascript_dynamiczne_elementy_html', 13, 43, 74, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1511, 'GIMP. Tworzenie szablonów stron WWW.', 'Opisywany szablon ma stałą szerokość. Wykorzystuje tzw. Czyszczenie, które nadaje elementom pływającym odpowiednią wysokość. Ponadto w nagłówku, przy użyciu pozycjonowania względnie bezwzględnego, rozjaśniony jest fragment zdjęcia.', 96, 99, 'gimp_tworzenie_szablonow_stron_www6', 13, 197, 74, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1512, 'Podstawy PHP. Operacje na napisach.', 'Programowanie na potrzeby internetu niemal zawsze wiąże się z przeprowadzaniem operacji na zmiennych przechowujących napisy. PHP oferuje bogaty zestaw funkcji ułatwiających pracę z napisami. Pozwalają one na konwersję napisów pomiędzy różnymi stronami kodowymi polskich znaków (i oczywiście nie tylko polskich), wycinanie fragmentów napisów, porównywanie, wyszukiwanie wzorców i wiele innych.', 100, 102, 'podstawy_php_operacje_na_napisach', 13, 11, 74, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1513, 'Mistrzostwa świata w piłce nożnej, czyli Propel i DBDesigner w akcji.', 'Kolejne spotkanie z Propelem poświęcamy praktycznemu przykładowi. Wykorzystując DBDesignera oraz Propela opracujemy aplikację internetową prezentującą zestawienie danych dotyczących mistrzostw świata w piłce nożnej.', 104, 109, 'mistrzostwa_swiata_w_pilce_noznej_czyli_propel_i_dbdesigner_w_akcji', 13, 218, 74, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1514, 'mp3-anywhere.com', 'Strona domowa mp3-anywhere, narzędzie umożliwiające zdalne odtwarzanie muzyki wymaga zmian. O ich wprowadzenie poprosiliśmy projektanta Daniela Boxa z agencji KNI.', 110, 111, 'mp3_anywhere_com', 13, 125, 74, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1515, 'Najlepsze polskie sklepy internetowe. Branża: RTV i AGD.', 'Robiąc zakupy w internecie można łatwo przyzwyczaić się do tego, że każdy produkt jest szczegółowo opisany i przedstawiony na zdjęciach. Mając do dyspozycji taką ilość danych można do woli porównywać konkretne modele i sprzęty, aby w końcu wybrać ten najlepszy. Nie inaczej jest ze sprzętem RTV i AGD. Tylko co zrobić, jeżeli np. w najbliższym sklepie nie ma upatrzonej lodówki czy zmywarki? To proste, wystarczy zamówić je przez internet!', 18, 18, 'najlepsze_polskie_sklepy_internetowe_branza_rtv_i_agd', 14, 112, 75, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1516, 'W cieniu Photoshopa. Przegląd edytorów graficznych online.', 'Czy edytory graficzne instalowane w całości na dysku to już przeżytek? Trudno powiedzieć. Faktem jest, że w sieci coraz częściej można się natknąć na aplikacje, które obrabiają pliki graficzne wykorzystując do tego jedynie przeglądarkę.', 22, 25, 'w_cieniu_photoshopa_przeglad_edytorow_graficznych_online', 15, 230, 75, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1517, 'Armaty na spam. Test rozwiązań antyspamowych w wiodących firmach hostingowych w Polsce.', 'O spamie jest ostatnio bardzo głośno - jego ilość rośnie lawinowo i coraz bardziej utrudnia nam korzystanie z internetu. Tradycyjne narzędzia antyspamowe okazują się mało skuteczne. Dlatego firmy hostingowe, wychodząc naprzeciw potrzebom klientów, musiały poszukać nowych rozwiązań. Jakie to rozwiązania i czy są skuteczne zbadaliśmy testując z oferty dostawców hostingu z pierwszej dziesiątki listy TOP100.pl.', 26, 28, 'armaty_na_spam_test_rozwiazan_antyspamowych_w_wiodacych_firmach_hostingowych_w_polsce', 20, 231, 75, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1518, 'Nie tylko twardy dysk. Przegląd serwisów hostujących pliki.', 'Zasoby zgromadzone i przechowywane na lokalnym dysku komputera lub na płytach CD/DVD są zazwyczaj bezpieczne i łatwo dostępne, jednak tylko dla ich posiadacza. Gdy zachodzi potrzeba podzielenia się nimi z innymi użytkownikami sieci, pojawia się problem jak je udostępnieć. Jedynym z praktycznych rozwiązań w takich sytuacjach jest wykorzystanie któregoś z publicznych serwerów hostingowych, które przyjmą nasz plik i za pośrednictwem przygotowanych odsyłaczy udostępnią go innym.', 30, 31, 'nie_tylko_twardy_dysk_przeglad_serwisow_hostujacych_pliki', 22, 232, 75, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1519, 'Basecamp. Grunt to dobra organizacja pracy.', 'Tworzysz rozbudowany serwis internetowy dla wymagającego klienta? A może pracujesz w zespole i nie bardzo wiesz jak zapanować nad zadaniami? Możesz mieć nad wszystkim pełną kontrolę, wystarczy odpowiednie narzędzie.', 32, 34, 'basecamp_grunt_to_dobra_organizacja_pracy', 22, 233, 75, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1520, 'Systemy wymiany linków w Polsce.', 'Jedynym z kluczowych elementów w procesie pozycjonowania jest pozyskiwanie linków do strony z określonymi słowami, na które pozycjonujemy naszą witrynę. Istnieje dużo sposobów pozyskiwania linków. Jednym z bardziej popularnych jest korzystanie z systemów wymiany linków.', 36, 39, 'systemy_wymiany_linkow_w_polsce', 22, 234, 75, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1521, 'Księgowość internetowa dla każdego. Zarządzaj dokumentami w firmie za pomocą serwisu ifirma.pl.', 'Każdy, kto prowadzi firmę w internecie, niezależnie od tego czy jest to popularny sklep internetowy czy też konto supersprzedawcy na Allegro, musi się kiedyś zmierzyć z całą masą papierków i deklaracji podatkowych. Warto wtedy sięgnąć po rozwiązania, które w tym pomogą.', 40, 43, 'ksiegowosc_internetowa_dla_kazdego_zarzadzaj_dokumentami_w_firmie_za_pomoca_serwisu_ifirma_pl', 35, 235, 75, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1522, 'Jak zbudowano Tommie.co.uk', 'Nie mogąc znaleźć przyzwoitego narzędzia do zarządzania biurem i pracownikami, w Monitor Media zdecydowaliśmy się na napisanie własnej aplikacji. Jak powstawała TOMMIE wyjaśnia Paul Trickey.', 44, 45, 'jak_zbudowano_tommie_co_uk', 35, 142, 75, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1523, 'Jak założyć forum internetowe. Poradnik praktyczny.', 'Myślicie, że założenie i administrowanie forum to coś, co umieją tylko administratorzy lub wykwalifikowani webmasterzy? Jesteście w błędzie, to nic trudnego!', 46, 51, 'jak_zalozyc_forum_internetowe_poradnik_praktyczny', 25, 236, 75, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1524, 'Google AdWords mistrz absolutny.', 'Google AdWords to fenomen, który zmienił internetowy marketing. Reklamodawcy lokują w nim duże sumy, choć wielu zniechęcają rosnące koszty i oszustwa z kliknięciami. Czy to kopalnia złota, czy tylko miraż?', 52, 55, 'google_adwords_mistrz_absolutny', 25, 237, 75, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1525, 'Długi ogon w wyszukiwarkach internetowych.', 'Jak zbadać popularność witryn w wyszukiwarkach i sprawdzić jak użytkownicy odnajdują witryny w oparciu o mechanizmy wyszukujące w internecie? Czym jest długi ogon w wynikach wyszukiwarek?', 56, 59, 'dlugi_ogon_w_wyszukiwarkach_internetowych', 25, 238, 75, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1526, 'Tworzymy klienta pocztowego.', 'Karl Hodge zabiera nas w podróż po RoundCube Webmailu i pokazuje jak dodać funkcjonalność webmaila do naszego IMAP-owego serwera.', 60, 62, 'tworzymy_klienta_pocztowego', 25, 239, 75, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1527, 'Pokochajmy dostępność.', 'Sieciowe standardy zaakceptowano jako element rozwijającego się internetu. W jaki sposób przygotować nasz serwis, by był pozbawiony barier i dostęp mieli do niego wszyscy? Gdzie i w jaki sposób stosować dostępność wyjaśnia Alaistair Campbell z Nomensy.', 63, 67, 'pokochajmy_dostepnosc', 23, 5, 75, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1528, '"Największym wyzwaniem jest stawienie czoła poglądowi, że wszyscy bloggerzy to ekshibicjoniści". Mena Trott', 'Blogowanie zatraciło gdzieś swoją radość i wypaliło wiele osób, które od dawna publikują w internecie. Oliver Lindberg rozmawia z Meną Trott, współzałożycielką i prezesem grupy ekspertów blogowania Six Apart, by dowiedzieć się dlaczego to dobry czas na uruchomienie jej ostatniej platformy do blogowania.', 68, 69, 'najwiekszym_wyzwaniem_jest_stawienie_czola_pogladowi_ze_wszyscy_bloggerzy_to_ekshibicjonisci_mena_trott', 23, 5, 75, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1529, 'Freeconet. Sposób na (prawie) darmowe dzwonienie.', 'Z Krzysztofem Malickim, prezesem Datera Sp. Z o.o., operatora Freeconetu (www.freeconet.pl) i TelAreny, rozmawia Piotr Perka.', 70, 71, 'freeconet_sposob_na_prawie_darmowe_dzwonienie', 32, 32, 75, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1530, '"Nie myślałem, że pobiję NBP".', 'Jak założyć własny serwis finansowy, który zyska ogromną popularność i zaufanie użytkowników? O tym z redaktorem naczelnym portalu finansowego mybank.pl Jarosławem Wasińskim rozmawia Artur Strzelecki.', 70, 71, 'nie_myslalem_ze_pobije_nbp', 32, 32, 75, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1531, 'ClipFinder. Prosto na dysk.', '', 86, 86, 'clipfinder_prosto_na_dysk', 10, 196, 75, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1532, 'Mailbox Digger. Poczta na skróty.', '', 86, 86, 'mailbox_digger_poczta_na_skroty', 10, 196, 75, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1533, 'NooBlog Writer. Wirtualny pamiętnik.', '', 87, 87, 'nooblog_writer_wirtualny_pamietnik', 10, 196, 75, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1534, 'GIMP. Tworzenie szablonów stron WWW.', 'Prezentowany szablon jest wykonany na bazie układu stałej szerokości. Wykorzystuje on dwie sztuczki techniczne: czyszczenie elementów pływających oraz ukrywanie tekstów. Ponadto dzięki ustaleniu szerokości menu głównego w jednostkach em wymiar menu będzie dopasowany do wielkości czcionki ustalonej w przeglądarce.', 89, 93, 'gimp_tworzenie_szablonow_stron_www7', 13, 197, 75, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1535, 'Last.fm', 'W dobie powszechnego dostępu do internetu wdawać by się mogło, że radio sazane jest na wymarcie. Jednak przeżyło bez większych problemów erę telewizji i także teraz pokazuje swoją siłę. Stacje radiowe nadawane są coraz częściej przez internet. Na tym zmiany się nie kończą - obecnie to przede wszystkim radiosłuchacz ma wpływ na radiowe ramówki. Najlepszym tego przykładem jest serwis Last.fm (http://last.fm) - system muzycznych rekomendacji, który pozwala na tworzenie stacji radiowych z repertuarem automatycznie sopasowywanym do określonych gustów muzycznych.', 94, 95, 'last_fm', 13, 123, 75, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1536, 'INSERT/UPDATE/DELETE. Edycja zawartości bazy danch przy użyciu formularzy HTML.', 'Aplikacja internetowa, która służy do zarządzania informacjami zapisanymi w bazie danych, powinna umożliwiać wykonanie trzech podstawowych operacji: wstawiania (INSERT), edycji (UPDATE) oraz usuwania (DELETE). Wykonanie każdej operacji należy zorganizować w taki sposób, by w żadnej sytuacji spójność danych w bazie nie została zakłócona. Trzeba także wykryć wszelkie możliwe błędy i - w miarę możliwości - poinformować o nich użytkownika, wskazując przyczyny niepowodzenia.', 96, 101, 'insert_update_delete_edycja_zawartosci_bazy_danch_przy_uzyciu_formularzy_html', 13, 122, 75, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1537, 'Surowe szablony PHP', 'Smarty - najpopularniejszy system szablonów dla języka PHP - wprowadza do kodu szereg własnych instruckji, znaczników i funkcji. Przy odrobinie pomysłowości znaczniki Smarty można wyeliminować. Otrzymamy w ten sposób skrypt, który stosuje technikę oddzielenia prezentacji od przetwarzania w oparciu w wbudowanie możliwości języka PHP. Rozwiązanie takie nazywam surowymi szablonami PHP.', 102, 103, 'surowe_szablony_php', 13, 11, 75, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1538, 'Podstawy PHP.', 'Wiemy już jak manipulować zmiennymi przechowującymi napisy. Poznaliśmy szereg przydatnych przy takich operacjach funkcji. Wśród nich znalazły się takie, krórych zadaniem była zmiana małych znaków na duże. I tu pojawił się problem - funkcje te działają poprawnie z podstawowym zestawem znaków ASCII, jednak nie zawsze radzą sobie ze znakami narodowymi. Na szczęście i ten problem da się rozwiązać.', 104, 105, 'podstawy_php4', 13, 11, 75, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1539, 'JavaScript. Dynamiczne elementy HTML.', 'W poprzedniej części powstał prosty dokument HTML z minimalną funkcjonalnością JavaScript, jaką jest rozwinięcie rozszerzonej treści newsa. Stopień zaawansowania skryptu, powiedzmy to sobie szczerze, jest dość mizerny: gdy odkryjemy drugą część wiadomości, nie możemy już jej ukryć. Zajmiemy się tym problemem.', 108, 109, 'javascript_dynamiczne_elementy_html2', 13, 43, 75, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1540, 'Galeoyachting.com.', 'Serwis tureckiego biura turystycznego Galeo Yachting &amp; Travel domagał się nowego projektu. Poprosiliśmy Tobiasa Smidth-Fibigera oraz Mikę B Nielson z Atmosphere Cph o wprowadzenie poprawek.', 110, 111, 'galeoyachting_com', 13, 125, 75, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1541, 'Najlepsze polskie sklepy internetowe. Branża: ogród.', 'Obecnie praktycznie w każdym supermarkecie budowlanym znajduje się dział z asortymentem ogrodowym. Jednak po raz kolejny okazuje się, że w internecie można bez problemu dostać te same rzeczy, a także rzadziej spotykany sprzęt, nasiona czy dodatki, na szukanie których szkoda zwykle czasu.', 18, 18, 'najlepsze_polskie_sklepy_internetowe_branza_ogrod', 14, 112, 76, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1542, 'Bądź mobilny!', 'Telefony komórkowe dawno przestały służyć tylko do prowadzenia rozmów głosowych. Dzisiaj oferują wiele innych funkcji, spośród których najbardziej atrakcyjne są te związane z bezprzewodowym internetem.', 24, 27, 'badz_mobilny', 22, 206, 76, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1543, 'Wikidot.com. Wiki dla każdego.', 'Szukasz prostego narzędzia umożliwiającego szybkie i łatwe uruchamianie własnej strony WWW? A może zawsze chciałeś mieć swoją małą Wikipedię? Jeżeli tak, to koniecznie musisz zainteresować się projektem Wikidot.com - stworzoną przez Michała Frąckowiaka farmą stron typu Wiki.', 28, 31, 'wikidot_com_wiki_dla_kazdego', 22, 240, 76, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1544, 'Telemedycyna, czyli internet w służbie Eskulapa.', 'Trzęsienie ziemi miało 8 stopni, z wioski nie pozostał kamień na kamieniu. Godzinę później na miejscu była już ekipa medyczna. Wielu rannych wymagało natychmiastowej pomocy chirurgicznej. Szybko staną szpital polowy, a technicy zestawili internetowe połączenie satelitarne. Obrazy z przenośnych urządzeń diagnostycznych zostały przesłane w kilka miejsc na świecie, gdzie zespoły specjalistów od medycyny katastrof podjęły błuskawiczne decyzje dotyczące bieżących działań. Nikt nie stracił życia, a jeszcze kilka lat wcześniej w takim przypadku ofiiary śmiertelne byłyby liczone w dziesiątkach. Science fiction? Nie, to obraz współczesnych możliwości telemedycyny - nauki umożliwiającej integrację działań lekarzy specjalistów niezależnie od miejsca, w którym znajduje się w danym momencie człowiek wymagający szybkiej pomocy.', 32, 36, 'telemedycyna_czyli_internet_w_sluzbie_eskulapa', 15, 241, 76, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1545, 'Przechytrzyć spamera.', 'Jak rejestrować się w serwisach internetowych nie zdradzając prywatnego adresu e-mailowego?', 38, 39, 'przechytrzyc_spamera', 20, 242, 76, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1546, 'Jak zbudowano Platial.com.', 'Każdy ma coraz obszerniejszą listę miejsc, które chcieliby odwiedzić. To był właśnie powód, dla którego Di-Ann Eisnor utworzyła Platial - atlas przeznaczony dla ludzi, połączenie social networking z API map.', 40, 41, 'jak_zbudowano_platial_com', 35, 142, 76, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1547, 'Usenet', 'Mimo że fora internetowe cieszą się coraz większą popularnością, to jednak "stary", ale wciąż jary Usenet (znany również jako grupy dyskusyjne) jest wygodniejszy w użyciu. Z Usenetu korzysta codziennie mnóstwo ludzi, więc jest to idealne miejsce do szukania odpowiedzi na problemy z różnych dziedzin życia, nauki itd.', 42, 45, 'usenet', 25, 243, 76, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1548, 'OpenDNS. Szybciej, sprawniej i bezpieczniej.', 'Są różne sposoby na optymalizację połączeń internetowych. Można to robić modyfikując wewnętrzne ustawienia systemy (MTU, TTL, MSS, RWIN itp.), instalując specjalne programy, albo też - jak radzą autorzy serwisu OpenDNS: (http://www.opendns.com) - zmieniając ustawienia serwera DNS.', 46, 48, 'opendns_szybciej_sprawniej_i_bezpieczniej', 25, 244, 76, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1549, 'Budujemy sieciową aplikację.', 'Jak stworzyć bogatą w funkcje sieciową aplikację wyposażoną w widgety ze złożonym interfejsem za pomocą szkieletu ZK Simply Ajax opowiada Karl Hodge.', 49, 51, 'budujemy_sieciowa_aplikacje', 25, 239, 76, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1550, 'Jenzyk gientki...', 'Postanowiłem napisać kilka słów na temat, który jest dość rzadko poruszany podczas dyskusji dotyczących internetu. Temat dość wstydliwy, bo obnażający niedostatki wiedzy przeciętnych "zjadaczy bitów". Chodzi o polską ortografię, a w zasadzie o straszne braki w tej dziedzinie, prezentowane zarówno na stronach internetowych, blogach, forach, jak też (a może przede wszystkim) w codziennych konwersacjach na wszelkiego rodzaju czatach. Nawet jeśli mamy z tym kłopoty, istnieją w sieci narzędzia, które mogą ułatwić nam życie.', 52, 55, 'jenzyk_gientki', 25, 245, 76, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1551, 'Jenzyk gientki...', 'Internetową TV coraz częściej interesują się programiści, dowiedzmy się więc, kto jest tu największym graczem i jak zrobić, by przyszłość należała do nas.', 52, 55, 'jenzyk_gientki2', 25, 245, 76, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1552, 'e-telewizja', 'Internetową TV coraz częściej interesują się programiści, dowiedzmy się więc, kto jest tu największym graczem i jak zrobić, by przyszłość należała do nas.', 56, 59, 'e_telewizja', 23, 246, 76, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1553, 'Rozwój 2.0: czy sieć uratuje świat?', 'Być może uważamy możliwość łączenia się za pośrednictwem Wi-Fi za coś oczywistego, jednak dzieci z krajów Trzeciego Świata dopiero teraz po raz pierwszy doświadczają bezprzewodowej sieci. To zasługa inicjatywy One Laptop Per Children. Z osobami odpowiedzialnymi za projekt rozmawia Scott Carney.', 60, 62, 'rozwoj_2_0_czy_siec_uratuje_swiat', 23, 246, 76, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1554, '"Jestem w stanie zmieniać życie studentów i programistów". Chris DiBona', 'Określenie "Summer of Code" może u niektórych ludzi wywołać ciarki przechodzące po plecach, jednak Chris DiBona, menedżer programu open source w Google, powiedział Oliverowi Lindbergowi, jak tego rodzaju inicjatywy znacząco przekształciły ruch open source.', 63, 65, 'jestem_w_stanie_zmieniac_zycie_studentow_i_programistow_chris_dibona', 32, 32, 76, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1555, 'Rozwój z perspektywami.', 'Z arkadiuszem Szczurowskim, prezesem zarządu serwisu Domeny.pl, rozmawia Piotr Perka.', 66, 67, 'rozwoj_z_perspektywami', 32, 32, 76, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1556, 'Przez partnerstwo do bezpieczeństwa.', 'Ze Stefanem Osthausem - Senior Director Consumer Marketing EMEA and Head of Global Consumer Marketing Operations firmy Symantec w regionie EMEA rozmawia Piotr Perka.', 68, 69, 'przez_partnerstwo_do_bezpieczenstwa', 32, 32, 76, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1557, 'Strażnik ucznia. Domowa cybermania.', '', 82, 82, 'straznik_ucznia_domowa_cybermania', 10, 196, 76, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1558, 'JetPhoto Studio. Zdjęcia w sieci.', '', 82, 82, 'jetphoto_studio_zdjecia_w_sieci', 10, 196, 76, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1559, 'TubeTools. Firmy pod kontrolą.', '', 83, 83, 'tubetools_firmy_pod_kontrola', 10, 196, 76, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1560, 'Analiza dokumentu DTD języka HTML 4.01 strict przy użyciu wyrażeń regularnych PCRE w PHP.', 'Analiza składni, nazywana parsingiem, jest bardzo często pierwszym etapem przetwarzania. Parsing poprzedza między innymi wyświetlenie dokumentu HTML przez przeglądarkę (parsing dokumentu HTML) oraz stosowanie stylów (parsing dokumentu CSS). W artykule przedstawię przykładową implementację parsingu dokumentu DTD.', 85, 89, 'analiza_dokumentu_dtd_jezyka_html_4_01_strict_przy_uzyciu_wyrazen_regularnych_pcre_w_php', 13, 247, 76, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1561, 'Salon.pl', 'Rynek nieruchomości w Polsce kwitnie. Co prawda obiecanych 3 milionów mieszkań szybko się nie doczekamy, jednak w budownictwie nastąpiło pewne ożywienie. Jednocześnie wśród osób czekających na wybudowanie swojego wymarzonego mieszkania istnieje potrzeba porozmawiania (np. o bieżącym przebiegu prac) z przyszłymi sąsiadami w danym bloku czy na osiedlu, co oferuje serwis Salon.pl.', 90, 91, 'salon_pl', 13, 123, 76, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1562, 'Podstawy PHP.', 'Formularze są podstawą aplikacji internetowych. Mimo że na stronach internetowych nie widać ich zbyt wiele, w panelach administracyjnych wszelkiego rodzaju formularzy jest znacznie więcej. To właśnie dzięki formularzom można dodawać treści na strony bez konieczności ręcznej edycji plików czy zawartości bazy danych.', 92, 94, 'podstawy_php5', 13, 11, 76, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1563, 'JavaScript. Dynamiczne elementy HTML.', 'W poprzednim odcinku po kilku modyfikacjach otrzymaliśmy skrypt, który powoduje zwinięcie bądź rozwinięcie akapitu z rozszerzoną treścią wiadomości. Uzupełnijmy go zmienną wartości linka Więcej - kiedy akapit będzie schowany, będzie ona równa "więcej", w przeciwnym razie przybierze wartość "schowaj".', 95, 97, 'javascript_dynamiczne_elementy_html3', 13, 43, 76, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1564, 'GIMP. Tworzenie szablonów stron WWW.', 'Opisywany szablon jest podzielony na trzy poziome obszary. Jest to szablon stałej szerokości, wyśrodkowany na stronie. Środkowy pas wykorzystuje sztuczkę udawanych kolumn, zaś etykiety opcji menu są wyśrodkowane poziomo i pionowo.', 98, 103, 'gimp_tworzenie_szablonow_stron_www8', 13, 197, 76, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1565, 'INSERT/UPDATE/DELETE', 'W artykule przedstawię technikę implementacji operacji INSERT/UPDATE/DELETE na przykładzie bazy danych prezentującej zestawienie filmów. Przykładowa baza danych zawiera trzy tabele, jedną relację jeden do wielu i jedną relację wiele do wielu. Przygotowany interfejs WWW pozwala na pełną edycję rekordów zapisanych w bazie danych.', 104, 109, 'insert_update_delete', 13, 122, 76, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1566, 'acegamez.co.uk', 'Redaktor Paul Rayan zasięgną opinii ekspertów radzących jak usprawnić jego stronę z grami AceGamez. Jak powinna wyglądać, zapytaliśmy Zaida Al.-Asadiego, projektanta z londyńskiej agencji Pod1.', 110, 111, 'acegamez_co_uk', 13, 125, 76, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1567, 'Najlepsze polskie sklepy internetowe. Branża: dekoracja i wyposażenie wnętrz', 'Sklepy internetowe z branży wyposażenia wnętrz to najwyższa liga. Nie ma wśród nich słabych stron. Ich klienci szukają w internecie albo rzeczy nietypowych, albo na tyle ekskluzywnych, że nie znajdzie się ich w supermarkecie. Nie kosztują one mało, dlatego tak ważna jest profesjonalna otoczka wokół sklepu.', 18, 18, 'najlepsze_polskie_sklepy_internetowe_branza_dekoracja_i_wyposazenie_wnetrz', 14, 112, 77, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1568, 'Jak stworzyć serwis Web 2.0. Poradnik praktyczny', 'Wydaje się, że już wszystko zostało wymyślone. Niektórzy jednak twierdzą, że najlepsze dopiero przed nami. Zobaczmy zatem, jak stworzyć nowoczesny serwis internetowy.', 22, 28, 'jak_stworzyc_serwis_web_2_0_poradnik_praktyczny', 23, 248, 77, 7);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1569, 'Projektowanie stron ze szkieletem Web 2.0.', 'Internet rozwija się przekraczając wszystkie wskaźniki. Nawet skromna funkcja odświeżania strony została zdobyta przez coraz bardziej intensywną falę technologii Web 2.0. Ale to dobrze, mówi Dan Frost.', 30, 33, 'projektowanie_stron_ze_szkieletem_web_2_0', 23, 248, 77, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1570, 'iPhone telefonem przyszłości', 'Gdy w 2001 roku Microsoft wypuścił na rynek Windows XP, Apple odpowiedział iPodem, który zrewolucjonizował przemysł muzyczny. W roku premiery Windows Vista firma z nadgryzionym jabłkiem w logo uderza ponownie urządzeniem, które według Steva Jobsa, szefa Apple, ma całkowicie zmienić podejście do komunikacji, związki między telefonią komórkową, internetem i przenośnymi odtwarzaczami multimediów. Czy iPhone będzie rewolucją na miarę iPoda?', 34, 36, 'iphone_telefonem_przyszlosci', 23, 5, 77, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1571, 'VoIP dla resellerów', 'Operatorów usługi VoIP, czyli firm oferujących połączenia VoIP dla użytkowników końcowych jest kilkadziesiąt. Jednak tak naprawdę w Polsce działa tylko kilku "prawdziwych" operatorów tj. posiadających własną infrastrukturę. Reszta to firmy resellerskie.', 38, 40, 'voip_dla_resellerow', 22, 108, 77, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1572, 'Poradnik egzaminacyjny dla gimnazjalistów. Zasoby sieciowe, które koniecznie powinieneś znać.', 'W chwili gdy piszę te słowa, trwają w najlepsze wakacje. Zegar jednak tyka i termin egzaminów gimnazjalnych zbliża się nieubłaganie. Trwa porządkowanie i systematyzowanie wiedzy, powtarzanie materiału. W tym artykule przedstawię wybrane zasoby sieciowe, które mogą wspomóc uczniów trzecich klas gimnazjów w przygotowywaniu do wiosennej sesji egzaminacyjnej.', 42, 45, 'poradnik_egzaminacyjny_dla_gimnazjalistow_zasoby_sieciowe_ktore_koniecznie_powinienes_znac', 22, 25, 77, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1573, 'Jak wycisnąć więcej z programów partnerskich', 'Uczestniczysz w programie partnerskim i mało zarabiasz? W tym artykule pokażę rozwiązania, których nie znasz albo o nich zapomniałeś.', 46, 49, 'jak_wycisnac_wiecej_z_programow_partnerskich', 35, 249, 77, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1574, 'Jak zbudowano maps.google.com', 'To Google Maps należałoby obarczyć za rewolucję, którą spowodował Ajax. O tym jak tworzono usługę, która rozpoczęła światową manię na mapy opowiada Thai Tran.', 50, 51, 'jak_zbudowano_maps_google_com', 35, 142, 77, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1575, 'Pozycjonowanie witryn WWW: gra według reguł', 'Czy chcielibyśmy odnaleźć drogę do doskonałego wyszukiwania i wspiąć się na szczyt Google''a? Wysunąć się przed konkurencję? Ekspert pozycjonowania Mark Buckingham rozmawiał z Mattem Cuttsem z Google, który przedstawił swój własny pogląd na pozycjonowanie.', 52, 56, 'pozycjonowanie_witryn_www_gra_wedlug_regul', 25, 238, 77, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1576, 'Budujemy serwis modułowy.', 'W tym miesiącu przyjrzymy się XOOPS-owi, zbudowanemu na PHP szkieletowi służącemu do tworzenia stron WWW. Stosujemy go do budowy zintegrowanych, modułowych stron.', 57, 59, 'budujemy_serwis_modulowy', 25, 250, 77, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1577, 'Firebug. Debugowanie stron WWW.', '90% czasu poświęcanego na realizację projektu WWW jest marnowane na poprawianie błędów w tym, co do tej pory zostało zrobione. Wykrywanie nieprawidłowości w kodzie HTML, CSS czy JavaScript może być szybkie i efektywne. Przyjrzymy się Firebugowi, narzędziu do debugowania stron WWW.', 60, 63, 'firebug_debugowanie_stron_www', 25, 251, 77, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1578, 'Wykopać cały świat.', 'Tomasz Drożdżyński z Wykop.pl to bardzo tajemniczy człowiek. Nam jednak udało się dowiedzieć czegoś więcej o jego serwisie.', 64, 65, 'wykopac_caly_swiat', 32, 32, 77, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1579, 'Polskie sklepy online: bomba z opóźnionym zapłonem.', 'Z Andrzejem Sobolem, prezesem ABC Data Sp. z o.o. Rozmawia Piotr Perka.', 66, 67, 'polskie_sklepy_online_bomba_z_opoznionym_zaplonem', 32, 32, 77, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1580, '"Bez otwarcia nie można dobrze prosperować w dzisiejszym ekosystemie". Bradley Horowitz', 'Pod koniec ubiegłego roku Yahoo sprawiało wrażenie, że się szamoce. Jednak nowe narzędzie Pipes i wewnętrzny inkubator Brickhouse sprawił, że internetowy gigant po raz kolejny odzyskał formę. Oliver Lindberg rozmawia z człowiekiem, dzięki któremu to się zdarzyło - Bradleyem Horowitzem.', 68, 70, 'bez_otwarcia_nie_mozna_dobrze_prosperowac_w_dzisiejszym_ekosystemie_bradley_horowitz', 32, 32, 77, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1581, 'Multikontakt. Sieciowe rozmówki.', '', 84, 84, 'multikontakt_sieciowe_rozmowki', 10, 196, 77, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1582, 'Click Clock. Pogoda na świecie.', '', 84, 84, 'click_clock_pogoda_na_swiecie', 10, 196, 77, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1583, 'Unyte. Pokaż swój pulpit.', '', 85, 85, 'unyte_pokaz_swoj_pulpit', 10, 196, 77, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1584, 'Profeo.pl', 'Moda na serwisy społecznościowe nie przemija. Każdego miesiąca jesteśmy informowani o kilku nowych projektach stworzonych przez polskich programistów. Jednym z najnowszych projektów zakrojonych na szerszą skalę jest Profeo - serwis zrzeszający profesjonalistów różnych branż.', 86, 87, 'profeo_pl', 13, 123, 77, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1585, 'Blogi webmasterskie. Poczytaj, co piszą koledzy po fachu.', 'Internet od zawsze był cennym źródłem informacji dla webmasterów. Jednak ostatnio daje się zauważyć spore przetasowania w branży serwisów związanych z tworzeniem stron WWW. Na znaczeniu tracą duże materiały autorstwa wielu osób, a na czoło wysuwają się specjalistyczne blogi.', 88, 87, 'blogi_webmasterskie_poczytaj_co_pisza_koledzy_po_fachu', 13, 252, 77, 0);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1586, 'Wymiana skórki aplikacji internetowej.', 'Termin "szablon" jest obecnie rozumiany na dwa sposoby. Pierwsze ze znaczeń odnosi się do zestawu plików HTML/CSS, na podstawie których można przygotować witrynę WWW, zaś drugie - do programistycznych technik wypełniania strony WWW danymi. Połączenie obydwu rozwiązań pozwala na bardzo wydajną zmianę wyglądu nawet złożonych witryn WWW i aplikacji internetowych. Wykonanie i wymianę skórki przedstawię na przykładzie aplikacji, która kataloguje czcionki oficjalnych projektów Ogrodu Zen CSS: http://www.csszengarden.com.', 90, 95, 'wymiana_skorki_aplikacji_internetowej', 13, 253, 77, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1587, 'Podstawy PHP. Obsługa sesji', 'Protokół HTTP jest protokołem bezstanowym, co oznacza, że pomiędzy wywołaniami kolejnych stron serwisu tracimy informacje o użytkowniku, który z niego korzysta. Można co prawda próbować go rozpoznawać na przykład po IP. Jest to jednak sposób zawodny, gdyż wielu internautów może być widocznych spod tego samego adresu IP. Na szczęście już dawno wymyślono na to sposób - sesje.', 96, 98, 'podstawy_php_obsluga_sesji', 13, 11, 77, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1588, 'JavaScript. Dynamiczne elementy HTML', 'Jeśli potrafimy bez ściągawki wykonać zwijanie i rozwijanie akapitu z rozszerzoną treścią, możemy być z siebie dumni. Oznacza to, że zrozumieliśmy istotę onclick i zmiany w dokumencie HTML. Umiemy też pobrać zawartość każdego znacznika HTML. W tym odcinku nauczymy się uzyskiwać efekty, które już znamy, lecz trochę innymi sposobami.', 99, 101, 'javascript_dynamiczne_elementy_html4', 13, 43, 77, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1589, 'NotH: edycja kodu XHTML/CSS', 'Program NotH jest bezpłatnym edytorem kodu XHTML/CSS. Zawiera paletę szablonów, która ułatwia wprowadzanie znaczników XHTML oraz właściwości CSS. Paleta jest ściągawką udostępniającą w wygodny sposób wszystkie elementy XHTML 1.0 oraz dużą część właściwości CSS 2.1. Eliminuje to konieczność kopiowania i wklejania fragmentów specyfikacji HTML, XHTML czy CSS. Najczęściej wykorzystywane szablony kodu mogą być wstawiane skrótami klawiszowymi. Dzięki dublowaniu skrótów klawiszowych oraz kontekstowemu (tj. zależnemy od rozszerzenia edytowanego pliku) udostępnianiu szablonów, te same skróty klawiszowe realizują różne zadania, inne w dokumentach HTML, a inne w dokumentach CSS. W ten sposób efektywna edycja kodu XHTML/CSS wymaga zapamiętania zaledwie kilkunastu skrótów klawiszowych.', 106, 109, 'noth_edycja_kodu_xhtml_css', 13, 254, 77, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1590, 'The Glow Company', 'The Glow Company sprzedaje przedmioty, które dosłownie świecą, jednak czy firmowa strona także błyszczy? Ben King, dyrektor strategiczny w bit10 zają się jej przebudową.', 110, 111, 'the_glow_company', 13, 125, 77, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1591, 'Najlepsze polskie sklepy internetowe. Branża: zegarki.', 'W historii naszych comiesięcznych rankingów sklepów internetowych już raz pojawiła się kategoria "biżuteria i zegarki". Po raz kolejny okazuje się jednak, że w polskim internecie cały czas przybywa nowych sklepów, także tych niszowych. Dlatego też zebranie dziesięciu najlepszych serwisów oferujących wyłącznie zegarki nie było zadaniem szczególnie trudnym.', 18, 18, 'najlepsze_polskie_sklepy_internetowe_branza_zegarki', 14, 112, 78, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1592, 'Przeglądarki internetowe pod lupą', 'Przeglądarka stron WWW należy do podstawowych narzędzi każdego internauty. To właśnie od niej w głównej mierze zależy wygoda i przyjemność serfowania po zasobach sieci. Firefox, Internet Explorer, a może Opera? Przyjrzeliśmy się sześciu programom, wśród których trzy najpopularniejsze w Polsce przeglądarki oraz trzy mniej znane.', 24, 31, 'przegladarki_internetowe_pod_lupa', 23, 255, 78, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1593, 'Przyszłość według Google', 'W niespełna 10 lat Google podbił świat. Co jednak czeka nas w następnej dekadzie? "Zapytaj Google" powierzyliśmy Gary''emu Marschalowi. Więc zapytał, a oto co znalazł...', 32, 36, 'przyszlosc_wedlug_google', 23, 5, 78, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1594, 'Jak zbudowano jumpman23.com', 'Marka Nike''a - Jordan to duży biznes mający wielu fanów, a sam serwis to efekt pracy Blast Radiusa. Dla Michaela Ciebina, który "obsesyjnie dba o doskonałość", to coś, co pozwoliło serwisowi zaistnieć.', 38, 39, 'jak_zbudowano_jumpman23_com', 35, 142, 78, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1595, 'Wycena serwisów internetowych', 'Wycena serwisów jest pojęciem dosyć mglistym oraz dalece niezdefiniowanym. Jak do tej pory przeszukując sieć tak polsko-, jak i obcojęzyczną nie natrafiłem na żaden ślad konkretnego opracowania na ten temat. Z racji tego, że w swojej dotychczasowej działalności poruszyłem się wokół zagadnienia wycen w sektorze internetowym, postanowiłem opublikować opracowaną przeze mnie metodologię wyceny serwisów.', 40, 42, 'wycena_serwisow_internetowych', 35, 256, 78, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1596, 'Gorące 40 aplikacji Web 2.0', 'Aplikacje online są wszędzie. Co więcej, większość z nich spisuje się bardzo dobrze, a niektóre to budzące zachwyt prawdziwe perełki. Gary Marshall wybrał "fantastyczną 40" i starał się przyłożyć do tego zadania.', 44, 49, 'gorace_40_aplikacji_web_2_0', 22, 173, 78, 6);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1597, 'Pomoc w sieci? Maturalnie!', 'Rok szkolny już w toku, a więc pora zabrać się do nauki, szczególnie jeśli do egzaminu dojrzałości zostało niewiele ponad pół roku. Gromadzenie wiedzy prawie się kończy, teraz czas na powtórki i porządkowanie. Oczywiście trzeba przeglądać książki i notatki z zeszytów, ale zwykle to nie wystarcza. I tutaj jak zawsze w sukurs przychodzi niezawodny internet. Przyjrzymy się więc zasobom sieciowym, które mogą być przydatne dla zapracowanego i zestresowanego maturzysty.', 50, 54, 'pomoc_w_sieci_maturalnie', 22, 25, 78, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1598, 'Czy to jeszcze sport czy już cybersport?', 'Ostatnio coraz częściej można usłyszeć o niezwykłym zjawisku, jakim jest sport elektroniczny. Jedni dostrzegają w cybersporcie milionowe zyski, inni z zachwytem prezentują sylwetki najlepszych zawodników. Zachęceni owymi metryczkami gracze spędzają coraz więcej czasu przy swoich maszynach, a socjolodzy zauważają, że przedstawiciele młodego pokolenia jeszcze bardziej oddalają się od rzeczywistości. Mówi się o e-sporcie, cybersporcie, v-sporcie lub netgamingu, myśląc o tym samym. No właśnie, o czym?', 56, 60, 'czy_to_jeszcze_sport_czy_juz_cybersport', 15, 257, 78, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1599, 'Rozbudowujemy nasz CMS', 'Integrujemy funkcje edycyjne WYSYWIG HTML-a z Systemem Zarządzania Treścią aplikacji do prowadzenia bloga lub internetowego sklepu za pomocą Spaw Editor 2.', 61, 63, 'rozbudowujemy_nasz_cms', 25, 258, 78, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1600, 'Google SketchUp. Świat w trzech wymiarach', 'Modelowanie trójwymiarowych brył nie musi być wcale tak skomplikowane jak mogłoby się wydawać. Dzięki takim programom jak Google SketchUp narysowanie prostego przestrzennego obiektu nie powinno sprawić nikomu większych problemów, a co bardziej ambitnym użytkownikom pozwoli nawet dokładnie odwzorować istniejące budowle i wyeksportować je na wirtualny globus Google Earth.', 64, 66, 'google_sketchup_swiat_w_trzech_wymiarach', 25, 259, 78, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1601, 'Diino. Zarchiwizuj swoje lokalne zasoby w sieci.', 'Gdy mamy na dysku twardym materiały, które są dla nas szczególnie cenne bądź którymi chcielibyśmy się czasem podzielić z innymi użytkownikami sieci, nie musimy już przegrywać ich na płyty ani wysyłać pocztą. Wystarczy zarejestrować się w serwisie Diino (http://www.diino.com) i za pośrednictwem udostępnionego tam programu tworzyć awaryjne kopie wybranych zasobów.', 67, 70, 'diino_zarchiwizuj_swoje_lokalne_zasoby_w_sieci', 25, 164, 78, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1602, 'Gadu-Gadu inaczej. Na skróty po informacje.', 'Z Gadu-Gadu korzysta niemal co drugi internauta. Sieć ta może jednak służyć nie tylko do prowadzenia dyskusji, ale i do szybkiego pozyskiwania wielu pożytecznych informacji.', 71, 71, 'gadu_gadu_inaczej_na_skroty_po_informacje', 25, 260, 78, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1603, '"Przeszliśmy długą drogę, ale nie sądzę, by komputerowy maniak kiedykolwiek mógł być gwiazdą rocka. "Kevin Rose', 'Digg to najpopularniejszy na świecie serwis newsowy tworzony przez użytkowników. Ostatnia rewolta pokazała, że naprawdę jest prowadzony przez użytkowników. Założyciel Kevin Rose opowiada Oliverowi Lindbergowi jak wyglądał najbardziej burzliwy dzień w historii Digga i jakiego następnego kroku oczekują od niego użytkownicy.', 71, 73, 'przeszlismy_dluga_droge_ale_nie_sadze_by_komputerowy_maniak_kiedykolwiek_mogl_byc_gwiazda_rocka_kevin_rose', 32, 32, 78, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1604, 'Internet jednak niebezpieczny', 'Z podinspektorem Mariuszem Sokołowskim i nadkomisarzem Zbigniewem Urbańskim z Komendy Głównej Policji rozmawia Piotr Perka.', 74, 75, 'internet_jednak_niebezpieczny', 32, 32, 78, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1605, 'Wink. Twórca wideotutoriali', '', 88, 88, 'wink_tworca_wideotutoriali', 10, 196, 78, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1606, 'Miro. Specjalista od filmów', '', 88, 88, 'miro_specjalista_od_filmow', 10, 196, 78, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1607, 'WebHat Web Gallery', '', 89, 89, 'webhat_web_gallery', 10, 196, 78, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1608, 'Kaspersky. Internet Security 7.0', 'Podłączając komputer do internetu użytkownicy narażają się na możliwość utraty coraz większej ilości danych gromadzonych na dyskach twardych. Zagrożenie można ograniczyć instalując np. nowy pakiet firmy Kaspersky Lab.', 90, 91, 'kaspersky_internet_security_7_0', 10, 38, 78, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1609, 'Gastronauci.pl', 'Internet to nie tylko miejsce dla rozrywki, aktualnych wiadomości czy też niezliczonych sklepów internetowych. To również ogromne źródło informacji o wszystkim. Tu w serwisie Telepolis.pl poznamy opinie użytkowników różnych marek telefonów, kinomani na FilmWeb.pl opowiedzą wrażenia po obejrzeniu jakiegoś filmu, a gdy zechcemy odwiedzić polecaną przez internautów restaurację, możemy skorzystać z serwisu Gastronauci.pl.', 92, 93, 'gastronauci_pl', 13, 123, 78, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1610, 'GIMP. Tworzenie szablonów stron WWW', 'Szablony XHTML/CSS można podzielić na dwie kategorie: szablony sztywne oraz szablony płynne. Szerokość szablonów sztywnych jest stała i nie zależy od rozmiaru okna przeglądarki. Natomiast szablony płynne dostosowują się do szerokości okna przeglądarki, wypełniając całą dostępną przestrzeń. Niektóre projekty graficzne mogą służyć do wykonania zarówno szablonu sztywnego, jak i płynnego. W artykule opiszę w jaki sposób narysować projekt szablonu w GIMP-ie oraz jak na bazie pliku XCF przygotować dwa identycznie wyglądające szablony: sztywny i pływający.', 94, 97, 'gimp_tworzenie_szablonow_stron_www9', 13, 197, 78, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1611, 'GIMP. Tworzenie szablonów stron WWW', 'Witryna xhtmlpp.gajdaw.pl stanowi suplement do książki pt. "HTML, XHTML i CSS. Praktyczne projekty". Wykonując witrynę wykorzystałem: PHP, Smarty, MySQL, phpMyAdmin, Propel, aplikację DBDesigner oraz edytor NotH. Przyjazne adresy URL wykonałem wykorzystując moduł mod_rewrite i pliki.htaccess. Wszystkie podstrony witryny pochodzą z bazy danych, zaś obrazy, style CSS i skrypty Java', 94, 97, 'gimp_tworzenie_szablonow_stron_www10', 13, 197, 78, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1612, 'Webmastering w przykładach xhtml.gajdaw.pl', 'Witryna xhtmlpp.gajdaw.pl stanowi suplement do książki pt. "HTML, XHTML i CSS. Praktyczne projekty". Wykonując witrynę wykorzystałem: PHP, Smarty, MySQL, phpMyAdmin, Propel, aplikację DBDesigner oraz edytor NotH. Przyjazne adresy URL wykonałem wykorzystując moduł mod_rewrite i pliki.htaccess. Wszystkie podstrony witryny pochodzą z bazy danych, zaś obrazy, style CSS i skrypty JavaScript są udostępniane jako statyczne pliki.', 98, 102, 'webmastering_w_przykladach_xhtml_gajdaw_pl', 13, 12, 78, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1613, 'Flagi państwowe, ikony uatrakcyjniające wygląd witryny WWW', 'Miniaturowe flagi państwowe są bardzo często wykorzystywane jako ikony ułatwiające przekaz informacji. Fozwiązania takie znajdziemy między innymi w serwisie 90minut.pl, gdzie narodowość piłkarzy jest przedstawiona w postaci miniaturowej flagi. W artykule opiszę w jaki sposób wzbogacić witrynę o ikony flag.', 103, 105, 'flagi_panstwowe_ikony_uatrakcyjniajace_wyglad_witryny_www', 13, 12, 78, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1614, 'Podstawy PHP. Programowanie obiektowe.', 'Niedoświadczeni programiści często mają problem ze zrozumieniem idei programowania obiektowego. A jest ona bardzo prosta. W programowaniu obiektowym odchodzimy od modelowania przestrzeni danych, operując na przestrzeni obiektu. Staramy się po prostu za pomocą klas opisać modelowaną rzeczywistość. Modelowanie rozpoczynamy od obiektów najbardziej ogólnych, powoli je uszczegóławiając.', 106, 108, 'podstawy_php_programowanie_obiektowe', 13, 11, 78, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1615, 'JavaScript. Dynamiczne elementy HTML', 'Dokument HTML, nad którym pracujemy od czterech lekcji, przeobraził się w całkiem zgrabne kaczątko. Używając jednego kliknięcia myszy, odwiedzający naszą stronę może natychmiast odsłonić rozszerzoną treść newsa. Co jednak z tymi, którym nie chce się klikać?', 109, 111, 'javascript_dynamiczne_elementy_html5', 13, 43, 78, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1616, 'JavaScript. Dynamiczne elementy HTML', 'Sklep online z artykułami w cenie 1 funta to wspaniały pomysł. Jednak stronie brakuje równie wspaniałego pomysłu. Chris Fullman z interaktywnej agencji AgencyNet podją się dodania sklepowi ostrości.', 109, 111, 'javascript_dynamiczne_elementy_html6', 13, 43, 78, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1617, 'Najlepsze polskie sklepy internetowe. Branża: motoryzacja', 'O tym, że rynek części zamiennych do samochodów to potężna branża przekonał się każdy, kto chociaż raz naprawiał lub tuningował swój samochód. Praktycznie w każdym większym mieście funkcjonują hurtownie części samochodowych, udanie konkurujące z ASO. Kwestią czasu było więc wkroczenie handlu częściami do internetu.', 18, 18, 'najlepsze_polskie_sklepy_internetowe_branza_motoryzacja', 14, 112, 79, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1618, 'Hosting 2007', 'Jak co roku, publikujemy raport na temat usług hostingowych w Polsce. Co zmieniło się w ciągu ostatniego roku, jakie nowe usługi są oferowane przez dostawców, czym należy się kierować przy wyborze usługi odpowiedniej do swoich potrzeb. Publikujemy również tabelę porównawczą dwudziestu największych polskich firm hostingowych.', 22, 29, 'hosting_2007', 2, 56, 79, 8);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1619, 'Jak zostać dostawcą usług hostingowych?', 'Telekomunikacja, nowe technologie i usługi internetowe są obszarami zainteresowań wielu osób poszukujących swego pomysłu na biznes. Wychodząc naprzeciw oczekiwaniom Klientów, Netia zaoferowała kompleksową platformę hostingową, dzięki której każda firma może zostać dostawcą usług hostingowych. Zaletą rozwiązania jest przede wszystkim model współpracy, w którym Partner samodzielnie tworzy produkty, publikuje ofertę, czy zarządza sprzedażą. Branding paneli, podpięcie usługi pod domenę Partnera i narzędzia administracyjne sprawiają, że usługę hostingową Netii można określić mianem "uszytej na miarę"', 30, 31, 'jak_zostac_dostawca_uslug_hostingowych', 44, 32, 79, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1620, 'Budujemy imperium na eBayu', 'Czy jesteśmy sezonowymi sprzedawcami czy też chcemy zwiększyć nasze wpływy, usprawnienie umiejętności sprzedaży może nam się bardzo przydać. Supersprzedawca Mark Buckingham objaśnia, jak to zrobić.', 32, 35, 'budujemy_imperium_na_ebayu', 2, 40, 79, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1621, 'Jak zarabiać na małej stronie WWW', 'Osoby prowadzące własne witryny internetowe zwykle traktują to jak hobby. Ale coraz częściej twórców zastanawia się jak zarobić na swoich małych i średnich srtonach. Sposobów jest wiele - wśród nich wyróżniają się programy afiliacyjne.', 36, 38, 'jak_zarabiac_na_malej_stronie_www', 2, 40, 79, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1622, 'Jak zbudowano Twitter.com', 'Bardzo rzadko sieciowa aplikacja odnotowuje taki wzrost popularności. Uruchomiony niewiele ponad rok temu Twitter zdobył już nagrodę SXSW Web Award w kategorii blogu. Biz Stone, współzałożyciel, objaśnia kluczową rolę prostoty.', 40, 41, 'jak_zbudowano_twitter_com', 2, 40, 79, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1623, 'Wiedza tłumu w służbie jednostki. Zadawanie pytań i społeczne udzielanie odpowiedzi w serwisach typu Web 2.0', 'Do zdobywających ostatnio szczyty popularności serwisów Web 2.0 zaliczamy również witryny, na których internauci zadają pytania na dowolne tematy, a odpowiedzi udziela społeczność dobrowolnie dzieląca się wiedzą. Do sztandarowych witryn tego typu należy amerykański serwis Yahoo! Anwers (http://answers.yahoo.com), a w Polsce coraz większą popularność zdobywa witryna Pytamy.pl (http://pytamy.interia.pl). Przyjrzyjmy się wspólnie temu i kilku innym konkurencyjnym serwisom.', 42, 44, 'wiedza_tlumu_w_sluzbie_jednostki_zadawanie_pytan_i_spoleczne_udzielanie_odpowiedzi_w_serwisach_typu_web_2_0', 2, 261, 79, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1624, 'Kliknij, żeby zadzwonić', 'Wyszukiwarki internetowe są już podstawą działań reklamowych największych firm w Posce i za granicą. W skali świata wydatki na taką reklamę sięgają kilkunastu miliardów dolarów (w Polsce w 2007 roku ponad 80 mln zł). Podstawowym narzędziem są tutaj linki sponsorowane. Jednak te klasyczne, wyłącznie przenoszące na stronę firmy, zaczynają być niewystarczające. Coraz więcej firm amerykańskich i europejskich decyduje się na reklamę w postaci sponsorowanych linków telefonicznych (click-to-call), które wprost z wyszukiwarki internetowej łączą nas z handlowcami.', 46, 47, 'kliknij_zeby_zadzwonic', 2, 91, 79, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1625, '"Mamy zamiar odsunąć potężną strukturę internetu od wyszukiwarek". Jimmy Wales', 'Wikipedia zrewolucjonizowała sposób, w jaki traktujemy informację. Obecnie jej założyciel przygląda się rynkowi wyszukiwania. Oliver Lindberg rozmawia z Jimmym Walesem, jedną z najbardziej barwnych postaci internetu, o nadchodzącej open source''owej wyszukiwarce, o której sile mają decydować ludzie.', 48, 49, 'mamy_zamiar_odsunac_potezna_strukture_internetu_od_wyszukiwarek_jimmy_wales', 2, 6, 79, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1626, 'Google Maps na własnej witrynie', 'Google Maps to pierwsza w pełni interaktywna internetowa mapa Ziemi. Ta niewątpliwie rewolucyjna usługa łączy możliwości zdjęć satelitarnych i tradycyjnej mapy kartograficznej. Udostępniane przez Google narzędzie Maps API pozwala na bezpłatnie umieszczanie mapy Google na własnej witrynie. Pokażę jak szybko stworzyć atrakcyjną mapę dojazdową w dziale Kontakt firmowej witryny.', 50, 54, 'google_maps_na_wlasnej_witrynie', 25, 262, 79, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1627, 'Profesjonalne forum w pół godziny', 'Myślicie, że założenie forum internetowego na własnym serwerze to rzecz, którą potrafią wyłącznie fachowcy? Jesteście w błędzie. Samodzielna instalacja jednego ze skryptów i konfiguracja forum to kwestia dobrych materiałów i kilkudziesięciu minut pracy.', 55, 59, 'profesjonalne_forum_w_pol_godziny', 25, 263, 79, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1628, 'Last.fm. Muzyka łączy ludzi (także przez internet)', 'Jeśli jesteś zapalonym audiofilem i nie wyobrażasz sobie życia bez codziennej dawki ulubionych przebojów to koniecznie musisz zapoznać się z ofertą strony Last.fm (http://www.lastfm.pl) - internetowego centrum zarządzania gustami muzycznymi.', 60, 61, 'last_fm_muzyka_laczy_ludzi_takze_przez_internet', 25, 173, 79, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1629, 'Box.net. Wygodny sposób na przechowywanie plików w sieci', 'Jeśli ktoś prowadzi serwis internetowy, ale na serwerze ma mało miejca na pliki, które chciałby udostępnić; lub dużo podróżuje i chciałby mieć swobodny dostęp do własnych materiałów z każdego komputera, a nawet z własnej komórki czy palmtopa; a może współtworzy z innymi dokumenty, do których każdy w dowolnej chwili musi mieć swobodny dostęp - to pewinien zainteresować się usługą hostowania plików na serwerze Box.net (http://www.box.net).', 62, 63, 'box_net_wygodny_sposob_na_przechowywanie_plikow_w_sieci', 25, 173, 79, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1630, 'Budujemy sieć społecznościową', 'Po szybkiej instalacji i prostych ustawieniach Elgg dostarczy nam niezbędnych narzędzi do budowy następnego MySpace. Ja to zrobić, pokaże Karl Hodge.', 64, 66, 'budujemy_siec_spolecznosciowa', 25, 239, 79, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1631, 'WebHat Editor. Darmowe tkanie stron', '', 82, 82, 'webhat_editor_darmowe_tkanie_stron', 10, 196, 79, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1632, 'BitComet. Uniwersalny downloader', '', 82, 82, 'bitcomet_uniwersalny_downloader', 10, 196, 79, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1633, 'Wizz RSS News Reader. Wiadomości w przeglądarce', '', 83, 83, 'wizz_rss_news_reader_wiadomosci_w_przegladarce', 10, 196, 79, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1634, 'Panda Internet Security 2008', 'Panda zmienia nazwę, strukturę organizacyjną i wprowadza nowy model ochrony o nazwie Mega Detection, ułatwiający zwalczanie współczesnych zagrożeń. Został on wykorzystany m.in. do opracowania nowej wersji pakietu Panda Internet Security.', 84, 85, 'panda_internet_security_2008', 10, 38, 79, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1635, 'Obróbka wideo online', 'Zakres usług internetowych oferujących zdalną edycję plików wprost z poziomu domyślnej przeglądarki powiększa się z miesiąca na miesiąc. Teraz online można już edytować nie tylko teksty czy statyczne grafiki, ale nawet filmy.', 86, 89, 'obrobka_wideo_online', 10, 9, 79, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1636, 'gover.pl', 'Polityka zawsze cieszyła się dużym zainteresowaniem w rozmowach Polaków. Jednak w internecie dotychczas niewiele było miejsc, gdzie każdy czytelnik mógłby skomentować działania poszczególnych posłów czy też przeczytać statystyki dotyczące ich pracy w Sejmie. Gover.pl to, jak piszą jego autorzy, pierwszy polityczny "watchdog" w polskiej sieci. W serwisie tym działania posłów wystawione są na ocenę każdego użytkownika.', 90, 91, 'gover_pl', 13, 123, 79, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1637, 'Zapis i odczyt arkuszy kalkulacyjnych Excela w PHP', 'Arkusz kalkulacyjny Excel jest jednym z najpolularniejszych narzędzi do tworzenia zestawień danych. Jest to program prosty w obsłudze i bardzo powszechny. W artykule opiszę w jaki sposób odczytywać i zapisywać pliki XLS w skryptach PHP. Jako przykład zastosowania przedstawię aplikację Autokomis, w której baza danych jest wypełniana na podstawie arkusza kalkulacyjnego utworzonego programem Excel.', 92, 96, 'zapis_i_odczyt_arkuszy_kalkulacyjnych_excela_w_php', 13, 11, 79, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1638, 'GIMP. Tworzenie szablonów stron WWW', 'Omawiany w tym odcinku szablon jest stałej szerokości. Ma on trzy kolumny, nagłówek oraz stopkę. Wewnątrz kolumn lewej i prawej znajdują się wielokrotne dwupoziomowe menu.', 97, 101, 'gimp_tworzenie_szablonow_stron_www11', 13, 264, 79, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1639, 'Webmastering w przykładach: noth.gajdaw.pl', 'Witryna NotH.gajdaw.pl stanowi wizytówkę programu NotH - bezpłatnego edytora plików HTML, XHTML i CSS. Na stronie znajdują się podstawowe informacje o programie, podręcznik, zestaw skrótów klawiszowych oraz pliki do pobrania. Całość jest wykonana w PHP przy użyciu szablonów Smarty oraz plików tekstowych.', 102, 105, 'webmastering_w_przykladach_noth_gajdaw_pl', 13, 12, 79, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1640, 'Podstawy PHP. PDO - PHP5 i baza danych', 'Od wersji PHP 5.1 programiści mogą korzystać z jednolitego interfejsu bazodanowego, opartego o klasy. Interfejs ten nazywa się PDO (PHP Data Object). Dzięki PDO, niezależnie od bazy z jakiej programista chce korzystać, zawsze korzysta z tego samego zestawu klas oraz metod.', 106, 108, 'podstawy_php_pdo_php5_i_baza_danych', 13, 265, 79, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1641, 'JavaScript. Sposób na zdarzenia', 'Na pewno chcemy, by nasze strony były poprawne semantycznie i walidowały się prawidłowo. Nasz cel jest więc prosty - pozbyć się nieeleganckich zdarzeń z tagów HTML. Są dwa sposoby na osiągnięcie tego celu: mniej lub bardziej eleganckie. Najpierw zajmiemy się tym mniej eleganckim.', 109, 111, 'javascript_sposob_na_zdarzenia', 13, 43, 79, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1642, 'www.cottages.co.uk', 'Co zrobić, jeśli mamy wspaniały adres, jednak znajdujący się pod nim serwis już taki nie jest? Kingdlsey Roberts z londyńskiej agencji Strange podją się rozwiązania tego problemu.', 112, 113, 'www_cottages_co_uk', 13, 125, 79, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1643, 'Zakupy online. Koniec z wyszukiwarkami, czas na porównywarki', 'Jeszcze kilka lat temu sklep internetowy kojarzył się głównie z wirtualną księgarnią lub sklepem komputerowym. Od kiedy jednak sukces serwisów aukcyjnych udowodnił, że handel internetowy to nie tylko książki, płyty CD i sprzęt multimedialny, z każdym dniem przybywa nowych e-sklepów. Rośnie także liczba osób, które chcą robić zakupy przez internet.', 26, 32, 'zakupy_online_koniec_z_wyszukiwarkami_czas_na_porownywarki', 2, 40, 80, 7);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1644, 'Lizanie cukierka przez papierek', 'Posiadanie własnego serwisu internetowego nie jest już żadnym kaprysem. Współczesny świat, którego życie toczy się niemal równolegle w wirtualnej rzeczywistości i tzw. realu, wymaga, by osoby poważnie myślące o przyszłości np. własnego biznesu, istniały również w globalnej sieci. Co jednak począć, gdy mamy wątpliwości pod jakim adresem "zameldować się" w internecie i jaki najlepiej "sprzeda" naszą firmę? Właśnie m.in. dla takich wahających się osób wprowadzono usługę testowania domen, która w założeniu ma ułatwić podjęcie decyzji o ewentualnym związku z danym adresem internetowym na dłużej.', 34, 35, 'lizanie_cukierka_przez_papierek', 2, 40, 80, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1645, 'Canopy w Gminie Cekcyn - Bory Tucholskie\\', 'Bezprzewodowy, szerokopasmowy system Canopy pozwala Ci szybciej i korzystniej rozszerzyć własną sieć komunikacyjną z zachowaniem jakości usług i bezpieczeństwa transmisji.', 36, 37, 'canopy_w_gminie_cekcyn_bory_tucholskie', 44, 32, 80, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1646, 'Jak zbudowano FeedBurner.com', 'FeedBurner, serwis służący do zarządzania kanałami RSS, cieszy się dużą popularnością. Przechowywane są tu kanały RSS od ponad 600 tys. wydawców, a sam serwis przyjęło Google. O tym jak do tego doszło opowiada Matt Shobe.', 38, 39, 'jak_zbudowano_feedburner_com', 2, 40, 80, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1647, 'Hity wirtualnego ekranu', 'Śmieszą lub szokują, zawsze budzą jednak duże kontrowersje i zainteresowanie. Znają je miliony, choć nikt ich nie reklamuje. Rozchodzą się po sieci szybciej niż wirusy komputerowe. Mowa o viral videos.', 40, 43, 'hity_wirtualnego_ekranu', 2, 5, 80, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1648, 'Google Sky. Przewodnik po tajemnicach kosmosu', 'Przyzwyczailiśmy się już, że co jakiś czas korporacja Google zaskakuje nas nowymi pomysłami. Zaczęło się od możliwości wyszukiwania obiektów w sieci, po jakimś czasie udostępniona została możliwość wirtualnej podróży po dowolnym fragmencie kuli ziemskiej w ramach projektu Google Earth, a tego lata nastąpiła premiera ulepszonej wersji Google Earth, w której jedno kliknięcie pozwala nam powędrować w wielki i fascynujący kosmos. Przedstawiamy Google Sky!', 44, 47, 'google_sky_przewodnik_po_tajemnicach_kosmosu', 2, 266, 80, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1649, 'Hosting za friko', 'O komercyjnym hostingu pisaliśmy obszernie miesiąc temu. Pora na przedstawienie hostingu darmowego.', 48, 51, 'hosting_za_friko', 2, 56, 80, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1650, 'Podcast - radio na życzenie', '28 września 2004 roku Doc Searls, znany amerykański dziennikarz technologiczny i za razem blogger, wpadł na pomysł, by prześledzić ilość zapytań w Google dotyczących słowa "podcast". Tego dnia internauci wpisali to słowo w okno najpopularniejszej wyszukiwarki świata 24 razy. 18 października tego samego roku padło ponad 100 tys. zapytań. Podcast rozpoczął swoją karierę/', 52, 54, 'podcast_radio_na_zyczenie', 2, 24, 80, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1651, 'Użyteczna witryna', 'Nic tak nie irytuje, jak pełna graficznych fajerwerków strona WWW, na której nic nie można znaleźć. Jak sprawić, by witryna była przyjazna użytkownikom?', 55, 57, 'uzyteczna_witryna', 2, 267, 80, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1652, 'Stary serwis, nowy projekt', 'Zmiana projektu może uratować lub zniszczyć serwis. Jak więc do tego zagadnienia podchodzą eksperci? Gary Marshall zajrzał za kulisy, by odkryć sekrety sukcesów odmłodzonych serwisów.', 58, 62, 'stary_serwis_nowy_projekt', 2, 268, 80, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1653, 'Tworzymy interaktywny film we flashu', 'W pierwszej części niniejszego poradnika pokażemy, jak zrobić ujęcia na zielonym tle za pomocą zwykłej kamery DV, jednocześnie stosując profesjonalne efekty specjalne.', 64, 67, 'tworzymy_interaktywny_film_we_flashu', 25, 21, 80, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1654, 'Opera szyta na miarę', 'Z każdym kolejnym wydaniem Opera zdobywa coraz większą popularność, szczególnie w Polsce. I choć w dalszym ciągu jest to program niszowy, który nie może udziałem w rynku równać się z IE czy Firefoksem, liczba jego sympatyków jest już całkiem spora. Z myślą o nich pokazujemy co zrobić, by dostosować Operę do własnych potrzeb.', 68, 70, 'opera_szyta_na_miare', 25, 269, 80, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1655, 'Dynamiczne publikowanie danych', 'Transformacje XSL umożliwiają nadanie stylu i rozmieszczenie w locie danych w formacie XML. Karl Hodge na bazie opensource''owego edytora HTML-Kit pokazuje, jak to zrobić.', 71, 75, 'dynamiczne_publikowanie_danych', 25, 239, 80, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1656, 'midomi.com', 'Lubicie śpiewać i chcielibyście pochwalić się swoimi wokalnymi osięgnięciami przed całym światem? Nic prostszego. Wystarczy wejść na stronę http://www.midomi.com, założyć swój profil i umieszczać w nim własne interpretacje własnych przebojów.', 74, 75, 'midomi_com', 25, 173, 80, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1657, 'Zamzar.com. Plikokonwerter online', 'Wraz z rozwojem oprogramowania powiększa się nie tylko ilość aplikacji, ale i zakres stosowanych przez nie wyjściowych formatów zapisu. Każdy format pliku cechują przy tym jakieś wady i zalety, które mają zazwyczaj zasadniczy wpływ na wybór tego, a nie innego formatu. Często też zachodzi potrzeba przeformatowania pliku po to, aby móc go podejrzeć lub dalej edytować, jeśli np. nie mamy w systemie macierzystej aplikacji, w której on powstał. I tu właśnie niezwykle pomocny może okazać się internetowy serwis Zamzar (http://www.zamzar.com), który bezpośrednio z poziomu przeglądarki pozwoli przekonwertować wybrany plik z jednego formatu na inny.', 76, 77, 'zamzar_com_plikokonwerter_online', 25, 173, 80, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1658, 'e-Capsule Private Browser. Bezpieczeństwo ponad wszystko', '', 88, 88, 'e_capsule_private_browser_bezpieczenstwo_ponad_wszystko', 10, 196, 80, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1659, '1-More MiniShow. Wstępna miniprezentacja', '', 88, 88, '1_more_minishow_wstepna_miniprezentacja', 10, 196, 80, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1660, 'FireFTP. Szybki FTP', '', 89, 89, 'fireftp_szybki_ftp', 10, 196, 80, 1);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1661, 'Netscape Navigator 9', 'Najnowsza wersja przeglądarki Netscape''a jest dostępna dla Windows, Macintosha i Linuksa. Twórcy zdecydowali się na radykalne zmiany, dlatego opcja automatycznego uaktualnienia z poprzednich wersji tym razem nie działa. "Dziewiątka" to produkt całkowicie odmieniony, bazujący na technologiach rodem z Firefoksa.', 90, 91, 'netscape_navigator_9', 10, 38, 80, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1662, 'Norton Internet Security 2008', 'Do grona producentów oprogramowania zabezpieczającego, którzy w ostatnim czasie udostępnili nowe wersje swych produktów, dołączyła firma Symantec. Wprowadziła na rynek m.in. nową edycję pakietu Norton Internet Security 2008.', 92, 93, 'norton_internet_security_2008', 10, 38, 80, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1663, 'Niespodzianka.pl', 'Zbliża się okres szaleństwa przedświątecznych zakupów. Dla wielu osób kojarzy się to z odwiecznym problemem, jaki komu kupić prezent, a zapytać wprost czasami nie wypada. I tutaj jak zwykle przychodzi nam z pomocą internet. Dzięki serwisowi Niespodzianka.pl każdy stworzy swoją własną listę życzeń. Inne osoby mogą ją następnie przeglądać i brać pod uwagę jej zawartość podczas robienia zakupów.', 94, 95, 'niespodzianka_pl', 13, 123, 80, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1664, 'Propel na serwerze. Instalacja aplikacji wykorzystującej biblioteki Propel i Creole na serwerze hostingowym', 'Propel i DBDesigner to dwa wydajne narzędzia, które bardzo ułatwiają tworzenie witryn wykorzystujących bazy danych. Uruchomienie aplikacji stosującej Propela na serwerze dostawcy hostingu wymaga instalacji odpowiednich bibliotek. W artykule opiszę, w jaki sposób bez uprawnień administracyjnych uruchomić skrypty PHP wykorzystujące Propela.', 96, 99, 'propel_na_serwerze_instalacja_aplikacji_wykorzystujacej_biblioteki_propel_i_creole_na_serwerze_hostingowym', 13, 12, 80, 4);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1665, 'Ajax. Kurs od podstaw', 'W dobie aplikacji Web 2.0 technologia Ajax robi zawrotną karierę. Pierwszy odcinek kursu Ajaxa wprowadzi w świat interaktywnych aplikacji WWW. Omawiany przykład prezentuje wszystkie cechy aplikacji ajaksowych: interaktywną wymianę treści i wyglądu przy użyciu modelu DOM, modyfikację fragmentu, asynchroniczną komunikację z serwerem prowadzoną w tle oraz operowanie danymi w formacie XML.', 100, 104, 'ajax_kurs_od_podstaw', 13, 270, 80, 5);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1666, 'JavaScript. Rozwijanie menu', 'Rozwijanie menu to dobry pomysł na uatrakcyjnienie stron WWW. Wykonamy je za pomocą JavaScriptu, poznając działanie pętli for i kilku innych funkcji języka.', 105, 107, 'javascript_rozwijanie_menu', 13, 43, 80, 3);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1667, 'GIMP. Tworzenie szablonów stron WWW', 'Szablon ma stałą szerokość. Oprócz standardowej nawigacji w prawym górnym narożniku znajdują się ikony ułatwiające dostęp do strony głównej, mapy witryny, strony kontaktowej oraz wersji do druku. Ikony szybkiej nawigacji są wykonane z wykorzystaniem pozycjonowania względnie bezwzględnego.', 108, 109, 'gimp_tworzenie_szablonow_stron_www12', 13, 264, 80, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1668, 'Podstawy PHP. SPL i standardowe iteratory', 'SPL jest nową biblioteką standardową (SPL - Standard PHP Library) języka PHP. Wprowadzono ją wraz z nadejściem PHP 5 i od tego czasu jest rozwijana. Główną siłą SPL są iteratory. Pozwalają one na przechodzenie po różnego rodzaju danych za pomocą pętli foreach, co jest niezmiernie wygodne.', 110, 111, 'podstawy_php_spl_i_standardowe_iteratory', 13, 265, 80, 2);
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `start`, `stop`, `slug`, `rubryka_id`, `podrubryka_id`, `numer_id`, `liczbastron`) VALUES(1669, 'Asia Dragon', 'Asia Dragon, orientalny sklep z Leeds, potrzebuje nowego wyglądu, który dobrze oddawałby różnorodność oferowanych produktów. Poprosiliśmy projektanta Toma Hartshorna, by upiększył serwis.', 112, 113, 'asia_dragon', 13, 125, 80, 2);

--
-- Zrzut danych tabeli `artykul_has_autor`
--

INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(12, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(31, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(65, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(69, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(87, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(88, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(89, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(98, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(107, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(129, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(169, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(170, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(185, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(206, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(233, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(255, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(262, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(284, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(300, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(303, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(306, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(332, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(344, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(350, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(363, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(370, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(383, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(389, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(391, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(401, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(402, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(407, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(431, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(439, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(440, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(475, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(491, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(508, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(509, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(515, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(526, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(541, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(545, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(561, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(575, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(592, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(597, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(627, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(630, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(648, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(662, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(663, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(665, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(678, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(680, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(687, 1);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(2, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(23, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(46, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(66, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(72, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(91, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(116, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(130, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(132, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(171, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(188, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(207, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(212, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(254, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(275, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(299, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(340, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(361, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(365, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(404, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(463, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(488, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(505, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(524, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(540, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(557, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(573, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(590, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(613, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(935, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1096, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1120, 2);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(3, 3);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(4, 4);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(45, 4);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(208, 4);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(236, 4);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(5, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(22, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(24, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(47, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(90, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(114, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(133, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(175, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(215, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(283, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(310, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(353, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(372, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(441, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(514, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(532, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(566, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(746, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(758, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(821, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(876, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(942, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(950, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(951, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(952, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1095, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1110, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1152, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1220, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1243, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1280, 5);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(6, 6);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(25, 6);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(50, 6);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(7, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(13, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(14, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(27, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(34, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(48, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(54, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(56, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(58, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(71, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(79, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(80, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(99, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(115, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(117, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(121, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(139, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(140, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(141, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(157, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(158, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(161, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(177, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(192, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(193, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(194, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(199, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(218, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(222, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(223, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(243, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(245, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(246, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(266, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(288, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(291, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(292, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(313, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(314, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(357, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(413, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(433, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(499, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(602, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(670, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(697, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(769, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(770, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(774, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(810, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(811, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(864, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(874, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(885, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1037, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1038, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1039, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1040, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1041, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1042, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1080, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1081, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1112, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1113, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1134, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1135, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1195, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1198, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1223, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1245, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1261, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1267, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1290, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1291, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1314, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1339, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1382, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1406, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1431, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1608, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1634, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1662, 7);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(8, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(33, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(67, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(110, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(137, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(138, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(186, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(187, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(213, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(239, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(260, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(324, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(327, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(341, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(392, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(417, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(457, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(474, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(493, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(506, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(507, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(512, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(531, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(558, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(574, 8);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(8, 9);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(9, 10);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(41, 10);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(109, 10);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(276, 10);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(420, 10);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(489, 10);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(10, 11);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(19, 11);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(11, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(29, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(64, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(86, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(118, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(126, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(131, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(164, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(173, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(183, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(322, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(400, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(420, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(421, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(456, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(479, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(489, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(525, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(539, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(565, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(574, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(607, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(644, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(698, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(814, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(817, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(930, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(931, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(932, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1060, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1143, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1211, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1335, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1403, 12);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(15, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(38, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(52, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(55, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(76, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(78, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(100, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(120, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(142, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(143, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(145, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(153, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(176, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(195, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(196, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(198, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(216, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(217, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(220, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(241, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(242, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(267, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(281, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(287, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(289, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(312, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(335, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(354, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(355, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(356, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(373, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(374, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(375, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(376, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(395, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(396, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(412, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(414, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(415, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(430, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(449, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(465, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(466, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(467, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(481, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(497, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(517, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(518, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(534, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(551, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(567, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(583, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(600, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(616, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(632, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(651, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(669, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(692, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(708, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(726, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(747, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(765, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(788, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(789, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(806, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(826, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(843, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(863, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(884, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(902, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(923, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(949, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(967, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(982, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1010, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1031, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1056, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1076, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1084, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1115, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1137, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1151, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1153, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1173, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1176, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1196, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1199, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1212, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1224, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1270, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1306, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1315, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1353, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1358, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1372, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1383, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1384, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1385, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1386, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1401, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1407, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1408, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1409, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1410, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1425, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1426, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1432, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1433, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1434, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1435, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1457, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1458, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1459, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1460, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1461, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1474, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1483, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1484, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1485, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1486, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1504, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1505, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1506, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1507, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1516, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1518, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1531, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1532, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1533, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1545, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1548, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1557, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1558, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1559, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1581, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1582, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1583, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1600, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1601, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1602, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1605, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1606, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1607, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1628, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1629, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1631, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1632, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1633, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1635, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1656, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1657, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1658, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1659, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1660, 13);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(16, 14);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(17, 15);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(35, 15);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(40, 15);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(59, 15);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(81, 15);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(101, 15);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(18, 16);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(36, 16);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(61, 16);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(82, 16);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(103, 16);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(125, 16);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(148, 16);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(167, 16);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(182, 16);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(248, 16);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(272, 16);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(20, 17);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(39, 17);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(62, 17);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(83, 17);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(294, 17);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(318, 17);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(434, 17);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(451, 17);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(471, 17);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(487, 17);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(21, 18);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(30, 18);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(73, 18);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(97, 18);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(22, 19);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(24, 20);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(26, 21);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(42, 21);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(105, 21);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(123, 21);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(28, 22);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(30, 23);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(32, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(53, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(75, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(119, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(135, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(152, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(159, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(160, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(197, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(205, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(210, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(235, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(237, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(238, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(240, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(265, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(290, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(304, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(343, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(347, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(366, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(388, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(482, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(519, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(601, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(631, 24);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(37, 25);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(104, 25);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(43, 26);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(44, 27);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(57, 27);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(68, 27);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(95, 27);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(191, 27);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(221, 27);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(244, 27);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(286, 27);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(394, 27);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(45, 28);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(47, 29);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(49, 30);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(122, 30);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(51, 31);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(70, 31);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(92, 31);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(112, 31);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(136, 31);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(60, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(84, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(102, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(124, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(149, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(162, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(166, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(178, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(181, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(200, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(203, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(224, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(228, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(247, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(253, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(268, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(274, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(293, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(298, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(311, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(315, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(321, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(358, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(379, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(418, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(419, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(504, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(536, 32);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(63, 33);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(67, 34);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(74, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(96, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(113, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(134, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(155, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(174, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(190, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(214, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(263, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(285, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(308, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(328, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(348, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(369, 35);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(77, 36);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(85, 37);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(106, 37);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(90, 38);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(93, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(701, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(702, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(718, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(719, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(738, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(739, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(762, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(763, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(764, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(780, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(786, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(799, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(801, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(824, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(825, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(841, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(842, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(861, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(862, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(879, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(880, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(881, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(882, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(883, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(900, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(901, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(920, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(922, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(944, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(945, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(964, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(966, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(986, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(987, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(996, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(999, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1007, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1008, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1009, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1029, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1030, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1054, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1055, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1072, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1073, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1074, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1075, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1082, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1083, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1109, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1114, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1121, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1122, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1123, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1124, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1133, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1136, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1150, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1172, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1175, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1309, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1367, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1378, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1397, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1402, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1416, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1427, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1428, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1429, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1442, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1445, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1446, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1467, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1471, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1472, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1481, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1492, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1495, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1498, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1500, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1514, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1522, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1527, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1528, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1540, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1546, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1566, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1569, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1571, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1574, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1575, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1578, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1580, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1590, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1593, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1594, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1596, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1603, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1619, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1620, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1622, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1625, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1642, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1645, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1646, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1653, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1669, 39);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(94, 40);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(95, 41);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(95, 42);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(108, 43);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(151, 43);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(111, 44);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(128, 44);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(234, 44);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(114, 45);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(127, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(189, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(259, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(579, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(642, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(643, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(652, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(683, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(684, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(690, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(723, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(805, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(896, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(917, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(956, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(965, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1106, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1128, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1393, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1454, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1503, 46);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(133, 47);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(137, 48);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(144, 49);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(150, 49);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(184, 49);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(146, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(163, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(179, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(201, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(226, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(250, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(269, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(295, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(316, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(317, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(338, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(377, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(378, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(695, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(724, 50);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(147, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(165, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(180, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(202, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(225, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(249, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(271, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(296, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(319, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(336, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(397, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(428, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(432, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(450, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(548, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(596, 51);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(151, 52);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(152, 53);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(209, 53);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(305, 53);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(152, 54);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(156, 54);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(168, 54);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(261, 54);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(154, 55);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(231, 55);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(477, 55);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(494, 55);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(528, 55);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(591, 55);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(614, 55);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(823, 55);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(156, 56);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(423, 56);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(443, 56);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(172, 57);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(411, 57);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(736, 57);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(800, 57);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(894, 57);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(916, 57);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(175, 58);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(187, 59);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(191, 60);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(204, 61);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(204, 62);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(209, 63);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(251, 63);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(270, 63);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(211, 64);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(215, 65);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(219, 66);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(227, 67);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(252, 67);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(273, 67);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(297, 67);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(320, 67);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(339, 67);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(229, 68);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(230, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(258, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(279, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(323, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(342, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(352, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(362, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(367, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(382, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(425, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(426, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(473, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(608, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(623, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(625, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(629, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(638, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(682, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(745, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(752, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(757, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(820, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(831, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(832, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(852, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(890, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1018, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1088, 69);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(232, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(256, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(277, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(301, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(333, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(346, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(381, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(384, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(437, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(455, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(472, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(576, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(589, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(611, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(622, 70);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(239, 71);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(239, 72);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(257, 73);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(259, 74);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(261, 75);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(264, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(282, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(307, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(330, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(351, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(371, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(393, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(409, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(427, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(447, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(464, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(480, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(496, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(516, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(533, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(550, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(564, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(582, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(650, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(691, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(722, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(756, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(777, 76);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(273, 77);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(297, 77);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(320, 77);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(339, 77);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(360, 77);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(399, 77);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(422, 77);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(436, 77);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(453, 77);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(478, 77);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(486, 77);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(511, 77);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(278, 78);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(280, 79);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(329, 79);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(444, 79);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(286, 80);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(302, 81);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(345, 81);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(386, 81);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(309, 82);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(326, 82);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(310, 83);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(325, 84);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(387, 84);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(331, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(364, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(368, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(385, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(390, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(408, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(438, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(490, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(495, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(530, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(542, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(549, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(562, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(563, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(581, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(610, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(615, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(641, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(661, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(667, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(685, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(707, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(734, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(741, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(745, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(784, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(785, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(815, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(834, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(838, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(878, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(918, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(937, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(958, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1125, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1142, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1163, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1185, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1208, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1232, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1255, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1279, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1300, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1325, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1347, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1368, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1392, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1417, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1443, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1468, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1493, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1515, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1521, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1541, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1567, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1591, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1617, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1643, 85);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(334, 86);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(337, 87);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(359, 87);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(380, 87);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(398, 87);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(349, 88);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(353, 89);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(360, 90);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(399, 90);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(422, 90);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(436, 90);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(453, 90);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(486, 90);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(372, 91);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(393, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(427, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(447, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(464, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(480, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(496, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(516, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(533, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(550, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(564, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(582, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(598, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(628, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(650, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(691, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(722, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(777, 92);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(394, 93);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(403, 94);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(405, 94);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(406, 95);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(442, 95);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(559, 95);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(578, 95);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(609, 95);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(891, 95);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(410, 96);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(429, 96);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(448, 96);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(458, 96);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(411, 97);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(416, 98);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(500, 98);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(424, 99);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(435, 100);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(446, 100);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(461, 100);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(498, 100);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(546, 100);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(715, 100);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(743, 100);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(761, 100);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(860, 100);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1047, 100);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1131, 100);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(445, 101);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(538, 101);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(554, 101);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(621, 101);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(448, 102);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(452, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(469, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(502, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(520, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(521, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(552, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(572, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(585, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(588, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(618, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(621, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(636, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(671, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(766, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(828, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(858, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(971, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1012, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1159, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1192, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1439, 103);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(454, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(470, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(485, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(503, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(522, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(537, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(553, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(571, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(587, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(603, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(619, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(637, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(656, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(674, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(696, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(712, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(731, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(750, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(768, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(792, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(830, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(868, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(889, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(905, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(929, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(972, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(992, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1015, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1036, 104);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(459, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(462, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(513, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(577, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(594, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(649, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(677, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(706, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(714, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(742, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(744, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(781, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(803, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(818, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(875, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(897, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(898, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(938, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(973, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(974, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(975, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(976, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1020, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1023, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1046, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1065, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1105, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1108, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1377, 105);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(460, 106);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(483, 106);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1005, 106);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(468, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(484, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(501, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(523, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(535, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(556, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(568, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(569, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(584, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(606, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(617, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(633, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(653, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(657, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(672, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(673, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(693, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(694, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(710, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(711, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(727, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(730, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(748, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(749, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(767, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(790, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(791, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(808, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(809, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(846, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(867, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(887, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(888, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(904, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(906, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(926, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(927, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(946, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(947, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(968, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(970, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(990, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(991, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1011, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1013, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1032, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1033, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1057, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1059, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1078, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1079, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1086, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1117, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1118, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1119, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1138, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1141, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1156, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1157, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1182, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1183, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1202, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1203, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1226, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1229, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1230, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1248, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1249, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1251, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1274, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1275, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1277, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1296, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1297, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1298, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1319, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1321, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1322, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1340, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1343, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1344, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1364, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1365, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1366, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1387, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1388, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1391, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1400, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1411, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1413, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1415, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1436, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1438, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1440, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1462, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1464, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1465, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1487, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1489, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1490, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1508, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1511, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1513, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1534, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1536, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1537, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1560, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1564, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1565, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1586, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1589, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1610, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1611, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1612, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1613, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1637, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1638, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1639, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1664, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1665, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1667, 107);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(476, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(510, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(527, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(560, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(593, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(599, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(624, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(681, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(703, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(787, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(812, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(835, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(910, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(978, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(995, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1089, 108);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(492, 109);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(754, 109);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(778, 109);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(796, 109);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(813, 109);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(836, 109);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(514, 110);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(529, 111);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(543, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(580, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(688, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(760, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(928, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(959, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(977, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1067, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1154, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1240, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1265, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1271, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1292, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1310, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1311, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1316, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1351, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1376, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1449, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1543, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1623, 112);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(544, 113);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(570, 113);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(547, 114);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(555, 115);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(586, 115);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(604, 115);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(566, 116);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(586, 117);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(604, 117);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(595, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(612, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(646, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(647, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(666, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(686, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(704, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(725, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(737, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(779, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(795, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(893, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(911, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(957, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(997, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(998, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1044, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1063, 118);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(605, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(620, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(654, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(664, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(689, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(729, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(751, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(807, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(829, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(845, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(847, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(866, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(869, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(870, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(925, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(948, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1006, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1014, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1085, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1087, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1097, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1098, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1099, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1161, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1179, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1204, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1228, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1252, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1260, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1276, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1323, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1342, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1362, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1480, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1519, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1577, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1626, 119);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(626, 120);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(634, 121);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(635, 121);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(675, 121);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(709, 121);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(827, 121);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(865, 121);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1022, 121);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1058, 121);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1420, 121);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1448, 121);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1542, 121);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1592, 121);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(639, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(640, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(658, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(668, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(713, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(740, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(753, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(771, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(772, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(773, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(848, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(854, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(993, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1016, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1017, 122);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(639, 123);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(658, 123);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(717, 123);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(755, 123);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(759, 123);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(849, 123);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(850, 123);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(645, 124);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(655, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(728, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(886, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(903, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(924, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(981, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1034, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1116, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1155, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1177, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1181, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1200, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1225, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1247, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1273, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1295, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1320, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1326, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1327, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1345, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1361, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1390, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1412, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1422, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1423, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1441, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1466, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1491, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1512, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1538, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1547, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1562, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1587, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1614, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1640, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1668, 125);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(659, 126);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(660, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(679, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(700, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(716, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(735, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(797, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(798, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(822, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(833, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(851, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(871, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(872, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(907, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(908, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(909, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(914, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(933, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(934, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(979, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1019, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1061, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1090, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1100, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1167, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1168, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1285, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1312, 127);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(668, 128);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(676, 129);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(699, 130);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(705, 131);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(720, 132);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(859, 132);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(721, 133);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(732, 134);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(733, 134);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(793, 134);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(794, 134);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(775, 135);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(789, 135);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(776, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(804, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(840, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(856, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(877, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(912, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(919, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(988, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1000, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1050, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1052, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1126, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1148, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1171, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1269, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1284, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1349, 136);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(782, 137);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(783, 138);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(802, 138);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(819, 138);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(802, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(839, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(855, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(857, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(895, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(899, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(941, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(955, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(980, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(983, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1004, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1028, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1045, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1053, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1070, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1071, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1093, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1111, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1132, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1149, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1219, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1258, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1259, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1337, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1352, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1475, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1496, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1568, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1573, 139);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(816, 140);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1035, 140);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1129, 140);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1357, 140);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(833, 141);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(837, 142);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(853, 142);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(873, 142);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(892, 142);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1026, 142);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(844, 143);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(969, 143);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(989, 143);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1205, 143);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1271, 143);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(852, 144);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(853, 145);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(874, 146);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(913, 147);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(915, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(936, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(960, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1001, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1069, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1101, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1104, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1233, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1234, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1235, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1334, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1380, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1396, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1450, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1544, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1550, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1551, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1572, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1597, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1648, 148);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(921, 149);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(934, 150);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(939, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(943, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(961, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(962, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(984, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(985, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1003, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1048, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1049, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1066, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1068, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1091, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1094, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1103, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1127, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1189, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1304, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1350, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1451, 151);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(940, 152);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(953, 153);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1301, 153);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1302, 153);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1303, 153);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(954, 154);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(955, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1158, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1180, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1201, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1227, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1250, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1272, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1294, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1317, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1341, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1360, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1373, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1389, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1395, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1414, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1437, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1463, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1469, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1488, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1509, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1535, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1561, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1568, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1584, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1609, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1636, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1663, 155);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(963, 156);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(980, 157);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(994, 158);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1002, 159);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1024, 159);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1062, 159);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1106, 159);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1178, 159);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1197, 159);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1221, 159);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1222, 159);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1268, 159);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1338, 159);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1661, 159);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1021, 160);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1051, 160);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1193, 160);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1216, 160);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1242, 160);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1025, 161);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1064, 161);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1077, 161);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1092, 161);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1164, 161);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1186, 161);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1187, 161);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1209, 161);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1246, 161);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1289, 161);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1027, 162);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1028, 163);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1043, 164);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1043, 165);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1045, 166);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1102, 167);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1107, 168);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1618, 168);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1111, 169);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1130, 170);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1132, 171);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1139, 172);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1140, 173);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1144, 174);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1145, 175);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1191, 175);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1305, 175);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1356, 175);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1369, 175);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1371, 175);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1394, 175);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1470, 175);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1476, 175);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1494, 175);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1523, 175);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1598, 175);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1627, 175);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1146, 176);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1147, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1236, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1238, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1281, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1308, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1331, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1359, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1374, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1398, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1424, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1455, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1479, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1501, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1526, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1549, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1576, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1599, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1630, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1655, 177);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1149, 178);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1160, 179);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1162, 180);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1165, 181);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1188, 181);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1283, 181);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1286, 181);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1329, 181);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1554, 181);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1166, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1190, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1210, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1217, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1237, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1241, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1262, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1266, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1307, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1313, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1318, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1332, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1370, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1447, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1477, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1652, 182);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1168, 183);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1169, 184);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1213, 184);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1170, 185);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1174, 186);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1184, 187);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1194, 188);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1206, 189);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1207, 190);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1231, 190);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1214, 191);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1215, 192);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1218, 192);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1286, 192);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1287, 192);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1328, 192);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1381, 192);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1404, 192);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1219, 193);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1231, 194);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1231, 195);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1239, 196);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1243, 197);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1244, 198);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1253, 199);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1254, 200);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1278, 200);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1299, 200);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1324, 200);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1346, 200);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1256, 201);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1257, 201);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1263, 202);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1264, 203);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1267, 204);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1282, 205);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1288, 206);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1292, 207);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1293, 208);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1316, 209);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1330, 210);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1333, 211);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1336, 212);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1348, 213);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1354, 214);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1355, 215);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1363, 216);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1375, 217);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1379, 218);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1399, 219);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1405, 220);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1430, 220);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1452, 220);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1482, 220);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1529, 220);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1555, 220);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1556, 220);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1579, 220);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1604, 220);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1405, 221);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1418, 222);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1419, 223);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1421, 224);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1502, 224);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1525, 224);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1530, 224);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1649, 224);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1444, 225);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1497, 225);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1453, 226);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1456, 227);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1473, 228);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1478, 229);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1499, 230);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1510, 231);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1539, 231);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1563, 231);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1588, 231);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1615, 231);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1616, 231);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1641, 231);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1666, 231);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1517, 232);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1520, 233);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1524, 234);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1552, 235);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1553, 235);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1570, 236);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1650, 236);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1585, 237);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1654, 237);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1589, 238);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1595, 239);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1621, 240);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1647, 240);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1651, 240);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1624, 241);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1644, 242);
INSERT INTO `artykul_has_autor` (`artykul_id`, `autor_id`) VALUES(1648, 243);

--
-- Zrzut danych tabeli `autor`
--

INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(1, 'Aleksander', 'Łamek', 57, 238, 'lamek_aleksander');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(2, 'Jarosław', 'Rafa', 32, 274, 'rafa_jaroslaw');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(3, 'Beata', 'Kita', 1, 4, 'kita_beata');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(4, 'Paweł', 'Hebda', 4, 14, 'hebda_pawel');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(5, 'Ewa', 'Miller-Stefańska', 31, 82, 'miller_stefanska_ewa');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(6, 'Cezary', 'Brzuzy', 3, 6, 'brzuzy_cezary');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(7, 'Krzysztof', 'Kowalski', 82, 152, 'kowalski_krzysztof');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(8, 'Damian', 'Jarosz', 25, 101, 'jarosz_damian');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(9, 'Grzegorz', 'Krajewski', 1, 2, 'krajewski_grzegorz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(10, 'Joanna', 'Brózda', 6, 31, 'brozda_joanna');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(11, 'Jacek', 'Konikowski', 2, 4, 'konikowski_jacek');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(12, 'Michał', 'Zimnicki', 34, 196, 'zimnicki_michal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(13, 'Paweł', 'Goc', 154, 452, 'goc_pawel');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(14, 'Rafał', 'Szymanowski', 1, 4, 'szymanowski_rafal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(15, 'Jacek', 'Uniewski', 6, 11, 'uniewski_jacek');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(16, 'Sławomir', 'Fajer', 11, 46, 'fajer_slawomir');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(17, 'Marcin', 'Lis', 10, 34, 'lis_marcin');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(18, 'Bartłomiej', 'Dramczyk', 4, 17, 'dramczyk_bartlomiej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(19, 'Magdalena', 'Busk', 1, 3, 'busk_magdalena');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(20, 'Halina', 'Kustosz', 1, 2, 'kustosz_halina');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(21, 'Michał', 'Skowroński', 4, 8, 'skowronski_michal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(22, 'Andrzej', 'Parszuto', 1, 2, 'parszuto_andrzej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(23, 'Rafał', 'Kondak', 1, 4, 'kondak_rafal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(24, 'Andrzej', 'Węcławski', 26, 100, 'weclawski_andrzej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(25, 'Marcin', 'Dębicki', 2, 9, 'debicki_marcin');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(26, 'Andrzej', 'Kierzkowski', 1, 3, 'kierzkowski_andrzej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(27, 'Klaudiusz', 'Dybowski', 9, 21, 'dybowski_klaudiusz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(28, 'Tomasz', 'Jażdżyński', 1, 2, 'jazdzynski_tomasz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(29, 'Piotr', 'Dachtera', 1, 3, 'dachtera_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(30, 'Daniel', 'Guga', 2, 6, 'guga_daniel');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(31, 'Kazimierz', 'Pietruszewski', 5, 13, 'pietruszewski_kazimierz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(32, 'Daniel', 'Bargieł', 28, 112, 'bargiel_daniel');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(33, 'Mariusz', 'Ferdyn', 1, 2, 'ferdyn_mariusz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(34, 'Piotr', 'Ciszek', 1, 2, 'ciszek_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(35, 'Alina', 'Majchrzak', 14, 46, 'majchrzak_alina');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(36, 'Mikołaj', 'Leszczuk', 1, 2, 'leszczuk_mikolaj');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(37, 'Sebastian', 'Górski', 2, 4, 'gorski_sebastian');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(38, 'Rafał', 'Styczeń', 1, 2, 'styczen_rafal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(39, '-', '-', 108, 360, 'brak');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(40, 'Magda', 'Hendzel', 1, 2, 'hendzel_magda');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(41, 'Kate', 'Bulkley', 1, 4, 'bulkley_kate');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(42, 'Arthur', 'Clark', 1, 4, 'clark_arthur');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(43, 'Fabian', 'Pędziwiatr', 2, 9, 'pedziwiatr_fabian');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(44, 'Artur', 'Nowicki', 3, 13, 'nowicki_artur');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(45, 'Andrzej', 'Tracz', 1, 2, 'tracz_andrzej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(46, 'Arkadiusz', 'Kopiciński', 21, 68, 'kopicinski_arkadiusz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(47, 'Adam', 'Wojtkiewicz', 1, 2, 'wojtkiewicz_adam');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(48, 'Kamil', 'Zaręba', 1, 2, 'zareba_kamil');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(49, 'Piotr', 'Bonarski', 3, 21, 'bonarski_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(50, 'Sebastian', 'Marek', 15, 59, 'marek_sebastian');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(51, 'Grzegorz', 'Niemirowski', 16, 36, 'niemirowski_grzegorz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(52, 'Mirosław', 'Pasek', 1, 4, 'pasek_miroslaw');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(53, 'Krzysztof', 'Dziewoński', 3, 16, 'dziewonski_krzysztof');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(54, 'Maciej', 'Kunowski', 4, 13, 'kunowski_maciej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(55, 'Wiesław', 'Pietruszkiewicz', 8, 31, 'pietruszkiewicz_wieslaw');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(56, 'Wojciech', 'Przyłęcki', 3, 7, 'przylecki_wojciech');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(57, 'Krystian', 'Grzenkowicz', 6, 25, 'grzenkowicz_krystian');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(58, 'Jacek', 'Kosiec', 1, 2, 'kosiec_jacek');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(59, 'Marek', 'Krakowiak', 1, 4, 'krakowiak_marek');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(60, 'Kimberly', 'Getgen', 1, 3, 'getgen_kimberly');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(61, 'Piotr', 'Karwatka', 1, 2, 'karwatka_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(62, 'Tomasz', 'Karwatka', 1, 2, 'karwatka_tomasz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(63, 'Bartosz', 'Danowski', 3, 10, 'danowski_bartosz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(64, 'Bożena', 'Bednarek-Michalska', 1, 3, 'bednarek_michalska_bozena');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(65, 'Artur', 'Więckowski', 1, 2, 'wieckowski_artur');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(66, 'Rafał', 'Agnieszczak', 1, 1, 'agnieszczak_rafal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(67, 'Katarzyna', 'Szczypiór', 6, 26, 'szczypior_katarzyna');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(68, 'Andrzej', 'Szewczyk', 1, 2, 'szewczyk_andrzej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(69, 'Paweł', 'Gruszecki', 28, 164, 'gruszecki_pawel');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(70, 'Justyna', 'Adamczyk', 15, 124, 'adamczyk_justyna');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(71, 'Łukasz', 'Lewandowski', 1, 2, 'lewandowski_lukasz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(72, 'Artur', 'Banach', 1, 2, 'banach_artur');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(73, 'Piotr', 'Listosz', 1, 6, 'listosz_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(74, 'Jakub', 'Ciesek', 1, 2, 'ciesek_jakub');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(75, 'Dariusz', 'Wadowski', 1, 2, 'wadowski_dariusz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(76, 'Krzysztof', 'Bielański', 23, 23, 'bielanski_krzysztof');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(77, 'Andrzej', 'Burnicki', 12, 41, 'burnicki_andrzej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(78, 'Jan', 'Sowiński', 1, 3, 'sowinski_jan');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(79, 'Adam', 'Błaszczyk', 3, 9, 'blaszczyk_adam');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(80, 'George', 'Ogden', 1, 2, 'ogden_george');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(81, 'Urszula', 'Szwed-Strych', 3, 9, 'szwed_strych_urszula');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(82, 'Dawid', 'Weiss', 2, 9, 'weiss_dawid');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(83, 'Andrzej', 'Czyżewski', 1, 2, 'czyzewski_andrzej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(84, 'Joanna', 'Jarmużewska', 2, 2, 'jarmuzewska_joanna');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(85, 'Michał', 'Stępień', 58, 151, 'stepien_michal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(86, 'Elżbieta', 'Suchodolska', 1, 1, 'suchodolska_elzbieta');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(87, 'Arnold', 'Adamczyk', 4, 15, 'adamczyk_arnold');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(88, 'Michał', 'Modestowicz', 1, 4, 'modestowicz_michal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(89, 'Artur', 'Adamowicz', 1, 2, 'adamowicz_artur');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(90, 'Katarzyna', 'Burnicka', 6, 20, 'burnicka_katarzyna');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(91, 'Mirosława', 'Camona', 1, 2, 'camona_miroslawa');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(92, 'Anna', 'Krajewska-Polak', 17, 17, 'krajewska_polak_anna');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(93, 'Michał', 'Szustak', 1, 2, 'szustak_michal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(94, 'Anna', 'Meller', 2, 3, 'meller_anna');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(95, 'Dorota', 'Dżega', 6, 24, 'dzega_dorota');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(96, 'Robert', 'Kopaczewski', 4, 9, 'kopaczewski_robert');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(97, 'Wojciech', 'Wrzaskała', 1, 2, 'wrzaskala_wojciech');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(98, 'Jarosław', 'Wasilewski', 2, 8, 'wasilewski_jaroslaw');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(99, 'Michał', 'Rolski', 1, 4, 'rolski_michal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(100, 'Arkadiusz', 'Łuczyk', 11, 36, 'luczyk_arkadiusz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(101, 'Marian', 'Witkowski', 4, 15, 'witkowski_marian');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(102, 'Piotr', 'Kaczor', 1, 2, 'kaczor_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(103, 'Tomasz', 'Gębarowski', 21, 71, 'gebarowski_tomasz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(104, 'Dariusz', 'Majgier', 29, 59, 'majgier_dariusz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(105, 'Wojciech', 'Nowakowski', 29, 100, 'nowakowski_wojciech');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(106, 'Daniel', 'Łoposzko', 3, 11, 'loposzko_daniel');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(107, 'Włodzimierz', 'Gajda', 121, 543, 'gajda_wlodzimierz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(108, 'Daniel', 'Kotyras', 16, 53, 'kotyras_daniel');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(109, 'Piotr', 'Jagielski', 6, 22, 'jagielski_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(110, 'Bartłomiej', 'Danek', 1, 2, 'danek_bartlomiej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(111, 'Dominik', 'Miklaszewski', 1, 3, 'miklaszewski_dominik');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(112, 'Bartłomiej', 'Dymecki', 21, 50, 'dymecki_bartlomiej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(113, 'Kamil', 'Matysik', 2, 6, 'matysik_kamil');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(114, 'Maciej', 'Kostro', 1, 2, 'kostro_maciej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(115, 'Tomasz', 'Woźniaczko', 3, 6, 'wozniaczko_tomasz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(116, 'Andrzej', 'Pilarz', 1, 2, 'pilarz_andrzej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(117, 'Edyta', 'Woźniaczko', 2, 4, 'wozniaczko_edyta');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(118, 'Krzysztof', 'Gienas', 18, 54, 'gienas_krzysztof');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(119, 'Paweł', 'Grzesiak', 37, 165, 'grzesiak_pawel');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(120, 'Anita', 'Wojtaś', 1, 4, 'wojtas_anita');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(121, 'Michał', 'Grzechowiak', 12, 61, 'grzechowiak_michal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(122, 'Konrad', 'Drozdowski', 15, 74, 'drozdowski_konrad');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(123, 'Tomasz', 'Teluk', 7, 24, 'teluk_tomasz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(124, 'Mariusz', 'Tkaczyk', 1, 6, 'tkaczyk_mariusz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(125, 'Marcin', 'Staniszczak', 36, 129, 'staniszczak_marcin');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(126, 'Iwo', 'Augustyński', 1, 3, 'augustynski_iwo');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(127, 'Tomasz', 'Frontczak', 27, 81, 'frontczak_tomasz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(128, 'Maciej', 'Kozłowski', 1, 2, 'kozlowski_maciej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(129, 'Marcin', 'Kuśmierz', 1, 5, 'kusmierz_marcin');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(130, 'Marcin', 'Cieślak', 1, 2, 'cieslak_marcin');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(131, 'Kamil', 'Antosiewicz', 1, 4, 'antosiewicz_kamil');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(132, 'Michał', 'Malinowski', 2, 4, 'malinowski_michal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(133, 'Gniewosz', 'Tomaszewski', 1, 5, 'tomaszewski_gniewosz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(134, 'Marcin', 'Tomczak', 4, 20, 'tomczak_marcin');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(135, 'Wojciech', 'Kocjan', 2, 5, 'kocjan_wojciech');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(136, 'Wojciech', 'Łamek', 17, 68, 'lamek_wojciech');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(137, 'Dariusz', 'Utracki', 1, 3, 'utracki_dariusz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(138, 'Piotr', 'Karkuciński', 3, 8, 'karkucinski_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(139, 'Patrycja', 'Kierzkowska', 29, 92, 'kierzkowska_patrycja');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(140, 'Jakub', 'Horbacewicz', 4, 16, 'horbacewicz_jakub');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(141, 'Anna', 'Sydor', 1, 4, 'sydor_anna');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(142, 'Adam', 'Owczarek', 5, 12, 'owczarek_adam');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(143, 'Łukasz', 'Lach', 5, 11, 'lach_lukasz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(144, 'Krzysztof', 'Szyszka', 1, 1, 'szyszka_krzysztof');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(145, 'Jakub', 'Żelichowski', 1, 2, 'zelichowski_jakub');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(146, 'Rafał', 'Płatek', 1, 2, 'platek_rafal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(147, 'Marcin', 'Fiedziukiewicz', 1, 1, 'fiedziukiewicz_marcin');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(148, 'Mirosław', 'Dworniczak', 20, 81, 'dworniczak_miroslaw');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(149, 'Karol', 'Gilarski', 1, 2, 'gilarski_karol');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(150, 'Dominik', 'Kaznowski', 1, 2, 'kaznowski_dominik');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(151, 'Dorota', 'Szumilas', 19, 62, 'szumilas_dorota');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(152, 'Piotr', 'Borek', 1, 2, 'borek_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(153, 'Bartosz', 'Kordecki', 4, 11, 'kordecki_bartosz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(154, 'Bogusław', 'Faja', 1, 2, 'faja_boguslaw');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(155, 'Tomasz', 'Kapelak', 27, 68, 'kapelak_tomasz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(156, 'Jarosław', 'Sztygar', 1, 2, 'sztygar_jaroslaw');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(157, 'Gerard', 'Grech', 1, 2, 'grech_gerard');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(158, 'Tomasz', 'Ochocki', 1, 5, 'ochocki_tomasz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(159, 'Jakub', 'Borzyński', 11, 30, 'borzynski_jakub');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(160, 'Mariusz', 'Pociask', 5, 22, 'pociask_mariusz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(161, 'Eryk', 'Algo', 10, 56, 'algo_eryk');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(162, 'Anna', 'Wróblewska', 1, 2, 'wroblewska_anna');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(163, 'Wojmir', 'Strzałkowski', 1, 2, 'strzalkowski_wojmir');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(164, 'Anna', 'Banicewicz-Miazga', 1, 3, 'banicewicz_miazga_anna');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(165, 'Michał', 'Nowakowski', 1, 3, 'nowakowski_michal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(166, 'Łukasz', 'Kuncewicz', 1, 2, 'kuncewicz_lukasz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(167, 'Tomasz', 'Łochocki', 1, 4, 'lochocki_tomasz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(168, 'Michał', 'Turliński', 2, 11, 'turlinski_michal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(169, 'Anita', 'Nowakowska', 1, 2, 'nowakowska_anita');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(170, 'Mateusz', 'Michałowski', 1, 3, 'michalowski_mateusz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(171, 'Konrad', 'Węgrowski', 1, 2, 'wegrowski_konrad');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(172, 'Piotr', 'Maliński', 1, 3, 'malinski_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(173, 'Błażej', 'Zyglarski', 1, 3, 'zyglarski_blazej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(174, 'Maciej', 'Kitajewski', 1, 3, 'kitajewski_maciej');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(175, 'Wiktor', 'Szpunar', 13, 54, 'szpunar_wiktor');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(176, 'Tim', 'Malbon', 1, 2, 'malbon_tim');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(177, 'Karl', 'Hodge', 19, 71, 'hodge_karl');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(178, 'Piotr', 'Kupczyk', 1, 4, 'kupczyk_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(179, 'Rayn', 'Carson', 1, 3, 'carson_rayn');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(180, 'Dean', 'Kerrigan', 1, 2, 'kerrigan_dean');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(181, 'Oliver', 'Lindberg', 6, 26, 'lindberg_oliver');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(182, 'Gary', 'Marshall', 16, 51, 'marshall_gary');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(183, 'Piotr', 'Zembura', 1, 2, 'zembura_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(184, 'Richard', 'Wentk', 2, 7, 'wentk_richard');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(185, 'Andy', 'Butland', 1, 2, 'butland_andy');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(186, 'Marek', 'Jaślan', 1, 1, 'jaslan_marek');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(187, 'Louis', 'Divine', 1, 2, 'divine_louis');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(188, 'Alex', 'Hunte', 1, 2, 'hunte_alex');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(189, 'Rayan', 'Carson', 1, 4, 'carson_rayan');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(190, 'Bradley', 'Martin', 2, 4, 'martin_bradley');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(191, 'Sarah', 'Lukins', 1, 2, 'lukins_sarah');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(192, 'Christian', 'Hall', 7, 28, 'hall_christian');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(193, 'Franciszek', 'Kędzierski', 1, 2, 'kedzierski_franciszek');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(194, 'Andrew', 'Walker', 1, 2, 'walker_andrew');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(195, 'Mo', 'Kader', 1, 2, 'kader_mo');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(196, 'Pete', 'Brown', 1, 2, 'brown_pete');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(197, 'Artur', 'Waliszewski', 1, 2, 'waliszewski_artur');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(198, '-', 'KBAB', 1, 3, 'kbab');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(199, 'Danny', 'Bradbury', 1, 4, 'bradbury_danny');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(200, 'Thin', 'Martian', 5, 10, 'martian_thin');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(201, 'Mateusz', 'Kornacki', 2, 7, 'kornacki_mateusz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(202, 'Richard', 'Hill', 1, 4, 'hill_richard');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(203, 'Chris', 'Jenkins', 1, 2, 'jenkins_chris');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(204, 'Grzegorz', 'Michałek', 1, 2, 'michalek_grzegorz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(205, 'Alison', 'Dunn', 1, 2, 'dunn_alison');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(206, 'Struan', 'Robertson', 1, 2, 'robertson_struan');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(207, 'Leszek', 'Krupiński', 1, 1, 'krupinski_leszek');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(208, 'Szymon', 'Rubisz', 1, 2, 'rubisz_szymon');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(209, 'Patryk', 'Zawadzki', 1, 1, 'zawadzki_patryk');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(210, 'Jakub', 'Duraj', 1, 4, 'duraj_jakub');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(211, 'Jason', 'Arber', 1, 4, 'arber_jason');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(212, 'Chris', 'Hassell', 1, 2, 'hassell_chris');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(213, 'Zenon', 'Michalski', 1, 12, 'michalski_zenon');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(214, 'Dan', 'Oliver', 1, 3, 'oliver_dan');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(215, 'Tony', 'Macklin', 1, 2, 'macklin_tony');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(216, 'Rob', 'Buckley', 1, 4, 'buckley_rob');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(217, 'Jason', 'Walsh', 1, 4, 'walsh_jason');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(218, 'Richard', 'Cobbet', 1, 4, 'cobbet_richard');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(219, 'Kris', 'Hadlock', 1, 4, 'hadlock_kris');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(220, 'Piotr', 'Perka', 9, 18, 'perka_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(221, 'Piotr', 'Palikowski', 1, 2, 'palikowski_piotr');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(222, 'Dominik', 'Wartecki', 1, 4, 'wartecki_dominik');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(223, 'Brain', 'Fling', 1, 7, 'fling_brain');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(224, 'Artur', 'Strzelecki', 5, 16, 'strzelecki_artur');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(225, 'Tomasz', 'Piotrowski', 2, 8, 'piotrowski_tomasz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(226, 'Dean', 'Hachamovitch', 1, 3, 'hachamovitch_dean');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(227, 'Paul', 'Wyatt', 1, 3, 'wyatt_paul');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(228, 'Paul', 'Dawson', 1, 6, 'dawson_paul');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(229, 'Arkadiusz', 'Kopciński', 1, 3, 'kopcinski_arkadiusz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(230, 'Poul', 'Dawson', 1, 4, 'dawson_poul');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(231, 'Damian', 'Wielgosik', 8, 24, 'wielgosik_damian');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(232, 'Agnieszka', 'Ryglewicz', 1, 3, 'ryglewicz_agnieszka');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(233, 'Paweł', 'Kobis', 1, 4, 'kobis_pawel');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(234, 'Mark', 'Buckingham', 1, 4, 'buckingham_mark');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(235, 'Richard', 'Cobbertt', 2, 7, 'cobbertt_richard');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(236, 'Przemysław', 'Kondraciuk', 2, 6, 'kondraciuk_przemyslaw');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(237, 'Michał', 'Zator', 2, 3, 'zator_michal');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(238, 'Paweł', 'Pylak', 1, 4, 'pylak_pawel');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(239, 'Marcin', 'Prys', 1, 3, 'prys_marcin');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(240, 'Wojciech', 'Wowra', 3, 10, 'wowra_wojciech');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(241, 'Marcin', 'Majerek', 1, 2, 'majerek_marcin');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(242, 'Grzegorz', 'Miłkowski', 1, 2, 'milkowski_grzegorz');
INSERT INTO `autor` (`autor_id`, `imie`, `nazwisko`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(243, 'Anna', 'Dworniczak', 1, 4, 'dworniczak_anna');

--
-- Zrzut danych tabeli `numer`
--

INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(1, 2, 20, 59, '2001_2', 1);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(2, 3, 20, 58, '2001_3', 1);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(3, 4, 24, 63, '2001_4', 1);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(4, 5, 22, 69, '2001_5', 1);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(5, 6, 20, 70, '2001_6', 1);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(6, 7, 22, 72, '2001_7', 1);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(7, 9, 21, 67, '2001_9', 1);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(8, 10, 19, 70, '2001_10', 1);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(9, 11, 15, 68, '2001_11', 1);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(10, 12, 22, 71, '2001_12', 1);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(11, 1, 24, 76, '2002_1', 2);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(12, 2, 25, 89, '2002_2', 2);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(13, 3, 21, 83, '2002_3', 2);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(14, 4, 24, 81, '2002_4', 2);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(15, 5, 23, 80, '2002_5', 2);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(16, 6, 18, 74, '2002_6', 2);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(17, 7, 21, 72, '2002_7', 2);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(18, 8, 20, 74, '2002_8', 2);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(19, 9, 19, 64, '2002_9', 2);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(20, 10, 20, 67, '2002_10', 2);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(21, 11, 17, 71, '2002_11', 2);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(22, 12, 18, 69, '2002_12', 2);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(23, 1, 17, 69, '2003_1', 3);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(24, 2, 16, 78, '2003_2', 3);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(25, 3, 17, 78, '2003_3', 3);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(26, 4, 19, 73, '2003_4', 3);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(27, 5, 15, 66, '2003_5', 3);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(28, 6, 18, 75, '2003_6', 3);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(29, 7, 16, 73, '2003_7', 3);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(30, 8, 16, 74, '2003_8', 3);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(31, 9, 18, 75, '2003_9', 3);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(32, 10, 15, 72, '2003_10', 3);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(33, 11, 16, 76, '2003_11', 3);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(34, 12, 19, 80, '2003_12', 3);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(35, 1, 18, 75, '2004_1', 4);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(36, 2, 21, 74, '2004_2', 4);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(37, 3, 16, 68, '2004_3', 4);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(38, 4, 19, 84, '2004_4', 4);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(39, 5, 20, 83, '2004_5', 4);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(40, 6, 17, 68, '2004_6', 4);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(41, 7, 24, 80, '2004_7', 4);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(42, 8, 17, 70, '2004_8', 4);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(43, 9, 21, 76, '2004_9', 4);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(44, 10, 17, 73, '2004_10', 4);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(45, 11, 21, 74, '2004_11', 4);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(46, 12, 21, 77, '2004_12', 4);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(47, 1, 17, 69, '2005_1', 5);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(48, 2, 23, 76, '2005_2', 5);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(49, 3, 20, 74, '2005_3', 5);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(50, 4, 23, 74, '2005_4', 5);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(51, 5, 20, 69, '2005_5', 5);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(52, 6, 23, 78, '2005_6', 5);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(53, 7, 21, 79, '2005_7', 5);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(54, 8, 23, 78, '2005_8', 5);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(55, 9, 20, 73, '2005_9', 5);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(56, 10, 17, 67, '2005_10', 5);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(57, 11, 23, 76, '2005_11', 5);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(58, 12, 22, 79, '2005_12', 5);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(59, 1, 21, 75, '2006_1', 6);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(60, 2, 22, 73, '2006_2', 6);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(61, 3, 23, 71, '2006_3', 6);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(62, 4, 24, 70, '2006_4', 6);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(63, 5, 23, 73, '2006_5', 6);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(64, 6, 24, 74, '2006_6', 6);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(65, 7, 21, 73, '2006_7', 6);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(66, 8, 25, 73, '2006_8', 6);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(67, 9, 22, 69, '2006_9', 6);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(68, 10, 21, 72, '2006_10', 6);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(69, 1, 24, 77, '2007_1', 7);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(70, 2, 25, 78, '2007_2', 7);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(71, 3, 26, 79, '2007_3', 7);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(72, 4, 25, 76, '2007_4', 7);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(73, 5, 25, 77, '2007_5', 7);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(74, 6, 22, 71, '2007_6', 7);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(75, 7, 26, 75, '2007_7', 7);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(76, 8, 26, 80, '2007_8', 7);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(77, 9, 24, 70, '2007_9', 7);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(78, 10, 26, 83, '2007_10', 7);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(79, 11, 26, 77, '2007_11', 7);
INSERT INTO `numer` (`numer_id`, `numer`, `liczbaartykulow`, `liczbastron`, `slug`, `rocznik_id`) VALUES(80, 12, 27, 79, '2007_12', 7);

--
-- Zrzut danych tabeli `podrubryka`
--

INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(1, 'TELEPRACA', 1, 7, 'telepraca');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(2, 'AKTUALNOŚCI', 2, 3, 'aktualnosci');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(3, 'CYBERŚWIAT', 52, 167, 'cyberswiat');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(4, 'PORADNIK', 196, 640, 'poradnik');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(5, 'TRENDY', 49, 180, 'trendy');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(6, 'WYWIAD', 35, 70, 'wywiad');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(7, 'ZESTAWIENIA', 3, 12, 'zestawienia');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(8, 'OPISY', 57, 109, 'opisy');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(9, 'PRZEGLĄD', 80, 358, 'przeglad');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(10, 'DHTML&amp;JAVASCRIPT', 2, 4, 'dhtml_amp_javascript');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(11, 'PHP', 69, 280, 'php');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(12, 'PRAKTYKA', 87, 299, 'praktyka');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(13, 'JAVA', 5, 16, 'java');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(14, 'PROMOCJA MUZYKI', 1, 6, 'promocja_muzyki');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(15, 'OPINIE', 16, 16, 'opinie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(16, 'PRAWO', 20, 55, 'prawo');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(17, 'USŁUGI', 43, 148, 'uslugi');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(18, 'WYDARZENIA', 5, 20, 'wydarzenia');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(19, 'KRÓTKIE TESTY', 19, 26, 'krotkie_testy');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(20, 'DHTML', 3, 6, 'dhtml');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(21, 'FLASH', 22, 83, 'flash');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(22, 'RAPORT', 30, 138, 'raport');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(23, 'CYBEŚWIAT', 1, 5, 'cybeswiat');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(24, 'TECHNOLOGIE', 26, 106, 'technologie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(25, 'EDUKACJA', 8, 29, 'edukacja');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(26, 'ZASTOSOWANIA', 15, 53, 'zastosowania');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(27, 'E-BANKING', 3, 12, 'e_banking');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(28, 'E-COMMERCE', 2, 6, 'e_commerce');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(29, 'PROGRAMOWANIE', 10, 40, 'programowanie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(30, 'WEBGRAFIKA', 12, 47, 'webgrafika');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(31, 'E-MARKETING', 25, 83, 'e_marketing');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(32, '', 73, 509, 'brak');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(33, 'REKLAMA', 1, 1, 'reklama');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(34, 'E-HANDEL', 12, 49, 'e_handel');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(35, 'E-FINANSE', 2, 6, 'e_finanse');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(36, 'ZASOBY', 9, 31, 'zasoby');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(37, 'FELIETON', 14, 14, 'felieton');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(38, 'TEST', 10, 22, 'test');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(39, 'BEZPIECZEŃSTWO', 18, 58, 'bezpieczenstwo');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(40, 'E-BIZNES', 17, 66, 'e_biznes');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(41, 'E-SZTUKA', 2, 6, 'e_sztuka');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(42, 'SERWERY', 1, 3, 'serwery');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(43, 'JAVASCRIPT', 13, 44, 'javascript');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(44, 'CYFRÓWKI', 1, 9, 'cyfrowki');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(45, 'E-BANKOWOŚĆ', 1, 4, 'e_bankowosc');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(46, 'E-LEARNING', 3, 11, 'e_learning');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(47, 'PHP+SQL', 1, 2, 'php_sql');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(48, 'MOBILNA SIEĆ', 1, 10, 'mobilna_siec');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(49, 'FLASH I PHP', 1, 3, 'flash_i_php');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(50, 'PC-SERWER', 1, 9, 'pc_serwer');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(51, 'E-EDUKACJA', 1, 5, 'e_edukacja');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(52, 'SERWER DLA FIRMY', 1, 9, 'serwer_dla_firmy');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(53, 'MYSQL', 2, 9, 'mysql');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(54, 'SMARTY', 2, 10, 'smarty');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(55, 'PHP-PDF', 1, 5, 'php_pdf');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(56, 'HOSTING', 4, 36, 'hosting');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(57, 'PRACA', 3, 9, 'praca');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(58, 'PHP+JS', 1, 2, 'php_js');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(59, 'CVS', 1, 2, 'cvs');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(60, 'SPRZĘT', 1, 6, 'sprzet');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(61, 'GALERIE', 1, 3, 'galerie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(62, 'GRAFIKA', 6, 32, 'grafika');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(63, 'PHP/MYSQL', 3, 17, 'php_mysql');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(64, 'OKNO NA ŚWIAT', 1, 3, 'okno_na_swiat');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(65, 'KNOW-HOW', 1, 2, 'know_how');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(66, 'WEBMASTERING', 1, 4, 'webmastering');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(67, 'BEZ BARIER', 1, 4, 'bez_barier');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(68, 'DOSTĘP DO INTERNETU', 3, 12, 'dostep_do_internetu');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(69, 'STATYSTYKI SIECI', 1, 2, 'statystyki_sieci');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(70, 'P2P', 1, 3, 'p2p');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(71, 'RYNEK', 9, 23, 'rynek');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(72, 'PODSTAWY', 19, 105, 'podstawy');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(73, 'BAROMETR', 24, 80, 'barometr');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(74, 'TURYSTYKA', 1, 16, 'turystyka');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(75, 'ROZRYWKA', 16, 25, 'rozrywka');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(76, 'APARATY', 2, 11, 'aparaty');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(77, 'PODATKI', 2, 3, 'podatki');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(78, 'SIEĆ BEZ BARIER', 1, 4, 'siec_bez_barier');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(79, 'KONTA POCZTOWE', 2, 16, 'konta_pocztowe');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(80, 'E-RYNEK', 2, 8, 'e_rynek');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(81, 'E-GOVERNMENT', 1, 2, 'e_government');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(82, 'W CO SIĘ BAWIĆ', 6, 16, 'w_co_sie_bawic');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(83, 'HTML', 22, 94, 'html');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(84, 'ABC WEBMASTERA', 2, 9, 'abc_webmastera');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(85, 'FOTOLABY', 2, 8, 'fotolaby');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(86, 'USŁUGI HOSTINGOWE', 2, 12, 'uslugi_hostingowe');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(87, 'RUTOWANIE', 2, 11, 'rutowanie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(88, 'CMS', 1, 5, 'cms');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(89, 'INTERNET 2004', 1, 10, 'internet_2004');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(90, 'SYSTEMY CMS', 5, 21, 'systemy_cms');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(91, 'E-REKLAMA', 4, 10, 'e_reklama');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(92, 'DOSTĘP DO SIECI', 4, 23, 'dostep_do_sieci');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(93, 'NARZĘDZIA', 10, 40, 'narzedzia');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(94, 'E-OSZCZĘDZANIE', 3, 7, 'e_oszczedzanie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(95, 'E-OBYCZAJE', 2, 4, 'e_obyczaje');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(96, 'CSS', 11, 44, 'css');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(97, 'HTML/PHP', 2, 11, 'html_php');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(98, 'WAP', 1, 5, 'wap');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(99, 'XHTML', 7, 23, 'xhtml');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(100, 'INTERNET Z KOMÓRKI', 2, 9, 'internet_z_komorki');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(101, 'RSS', 3, 12, 'rss');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(102, 'WEBKAMERY', 2, 12, 'webkamery');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(103, 'ATAKI XSS', 1, 5, 'ataki_xss');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(104, 'INTERNET DLA GRACZY', 6, 13, 'internet_dla_graczy');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(105, 'PRACA Z SIECI', 1, 8, 'praca_z_sieci');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(106, 'OPROGRAMOWANIE', 1, 3, 'oprogramowanie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(107, 'E-RANDKI', 1, 4, 'e_randki');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(108, 'VOIP', 3, 27, 'voip');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(109, 'PREZENTACJA', 4, 4, 'prezentacja');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(110, 'RANKING E-SKLEPÓW', 1, 7, 'ranking_e_sklepow');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(111, 'DOMENY', 7, 21, 'domeny');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(112, 'E-ZAKUPY', 21, 24, 'e_zakupy');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(113, 'WYSZUKIWANIE ZASOBÓW W SIECI', 1, 8, 'wyszukiwanie_zasobow_w_sieci');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(114, 'WIRTUALNE PAŃSTWA', 3, 10, 'wirtualne_panstwa');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(115, 'WEBDESIGN', 1, 2, 'webdesign');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(116, 'NEWSLETTER', 1, 4, 'newsletter');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(117, 'CYBERWANDALIZM', 1, 4, 'cyberwandalizm');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(118, 'RSS W OUTLOOKU', 1, 4, 'rss_w_outlooku');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(119, 'FIREFOX', 2, 4, 'firefox');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(120, 'TUTORIAL', 2, 4, 'tutorial');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(121, 'GRAFIKA NA STRONY WWW', 10, 41, 'grafika_na_strony_www');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(122, 'BAZY DANYCH', 12, 48, 'bazy_danych');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(123, 'INSPIRACJE', 22, 44, 'inspiracje');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(124, 'EDYTORY HTML NA STRONĘ WWW', 1, 4, 'edytory_html_na_strone_www');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(125, 'KLINIKA STRON WWW', 20, 40, 'klinika_stron_www');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(126, 'BANKOWOŚĆ ELEKTRONICZNA', 1, 10, 'bankowosc_elektroniczna');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(127, 'LEGALNA MUZYKA', 1, 5, 'legalna_muzyka');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(128, 'EDYTOR TEKSTU ONLINE', 1, 4, 'edytor_tekstu_online');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(129, 'INTERNET PRZEZ SATELITĘ', 1, 4, 'internet_przez_satelite');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(130, 'HISTORIA PROJEKTU', 2, 4, 'historia_projektu');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(131, 'SERWER NA ZMIENNYM IP', 1, 4, 'serwer_na_zmiennym_ip');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(132, 'RSS W THUNDERBIRDZIE', 1, 3, 'rss_w_thunderbirdzie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(133, 'BEZPIECZNY PC', 2, 9, 'bezpieczny_pc');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(134, 'INTERNETOWA TV', 1, 4, 'internetowa_tv');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(135, 'BILETY LOTNICZE ONLINE', 1, 4, 'bilety_lotnicze_online');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(136, 'DYSK W SIECI', 1, 3, 'dysk_w_sieci');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(137, 'TELEFONIA INTERNETOWA', 1, 2, 'telefonia_internetowa');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(138, 'SZYFROWANIE POCZTY', 1, 3, 'szyfrowanie_poczty');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(139, 'NOWOŚCI', 11, 20, 'nowosci');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(140, 'SERWISY INFORMACYJNE', 1, 2, 'serwisy_informacyjne');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(141, 'JABBER', 1, 2, 'jabber');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(142, 'OD PROJEKTU DO REALIZACJI', 17, 34, 'od_projektu_do_realizacji');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(143, 'NIEBEZPIECZNE E-APTEKI', 1, 2, 'niebezpieczne_e_apteki');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(144, 'PLANOWANIE', 1, 4, 'planowanie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(145, 'OBSŁUGA ANTYWIRUSA', 1, 2, 'obsluga_antywirusa');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(146, 'TWORZENIE GALERII', 1, 2, 'tworzenie_galerii');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(147, 'WALIDACJA STRON WWW', 1, 2, 'walidacja_stron_www');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(148, 'BEZPŁATNE NARZĘDZIA', 1, 6, 'bezplatne_narzedzia');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(149, 'POŻYTECZNE SERWISY', 1, 2, 'pozyteczne_serwisy');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(150, 'STREFA BLOGÓW', 1, 2, 'strefa_blogow');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(151, 'PODKRĘCANIE SERWISÓW', 1, 4, 'podkrecanie_serwisow');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(152, 'MULTIMEDIA', 1, 6, 'multimedia');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(153, 'USŁUGI SIECIOWE', 1, 4, 'uslugi_sieciowe');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(154, 'AUKCJE INTERNETOWE', 4, 14, 'aukcje_internetowe');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(155, 'NOWE OBLICZE MEDIÓW', 1, 4, 'nowe_oblicze_mediow');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(156, 'E-SPOŁECZNOŚCI', 1, 4, 'e_spolecznosci');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(157, 'MULTIMEDIA ONLINE', 1, 4, 'multimedia_online');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(158, 'CIEKAWE SERWISY', 1, 2, 'ciekawe_serwisy');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(159, 'SIEĆ W PRAKTYCE', 1, 2, 'siec_w_praktyce');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(160, 'MULTIMEDIA BEZ TAJEMNIC', 1, 2, 'multimedia_bez_tajemnic');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(161, 'PLIKI AUDIO BEZ TAJEMNIC', 1, 4, 'pliki_audio_bez_tajemnic');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(162, 'FOTOLABY ONLINE', 1, 12, 'fotolaby_online');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(163, 'TRENDY W PROJEKTOWANIU', 1, 6, 'trendy_w_projektowaniu');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(164, 'PLIKI W SIECI', 2, 7, 'pliki_w_sieci');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(165, 'PROMOCJA WITRYNY', 2, 6, 'promocja_witryny');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(166, 'TELEKOMUNIKACJA', 1, 6, 'telekomunikacja');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(167, 'PHISHING', 1, 2, 'phishing');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(168, 'PRZYSPIESZANIE ŁĄCZA', 1, 4, 'przyspieszanie_lacza');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(169, 'GDZIE I JAK KUPOWAĆ?', 3, 9, 'gdzie_i_jak_kupowac');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(170, 'ULEPSZANIE FIREFOXA', 1, 4, 'ulepszanie_firefoxa');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(171, 'ULEPSZANIE STRON WWW', 1, 4, 'ulepszanie_stron_www');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(172, 'RANDKI W SIECI', 1, 5, 'randki_w_sieci');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(173, 'NARZĘDZIA ONLINE', 16, 44, 'narzedzia_online');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(174, 'KALENDARZ ONLINE', 1, 2, 'kalendarz_online');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(175, 'FIRMOWA STRONA WWW', 2, 7, 'firmowa_strona_www');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(176, 'E-PRZESTĘPCZOŚĆ', 1, 2, 'e_przestepczosc');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(177, 'SEKRETY PROFESJONALISTÓW', 1, 4, 'sekrety_profesjonalistow');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(178, 'PRZETWARZANIE ROZPROSZONE', 1, 4, 'przetwarzanie_rozproszone');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(179, 'INICJATYWY', 1, 4, 'inicjatywy');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(180, 'POBIERANIE PLIKÓW', 1, 4, 'pobieranie_plikow');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(181, 'SKUTECZNE LICYTOWANIE', 1, 4, 'skuteczne_licytowanie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(182, 'ULEPSZANIE THUNDERBIRDA', 1, 3, 'ulepszanie_thunderbirda');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(183, 'MANIA GRANIA', 1, 3, 'mania_grania');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(184, 'OPTYMALIZACJA NEOSTRADY', 1, 3, 'optymalizacja_neostrady');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(185, 'WTYCZKI DLA PROGRAMISTÓW', 1, 4, 'wtyczki_dla_programistow');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(186, 'HTML/CSS/JAVASCRIPT', 1, 4, 'html_css_javascript');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(187, 'WIRTUALNE SPOŁECZNOŚCI', 1, 4, 'wirtualne_spolecznosci');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(188, 'DARMOWE SZABLONY WWW', 1, 4, 'darmowe_szablony_www');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(189, 'EDYCJA GRAFIKI ONLINE', 1, 3, 'edycja_grafiki_online');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(190, 'GOOGLOMANIA', 1, 5, 'googlomania');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(191, 'BUDOWA GALERII', 1, 3, 'budowa_galerii');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(192, 'TEORIA KOLORU', 1, 4, 'teoria_koloru');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(193, 'AUTOREKLAMA', 1, 4, 'autoreklama');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(194, 'PODCASTING', 3, 12, 'podcasting');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(195, 'DAWNO, DAWNO TEMU', 3, 14, 'dawno_dawno_temu');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(196, 'W SKRÓCIE', 36, 36, 'w_skrocie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(197, 'TWORZENIE SZABLONÓW', 10, 48, 'tworzenie_szablonow');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(198, 'SERFUJ MOBILNIE', 1, 6, 'serfuj_mobilnie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(199, 'SZABLONY STRON WWW', 1, 4, 'szablony_stron_www');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(200, 'PRACA ONLINE', 1, 4, 'praca_online');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(201, 'SEO', 1, 5, 'seo');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(202, 'PROSTY E-SKLEP', 1, 3, 'prosty_e_sklep');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(203, 'ANIMOWANE GIFY', 1, 4, 'animowane_gify');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(204, 'WYSYŁANIE ZAŁĄCZNIKÓW', 1, 2, 'wysylanie_zalacznikow');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(205, 'ATAKI BEZ TAJEMNIC', 1, 6, 'ataki_bez_tajemnic');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(206, 'MOBILNY INTERNET', 2, 11, 'mobilny_internet');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(207, 'MAPY ONLINE', 1, 4, 'mapy_online');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(208, 'GOOGLE ADSENSE', 1, 3, 'google_adsense');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(209, 'ZDJĘCIA ONLINE', 1, 2, 'zdjecia_online');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(210, 'KAMERA ONLINE', 1, 2, 'kamera_online');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(211, 'POLITYKA', 1, 2, 'polityka');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(212, 'WSZYSTKO O CZCIONKACH', 1, 6, 'wszystko_o_czcionkach');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(213, 'RADIO NA ŻYCZENIE', 1, 6, 'radio_na_zyczenie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(214, 'CYFROWA TOŻSAMOŚC', 1, 4, 'cyfrowa_tozsamosc');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(215, 'SPAM', 1, 6, 'spam');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(216, 'TELEFONIA VOIP', 2, 6, 'telefonia_voip');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(217, 'WORDPRESS', 1, 3, 'wordpress');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(218, 'PROPEL', 3, 18, 'propel');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(219, 'GALERIE ZA DARMO', 1, 6, 'galerie_za_darmo');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(220, 'BLOGI', 1, 4, 'blogi');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(221, 'SYSTEMY OPERACYJNE ONLINE', 1, 2, 'systemy_operacyjne_online');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(222, 'E-LITERATURA', 1, 4, 'e_literatura');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(223, 'ULEPSZAMY FIREFOKSA', 1, 5, 'ulepszamy_firefoksa');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(224, 'TELEFONIA WOIP', 1, 3, 'telefonia_woip');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(225, 'PHPBB', 1, 3, 'phpbb');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(226, 'URLOP Z SIECI', 1, 5, 'urlop_z_sieci');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(227, 'DARMOWE SKRZYNKI E-MAIL', 1, 8, 'darmowe_skrzynki_e_mail');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(228, 'INTERNET W OPEN SOURCE', 1, 3, 'internet_w_open_source');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(229, 'POZYCJONOWANIE WITRYN', 1, 3, 'pozycjonowanie_witryn');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(230, 'OBRÓBKA GRAFIKI ONLINE', 1, 4, 'obrobka_grafiki_online');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(231, 'ANTYSPAM', 1, 3, 'antyspam');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(232, 'HOSTING PLIKÓW', 1, 2, 'hosting_plikow');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(233, 'NARZĘDZIA DLA FIRM', 1, 3, 'narzedzia_dla_firm');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(234, 'SYSTEMY WYMIANY LINKÓW', 1, 4, 'systemy_wymiany_linkow');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(235, 'E-KSIĘGOWOŚĆ', 1, 4, 'e_ksiegowosc');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(236, 'FORUM DLA KAŻDEGO', 1, 6, 'forum_dla_kazdego');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(237, 'WSZYSTKO O ADWORDS', 1, 4, 'wszystko_o_adwords');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(238, 'POZYCJONOWANIE', 2, 9, 'pozycjonowanie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(239, 'OPEN SOURCE', 4, 14, 'open_source');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(240, 'WIKIFARMA', 1, 4, 'wikifarma');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(241, 'E-MEDYCYNA', 1, 5, 'e_medycyna');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(242, 'E-MAIL NA ŻYCZENIE', 1, 2, 'e_mail_na_zyczenie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(243, 'USENET W PRAKTYCE', 1, 4, 'usenet_w_praktyce');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(244, 'OPTYMALIZACJA ŁĄCZY', 1, 3, 'optymalizacja_laczy');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(245, 'DBAJMY O ORTOGRAFIĘ', 2, 8, 'dbajmy_o_ortografie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(246, 'PRZYSZŁOŚĆ TELEWIZJI INTERNETOWEJ', 2, 7, 'przyszlosc_telewizji_internetowej');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(247, 'PHP/HTML/XHTML', 1, 5, 'php_html_xhtml');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(248, 'WEB 2', 2, 11, 'web_2');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(249, 'PROGRAMY PARTNERSKIE', 1, 4, 'programy_partnerskie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(250, 'PORTAL Z MODUŁÓW', 1, 3, 'portal_z_modulow');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(251, 'DEBUGOWANIE', 1, 4, 'debugowanie');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(252, 'WEBBLOGI', 1, 0, 'webblogi');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(253, 'PHP/HTML/SMARTY/SQL', 1, 6, 'php_html_smarty_sql');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(254, 'EDYCJA XHTML/CSS', 1, 4, 'edycja_xhtml_css');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(255, 'PRZEGLĄDARKI INTERNETOWE', 1, 8, 'przegladarki_internetowe');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(256, 'WYCENA SERWISÓW WWW', 1, 3, 'wycena_serwisow_www');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(257, 'CYBERSPORT', 1, 5, 'cybersport');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(258, 'PHP/CMS', 1, 3, 'php_cms');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(259, 'NARZĘDZIA GOOGLE', 1, 3, 'narzedzia_google');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(260, 'GADU-GADU', 1, 1, 'gadu_gadu');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(261, 'SERWISY', 1, 3, 'serwisy');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(262, 'WDRAŻAMY GOOGLE', 1, 5, 'wdrazamy_google');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(263, 'WŁASNE FORUM', 1, 5, 'wlasne_forum');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(264, 'TWORZENIE SZABLONÓW WWW', 2, 7, 'tworzenie_szablonow_www');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(265, 'KURS PHP', 2, 5, 'kurs_php');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(266, 'WIRTUALNE NIEBO', 1, 4, 'wirtualne_niebo');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(267, 'WEBUSABILITY', 1, 3, 'webusability');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(268, 'PORADNIK PROJEKTANTA', 1, 5, 'poradnik_projektanta');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(269, 'DOSTRAJANIE OPERY', 1, 3, 'dostrajanie_opery');
INSERT INTO `podrubryka` (`podrubryka_id`, `podrubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(270, 'AJAX', 1, 5, 'ajax');

--
-- Zrzut danych tabeli `rocznik`
--

INSERT INTO `rocznik` (`rocznik_id`, `rok`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(1, 2001, 205, 667, '2001');
INSERT INTO `rocznik` (`rocznik_id`, `rok`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(2, 2002, 250, 900, '2002');
INSERT INTO `rocznik` (`rocznik_id`, `rok`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(3, 2003, 202, 889, '2003');
INSERT INTO `rocznik` (`rocznik_id`, `rok`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(4, 2004, 232, 902, '2004');
INSERT INTO `rocznik` (`rocznik_id`, `rok`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(5, 2005, 252, 892, '2005');
INSERT INTO `rocznik` (`rocznik_id`, `rok`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(6, 2006, 226, 723, '2006');
INSERT INTO `rocznik` (`rocznik_id`, `rok`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(7, 2007, 302, 922, '2007');

--
-- Zrzut danych tabeli `rubryka`
--

INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(1, 'TEMAT MIESIĄCA', 17, 100, 'temat_miesiaca');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(2, 'MAGAZYN', 426, 1372, 'magazyn');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(3, 'RYNEK', 119, 449, 'rynek');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(4, 'OPROGRAMOWANIE', 95, 257, 'oprogramowanie');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(5, 'WARSZTAT', 242, 889, 'warsztat');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(6, 'SPRZĘT', 19, 26, 'sprzet');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(7, 'WARSZTAW', 12, 38, 'warsztaw');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(8, 'PORADNIK PRAKTYCZNY', 22, 335, 'poradnik_praktyczny');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(9, 'ARTYKUŁ SPONSOROWANY', 1, 1, 'artykul_sponsorowany');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(10, 'PROGRAMY', 106, 302, 'programy');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(11, 'Z OKŁADKI', 84, 422, 'z_okladki');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(12, 'FIRMA', 89, 281, 'firma');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(13, 'WEBMASTERING', 169, 568, 'webmastering');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(14, 'AKTUALNOŚCI', 21, 24, 'aktualnosci');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(15, 'ZASTOSOWANIA', 16, 60, 'zastosowania');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(16, 'CYBERŚWIAT', 5, 18, 'cyberswiat');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(17, 'PROJEKTOWANIE', 1, 2, 'projektowanie');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(18, 'SIEĆ W FIRMIE', 3, 8, 'siec_w_firmie');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(19, 'MONITORING SERWERÓW', 1, 4, 'monitoring_serwerow');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(20, 'BEZPIECZEŃSTWO', 6, 25, 'bezpieczenstwo');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(21, 'PRAKTYKA DLA POCZĄTKUJĄCYCH', 14, 40, 'praktyka_dla_poczatkujacych');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(22, 'USŁUGI', 23, 100, 'uslugi');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(23, 'TECHNOLOGIE', 21, 95, 'technologie');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(24, 'WEBDESIGN', 10, 29, 'webdesign');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(25, 'PRAKTYKA', 67, 226, 'praktyka');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(26, '-', 1, 1, 'brak');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(27, 'MULTIMEDIA', 2, 8, 'multimedia');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(28, 'CIEKAWOSTKI', 1, 2, 'ciekawostki');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(29, 'ZASOBY', 4, 12, 'zasoby');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(30, 'KOMUNIKATORY', 1, 2, 'komunikatory');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(31, 'MEDYCYNA ON-LINE', 1, 2, 'medycyna_on_line');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(32, 'WYWIAD', 25, 54, 'wywiad');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(33, 'SIEĆ W PRAKTYCE', 3, 8, 'siec_w_praktyce');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(34, 'PORADNIK', 2, 10, 'poradnik');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(35, 'E-BIZNES', 23, 69, 'e_biznes');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(36, 'E-HANDEL', 1, 6, 'e_handel');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(37, 'E-MARKETING', 2, 6, 'e_marketing');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(38, 'TRENDY', 1, 6, 'trendy');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(39, 'BLOGI', 1, 4, 'blogi');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(40, 'E-PRZESTĘPCZOŚĆ', 1, 2, 'e_przestepczosc');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(41, 'MUZYKA ONLINE', 3, 9, 'muzyka_online');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(42, 'KOMUNIKACJA', 2, 6, 'komunikacja');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(43, 'E-SPOŁECZNOŚCI', 3, 11, 'e_spolecznosci');
INSERT INTO `rubryka` (`rubryka_id`, `rubryka`, `liczbaartykulow`, `liczbastron`, `slug`) VALUES(44, 'PREZENTACJA', 3, 6, 'prezentacja');

SET FOREIGN_KEY_CHECKS=1;
