<?php

class Actions extends ActionsBase
{

    public function execute_list()
    {
        $kolumny = new TabelaArtykulow();

        if ($kolumny->incorrectVars()) {
            $this->execute_404();
            return;
        } else if ($kolumny->correctVars()) {
            $kolumny->setIndex($_GET['orderslug']);
            $kolumny->setOrder($_GET['order']);
        }

        $kolumny->assignCurrent();
        $c = $kolumny->getCriteria();
        $kolumny->reverseOrder();
        $kolumny->addURLs('index.php?module=artykul&action=list');
        
        
        $this->set('kolumny', $kolumny->getColumns());

        if (isset($_GET['page'])) {
            if (str_ievpi($_GET['page'])) {
                $strona = $_GET['page'];
            } else {
                $this->execute_404();
                return;
            }
        } else {
            $strona = '1';
        }

        $pager = new Pager('Artykul', ILE_NA_STRONIE, $c);

        if ($pager->isValidPage($strona)) {
            $pager->setPage($strona);
            $pager->assignRecords();
            
            $pager->setBaseURL(
                'index.php?module=artykul&action=list&order=' .
                    $kolumny->getCurrentOrder() .
                    '&orderslug=' .
                    $kolumny->getIndex() .
                    '&page='
            );
            
            
            $this->set('pager', $pager);
            
        } else {
            $this->execute_404();
        }

    }              
    
    public function execute_show()
    {
        if (
            isset($_GET['slug']) &&
            str_ivslug($_GET['slug']) &&
            ($artykul = ArtykulPeer::retrieveBySlug($_GET['slug']))
        ) {

            $this->set('artykul', $artykul);
            
            $wskaznik = new WskaznikArtykulu($artykul);
            $this->set('wskaznik', $wskaznik->getPointers());

        } else {

            $this->execute_404();

        }

    }
    
}