<?php

require_once 'XML/Serializer.php';
require_once 'XML/Unserializer.php';

$wszystkie = array();

$plks = glob('artykuly/*.xml');
foreach ($plks as $plk) {
    $unserializer = new XML_Unserializer();
    $unserializer->unserialize($plk, true);
    $wynik = $unserializer->getUnserializedData();    
    array_push($wszystkie, $wynik);
}

$serializer = new XML_Serializer();

$options = array(
    'addDecl'  => true,
    'indent'   => '    ',
    'rootName' => 'artykuly',
    'encoding' => 'utf-8',
    'defaultTagName' => 'artykul',    
);

$serializer->setOptions($options);
$serializer->serialize($wszystkie);
$wynik = $serializer->getSerializedData();
file_put_contents('artykuly.xml', $wynik);

