set names utf8;
drop database if exists phppp;
create database phppp default character set utf8 collate utf8_polish_ci;
grant all on phppp.* to admin@localhost identified by 'password';
flush privileges;
use phppp;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- rozdzial
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rozdzial`;


CREATE TABLE `rozdzial`
(
	`rozdzial_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`czesc_id` INTEGER  NOT NULL,
	`tytul` VARCHAR(255),
	`numer` INTEGER,
	`slug` VARCHAR(45),
	PRIMARY KEY (`rozdzial_id`),
	UNIQUE KEY `rozdzial_U_1` (`slug`(45)),
	KEY `rozdzial_I_1`(`czesc_id`),
	CONSTRAINT `fk_czesc`
		FOREIGN KEY (`czesc_id`)
		REFERENCES `czesc` (`czesc_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- projekt
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `projekt`;


CREATE TABLE `projekt`
(
	`projekt_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rozdzial_id` INTEGER  NOT NULL,
	`tytul` VARCHAR(255),
	`numer` INTEGER,
	`numerpelny` VARCHAR(20),
	`folder` VARCHAR(45),
	`plik` VARCHAR(45),
	`dane` INTEGER,
	`preview` INTEGER,
	`slug` VARCHAR(45),
	PRIMARY KEY (`projekt_id`),
	UNIQUE KEY `projekt_U_1` (`slug`(45)),
	KEY `projekt_I_1`(`rozdzial_id`),
	CONSTRAINT `fk_rozdzial`
		FOREIGN KEY (`rozdzial_id`)
		REFERENCES `rozdzial` (`rozdzial_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- menu
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `menu`;


CREATE TABLE `menu`
(
	`menu_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` TEXT,
	`tekst` TEXT,
	`slug` VARCHAR(255),
	PRIMARY KEY (`menu_id`),
	UNIQUE KEY `menu_U_1` (`slug`(255))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- czesc
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `czesc`;


CREATE TABLE `czesc`
(
	`czesc_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255),
	`numer` INTEGER,
	PRIMARY KEY (`czesc_id`)
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 3.1.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 14 Gru 2009, 09:59
-- Wersja serwera: 5.1.35
-- Wersja PHP: 5.2.9-2

SET FOREIGN_KEY_CHECKS=0;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Baza danych: `phppp`
--

--
-- Zrzut danych tabeli `czesc`
--

INSERT INTO `czesc` (`czesc_id`, `tytul`, `numer`) VALUES(1, 'Część pierwsza: Składnia języka PHP', 1);
INSERT INTO `czesc` (`czesc_id`, `tytul`, `numer`) VALUES(2, 'Część druga: HTML, napisy, tablice i pliki tekstowe', 2);
INSERT INTO `czesc` (`czesc_id`, `tytul`, `numer`) VALUES(3, 'Część trzecia: Zmienne URL', 3);
INSERT INTO `czesc` (`czesc_id`, `tytul`, `numer`) VALUES(4, 'Część czwarta: Szablony', 4);
INSERT INTO `czesc` (`czesc_id`, `tytul`, `numer`) VALUES(5, 'Część piąta: Bazy danych', 5);
INSERT INTO `czesc` (`czesc_id`, `tytul`, `numer`) VALUES(6, 'Część szósta: Interfejsy API dostępu do bazy danych', 6);
INSERT INTO `czesc` (`czesc_id`, `tytul`, `numer`) VALUES(7, 'Część siódma: MVC', 7);
INSERT INTO `czesc` (`czesc_id`, `tytul`, `numer`) VALUES(8, 'Część ósma: Przyjazne Adresy URL', 8);

--
-- Zrzut danych tabeli `menu`
--

INSERT INTO `menu` (`menu_id`, `tytul`, `tekst`, `slug`) VALUES(1, 'Od autora', '<h3>Witam serdecznie na witrynie</h3>\r\n\r\n<h4>PHP. Praktyczne projekty</h4>\r\n\r\n<p> Witryna jest dodatkiem do książki zatytułowanej <a href="http://helion.pl/view/3271w/phpprp.htm"><em>&bdquo;PHP.&nbsp;Praktyczne projekty&rdquo;</em></a> wydanej przez wydawnictwo <a href="http://helion.pl/view/3271w">Helion</a> we wrześniu 2009 roku. </p>\r\n<p> Znajdziesz tutaj projekty omówione w książce, zarówno rozwiązania, jak i wykorzystane dane. </p>\r\n<p> Witryna dostępna pod adresem <a href="http://phppp.gajdaw.pl">http://phppp.gajdaw.pl</a> <strong>jest&nbsp;okrojona</strong> w stosunku do zawartości płyty CD dołączonej do książki. </p>\r\n<p> Płyta CD dołączona do książki zawiera kompletny kod źródłowy wszystkich projektów wraz z zestawami danych. Projekty są dostępne w postaci spakowanych plików .zip (np. 10-01.zip, 18-03.zip, itd.), zaś dane do projektów &mdash; w archiwach, których nazwa kończy się przyrostkiem -dane.zip (np. 12-07-dane.zip, 16-01-dane.zip, itd.). W celu uruchomienia projektu należy najpierw rozpakować spakowane archiwum. W projektach, które wykorzystują bazę danych, plik ZIP z rozwiązaniem zawiera także kod SQL tworzący odpowiednią bazę danych. Płyta CD nie umożliwia podglądu działania skryptów PHP. </p>\r\n<p> Witryna dostępna pod adresem <a href="http://phppp.gajdaw.pl">http://phppp.gajdaw.pl</a> umożliwia podgląd działania wszystkich projektów lecz nie zawiera kodów źródłowych ani zestawów danych wykorzystanych w projektach. </p>\r\n<p> Ponadto płyta CD dołączona do książki zawiera oprogramowanie opisane w książce (m.in. Apache/PHP/MySQL) wraz z kompletną instrukcją instalacji w systemie Windows XP. </p>\r\n<p> Projekty dostępne do podglądu w internecie zostały także okrojone. Nie zawierają pełnych zestawów danych. Na przykład <a href="http://phppp.gajdaw.pl/projekty/25-03/index.php">zbiór zadań z programowania w C++ wykorzystany w projekcie 25.3</a> składa się z kilku dziesięciu rozdziałów i kilkuset zadań. Podgląd w internecie prezentuje tylko kilkanaście zadań. </p>\r\n<p> Podobieństwa i różnice pomiędzy zawartością płyty CD dołączonej do książki a witryną <a href="http://phppp.gajdaw.pl">http://phppp.gajdaw.pl</a> prezentuje poniższa tabela. </p>\r\n\r\n<table id="cdint">\r\n    <tr>\r\n        <th></th>\r\n        <th>Na płycie CD<br />dołączonej do książki</th>\r\n        <th>W internecie<br />http://phppp.gajdaw.pl</th>\r\n    </tr>\r\n    <tr>\r\n        <th>Podgląd projektu<br />w postaci ilustracji JPG</th>\r\n        <td>+</td>\r\n        <td>+</td>\r\n    </tr>\r\n    <tr>\r\n        <th>Kompletne rozwiązanie</th>\r\n        <td>+</td>\r\n        <td>-</td>\r\n    </tr>\r\n    <tr>\r\n        <th>Dane do projektu</th>\r\n        <td>+</td>\r\n        <td>-</td>\r\n    </tr>\r\n    <tr>\r\n        <th>Kod SQL tworzący bazy danych</th>\r\n        <td>+</td>\r\n        <td>-</td>\r\n    </tr>\r\n    <tr>\r\n        <th>Podgląd działania skryptu PHP</th>\r\n        <td>-</td>\r\n        <td>+<br />prezentowane zestawy danych zostały w kilku projektach okrojone</td>\r\n    </tr>\r\n    <tr>\r\n        <th>Oprogramowanie: Apache, PHP, Smarty, MySQL, phpMyAdmin, Propel, MySQL Workbench, wtyczka PropelExport do MySQL Workbench, Eclipse PHP Galileo, NotH</th>\r\n        <td>+</td>\r\n        <td>-</td>\r\n    </tr>\r\n    <tr>\r\n        <th>Instrukcja instalacji oprogramowania</th>\r\n        <td>+</td>\r\n        <td>-</td>\r\n    </tr>\r\n\r\n</table>\r\n\r\n\r\n<h5>Włodzimierz Gajda,<br />2 czerwca 2009 r.</h5>', 'index');
INSERT INTO `menu` (`menu_id`, `tytul`, `tekst`, `slug`) VALUES(2, 'Podziękowania', '<h3>Serdecznie dziękuję:</h3>\r\n\r\n<ul>\r\n<li><strong>Beacie</strong>, <strong>Kasi</strong>, <strong>Tomkowi</strong> i <strong>Bartkowi</strong>, za zapał, zainteresowanie i pomysły.</li>\r\n<li>Panu redaktorowi <strong>Krzysztofowi Zemankowi</strong> za pomoc w przygotowaniu książki i cierpliwość.</li>\r\n<li>Redaktorom <strong>Krystianowi Grzenkowiczowi</strong> oraz <strong>Michałowi Stępniowi</strong> za kilka lat owocnej współpracy. Duża część materiału zawartego w książce stanowi fragmenty artykułów, które opublikowałem na łamach czasopism Magazyn INTERNET oraz INTERNET Maker.</li>\r\n<li><strong>Studentom</strong>, którzy w latach 1999 &mdash; 2009 uczestniczyli w prowadzonych przeze mnie zajęciach, w ramach których, nauczałem programowania w języku PHP.</li>\r\n</ul>\r\n\r\n<h5>Włodzimierz Gajda,<br />2 czerwca 2009 r.</h5>', 'podziekowania');
INSERT INTO `menu` (`menu_id`, `tytul`, `tekst`, `slug`) VALUES(3, 'Metryka', '<h3>PHP. Praktyczne projekty</h3>\r\n<h3>Włodzimierz Gajda</h3>\r\n\r\n<p class="noindent">\r\nWydawnictwo <a href="http://helion.pl/view/3271w">Helion</a><br />\r\nGliwice 2009<br />\r\nWydanie I<br />\r\nFormat B5<br />\r\nOprawa miękka<br />\r\nISBN: 83-246-0943-1<br />\r\n</p>\r\n\r\n\r\n<p>\r\n<img src="okladki/phppp-okladka-duza.jpg" alt="" />\r\n</p>\r\n\r\n\r\n<p class="noindent">\r\n<a href="http://helion.pl/view/3271w/phpprp.htm">Książka w księgarni Helion</a><br />\r\n</p>', 'metryka');
INSERT INTO `menu` (`menu_id`, `tytul`, `tekst`, `slug`) VALUES(4, 'Dla kogo', '<h3>Dla kogo?</h3>\r\n\r\n<p> Książka jest skierowana do osób rozpoczynających naukę PHP oraz do tych, którzy wprawdzie PHP już w jakimś stopniu znają, lecz obce im są: </p>\r\n<ul>\r\n<li><strong>szablony</strong>,</li>\r\n<li><strong>oprogramowanie Smarty</strong>,</li>\r\n<li><strong>diagramy związków encji ERD (ang. Entity Relational Diagram)</strong>,</li>\r\n<li><strong>wizualne projektowanie baz danych</strong>,</li>\r\n<li><strong>narzędzie MySQL Workshop</strong>,</li>\r\n<li><strong>mapowanie relacyjno obiektowe ORM (ang. Object Relational Mapping)</strong>,</li>\r\n<li><strong>oprogramowanie Propel</strong>,</li>\r\n<li><strong>model architektoniczny MVC (ang. Model View Controller)</strong>,</li>\r\n<li><strong>moduł mod_rewrite serwera Apache</strong>,</li>\r\n<li><strong>oraz przyjazne adresy URL.</strong></li>\r\n</ul>\r\n\r\n\r\n<p> Głównym zadaniem książki jest przygotowanie początkującego programisty PHP do pracy nad większymi projektami i aplikacjami internetowymi. </p>\r\n\r\n<p> Wykonując projekty opisane w książce nauczysz się podstaw języka PHP oraz: </p>\r\n\r\n<ul>\r\n<li>poznasz <strong>szablony Smarty</strong> oraz <strong>szablony PHP</strong>,</li>\r\n<li>dowiesz się w jaki sposób wizualnie <strong>projektować bazy danych</strong>,</li>\r\n<li>nauczysz się wykorzystywać oprogramowanie <strong>ORM Propel</strong>,</li>\r\n<li>opanujesz model architektoniczny <strong>MVC</strong>,</li>\r\n<li>oraz będziesz umiał stosować <strong>przyjazne adresy URL</strong>.</li>\r\n</ul>', 'dla-kogo');
INSERT INTO `menu` (`menu_id`, `tytul`, `tekst`, `slug`) VALUES(5, 'Adresy', '<h3>Adresy</h3>\r\n\r\n<h4 class="adr">Oprogramowanie</h4>\r\n\r\n\r\n<ul>\r\n<li><a href="http://apache.org">Apache</a></li>\r\n<li><a href="http://php.net">PHP</a></li>\r\n<li><a href="http://smarty.net">Smarty</a></li>\r\n<li><a href="http://mysql.com">MySQL</a></li>\r\n<li><a href="http://www.phpmyadmin.net">phpMyAdmin</a></li>\r\n<li><a href="http://dev.mysql.com/workbench/">MySQL Workbench</a></li>\r\n<li><a href="http://www.diloc.de/blog/2008/05/27/mysql-workbench-propel-export-plugin/">MySQL Workbench Propel plugin</a></li>\r\n<li><a href="http://propel.phpdb.org/trac/">Propel</a></li>\r\n<li><a href="http://phing.info/trac/">Phing</a></li>\r\n<li><a href="http://pear.php.net/">PEAR</a></li>\r\n<li><a href="http://www.eclipse.org/pdt/">PHP Development Tools Project</a></li>\r\n<li><a href="http://www.mozilla-europe.org/pl/firefox/">Firefox</a></li>\r\n\r\n\r\n</ul>\r\n\r\n\r\n<h4 class="adr">PHP &mdash; dokumentacja</h4>\r\n\r\n<ul>\r\n\r\n<li><a href="http://pl2.php.net/manual/pl/funcref.php">Funkcje dostępne w PHP</a></li>\r\n<li><a href="http://pl2.php.net/manual/pl/book.math.php">Funkcje matematyczne</a></li>\r\n<li><a href="http://pl2.php.net/manual/pl/book.strings.php">Funkcje dotyczące napisów</a></li>\r\n<li><a href="http://pl2.php.net/manual/pl/book.array.php">Funkcje dotyczące tablic</a></li>\r\n<li><a href="http://pl2.php.net/manual/pl/book.pcre.php">Funkcje dotyczące wyrażeń regularnych PCRE</a></li>\r\n<li><a href="http://pl2.php.net/manual/pl/ref.filesystem.php">Funkcje systemu plików</a></li>\r\n<li><a href="http://pl2.php.net/manual/pl/book.pdo.php">Funkcje PDO</a></li>\r\n<li><a href="http://pl2.php.net/manual/pl/book.mysql.php">Funkcje mysql_xxx</a></li>\r\n<li><a href="http://pl2.php.net/manual/pl/book.mysqli.php">Funkcje mysqli_xxx</a></li>\r\n\r\n</ul>\r\n\r\n\r\n\r\n<h4 class="adr">ORM &mdash; opisy w wikipedii</h4>\r\n\r\n<ul>\r\n<li><a href="http://pl.wikipedia.org/wiki/ORM">Mapowanie relacyjno-obiektowe (po polsku)</a></li>\r\n<li><a href="http://en.wikipedia.org/wiki/Object-relational_mapping">Object-relational mapping (po angielsku)</a></li>\r\n<li><a href="http://en.wikipedia.org/wiki/List_of_object-relational_mapping_software#PHP">Lista pakietów ORM dla PHP</a></li>\r\n</ul>\r\n\r\n<h4 class="adr">ERD &mdash; opisy w wikipedii</h4>\r\n\r\n<ul>\r\n<li><a href="http://en.wikipedia.org/wiki/Entity-relationship_model">Entity-relationship model (po angielsku)</a></li>\r\n<li><a href="http://pl.wikipedia.org/wiki/Entity_Relationship_Diagram">Diagram związków encji</a></li>\r\n</ul>\r\n\r\n\r\n<h4 class="adr">MVC &mdash; opisy w wikipedii</h4>\r\n\r\n<ul>\r\n<li><a href="http://en.wikipedia.org/wiki/Model%E2%80%93view%E2%80%93controller">Model-View-Controller (po angielsku)</a></li>\r\n<li><a href="http://pl.wikipedia.org/wiki/MVC">Model-View-Controller (po polsku)</a></li>\r\n</ul>\r\n\r\n\r\n<h4 class="adr">Firefox &mdash; wtyczki</h4>\r\n\r\n<ul>\r\n<li><a href="http://livehttpheaders.mozdev.org/">LiveHTTPHeaders</a></li>\r\n<li><a href="http://chrispederick.com/work/webdeveloper/">Web Developer Toolbar</a></li>\r\n<li><a href="http://users.skynet.be/mgueury/mozilla/">HTML Validator</a></li>\r\n</ul>', 'adresy');
INSERT INTO `menu` (`menu_id`, `tytul`, `tekst`, `slug`) VALUES(6, 'Kontakt', '<h3>Kontakt z autorem</h3>\r\n\r\n<p> Aktualne informacje na temat mojego adresu e-mail oraz tradycyjnego adresu pocztowego znajdują się na stronie <a href="http://gajdaw.pl">http://gajdaw.pl</a>. </p>', 'kontakt');
INSERT INTO `menu` (`menu_id`, `tytul`, `tekst`, `slug`) VALUES(7, 'Moje książki', '<h3>Moje książki</h3>\r\n\r\n<table id="ksiazki" summary="">\r\n\r\n\r\n<tr>\r\n<td>\r\n<a href="http://helion.pl/view/3271w/phpprp.htm"><img src="okladki/phppp.jpg" alt="Okładka książki pt. PHP. Praktyczne projekty" /></a>\r\n</td>\r\n<td>\r\n<strong>PHP. Praktyczne projekty</strong><br />\r\n<strong>Włodzimierz Gajda</strong><br />\r\nWydawnictwo Helion<br />\r\nGliwice 2009<br />\r\nWydanie I<br />\r\nFormat B5<br />\r\nOprawa miękka<br />\r\nCD-ROM<br />\r\nISBN: 83-246-0943-1<br />\r\n<a href="http://phppp.gajdaw.pl">STRONA KSIĄŻKI</a><br />\r\n<a href="http://helion.pl/view/3271w/phpprp.htm">KSIĄŻKA W KSIĘGARNI WYDAWCY</a><br />\r\n<a href="http://helion.pl/view/3271w">STRONA WYDAWCY</a><br />\r\n</td>\r\n</tr>\r\n\r\n\r\n\r\n<tr>\r\n<td>\r\n<a href="http://helion.pl/view/3271w/htxcsp.htm"><img src="okladki/xhtmlpp.jpg" alt="Okładka książki pt. HTML, XHTML i CSS. Praktyczne projekty" /></a>\r\n</td>\r\n<td>\r\n<strong>HTML, XHTML i CSS. Praktyczne projekty</strong><br />\r\n<strong>Włodzimierz Gajda</strong><br />\r\nWydawnictwo Helion<br />\r\nGliwice 2007<br />\r\nWydanie I<br />\r\nFormat B5<br />\r\nOprawa miękka<br />\r\nCD-ROM<br />\r\nISBN 83-246-0885-0<br /><br />\r\n<a href="http://xhtmlpp.gajdaw.pl">STRONA KSIĄŻKI</a><br />\r\n<a href="http://helion.pl/view/3271w/htxcsp.htm">KSIĄŻKA W KSIĘGARNI WYDAWCY</a><br />\r\n<a href="http://helion.pl/view/3271w">STRONA WYDAWCY</a><br />\r\n</td>\r\n</tr>\r\n\r\n\r\n\r\n<tr>\r\n<td>\r\n<a href="http://helion.pl/view/3271w/gimppp.htm"><img src="okladki/gpp.jpg" alt="Okładka książki pt. GIMP. Praktyczne projekty" /></a>\r\n</td>\r\n<td>\r\n<strong>GIMP. Praktyczne projekty</strong><br />\r\n<strong>Włodzimierz Gajda</strong><br />\r\nWydawnictwo Helion<br />\r\nGliwice 2006<br />\r\nWydanie I<br />\r\n586 stron<br />\r\nFormat B5<br />\r\nOprawa miękka<br />\r\nCD-ROM<br />\r\nISBN 83-246-0439-1<br /><br />\r\n<a href="http://gpp.gajdaw.pl">STRONA KSIĄŻKI</a><br />\r\n<a href="http://helion.pl/view/3271w/gimppp.htm">KSIĄŻKA W KSIĘGARNI WYDAWCY</a><br />\r\n<a href="http://helion.pl/view/3271w">STRONA WYDAWCY</a><br />\r\n</td>\r\n</tr>\r\n\r\n\r\n\r\n<tr>\r\n<td>\r\n<a href="http://mikom.pwn.pl/4527_pozycja.html"><img src="okladki/gwz.jpg" alt="Okładka książki pt. GIMP w zastosowaniach" /></a>\r\n</td>\r\n<td>\r\n<strong>GIMP w zastosowaniach</strong><br />\r\n<strong>Włodzimierz Gajda</strong><br />\r\nWydawnictwo Mikom,<br />\r\nWarszawa 2004<br />\r\nWydanie I<br />\r\n178 stron<br />\r\nFormat B5<br />\r\nOprawa miękka<br />\r\nISBN 83-7279-431-6<br /><br />\r\n<a href="http://gwz.gajdaw.pl">STRONA KSIĄŻKI</a><br />\r\n<a href="http://mikom.pwn.pl/4527_pozycja.html">KSIĄŻKA W KSIĘGARNI WYDAWCY</a><br />\r\n<a href="http://mikom.pwn.pl">STRONA WYDAWCY</a><br />\r\n</td>\r\n</tr>\r\n\r\n</table>', 'ksiazki');
INSERT INTO `menu` (`menu_id`, `tytul`, `tekst`, `slug`) VALUES(8, 'Oprogramowanie', '<h3>Oprogramowanie</h3>\r\n\r\n\r\n<ul>\r\n<li><a href="instalacja/download/apache_2.2.11-win32-x86-openssl-0.9.8i.msi">apache_2.2.11-win32-x86-openssl-0.9.8i.msi</a></li>\r\n<li><a href="instalacja/download/php-5.2.9-2-Win32.zip">php-5.2.9-2-Win32.zip</a></li>\r\n<li><a href="instalacja/download/mysql-essential-5.1.35-win32.msi">mysql-essential-5.1.35-win32.msi</a></li>\r\n<li><a href="instalacja/download/Smarty-2.6.25.zip">Smarty-2.6.25.zip</a></li>\r\n<li><a href="instalacja/download/phpMyAdmin-3.1.5-all-languages.zip">phpMyAdmin-3.1.5-all-languages.zip</a></li>\r\n<li><a href="instalacja/download/mysql-workbench-oss-5.0.30-win32.msi">mysql-workbench-oss-5.0.30-win32.msi</a></li>\r\n<li><a href="instalacja/download/PropelExport.grt.lua">PropelExport.grt.lua</a></li>\r\n<li><a href="instalacja/download/eclipse-php-galileo-RC3-win32.zip">eclipse-php-galileo-RC3-win32.zip</a></li>\r\n<li><a href="instalacja/download/noth_1_0_1_14_install.exe">noth_1_0_1_14_install.exe</a></li>\r\n<li><a href="instalacja/download/noth-skroty-php-smarty.zip">noth-skroty-php-smarty.zip</a></li>\r\n</ul>', 'oprogramowanie');
INSERT INTO `menu` (`menu_id`, `tytul`, `tekst`, `slug`) VALUES(9, 'Skrypty', '<h3>Skrypty opisane w książce</h3>\r\n\r\n<ul>\r\n<li><a href="skrypty/db-frame-tool_1_1.zip">db-frame-tool_1_1.zip (z projektu 33.1)</a></li>\r\n<li><a href="skrypty/kontroler-mvc_0_2.zip">kontroler-mvc_0_2.zip (z projektu 38.2)</a></li>\r\n<li><a href="skrypty/biblioteki-funkcji.zip">biblioteki funkcji</a></li>\r\n</ul>', 'skrypty');
INSERT INTO `menu` (`menu_id`, `tytul`, `tekst`, `slug`) VALUES(10, 'Edycja kodu PHP', '<h3>Edycja kodu PHP</h3>\r\n\r\n<p> Cały kod PHP opisany w książce został napisany w edytorze <a href="http://noth.gajdaw.pl">NotH</a>. Skróty klawiszowe ułatwiające pisanie kodu PHP są zawarte w pliku <a href="instalacja/download/noth-skroty-php-smarty.zip">noth-skroty-php-smarty.zip</a>. Po <a href="instalacja/download/noth_1_0_1_14_install.exe">zainstalowaniu programu NotH</a> wypakuj plik <a href="instalacja/download/noth-skroty-php-smarty.zip">noth-skroty-php-smarty.zip</a>. do folderu <span class="filename">C:\\Program Files\\NotH\\conf</span>. </p>\r\n<p> Wśród programistów PHP dużym uznaniem cieszy się środowisko programistyczne <a href="http://www.eclipse.org/pdt/">Eclipse PHP</a>. Instalacja oprogramowania sprowadza się do wypakowania pliku <a href="instalacja/download/eclipse-php-galileo-RC3-win32.zip">eclipse-php-galileo-RC3-win32.zip</a> i uruchomienia programu <span class="filename">eclipse.exe</span>. </p>', 'edycja');

--
-- Zrzut danych tabeli `projekt`
--

INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(1, 10, 'Tabliczka mnożenia', 1, '10.1', '10-01', 'tabliczka-mnozenia.php', 0, 1, '10-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(2, 10, 'Tabela potęg', 2, '10.2', '10-02', 'tabela-poteg.php', 0, 1, '10-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(3, 10, 'Tablica wartości funkcji trygonometrycznych', 3, '10.3', '10-03', 'funkcje-trygonometryczne.php', 0, 1, '10-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(4, 10, 'Zestawienie szablonów', 4, '10.4', '10-04', 'index.php', 0, 1, '10-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(5, 11, 'Karuzela', 1, '11.1', '11-01', 'karuzela.php', 0, 1, '11-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(6, 11, 'Abrakadabra', 2, '11.2', '11-02', 'abrakadabra.php', 0, 1, '11-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(7, 11, 'Polskie znaki iso-8859-2', 3, '11.3', '11-03', 'polskie-znaki-iso.php', 0, 1, '11-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(8, 11, 'Polskie znaki iso-8859-2 oraz windows-1250', 4, '11.4', '11-04', 'polskie-znaki-iso-win.php', 0, 1, '11-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(9, 11, 'Prezentacja zawartości pliku XML', 5, '11.5', '11-05', 'skrypt.php', 1, 1, '11-05');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(10, 11, 'Deszcz, jesienny deszcz', 6, '11.6', '11-06', 'skrypt.php', 1, 1, '11-06');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(11, 11, 'Przetwarzanie napisów utf-8 znak po znaku', 7, '11.7', '11-07', 'polskie-znaki-utf.php', 0, 1, '11-07');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(12, 12, 'Auta', 1, '12.1', '12-01', 'auta.php', 0, 1, '12-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(13, 12, 'Bezpieczne kolory WWW', 2, '12.2', '12-02', 'bezpieczne-kolory.php', 0, 1, '12-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(14, 12, 'Osoby', 3, '12.3', '12-03', 'osoby.php', 0, 1, '12-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(15, 12, 'Kolory nazwane HTML', 4, '12.4', '12-04', 'kolory-html.php', 0, 1, '12-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(16, 12, 'Owoce', 5, '12.5', '12-05', 'owoce.php', 1, 1, '12-05');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(17, 12, 'Warzywa', 6, '12.6', '12-06', 'warzywa.php', 0, 1, '12-06');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(18, 12, 'Miłosierdzie gminy', 7, '12.7', '12-07', 'milosierdzie-gminy.php', 0, 1, '12-07');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(19, 13, '140 kolorów CSS', 1, '13.1', '13-01', '140-kolory-css.php', 0, 1, '13-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(20, 13, 'Nagrody Nobla', 2, '13.2', '13-02', 'nagrodynobla.php', 0, 1, '13-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(21, 13, 'Dzieła literatury światowej', 3, '13.3', '13-03', 'dziela_literatury_swiatowej.php', 0, 1, '13-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(22, 13, 'Flagi', 4, '13.4', '13-04', 'flagi.php', 0, 1, '13-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(23, 13, 'Autorytety informatyki', 5, '13.5', '13-05', 'i.php', 0, 1, '13-05');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(24, 13, 'Polskie wyprawy badawcze', 6, '13.6', '13-06', 'wyprawy.php', 0, 1, '13-06');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(25, 13, 'Z historii techniki', 7, '13.7', '13-07', 'zht.php', 0, 1, '13-07');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(26, 13, 'Odkrycia geograficzne', 8, '13.8', '13-08', 'geo.php', 0, 1, '13-08');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(27, 13, 'Przemówienia', 9, '13.9', '13-09', 'przemowienie.php', 0, 1, '13-09');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(28, 13, 'Filmy i aktorzy', 10, '13.10', '13-10', 'filmy.php', 0, 1, '13-10');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(29, 13, 'Język LOGO &mdash; ściągawka', 11, '13.11', '13-11', 'logo.php', 0, 1, '13-11');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(30, 14, 'Korona Ziem', 1, '14.1', '14-01', 'korona-ziemi.php', 0, 1, '14-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(31, 14, 'Zestawienie publikacji', 2, '14.2', '14-02', 'publikacje-www.php', 0, 1, '14-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(32, 14, 'Najdłuższe rzeki świata', 3, '14.3', '14-03', 'rzeki.php', 0, 1, '14-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(33, 14, 'Sprawdzanie struktury pliku', 4, '14.4', '14-04', 'sprawdzanie.php', 0, 1, '14-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(34, 14, 'Tabela miniatur', 5, '14.5', '14-05', 'tabela-miniatur.php', 0, 1, '14-05');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(35, 14, 'Imiona', 6, '14.6', '14-06', 'imiona.php', 0, 1, '14-06');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(36, 14, 'Alfabet', 7, '14.7', '14-07', 'alfabet.php', 0, 1, '14-07');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(37, 14, 'Rozdziobią nas kruki, wrony', 8, '14.8', '14-08', 'nowela.php', 0, 1, '14-08');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(38, 15, 'Kody polskich liter', 1, '15.1', '15-01', '', 0, 0, '15-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(39, 15, 'Kolędy', 2, '15.2', '15-02', 'koledy.html', 0, 1, '15-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(40, 15, 'Generator danych osobowych', 3, '15.3', '15-03', '', 0, 0, '15-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(41, 15, 'Transponowanie danych', 4, '15.4', '15-04', '', 0, 0, '15-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(42, 15, 'Modyfikacja kolejności kolumn, porządku i separatora', 5, '15.5', '15-05', '', 0, 0, '15-05');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(43, 15, 'Cyrylica', 6, '15.6', '15-06', 'tekst-out.html', 0, 1, '15-06');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(44, 15, 'Pobieranie powieści Krzyżacy', 7, '15.7', '15-07', '', 0, 0, '15-07');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(45, 16, 'Encje HTML', 1, '16.1', '16-01', 'encje-html.php', 0, 1, '16-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(46, 16, 'Podział nazwisk na męskie i żeńskie', 2, '16.2', '16-02', '', 0, 0, '16-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(47, 16, 'Podział powieści na akapity', 3, '16.3', '16-03', '', 0, 0, '16-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(48, 16, 'Jack London: Martin Eden &mdash; format HTML', 4, '16.4', '16-04', 'html-me.php', 0, 1, '16-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(49, 16, 'Jack London: Martin Eden &mdash; format LaTeX', 5, '16.5', '16-05', 'tex/me.pdf', 0, 1, '16-05');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(50, 17, 'Lista plików', 1, '17.1', '17-01', 'lista-plikow.php', 0, 1, '17-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(51, 17, 'Tworzenie indeksu wierszy', 2, '17.2', '17-02', '', 0, 0, '17-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(52, 17, 'Wiersze Tadeusza Różewicza', 3, '17.3', '17-03', 'wiersze.php', 0, 1, '17-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(53, 17, 'Tabela miniaturowych hiperłączy', 4, '17.4', '17-04', 'index.php', 0, 1, '17-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(54, 17, 'Rekurencyjna konwersja kodowania w podfolderach', 5, '17.5', '17-05', '', 0, 0, '17-05');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(55, 18, 'Adam Mickiewicz: Pan Tadeusz', 1, '18.1', '18-01', 'pan-tadeusz.html', 0, 1, '18-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(56, 18, 'Adam Mickiewicz: Pani Twardowska', 2, '18.2', '18-02', 'pani-twardowska.html', 0, 1, '18-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(57, 18, 'Jane Austen: Emma', 3, '18.3', '18-03', 'emma.html', 0, 1, '18-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(58, 18, 'Fraszki', 4, '18.4', '18-04', 'html/do-goscia.html', 0, 1, '18-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(59, 18, 'Spis treści h3/h4', 5, '18.5', '18-05', 'new/a01.html', 0, 1, '18-05');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(60, 18, 'Zmiana nazw plików: numeracja', 6, '18.6', '18-06', '', 0, 0, '18-06');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(61, 18, 'Zmiana nazw plików na podstawie treści', 7, '18.7', '18-07', '', 0, 0, '18-07');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(62, 19, 'Opowiadania Edgara Alana Poe', 1, '19.1', '19-01', 'index.php', 0, 1, '19-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(63, 19, 'Tabela ekstraklasy 2006-2007', 2, '19.2', '19-02', 'ekstraklasa.php', 0, 1, '19-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(64, 19, 'Kalkulator', 3, '19.3', '19-03', 'kalkulator.php', 0, 1, '19-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(65, 19, 'Fraszki', 4, '19.4', '19-04', 'index.php', 0, 1, '19-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(66, 20, 'Piosenki Kapeli Radości Małych', 1, '20.1', '20-01', 'krm.php', 0, 1, '20-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(67, 20, 'Treny', 2, '20.2', '20-02', 'treny.php', 0, 1, '20-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(68, 20, 'Znaki drogowe', 3, '20.3', '20-03', 'index.php', 0, 1, '20-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(69, 20, 'Ćwiczenia z instalacji i konfiguracji sieci komputerowych', 4, '20.4', '20-04', 'iksk.php', 0, 1, '20-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(70, 20, 'Stronicowanie tabeli imion', 5, '20.5', '20-05', 'imiona.php', 0, 1, '20-05');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(71, 20, 'Państwa rozpoczynające się na wybraną literę', 6, '20.6', '20-06', 'panstwa.php', 0, 1, '20-06');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(72, 20, 'Test czcionek', 7, '20.7', '20-07', 'index.php', 0, 1, '20-07');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(73, 21, 'Poezja', 1, '21.1', '21-01', 'poezja.php', 0, 1, '21-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(74, 21, 'Jack London: The Call of the Wild', 2, '21.2', '21-02', 'index.php', 0, 1, '21-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(75, 21, 'Drop folder miniatur', 3, '21.3', '21-03', 'index.php', 0, 1, '21-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(76, 21, 'Ligi europejskie', 4, '21.4', '21-04', 'ligi.php', 0, 1, '21-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(77, 22, 'Smarty &mdash; pierwszy skrypt', 1, '22.1', '22-01', 'index.php', 0, 1, '22-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(78, 22, 'Wymiana zmiennych w szablonie', 2, '22.2', '22-02', 'index.php', 0, 1, '22-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(79, 22, 'Lorem ipsum &mdash; test kilku modyfikatorów', 3, '22.3', '22-03', 'index.php', 0, 1, '22-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(80, 22, 'Piosenka pt. Jadą, jadą misie', 4, '22.4', '22-04', 'index.php', 0, 1, '22-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(81, 22, 'Smarty &mdash; owoce', 5, '22.5', '22-05', 'index.php', 0, 1, '22-05');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(82, 22, 'Angielskie czasowniki nieregularne', 6, '22.6', '22-06', 'index.php', 0, 1, '22-06');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(83, 22, 'Tatry', 7, '22.7', '22-07', 'index.php', 0, 1, '22-07');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(84, 22, 'Kody polskich znaków', 8, '22.8', '22-08', 'index.php', 0, 1, '22-08');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(85, 22, 'Mecze ekstraklasy w sezonie 2003-2004', 9, '22.9', '22-09', 'index.php', 0, 1, '22-09');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(86, 22, 'Henryk Sienkiewicz: Sachem', 10, '22.10', '22-10', 'index.php', 0, 1, '22-10');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(87, 22, 'Maria Konopnicka: Nasza szkapa', 11, '22.11', '22-11', 'nasza-szkapa.html', 0, 1, '22-11');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(88, 23, 'Powieści Agathy Christie', 1, '23.1', '23-01', 'index.php', 0, 1, '23-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(89, 23, 'Ogonki DE, FR, PL, RU', 2, '23.2', '23-02', 'index.php', 0, 1, '23-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(90, 23, 'Fraszki', 3, '23.3', '23-03', 'index.php', 0, 1, '23-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(91, 23, 'Liczba mnoga rzeczowników angielskich', 4, '23.4', '23-04', 'index.php', 0, 1, '23-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(92, 23, 'Sortowanie danych względem kilku kolumn', 5, '23.5', '23-05', 'sortuj.php', 0, 1, '23-05');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(93, 23, 'Fotogaleria', 6, '23.6', '23-06', 'index.php', 0, 1, '23-06');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(94, 23, 'Witryna GIMP w zastosowaniach', 7, '23.7', '23-07', 'index.php', 0, 1, '23-07');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(95, 24, 'Przekazanie zmiennych do szablonu', 1, '24.1', '24-01', 'index.php', 0, 1, '24-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(96, 24, 'Modyfikatory zmiennych', 2, '24.2', '24-02', 'index.php', 0, 1, '24-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(97, 24, 'Iteracyjne przetwarzanie tablic', 3, '24.3', '24-03', 'index.php', 0, 1, '24-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(98, 24, 'Instrukcja if', 4, '24.4', '24-04', 'index.php', 0, 1, '24-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(99, 24, 'Maria Konopnicka: Nasza szkapa', 5, '24.5', '24-05', 'nasza-szkapa.html', 0, 1, '24-05');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(100, 25, 'Układy cyfrowe &mdash; szablony Smarty', 1, '25.1', '25-01', 'index.php', 0, 1, '25-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(101, 25, 'Układy cyfrowe &mdash; szablony PHP', 2, '25.2', '25-02', 'index.php', 0, 1, '25-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(102, 25, 'Zbiór zadań z C++ &mdash; szablony Smarty', 3, '25.3', '25-03', 'index.php', 0, 1, '25-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(103, 25, 'Zbiór zadań z C++ &mdash; szablony PHP', 4, '25.4', '25-04', 'index.php', 0, 1, '25-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(104, 26, 'Baza danych wyrazy', 1, '26.1', '26-01', '', 0, 0, '26-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(105, 26, 'Wypełnianie bazy samochody', 2, '26.2', '26-02', '', 0, 0, '26-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(106, 26, 'Wypełnianie bazy danych z wykorzystaniem Smarty', 3, '26.3', '26-03', '', 0, 0, '26-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(107, 27, 'Wojewodztwa', 1, '27.1', '27-01', '', 0, 0, '27-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(108, 27, 'Imiona', 2, '27.2', '27-02', '', 0, 0, '27-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(109, 28, 'Wizualny projekt bazy danych wyrazy', 1, '28.1', '28-01', '', 0, 0, '28-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(110, 28, 'Państwa-miasta: identyfikująca relacja 1:n', 2, '28.2', '28-02', '', 0, 0, '28-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(111, 28, 'Książka-kategoria: nieidentyfikująca relacja 1:n', 3, '28.3', '28-03', '', 0, 0, '28-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(112, 28, 'Filmy-aktorzy: relacja n:m', 4, '28.4', '28-04', '', 0, 0, '28-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(113, 29, 'Imiona', 1, '29.1', '29-01', '5-wydruk-zawartosci-bazy/index.php', 0, 1, '29-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(114, 29, 'Filmy', 2, '29.2', '29-02', '5-wydruk-zawartosci-bazy/index.php', 0, 1, '29-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(115, 30, 'Imiona', 1, '30.1', '30-01', '5-wydruk-zawartosci-bazy/index.php', 0, 1, '30-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(116, 30, 'Filmy', 2, '30.2', '30-02', '5-wydruk-zawartosci-bazy/index.php', 0, 1, '30-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(117, 31, 'Imiona', 1, '31.1', '31-01', '6-wydruk-zawartosci-bazy/index.php', 0, 1, '31-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(118, 31, 'Filmy', 2, '31.2', '31-02', '6-wydruk-zawartosci-bazy/index.php', 0, 1, '31-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(119, 32, 'Piosenki', 1, '32.1', '32-01', '7-aplikacja-mvc/index.php', 0, 1, '32-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(120, 32, 'Poezja', 2, '32.2', '32-02', '7-aplikacja-mvc/index.php', 0, 1, '32-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(121, 32, 'Filmy', 3, '32.3', '32-03', '7-aplikacja-mvc/index.php', 0, 1, '32-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(122, 33, 'db-frame-tool', 1, '33.1', '33-01', '', 0, 0, '33-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(123, 33, 'Aplikacja kluby piłkarskie', 2, '33.2', '33-02', '4-app/index.php', 0, 1, '33-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(124, 34, 'Katalog płyt winylowych &mdash; implementacja bez wykorzystania programowania obiektowego', 1, '34.1', '34-01', '4-app/index.php', 0, 1, '34-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(125, 34, 'Katalog płyt winylowych &mdash; implementacja obiektowa', 2, '34.2', '34-02', '4-app/index.php', 0, 1, '34-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(126, 34, 'Kluby piłkarskie &mdash; kontroler obiektowy', 3, '34.3', '34-03', '4-app/index.php', 0, 1, '34-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(127, 35, 'Powieści A. Christie', 1, '35.1', '35-01', '4-app/index.php', 0, 1, '35-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(128, 35, 'Katalog płyt winylowych', 2, '35.2', '35-02', '4-app/index.php', 0, 1, '35-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(129, 35, 'Układy cyfrowe', 3, '35.3', '35-03', '5-app/index.php', 0, 1, '35-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(130, 35, 'Kontynenty, państwa i flagi', 4, '35.4', '35-04', '4-app/index.php', 0, 1, '35-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(131, 36, 'Translacja adresu adres.html na index.php', 1, '36.1', '36-01', 'adres.html', 0, 1, '36-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(132, 36, 'Wykluczanie adresu index.php', 2, '36.2', '36-02', 'adres.html', 0, 1, '36-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(133, 36, 'Ustalanie zmiennych URL na podstawie fragmentu adresu', 3, '36.3', '36-03', 'adres-lorem.html', 0, 1, '36-03');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(134, 36, 'Eliminacja adresów o rozszerzeniu .php w projekcie 36.3', 4, '36.4', '36-04', 'adres-ipsum.html', 0, 1, '36-04');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(135, 36, 'Kolędy', 5, '36.5', '36-05', 'a-wczora-z-wieczora.html', 0, 1, '36-05');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(136, 36, 'Kolędy &mdash; wykluczanie adresów .php', 6, '36.6', '36-06', 'a-wczora-z-wieczora.html', 0, 1, '36-06');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(137, 36, 'Kolędy &mdash; generowanie pliku .htaccess', 7, '36.7', '36-07', 'skrypt/a-wczora-z-wieczora.html', 0, 1, '36-07');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(138, 37, 'HTML, XHTML i CSS. Praktyczne projekty', 1, '37.1', '37-01', '4-app/index.php', 0, 1, '37-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(139, 37, 'HTML, XHTML i CSS. Praktyczne projekty &mdash; rozwiązanie wzbogacone o obsługę przyjaznych URL-i', 2, '37.2', '37-02', '2-app-friendly-url/index.html', 0, 1, '37-02');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(140, 38, 'Ptaki', 1, '38.1', '38-01', '4-app/index.html', 0, 1, '38-01');
INSERT INTO `projekt` (`projekt_id`, `rozdzial_id`, `tytul`, `numer`, `numerpelny`, `folder`, `plik`, `dane`, `preview`, `slug`) VALUES(141, 38, 'Mundial', 2, '38.2', '38-02', '4-app-routing/index.html', 0, 1, '38-02');

--
-- Zrzut danych tabeli `rozdzial`
--

INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(1, 1, 'Pierwszy skrypt', 1, '01');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(2, 1, 'Podstawy języka PHP', 2, '02');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(3, 1, 'Instrukcje wyjściowe i napisy', 3, '03');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(4, 1, 'Stałe, zmienne, wyrażenia i operatory', 4, '04');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(5, 1, 'Instrukcje sterujące', 5, '05');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(6, 1, 'Funkcje w PHP', 6, '06');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(7, 1, 'Programowanie obiektowe', 7, '07');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(8, 1, 'Podział skryptu na wiele plików', 8, '08');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(9, 1, 'Formatowanie kodu PHP', 9, '09');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(10, 2, 'Generowanie kodu HTML', 10, '10');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(11, 2, 'Przetwarzanie napisów', 11, '11');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(12, 2, 'Podstawy przetwarzania tablic', 12, '12');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(13, 2, 'Krojenie plików tekstowych', 13, '13');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(14, 2, 'Biblioteki funkcji', 14, '14');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(15, 2, 'Tworzenie plików', 15, '15');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(16, 2, 'Wyrażenia regularne', 16, '16');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(17, 2, 'Wyszukiwanie plików', 17, '17');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(18, 2, 'Przetwarzanie wsadowe', 18, '18');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(19, 3, 'Wybór podstrony serwisu', 19, '19');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(20, 3, 'Walidacja zmiennych URL', 20, '20');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(21, 3, 'Stosowanie kilku zmiennych URL', 21, '21');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(22, 4, 'Szablony Smarty', 22, '22');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(23, 4, 'Pliki tekstowe, zmienne URL i szablony Smarty', 23, '23');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(24, 4, 'Szablony PHP', 24, '24');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(25, 4, 'Szablony Smarty i szablony PHP &mdash; porównanie', 25, '25');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(26, 5, 'Wsadowe tworzenie baz danych', 26, '26');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(27, 5, 'phpMyAdmin &mdash; narzędzie do edycji i analizy zawartości baz danych', 27, '27');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(28, 5, 'Wizualne projektowanie baz danych w MySQL Workbench', 28, '28');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(29, 6, 'Funkcje mysql_xxx', 29, '29');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(30, 6, 'PDO', 30, '30');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(31, 6, 'Propel', 31, '31');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(32, 7, 'Jednowymiarowy kontroler MVC', 32, '32');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(33, 7, 'db-frame-tool. Skrytpy ułatwiające uruchamianie generatora Propel', 33, '33');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(34, 7, 'Obiektowa implementacja kontrolera jednowymiarowego', 34, '34');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(35, 7, 'Moduł/akcja, czyli kontroler dwuwymiarowy', 35, '35');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(36, 8, 'Moduł mod_rewrite', 36, '36');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(37, 8, 'Wzbogacanie aplikacji o obsługę przyjaznych URL-i', 37, '37');
INSERT INTO `rozdzial` (`rozdzial_id`, `czesc_id`, `tytul`, `numer`, `slug`) VALUES(38, 8, 'Routing przyjaznych adresów URL', 38, '38');

SET FOREIGN_KEY_CHECKS=1;
