<?php

require_once 'search-files.inc.php';



function get_file_list()
{
    $plks = search_files(BASE_PATH, '/\.svg$/');
    $plksc = count($plks);
    for ($i = 0; $i < $plksc; $i++) {
        $plks[$i] = str_replace(BASE_PATH, '', $plks[$i]);
    }
    
    return $plks;
}




function parse_filename($path)
{
    return array(
        'filename' => basename($path, ".svg"),
        'dir' => dirname($path),
        'folders' => explode('/', dirname($path))
    );
}


function parse_txt_file($contents)
{
    $re = '/Keywords:([a-z\s]+)/is';
    if (preg_match($re, $contents, $m)) {
        $el = explode("\n", trim($m[1]));
        $elc = count($el);
        for ($i = 0; $i < $elc; $i++) {
            $el[$i] = trim($el[$i]);
        }
        return $el;
    } else {
        return array();;
    }
}



