<?php


/**
 * This class adds structure of 'kurs' table to 'kursywalut' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    kursywalut.map
 */
class KursMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'kursywalut.map.KursMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(KursPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(KursPeer::TABLE_NAME);
		$tMap->setPhpName('Kurs');
		$tMap->setClassname('Kurs');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('KURS_ID', 'KursId', 'INTEGER', true, null);

		$tMap->addColumn('KURSSREDNI', 'Kurssredni', 'FLOAT', false, null);

		$tMap->addForeignKey('WALUTA_ID', 'WalutaId', 'INTEGER', 'waluta', 'WALUTA_ID', false, null);

		$tMap->addForeignKey('TABELA_ID', 'TabelaId', 'INTEGER', 'tabela', 'TABELA_ID', false, null);

	} // doBuild()

} // KursMapBuilder
