﻿using Microsoft.Extensions.Localization; // IStringLocalizer, LocalizedString

public class PacktResources
{
  private readonly IStringLocalizer<PacktResources> localizer = null!;

  public PacktResources(IStringLocalizer<PacktResources> localizer)
  {
    this.localizer = localizer;
  }

  public string? GetEnterYourNamePrompt()
  {
    string resourceStringName = "EnterYourName";

    // 1. Uzyskanie obiektu LocalizedString.
    LocalizedString localizedString = localizer[resourceStringName];

    // 2. Sprawdzenie, czy ciąg zasobów istnieje.
    if (localizedString.ResourceNotFound)
    {
      ConsoleColor previousColor = ForegroundColor;
      ForegroundColor = ConsoleColor.Red;
      WriteLine($"Błąd: nie znaleziono ciągu zasobów \"{resourceStringName}\"."
        + Environment.NewLine
        + $"Ścieżka wyszukiwania: {localizedString.SearchedLocation}");
      ForegroundColor = previousColor;

      return $"{localizedString}: ";
    }

    // 3. Zwrócenie znalezionego ciągu zasobów.
    return localizedString;
  }

  public string? GetEnterYourDobPrompt()
  {
    // Obiekt LocalizedString jest niejawnie rzutowany na ciąg znaków,
    // który jest traktowany jako klucz, jeżeli ciąg zasobów nie zostanie znaleziony.
    return localizer["EnterYourDob"];
  }

  public string? GetEnterYourSalaryPrompt()
  {
    return localizer["EnterYourSalary"];
  }

  public string? GetPersonDetails(
    string name, DateTime dob, int minutes, decimal salary)
  {
    return localizer["PersonDetails", name, dob, minutes, salary];
  }
}
