﻿using System.Diagnostics; // Stopwatch

OutputThreadInfo();
Stopwatch timer = Stopwatch.StartNew();

SectionTitle("Synchroniczne wywołanie metod w jednym wątku."); 
MethodA();
MethodB();
MethodC();

WriteLine($"Czas działania: {timer.ElapsedMilliseconds:# ##0} ms.");

SectionTitle("Asynchroniczne wywołanie metod w kilku wątkach."); 
timer.Restart();

Task taskA = new(MethodA);
taskA.Start();
Task taskB = Task.Factory.StartNew(MethodB);
Task taskC = Task.Run(MethodC);

Task[] tasks = { taskA, taskB, taskC };
Task.WaitAll(tasks);

WriteLine($"Czas działania: {timer.ElapsedMilliseconds:# ##0} ms.");

SectionTitle("Przekazanie wyniku jednego zadania na wejście innego.");
timer.Restart();

Task<string> taskServiceThenSProc = Task.Factory
  .StartNew(CallWebService) // Zwraca wynik typu Task<decimal>.
  .ContinueWith(previousTask => // Zwraca wynik typu Task<string>.
    CallStoredProcedure(previousTask.Result));

WriteLine($"Wynik: {taskServiceThenSProc.Result}");

WriteLine($"Czas działania: {timer.ElapsedMilliseconds:# ##0} ms.");

SectionTitle("Zadania zagnieżdżone i podrzędne");

Task outerTask = Task.Factory.StartNew(OuterMethod);
outerTask.Wait();
WriteLine("Zakończenie działania aplikacji.");
