﻿using System.Diagnostics; // Stopwatch

using static System.Diagnostics.Process; // GetCurrentProcess()

namespace Packt.Shared;

public static class Recorder
{
  private static Stopwatch timer = new();

  private static long bytesPhysicalBefore = 0;
  private static long bytesVirtualBefore = 0;

  public static void Start()
  {
    // Jawne uporządkowanie pamięci w celu usunięcia obiektów, które nie są już używane.
    GC.Collect();
    GC.WaitForPendingFinalizers();
    GC.Collect();
    GC.WaitForPendingFinalizers();
    GC.Collect();

    // Zapisanie bieżącego wykorzystania pamięci wirtualnej i fizycznej.
    bytesPhysicalBefore = GetCurrentProcess().WorkingSet64;
    bytesVirtualBefore = GetCurrentProcess().VirtualMemorySize64;

    timer.Restart();
  }

  public static void Stop()
  {
    timer.Stop();

    long bytesPhysicalAfter =
      GetCurrentProcess().WorkingSet64;

    long bytesVirtualAfter =
      GetCurrentProcess().VirtualMemorySize64;

    WriteLine("Liczba zajętych bajtów pamięci fizycznej: {0:N0}.",
      bytesPhysicalAfter - bytesPhysicalBefore);

    WriteLine("Liczba zajętych bajtów pamięci wirtualnej: {0:N0}.",
      bytesVirtualAfter - bytesVirtualBefore);

    WriteLine("Czas działania: {0}.", timer.Elapsed);

    WriteLine("Czas działania w milisekundach: {0:N0}.",
      timer.ElapsedMilliseconds);
  }
}
