﻿using CommunityToolkit.Mvvm.Input; // [RelayCommand]
using System.Collections.ObjectModel; // ObservableCollection<T>
using System.Net.Http.Headers; // MediaTypeWithQualityHeaderValue
using System.Net.Http.Json; // ReadFromJsonAsync<T>

namespace Northwind.Maui.Blazor.Client.Views.Categories;

internal partial class CategoriesViewModel : ObservableCollection<Category>
{
  // Poniższe właściwości nie muszą być powiązane dwukierunkowo,
  // ponieważ są im programowo przypisywane wartości do wyświetlenia na ekranie.

  public string InfoMessage { get; set; } = string.Empty;

  public string ErrorMessage { get; set; } = string.Empty;

  public bool ErrorMessageVisible { get; set; }

  public CategoriesViewModel()
  {
    try
    {
      HttpClient client = new()
      {
        BaseAddress = new Uri(
          DeviceInfo.Platform == DevicePlatform.Android ?
          "http://10.0.2.2:5192" : "http://localhost:5192")
      };

      InfoMessage = $"BaseAddress: {client.BaseAddress}.";
      
      client.DefaultRequestHeaders.Accept.Add(
        new MediaTypeWithQualityHeaderValue("application/json"));

      HttpResponseMessage response = client
        .GetAsync("api/categories").Result;

      response.EnsureSuccessStatusCode();

      IEnumerable<Category> categories =
        response.Content.ReadFromJsonAsync
        <IEnumerable<Category>>().Result;

      foreach (Category category in categories)
      {
        int offset = 78; // Pominięcie nagłówka OLE header.

        category.Picture = category.Picture.AsSpan(
          offset, category.Picture.Length - offset).ToArray();

        category.PicturePath = $"category{category.CategoryId}_small.jpeg";

        Add(category);
      }

      InfoMessage += $"Liczba odczytanych kategorii: {Count}.";
    }
    catch (Exception ex)
    {
      ErrorMessage = ex.Message;
      ErrorMessageVisible = true;
    }
  }

  [RelayCommand]
  private void AddCategoryToFavorites()
  {
    Console.WriteLine("Dodanie kategorii do ulubionych.");
  }

  [RelayCommand]
  private void DeleteCategory()
  {
    Console.WriteLine("Usunięcie kategorii.");
  }
}
