﻿using System.Security.Cryptography; // CryptographicException
using Packt.Shared; // Protector

Write("Wpisz komunikat, który chcesz zaszyfrować: "); 
string? message = ReadLine();

Write("Podaj hasło: "); 
string? password = ReadLine();

if ((password is null) || (message is null))
{
  WriteLine("Komunikat i hasło nie mogą być puste.");
  return;
}

string cipherText = Protector.Encrypt(message, password); 

WriteLine($"Zaszyfrowany komunikat: {cipherText}");

Write("Podaj hasło: "); 
string? password2Decrypt = ReadLine();

if (password2Decrypt is null)
{
 WriteLine("Hasło nie może być puste.");
 return;
}

try
{
  string clearText = Protector.Decrypt(cipherText, password2Decrypt); 
  WriteLine($"Odszyfrowany komunikat: {clearText}");
}
catch (CryptographicException)
{
  WriteLine("Błędne hasło!");
}
catch (Exception ex)
{
  WriteLine("Wyjątek niekryptograficzny: {0}, {1}",
    arg0: ex.GetType().Name,
    arg1: ex.Message);
}
