﻿using Microsoft.Data.SqlClient; // SqlConnectionStringBuilder
using Microsoft.EntityFrameworkCore; // ToQueryString, GetConnectionString
using Northwind.Console.EFCore.Models; // NorthwindDb

SqlConnectionStringBuilder builder = new();

builder.InitialCatalog = "Northwind";
builder.MultipleActiveResultSets = true;
builder.Encrypt = true;
builder.TrustServerCertificate = true;
builder.ConnectTimeout = 10;

WriteLine("Połączenie z bazą:");
WriteLine("  1 - SQL Server na lokalnym komputerze");
WriteLine("  2 - Azure SQL Database");
WriteLine("  3 - Azure SQL Edge");
WriteLine();
Write("Wybierz opcję: ");

ConsoleKey key = ReadKey().Key;
WriteLine(); WriteLine();

if (key is ConsoleKey.D1 or ConsoleKey.NumPad1)
{
  builder.DataSource = "."; // Lokalna baza SQL Server
  // @".\net7book"; // Lokalna baza SQL Server z nazwą instancji
}
else if (key is ConsoleKey.D2 or ConsoleKey.NumPad2)
{
  builder.DataSource = // Azure SQL Database
    "tcp:apps-services-net7.database.windows.net,1433";
}
else if (key is ConsoleKey.D3 or ConsoleKey.NumPad3)
{
  builder.DataSource = "tcp:127.0.0.1,1433"; // Azure SQL Edge
}
else
{
  WriteLine("Nie wybrałeś bazy.");
  return;
}

WriteLine("Metoda uwierzytelnienia:");
WriteLine("  1 - Windows Authentication");
WriteLine("  2 - przy użyciu konta, np. sa");
WriteLine();
Write("Wybierz opcję: ");

key = ReadKey().Key;
WriteLine(); WriteLine();

if (key is ConsoleKey.D1 or ConsoleKey.NumPad1)
{
  builder.IntegratedSecurity = true;
}
else if (key is ConsoleKey.D2 or ConsoleKey.NumPad2)
{
  builder.UserID = "sa"; // Azure SQL Edge
                         // "markjprice"; // Wpisz nazwę swojego konta

  Write("Podaj hasło: ");
  string? password = ReadLine();
  if (string.IsNullOrWhiteSpace(password))
  {
    WriteLine("Hasło nie może być puste.");
    return;
  }

  builder.Password = password;
  builder.PersistSecurityInfo = false;
}
else
{
  WriteLine("Nie wybrałeś metody uwierzytelnienia.");
  return;
}

DbContextOptionsBuilder<NorthwindDb> options = new();
options.UseSqlServer(builder.ConnectionString);

using (NorthwindDb db = new(options.Options))
{
  Write("Podaj cenę: ");
  string? priceText = ReadLine();

  if (!decimal.TryParse(priceText, out decimal price))
  {
    WriteLine("Podałeś błędną cenę.");
    return;
  }

  // Instrukcja var jest konieczna, ponieważ rzutujemy na typ anonimowy.
  var products = db.Products
    .Where(p => p.UnitPrice > price)
    .Select(p => new { p.ProductId, p.ProductName, p.UnitPrice });

  WriteLine("----------------------------------------------------------");
  WriteLine("| {0,5} | {1,-35} | {2,8} |", "Id", "Nazwa", "Cena");
  WriteLine("----------------------------------------------------------");

  foreach (var p in products)
  {
    WriteLine("| {0,5} | {1,-35} | {2,8:C} |",
      p.ProductId, p.ProductName, p.UnitPrice);
  }

  WriteLine("----------------------------------------------------------");

  WriteLine(products.ToQueryString());
  WriteLine();
  WriteLine($"Dostawca:   {db.Database.ProviderName}");
  WriteLine($"Połączenie: {db.Database.GetConnectionString()}");
}
