﻿using NCrontab;

DateTime start = new(2023, 1, 1);
DateTime end = start.AddYears(1);

WriteLine($"Początek:   {start:ddd, dd MMM yyyy HH:mm:ss}");
WriteLine($"Koniec:     {end:ddd, dd MMM yyyy HH:mm:ss}");
WriteLine();

string sec = "0";
string min = "0";
string hour = "*/4";
string dayOfMonth = "*";
string month = "*";
string dayOfWeek = "*";

string expression = string.Format(
  "{0,-3} {1,-3} {2,-3} {3,-3} {4,-3} {5,-3}",
  sec, min, hour, dayOfMonth, month, dayOfWeek);

CrontabSchedule schedule = CrontabSchedule.Parse(expression,
  new CrontabSchedule.ParseOptions { IncludingSeconds = true });

WriteLine($"Wyrażenie: {expression}");
WriteLine(@"           \ / \ / \ / \ / \ / \ /");
WriteLine($"            -   -   -   -   -   -");
WriteLine($"            |   |   |   |   |   |");
WriteLine($"            |   |   |   |   |   +--- dzień tygodnia (0 - 6, niedziela=0)");
WriteLine($"            |   |   |   |   +------- miesiąc (1 - 12)");
WriteLine($"            |   |   |   +----------- dzień miesiąca (1 - 31)");
WriteLine($"            |   |   +--------------- godziny (0 - 23)");
WriteLine($"            |   +------------------- minuty (0 - 59)");
WriteLine($"            +----------------------- sekundy (0 - 59)");
WriteLine();

IEnumerable<DateTime> occurrences = schedule.GetNextOccurrences(start, end);

// Wyświetlenie 40 pierwszych zdarzeń.
foreach (DateTime occurrence in occurrences.Take(40))
{
  WriteLine($"{occurrence:ddd, dd MMM yyyy HH:mm:ss}");
}
