﻿partial class Program
{
  static void OutputCultures(string title)
  {
    ConsoleColor previousColor = ForegroundColor;
    ForegroundColor = ConsoleColor.DarkYellow;

    WriteLine("*");
    WriteLine($"* {title}");
    WriteLine("*");

    // get the cultures from the current thread
    CultureInfo globalization = CultureInfo.CurrentCulture;
    CultureInfo localization = CultureInfo.CurrentUICulture;

    WriteLine("Bieżąca kultura globalizacyjna: {0}, {1}",
      globalization.Name, globalization.DisplayName);

    WriteLine("Bieżąca kultura lokalizacyjna: {0}, {1}",
      localization.Name, localization.DisplayName);

    WriteLine("Dni tygodnia: {0}",
      string.Join(", ", globalization.DateTimeFormat.DayNames));

    WriteLine("Miesiące: {0}",
      string.Join(", ", globalization.DateTimeFormat.MonthNames
        // Niektóre kalendarze mają 13 miesięcy, większość jednak 12, przy czym ostatni jest pusty.
        .TakeWhile(month => !string.IsNullOrEmpty(month))));

    WriteLine("Pierwszy dzień tego roku: {0}", 
      new DateTime(year: DateTime.Today.Year, month: 1, day: 1)
      .ToString("D", globalization));

    WriteLine("Separator grup liczb: {0}",
      globalization.NumberFormat.NumberGroupSeparator);

    WriteLine("Symbol dziesiętny: {0}",
      globalization.NumberFormat.NumberDecimalSeparator);
    
    RegionInfo region = new RegionInfo(globalization.LCID);

    WriteLine("Symbol waluty: {0}", region.CurrencySymbol);

    WriteLine("Nazwa waluty: {0} ({1})",
      region.CurrencyNativeName, region.CurrencyEnglishName);

    WriteLine("IsMetric: {0}", region.IsMetric);

    WriteLine();

    ForegroundColor = previousColor;
  }
}
