﻿using System.Collections.ObjectModel; // ReadOnlyCollection<T>

partial class Program
{
  static void SectionTitle(string title)
  {
    ConsoleColor previousColor = ForegroundColor;
    ForegroundColor = ConsoleColor.DarkYellow;
    WriteLine("*");
    WriteLine($"* {title}");
    WriteLine("*");
    ForegroundColor = previousColor;
  }

  static void OutputTimeZones()
  {
    // Odczytanie stref czasowych zarejestrowanych w systemie operacyjnym.
    ReadOnlyCollection<TimeZoneInfo> zones = 
      TimeZoneInfo.GetSystemTimeZones();

    WriteLine("*");
    WriteLine($"* Liczba stref czasowych: {zones.Count}:");
    WriteLine("*");

    // Sortowanie stref czasowych według identyfikatorów, a nie nazw.
    foreach (TimeZoneInfo zone in zones.OrderBy(z => z.Id))
    {
      WriteLine($"{zone.Id}");
    }
  }

  static void OutputDateTime(DateTime dateTime, string title)
  {
    SectionTitle(title);
    WriteLine($"Wartość: {dateTime}");
    WriteLine($"Rodzaj: {dateTime.Kind}");
    WriteLine($"Czas letni: {dateTime.IsDaylightSavingTime()}");
    WriteLine($"Czas lokalny: {dateTime.ToLocalTime()}");
    WriteLine($"Czas uniwersalny: {dateTime.ToUniversalTime()}");
  }

  static void OutputTimeZone(TimeZoneInfo zone, string title)
  {
    SectionTitle(title);
    WriteLine($"Id: {zone.Id}");
    WriteLine("IsDaylightSavingTime(DateTime.Now): {0}",
      zone.IsDaylightSavingTime(DateTime.Now));
    WriteLine($"StandardName: {zone.StandardName}");
    WriteLine($"DaylightName: {zone.DaylightName}");
    WriteLine($"BaseUtcOffset: {zone.BaseUtcOffset}");
  }

  static string GetCurrentZoneName(TimeZoneInfo zone, DateTime when)
  {
    // Nazwy stref czasowych zmieniają się, jeśli aktywny jest czas letni, 
    // np. czas standardowy GMT zmienia się w czas letni GMT.
    return zone.IsDaylightSavingTime(when) ?
      zone.DaylightName : zone.StandardName;
  }
}