<?php

require "accept.php";

$data = array ("greeting" => "Cześć, ", "name" => "Lorna");

$accepted_formats = parseAcceptHeader();
$supported_formats = array("application/json", "text/html");
foreach($accepted_formats as $format) {
    if(in_array($format, $supported_formats)) {
        // użycie tego formatu
        break;
    }
}

switch($format) {
    case "application/json":
        header("Content-Type: application/json");
        $output = json_encode($data);
        break;
    case "text/html":
    default:
        $output = "<p>" . implode(',', $data) . "</p>";
        break;
}

echo $output;

