<?php

include("library.php");
$lib = new Library();

if(isset($_GET['action'])) {
    switch($_GET['action']) {
    case "getDwarves":
        $data = $lib->getDwarves();
        break;
    case "greetUser":
        $data = $lib->greetUser(
            filter_input(INPUT_GET, 'name', FILTER_SANITIZE_STRING)
        );
        break;
    default:
        // Tylko PHP 5.4+. W starszych wersjach należy używać poniższego kodu.
        http_response_code(400);

        // Dla PHP < 5.4 należy użyć poniższej linijki kodu.
        // header("Status: 400", false, 400);

        $data = array("error" => "Niepoprawne żądanie");
    }

    header("Content-Type: application/json");
    echo json_encode($data);
}

