# -*- coding: UTF-8 -*-
from django.db import models
from django.utils.translation import ugettext_lazy as _

from utils.models import CreationModificationDateMixin


class Movie(CreationModificationDateMixin):
    title = models.CharField(_("Title"), max_length=255)
    url = models.URLField(_("URL"), blank=True)
    release_year = models.PositiveIntegerField(_("Release Year"))

    def __unicode__(self):
        return self.title

    class Meta:
        verbose_name = _("Movie")
        verbose_name_plural = _("Movies")
