# -*- coding: UTF-8 -*-
from django.db import models
from django.utils.translation import ugettext_lazy as _

TYPE_CHOICES = (
    ('searching', _("Szukanie")),
    ('offering', _("Oferowanie")),
)


class Bulletin(models.Model):
    bulletin_type = models.CharField(_("Typ"), max_length=20, choices=TYPE_CHOICES)
    
    title = models.CharField(_(u"Tytuł"), max_length=255)
    description = models.TextField(_("Opis"), max_length=300)
    
    contact_person = models.CharField(_("Osoba kontaktowa"), max_length=255)
    phone = models.CharField(_("Numer telefonu"), max_length=200, blank=True)
    email = models.EmailField(_("E-mail"), blank=True)
    
    image = models.ImageField(_("Obraz"), max_length=255, upload_to="bulletin_board/", blank=True)

    class Meta:
        verbose_name = _("Biuletyn")
        verbose_name_plural = _("Biuletyny")
        ordering = ("title",)

    def __unicode__(self):
        return self.title
