# -*- coding: utf-8 -*-
from south.utils import datetime_utils as datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'Bulletin'
        db.create_table(u'bulletin_board_bulletin', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('bulletin_type', self.gf('django.db.models.fields.CharField')(max_length=20)),
            ('title', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('description', self.gf('django.db.models.fields.TextField')(max_length=300)),
            ('contact_person', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('phone', self.gf('django.db.models.fields.CharField')(max_length=200, blank=True)),
            ('email', self.gf('django.db.models.fields.EmailField')(max_length=75, blank=True)),
            ('image', self.gf('django.db.models.fields.files.ImageField')(max_length=255, blank=True)),
        ))
        db.send_create_signal(u'bulletin_board', ['Bulletin'])


    def backwards(self, orm):
        # Deleting model 'Bulletin'
        db.delete_table(u'bulletin_board_bulletin')


    models = {
        u'bulletin_board.bulletin': {
            'Meta': {'ordering': "('title',)", 'object_name': 'Bulletin'},
            'bulletin_type': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'contact_person': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'description': ('django.db.models.fields.TextField', [], {'max_length': '300'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'image': ('django.db.models.fields.files.ImageField', [], {'max_length': '255', 'blank': 'True'}),
            'phone': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        }
    }

    complete_apps = ['bulletin_board']