# -*- coding: UTF-8 -*-
from django.contrib import admin
from django.conf import settings
from models import Book


class BookAdmin(admin.ModelAdmin):
    list_display = ('title', 'author', 'description')
    list_display_links = ('title', 'author')

    fields = ['author'] +\
        ['title_%s' % lang_code for lang_code, lang_name in settings.LANGUAGES] +\
        ['description_%s' % lang_code for lang_code, lang_name in settings.LANGUAGES]

admin.site.register(Book, BookAdmin)