/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.os.Build;
import android.support.v4.view.ViewConfigurationCompatFroyo;
import android.support.v4.view.ViewConfigurationCompatICS;
import android.view.ViewConfiguration;

public final class ViewConfigurationCompat {
    static final ViewConfigurationVersionImpl IMPL = Build.VERSION.SDK_INT >= 14 ? new IcsViewConfigurationVersionImpl() : (Build.VERSION.SDK_INT >= 11 ? new HoneycombViewConfigurationVersionImpl() : (Build.VERSION.SDK_INT >= 8 ? new FroyoViewConfigurationVersionImpl() : new BaseViewConfigurationVersionImpl()));

    public static int getScaledPagingTouchSlop(ViewConfiguration config) {
        return IMPL.getScaledPagingTouchSlop(config);
    }

    public static boolean hasPermanentMenuKey(ViewConfiguration config) {
        return IMPL.hasPermanentMenuKey(config);
    }

    private ViewConfigurationCompat() {
    }

    static class IcsViewConfigurationVersionImpl
    extends HoneycombViewConfigurationVersionImpl {
        IcsViewConfigurationVersionImpl() {
        }

        @Override
        public boolean hasPermanentMenuKey(ViewConfiguration config) {
            return ViewConfigurationCompatICS.hasPermanentMenuKey((ViewConfiguration)config);
        }
    }

    static class HoneycombViewConfigurationVersionImpl
    extends FroyoViewConfigurationVersionImpl {
        HoneycombViewConfigurationVersionImpl() {
        }

        @Override
        public boolean hasPermanentMenuKey(ViewConfiguration config) {
            return false;
        }
    }

    static class FroyoViewConfigurationVersionImpl
    extends BaseViewConfigurationVersionImpl {
        FroyoViewConfigurationVersionImpl() {
        }

        @Override
        public int getScaledPagingTouchSlop(ViewConfiguration config) {
            return ViewConfigurationCompatFroyo.getScaledPagingTouchSlop((ViewConfiguration)config);
        }
    }

    static class BaseViewConfigurationVersionImpl
    implements ViewConfigurationVersionImpl {
        BaseViewConfigurationVersionImpl() {
        }

        @Override
        public int getScaledPagingTouchSlop(ViewConfiguration config) {
            return config.getScaledTouchSlop();
        }

        @Override
        public boolean hasPermanentMenuKey(ViewConfiguration config) {
            return true;
        }
    }

    static interface ViewConfigurationVersionImpl {
        public int getScaledPagingTouchSlop(ViewConfiguration var1);

        public boolean hasPermanentMenuKey(ViewConfiguration var1);
    }
}

