/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.os;

import android.os.Build;
import android.support.v4.os.CancellationSignalCompatJellybean;
import android.support.v4.os.OperationCanceledException;

public final class CancellationSignal {
    private boolean mIsCanceled;
    private OnCancelListener mOnCancelListener;
    private Object mCancellationSignalObj;
    private boolean mCancelInProgress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            return this.mIsCanceled;
        }
    }

    public void throwIfCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object obj;
        OnCancelListener listener;
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            if (this.mIsCanceled) {
                return;
            }
            this.mIsCanceled = true;
            this.mCancelInProgress = true;
            listener = this.mOnCancelListener;
            obj = this.mCancellationSignalObj;
        }
        try {
            if (listener != null) {
                listener.onCancel();
            }
            if (obj != null) {
                CancellationSignalCompatJellybean.cancel((Object)obj);
            }
        }
        finally {
            cancellationSignal = this;
            synchronized (cancellationSignal) {
                this.mCancelInProgress = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnCancelListener(OnCancelListener listener) {
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            this.waitForCancelFinishedLocked();
            if (this.mOnCancelListener == listener) {
                return;
            }
            this.mOnCancelListener = listener;
            if (!this.mIsCanceled || listener == null) {
                return;
            }
        }
        listener.onCancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCancellationSignalObject() {
        if (Build.VERSION.SDK_INT < 16) {
            return null;
        }
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            if (this.mCancellationSignalObj == null) {
                this.mCancellationSignalObj = CancellationSignalCompatJellybean.create();
                if (this.mIsCanceled) {
                    CancellationSignalCompatJellybean.cancel((Object)this.mCancellationSignalObj);
                }
            }
            return this.mCancellationSignalObj;
        }
    }

    private void waitForCancelFinishedLocked() {
        while (this.mCancelInProgress) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static interface OnCancelListener {
        public void onCancel();
    }
}

