/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.Nullable;
import android.support.design.R;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.FloatingActionButtonImpl;
import android.support.design.widget.ShadowDrawableWrapper;
import android.support.design.widget.ShadowViewDelegate;
import android.support.design.widget.StateListAnimator;
import android.support.design.widget.VisibilityAwareImageButton;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;

class FloatingActionButtonEclairMr1
extends FloatingActionButtonImpl {
    private int mAnimationDuration;
    private StateListAnimator mStateListAnimator;
    private boolean mIsHiding;
    ShadowDrawableWrapper mShadowDrawable;

    FloatingActionButtonEclairMr1(VisibilityAwareImageButton view, ShadowViewDelegate shadowViewDelegate) {
        super(view, shadowViewDelegate);
        this.mAnimationDuration = view.getResources().getInteger(0x10E0000);
        this.mStateListAnimator = new StateListAnimator();
        this.mStateListAnimator.setTarget((View)view);
        this.mStateListAnimator.addState(PRESSED_ENABLED_STATE_SET, this.setupAnimation(new ElevateToTranslationZAnimation()));
        this.mStateListAnimator.addState(FOCUSED_ENABLED_STATE_SET, this.setupAnimation(new ElevateToTranslationZAnimation()));
        this.mStateListAnimator.addState(EMPTY_STATE_SET, this.setupAnimation(new ResetElevationAnimation()));
    }

    @Override
    void setBackgroundDrawable(ColorStateList backgroundTint, PorterDuff.Mode backgroundTintMode, int rippleColor, int borderWidth) {
        Drawable[] layers;
        this.mShapeDrawable = DrawableCompat.wrap((Drawable)this.createShapeDrawable());
        DrawableCompat.setTintList((Drawable)this.mShapeDrawable, (ColorStateList)backgroundTint);
        if (backgroundTintMode != null) {
            DrawableCompat.setTintMode((Drawable)this.mShapeDrawable, (PorterDuff.Mode)backgroundTintMode);
        }
        GradientDrawable touchFeedbackShape = this.createShapeDrawable();
        this.mRippleDrawable = DrawableCompat.wrap((Drawable)touchFeedbackShape);
        DrawableCompat.setTintList((Drawable)this.mRippleDrawable, (ColorStateList)FloatingActionButtonEclairMr1.createColorStateList(rippleColor));
        if (borderWidth > 0) {
            this.mBorderDrawable = this.createBorderDrawable(borderWidth, backgroundTint);
            layers = new Drawable[]{this.mBorderDrawable, this.mShapeDrawable, this.mRippleDrawable};
        } else {
            this.mBorderDrawable = null;
            layers = new Drawable[]{this.mShapeDrawable, this.mRippleDrawable};
        }
        this.mContentBackground = new LayerDrawable(layers);
        this.mShadowDrawable = new ShadowDrawableWrapper(this.mView.getResources(), this.mContentBackground, this.mShadowViewDelegate.getRadius(), this.mElevation, this.mElevation + this.mPressedTranslationZ);
        this.mShadowDrawable.setAddPaddingForCorners(false);
        this.mShadowViewDelegate.setBackgroundDrawable((Drawable)this.mShadowDrawable);
    }

    @Override
    void setBackgroundTintList(ColorStateList tint) {
        if (this.mShapeDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.mShapeDrawable, (ColorStateList)tint);
        }
        if (this.mBorderDrawable != null) {
            this.mBorderDrawable.setBorderTint(tint);
        }
    }

    @Override
    void setBackgroundTintMode(PorterDuff.Mode tintMode) {
        if (this.mShapeDrawable != null) {
            DrawableCompat.setTintMode((Drawable)this.mShapeDrawable, (PorterDuff.Mode)tintMode);
        }
    }

    @Override
    void setRippleColor(int rippleColor) {
        if (this.mRippleDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.mRippleDrawable, (ColorStateList)FloatingActionButtonEclairMr1.createColorStateList(rippleColor));
        }
    }

    @Override
    float getElevation() {
        return this.mElevation;
    }

    @Override
    void onElevationChanged(float elevation) {
        if (this.mShadowDrawable != null) {
            this.mShadowDrawable.setShadowSize(elevation, elevation + this.mPressedTranslationZ);
            this.updatePadding();
        }
    }

    @Override
    void onTranslationZChanged(float translationZ) {
        if (this.mShadowDrawable != null) {
            this.mShadowDrawable.setMaxShadowSize(this.mElevation + translationZ);
            this.updatePadding();
        }
    }

    @Override
    void onDrawableStateChanged(int[] state) {
        this.mStateListAnimator.setState(state);
    }

    @Override
    void jumpDrawableToCurrentState() {
        this.mStateListAnimator.jumpToCurrentState();
    }

    @Override
    void hide(final @Nullable FloatingActionButtonImpl.InternalVisibilityChangedListener listener, final boolean fromUser) {
        if (this.mIsHiding || this.mView.getVisibility() != 0) {
            if (listener != null) {
                listener.onHidden();
            }
            return;
        }
        Animation anim2 = android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.design_fab_out);
        anim2.setInterpolator(AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR);
        anim2.setDuration(200L);
        anim2.setAnimationListener((Animation.AnimationListener)new AnimationUtils.AnimationListenerAdapter(){

            @Override
            public void onAnimationStart(Animation animation) {
                FloatingActionButtonEclairMr1.this.mIsHiding = true;
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                FloatingActionButtonEclairMr1.this.mIsHiding = false;
                FloatingActionButtonEclairMr1.this.mView.internalSetVisibility(8, fromUser);
                if (listener != null) {
                    listener.onHidden();
                }
            }
        });
        this.mView.startAnimation(anim2);
    }

    @Override
    void show(final @Nullable FloatingActionButtonImpl.InternalVisibilityChangedListener listener, boolean fromUser) {
        if (this.mView.getVisibility() != 0 || this.mIsHiding) {
            this.mView.clearAnimation();
            this.mView.internalSetVisibility(0, fromUser);
            Animation anim2 = android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.design_fab_in);
            anim2.setDuration(200L);
            anim2.setInterpolator(AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR);
            anim2.setAnimationListener((Animation.AnimationListener)new AnimationUtils.AnimationListenerAdapter(){

                @Override
                public void onAnimationEnd(Animation animation) {
                    if (listener != null) {
                        listener.onShown();
                    }
                }
            });
            this.mView.startAnimation(anim2);
        } else if (listener != null) {
            listener.onShown();
        }
    }

    @Override
    void onCompatShadowChanged() {
    }

    @Override
    void getPadding(Rect rect) {
        this.mShadowDrawable.getPadding(rect);
    }

    private Animation setupAnimation(Animation animation) {
        animation.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        animation.setDuration((long)this.mAnimationDuration);
        return animation;
    }

    private static ColorStateList createColorStateList(int selectedColor) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        states[i] = FOCUSED_ENABLED_STATE_SET;
        colors[i] = selectedColor;
        states[++i] = PRESSED_ENABLED_STATE_SET;
        colors[i] = selectedColor;
        states[++i] = new int[0];
        colors[i] = 0;
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private class ElevateToTranslationZAnimation
    extends BaseShadowAnimation {
        private ElevateToTranslationZAnimation() {
        }

        @Override
        protected float getTargetShadowSize() {
            return FloatingActionButtonEclairMr1.this.mElevation + FloatingActionButtonEclairMr1.this.mPressedTranslationZ;
        }
    }

    private class ResetElevationAnimation
    extends BaseShadowAnimation {
        private ResetElevationAnimation() {
        }

        @Override
        protected float getTargetShadowSize() {
            return FloatingActionButtonEclairMr1.this.mElevation;
        }
    }

    private abstract class BaseShadowAnimation
    extends Animation {
        private float mShadowSizeStart;
        private float mShadowSizeDiff;

        private BaseShadowAnimation() {
        }

        public void reset() {
            super.reset();
            this.mShadowSizeStart = FloatingActionButtonEclairMr1.this.mShadowDrawable.getShadowSize();
            this.mShadowSizeDiff = this.getTargetShadowSize() - this.mShadowSizeStart;
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            FloatingActionButtonEclairMr1.this.mShadowDrawable.setShadowSize(this.mShadowSizeStart + this.mShadowSizeDiff * interpolatedTime);
        }

        protected abstract float getTargetShadowSize();
    }
}

