package com.androidtablet.actionbartabapp;

import android.os.Bundle;
import android.app.Activity;
import android.app.ActionBar;
import android.app.ActionBar.Tab;
import android.app.FragmentTransaction;
import android.util.Log;
import android.app.FragmentManager;
import android.app.Fragment;
import android.widget.Button;
import android.view.View; 
import android.view.View.OnClickListener;
import android.content.Context;
import com.google.analytics.tracking.android.Tracker;
import com.google.analytics.tracking.android.GoogleAnalytics;

public class ActionBarTabAppActivity extends Activity  { 
    Tracker tracker;

    @Override
    public void onCreate(Bundle savedInstanceState) { 
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_action_bar_tab_app);
        Fragment createFragment = new CreateActivity();
        Fragment updateFragment = new UpdateActivity();
        ActionBar actionBar = getActionBar();
        actionBar.setNavigationMode(ActionBar.NAVIGATION_MODE_TABS);
        actionBar.setDisplayShowTitleEnabled(true); 
        ActionBar.Tab CreateTab = actionBar.newTab().setText("Utwrz"); 
        ActionBar.Tab UpdateTab = actionBar.newTab().setText("Zaktualizuj"); 
        CreateTab.setTabListener(new MyTabsListener(createFragment)); 
        UpdateTab.setTabListener(new MyTabsListener(updateFragment));
        actionBar.addTab(CreateTab); 
        actionBar.addTab(UpdateTab);
        Button startButton = (Button) findViewById(R.id.start_button); 
        startButton.setOnClickListener(new OnClickListener() { 
            @Override     
            public void onClick(View view) { 
                tracker.trackEvent("Przyciski", "Kliknicia", "Przycisk start", 0L); 
            }     
        });
        Button stopButton = (Button) findViewById(R.id.stop_button); 
        stopButton.setOnClickListener(new OnClickListener() { 
            @Override     
            public void onClick(View view) {
                tracker.trackEvent("Przyciski", "Kliknicia", "Przycisk stop", 0L); 
            }     
        });
    }  
    
    @Override 
    public void onStart() { 
        super.onStart(); 
        Context context = this; 
        GoogleAnalytics analyticsInstance = GoogleAnalytics.getInstance(context.getApplicationContext());
        analyticsInstance.setDebug(true);
        /* Wstaw poniej w metodzie getTracker() swj identyfikator ledzenia.*/
        tracker = analyticsInstance.getTracker("UA-xxxxxxxx-y");
        analyticsInstance.setDefaultTracker(tracker); 
        tracker.trackView("/CreateActivity");
        tracker.trackView("/UpdateActivity");
    } 

    @Override 
    public void onStop() { 
        super.onStop(); 
    } 
    
    protected class MyTabsListener implements  ActionBar.TabListener {
        Fragment fragment;
        
        public MyTabsListener(Fragment fragment){
            this.fragment = fragment;
        }

        public void onTabSelected(Tab tab, FragmentTransaction ft) { 
            ft.replace(R.id.fragment_container, fragment, null);    
        }

        public void onTabUnselected(Tab tab, FragmentTransaction ft) {
            ft.remove(fragment);
            getFragmentManager().popBackStack(null, FragmentManager.POP_BACK_STACK_INCLUSIVE);
        }

        public void onTabReselected(Tab tab, FragmentTransaction ft) {
            Log.d("Zakadka", String.valueOf(tab.getPosition()) + " wybrana ponownie");
        }
    }
}
