/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.google.analytics.tracking.android.Analytics;
import com.google.analytics.tracking.android.AnalyticsThread;
import com.google.analytics.tracking.android.GAServiceProxy;
import com.google.analytics.tracking.android.HitBuilder;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.MetaModel;
import com.google.analytics.tracking.android.MetaModelInitializer;
import com.google.analytics.tracking.android.ServiceProxy;
import com.google.analytics.tracking.android.StandardExceptionParser;
import com.google.analytics.tracking.android.Utils;
import com.google.android.gms.analytics.internal.Command;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

class GAThread
extends Thread
implements AnalyticsThread {
    private static final String CLIENT_VERSION = "ma1b3";
    private static final int MAX_SAMPLE_RATE = 100;
    private static final int SAMPLE_RATE_MULTIPLIER = 100;
    private static final int SAMPLE_RATE_MODULO = 10000;
    static final String API_VERSION = "1";
    private final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();
    private volatile boolean disabled = false;
    private volatile boolean closed = false;
    private volatile boolean appOptOut;
    private volatile List<Command> commands;
    private volatile MetaModel metaModel;
    private volatile String installCampaign;
    private volatile String clientId;
    private static GAThread instance;
    private final ServiceProxy proxy;
    private final Context ctx;

    static GAThread getInstance(Context ctx) {
        if (instance == null) {
            instance = new GAThread(ctx);
        }
        return instance;
    }

    private GAThread(Context ctx) {
        super("GAThread");
        this.ctx = ctx;
        this.proxy = new GAServiceProxy(ctx, this);
        this.init();
    }

    GAThread(Context ctx, ServiceProxy proxy) {
        super("GAThread");
        this.ctx = ctx;
        this.proxy = proxy;
        this.init();
    }

    private void init() {
        this.proxy.createService();
        this.commands = new ArrayList<Command>();
        this.commands.add(new Command("appendVersion", "_v", CLIENT_VERSION));
        this.commands.add(new Command("appendQueueTime", "qt", null));
        this.commands.add(new Command("appendCacheBuster", "z", null));
        this.metaModel = new MetaModel();
        MetaModelInitializer.set(this.metaModel);
        this.start();
    }

    @Override
    public void sendHit(Map<String, String> hit) {
        final HashMap<String, String> hitCopy = new HashMap<String, String>(hit);
        final long hitTime = System.currentTimeMillis();
        this.queueToThread(new Runnable(){

            @Override
            public void run() {
                if (GAThread.this.appOptOut || GAThread.this.isSampledOut(hitCopy)) {
                    return;
                }
                hitCopy.put("clientId", GAThread.this.clientId);
                if (!TextUtils.isEmpty((CharSequence)GAThread.this.installCampaign)) {
                    hitCopy.put("campaign", GAThread.this.installCampaign);
                    GAThread.this.installCampaign = null;
                }
                GAThread.this.fillAppParameters(hitCopy);
                GAThread.this.fillCampaignParameters(hitCopy);
                GAThread.this.fillExceptionParameters(hitCopy);
                Map<String, String> wireFormatParams = HitBuilder.generateHitParams(GAThread.this.metaModel, hitCopy);
                GAThread.this.proxy.putHit(wireFormatParams, hitTime, GAThread.this.getHostUrl(hitCopy), GAThread.this.commands);
            }
        });
    }

    private String getHostUrl(Map<String, String> hit) {
        String hitUrl = hit.get("internalHitUrl");
        if (hitUrl == null) {
            hitUrl = Utils.safeParseBoolean(hit.get("useSecure")) ? "https://ssl.google-analytics.com/collect" : "http://www.google-analytics.com/collect";
        }
        return hitUrl;
    }

    private void fillExceptionParameters(Map<String, String> hit) {
        Throwable exception;
        String rawExceptionString = hit.get("rawException");
        if (rawExceptionString == null) {
            return;
        }
        hit.remove("rawException");
        byte[] rawExceptionStringBytes = Utils.hexDecode(rawExceptionString);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(rawExceptionStringBytes);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteStream);
            Object readObject = objectInputStream.readObject();
            objectInputStream.close();
            if (!(readObject instanceof Throwable)) {
                return;
            }
            exception = (Throwable)readObject;
        }
        catch (IOException e) {
            Log.w("IOException reading exception");
            return;
        }
        catch (ClassNotFoundException e) {
            Log.w("ClassNotFoundException reading exception");
            return;
        }
        ArrayList<String> additionalPackages = new ArrayList<String>();
        StandardExceptionParser exceptionParser = new StandardExceptionParser(this.ctx, additionalPackages);
        hit.put("exDescription", exceptionParser.getDescription(hit.get("exceptionThreadName"), exception));
    }

    private boolean isSampledOut(Map<String, String> hit) {
        if (hit.get("sampleRate") != null) {
            String clientId;
            double sampleRate = Utils.safeParseDouble(hit.get("sampleRate"));
            if (sampleRate <= 0.0) {
                return true;
            }
            if (sampleRate < 100.0 && (clientId = hit.get("clientId")) != null && (double)(Math.abs(clientId.hashCode()) % 10000) >= sampleRate * 100.0) {
                return true;
            }
        }
        return false;
    }

    private void fillAppParameters(Map<String, String> hit) {
        PackageManager pm = this.ctx.getPackageManager();
        String appId = this.ctx.getPackageName();
        String appInstallerId = pm.getInstallerPackageName(appId);
        String appName = appId;
        String appVersion = null;
        try {
            PackageInfo packageInfo = pm.getPackageInfo(this.ctx.getPackageName(), 0);
            if (packageInfo != null) {
                appName = ((Object)pm.getApplicationLabel(packageInfo.applicationInfo)).toString();
                appVersion = packageInfo.versionName;
            }
        }
        catch (PackageManager.NameNotFoundException exception) {
            Log.e("Error retrieving package info: appName set to " + appName);
        }
        this.putIfAbsent(hit, "appName", appName);
        this.putIfAbsent(hit, "appVersion", appVersion);
        this.putIfAbsent(hit, "appId", appId);
        this.putIfAbsent(hit, "appInstallerId", appInstallerId);
        hit.put("apiVersion", API_VERSION);
    }

    private void putIfAbsent(Map<String, String> hit, String key, String value) {
        if (!hit.containsKey(key)) {
            hit.put(key, value);
        }
    }

    private void fillCampaignParameters(Map<String, String> hit) {
        String campaign = Utils.filterCampaign(hit.get("campaign"));
        if (TextUtils.isEmpty((CharSequence)campaign)) {
            return;
        }
        Map<String, String> paramsMap = Utils.parseURLParameters(campaign);
        hit.put("campaignContent", paramsMap.get("utm_content"));
        hit.put("campaignMedium", paramsMap.get("utm_medium"));
        hit.put("campaignName", paramsMap.get("utm_campaign"));
        hit.put("campaignSource", paramsMap.get("utm_source"));
        hit.put("campaignKeyword", paramsMap.get("utm_term"));
        hit.put("campaignId", paramsMap.get("utm_id"));
        hit.put("gclid", paramsMap.get("gclid"));
        hit.put("dclid", paramsMap.get("dclid"));
        hit.put("gmob_t", paramsMap.get("gmob_t"));
    }

    @Override
    public void dispatch() {
        this.queueToThread(new Runnable(){

            @Override
            public void run() {
                GAThread.this.proxy.dispatch();
            }
        });
    }

    @Override
    public void setAppOptOut(final boolean appOptOut) {
        this.queueToThread(new Runnable(){

            @Override
            public void run() {
                if (GAThread.this.appOptOut == appOptOut) {
                    return;
                }
                if (appOptOut) {
                    File f = GAThread.this.ctx.getFileStreamPath("gaOptOut");
                    try {
                        f.createNewFile();
                    }
                    catch (IOException e) {
                        Log.w("Error creating optOut file.");
                    }
                    GAThread.this.proxy.clearHits();
                } else {
                    GAThread.this.ctx.deleteFile("gaOptOut");
                }
                GAThread.this.appOptOut = appOptOut;
            }
        });
    }

    @Override
    public void requestAppOptOut(final Analytics.AppOptOutCallback callback) {
        this.queueToThread(new Runnable(){

            @Override
            public void run() {
                callback.reportAppOptOut(GAThread.this.appOptOut);
            }
        });
    }

    @Override
    public void requestClientId(final AnalyticsThread.ClientIdCallback callback) {
        this.queueToThread(new Runnable(){

            @Override
            public void run() {
                callback.reportClientId(GAThread.this.clientId);
            }
        });
    }

    private void queueToThread(Runnable r) {
        this.queue.add(r);
    }

    private boolean loadAppOptOut() {
        return this.ctx.getFileStreamPath("gaOptOut").exists();
    }

    private boolean storeClientId(String clientId) {
        try {
            FileOutputStream fos = this.ctx.openFileOutput("gaClientId", 0);
            fos.write(clientId.getBytes());
            fos.close();
            return true;
        }
        catch (FileNotFoundException e) {
            Log.e("Error creating clientId file.");
            return false;
        }
        catch (IOException e) {
            Log.e("Error writing to clientId file.");
            return false;
        }
    }

    String generateClientId() {
        long result = (new SecureRandom().nextLong() & Long.MAX_VALUE) % Long.MAX_VALUE + 1L;
        String resultAsString = Long.toHexString(result);
        if (!this.storeClientId(resultAsString)) {
            result = 0L;
        }
        return resultAsString;
    }

    String initializeClientId() {
        String rslt = null;
        try {
            FileInputStream input = this.ctx.openFileInput("gaClientId");
            byte[] bytes = new byte[128];
            int readLen = input.read(bytes, 0, 128);
            if (input.available() > 0) {
                Log.e("clientId file seems corrupted, deleting it.");
                input.close();
                this.ctx.deleteFile("gaInstallData");
            }
            if (readLen <= 0) {
                Log.e("clientId file seems empty, deleting it.");
                input.close();
                this.ctx.deleteFile("gaInstallData");
            } else {
                rslt = new String(bytes, 0, readLen);
                input.close();
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Log.e("Error reading clientId file, deleting it.");
            this.ctx.deleteFile("gaInstallData");
        }
        catch (NumberFormatException e) {
            Log.e("cliendId file doesn't have long value, deleting it.");
            this.ctx.deleteFile("gaInstallData");
        }
        if (rslt == null) {
            rslt = this.generateClientId();
        }
        return rslt;
    }

    static String getAndClearCampaign(Context context) {
        try {
            FileInputStream input = context.openFileInput("gaInstallData");
            byte[] inputBytes = new byte[8192];
            int readLen = input.read(inputBytes, 0, 8192);
            if (input.available() > 0) {
                Log.e("Too much campaign data, ignoring it.");
                input.close();
                context.deleteFile("gaInstallData");
                return null;
            }
            input.close();
            context.deleteFile("gaInstallData");
            if (readLen <= 0) {
                Log.w("Campaign file is empty.");
                return null;
            }
            String campaignString = new String(inputBytes, 0, readLen);
            Log.i("Campaign found: " + campaignString);
            return campaignString;
        }
        catch (FileNotFoundException e) {
            Log.i("No campaign data found.");
            return null;
        }
        catch (IOException e) {
            Log.e("Error reading campaign data.");
            context.deleteFile("gaInstallData");
            return null;
        }
    }

    private String printStackTrace(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        t.printStackTrace(stream);
        stream.flush();
        return new String(baos.toByteArray());
    }

    @Override
    public void run() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Log.w("sleep interrupted in GAThread initialize");
        }
        try {
            this.appOptOut = this.loadAppOptOut();
            this.clientId = this.initializeClientId();
            this.installCampaign = GAThread.getAndClearCampaign(this.ctx);
        }
        catch (Throwable t) {
            Log.e("Error initializing the GAThread: " + this.printStackTrace(t));
            Log.e("Google Analytics will not start up.");
            this.disabled = true;
        }
        while (!this.closed) {
            try {
                try {
                    Runnable r = this.queue.take();
                    if (this.disabled) continue;
                    r.run();
                }
                catch (InterruptedException e) {
                    Log.i(e.toString());
                }
            }
            catch (Throwable t) {
                Log.e("Error on GAThread: " + this.printStackTrace(t));
                Log.e("Google Analytics is shutting down.");
                this.disabled = true;
            }
        }
    }

    @Override
    public LinkedBlockingQueue<Runnable> getQueue() {
        return this.queue;
    }

    @Override
    public Thread getThread() {
        return this;
    }

    void close() {
        this.closed = true;
        this.interrupt();
    }

    boolean isDisabled() {
        return this.disabled;
    }
}

