/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.text.TextUtils;
import com.google.analytics.tracking.android.ExceptionParser;
import com.google.analytics.tracking.android.GAUsage;
import com.google.analytics.tracking.android.Item;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.Tracker;
import com.google.analytics.tracking.android.TrackerHandler;
import com.google.analytics.tracking.android.Transaction;
import com.google.analytics.tracking.android.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GoogleTracker
implements Tracker {
    private static final DecimalFormat DF = new DecimalFormat("0.######", new DecimalFormatSymbols(Locale.US));
    private final TrackerHandler handler;
    private final SimpleModel model;
    private volatile ExceptionParser exceptionParser;
    private volatile boolean trackerClosed = false;
    private volatile boolean trackingStarted = false;

    GoogleTracker(String trackingId, TrackerHandler handler) {
        if (trackingId == null) {
            throw new IllegalArgumentException("trackingId cannot be null");
        }
        this.handler = handler;
        this.model = new SimpleModel();
        this.model.set("trackingId", trackingId);
        this.model.set("sampleRate", "100");
        this.model.setForNextHit("sessionControl", "start");
    }

    private void assertTrackerOpen() {
        if (this.trackerClosed) {
            throw new IllegalStateException("Tracker closed");
        }
    }

    @Override
    public void send(String hitType, Map<String, String> params) {
        this.assertTrackerOpen();
        GAUsage.getInstance().setUsage(GAUsage.Field.SEND);
        this.internalSend(hitType, params);
    }

    private void internalSend(String hitType, Map<String, String> params) {
        this.trackingStarted = true;
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("hitType", hitType);
        this.model.setAll(params, true);
        this.handler.sendHit(this.model.getKeysAndValues());
        this.model.clearTemporaryValues();
    }

    @Override
    public void setStartSession(boolean startSession) {
        this.assertTrackerOpen();
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_START_SESSION);
        this.model.setForNextHit("sessionControl", startSession ? "start" : null);
    }

    @Override
    public void setAppScreen(String appScreen) {
        this.assertTrackerOpen();
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_APP_SCREEN);
        this.model.set("description", appScreen);
    }

    @Override
    public void trackView() {
        this.assertTrackerOpen();
        if (TextUtils.isEmpty((CharSequence)this.model.get("description"))) {
            throw new IllegalStateException("trackView requires a appScreen to be set");
        }
        GAUsage.getInstance().setUsage(GAUsage.Field.TRACK_VIEW);
        this.internalSend("appview", null);
    }

    @Override
    public void trackView(String appScreen) {
        this.assertTrackerOpen();
        if (TextUtils.isEmpty((CharSequence)appScreen)) {
            throw new IllegalStateException("trackView requires a appScreen to be set");
        }
        GAUsage.getInstance().setUsage(GAUsage.Field.TRACK_VIEW_WITH_APPSCREEN);
        this.model.set("description", appScreen);
        this.internalSend("appview", null);
    }

    @Override
    public void trackEvent(String category, String action, String label, Long value) {
        this.assertTrackerOpen();
        GAUsage.getInstance().setUsage(GAUsage.Field.TRACK_EVENT);
        GAUsage.getInstance().setDisableUsage(true);
        this.internalSend("event", this.constructEvent(category, action, label, value));
        GAUsage.getInstance().setDisableUsage(false);
    }

    @Override
    public void trackTransaction(Transaction transaction) {
        this.assertTrackerOpen();
        GAUsage.getInstance().setUsage(GAUsage.Field.TRACK_TRANSACTION);
        GAUsage.getInstance().setDisableUsage(true);
        this.internalSend("tran", this.constructTransaction(transaction));
        for (Item item : transaction.getItems()) {
            this.internalSend("item", this.constructItem(item, transaction));
        }
        GAUsage.getInstance().setDisableUsage(false);
    }

    @Override
    public void trackException(String description, boolean fatal) {
        this.assertTrackerOpen();
        GAUsage.getInstance().setUsage(GAUsage.Field.TRACK_EXCEPTION_WITH_DESCRIPTION);
        GAUsage.getInstance().setDisableUsage(true);
        this.internalSend("exception", this.constructException(description, fatal));
        GAUsage.getInstance().setDisableUsage(false);
    }

    @Override
    public void trackException(String threadName, Throwable exception, boolean fatal) {
        String description;
        this.assertTrackerOpen();
        GAUsage.getInstance().setUsage(GAUsage.Field.TRACK_EXCEPTION_WITH_THROWABLE);
        if (this.exceptionParser != null) {
            description = this.exceptionParser.getDescription(threadName, exception);
        } else {
            try {
                GAUsage.getInstance().setDisableUsage(true);
                this.internalSend("exception", this.constructRawException(threadName, exception, fatal));
                GAUsage.getInstance().setDisableUsage(false);
                return;
            }
            catch (IOException e) {
                Log.w("trackException: couldn't serialize, sending \"Unknown Exception\"");
                description = "Unknown Exception";
            }
        }
        GAUsage.getInstance().setDisableUsage(true);
        this.trackException(description, fatal);
        GAUsage.getInstance().setDisableUsage(false);
    }

    @Override
    public void trackTiming(String category, long intervalInMilliseconds, String name, String label) {
        this.assertTrackerOpen();
        GAUsage.getInstance().setUsage(GAUsage.Field.TRACK_TIMING);
        GAUsage.getInstance().setDisableUsage(true);
        this.internalSend("timing", this.constructTiming(category, intervalInMilliseconds, name, label));
        GAUsage.getInstance().setDisableUsage(false);
    }

    @Override
    public void trackSocial(String network, String action, String target) {
        this.assertTrackerOpen();
        GAUsage.getInstance().setUsage(GAUsage.Field.TRACK_SOCIAL);
        GAUsage.getInstance().setDisableUsage(true);
        this.internalSend("social", this.constructSocial(network, action, target));
        GAUsage.getInstance().setDisableUsage(false);
    }

    @Override
    public Map<String, String> constructEvent(String category, String action, String label, Long value) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventCategory", category);
        params.put("eventAction", action);
        params.put("eventLabel", label);
        if (value != null) {
            params.put("eventValue", Long.toString(value));
        }
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_EVENT);
        return params;
    }

    private static String microsToCurrencyString(long currencyInMicros) {
        return DF.format((double)currencyInMicros / 1000000.0);
    }

    @Override
    public Map<String, String> constructTransaction(Transaction trans) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("transactionId", trans.getTransactionId());
        params.put("transactionAffiliation", trans.getAffiliation());
        params.put("transactionShipping", GoogleTracker.microsToCurrencyString(trans.getShippingCostInMicros()));
        params.put("transactionTax", GoogleTracker.microsToCurrencyString(trans.getTotalTaxInMicros()));
        params.put("transactionTotal", GoogleTracker.microsToCurrencyString(trans.getTotalCostInMicros()));
        params.put("currencyCode", trans.getCurrencyCode());
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_TRANSACTION);
        return params;
    }

    Map<String, String> constructItem(Item item, Transaction trans) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("transactionId", trans.getTransactionId());
        params.put("currencyCode", trans.getCurrencyCode());
        params.put("itemCode", item.getProductSKU());
        params.put("itemName", item.getProductName());
        params.put("itemCategory", item.getProductCategory());
        params.put("itemPrice", GoogleTracker.microsToCurrencyString(item.getItemPriceInMicros()));
        params.put("itemQuantity", Long.toString(item.getItemQuantity()));
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_ITEM);
        return params;
    }

    @Override
    public Map<String, String> constructException(String exceptionDescription, boolean fatal) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("exDescription", exceptionDescription);
        params.put("exFatal", Boolean.toString(fatal));
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_EXCEPTION);
        return params;
    }

    @Override
    public Map<String, String> constructRawException(String threadName, Throwable exception, boolean fatal) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(byteStream);
        stream.writeObject(exception);
        stream.close();
        params.put("rawException", Utils.hexEncode(byteStream.toByteArray()));
        if (threadName != null) {
            params.put("exceptionThreadName", threadName);
        }
        params.put("exFatal", Boolean.toString(fatal));
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_RAW_EXCEPTION);
        return params;
    }

    @Override
    public Map<String, String> constructTiming(String category, long intervalInMilliseconds, String name, String label) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("timingCategory", category);
        params.put("timingValue", Long.toString(intervalInMilliseconds));
        params.put("timingVar", name);
        params.put("timingLabel", label);
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_TIMING);
        return params;
    }

    @Override
    public Map<String, String> constructSocial(String network, String action, String target) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("socialNetwork", network);
        params.put("socialAction", action);
        params.put("socialTarget", target);
        GAUsage.getInstance().setUsage(GAUsage.Field.CONSTRUCT_SOCIAL);
        return params;
    }

    @Override
    public void close() {
        this.trackerClosed = true;
        this.handler.closeTracker(this);
    }

    @Override
    public String getTrackingId() {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_TRACKING_ID);
        return this.model.get("trackingId");
    }

    @Override
    public void setAnonymizeIp(boolean anonymizeIp) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_ANONYMIZE_IP);
        this.model.set("anonymizeIp", Boolean.toString(anonymizeIp));
    }

    @Override
    public void setSampleRate(double sampleRate) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_SAMPLE_RATE);
        this.model.set("sampleRate", Double.toString(sampleRate));
    }

    @Override
    public boolean anonymizeIpEnabled() {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_ANONYMIZE_IP);
        return Utils.safeParseBoolean(this.model.get("anonymizeIp"));
    }

    @Override
    public double getSampleRate() {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_SAMPLE_RATE);
        return Utils.safeParseDouble(this.model.get("sampleRate"));
    }

    @Override
    public void setReferrer(String referrer) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_REFERRER);
        this.model.setForNextHit("referrer", referrer);
    }

    @Override
    public void setCampaign(String campaign) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_CAMPAIGN);
        this.model.setForNextHit("campaign", campaign);
    }

    @Override
    public String get(String key) {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET);
        return this.model.get(key);
    }

    @Override
    public void set(String key, String value) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET);
        this.model.set(key, value);
    }

    @Override
    public void setAppName(String appName) {
        if (this.trackingStarted) {
            Log.wDebug("Tracking already started, setAppName call ignored");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)appName)) {
            Log.wDebug("setting appName to empty value not allowed, call ignored");
            return;
        }
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_APP_NAME);
        this.model.set("appName", appName);
    }

    @Override
    public void setAppVersion(String appVersion) {
        if (this.trackingStarted) {
            Log.wDebug("Tracking already started, setAppVersion call ignored");
            return;
        }
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_APP_VERSION);
        this.model.set("appVersion", appVersion);
    }

    @Override
    public void setAppId(String appId) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_APP_ID);
        this.model.set("appId", appId);
    }

    @Override
    public String getAppId() {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_APP_ID);
        return this.model.get("appId");
    }

    @Override
    public void setAppInstallerId(String appInstallerId) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_APP_INSTALLER_ID);
        this.model.set("appInstallerId", appInstallerId);
    }

    @Override
    public String getAppInstallerId() {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_APP_INSTALLER_ID);
        return this.model.get("appInstallerId");
    }

    @Override
    public void setExceptionParser(ExceptionParser exceptionParser) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_EXCEPTION_PARSER);
        this.exceptionParser = exceptionParser;
    }

    @Override
    public ExceptionParser getExceptionParser() {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_EXCEPTION_PARSER);
        return this.exceptionParser;
    }

    @Override
    public void setUseSecure(boolean useSecure) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_USE_SECURE);
        this.model.set("useSecure", Boolean.toString(useSecure));
    }

    @Override
    public boolean getUseSecure() {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_USE_SECURE);
        return Boolean.parseBoolean(this.model.get("useSecure"));
    }

    @Override
    public void setCustomDimension(int slot, String value) {
        if (slot < 1) {
            Log.w("slot must be > 0, ignoring setCustomDimension call for " + slot + ", " + value);
            return;
        }
        this.model.setForNextHit(Utils.getSlottedModelField("customDimension", slot), value);
    }

    @Override
    public void setCustomMetric(int slot, Long value) {
        if (slot < 1) {
            Log.w("slot must be > 0, ignoring setCustomMetric call for " + slot + ", " + value);
            return;
        }
        String tmpValue = null;
        if (value != null) {
            tmpValue = Long.toString(value);
        }
        this.model.setForNextHit(Utils.getSlottedModelField("customMetric", slot), tmpValue);
    }

    @Override
    public void setCustomDimensionsAndMetrics(Map<Integer, String> dimensions, Map<Integer, Long> metrics) {
        if (dimensions != null) {
            for (Integer key : dimensions.keySet()) {
                this.setCustomDimension(key, dimensions.get(key));
            }
        }
        if (metrics != null) {
            for (Integer key : metrics.keySet()) {
                this.setCustomMetric(key, metrics.get(key));
            }
        }
    }

    private static class SimpleModel {
        private Map<String, String> temporaryMap = new HashMap<String, String>();
        private Map<String, String> permanentMap = new HashMap<String, String>();

        private SimpleModel() {
        }

        public synchronized void setForNextHit(String key, String value) {
            this.temporaryMap.put(key, value);
        }

        public synchronized void set(String key, String value) {
            this.permanentMap.put(key, value);
        }

        public synchronized void clearTemporaryValues() {
            this.temporaryMap.clear();
        }

        public synchronized String get(String key) {
            String result = this.temporaryMap.get(key);
            if (result != null) {
                return result;
            }
            return this.permanentMap.get(key);
        }

        public synchronized void setAll(Map<String, String> keysAndValues, Boolean isForNextHit) {
            if (isForNextHit.booleanValue()) {
                this.temporaryMap.putAll(keysAndValues);
            } else {
                this.permanentMap.putAll(keysAndValues);
            }
        }

        public synchronized Map<String, String> getKeysAndValues() {
            HashMap<String, String> result = new HashMap<String, String>(this.permanentMap);
            result.putAll(this.temporaryMap);
            return result;
        }
    }
}

