# (c) 2020, James Freeman <james.freeman@example.com>
# (c) 2012, Daniel Hokka Zakrisson <daniel@hozac.com>
# (c) 2017 Ansible Project
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
from __future__ import (absolute_import, division, print_function)
__metaclass__ = type

DOCUMENTATION = """
    lookup: firstchar
    author: James Freeman <james.freeman@example.com>
    version_added: "2.9"
    short_description: odczytuje pierwszy znak zawartości pliku
    description:
        - Ta wtyczka zwraca pierwszy znak zawartości pliku znajdującego się w systemie plików kontrolera Ansible.
    options:
      _terms:
        description: ścieżka dostępu do odczytywanego pliku lub plików
        required: True
    notes:
      - Po umieszczeniu danych w kontekście zmiennej plik może być interpretowany jako YAML, o ile jego zawartość jest poprawna dla analizatora składni.
      - Ta wtyczka nie obsługuje opcji 'globing', zamiast niej należy użyć fileglob.
"""

EXAMPLES = """
- debug: msg="pierwszy znak w pliku foo.txt to {{lookup('firstchar', '/etc/foo.txt') }}"

"""

RETURN = """
  _raw:
    description:
      - pierwszy znak pobrany z zawartości pliku lub plików
"""

from ansible.errors import AnsibleError, AnsibleParserError
from ansible.plugins.lookup import LookupBase
from ansible.utils.display import Display

display = Display()


class LookupModule(LookupBase):

    def run(self, terms, variables=None, **kwargs):

        ret = []
        for term in terms:
            display.debug("Szukane wyrażenie: %s" % term)

            lookupfile = self.find_file_in_search_path(variables, 'files', term)

            display.vvvv(u"Wyszukiwanie z użyciem pliku %s" % lookupfile)
            try:
                if lookupfile:
                    contents, show_data = self._loader._get_file_contents(lookupfile)
                    ret.append(contents.rstrip()[0])
                else:
                    raise AnsibleParserError()
            except AnsibleParserError:
                raise AnsibleError("nie udało się odnaleźć pliku: %s" % term)

        return ret
