# Practical Ansible 2

**Automatyzacja infrastruktury, zarządzanie konfiguracją i wdrażanie aplikacji za pomocą Ansible 2.9**

## Co znajdziesz w książce?
Ansible pozwala na automatyzację wdrażania oprogramowania, zarządzania konfiguracją i wydawaniem aplikacji. Framework Ansible można wykorzystać również jako narzędzie wdrożenia i orkiestracji. Wprawdzie oferuje proste i jednocześnie potężne funkcje przeznaczone do automatyzacji wielowarstwowych środowisk za pomocą komunikacji niewymagającej agenta, ale potrafi sprostać także innym wyzwaniom w IT, takim jak zapewnienie obsługi ciągłej integracji i ciągłego wdrażania (CI/CD) bez żadnego przestoju.

W książce wykorzystano Ansible 2.9 i pokazano sposoby użycia tego frameworka do szybkiego rozwiązywania problemów za pomocą scenariuszy opracowanych pod kątem konkretnych zadań. Na początku zainstalujesz i skonfigurujesz Ansible w systemach Linux i macOS. Dzięki temu będziesz mógł monotonne i powtarzające się zadania IT automatyzować za pomocą koncepcji takich jak scenariusze, ewidencje i moduły sieciowe. Gdy nabędziesz większego doświadczenia w pracy z Ansible, poznasz szczegóły składni YAML i dowiesz się, jak przenosić kod między poszczególnymi wydaniami Ansible. Ponadto zobaczysz, jak Ansible pozwala na orkiestrację wielowarstwowych środowisk, takich jak sieci, kontenery i chmura.

W książce zostały poruszone następujące zagadnienia:
* poznanie podstaw pracy z frameworkiem Ansible
* konfiguracja zależności i zmiennych bazujących na rolach
* unikanie najczęściej popełnianych błędów i pułapek podczas tworzenia w Ansible kodu automatyzacji
* zaangażowanie się w rozwój projektu Ansible przez przekazanie samodzielnie opracowanego kodu
* stosowanie najlepszych praktyk związanych z ewidencjami w środowisku chmury

Jeżeli uważasz, że ta książka jest dla Ciebie, już dzisiaj kup [egzemplarz](https://www.helion.pl) dla siebie!

## Informacje dotyczące kodu źródłowego
Wszystkie przykłady zostały umieszczone w katalogach. Przykładem może być katalog Rozdzial02.

Blok kodu przedstawia się następująco:
```
if (sprawdzane wyrażenie)
{
  Polecenia wykonywane, gdy wartością wyrażenia jest true.
}
```

**Wymagania techniczne**
Jeżeli jesteś inżynierem DevOps, administratorem lub profesjonalistą w branży IT, który szuka możliwości automatyzacji zadań IT za pomocą Ansible, ta książka jest właśnie dla Ciebie. Nie musisz mieć żadnego doświadczenia w pracy z Ansible.

Po spełnieniu wymienionych tutaj wymagań sprzętowych i programowych, będziesz mógł uruchomić wszystkie przykładowe fragmenty kodu, które zostały omówione w książce (rozdziały od 1. do 12.).

### Lista niezbędnego sprzętu i oprogramowania

| Rozdział | Wymagane oprogramowanie                                         | Wymagany system operacyjny       |
| -------- | --------------------------------------------------------------- | -------------------------------- |
| 1-12     | Co najmniej jeden serwer Linux (fizyczny lub maszyna wirtualna) | CentOS 7 lub Ubuntu Server 18.04 |
| 1-12     | Ansible 2.9                                                     | CentOS 7 lub Ubuntu Server 18.04 |
| 1-12     | AWX release 10.0.0 or later                                     | CentOS 7 lub Ubuntu Server 18.04 |


## Autorzy
**Daniel Oh**
Daniel Oh jest menedżerem technicznym w firmie Red Hat. Zajmuje się środowiskami uruchomieniowymi, frameworkami, zagadnieniami związanymi z szybkim dostępem do danych, a także charakteryzującą się wysoką wydajnością wymianą komunikatów w sposób elastyczny, łatwy w użyciu, efektywny pod względem kosztów, otwarty i pozwalający na współpracę z innymi rozwiązaniami. Daniel jest również ambasadorem CNCF i DevOps Institute, zajmuje się promowaniem sposobu projektowania i tworzenia natywnych dla chmury i niewymagających serwera mikrousług oraz wdrażania ich w hybrydowych platformach natywnej chmury na podstawie projektów CNCF. Uwielbia dzielić się ze społecznością DevOps swoim doświadczeniem w zakresie ewolucji tradycyjnych mikrousług do aplikacji natywnej chmury, opartych na zdarzeniach i niewymagających serwera. Wiedzą dzieli się poprzez warsztaty techniczne, sesje, spotkania typu hackathons oraz konferencje organizowane na całym świecie.

**James Freeman**
James Freeman to znakomity konsultant IT z ponad 20-letnim doświadczeniem w branży informatycznej. Ma ponad 5-letnie doświadczenie w rozwiązywaniu rzeczywistych problemów korporacji w środowiskach produkcyjnych używając do tego Ansible. Bardzo często proponuje po raz pierwszy zastosowanie w firmie rozwiązań opartych na Ansible jako nowej technologii. Jest również autorem i prelegentem podczas warsztatów i szkoleń związanych z Ansible. Występował na różnych międzynarodowych konferencjach i spotkaniach dotyczących Ansible.

**Fabio Alessandro Locati**
Fabio Alessandro Locati – powszechnie znany jako Fale – to starszy architekt rozwiązania w firmie Red Hat, prelegent na różnych spotkaniach, autor i twórca oprogramowania typu open source. Zajmuje się przede wszystkim systemem Linux, automatyzacją, zapewnieniem bezpieczeństwa oraz technologiami chmury. Fale ma ponad 15-letnie doświadczenie w pracy w branży IT, z których wiele spędził na świadczeniu usług konsultingowych dla wielu firm, w tym także zaliczanych do listy Fortune 500. Jest autorem książek Learning Ansible 2.7, Learning Ansible 2 i OpenStack Cloud Security, a także zajmował się recenzją techniczną wielu innych książek.
