
package defensive;
import junit.framework.TestCase;


public class UnitTester extends TestCase
{
    public void testType(Unit unit, String type, String expectedOutputType) {
        System.out.println("\nTestowanie zapisu i odczytu w�a�ciwo�ci 'type'.");
        unit.setType(type);
        String outputType = unit.getType();
        if (expectedOutputType.equals(outputType))
        {
            System.out.println("Test zko�czony pomy�lnie");
        }
        else
        {
      		System.out.println("Nie uda�o si� pomy�lnie przej�� testu: warto�ci " + 
           		outputType + " oraz " + expectedOutputType + " nie odpowiadaj� sobie");
        }
    }
    
    public void testUnitSpecificProperty(Unit unit, String propertyName, Object inputValue, Object expectedOutputValue) {
        System.out.println("\nTestowanie zapisu i odczytu w�a�ciwo�ci charakterystycznej dla jednostki.");
        unit.setProperty(propertyName, inputValue);
        Object outputValue = null;
        try
        {
            outputValue = unit.getProperty(propertyName);
        } catch (IllegalAccessException e)
        {
            e.printStackTrace();
        }
        if (expectedOutputValue.equals(outputValue))
        {
            System.out.println("Test zko�czony pomy�lnie");
        }
        else
        {
      		System.out.println("Nie uda�o si� pomy�lnie przej�� testu: warto�ci " + 
           		outputValue + " oraz " + expectedOutputValue + " nie odpowiadaj� sobie");
        }
    }
    
    public void testNonExistentProperty(Unit unit, String propertyName) {
        System.out.println("\nTestowanie odczytu warto�ci nieistniej�cej w�a�ciwo�ci.");
        Object outputValue = null;
        boolean pass = false;
        try
        {
            outputValue = unit.getProperty(propertyName);
        } catch (IllegalAccessException e)
        {
            pass = true;
        }
        if (pass)
        {
            System.out.println("Test zko�czony pomy�lnie");
        }
        else
        {
            System.out.println("Nie uda�o si� pomy�lnie przej�� testu: odczytano warto�� " + outputValue);
        }
    }
    
    public static void main(String args[]) {
        UnitTester tester = new UnitTester();
        Unit unit = new Unit(1000);
        tester.testType(unit, "piechota", "piechota");
        tester.testUnitSpecificProperty(unit, "hitPoints", new Integer(25), new Integer(25));
        tester.testNonExistentProperty(unit, "strength");
    }
}
