import {Component, OnDestroy} from "@angular/core";
import {WebSocketService} from "./websocket.service";
import {Subscription} from "rxjs";

@Component({
  selector: 'app-root',
  providers: [ WebSocketService ],
  template: `<h1>Klient Angulara dla serwera WebSocket</h1>
  {{messageFromServer}}<br>
  <button (click)="sendMessageToServer()">Wyślij komunikat do serwera</button>
  <button (click)="closeSocket()">Rozłącz</button>
  <div>{{status}}</div>
  `})
export class AppComponent implements OnDestroy {

  messageFromServer: string;
  wsSubscription: Subscription;
  status;

  constructor(private wsService: WebSocketService) {

    this.wsSubscription = this.wsService.createObservableSocket("ws://localhost:8085")
      .subscribe(
        data => this.messageFromServer = data,
        err => console.log( 'err'),
        () =>  console.log( 'Strumień obserwowalny jest zakończony')
      );
  }

  sendMessageToServer(){
    this.status = this.wsService.sendMessage("Pozdrowienia od klienta");
  }

  closeSocket(){
    this.wsSubscription.unsubscribe();  // Close the Websocket
    this.status = 'Gniazdo jest zamknięte';
  }

  ngOnDestroy() {
    this.closeSocket();
  }
}
