import {Component} from '@angular/core';
import {Subject} from "rxjs";

@Component({
  selector: "app-root",
  template: `
    <h3>Użycie Subject do emitowania i subsktybowania zdarzeń keyup i input</h3>
    <input type="text" placeholder="Rozpocznik wpisywania"
           (input)="mySubject$.next($event)" (keyup)="myKeySubject$.next($event)">
  `
})
export class AppComponent {

  mySubject$ = new Subject();      // dla dowolnych zdarzeń
  myKeySubject$ = new Subject();   // dla zdarzeń klawiatury

  constructor(){

    this.myKeySubject$.subscribe(({type, key}) => console.log(`Zdarzenie: ${type} przycisk: ${key}`));

    this.mySubject$.subscribe(({type, target}) => console.log(
                   `Zdarzenie: ${type} wartość:  ${(<HTMLInputElement>target).value}`));
  }
}
