interface IPayable{
    increasePay(percent: number): void;
}

class Employee implements IPayable {
    increasePay(percent:number){
      console.log(`Zwiększanie pensji pracownika o ${percent}`);
    }
}

class Contractor implements IPayable {
    increasePay(percent: number) {
        console.log(`Zwiększanie stawki podwykonawcy o ${percent}`);
    }
}

let workers: IPayable[] = [];

workers[0] = new Employee();
workers[1] = new Contractor();

workers.forEach( (worker) => worker.increasePay(20));
