import { CanDeactivate, Router } from "@angular/router";
import { Injectable } from "@angular/core";
import { ProductDetailComponent } from "./product.component";

@Injectable()
export class UnsavedChangesGuard implements CanDeactivate<ProductDetailComponent> {

  canDeactivate(component: ProductDetailComponent) {

    if (component.name.dirty) {
      return window.confirm("Masz niezapisane zmiany. Nadal chcesz opuścić stronę?");
    } else {
      return true;
    }
  }
}
