import {Component} from '@angular/core';
import {
  Router, NavigationStart, NavigationEnd, NavigationError, NavigationCancel} from "@angular/router";

@Component({
  selector: 'app-root',
  template: `
    <a [routerLink]="['/']">Strona główna</a>&nbsp;
    <a [routerLink]="['mydata']">Dane</a>
    <router-outlet></router-outlet>
    <div *ngIf="isNavigating">
      Ładuję...
      <mat-progress-bar mode="indeterminate"></mat-progress-bar>
    </div>
  `
})
export class AppComponent {

  isNavigating = false;

  constructor (private router: Router){
    this.router.events.subscribe(
      (event) => {
        if (event instanceof NavigationStart){
          this.isNavigating=true;
          console.log("Nawigacja rozpoczęta");
        }

        if (event instanceof NavigationEnd) {
          // || event instanceof NavigationError || event instanceof NavigationCancel){
          this.isNavigating=false;
          console.log("Nawigacja zakończona");
        }
      }
    );
  }
}
