import { Component, Directive, ElementRef } from '@angular/core';
import { NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';

// Component
@Component({
  selector: 'hello-world',
  template: `
    <label for="speed">Wybierz prędkość</label>
    <select name="speed" id="speed">
      <option>Wolniej</option>
      <option>Wolno</option>
      <option selected="selected">Średnio</option>
      <option>Szybko</option>
      <option>Szybciej</option>
    </select>
  `
})
class HelloWorldComponent {
  name: string;

  constructor() {
    this.name = 'Angular';
  }
}

@Directive({
  selector: 'select'
})
class SelectMenuDirective {

  constructor(private hostElement: ElementRef) {}

  ngOnInit() {
    $(this.hostElement.nativeElement).selectmenu({});  // invoking a jQueri-UI function
  }
}

// Module
@NgModule({
  imports:      [ BrowserModule ],
  declarations: [ HelloWorldComponent, SelectMenuDirective ],
  bootstrap:    [ HelloWorldComponent ]
})
export class AppModule { }

// App bootstrap
platformBrowserDynamic().bootstrapModule(AppModule);
