import * as express from "express";
import * as path from "path";
import * as bodyParser from "body-parser";
import { AddressInfo } from "net";

const app = express();

app.use('/', express.static(path.join(__dirname, 'public')));
app.use(bodyParser.json());

app.post("/api/product", (req, res) => {

    console.log(`Otrzymano nowy produkt ${req.body.title} ${req.body.price}`);

    res.json({'message':`Serwer odpowiedział: dodano ${req.body.title}`});
});

const server = app.listen(8000, "localhost", () => {
    const {address, port} = server.address() as AddressInfo;
    console.log(`Nasłuchiwanie na adresie ${address}: ${port}`);
});
