import { Component } from '@angular/core';
import {FormGroup, FormControl} from "@angular/forms";

@Component({
  selector: 'app-root',
  template: `
    <form [formGroup]="myFormModel" (ngSubmit)="onSubmit()">
      <div>Nazwa użytkownika: <input type="text" formControlName="username"></div>
      <div>Numer ubezpieczenia:      <input type="text" formControlName="ssn"></div>

      <div formGroupName="passwordsGroup">
        <div>Hasło:        <input type="password" formControlName="password"></div>
        <div>Potwierdź hasło: <input type="password" formControlName="pconfirm"></div>
      </div>
      <button type="submit">Wyślij</button>
    </form>
  `
})
export class AppComponent {
  myFormModel: FormGroup;

  constructor() {
    this.myFormModel = new FormGroup({
      username: new FormControl(''),
      ssn: new FormControl(''),
      passwordsGroup: new FormGroup({
        password: new FormControl(''),
        pconfirm: new FormControl('')
      })
    });
  }

  onSubmit() {


    console.log(this.myFormModel.value);
  }
}
