let {Observable} = require('rxjs/Observable');
require('rxjs/add/observable/from');
require('rxjs/add/operator/map');
require('rxjs/add/operator/reduce');

let beers = [
    {name: "Stella", country: "Belgia", price: 9.50},
    {name: "Sam Adams", country: "Stany Zjednoczone", price: 8.50},
    {name: "Bud Light", country: "Stany Zjednoczone", price: 6.50}
];

Observable.from(beers)
    .map(beer => beer.price)
    .reduce((total,price) => total+price,0)
    .subscribe(
        totalPrice => console.log(`Cena całkowita: ${totalPrice}`),
        err => console.error(err)
    );
