// Konfiguracja Karma
// http://karma-runner.github.io/0.12/config/configuration-file.html
// Generated on 2014-12-15 using
// generator-karma 0.8.3

module.exports = function(config) {
  'use strict';

  config.set({
    // włącza / wyłącza obserwację plików i wykonywanie testów w odpowiedzi na zmiany w plikach
    autoWatch: true,

    // ścieżka bazowa, która będzie użyta do rozwiązywania i wyłaczania plików
    basePath: '',

    // używany framework testowania (jasmine/mocha/qunit/...)
    frameworks: ['jasmine'],

    // lista plików / wzorców do załadowania w przeglądarce
    files: [
        'bower_components/angular/angular.js',
        'bower_components/angular-animate/angular-animate.js',
        'bower_components/angular-aria/angular-aria.js',
        'bower_components/angular-cookies/angular-cookies.js',
        'bower_components/angular-messages/angular-messages.js',
        'bower_components/angular-resource/angular-resource.js',
        'bower_components/angular-route/angular-route.js',
        'bower_components/angular-sanitize/angular-sanitize.js',
        'bower_components/angular-touch/angular-touch.js',
        'bower_components/angular-mocks/angular-mocks.js',
        'app/scripts/**/*.js',
        'test/spec/**/*.js'
    ],

    // list of files / patterns to exclude
    exclude: [],

    // port serwera WWW
    port: 8080,

    // Uruchomienie tych przeglądarek. Obecnie dostępne:
    // - Chrome
    // - ChromeCanary
    // - Firefox
    // - Opera
    // - Safari (only Mac)
    // - PhantomJS
    // - IE (only Windows)
    browsers: [
      'PhantomJS'
    ],

    // Które pluginy włączyć
    plugins: [
      'karma-phantomjs-launcher',
      'karma-jasmine'
    ],

    // Tryb ciągłej integracji
    // jeśli ma wartość true, przechwytuje przeglądarki, uruchamia testy i kończy działanie
    singleRun: false,

    colors: true,

    // poziom rejestrowania
    // możliwe wartości: LOG_DISABLE || LOG_ERROR || LOG_WARN || LOG_INFO || LOG_DEBUG
    logLevel: config.LOG_INFO,

    // Anuluj komentarz w poniższych wierszach, jeśli używasz serwera grunt do uruchamiania testów
    // proxies: {
    //   '/': 'http://localhost:9000/'
    // },
    // adres URL korzenia w celu wyeliminowania konfliktów z korzeniem witryny
    // urlRoot: '_karma_'
  });
};
